/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;

public class Draw
extends MeshCollection {
    DrawMesh[] dmeshes = new DrawMesh[4];
    private DrawMesh thisMesh;
    private P3[] ptList;
    private V3 offset = new V3();
    private int nPoints;
    private int diameter;
    private float width;
    private float newScale;
    private float length;
    private boolean isCurve;
    private boolean isArc;
    private boolean isArrow;
    private boolean isLine;
    private boolean isVector;
    private boolean isCircle;
    private boolean isPerpendicular;
    private boolean isCylinder;
    private boolean isVertices;
    private boolean isPlane;
    private boolean isReversed;
    private boolean isRotated45;
    private boolean isCrossed;
    private boolean isValid;
    private boolean noHead;
    private boolean isBarb;
    private int indicatedModelIndex = -1;
    private int[] modelInfo;
    private boolean makePoints;
    private P4 plane;
    private BS bsAllModels;
    private Lst<Object> polygon;
    private Lst<Object[]> vData;
    private String intersectID;
    private P3[] boundBox;
    private Lst<P3[]> lineData;
    private static final int PT_COORD = 1;
    private static final int PT_IDENTIFIER = 2;
    private static final int PT_BITSET = 3;
    private static final int PT_MODEL_INDEX = 4;
    private static final int PT_MODEL_BASED_POINTS = 5;
    MeshSurface slabData;
    private final V3 vAB = new V3();
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();

    public Draw() {
        this.htObjects = new Hashtable();
    }

    public void allocMesh(String thisID, Mesh m) {
        int index = this.meshCount++;
        this.dmeshes = (DrawMesh[])AU.ensureLength((Object)this.dmeshes, (int)(this.meshCount * 2));
        this.meshes = this.dmeshes;
        this.dmeshes[index] = m == null ? new DrawMesh(this.vwr, thisID, this.colix, index) : (DrawMesh)m;
        this.thisMesh = this.dmeshes[index];
        this.currentMesh = this.dmeshes[index];
        this.currentMesh.color = this.color;
        this.currentMesh.index = index;
        if (thisID != null && thisID != "+PREVIOUS_MESH+" && this.htObjects != null) {
            this.htObjects.put(thisID.toUpperCase(), this.currentMesh);
        }
    }

    private void setPropertySuper(String propertyName, Object value, BS bs) {
        this.currentMesh = this.thisMesh;
        this.setPropMC(propertyName, value, bs);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    public void initShape() {
        super.initShape();
        this.myType = "draw";
    }

    public void setProperty(String propertyName, Object value, BS bs) {
        if ("init" == propertyName) {
            this.initDraw();
            this.setPropertySuper("init", value, bs);
            return;
        }
        if ("length" == propertyName) {
            this.length = ((Float)value).floatValue();
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            return;
        }
        if ("intersect" == propertyName) {
            if (value instanceof String) {
                this.intersectID = (String)value;
            } else {
                this.boundBox = (P3[])value;
            }
            return;
        }
        if ("slab" == propertyName) {
            int meshIndex = this.getIndexFromName((String)value);
            if (meshIndex < 0) {
                return;
            }
            Mesh m = this.meshes[meshIndex];
            if (m.checkByteCount != 1) {
                return;
            }
            MeshSurface ms = new MeshSurface();
            ms.vs = m.vs;
            ms.vvs = new float[m.vc];
            ms.vc = m.vc;
            ms.pis = m.pis;
            ms.pc = m.pc;
            ms.dataOnly = true;
            this.slabData = ms;
        }
        if ("lineData" == propertyName) {
            this.lineData = new Lst();
            if (this.indicatedModelIndex < 0) {
                this.indicatedModelIndex = this.vwr.am.cmi;
            }
            float[] fdata = (float[])value;
            int n = fdata.length / 6;
            int pt = 0;
            for (int i = 0; i < n; ++i) {
                this.lineData.addLast((Object)new P3[]{P3.new3((float)fdata[pt++], (float)fdata[pt++], (float)fdata[pt++]), P3.new3((float)fdata[pt++], (float)fdata[pt++], (float)fdata[pt++])});
            }
            return;
        }
        if ("modelIndex" == propertyName) {
            this.indicatedModelIndex = (Integer)value;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex >= this.vwr.ms.mc) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = 4;
            this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            objectArray[1] = this.modelInfo;
            this.vData.addLast((Object)objectArray);
            return;
        }
        if ("planedef" == propertyName) {
            this.plane = (P4)value;
            if (this.intersectID != null || this.boundBox != null || this.slabData != null) {
                return;
            }
            if (this.isCircle || this.isArc) {
                this.isPlane = true;
            }
            this.vData.addLast((Object)new Object[]{1, P3.new3((float)Float.NaN, (float)Float.NaN, (float)Float.NaN)});
            return;
        }
        if ("perp" == propertyName) {
            this.isPerpendicular = true;
            return;
        }
        if ("cylinder" == propertyName) {
            this.isCylinder = true;
            return;
        }
        if ("plane" == propertyName) {
            this.isPlane = true;
            return;
        }
        if ("curve" == propertyName) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == propertyName) {
            this.isArrow = true;
            return;
        }
        if ("line" == propertyName) {
            this.isLine = true;
            this.isCurve = true;
            return;
        }
        if ("arc" == propertyName) {
            this.isCurve = true;
            this.isArc = true;
            if (this.isArrow) {
                this.isArrow = false;
                this.isVector = true;
            }
            return;
        }
        if ("circle" == propertyName) {
            this.isCircle = true;
            return;
        }
        if ("vector" == propertyName) {
            this.isArrow = true;
            this.isVector = true;
            return;
        }
        if ("vertices" == propertyName) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == propertyName) {
            this.isReversed = true;
            return;
        }
        if ("nohead" == propertyName) {
            this.noHead = true;
            return;
        }
        if ("isbarb" == propertyName) {
            this.isBarb = true;
            return;
        }
        if ("rotate45" == propertyName) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == propertyName) {
            this.isCrossed = true;
            return;
        }
        if ("points" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
            }
            return;
        }
        if ("diameter" == propertyName) {
            this.diameter = ((Float)value).intValue();
            return;
        }
        if ("width" == propertyName) {
            this.width = ((Float)value).floatValue();
            return;
        }
        if ("identifier" == propertyName) {
            String thisID = (String)value;
            int meshIndex = this.getIndexFromName(thisID);
            if (meshIndex >= 0) {
                this.vData.addLast((Object)new Object[]{2, new int[]{meshIndex, this.isReversed ? 1 : 0, this.isVertices ? 1 : 0}});
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error((String)("draw identifier " + value + " not found"));
                this.isValid = false;
            }
            return;
        }
        if ("polygon" == propertyName) {
            this.polygon = (Lst)value;
            if (this.polygon == null) {
                this.polygon = new Lst();
            }
            return;
        }
        if ("coord" == propertyName) {
            this.vData.addLast((Object)new Object[]{1, value});
            if (this.indicatedModelIndex >= 0) {
                this.modelInfo[1] = this.modelInfo[1] + 1;
            }
            return;
        }
        if ("offset" == propertyName) {
            this.offset = V3.newV((T3)((P3)value));
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == propertyName) {
            BS bsAtoms = (BS)value;
            if (bsAtoms.isEmpty()) {
                return;
            }
            this.vData.addLast((Object)new Object[]{3, bsAtoms});
            if (this.isCircle && this.diameter == 0 && this.width == 0.0f) {
                this.width = this.vwr.ms.calcRotationRadiusBs(bsAtoms) * 2.0f;
            }
            return;
        }
        if ("coords" == propertyName) {
            this.addPoints(1, value);
            return;
        }
        if ("modelBasedPoints" == propertyName) {
            this.addPoints(5, value);
            return;
        }
        if ("set" == propertyName) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
                this.thisMesh.colix = this.colix;
                this.thisMesh.color = this.color;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing((int[])value) : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vc > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
                Draw.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.visible = true;
            }
            this.nPoints = -1;
            this.vData = null;
            this.lineData = null;
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.deleteModels(((int[])((Object[])value)[2])[0]);
            return;
        }
        this.setPropertySuper(propertyName, value, bs);
    }

    private void addPoints(int type, Object value) {
        boolean isModelPoints;
        Lst pts = (Lst)value;
        Integer key = type;
        boolean bl = isModelPoints = type == 5;
        if (isModelPoints) {
            this.vData.addLast((Object)new Object[]{key, pts});
        }
        int n = pts.size();
        block4: for (int i = 0; i < n; ++i) {
            P3 pt;
            SV v = (SV)pts.get(i);
            switch (v.tok) {
                case 10: {
                    if (!isModelPoints && ((BS)v.value).isEmpty()) continue block4;
                    pt = this.vwr.ms.getAtomSetCenter((BS)v.value);
                    break;
                }
                case 8: {
                    if (isModelPoints) continue block4;
                }
                default: {
                    pt = SV.ptValue((SV)v);
                }
            }
            if (isModelPoints) {
                pts.set(i, (Object)SV.getVariable((Object)pt));
                continue;
            }
            this.vData.addLast((Object)new Object[]{key, pt});
        }
    }

    private void deleteModels(int modelIndex) {
        int i = this.meshCount;
        while (--i >= 0) {
            boolean deleteMesh;
            DrawMesh m = this.dmeshes[i];
            if (m == null) continue;
            boolean bl = deleteMesh = m.modelIndex == modelIndex;
            if (m.modelFlags != null) {
                m.deleteAtoms(modelIndex);
                deleteMesh = m.modelFlags.length() == 0;
                if (!deleteMesh) continue;
            }
            if (deleteMesh) {
                --this.meshCount;
                this.deleteMeshElement(i);
                continue;
            }
            if (this.meshes[i].modelIndex <= modelIndex) continue;
            --this.meshes[i].modelIndex;
        }
        this.resetObjects();
    }

    private void deleteMeshElement(int i) {
        if (this.meshes[i] == this.currentMesh) {
            this.thisMesh = null;
            this.currentMesh = null;
        }
        this.dmeshes = (DrawMesh[])AU.deleteElements((Object)this.meshes, (int)i, (int)1);
        this.meshes = this.dmeshes;
    }

    private void initDraw() {
        this.boundBox = null;
        this.bsAllModels = null;
        this.colix = (short)5;
        this.color = -1;
        this.diameter = 0;
        this.explicitID = false;
        this.indicatedModelIndex = -1;
        this.intersectID = null;
        this.isLine = false;
        this.isCylinder = false;
        this.isCircle = false;
        this.isPlane = false;
        this.isArrow = false;
        this.isArc = false;
        this.isCurve = false;
        this.isBarb = false;
        this.noHead = false;
        this.isCrossed = false;
        this.isRotated45 = false;
        this.isReversed = false;
        this.isFixed = false;
        this.isVector = false;
        this.isVertices = false;
        this.isPerpendicular = false;
        this.isValid = true;
        this.length = Float.MAX_VALUE;
        this.lineData = null;
        this.newScale = 0.0f;
        this.offset = null;
        this.plane = null;
        this.polygon = null;
        this.slabData = null;
        this.vData = new Lst();
        this.width = 0.0f;
        this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
    }

    public boolean getPropertyData(String property, Object[] data) {
        String id;
        if (property == "keys") {
            Lst keys = data[1] instanceof Lst ? (Lst)data[1] : new Lst();
            data[1] = keys;
            keys.addLast((Object)"getSpinAxis");
        }
        if (property == "getCenter") {
            id = (String)data[0];
            int index = (Integer)data[1];
            int modelIndex = (Integer)data[2];
            data[2] = this.getSpinCenter(id, index, modelIndex);
            return data[2] != null;
        }
        if (property == "getSpinAxis") {
            id = (String)data[0];
            int index = (Integer)data[1];
            data[2] = this.getSpinAxis(id, index);
            return data[2] != null;
        }
        return this.getPropDataMC(property, data);
    }

    public Object getProperty(String property, int index) {
        DrawMesh m = this.thisMesh;
        if (index >= 0 && (index >= this.meshCount || (m = (DrawMesh)this.meshes[index]) == null)) {
            return null;
        }
        if (property == "command") {
            return this.getCommand(m);
        }
        if (property == "type") {
            return m == null ? EnumDrawType.NONE.id : m.drawType.id;
        }
        return this.getPropMC(property, index);
    }

    private T3 getSpinCenter(String axisID, int vertexIndex, int modelIndex) {
        DrawMesh m;
        String id;
        int pt = axisID.indexOf("[");
        if (pt > 0) {
            id = axisID.substring(0, pt);
            int pt2 = axisID.lastIndexOf("]");
            if (pt2 < pt) {
                pt2 = axisID.length();
            }
            try {
                vertexIndex = Integer.parseInt(axisID.substring(pt + 1, pt2));
            }
            catch (Exception exception) {}
        } else {
            id = axisID;
        }
        if ((m = (DrawMesh)this.getMesh(id)) == null || m.vs == null) {
            return null;
        }
        if (vertexIndex == Integer.MAX_VALUE) {
            return P3.new3((float)(m.index + 1), (float)this.meshCount, (float)m.vc);
        }
        if (vertexIndex != Integer.MIN_VALUE) {
            vertexIndex = m.getVertexIndexFromNumber(vertexIndex);
        }
        return vertexIndex >= 0 ? m.vs[vertexIndex] : (m.ptCenters == null || modelIndex < 0 || modelIndex >= m.ptCenters.length ? m.ptCenter : m.ptCenters[modelIndex]);
    }

    private V3 getSpinAxis(String axisID, int modelIndex) {
        DrawMesh m = (DrawMesh)this.getMesh(axisID);
        return m == null || m.vs == null ? null : (m.ptCenters == null || modelIndex < 0 ? m.axis : m.axes[modelIndex]);
    }

    private boolean setDrawing(int[] connections) {
        if (this.thisMesh == null) {
            this.allocMesh(null, null);
        }
        this.thisMesh.clear("draw");
        this.thisMesh.diameter = this.diameter;
        this.thisMesh.width = this.width;
        if (this.intersectID != null || this.boundBox != null) {
            if (this.boundBox != null) {
                if (this.plane == null) {
                    // empty if block
                }
            } else if (this.plane != null && this.intersectID != null) {
                Lst vData = new Lst();
                Object[] data = new Object[]{this.intersectID, this.plane, vData, null};
                this.vwr.shm.getShapePropertyData(24, "intersectPlane", data);
                if (vData.size() > 0) {
                    this.indicatedModelIndex = (Integer)data[3];
                    this.lineData = vData;
                }
            }
        } else if (this.slabData != null && this.plane != null) {
            this.slabData.getMeshSlicer().getIntersection(0.0f, this.plane, null, null, null, null, null, false, true, 134217750, false);
            this.polygon = new Lst();
            this.polygon.addLast((Object)this.slabData.vs);
            this.polygon.addLast((Object)this.slabData.pis);
        }
        if (this.polygon == null && (this.lineData == null ? this.vData.size() == 0 == (connections == null) : this.lineData.size() == 0) || !this.isArrow && connections != null) {
            return false;
        }
        int modelCount = this.vwr.ms.mc;
        if (this.polygon != null || this.lineData != null || this.indicatedModelIndex < 0 && (this.isFixed || this.isArrow || this.isCurve || this.isCircle || this.isCylinder || modelCount == 1)) {
            this.thisMesh.modelIndex = this.lineData == null ? this.vwr.am.cmi : this.indicatedModelIndex;
            boolean bl = this.thisMesh.isFixed = this.isFixed || this.lineData == null && this.thisMesh.modelIndex < 0 && modelCount > 1;
            if (this.isFixed && modelCount > 1) {
                this.thisMesh.modelIndex = -1;
            } else if (this.lineData == null && this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            this.thisMesh.connectedAtoms = connections;
            if (this.polygon != null) {
                if (this.polygon.size() == 0) {
                    return false;
                }
                this.thisMesh.isTriangleSet = true;
                this.thisMesh.vs = (P3[])this.polygon.get(0);
                this.thisMesh.pis = (int[][])this.polygon.get(1);
                this.thisMesh.drawVertexCount = this.thisMesh.vc = this.thisMesh.vs.length;
                this.thisMesh.pc = this.thisMesh.pis == null ? -1 : this.thisMesh.pis.length;
                for (int i = 0; i < this.thisMesh.pc; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (this.thisMesh.pis[i][j] < this.thisMesh.vc) continue;
                        return false;
                    }
                }
                this.thisMesh.drawType = EnumDrawType.POLYGON;
                this.thisMesh.checkByteCount = 1;
            } else if (this.lineData != null) {
                this.thisMesh.lineData = this.lineData;
            } else {
                this.thisMesh.setPolygonCount(1);
                if (this.setPoints(-1, -1)) {
                    this.setPoints(-1, this.nPoints);
                }
                this.setPolygon(0);
            }
        } else {
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(modelCount);
            this.thisMesh.ptCenters = new P3[modelCount];
            this.thisMesh.modelFlags = new BS();
            this.thisMesh.drawTypes = new EnumDrawType[modelCount];
            this.thisMesh.drawVertexCounts = new int[modelCount];
            this.thisMesh.vc = 0;
            if (this.indicatedModelIndex >= 0) {
                this.setPoints(-1, 0);
                this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                this.thisMesh.drawVertexCount = -1;
                this.thisMesh.modelFlags.set(this.indicatedModelIndex);
                this.indicatedModelIndex = -1;
            } else {
                BS bsModels = this.vwr.getVisibleFramesBitSet();
                for (int iModel = 0; iModel < modelCount; ++iModel) {
                    if (bsModels.get(iModel) && this.setPoints(iModel, -1)) {
                        this.setPoints(iModel, this.nPoints);
                        this.setPolygon(iModel);
                        this.thisMesh.setCenter(iModel);
                        this.thisMesh.drawTypes[iModel] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[iModel] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                        this.thisMesh.drawVertexCount = -1;
                        this.thisMesh.modelFlags.set(iModel);
                        continue;
                    }
                    this.thisMesh.drawTypes[iModel] = EnumDrawType.NONE;
                    this.thisMesh.pis[iModel] = new int[0];
                }
            }
        }
        this.thisMesh.isVector = this.isVector;
        this.thisMesh.noHead = this.noHead;
        this.thisMesh.isBarb = this.isBarb;
        this.thisMesh.width = this.thisMesh.drawType == EnumDrawType.CYLINDER || this.thisMesh.drawType == EnumDrawType.CIRCULARPLANE ? -Math.abs(this.width) : this.width;
        this.thisMesh.setCenter(-1);
        if (this.offset != null) {
            this.thisMesh.offset(this.offset);
        }
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = this.thisMesh.drawType.name + ++this.nUnnamed;
            this.htObjects.put(this.thisMesh.thisID, this.thisMesh);
        }
        this.clean();
        return true;
    }

    protected void clean() {
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i] != null && (this.meshes[i].vc != 0 || this.meshes[i].connectedAtoms != null || this.meshes[i].lineData != null)) continue;
            this.deleteMeshI(i);
        }
    }

    private void addPoint(T3 newPt, int iModel) {
        if (this.makePoints) {
            if (newPt == null || iModel >= 0 && !this.bsAllModels.get(iModel)) {
                return;
            }
            this.ptList[this.nPoints] = P3.newP((T3)newPt);
            if (newPt.z == Float.MAX_VALUE || newPt.z == -3.4028235E38f) {
                this.thisMesh.haveXyPoints = true;
            }
        } else if (iModel >= 0) {
            this.bsAllModels.set(iModel);
        }
        ++this.nPoints;
    }

    private boolean setPoints(int iModel, int n) {
        boolean bl = this.makePoints = n >= 0;
        if (this.makePoints) {
            this.ptList = new P3[Math.max(5, n)];
            if (this.bsAllModels == null) {
                this.bsAllModels = this.vwr.getVisibleFramesBitSet();
            }
        }
        this.nPoints = 0;
        int nData = this.vData.size();
        int modelIndex = 0;
        BS bsModel = iModel < 0 ? null : this.vwr.getModelUndeletedAtomsBitSet(iModel);
        block7: for (int i = 0; i < nData; ++i) {
            Object[] info = (Object[])this.vData.get(i);
            switch ((Integer)info[0]) {
                case 4: {
                    int j;
                    int[] modelInfo = (int[])info[1];
                    modelIndex = modelInfo[0];
                    this.nPoints = modelInfo[1];
                    int nVertices = Math.max(this.nPoints, 3);
                    int n0 = this.thisMesh.vc;
                    if (this.nPoints <= 0) continue block7;
                    this.thisMesh.pis[modelIndex] = new int[nVertices];
                    int[] p = this.thisMesh.pis[modelIndex];
                    for (j = 0; j < this.nPoints; ++j) {
                        info = (Object[])this.vData.get(++i);
                        p[j] = this.thisMesh.addV((T3)((P3)info[1]), false);
                    }
                    for (j = this.nPoints; j < 3; ++j) {
                        p[j] = n0 + this.nPoints - 1;
                    }
                    this.thisMesh.drawTypes[modelIndex] = EnumDrawType.getType(this.nPoints);
                    this.thisMesh.drawVertexCounts[modelIndex] = this.nPoints;
                    this.thisMesh.modelFlags.set(modelIndex);
                    continue block7;
                }
                case 1: {
                    this.addPoint((T3)((P3)info[1]), this.makePoints ? iModel : -1);
                    continue block7;
                }
                case 3: {
                    BS bs = BSUtil.copy((BS)((BS)info[1]));
                    if (bsModel != null) {
                        bs.and(bsModel);
                    }
                    if (bs.length() <= 0) continue block7;
                    this.addPoint((T3)this.vwr.ms.getAtomSetCenter(bs), this.makePoints ? iModel : -1);
                    continue block7;
                }
                case 2: {
                    boolean isVertices;
                    int[] idInfo = (int[])info[1];
                    DrawMesh m = this.dmeshes[idInfo[0]];
                    boolean isReversed = idInfo[1] == 1;
                    boolean bl2 = isVertices = idInfo[2] == 1;
                    if (m.modelIndex > 0 && m.modelIndex != iModel) {
                        return false;
                    }
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    if (this.isPlane && !this.isCircle || this.isPerpendicular || isVertices) {
                        if (isReversed) {
                            if (iModel < 0 || iModel >= m.pc) {
                                int ipt = m.drawVertexCount;
                                while (--ipt >= 0) {
                                    this.addPoint(m.vs[ipt], iModel);
                                }
                                continue block7;
                            }
                            if (m.pis[iModel] == null) continue block7;
                            int ipt = m.drawVertexCounts[iModel];
                            while (--ipt >= 0) {
                                this.addPoint(m.vs[m.pis[iModel][ipt]], iModel);
                            }
                            continue block7;
                        }
                        if (iModel < 0 || iModel >= m.pc) {
                            for (int ipt = 0; ipt < m.drawVertexCount; ++ipt) {
                                this.addPoint(m.vs[ipt], iModel);
                            }
                            continue block7;
                        }
                        if (m.pis[iModel] == null) continue block7;
                        for (int ipt = 0; ipt < m.drawVertexCounts[iModel]; ++ipt) {
                            this.addPoint(m.vs[m.pis[iModel][ipt]], iModel);
                        }
                        continue block7;
                    }
                    if (iModel < 0 || m.ptCenters == null || m.ptCenters[iModel] == null) {
                        this.addPoint((T3)m.ptCenter, iModel);
                        continue block7;
                    }
                    this.addPoint((T3)m.ptCenters[iModel], iModel);
                    continue block7;
                }
                case 5: {
                    BS bs;
                    Lst modelBasedPoints = (Lst)info[1];
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    for (int j = 0; j < modelBasedPoints.size(); ++j) {
                        if (iModel >= 0 && j != iModel) continue;
                        Object point = modelBasedPoints.get(j);
                        this.bsAllModels.set(j);
                        if (point instanceof P3) {
                            this.addPoint((T3)((P3)point), j);
                            continue;
                        }
                        if (point instanceof BS) {
                            bs = (BS)point;
                            if (bsModel != null) {
                                bs.and(bsModel);
                            }
                            if (bs.length() <= 0) continue;
                            this.addPoint((T3)this.vwr.ms.getAtomSetCenter(bs), j);
                            continue;
                        }
                        if (!(point instanceof SV)) continue;
                        this.addPoint((T3)SV.ptValue((SV)((SV)point)), j);
                    }
                    continue block7;
                }
            }
        }
        if (this.makePoints && this.isCrossed && this.nPoints == 4) {
            P3 pt = this.ptList[1];
            this.ptList[1] = this.ptList[2];
            this.ptList[2] = pt;
        }
        return this.nPoints > 0;
    }

    private void setPolygon(int nPoly) {
        int nVertices = this.nPoints;
        EnumDrawType drawType = EnumDrawType.POINT;
        if (this.isArc) {
            if (nVertices >= 2) {
                drawType = EnumDrawType.ARC;
            } else {
                this.isArc = false;
                this.isVector = false;
                this.isCurve = false;
                this.isArrow = true;
            }
        }
        if (this.isCircle) {
            this.length = 0.0f;
            if (nVertices == 2) {
                this.isPlane = true;
            }
            if (!this.isPlane) {
                drawType = EnumDrawType.CIRCLE;
            }
            if (this.width == 0.0f) {
                this.width = 1.0f;
            }
        } else if ((this.isCurve || this.isArrow) && nVertices >= 2 && !this.isArc) {
            EnumDrawType enumDrawType = this.isLine ? EnumDrawType.LINE_SEGMENT : (drawType = this.isCurve ? EnumDrawType.CURVE : EnumDrawType.ARROW);
        }
        if (this.isVector && !this.isArc) {
            if (nVertices > 2) {
                nVertices = 2;
            } else if (this.plane == null && nVertices != 2) {
                this.isVector = false;
            }
        }
        if (this.thisMesh.haveXyPoints) {
            this.isPerpendicular = false;
            if (nVertices == 3 && this.isPlane) {
                this.isPlane = false;
            }
            this.length = Float.MAX_VALUE;
            if (this.isVector) {
                this.thisMesh.diameter = 0;
            }
        } else if (nVertices == 2 && this.isVector) {
            this.ptList[1].add((T3)this.ptList[0]);
        }
        float dist = 0.0f;
        if (this.isArc || this.plane != null && this.isCircle) {
            if (this.plane != null) {
                dist = Measure.distanceToPlane((P4)this.plane, (T3)this.ptList[0]);
                V3 vAC = V3.new3((float)(-this.plane.x), (float)(-this.plane.y), (float)(-this.plane.z));
                vAC.normalize();
                if (dist < 0.0f) {
                    vAC.scale(-1.0f);
                }
                if (this.isCircle) {
                    vAC.scale(0.005f);
                    this.ptList[0].sub((T3)vAC);
                    vAC.scale(2.0f);
                }
                vAC.add((T3)this.ptList[0]);
                this.ptList[1] = P3.newP((T3)vAC);
                EnumDrawType enumDrawType = this.isArrow ? EnumDrawType.ARROW : (drawType = this.isArc ? EnumDrawType.ARC : EnumDrawType.CIRCULARPLANE);
            }
            if (this.isArc) {
                dist = Math.abs(dist);
                if (nVertices <= 3) {
                    if (nVertices == 3) {
                        this.ptList[3] = P3.newP((T3)this.ptList[2]);
                        this.ptList[2] = Draw.randomPoint();
                    } else {
                        if (nVertices == 2) {
                            this.ptList[2] = Draw.randomPoint();
                        }
                        this.ptList[3] = P3.new3((float)0.0f, (float)360.0f, (float)0.0f);
                    }
                }
                if (this.plane != null) {
                    this.ptList[3].z *= dist;
                }
                nVertices = 4;
            }
            this.plane = null;
        } else if (drawType == EnumDrawType.POINT) {
            P3 pt;
            P3 center = new P3();
            V3 normal = new V3();
            if (nVertices == 2 && this.plane != null) {
                this.ptList[1] = P3.newP((T3)this.ptList[0]);
                V3 vTemp = new V3();
                Measure.getPlaneProjection((P3)this.ptList[1], (P4)this.plane, (P3)this.ptList[1], (V3)vTemp);
                nVertices = -2;
                if (this.isArrow) {
                    drawType = EnumDrawType.ARROW;
                }
                this.plane = null;
            }
            if (nVertices == 3 && this.isPlane && !this.isPerpendicular) {
                pt = P3.newP((T3)this.ptList[1]);
                pt.sub((T3)this.ptList[0]);
                pt.scale(0.5f);
                this.ptList[3] = P3.newP((T3)this.ptList[2]);
                this.ptList[2].add((T3)pt);
                this.ptList[3].sub((T3)pt);
                nVertices = 4;
            } else if (nVertices >= 3 && !this.isPlane && this.isPerpendicular) {
                Measure.calcNormalizedNormal((T3)this.ptList[0], (T3)this.ptList[1], (T3)this.ptList[2], (V3)normal, (V3)this.vAB);
                center = new P3();
                Measure.calcAveragePointN((P3[])this.ptList, (int)nVertices, (P3)center);
                dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance((T3)center) : this.length;
                normal.scale(dist);
                this.ptList[0].setT((T3)center);
                this.ptList[1].add2((T3)center, (T3)normal);
                nVertices = 2;
            } else if (nVertices == 2 && this.isPerpendicular) {
                Measure.calcAveragePoint((P3)this.ptList[0], (P3)this.ptList[1], (P3)center);
                float f = dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance((T3)center) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    dist /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    dist *= 1.4142f;
                }
                Measure.getNormalToLine((P3)this.ptList[0], (P3)this.ptList[1], (V3)normal);
                normal.scale(dist);
                if (this.isPlane) {
                    this.ptList[2] = P3.newP((T3)center);
                    this.ptList[2].sub((T3)normal);
                    pt = P3.newP((T3)center);
                    pt.add((T3)normal);
                    Measure.calcNormalizedNormal((T3)this.ptList[0], (T3)this.ptList[1], (T3)this.ptList[2], (V3)normal, (V3)this.vAB);
                    normal.scale(dist);
                    this.ptList[3] = P3.newP((T3)center);
                    this.ptList[3].add((T3)normal);
                    this.ptList[1].sub2((T3)center, (T3)normal);
                    this.ptList[0].setT((T3)pt);
                    if (this.isRotated45) {
                        Measure.calcAveragePoint((P3)this.ptList[0], (P3)this.ptList[1], (P3)this.ptList[0]);
                        Measure.calcAveragePoint((P3)this.ptList[1], (P3)this.ptList[2], (P3)this.ptList[1]);
                        Measure.calcAveragePoint((P3)this.ptList[2], (P3)this.ptList[3], (P3)this.ptList[2]);
                        Measure.calcAveragePoint((P3)this.ptList[3], (P3)pt, (P3)this.ptList[3]);
                    }
                    nVertices = 4;
                } else {
                    this.ptList[0].sub2((T3)center, (T3)normal);
                    this.ptList[1].add2((T3)center, (T3)normal);
                }
                if (this.isArrow && nVertices != -2) {
                    this.isArrow = false;
                }
            } else if (nVertices == 2 && this.length != Float.MAX_VALUE) {
                Measure.calcAveragePoint((P3)this.ptList[0], (P3)this.ptList[1], (P3)center);
                normal.sub2((T3)this.ptList[1], (T3)center);
                normal.scale(0.5f / normal.length() * (this.length == 0.0f ? 0.01f : this.length));
                if (this.length == 0.0f) {
                    center.setT((T3)this.ptList[0]);
                }
                this.ptList[0].sub2((T3)center, (T3)normal);
                this.ptList[1].add2((T3)center, (T3)normal);
            }
            if (nVertices > 4) {
                nVertices = 4;
            }
            switch (nVertices) {
                case -2: {
                    nVertices = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    drawType = this.isArc ? EnumDrawType.ARC : (this.isPlane && this.isCircle ? EnumDrawType.CIRCULARPLANE : (this.isCylinder ? EnumDrawType.CYLINDER : EnumDrawType.LINE));
                    break;
                }
                default: {
                    drawType = this.thisMesh.connectedAtoms == null ? EnumDrawType.PLANE : EnumDrawType.ARROW;
                }
            }
        }
        this.thisMesh.drawType = drawType;
        this.thisMesh.drawVertexCount = nVertices;
        if (nVertices == 0) {
            return;
        }
        int nVertices0 = this.thisMesh.vc;
        for (int i = 0; i < nVertices; ++i) {
            this.thisMesh.addV((T3)this.ptList[i], false);
        }
        int npoints = nVertices < 3 ? 3 : nVertices;
        this.thisMesh.setPolygonCount(nPoly + 1);
        this.thisMesh.pis[nPoly] = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            this.thisMesh.pis[nPoly][i] = nVertices0 + (i < nVertices ? i : nVertices - 1);
        }
    }

    private void scale(Mesh mesh, float newScale) {
        DrawMesh dmesh = (DrawMesh)mesh;
        if (newScale == 0.0f || dmesh.vc == 0 && dmesh.connectedAtoms == null || dmesh.scale == newScale) {
            return;
        }
        float f = newScale / dmesh.scale;
        dmesh.scale = newScale;
        dmesh.isScaleSet = true;
        if (dmesh.isRenderScalable()) {
            return;
        }
        V3 diff = new V3();
        int iptlast = -1;
        int ipt = 0;
        try {
            int i = dmesh.pc;
            while (--i >= 0) {
                T3 center;
                T3 t3 = dmesh.isVector ? dmesh.vs[0] : (center = dmesh.ptCenters == null ? dmesh.ptCenter : dmesh.ptCenters[i]);
                if (center == null) {
                    return;
                }
                if (dmesh.pis[i] == null) continue;
                iptlast = -1;
                int iV = dmesh.pis[i].length;
                while (--iV >= 0) {
                    ipt = dmesh.pis[i][iV];
                    if (ipt == iptlast) continue;
                    iptlast = ipt;
                    diff.sub2(dmesh.vs[ipt], center);
                    diff.scale(f);
                    diff.add(center);
                    dmesh.vs[ipt].setT((T3)diff);
                }
            }
        }
        catch (Exception e) {
            Logger.info((String)("Error executing DRAW command: " + e));
            dmesh.isValid = false;
        }
    }

    private static final void setAxes(DrawMesh m) {
        m.axis = V3.new3((float)0.0f, (float)0.0f, (float)0.0f);
        m.axes = new V3[m.pc > 0 ? m.pc : 1];
        if (m.vs == null) {
            return;
        }
        int n = 0;
        int i = m.pc;
        while (--i >= 0) {
            int[] p = m.pis[i];
            m.axes[i] = new V3();
            if (p != null && p.length != 0) {
                if (m.drawVertexCount == 2 || m.drawVertexCount < 0 && m.drawVertexCounts[i] == 2) {
                    m.axes[i].sub2(m.vs[p[0]], m.vs[p[1]]);
                    ++n;
                } else {
                    Measure.calcNormalizedNormal((T3)m.vs[p[0]], (T3)m.vs[p[1]], (T3)m.vs[p[2]], (V3)m.axes[i], (V3)m.vAB);
                    ++n;
                }
            }
            m.axis.add((T3)m.axes[i]);
        }
        if (n == 0) {
            return;
        }
        m.axis.scale(1.0f / (float)n);
    }

    public void setModelVisibilityFlags(BS bsModels) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh m = this.dmeshes[i];
            if (m == null) continue;
            int n = m.visibilityFlags = m.isValid && m.visible ? this.vf : 0;
            if (m.modelIndex >= 0 && !bsModels.get(m.modelIndex) || m.modelFlags != null && !BSUtil.haveCommon((BS)bsModels, (BS)m.modelFlags)) {
                m.visibilityFlags = 0;
                continue;
            }
            if (m.modelFlags == null) continue;
            m.bsMeshesVisible.clearAll();
            m.bsMeshesVisible.or(m.modelFlags);
            m.bsMeshesVisible.and(bsModels);
        }
    }

    public Map<String, Object> checkObjectClicked(int x, int y, int action, BS bsVisible, boolean drawPicking) {
        boolean isSpinMode;
        boolean isPickingMode = this.vwr.getPickingMode() == 4;
        boolean bl = isSpinMode = this.vwr.getPickingMode() == 5;
        if (!isPickingMode && !drawPicking && !isSpinMode || C.isColixTranslucent((short)this.colix)) {
            return null;
        }
        if (!this.findPickedObject(x, y, false, bsVisible)) {
            return null;
        }
        T3 v = this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][this.pickedVertex]];
        int modelIndex = this.pickedMesh.modelIndex;
        BS bs = ((DrawMesh)this.pickedMesh).modelFlags;
        if (modelIndex < 0 && BSUtil.cardinalityOf((BS)bs) == 1) {
            modelIndex = bs.nextSetBit(0);
        }
        Map map = null;
        if (action != 0) {
            map = this.getPickedPoint(v, modelIndex);
        }
        if (drawPicking && !isPickingMode) {
            if (action != 0) {
                this.setStatusPicked(-2, v, map);
            }
            return this.getPickedPoint(v, modelIndex);
        }
        if (action == 0 || this.pickedMesh.pis[this.pickedModel][0] == this.pickedMesh.pis[this.pickedModel][1]) {
            return map;
        }
        boolean isClockwise = this.vwr.isBound(action, 42);
        if (this.pickedVertex == 0) {
            this.vwr.startSpinningAxis(this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][1]], this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][0]], isClockwise);
        } else {
            this.vwr.startSpinningAxis(this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][0]], this.pickedMesh.vs[this.pickedMesh.pis[this.pickedModel][1]], isClockwise);
        }
        return this.getPickedPoint(null, 0);
    }

    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        String s;
        if (!this.vwr.getDrawHover()) {
            return false;
        }
        if (C.isColixTranslucent((short)this.colix)) {
            return false;
        }
        if (!this.findPickedObject(x, y, false, bsVisible)) {
            return false;
        }
        if (this.vwr.gdata.antialiasEnabled) {
            x <<= 1;
            y <<= 1;
        }
        String string = s = this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0];
        if (s.length() > 1 && s.charAt(0) == '>') {
            s = s.substring(1);
        }
        this.vwr.hoverOnPt(x, y, s, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    public synchronized boolean checkObjectDragged(int prevX, int prevY, int x, int y, int dragAction, BS bsVisible) {
        if (this.vwr.getPickingMode() != 4) {
            return false;
        }
        boolean moveAll = this.vwr.isBound(dragAction, 8);
        boolean movePoint = this.vwr.isBound(dragAction, 9);
        if (!moveAll && !movePoint) {
            return false;
        }
        if (prevX == Integer.MIN_VALUE) {
            return this.findPickedObject(x, y, true, bsVisible);
        }
        if (prevX == Integer.MAX_VALUE) {
            this.pickedMesh = null;
            return false;
        }
        if (this.pickedMesh == null) {
            return false;
        }
        DrawMesh dm = (DrawMesh)this.pickedMesh;
        this.move2D(dm, dm.pis[this.pickedModel], this.pickedVertex, x, y, moveAll);
        this.thisMesh = dm;
        return true;
    }

    private void move2D(DrawMesh mesh, int[] vertexes, int iVertex, int x, int y, boolean moveAll) {
        int i;
        if (vertexes == null || vertexes.length == 0) {
            return;
        }
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
        }
        P3 pt = new P3();
        int ptVertex = vertexes[iVertex];
        P3 coord = P3.newP((T3)(mesh.altVertices == null ? mesh.vs[ptVertex] : (P3)mesh.altVertices[ptVertex]));
        P3 newcoord = new P3();
        V3 move = new V3();
        this.vwr.tm.transformPt3f((T3)coord, pt);
        pt.x = x;
        pt.y = y;
        this.vwr.tm.unTransformPoint((T3)pt, (T3)newcoord);
        move.sub2((T3)newcoord, (T3)coord);
        if (mesh.isTriangleSet) {
            iVertex = ptVertex;
        }
        int n = !moveAll ? iVertex + 1 : (mesh.isTriangleSet ? mesh.vs.length : vertexes.length);
        BS bsMoved = new BS();
        int n2 = i = moveAll ? 0 : iVertex;
        while (i < n) {
            if (moveAll || i == iVertex) {
                int k;
                int n3 = k = mesh.isTriangleSet ? i : vertexes[i];
                if (!bsMoved.get(k)) {
                    bsMoved.set(k);
                    mesh.vs[k].add((T3)move);
                }
            }
            ++i;
        }
        if (mesh.altVertices != null) {
            mesh.recalcAltVertices = true;
        }
        mesh.setCenters();
    }

    private boolean findPickedObject(int x, int y, boolean isPicking, BS bsVisible) {
        int dmin2 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int mCount;
            DrawMesh m = this.dmeshes[i];
            if (m.visibilityFlags == 0) continue;
            int iModel = mCount = m.isTriangleSet ? m.pc : (m.modelFlags == null ? 1 : this.vwr.ms.mc);
            while (--iModel >= 0) {
                int iVertex;
                if (m.modelFlags != null && !m.modelFlags.get(iModel) || m.pis == null || !m.isTriangleSet && (iModel >= m.pis.length || m.pis[iModel] == null)) continue;
                int n = iVertex = m.isTriangleSet ? 3 : m.pis[iModel].length;
                while (--iVertex >= 0) {
                    try {
                        int iv = m.pis[iModel][iVertex];
                        Object pt = m.altVertices == null ? m.vs[iv] : (P3)m.altVertices[iv];
                        int d2 = this.coordinateInRange(x, y, (T3)pt, dmin2, this.ptXY);
                        if (d2 < 0) continue;
                        this.pickedMesh = m;
                        dmin2 = d2;
                        this.pickedModel = iModel;
                        this.pickedVertex = iVertex;
                        this.pickedPt = pt;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }
        }
        return this.pickedMesh != null;
    }

    private String getCommand(Mesh mesh) {
        if (mesh != null) {
            return this.getCommand2(mesh, mesh.modelIndex);
        }
        SB sb = new SB();
        String key = this.explicitID && this.previousMeshID != null && PT.isWild((String)this.previousMeshID) ? this.previousMeshID : null;
        Lst list = this.getMeshList(key, false);
        int i = list.size();
        while (--i >= 0) {
            Mesh m = (Mesh)list.get(i);
            sb.append(this.getCommand2(m, m.modelIndex));
        }
        return sb.toString();
    }

    private String getCommand2(Mesh mesh, int iModel) {
        DrawMesh dmesh = (DrawMesh)mesh;
        if (!dmesh.isValid || dmesh.drawType == EnumDrawType.NONE && dmesh.lineData == null && dmesh.drawVertexCount == 0 && dmesh.drawVertexCounts == null) {
            return "";
        }
        SB str = new SB();
        int modelCount = this.vwr.ms.mc;
        if (!dmesh.isFixed && iModel >= 0 && modelCount > 1) {
            Draw.appendCmd((SB)str, (String)("frame " + this.vwr.getModelNumberDotted(iModel)));
        }
        str.append("  draw ID ").append(PT.esc((String)dmesh.thisID));
        if (dmesh.isFixed) {
            str.append(" fixed");
        }
        if (iModel < 0) {
            iModel = 0;
        }
        if (dmesh.noHead) {
            str.append(" noHead");
        } else if (dmesh.isBarb) {
            str.append(" barb");
        }
        if (dmesh.scale != 1.0f && dmesh.isScaleSet && (dmesh.haveXyPoints || dmesh.connectedAtoms != null || dmesh.drawType == EnumDrawType.CIRCLE || dmesh.drawType == EnumDrawType.ARC)) {
            str.append(" scale ").appendF(dmesh.scale);
        }
        if (dmesh.width != 0.0f) {
            str.append(" diameter ").appendF(dmesh.drawType == EnumDrawType.CYLINDER ? Math.abs(dmesh.width) : (dmesh.drawType == EnumDrawType.CIRCULARPLANE ? Math.abs(dmesh.width * dmesh.scale) : dmesh.width));
        } else if (dmesh.diameter > 0) {
            str.append(" diameter ").appendI(dmesh.diameter);
        }
        if (dmesh.lineData != null) {
            str.append("  lineData [");
            int n = dmesh.lineData.size();
            int j = 0;
            while (j < n) {
                P3[] pts = (P3[])dmesh.lineData.get(j);
                String s = Escape.eP((T3)pts[0]);
                str.append(s.substring(1, s.length() - 1));
                str.append(",");
                s = Escape.eP((T3)pts[1]);
                str.append(s.substring(1, s.length() - 1));
                if (++j >= n) continue;
                str.append(", ");
            }
            str.append("]");
        } else {
            int nVertices = dmesh.drawVertexCount > 0 || dmesh.drawVertexCounts == null ? dmesh.drawVertexCount : dmesh.drawVertexCounts[iModel >= 0 ? iModel : 0];
            switch (dmesh.drawTypes == null || dmesh.drawTypes[iModel] == null ? dmesh.drawType : dmesh.drawTypes[iModel]) {
                case NONE: 
                case MULTIPLE: {
                    break;
                }
                case POLYGON: {
                    str.append(" POLYGON ").appendI(nVertices);
                    break;
                }
                case PLANE: {
                    if (nVertices != 4) break;
                    str.append(" PLANE");
                    break;
                }
                case LINE_SEGMENT: {
                    str.append(" LINE");
                    break;
                }
                case ARC: {
                    str.append(dmesh.isVector ? " ARROW ARC" : " ARC");
                    break;
                }
                case ARROW: {
                    str.append(dmesh.isVector ? " VECTOR" : " ARROW");
                    if (dmesh.connectedAtoms == null) break;
                    str.append(" connect ").append(Escape.eAI((int[])dmesh.connectedAtoms));
                    break;
                }
                case CIRCLE: {
                    str.append(" CIRCLE");
                    break;
                }
                case CURVE: {
                    str.append(" CURVE");
                    break;
                }
                case CIRCULARPLANE: 
                case CYLINDER: {
                    str.append(" CYLINDER");
                    break;
                }
                case POINT: {
                    nVertices = 1;
                    break;
                }
                case LINE: {
                    nVertices = 2;
                }
            }
            if (dmesh.modelIndex < 0 && !dmesh.isFixed) {
                for (int i = 0; i < modelCount; ++i) {
                    if (!Draw.isPolygonDisplayable(dmesh, i)) continue;
                    if (nVertices == 0) {
                        nVertices = dmesh.drawVertexCounts[i];
                    }
                    str.append(" [ " + i);
                    String s = Draw.getVertexList(dmesh, i, nVertices);
                    if (s.indexOf("NaN") >= 0) {
                        return "";
                    }
                    str.append(s);
                    str.append(" ] ");
                }
            } else if (dmesh.drawType == EnumDrawType.POLYGON) {
                int i;
                for (i = 0; i < dmesh.vc; ++i) {
                    str.append(" ").append(Escape.eP((T3)dmesh.vs[i]));
                }
                str.append(" ").appendI(dmesh.pc);
                for (i = 0; i < dmesh.pc; ++i) {
                    if (dmesh.pis[i] == null) {
                        str.append(" [0 0 0 0]");
                        continue;
                    }
                    str.append(" ").append(Escape.eAI((int[])dmesh.pis[i]));
                }
            } else {
                String s = Draw.getVertexList(dmesh, iModel, nVertices);
                if (s.indexOf("NaN") >= 0) {
                    return "";
                }
                str.append(s);
            }
        }
        if (dmesh.mat4 != null) {
            V3 v = new V3();
            dmesh.mat4.getTranslation((T3)v);
            str.append(" offset ").append(Escape.eP((T3)v));
        }
        if (dmesh.title != null) {
            String s = "";
            for (int i = 0; i < dmesh.title.length; ++i) {
                s = s + "|" + dmesh.title[i];
            }
            str.append(PT.esc((String)s.substring(1)));
        }
        str.append(";\n");
        Draw.appendCmd((SB)str, (String)dmesh.getState("draw"));
        Draw.appendCmd((SB)str, (String)Draw.getColorCommandUnk((String)"draw", (short)dmesh.colix, (boolean)this.translucentAllowed));
        return str.toString();
    }

    public static boolean isPolygonDisplayable(Mesh mesh, int i) {
        return i < mesh.pis.length && mesh.pis[i] != null && mesh.pis[i].length > 0;
    }

    private static String getVertexList(DrawMesh mesh, int iModel, int nVertices) {
        String str = "";
        try {
            if (iModel >= mesh.pis.length) {
                iModel = 0;
            }
            boolean adjustPt = mesh.isVector && mesh.drawType != EnumDrawType.ARC;
            for (int i = 0; i < nVertices; ++i) {
                T3 pt = mesh.vs[mesh.pis[iModel][i]];
                if (pt.z == Float.MAX_VALUE || pt.z == -3.4028235E38f) {
                    str = str + (i == 0 ? " " : " ,") + "[" + (int)pt.x + " " + (int)pt.y + (pt.z < 0.0f ? " %]" : "]");
                    continue;
                }
                if (adjustPt && i == 1) {
                    P3 pt1 = P3.newP((T3)pt);
                    pt1.sub(mesh.vs[mesh.pis[iModel][0]]);
                    str = str + " " + Escape.eP((T3)pt1);
                    continue;
                }
                str = str + " " + Escape.eP((T3)pt);
            }
        }
        catch (Exception e) {
            Logger.error((String)"Unexpected error in Draw.getVertexList");
        }
        return str;
    }

    public Object getShapeDetail() {
        Lst V = new Lst();
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh mesh = this.dmeshes[i];
            if (mesh.vc == 0) continue;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("visible", mesh.visible ? Boolean.TRUE : Boolean.FALSE);
            info.put("fixed", mesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("drawType", mesh.drawType.name);
            if (mesh.diameter > 0) {
                info.put("diameter", mesh.diameter);
            }
            if (mesh.width != 0.0f) {
                info.put("width", Float.valueOf(mesh.width));
            }
            info.put("scale", Float.valueOf(mesh.scale));
            if (mesh.drawType == EnumDrawType.MULTIPLE) {
                Lst m = new Lst();
                int modelCount = this.vwr.ms.mc;
                for (int k = 0; k < modelCount; ++k) {
                    if (mesh.ptCenters[k] == null) continue;
                    Hashtable<String, Object> mInfo = new Hashtable<String, Object>();
                    mInfo.put("modelIndex", k);
                    mInfo.put("command", this.getCommand2(mesh, k));
                    mInfo.put("center", mesh.ptCenters[k]);
                    int nPoints = mesh.drawVertexCounts[k];
                    mInfo.put("vertexCount", nPoints);
                    if (nPoints > 1) {
                        mInfo.put("axis", mesh.axes[k]);
                    }
                    Lst v = new Lst();
                    for (int ipt = 0; ipt < nPoints; ++ipt) {
                        v.addLast((Object)mesh.vs[mesh.pis[k][ipt]]);
                    }
                    mInfo.put("vertices", v);
                    if (mesh.drawTypes[k] == EnumDrawType.LINE) {
                        float d = mesh.vs[mesh.pis[k][0]].distance(mesh.vs[mesh.pis[k][1]]);
                        mInfo.put("length_Ang", Float.valueOf(d));
                    }
                    m.addLast(mInfo);
                }
                info.put("models", m);
            } else {
                info.put("command", this.getCommand(mesh));
                info.put("center", mesh.ptCenter);
                if (mesh.drawVertexCount > 1) {
                    info.put("axis", mesh.axis);
                }
                Lst v = new Lst();
                for (int j = 0; j < mesh.vc; ++j) {
                    v.addLast((Object)mesh.vs[j]);
                }
                info.put("vertices", v);
                if (mesh.drawType == EnumDrawType.LINE) {
                    info.put("length_Ang", Float.valueOf(mesh.vs[0].distance(mesh.vs[1])));
                }
            }
            V.addLast(info);
        }
        return V;
    }

    public String getShapeState() {
        SB s = new SB();
        s.append("\n");
        Draw.appendCmd((SB)s, (String)(this.myType + " delete"));
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh mesh = this.dmeshes[i];
            if (mesh.vc == 0 && mesh.lineData == null) continue;
            s.append(this.getCommand2(mesh, mesh.modelIndex));
            if (mesh.visible) continue;
            s.append(" " + this.myType + " ID " + PT.esc((String)mesh.thisID) + " off;\n");
        }
        return s.toString();
    }

    public static P3 randomPoint() {
        return P3.new3((float)((float)Math.random()), (float)((float)Math.random()), (float)((float)Math.random()));
    }

    public static enum EnumDrawType {
        MULTIPLE(-1, "multiple"),
        NONE(0, "none"),
        POINT(1, "point"),
        LINE(2, "line"),
        PLANE(4, "plane"),
        CYLINDER(14, "cylinder"),
        ARROW(15, "arrow"),
        CIRCLE(16, "circle"),
        CURVE(17, "curve"),
        CIRCULARPLANE(18, "circularPlane"),
        ARC(19, "arc"),
        LINE_SEGMENT(20, "lineSegment"),
        POLYGON(21, "polygon");

        final int id;
        final String name;

        private EnumDrawType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static EnumDrawType getType(int nPoints) {
            switch (nPoints) {
                case 1: {
                    return POINT;
                }
                case 2: {
                    return LINE;
                }
                case 4: {
                    return PLANE;
                }
            }
            return NONE;
        }
    }
}

