/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javajs.util.Lst;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

abstract class SlaterReader
extends BasisFunctionReader {
    protected final Lst<SlaterData> slaters = new Lst();
    protected SlaterData[] slaterArray;
    private static final double _1_4pi = 0.07957747154594767;
    private static final double[] fact1 = new double[]{1.0, 2.0, 24.0, 720.0, 40320.0, 362880.0, 8.71782912E10};
    private static final double[] dfact2 = new double[]{1.0, 1.0, 3.0, 15.0, 105.0};

    SlaterReader() {
    }

    protected final void addSlater(int iAtom, int a, int b, int c, int d, double zeta, float coef) {
        this.slaters.addLast((Object)new SlaterData(iAtom, a, b, c, d, zeta, coef));
    }

    protected void addSlater(SlaterData sd, int n) {
        sd.index = n;
        this.slaters.addLast((Object)sd);
    }

    protected final void setSlaters(boolean doScale, boolean doSort) {
        int i;
        if (this.slaterArray == null) {
            int nSlaters = this.slaters.size();
            this.slaterArray = new SlaterData[nSlaters];
            for (i = 0; i < this.slaterArray.length; ++i) {
                this.slaterArray[i] = (SlaterData)this.slaters.get(i);
            }
        }
        if (doScale) {
            for (int i2 = 0; i2 < this.slaterArray.length; ++i2) {
                SlaterData sd = this.slaterArray[i2];
                sd.coef *= this.scaleSlater(sd.x, sd.y, sd.z, sd.r, sd.zeta);
                if (!this.debugging) continue;
                Logger.debug((String)("SlaterReader " + i2 + ": " + sd.iAtom + " " + sd.x + " " + sd.y + " " + sd.z + " " + sd.r + " " + sd.zeta + " " + sd.coef));
            }
        }
        if (doSort) {
            Arrays.sort(this.slaterArray, new SlaterSorter());
            int[] pointers = new int[this.slaterArray.length];
            for (i = 0; i < this.slaterArray.length; ++i) {
                pointers[i] = this.slaterArray[i].index;
            }
            this.sortOrbitalCoefficients(pointers);
        }
        this.moData.put("slaters", this.slaterArray);
        this.asc.setCurrentModelInfo("moData", (Object)this.moData);
    }

    protected final void setMOs(String units) {
        this.moData.put("mos", this.orbitals);
        this.moData.put("energyUnits", units);
        this.finalizeMOData(this.moData);
    }

    protected void sortOrbitalCoefficients(int[] pointers) {
        int i = this.orbitals.size();
        while (--i >= 0) {
            Map mo = (Map)this.orbitals.get(i);
            float[] coefs = (float[])mo.get("coefficients");
            float[] sorted = new float[pointers.length];
            for (int j = 0; j < pointers.length; ++j) {
                int k = pointers[j];
                if (k >= coefs.length) continue;
                sorted[j] = coefs[k];
            }
            mo.put("coefficients", sorted);
        }
    }

    protected void sortOrbitals() {
        Map[] array = (Map[])this.orbitals.toArray((Object[])new Map[0]);
        Arrays.sort(array, new OrbitalSorter());
        this.orbitals.clear();
        for (int i = 0; i < array.length; ++i) {
            this.orbitals.addLast((Object)array[i]);
        }
    }

    protected double scaleSlater(int ex, int ey, int ez, int er, double zeta) {
        int el = ex + ey + ez;
        switch (el) {
            case 0: 
            case 1: {
                ez = -1;
            }
        }
        return SlaterReader.getSlaterConstCartesian(el + er + 1, Math.abs(zeta), el, ex, ey, ez);
    }

    private static double fact(double f, double zeta, int n) {
        return Math.pow(2.0 * zeta, (double)n + 0.5) * Math.sqrt(f * 0.07957747154594767 / fact1[n]);
    }

    protected static final double getSlaterConstCartesian(int n, double zeta, int el, int ex, int ey, int ez) {
        return SlaterReader.fact(ez < 0 ? dfact2[el + 1] : dfact2[el + 1] / dfact2[ex] / dfact2[ey] / dfact2[ez], zeta, n);
    }

    protected static final double getSlaterConstDSpherical(int n, double zeta, int ex, int ey) {
        return SlaterReader.fact(15 / (ex < 0 ? 12 : (ey < 0 ? 4 : 1)), zeta, n);
    }

    class OrbitalSorter
    implements Comparator<Map<String, Object>> {
        OrbitalSorter() {
        }

        @Override
        public int compare(Map<String, Object> mo1, Map<String, Object> mo2) {
            float e2;
            float e1 = ((Float)mo1.get("energy")).floatValue();
            return e1 < (e2 = ((Float)mo2.get("energy")).floatValue()) ? -1 : (e2 < e1 ? 1 : 0);
        }
    }

    class SlaterSorter
    implements Comparator<SlaterData> {
        SlaterSorter() {
        }

        @Override
        public int compare(SlaterData sd1, SlaterData sd2) {
            return sd1.iAtom < sd2.iAtom ? -1 : (sd1.iAtom > sd2.iAtom ? 1 : 0);
        }
    }
}

