/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.SpartanArchive;
import org.jmol.adapter.readers.quantum.SpartanInputReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends SpartanInputReader {
    private boolean iHaveModelStatement;
    private boolean isCompoundDocument;
    private boolean inputOnly;
    private boolean espCharges;
    private boolean isInputFirst;
    private boolean iHaveNewDir;
    private String endCheck = "END Directory Entry ";
    private String title;
    SpartanArchive spartanArchive;
    Map<String, String> titles;
    private boolean haveCharges;

    protected void initializeReader() throws Exception {
        this.isCompoundDocument = this.rd().indexOf("Compound Document File Directory") >= 0;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.espCharges = !this.checkFilterKey("MULLIKEN");
    }

    protected boolean checkLine() throws Exception {
        boolean isMacDir;
        boolean isNewDir;
        int pt = 3;
        boolean bl = isNewDir = this.isCompoundDocument && this.line.startsWith("NEW Directory M") && !this.line.startsWith("NEW Directory Molecules");
        if (isNewDir) {
            this.iHaveNewDir = true;
        }
        boolean isMolecule = !this.iHaveNewDir && !isNewDir && this.isCompoundDocument && this.line.equals("BEGIN Directory Entry Molecule");
        boolean bl2 = isMacDir = !this.isCompoundDocument && (pt = this.line.indexOf("#JMOL_MODEL")) >= 0;
        if (isNewDir || isMolecule || isMacDir) {
            if (this.modelNumber > 0 && !this.isInputFirst) {
                this.applySymmetryAndSetTrajectory();
            }
            this.iHaveModelStatement = true;
            int modelNo = isMolecule ? 0 : this.parseIntAt(this.line, pt + 12);
            this.modelNumber = this.bsModels == null && modelNo != Integer.MIN_VALUE && modelNo != 0 ? modelNo : this.modelNumber + 1;
            this.bondData = "";
            if (!this.doGetModel(this.modelNumber, null)) {
                if (this.isInputFirst) {
                    this.asc.removeCurrentAtomSet();
                    this.discardLinesUntilContains("BEGIN Directory Entry Input");
                } else if (isNewDir) {
                    this.discardLinesUntilContains("NEW Directory M");
                } else if (isMolecule) {
                    this.discardLinesUntilContains("BEGIN Directory Entry M");
                } else {
                    this.discardLinesUntilContains("#JMOL_MODEL");
                }
                this.checkLastModel();
                return false;
            }
            if (!this.isInputFirst) {
                this.asc.newAtomSet();
            }
            this.moData = new Hashtable();
            this.moData.put("isNormalized", Boolean.TRUE);
            boolean isOK = false;
            if (modelNo == Integer.MIN_VALUE || this.titles == null) {
                modelNo = this.modelNumber;
                this.title = "Model " + modelNo;
            } else {
                isOK = true;
                this.title = this.titles.get("Title" + modelNo);
                this.title = "Profile " + modelNo + (this.title == null ? "" : ": " + this.title);
            }
            if (this.constraints == null && (isOK || !this.isInputFirst)) {
                this.asc.setAtomSetName(this.title);
            }
            this.setModelPDB(false);
            this.asc.setCurrentAtomSetNumber(modelNo);
            if (isMolecule) {
                this.readMyTransform();
            }
            return true;
        }
        if (this.iHaveModelStatement && !this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("BEGIN") == 0) {
            String lcline = this.line.toLowerCase();
            if (lcline.endsWith("input")) {
                if (!this.iHaveModelStatement) {
                    this.isInputFirst = true;
                }
                if (this.isInputFirst) {
                    this.asc.newAtomSet();
                }
                this.bondData = "";
                this.title = this.readInputRecords();
                if (this.asc.errorMessage != null) {
                    this.continuing = false;
                    return false;
                }
                if (this.title != null && this.constraints == null) {
                    this.asc.setAtomSetName(this.title);
                }
                this.setCharges();
                if (this.inputOnly) {
                    this.continuing = false;
                    return false;
                }
            } else {
                if (lcline.endsWith("_output")) {
                    return true;
                }
                if (lcline.endsWith("output")) {
                    this.readOutput();
                    return false;
                }
                if (lcline.endsWith("molecule") || lcline.endsWith("molecule:asbinarystring")) {
                    this.readMyTransform();
                    return false;
                }
                if (lcline.endsWith("proparc") || lcline.endsWith("propertyarchive")) {
                    this.readProperties();
                    return false;
                }
                if (lcline.endsWith("archive")) {
                    this.asc.setAtomSetName(this.readArchive());
                    return false;
                }
            }
            return true;
        }
        if (this.line.indexOf("5D shell") >= 0) {
            this.calculationType = this.line;
            this.moData.put("calculationType", this.calculationType);
        }
        return true;
    }

    protected void finalizeSubclassReader() throws Exception {
        Float n;
        this.finalizeReaderASCR();
        if (this.asc.ac > 0 && this.spartanArchive != null && this.asc.bondCount == 0 && this.bondData != null) {
            this.spartanArchive.addBonds(this.bondData, 0);
        }
        if (this.moData != null && (n = (Float)this.asc.atomSetInfo.get("HOMO_N")) != null) {
            int i = n.intValue();
            this.moData.put("HOMO", i);
        }
    }

    private void readMyTransform() throws Exception {
        int i;
        String binaryCodes = this.rd();
        String[] tokens = PT.getTokens((String)binaryCodes.trim());
        if (tokens.length < 16) {
            return;
        }
        byte[] bytes = new byte[tokens.length];
        for (i = 0; i < tokens.length; ++i) {
            bytes[i] = (byte)PT.parseIntRadix((String)tokens[i], (int)16);
        }
        float[] mat = new float[16];
        i = 16;
        int j = bytes.length - 8;
        while (--i >= 0) {
            mat[i] = BC.bytesToDoubleToFloat((byte[])bytes, (int)j, (boolean)false);
            j -= 8;
        }
        this.setTransform(mat[0], mat[1], mat[2], mat[4], mat[5], mat[6], mat[8], mat[9], mat[10]);
    }

    private void readOutput() throws Exception {
        this.titles = new Hashtable<String, String>();
        SB header = new SB();
        while (this.rd() != null && !this.line.startsWith("END ")) {
            header.append(this.line).append("\n");
            int pt = this.line.indexOf(")");
            if (pt <= 0) continue;
            this.titles.put("Title" + this.parseIntRange(this.line, 0, pt), this.line.substring(pt + 1).trim());
        }
        this.asc.setInfo("fileHeader", (Object)header.toString());
    }

    private String readArchive() throws Exception {
        this.spartanArchive = new SpartanArchive(this, this.bondData, this.endCheck);
        String modelName = this.readArchiveHeader();
        if (modelName != null) {
            this.modelAtomCount = this.spartanArchive.readArchive(this.line, false, this.asc.ac, false);
        }
        return this.constraints == null ? modelName : null;
    }

    private void setCharges() {
        if (this.haveCharges || this.asc.ac == 0) {
            return;
        }
        this.haveCharges = this.espCharges && this.asc.setAtomSetCollectionPartialCharges("ESPCHARGES") || this.asc.setAtomSetCollectionPartialCharges("MULCHARGES") || this.asc.setAtomSetCollectionPartialCharges("Q1_CHARGES") || this.asc.setAtomSetCollectionPartialCharges("ESPCHARGES");
    }

    private void readProperties() throws Exception {
        if (this.spartanArchive == null) {
            this.rd();
            return;
        }
        this.spartanArchive.readProperties();
        this.rd();
        this.setCharges();
    }

    private String readArchiveHeader() throws Exception {
        String modelInfo = this.rd();
        if (this.debugging) {
            Logger.debug((String)modelInfo);
        }
        if (modelInfo.indexOf("Error:") == 0) {
            return null;
        }
        this.asc.setCollectionName(modelInfo);
        this.asc.setAtomSetName(modelInfo);
        String modelName = this.rd();
        if (this.debugging) {
            Logger.debug((String)modelName);
        }
        this.rd();
        return modelName;
    }

    public void setEnergy(float value) {
        this.asc.setAtomSetName(this.constraints + (this.constraints.length() == 0 ? "" : " ") + "Energy=" + value + " KJ");
    }
}

