/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

abstract class BasisFunctionReader
extends AtomSetCollectionReader {
    public Lst<int[]> shells;
    protected Map<String, Object> moData = new Hashtable<String, Object>();
    protected Lst<Map<String, Object>> orbitals = new Lst();
    protected int nOrbitals = 0;
    protected boolean ignoreMOs = false;
    protected String alphaBeta = "";
    protected int[][] dfCoefMaps;
    private String[] filterTokens;
    private boolean filterIsNot;
    private String spin;
    protected int nCoef;

    BasisFunctionReader() {
    }

    protected boolean filterMO() {
        boolean isHeader;
        boolean bl = isHeader = this.line.indexOf(10) == 0;
        if (!isHeader && !this.doReadMolecularOrbitals) {
            return false;
        }
        boolean isOK = true;
        this.line = this.line + " " + this.alphaBeta;
        String ucline = this.line.toUpperCase();
        if (this.filter != null) {
            int nOK = 0;
            if (this.filterTokens == null) {
                this.filterIsNot = this.filter.indexOf("!") >= 0;
                this.filterTokens = PT.getTokens((String)this.filter.replace('!', ' ').replace(',', ' ').replace(';', ' '));
            }
            for (int i = 0; i < this.filterTokens.length; ++i) {
                if (ucline.indexOf(this.filterTokens[i]) >= 0) {
                    if (this.filterIsNot) continue;
                    nOK = this.filterTokens.length;
                    break;
                }
                if (!this.filterIsNot) continue;
                ++nOK;
            }
            boolean bl2 = isOK = nOK == this.filterTokens.length;
            if (!isHeader) {
                Logger.info((String)("filter MOs: " + isOK + " for \"" + this.line + "\""));
            }
        }
        this.spin = ucline.indexOf("ALPHA") >= 0 ? "alpha" : (ucline.indexOf("BETA") >= 0 ? "beta" : null);
        return isOK;
    }

    protected void setMO(Map<String, Object> mo) {
        if (this.dfCoefMaps != null) {
            mo.put("dfCoefMaps", this.dfCoefMaps);
        }
        this.orbitals.addLast(mo);
        mo.put("index", this.orbitals.size());
        if (this.spin != null) {
            mo.put("spin", this.spin);
        }
    }

    protected boolean getDFMap(String fileList, int shellType, String jmolList, int minLength) {
        if (fileList.equals(jmolList)) {
            return true;
        }
        this.getDfCoefMaps();
        boolean isOK = QS.createDFMap(this.dfCoefMaps[shellType], fileList, jmolList, minLength);
        if (!isOK) {
            Logger.error((String)("Disabling orbitals of type " + shellType + " -- Cannot read orbital order for: " + fileList + "\n expecting: " + jmolList));
        }
        return isOK;
    }

    public int[][] getDfCoefMaps() {
        return this.dfCoefMaps == null ? (this.dfCoefMaps = QS.getNewDfCoefMap()) : this.dfCoefMaps;
    }

    protected static final String canonicalizeQuantumSubshellTag(String tag) {
        char firstChar = tag.charAt(0);
        if (firstChar == 'X' || firstChar == 'Y' || firstChar == 'Z') {
            char[] sorted = tag.toCharArray();
            Arrays.sort(sorted);
            return new String(sorted);
        }
        return tag;
    }

    protected int fixSlaterTypes(int typeOld, int typeNew) {
        if (this.shells == null) {
            return 0;
        }
        this.nCoef = 0;
        int i = this.shells.size();
        while (--i >= 0) {
            int[] slater = (int[])this.shells.get(i);
            if (slater[1] == typeOld) {
                slater[1] = typeNew;
            }
            int m = this.getDfCoefMaps()[slater[1]].length;
            this.nCoef += m;
        }
        return this.nCoef;
    }

    public static int getQuantumShellTagIDSpherical(String tag) {
        return QS.getQuantumShellTagIDSpherical(tag);
    }

    public static int getQuantumShellTagID(String tag) {
        return QS.getQuantumShellTagID(tag);
    }

    public static String getQuantumShellTag(int id) {
        return QS.getQuantumShellTag(id);
    }

    protected void discardPreviousAtoms() {
        this.asc.discardPreviousAtoms();
        this.moData.remove("mos");
        this.orbitals.clear();
    }

    public class MOEnergySorter
    implements Comparator<Object> {
        @Override
        public int compare(Object a, Object b) {
            float eb;
            float ea = ((Float)((Map)a).get("energy")).floatValue();
            return ea < (eb = ((Float)((Map)b).get("energy")).floatValue()) ? -1 : (ea > eb ? 1 : 0);
        }
    }
}

