/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;

public class Mesh {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    private JmolRendererInterface g3d;
    public String[] title = null;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public boolean visible = true;
    public short colix;
    public int vertexCount;
    public Point3f[] vertices;
    public short[] normixes;
    public int polygonCount;
    public int[][] polygonIndexes = null;
    public float scale = 1.0f;
    public int diameter;
    public float width;
    public Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    public String meshType = null;
    public Mesh linkedMesh = null;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public int[] modelFlags = null;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isTwoSided = true;
    public boolean isColorSolid = true;
    public static final int SEED_COUNT = 25;
    public int lighting = 0;
    public final Vector3f vAB = new Vector3f();
    public final Vector3f vAC = new Vector3f();
    protected boolean haveCheckByte;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh() {
    }

    public Mesh(String string, JmolRendererInterface jmolRendererInterface, short s) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            string = null;
        }
        this.thisID = string;
        this.g3d = jmolRendererInterface;
        this.colix = s;
    }

    public void clear(String string) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.scale = 1.0f;
        this.vertices = null;
        this.polygonIndexes = null;
        this.showPoints = false;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.showTriangles = false;
        this.frontOnly = false;
        this.meshType = string;
    }

    public void initialize(int n) {
        Vector3f[] vector3fArray = this.getVertexNormals();
        this.normixes = new short[this.vertexCount];
        this.initializeNormixes(n, vector3fArray);
    }

    public Vector3f[] getVertexNormals() {
        Vector3f[] vector3fArray = new Vector3f[this.vertexCount];
        int n = this.vertexCount;
        while (--n >= 0) {
            vector3fArray[n] = new Vector3f();
        }
        this.sumVertexNormals(vector3fArray);
        n = this.vertexCount;
        while (--n >= 0) {
            vector3fArray[n].normalize();
        }
        return vector3fArray;
    }

    public void initializeNormixes(int n, Vector3f[] vector3fArray) {
        this.isTwoSided = n == 2;
        this.normixes = new short[this.vertexCount];
        int n2 = this.vertexCount;
        while (--n2 >= 0) {
            this.normixes[n2] = this.g3d.getNormix(vector3fArray[n2]);
        }
        this.lighting = 0;
        this.setLighting(n);
    }

    public void setLighting(int n) {
        if (n == this.lighting) {
            return;
        }
        switch (n < 0 ? this.lighting : n) {
            case 1: {
                if (this.lighting == 2) {
                    this.setLighting(-1);
                }
                int n2 = this.vertexCount;
                while (--n2 >= 0) {
                    this.normixes[n2] = this.g3d.getInverseNormix(this.normixes[n2]);
                }
                break;
            }
            case 2: {
                if (n == 1) {
                    this.setLighting(-1);
                }
                int n3 = this.vertexCount;
                while (--n3 >= 0) {
                    this.normixes[n3] = ~this.normixes[n3];
                }
                break;
            }
            case 0: {
                this.setLighting(-1);
            }
        }
        this.lighting = n;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent((short)this.colix, (boolean)bl, (float)f);
    }

    public void sumVertexNormals(Vector3f[] vector3fArray) {
        Vector3f vector3f = new Vector3f();
        int n = this.haveCheckByte ? 1 : 0;
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int[] nArray = this.polygonIndexes[n2];
            try {
                if (nArray == null) continue;
                Graphics3D.calcNormalizedNormal((Point3f)this.vertices[nArray[0]], (Point3f)this.vertices[nArray[1]], (Point3f)this.vertices[nArray[2]], (Vector3f)vector3f, (Vector3f)this.vAB, (Vector3f)this.vAC);
                float f = vector3f.length();
                if (!((double)f > 0.9) || !((double)f < 1.1)) continue;
                int n3 = nArray.length - n;
                while (--n3 >= 0) {
                    int n4 = nArray[n3];
                    vector3fArray[n4].add((Tuple3f)vector3f);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void setPolygonCount(int n) {
        this.polygonCount = n;
        if (n < 0) {
            return;
        }
        if (this.polygonIndexes == null || n > this.polygonIndexes.length) {
            this.polygonIndexes = new int[n][];
        }
    }

    public int addVertexCopy(Point3f point3f) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength((Object)this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(point3f);
        return this.vertexCount++;
    }

    public void addTriangle(int n, int n2, int n3) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength((Object)this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3};
    }

    public void addQuad(int n, int n2, int n3, int n4) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength((Object)this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3, n4};
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public String getState(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.equals("mo")) {
            stringBuffer.append(" ").append(this.thisID);
        }
        stringBuffer.append(this.fillTriangles ? " fill" : " noFill");
        stringBuffer.append(this.drawTriangles ? " mesh" : " noMesh");
        stringBuffer.append(this.showPoints ? " dots" : " noDots");
        stringBuffer.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showTriangles) {
            stringBuffer.append(" triangles");
        }
        stringBuffer.append(this.lighting == 1 ? " backlit" : (this.lighting == 2 ? " fullylit" : " frontlit"));
        if (!this.visible) {
            stringBuffer.append(" off");
        }
        return stringBuffer.toString();
    }
}

