/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;

public class AlphaMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};
    private ProteinStructure proteinStructure;

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        if (n2 != n3 || nArray[2] != n2) {
            return null;
        }
        return new AlphaMonomer(chain, string, n, n2, n3, alphaOffsets);
    }

    AlphaMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
    }

    boolean isAlphaMonomer() {
        return true;
    }

    public ProteinStructure getProteinStructure() {
        return this.proteinStructure;
    }

    void setStructure(ProteinStructure proteinStructure) {
        this.proteinStructure = proteinStructure;
    }

    public byte getProteinStructureType() {
        return this.proteinStructure == null ? (byte)0 : this.proteinStructure.type;
    }

    public int getProteinStructureID() {
        return this.proteinStructure != null ? this.proteinStructure.uniqueID : -1;
    }

    public boolean isHelix() {
        return this.proteinStructure != null && this.proteinStructure.type == 3;
    }

    public boolean isSheet() {
        return this.proteinStructure != null && this.proteinStructure.type == 2;
    }

    public int setProteinStructureType(byte by, int n) {
        if (n < 0 || n > 0 && this.monomerIndex == 0) {
            int n2;
            if (this.proteinStructure != null && (n2 = this.proteinStructure.removeMonomer(this.monomerIndex)) > 0) {
                this.getBioPolymer().removeProteinStructure(this.monomerIndex + 1, n2);
            }
            switch (by) {
                case 3: {
                    this.setStructure(new Helix((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1));
                    break;
                }
                case 2: {
                    this.setStructure(new Sheet((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1));
                    break;
                }
                case 1: {
                    this.setStructure(new Turn((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1));
                    break;
                }
                case 0: {
                    this.setStructure(null);
                }
            }
        } else {
            this.setStructure(this.getBioPolymer().getProteinStructure(n));
            if (this.proteinStructure != null) {
                this.proteinStructure.addMonomer(this.monomerIndex);
            }
        }
        return this.monomerIndex;
    }

    public final Atom getAtom(byte by) {
        return by == 2 ? this.getLeadAtom() : null;
    }

    public final Point3f getAtomPoint(byte by) {
        return by == 2 ? this.getLeadAtomPoint() : null;
    }

    boolean isConnectedAfter(Monomer monomer) {
        Atom atom;
        if (monomer == null) {
            return true;
        }
        if (!(monomer instanceof AlphaMonomer)) {
            return false;
        }
        Atom atom2 = this.getLeadAtom();
        return atom2.isBonded(atom = monomer.getLeadAtom()) || atom2.distance((Point3f)atom) <= 4.2f;
    }
}

