/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class OdysseyReader
extends AtomSetCollectionReader {
    String modelName = "Odyssey file";
    int atomCount;
    int bondCount;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("odyssey)");
        try {
            this.readHeader();
            this.discardLinesUntilContains("0 1");
            if (this.line == null) {
                return this.atomSetCollection;
            }
            this.readAtoms();
            this.discardLinesUntilContains("ATOMLABELS");
            if (this.line != null) {
                this.readAtomNames();
            }
            this.discardLinesUntilContains("HESSIAN");
            if (this.line != null) {
                this.readBonds();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        if (this.atomSetCollection.getAtomCount() > 0) {
            this.atomSetCollection.setAtomSetName(this.modelName);
        }
        return this.atomSetCollection;
    }

    void readHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith(" ")) {
        }
        this.readLine();
        this.modelName = this.line + ";";
        this.modelName = this.modelName.substring(0, this.modelName.indexOf(";")).trim();
    }

    void readAtoms() throws Exception {
        this.atomCount = 0;
        while (this.readLine() != null && !this.line.startsWith("ENDCART")) {
            String[] stringArray = this.getTokens();
            int n = this.parseInt(stringArray[0]);
            String string = AtomSetCollectionReader.getElementSymbol((int)n);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            ++this.atomCount;
        }
    }

    void readAtomNames() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomSetCollection.getAtom((int)i).atomName = this.line.substring(1, this.line.length() - 1);
        }
    }

    void readBonds() throws Exception {
        int n = this.atomCount;
        while (this.readLine() != null && !this.line.startsWith("ENDHESS")) {
            String[] stringArray = this.getTokens();
            if (n == 0) {
                int n2 = this.parseInt(stringArray[0]) - 1;
                int n3 = this.parseInt(stringArray[1]) - 1;
                int n4 = this.parseInt(stringArray[2]);
                if (n4 <= 0) continue;
                this.atomSetCollection.addBond(new Bond(n2, n3, n4 < 4 ? n4 : 1));
                ++this.bondCount;
                continue;
            }
            n -= stringArray.length;
        }
        if (Logger.debugging) {
            Logger.debug((String)(this.bondCount + " bonds read"));
        }
    }
}

