/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class GamessReader
extends AtomSetCollectionReader {
    int atomCount = 0;
    int shellCount = 0;
    int gaussianCount = 0;
    String calculationType = "?";
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();
    Vector atomNames = new Vector();

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("gamess");
        try {
            this.readLine();
            boolean bl = false;
            while (this.line != null) {
                if (this.line.indexOf("COORDINATES (BOHR)") >= 0 || this.line.indexOf("COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!bl) {
                            this.readLine();
                            continue;
                        }
                        break;
                    }
                    if (this.line.indexOf("COORDINATES (BOHR)") >= 0) {
                        this.readAtomsInBohrCoordinates();
                    } else {
                        this.readAtomsInAngstromCoordinates();
                    }
                    bl = true;
                } else if (bl && this.line.indexOf("FREQUENCIES IN CM") >= 0) {
                    this.readFrequencies();
                } else {
                    if (bl && this.line.indexOf("ATOMIC BASIS SET") >= 0) {
                        this.readGaussianBasis();
                        this.moData.put("calculationType", this.calculationType);
                        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
                        continue;
                    }
                    if (bl && (this.line.indexOf("  EIGENVECTORS") >= 0 || this.line.indexOf("  MOLECULAR ORBITALS") >= 0)) {
                        this.readMolecularOrbitals();
                        this.moData.put("mos", this.orbitals);
                        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
                        continue;
                    }
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtomsInBohrCoordinates() throws Exception {
        String string;
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (string = this.parseToken(this.line, 1, 6)) != null) {
            float f = this.parseFloat(this.line, 17, 37);
            float f2 = this.parseFloat(this.line, 37, 57);
            float f3 = this.parseFloat(this.line, 57, 77);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f, f2, f3);
            atom.scale(0.5291772f);
            this.atomNames.addElement(string);
        }
    }

    void readAtomsInAngstromCoordinates() throws Exception {
        String string;
        this.readLine();
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (string = this.parseToken(this.line, 1, 6)) != null) {
            float f = this.parseFloat(this.line, 16, 31);
            float f2 = this.parseFloat(this.line, 31, 46);
            float f3 = this.parseFloat(this.line, 46, 61);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f, f2, f3);
            this.atomNames.addElement(string);
        }
    }

    void readGaussianBasis() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        Vector<String[]> vector = new Vector<String[]>();
        this.gaussianCount = 0;
        int n3 = 0;
        this.shellCount = 0;
        String string = "0";
        this.discardLinesUntilContains("SHELL TYPE");
        this.readLine();
        int[] nArray = null;
        Hashtable hashtable = new Hashtable();
        Vector<int[]> vector2 = new Vector<int[]>();
        String string2 = null;
        block4: while (this.readLine() != null && this.line.indexOf("TOTAL") < 0) {
            stringArray2 = this.getTokens();
            switch (stringArray2.length) {
                case 1: {
                    if (string2 != null) {
                        if (nArray != null) {
                            nArray[2] = n3;
                            vector2.addElement(nArray);
                            nArray = null;
                        }
                        hashtable.put(string2, vector2);
                    }
                    vector2 = new Vector();
                    string2 = stringArray2[0];
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            if (!stringArray2[0].equals(string)) {
                if (nArray != null) {
                    nArray[2] = n3;
                    vector2.addElement(nArray);
                }
                string = stringArray2[0];
                ++this.shellCount;
                nArray = new int[]{JmolAdapter.getQuantumShellTagID((String)stringArray2[1]), this.gaussianCount, 0};
                n3 = 0;
            }
            ++n3;
            ++this.gaussianCount;
            if (this.line.indexOf("(") >= 0) {
                stringArray = new String[4 + (stringArray2.length - 4) / 3];
                n2 = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[n2] = stringArray2[i];
                    if (stringArray[n2].indexOf(")") >= 0) {
                        stringArray[n2] = stringArray[n2].substring(0, stringArray[n2].indexOf(")"));
                    }
                    if (i >= 3) {
                        i += 2;
                    }
                    ++n2;
                }
                vector.addElement(stringArray);
                continue;
            }
            vector.addElement(stringArray2);
        }
        if (nArray != null) {
            nArray[2] = n3;
            vector2.addElement(nArray);
        }
        if (string2 != null) {
            hashtable.put(string2, vector2);
        }
        stringArray = new Vector();
        this.atomCount = this.atomNames.size();
        for (n2 = 0; n2 < this.atomCount; ++n2) {
            string2 = (String)this.atomNames.elementAt(n2);
            Vector vector3 = (Vector)hashtable.get(string2);
            if (vector3 == null) {
                Logger.error((String)("slater for atom " + n2 + " atomType " + string2 + " was not found in listing. Ignoring molecular orbitals"));
                return;
            }
            for (n = 0; n < vector3.size(); ++n) {
                nArray = (int[])vector3.elementAt(n);
                stringArray.addElement(new int[]{n2, nArray[0], nArray[1], nArray[2]});
            }
        }
        float[][] fArrayArray = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            stringArray2 = (String[])vector.get(i);
            fArrayArray[i] = new float[stringArray2.length - 3];
            for (n = 3; n < stringArray2.length; ++n) {
                fArrayArray[i][n - 3] = this.parseFloat(stringArray2[n]);
            }
        }
        this.moData.put("shells", stringArray);
        this.moData.put("gaussians", fArrayArray);
        if (Logger.debugging) {
            Logger.debug((String)(this.shellCount + " slater shells read"));
            Logger.debug((String)(this.gaussianCount + " gaussian primitives read"));
        }
    }

    void readMolecularOrbitals() throws Exception {
        Hashtable[] hashtableArray = null;
        Vector[] vectorArray = null;
        Vector<String> vector = null;
        this.readLine();
        int n = 0;
        while (this.readLine() != null) {
            int n2;
            String[] stringArray = this.getTokens();
            if (Logger.debugging) {
                Logger.debug((String)(stringArray.length + " --- " + this.line));
            }
            if (this.line.length() == 0 || this.line.indexOf("--") >= 0 || this.line.indexOf(".....") >= 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    float[] fArray = new float[vectorArray[n2].size()];
                    int n3 = 0;
                    while (n3 < fArray.length) {
                        if (((String)vector.get(n3)).equals("XXX")) {
                            int n4;
                            Hashtable hashtable = new Hashtable();
                            for (n4 = 0; n4 < 10; ++n4) {
                                hashtable.put(vector.get(n3 + n4), vectorArray[n2].get(n3 + n4));
                            }
                            for (n4 = 0; n4 < 10; ++n4) {
                                String string = JmolAdapter.getQuantumSubshellTag((int)5, (int)n4);
                                fArray[n3++] = this.parseFloat((String)hashtable.get(string));
                            }
                            continue;
                        }
                        fArray[n3] = this.parseFloat((String)vectorArray[n2].get(n3));
                        ++n3;
                    }
                    hashtableArray[n2].put("coefficients", fArray);
                    this.orbitals.addElement(hashtableArray[n2]);
                }
                n = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            if (n == 0) {
                n = stringArray.length;
                stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                if (hashtableArray == null || n > hashtableArray.length) {
                    hashtableArray = new Hashtable[n];
                    vectorArray = new Vector[n];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2] = new Hashtable();
                    vectorArray[n2] = new Vector();
                    hashtableArray[n2].put("energy", new Float(stringArray[n2]));
                }
                stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2].put("symmetry", stringArray[n2]);
                }
                vector = new Vector<String>();
                continue;
            }
            n2 = stringArray.length - n;
            vector.addElement(JmolAdapter.canonicalizeQuantumSubshellTag((String)stringArray[n2 - 1]));
            for (int i = 0; i < n; ++i) {
                vectorArray[i].addElement(stringArray[i + n2]);
            }
        }
        Logger.debug((String)(this.orbitals.size() + " molecular orbitals read in model " + this.modelNumber));
    }

    void readFrequencies() throws Exception {
        int n = 0;
        int n2 = this.atomSetCollection.getAtomCount();
        float[] fArray = new float[5];
        float[] fArray2 = new float[5];
        float[] fArray3 = new float[5];
        float[] fArray4 = new float[5];
        this.discardLinesUntilContains("FREQUENCY:");
        while (this.line != null && this.line.indexOf("FREQUENCY:") >= 0) {
            int n3 = n;
            int n4 = 0;
            String[] stringArray = this.getTokens();
            for (int i = 0; i < stringArray.length; ++i) {
                float f = this.parseFloat(stringArray[i]);
                if (stringArray[i].equals("I")) {
                    fArray4[n4 - 1] = -fArray4[n4 - 1];
                }
                if (Float.isNaN(f)) continue;
                fArray4[n4] = f;
                ++n4;
                if (Logger.debugging) {
                    Logger.debug((String)(n + " frequency=" + f));
                }
                if (n4 == 5) break;
            }
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            this.readLine();
            if (this.line.indexOf("MASS") >= 0) {
                stringArray2 = this.getTokens();
                this.readLine();
            }
            if (this.line.indexOf("INTENS") >= 0) {
                stringArray3 = this.getTokens();
            }
            for (int i = 0; i < n4; ++i) {
                if (++n > 1) {
                    this.atomSetCollection.cloneFirstAtomSet();
                }
                this.atomSetCollection.setAtomSetName(fArray4[i] + " cm-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", fArray4[i] + " cm-1");
                if (stringArray2 != null) {
                    this.atomSetCollection.setAtomSetProperty("Reduced Mass", stringArray2[i + 2] + " AMU");
                }
                if (stringArray3 == null) continue;
                this.atomSetCollection.setAtomSetProperty("IR Intensity", stringArray3[i + 2] + " D^2/AMU-Angstrom^2");
            }
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            this.discardLinesUntilBlank();
            for (int i = 0; i < n2; ++i) {
                this.readLine();
                this.readComponents(n4, fArray);
                this.readLine();
                this.readComponents(n4, fArray2);
                this.readLine();
                this.readComponents(n4, fArray3);
                for (int j = 0; j < n4; ++j) {
                    int n5 = (n3 + j) * n2 + i;
                    Atom atom = atomArray[n5];
                    atom.vectorX = fArray[j];
                    atom.vectorY = fArray2[j];
                    atom.vectorZ = fArray3[j];
                }
            }
            this.discardLines(12);
            this.readLine();
        }
    }

    void readComponents(int n, float[] fArray) {
        int n2 = 0;
        int n3 = 20;
        while (n2 < n) {
            fArray[n2] = this.parseFloat(this.line, n3, n3 + 12);
            ++n2;
            n3 += 12;
        }
    }
}

