/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.util.Logger;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    private float solventRadius;
    private boolean isProperty;
    private boolean doSmoothProperty;
    final Point3f ptXyzTemp = new Point3f();
    final Point3f ptS = new Point3f();

    IsoSolventReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
    }

    protected void setup() {
        super.setup();
        this.cavityRadius = this.params.cavityRadius;
        this.envelopeRadius = this.params.envelopeRadius;
        this.solventRadius = this.params.solventRadius;
        this.point = this.params.point;
        this.isCavity = this.params.isCavity && this.meshDataServer != null;
        this.isPocket = this.params.pocket != null && this.meshDataServer != null;
        this.isProperty = this.dataType == 181;
        this.doSmoothProperty = this.isProperty && this.params.propertySmoothing;
        this.doUseIterator = this.doCalculateTroughs = this.atomDataServer != null && !this.isCavity && this.solventRadius > 0.0f && (this.dataType == 171 || this.dataType == 179);
        this.modelIndex = this.params.modelIndex;
        this.getAtoms(Float.NaN, false, true);
        if (this.isCavity || this.isPocket) {
            this.meshData.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
        }
        this.setHeader("solvent/molecular surface", this.params.calculationType);
        this.setRangesAndAddAtoms(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, this.params.thePlane != null ? Integer.MAX_VALUE : Math.min(this.firstNearbyAtom, 100));
    }

    public void selectPocket(boolean bl) {
        int n;
        int n2;
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.fillMeshData(this.meshData, 1);
        Point3f[] point3fArray = this.meshData.vertices;
        int n3 = this.meshData.vertexCount;
        float[] fArray = this.meshData.vertexValues;
        Point3f[] point3fArray2 = this.meshData.dots;
        int n4 = point3fArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                if (!(point3fArray2[i].distance(point3fArray[n2]) < this.envelopeRadius)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        n2 = this.meshData.nSets;
        BitSet bitSet = new BitSet(n2);
        block2: for (n = 0; n < n2; ++n) {
            BitSet bitSet2 = this.meshData.surfaceSet[n];
            if (bitSet2 == null) continue;
            int n5 = bitSet2.length();
            while (--n5 >= 0) {
                if (!bitSet2.get(n5) || !Float.isNaN(this.meshData.vertexValues[n5])) continue;
                bitSet.set(n);
                continue block2;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.meshData.surfaceSet[n] == null || bitSet.get(n) != bl) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (!bl) {
            this.meshData.surfaceSet = null;
        }
        this.meshDataServer.fillMeshData(this.meshData, 3);
        this.meshData = new MeshData();
    }

    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        this.generateSolventCube(true);
        if (this.isCavity && this.dataType != 180 && this.dataType != 181) {
            this.generateSolventCavity();
            this.generateSolventCube(false);
        }
        if (this.params.doCapIsosurface) {
            Logger.info((String)("capping isosurface using " + this.params.cappingPlane));
            this.volumeData.capData(this.params.cappingPlane, this.params.cutoff);
        }
    }

    private void generateSolventCavity() {
        int n;
        int n2;
        int n3;
        int n4;
        BitSet bitSet = new BitSet(this.nPointsX * this.nPointsY * this.nPointsZ);
        int n5 = 0;
        int n6 = this.meshData.dots.length;
        int n7 = 0;
        float f = this.envelopeRadius;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                n2 = 0;
                while (n2 < this.nPointsZ) {
                    block9: {
                        float f2;
                        float f3 = this.voxelData[n4][n3][n2];
                        if (f2 < Float.MAX_VALUE && f3 >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(n4, n3, n2, this.ptXyzTemp);
                            for (n = 0; n < n6; ++n) {
                                if (!(this.meshData.dots[n].distance(this.ptXyzTemp) < f)) {
                                    continue;
                                }
                                break block9;
                            }
                            bitSet.set(n5);
                            ++n7;
                        }
                    }
                    ++n2;
                    ++n5;
                }
            }
        }
        Logger.info((String)("cavities include " + n7 + " voxel points"));
        this.atomRadius = new float[n7];
        this.atomXyz = new Point3f[n7];
        n3 = 0;
        n2 = 0;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n = 0; n < this.nPointsY; ++n) {
                for (int i = 0; i < this.nPointsZ; ++i) {
                    if (!bitSet.get(n3++)) continue;
                    this.atomXyz[n2] = new Point3f();
                    this.volumeData.voxelPtToXYZ(n4, n, i, this.atomXyz[n2]);
                    this.atomRadius[n2++] = this.voxelData[n4][n][i];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n7;
    }

    void generateSolventCube(boolean bl) {
        int n;
        float f;
        Point3f point3f;
        int n2;
        int n3;
        int n4;
        int n5;
        long l = System.currentTimeMillis();
        float f2 = this.params.distance;
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Point3i point3i = new Point3i();
        Point3i point3i2 = new Point3i();
        float f3 = this.doSmoothProperty ? Float.NaN : Float.MAX_VALUE;
        for (n5 = 0; n5 < this.nPointsX; ++n5) {
            for (int i = 0; i < this.nPointsY; ++i) {
                for (n4 = 0; n4 < this.nPointsZ; ++n4) {
                    this.voxelData[n5][i][n4] = f3;
                }
            }
        }
        if (this.dataType == 180) {
            return;
        }
        n5 = this.myAtomCount;
        float[][][] fArray = null;
        if (this.isProperty) {
            n5 = this.firstNearbyAtom;
            fArray = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
            f3 = this.doSmoothProperty ? 0.0f : Float.NaN;
            for (n4 = 0; n4 < this.nPointsX; ++n4) {
                for (int i = 0; i < this.nPointsY; ++i) {
                    for (n3 = 0; n3 < this.nPointsZ; ++n3) {
                        fArray[n4][i][n3] = f3;
                    }
                }
            }
        }
        float f4 = 0.0f;
        float f5 = bl && this.isCavity ? this.cavityRadius : 0.0f;
        n3 = bl && f2 != Float.MAX_VALUE ? 1 : 0;
        for (n2 = 0; n2 < n5; ++n2) {
            point3f = this.atomXyz[n2];
            f = this.atomRadius[n2];
            if (f > f4) {
                f4 = f;
            }
            if (n3 != 0 && (double)point3f.distance(this.point) > (double)(f2 + f) + 0.5) continue;
            boolean bl2 = n2 >= this.firstNearbyAtom;
            this.setGridLimitsForAtom(point3f, f + f5, point3i, point3i2);
            this.volumeData.voxelPtToXYZ(point3i.x, point3i.y, point3i.z, this.ptXyzTemp);
            for (int i = point3i.x; i < point3i2.x; ++i) {
                point3f2.set((Tuple3f)this.ptXyzTemp);
                for (int j = point3i.y; j < point3i2.y; ++j) {
                    point3f3.set((Tuple3f)this.ptXyzTemp);
                    for (n = point3i.z; n < point3i2.z; ++n) {
                        float f6 = this.ptXyzTemp.distance(point3f) - f;
                        if (this.doSmoothProperty) {
                            f6 = 1.0f / (f6 + f);
                            f6 *= f6;
                            f6 *= f6;
                            if (Float.isNaN(this.voxelData[i][j][n])) {
                                this.voxelData[i][j][n] = 0.0f;
                            }
                            float[] fArray2 = fArray[i][j];
                            int n6 = n;
                            fArray2[n6] = fArray2[n6] + this.atomProp[n2] * f6;
                            float[] fArray3 = this.voxelData[i][j];
                            int n7 = n;
                            fArray3[n7] = fArray3[n7] + f6;
                        } else if (f6 < this.voxelData[i][j][n]) {
                            float f7 = this.voxelData[i][j][n] = bl2 || n3 != 0 && this.ptXyzTemp.distance(this.point) > f2 ? Float.NaN : f6;
                            if (this.isProperty) {
                                fArray[i][j][n] = this.atomProp[n2];
                            }
                        }
                        this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.set((Tuple3f)point3f3);
                    this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[1]);
                }
                this.ptXyzTemp.set((Tuple3f)point3f2);
                this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[0]);
            }
        }
        if (this.isCavity && bl) {
            return;
        }
        if (this.doCalculateTroughs) {
            Point3i point3i3 = new Point3i();
            Point3i point3i4 = new Point3i();
            Point3i point3i5 = new Point3i();
            Point3i point3i6 = new Point3i();
            for (n = 0; n < this.firstNearbyAtom - 1; ++n) {
                if (this.atomNo[n] <= 0) continue;
                point3f = this.atomXyz[n];
                f = this.atomRadius[n] + this.solventRadius;
                int n8 = this.atomIndex[n];
                if (n3 != 0 && (double)point3f.distance(this.point) > (double)(f2 + f) + 0.5) continue;
                this.setGridLimitsForAtom(point3f, f - this.solventRadius, point3i3, point3i5);
                AtomIndexIterator atomIndexIterator = this.atomDataServer.getWithinAtomSetIterator(n8, f + this.solventRadius + f4, this.bsMySelected, true, true);
                while (atomIndexIterator.hasNext()) {
                    float f8;
                    int n9 = atomIndexIterator.next();
                    Point3f point3f4 = this.atomXyz[this.myIndex[n9]];
                    float f9 = this.atomData.atomRadius[n9] + this.solventRadius;
                    if (n3 != 0 && (double)point3f4.distance(this.point) > (double)(f2 + f9) + 0.5 || this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(point3f4)) > 2.0f * f9 || (f8 = point3f.distance(point3f4)) >= f + f9) continue;
                    this.setGridLimitsForAtom(point3f4, f9 - this.solventRadius, point3i4, point3i6);
                    point3i.x = Math.min(point3i3.x, point3i4.x);
                    point3i.y = Math.min(point3i3.y, point3i4.y);
                    point3i.z = Math.min(point3i3.z, point3i4.z);
                    point3i2.x = Math.max(point3i5.x, point3i6.x);
                    point3i2.y = Math.max(point3i5.y, point3i6.y);
                    point3i2.z = Math.max(point3i5.z, point3i6.z);
                    this.volumeData.voxelPtToXYZ(point3i.x, point3i.y, point3i.z, this.ptXyzTemp);
                    for (int i = point3i.x; i < point3i2.x; ++i) {
                        point3f2.set((Tuple3f)this.ptXyzTemp);
                        for (int j = point3i.y; j < point3i2.y; ++j) {
                            point3f3.set((Tuple3f)this.ptXyzTemp);
                            for (int k = point3i.z; k < point3i2.z; ++k) {
                                float f10;
                                float f11 = this.checkSpecialVoxel(point3f, f, point3f4, f9, f8, this.ptXyzTemp);
                                if (!Float.isNaN(f11) && (f10 = this.solventRadius - f11) < this.voxelData[i][j][k]) {
                                    this.voxelData[i][j][k] = n3 != 0 && this.ptXyzTemp.distance(this.point) > f2 ? Float.NaN : f10;
                                }
                                this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[2]);
                            }
                            this.ptXyzTemp.set((Tuple3f)point3f3);
                            this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[1]);
                        }
                        this.ptXyzTemp.set((Tuple3f)point3f2);
                        this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[0]);
                    }
                }
            }
        }
        if (this.doSmoothProperty) {
            for (n2 = 0; n2 < this.nPointsX; ++n2) {
                for (int i = 0; i < this.nPointsY; ++i) {
                    for (int j = 0; j < this.nPointsZ; ++j) {
                        if (Float.isNaN(this.voxelData[n2][i][j])) continue;
                        this.voxelData[n2][i][j] = fArray[n2][i][j] / this.voxelData[n2][i][j];
                    }
                }
            }
            return;
        }
        if (this.isProperty) {
            this.volumeData.voxelData = fArray;
            this.setVolumeData(this.volumeData);
            this.initializeVolumetricData();
        }
        if (this.params.thePlane == null) {
            for (n2 = 0; n2 < this.nPointsX; ++n2) {
                for (int i = 0; i < this.nPointsY; ++i) {
                    for (int j = 0; j < this.nPointsZ; ++j) {
                        if (this.voxelData[n2][i][j] != Float.MAX_VALUE) continue;
                        this.voxelData[n2][i][j] = Float.NaN;
                    }
                }
            }
        } else {
            f3 = 0.001f;
            for (n2 = 0; n2 < this.nPointsX; ++n2) {
                for (int i = 0; i < this.nPointsY; ++i) {
                    for (int j = 0; j < this.nPointsZ; ++j) {
                        if (this.voxelData[n2][i][j] < f3) continue;
                        this.voxelData[n2][i][j] = f3;
                    }
                }
            }
        }
        if (Logger.debugging) {
            Logger.debug((String)("solvent surface time:" + (System.currentTimeMillis() - l)));
        }
    }

    void setGridLimitsForAtom(Point3f point3f, float f, Point3i point3i, Point3i point3i2) {
        this.volumeData.xyzToVoxelPt(point3f.x - f, point3f.y - f, point3f.z - f, point3i);
        --point3i.x;
        --point3i.y;
        --point3i.z;
        if (point3i.x < 0) {
            point3i.x = 0;
        }
        if (point3i.y < 0) {
            point3i.y = 0;
        }
        if (point3i.z < 0) {
            point3i.z = 0;
        }
        this.volumeData.xyzToVoxelPt(point3f.x + f, point3f.y + f, point3f.z + f, point3i2);
        point3i2.x += 2;
        point3i2.y += 2;
        point3i2.z += 2;
        if (point3i2.x >= this.nPointsX) {
            point3i2.x = this.nPointsX;
        }
        if (point3i2.y >= this.nPointsY) {
            point3i2.y = this.nPointsY;
        }
        if (point3i2.z >= this.nPointsZ) {
            point3i2.z = this.nPointsZ;
        }
    }

    float checkSpecialVoxel(Point3f point3f, float f, Point3f point3f2, float f2, float f3, Point3f point3f3) {
        float f4 = point3f.distance(point3f3);
        float f5 = point3f2.distance(point3f3);
        float f6 = Float.NaN;
        float f7 = f / f4;
        if (f7 > 1.0f) {
            this.ptS.set(point3f.x + (point3f3.x - point3f.x) * f7, point3f.y + (point3f3.y - point3f.y) * f7, point3f.z + (point3f3.z - point3f.z) * f7);
            if (point3f2.distance(this.ptS) < f2 && !this.voxelIsInTrough(f6 = this.solventDistance(point3f3, point3f, point3f2, f, f2, f3, f4, f5), f * f, f2, f3, f4, f5)) {
                return Float.NaN;
            }
            return f6;
        }
        f7 = f2 / f5;
        if (f7 <= 1.0f) {
            return f6;
        }
        this.ptS.set(point3f2.x + (point3f3.x - point3f2.x) * f7, point3f2.y + (point3f3.y - point3f2.y) * f7, point3f2.z + (point3f3.z - point3f2.z) * f7);
        if (point3f.distance(this.ptS) < f && !this.voxelIsInTrough(f6 = this.solventDistance(point3f3, point3f2, point3f, f2, f, f3, f5, f4), f * f, f2, f3, f4, f5)) {
            return Float.NaN;
        }
        return f6;
    }

    boolean voxelIsInTrough(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (f2 + f3 * f3 - f4 * f4) / f3;
        float f8 = (f2 + f * f - f5 * f5) / f;
        return f7 < f8;
    }

    float solventDistance(Point3f point3f, Point3f point3f2, Point3f point3f3, float f, float f2, float f3, float f4, float f5) {
        double d = Math.acos((f4 * f4 + f3 * f3 - f5 * f5) / (2.0f * f4 * f3));
        double d2 = Math.acos((f3 * f3 + f * f - f2 * f2) / (2.0f * f3 * f));
        float f6 = (float)Math.sqrt((double)(f * f + f4 * f4) - (double)(2.0f * f * f4) * Math.cos(d2 - d));
        return f6;
    }
}

