/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class XplorReader
extends VolumeFileReader {
    int nBlock;
    int linePt = Integer.MAX_VALUE;
    int nRead;

    XplorReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isAngstroms = false;
        this.jvxlData.wasCubic = true;
    }

    protected int readVolumetricHeader() {
        try {
            this.readTitleLines();
            Logger.info((String)this.jvxlFileHeaderBuffer.toString());
            this.readAtomCountAndOrigin();
            Logger.info((String)("voxel grid origin:" + this.volumetricOrigin));
            this.readVoxelVectors();
            for (int i = 0; i < 3; ++i) {
                Logger.info((String)("voxel grid vector:" + this.volumetricVectors[i]));
            }
            JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
            return this.readExtraLine();
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
            throw new NullPointerException();
        }
    }

    protected void readTitleLines() throws Exception {
        int n;
        this.jvxlFileHeaderBuffer = new StringBuffer();
        int n2 = n = this.parseInt(this.getLine());
        while (--n2 >= 0) {
            this.line = this.br.readLine().trim();
            this.jvxlFileHeaderBuffer.append("# ").append(this.line).append('\n');
        }
        this.jvxlFileHeaderBuffer.append("Xplor data\nJmol " + Viewer.getJmolVersion() + '\n');
    }

    protected void readVoxelVectors() throws Exception {
        int n = this.parseInt(this.getLine());
        int n2 = this.parseInt();
        int n3 = this.parseInt();
        int n4 = this.parseInt();
        int n5 = this.parseInt();
        int n6 = this.parseInt();
        int n7 = this.parseInt();
        int n8 = this.parseInt();
        int n9 = this.parseInt();
        this.voxelCounts[0] = n9 - n8 + 1;
        this.voxelCounts[1] = n6 - n5 + 1;
        this.voxelCounts[2] = n3 - n2 + 1;
        this.nBlock = this.voxelCounts[2] * this.voxelCounts[1];
        float f = this.parseFloat(this.getLine());
        float f2 = this.parseFloat();
        float f3 = this.parseFloat();
        float f4 = this.parseFloat();
        float f5 = this.parseFloat();
        float f6 = this.parseFloat();
        UnitCell unitCell = new UnitCell(new float[]{f, f2, f3, f4, f5, f6});
        Point3f point3f = new Point3f(0.0f, 0.0f, 1.0f / (float)n7);
        unitCell.toCartesian(point3f);
        this.volumetricVectors[0].set((Tuple3f)point3f);
        point3f = new Point3f(0.0f, 1.0f / (float)n4, 0.0f);
        unitCell.toCartesian(point3f);
        this.volumetricVectors[1].set((Tuple3f)point3f);
        point3f = new Point3f(1.0f / (float)n, 0.0f, 0.0f);
        unitCell.toCartesian(point3f);
        this.volumetricVectors[2].set((Tuple3f)point3f);
        this.getLine();
    }

    protected void readAtomCountAndOrigin() throws Exception {
        this.atomCount = 0;
        this.negativeAtomCount = false;
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
    }

    private String getLine() throws IOException {
        this.line = this.br.readLine();
        while (this.line != null && (this.line.length() == 0 || this.line.indexOf("REMARKS") >= 0 || this.line.indexOf("XPLOR:") >= 0)) {
            this.line = this.br.readLine();
        }
        return this.line;
    }

    protected float nextVoxel() throws Exception {
        if (this.linePt >= this.line.length()) {
            this.line = this.br.readLine();
            this.linePt = 0;
            if (this.nRead % this.nBlock == 0) {
                System.out.println("block " + this.line);
                this.line = this.br.readLine();
            }
        }
        if (this.line == null) {
            return 0.0f;
        }
        float f = this.parseFloat(this.line.substring(this.linePt, this.linePt + 12));
        this.linePt += 12;
        ++this.nRead;
        return f;
    }
}

