/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.Date;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class AtomDataReader
extends VolumeDataReader {
    protected AtomDataServer atomDataServer;
    protected String fileName;
    protected String fileDotModel;
    protected int modelIndex;
    protected AtomData atomData = new AtomData();
    protected Point3f[] atomXyz;
    protected float[] atomRadius;
    protected float[] atomProp;
    protected int[] atomNo;
    protected int[] atomIndex;
    protected int[] myIndex;
    protected int atomCount;
    protected int myAtomCount;
    protected int nearbyAtomCount;
    protected int firstNearbyAtom;
    protected BitSet bsMySelected;
    protected BitSet bsMyIgnored;
    private Point3f xyzMin;
    private Point3f xyzMax;
    protected boolean doAddHydrogens;
    protected boolean doUsePlane;
    protected boolean doUseIterator;

    AtomDataReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
        this.precalculateVoxelData = true;
        this.atomDataServer = surfaceGenerator.getAtomDataServer();
    }

    protected void setup() {
        this.params.iUseBitSets = true;
        this.doAddHydrogens = this.atomDataServer != null && this.params.addHydrogens;
        this.modelIndex = this.params.modelIndex;
        this.xyzMin = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.xyzMax = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.bsMySelected = new BitSet();
        this.bsMyIgnored = this.params.bsIgnore == null ? new BitSet() : this.params.bsIgnore;
        boolean bl = this.doUsePlane = this.params.thePlane != null;
        if (this.doUsePlane) {
            this.volumeData.setPlaneParameters(this.params.thePlane);
        }
    }

    protected void getAtoms(float f, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        this.atomData.useIonic = this.params.useIonic;
        this.atomData.modelIndex = this.modelIndex;
        this.atomData.bsSelected = this.doUseIterator ? null : this.params.bsSelected;
        this.atomData.bsIgnored = this.bsMyIgnored;
        this.atomDataServer.fillAtomData(this.atomData, 2);
        this.atomCount = this.atomData.atomCount;
        this.modelIndex = this.atomData.firstModelIndex;
        int n4 = 0;
        boolean bl3 = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if ((this.params.bsSelected == null || this.params.bsSelected.get(i)) && !this.bsMyIgnored.get(i)) {
                if (this.doUsePlane) {
                    float f2;
                    this.atomData.atomRadius[i] = this.getWorkingRadius(i, f);
                    if (Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[i])) > 2.0f * f2) continue;
                }
                this.bsMySelected.set(i);
                ++n4;
                boolean bl4 = bl3 = !this.doUsePlane;
            }
            if (!bl2 && !bl3) continue;
            this.atomData.atomRadius[i] = this.getWorkingRadius(i, f);
        }
        float f3 = this.doAddHydrogens ? this.getWorkingRadius(-1, f) : 0.0f;
        BitSet bitSet = new BitSet();
        int n5 = -1;
        int n6 = 0;
        this.myAtomCount = 0;
        for (n3 = 0; n3 < this.atomCount; ++n3) {
            if (!this.bsMySelected.get(n3)) continue;
            ++this.myAtomCount;
            bitSet.set(n3);
            if (n5 == -1) {
                n5 = n3;
            }
            n6 = n3;
        }
        n3 = 0;
        this.atomProp = null;
        if (this.myAtomCount > 0) {
            int n7;
            int n8;
            Point3f[] point3fArray = null;
            if (this.doAddHydrogens) {
                this.atomData.bsSelected = bitSet;
                this.atomDataServer.fillAtomData(this.atomData, 3);
                n3 = this.atomData.hydrogenAtomCount;
                point3fArray = new Point3f[n3];
                for (n8 = 0; n8 < this.atomData.hAtoms.length; ++n8) {
                    if (this.atomData.hAtoms[n8] == null) continue;
                    n7 = this.atomData.hAtoms[n8].length;
                    while (--n7 >= 0) {
                        point3fArray[--n3] = this.atomData.hAtoms[n8][n7];
                    }
                }
                n3 = point3fArray.length;
                Logger.info((String)(n3 + " attached hydrogens added"));
            }
            n8 = n3 + this.myAtomCount;
            this.atomRadius = new float[n8];
            this.atomXyz = new Point3f[n8];
            if (this.params.theProperty != null) {
                this.atomProp = new float[n8];
            }
            this.atomNo = new int[n8];
            if (this.doUseIterator) {
                this.atomIndex = new int[n8];
                this.myIndex = new int[this.atomCount];
            }
            for (n7 = 0; n7 < n3; ++n7) {
                this.atomRadius[n7] = f3;
                this.atomXyz[n7] = point3fArray[n7];
                this.atomNo[n7] = -1;
                if (this.atomProp == null) continue;
                this.atomProp[n7] = Float.NaN;
            }
            this.myAtomCount = n3;
            float[] fArray = this.params.theProperty;
            for (n2 = n5; n2 <= n6; ++n2) {
                if (!bitSet.get(n2)) continue;
                if (this.atomProp != null) {
                    this.atomProp[this.myAtomCount] = fArray != null && n2 < fArray.length ? fArray[n2] : Float.NaN;
                }
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[n2];
                this.atomNo[this.myAtomCount] = this.atomData.atomicNumber[n2];
                if (this.doUseIterator) {
                    this.atomIndex[this.myAtomCount] = n2;
                    this.myIndex[n2] = this.myAtomCount;
                }
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[n2];
            }
        }
        this.firstNearbyAtom = this.myAtomCount;
        Logger.info((String)(this.myAtomCount + " atoms will be used in the surface calculation"));
        for (int i = 0; i < this.myAtomCount; ++i) {
            Point3f point3f = this.atomXyz[i];
            float f4 = this.atomRadius[i];
            if (point3f.x - f4 < this.xyzMin.x) {
                this.xyzMin.x = point3f.x - f4;
            }
            if (point3f.x + f4 > this.xyzMax.x) {
                this.xyzMax.x = point3f.x + f4;
            }
            if (point3f.y - f4 < this.xyzMin.y) {
                this.xyzMin.y = point3f.y - f4;
            }
            if (point3f.y + f4 > this.xyzMax.y) {
                this.xyzMax.y = point3f.y + f4;
            }
            if (point3f.z - f4 < this.xyzMin.z) {
                this.xyzMin.z = point3f.z - f4;
            }
            if (!(point3f.z + f4 > this.xyzMax.z)) continue;
            this.xyzMax.z = point3f.z + f4;
        }
        Logger.info((String)("surface range " + this.xyzMin + " to " + this.xyzMax));
        if (!Float.isNaN(this.params.scale)) {
            Vector3f vector3f = new Vector3f((Tuple3f)this.xyzMax);
            vector3f.sub((Tuple3f)this.xyzMin);
            vector3f.scale(0.5f);
            this.xyzMin.add((Tuple3f)vector3f);
            vector3f.scale(this.params.scale);
            this.xyzMax.set((Tuple3f)this.xyzMin);
            this.xyzMax.add((Tuple3f)vector3f);
            this.xyzMin.sub((Tuple3f)vector3f);
        }
        if (!bl2) {
            return;
        }
        Point3f point3f = new Point3f();
        BitSet bitSet2 = new BitSet();
        n5 = -1;
        n6 = 0;
        for (n = 0; n < this.atomCount; ++n) {
            if (bitSet.get(n) || this.bsMyIgnored.get(n)) continue;
            float f5 = this.atomData.atomRadius[n];
            if (this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(this.atomData.atomXyz[n])) > 2.0f * f5) continue;
            point3f = this.atomData.atomXyz[n];
            if (!(point3f.x + f5 > this.xyzMin.x) || !(point3f.x - f5 < this.xyzMax.x) || !(point3f.y + f5 > this.xyzMin.y) || !(point3f.y - f5 < this.xyzMax.y) || !(point3f.z + f5 > this.xyzMin.z) || !(point3f.z - f5 < this.xyzMax.z)) continue;
            if (n5 == -1) {
                n5 = n;
            }
            n6 = n;
            bitSet2.set(n);
            ++this.nearbyAtomCount;
        }
        n = this.myAtomCount;
        if (this.nearbyAtomCount != 0) {
            this.atomRadius = ArrayUtil.setLength((float[])this.atomRadius, (int)(n += this.nearbyAtomCount));
            this.atomXyz = (Point3f[])ArrayUtil.setLength((Object)this.atomXyz, (int)n);
            for (n2 = n5; n2 <= n6; ++n2) {
                if (!bitSet2.get(n2)) continue;
                this.atomXyz[this.myAtomCount] = this.atomData.atomXyz[n2];
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[n2];
            }
        }
    }

    private float getWorkingRadius(int n, float f) {
        if (!Float.isNaN(f)) {
            return (n < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[n]) + f;
        }
        float f2 = this.params.solventAtomRadiusAbsolute > 0.0f ? this.params.solventAtomRadiusAbsolute : (n < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[n]);
        f2 *= this.params.solventAtomRadiusFactor;
        if ((double)(f2 += this.params.solventExtendedAtomRadius + this.params.solventAtomRadiusOffset) < 0.1) {
            f2 = 0.1f;
        }
        return f2;
    }

    protected void setHeader(String string, String string2) {
        Logger.info((String)(string + " range " + this.xyzMin + " to " + this.xyzMax));
        this.jvxlFileHeaderBuffer = new StringBuffer();
        if (this.atomData.programInfo != null) {
            this.jvxlFileHeaderBuffer.append("#created by ").append(this.atomData.programInfo).append(" on ").append(new Date()).append("\n");
        }
        this.jvxlFileHeaderBuffer.append(string).append(" range ").append(this.xyzMin).append(" to ").append(this.xyzMax).append("\n").append(string2).append("\n");
    }

    protected void setRangesAndAddAtoms(float f, int n, int n2) {
        this.setVoxelRange(0, this.xyzMin.x, this.xyzMax.x, f, n);
        this.setVoxelRange(1, this.xyzMin.y, this.xyzMax.y, f, n);
        this.setVoxelRange(2, this.xyzMin.z, this.xyzMax.z, f, n);
        JvxlReader.jvxlCreateHeader(this.volumeData, n2, this.atomXyz, this.atomNo, this.jvxlFileHeaderBuffer);
    }

    protected boolean fixTitleLine(int n) {
        String string = this.params.title[n];
        if (string.indexOf("%F") > 0) {
            string = this.params.title[n] = TextFormat.formatString((String)string, (String)"F", (String)this.atomData.fileName);
        }
        if (string.indexOf("%M") > 0) {
            this.params.title[n] = TextFormat.formatString((String)string, (String)"M", (String)this.atomData.modelName);
        }
        return true;
    }
}

