/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.lang.reflect.Array;

public final class ArrayUtil {
    public static Object ensureLength(Object object, int n) {
        if (object != null && Array.getLength(object) >= n) {
            return object;
        }
        return ArrayUtil.setLength(object, n);
    }

    public static String[] ensureLength(String[] stringArray, int n) {
        if (stringArray != null && stringArray.length >= n) {
            return stringArray;
        }
        return ArrayUtil.setLength(stringArray, n);
    }

    public static float[] ensureLength(float[] fArray, int n) {
        if (fArray != null && fArray.length >= n) {
            return fArray;
        }
        return ArrayUtil.setLength(fArray, n);
    }

    public static int[] ensureLength(int[] nArray, int n) {
        if (nArray != null && nArray.length >= n) {
            return nArray;
        }
        return ArrayUtil.setLength(nArray, n);
    }

    public static short[] ensureLength(short[] sArray, int n) {
        if (sArray != null && sArray.length >= n) {
            return sArray;
        }
        return ArrayUtil.setLength(sArray, n);
    }

    public static byte[] ensureLength(byte[] byArray, int n) {
        if (byArray != null && byArray.length >= n) {
            return byArray;
        }
        return ArrayUtil.setLength(byArray, n);
    }

    public static Object doubleLength(Object object) {
        return ArrayUtil.setLength(object, object == null ? 16 : 2 * Array.getLength(object));
    }

    public static String[] doubleLength(String[] stringArray) {
        return ArrayUtil.setLength(stringArray, stringArray == null ? 16 : 2 * stringArray.length);
    }

    public static float[] doubleLength(float[] fArray) {
        return ArrayUtil.setLength(fArray, fArray == null ? 16 : 2 * fArray.length);
    }

    public static int[] doubleLength(int[] nArray) {
        return ArrayUtil.setLength(nArray, nArray == null ? 16 : 2 * nArray.length);
    }

    public static short[] doubleLength(short[] sArray) {
        return ArrayUtil.setLength(sArray, sArray == null ? 16 : 2 * sArray.length);
    }

    public static byte[] doubleLength(byte[] byArray) {
        return ArrayUtil.setLength(byArray, byArray == null ? 16 : 2 * byArray.length);
    }

    public static boolean[] doubleLength(boolean[] blArray) {
        return ArrayUtil.setLength(blArray, blArray == null ? 16 : 2 * blArray.length);
    }

    public static Object setLength(Object object, int n) {
        if (object == null) {
            return null;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        int n2 = Array.getLength(object);
        System.arraycopy(object, 0, object2, 0, n2 < n ? n2 : n);
        return object2;
    }

    public static String[] setLength(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        if (stringArray != null) {
            int n2 = stringArray.length;
            System.arraycopy(stringArray, 0, stringArray2, 0, n2 < n ? n2 : n);
        }
        return stringArray2;
    }

    public static float[] setLength(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        if (fArray != null) {
            int n2 = fArray.length;
            System.arraycopy(fArray, 0, fArray2, 0, n2 < n ? n2 : n);
        }
        return fArray2;
    }

    public static int[] setLength(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            int n2 = nArray.length;
            System.arraycopy(nArray, 0, nArray2, 0, n2 < n ? n2 : n);
        }
        return nArray2;
    }

    public static int[] arrayCopy(int[] nArray, int n, int n2, boolean bl) {
        if (nArray == null) {
            return null;
        }
        int n3 = nArray.length;
        if (n2 == -1) {
            n2 = n3;
        }
        if (n2 == -2) {
            n2 = n3 / 2;
        }
        int[] nArray2 = new int[n2 -= n];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        if (bl) {
            int n4 = n2 / 2;
            while (--n4 >= 0) {
                ArrayUtil.swap(nArray2, n4, n2 - 1 - n4);
            }
        }
        return nArray2;
    }

    public static short[] setLength(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        if (sArray != null) {
            int n2 = sArray.length;
            System.arraycopy(sArray, 0, sArray2, 0, n2 < n ? n2 : n);
        }
        return sArray2;
    }

    public static byte[] setLength(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n2 < n ? n2 : n);
        }
        return byArray2;
    }

    public static boolean[] setLength(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        if (blArray != null) {
            int n2 = blArray.length;
            System.arraycopy(blArray, 0, blArray2, 0, n2 < n ? n2 : n);
        }
        return blArray2;
    }

    public static void swap(short[] sArray, int n, int n2) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    public static String dumpArray(String string, float[][] fArray, int n, int n2, int n3, int n4) {
        int n5;
        String string2 = "dumpArray: " + string + "\n";
        for (n5 = n; n5 <= n2; ++n5) {
            string2 = string2 + "\t*" + n5 + "*";
        }
        for (n5 = n4; n5 >= n3; --n5) {
            string2 = string2 + "\n*" + n5 + "*";
            for (int i = n; i <= n2; ++i) {
                string2 = string2 + "\t" + (i < fArray.length && n5 < fArray[i].length ? fArray[i][n5] : Float.NaN);
            }
        }
        return string2;
    }

    public static String dumpIntArray(int[] nArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " " + nArray[i];
        }
        return string;
    }
}

