/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class AtomSetCollection {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "isPDB"};
    static final int GLOBAL_FRACTCOORD = 0;
    static final int GLOBAL_SYMMETRY = 1;
    static final int GLOBAL_latticeCells = 2;
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    static final String[] dictRefUnitcellTags = new String[]{"cif:_cell_length_a", "cif:_cell_length_b", "cif:cell_length_c", "cif:_cell_length_alpha", "cif:_cell_length_beta", "cif:_cell_length_gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    int[] latticeCells;
    public String errorMessage;
    boolean coordinatesAreFractional;
    boolean isTrajectory;
    int nTrajectories = 0;
    Point3f[] trajectory;
    Vector trajectories;
    float[] notionalUnitCell = new float[6];
    SpaceGroup spaceGroup;
    UnitCell unitCell;
    Vector vConnect;
    int connectNextAtomIndex = 0;
    int connectNextAtomSet = 0;
    int[] connectLast;
    float symmetryRange;
    boolean doNormalize = true;
    boolean isLatticeRange = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    Point3f[] cartesians;
    int bondCount0;
    int bondIndex0;
    boolean applySymmetryToBonds = false;
    boolean checkSpecial = true;
    Hashtable atomSymbolicMap = new Hashtable();
    VolumeData vd;

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBond(int n) {
        return this.bonds[n];
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public AtomSetCollection(String string) {
        this.fileTypeName = string;
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_KEY", ".PATH");
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    public AtomSetCollection(AtomSetCollection[] atomSetCollectionArray) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < atomSetCollectionArray.length; ++i) {
            this.appendAtomSetCollection(i, atomSetCollectionArray[i]);
        }
    }

    public AtomSetCollection(Vector vector) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        this.appendAtomSetCollection(vector);
    }

    private void appendAtomSetCollection(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                this.appendAtomSetCollection((Vector)e);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)e);
        }
    }

    public void setFileTypeName(String string) {
        this.fileTypeName = string;
    }

    boolean setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectories = new Vector();
        }
        this.isTrajectory = true;
        return true;
    }

    protected void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        Object object;
        int n2;
        int n3 = this.atomCount;
        int n4 = 0;
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            int n5;
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            this.setAtomSetAuxiliaryInfo("title", atomSetCollection.collectionName, this.currentAtomSetIndex);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            object = atomSetCollection.getAtomSetProperties(n2);
            if (object != null) {
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.setAtomSetProperty(string, ((Properties)object).getProperty(string));
                }
            }
            for (n5 = 0; n5 < atomSetCollection.atomSetAtomCounts[n2]; ++n5) {
                try {
                    this.newCloneAtom(atomSetCollection.atoms[n4]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n4;
            }
            for (n5 = 0; n5 < atomSetCollection.structureCount; ++n5) {
                if (atomSetCollection.structures[n5].modelIndex != n2 && atomSetCollection.structures[n5].modelIndex != -1) continue;
                this.addStructure(atomSetCollection.structures[n5]);
            }
            this.atomSetNames[this.currentAtomSetIndex] = atomSetCollection.atomSetNames[n2];
            this.atomSetNumbers[this.currentAtomSetIndex] = (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            object = atomSetCollection.bonds[n2];
            this.addNewBond(((Bond)object).atomIndex1 + n3, ((Bond)object).atomIndex2 + n3, ((Bond)object).order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!Boolean.TRUE.equals(atomSetCollection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n2]))) continue;
            this.setGlobalBoolean(n2);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.notionalUnitCell = null;
        this.spaceGroup = null;
        this.structures = new Structure[16];
        this.atomSetNumbers = new int[16];
        this.atomSetNames = new String[16];
        this.atomSetAtomCounts = new int[16];
        this.atomSetProperties = new Properties[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.structureCount = 0;
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
    }

    void freeze() {
        if (this.isTrajectory) {
            this.finalizeTrajectories();
        }
        this.getAltLocLists();
        this.getInsertionLists();
    }

    public void discardPreviousAtoms() {
        int n = this.atomCount;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.atomCount = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        n = this.atomSetNames.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetNames[n] = null;
        }
    }

    public void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.cloneAtom();
        this.addAtom(atom2);
        return atom2;
    }

    public void cloneFirstAtomSet() throws Exception {
        this.newAtomSet();
        int n = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    public void cloneFirstAtomSetWithBonds(int n) throws Exception {
        this.cloneFirstAtomSet();
        int n2 = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            Bond bond = this.bonds[this.bondCount - n];
            this.addNewBond(bond.atomIndex1 + n2, bond.atomIndex2 + n2, bond.order);
        }
    }

    public void cloneLastAtomSet() throws Exception {
        int n = this.getLastAtomSetAtomCount();
        int n2 = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--n >= 0) {
            this.newCloneAtom(this.atoms[n2]);
            ++n2;
        }
    }

    public int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBond(int n, int n2) {
        return this.addNewBond(n, n2, 1);
    }

    Bond addNewBond(String string, String string2) {
        return this.addNewBond(string, string2, 1);
    }

    public Bond addNewBond(int n, int n2, int n3) {
        if (n < 0 || n >= this.atomCount || n2 < 0 || n2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBond(String string, String string2, int n) {
        return this.addNewBond(this.getAtomNameIndex(string), this.getAtomNameIndex(string2), n);
    }

    public Bond addNewBondWithMappedSerialNumbers(int n, int n2, int n3) {
        return this.addNewBond(this.getAtomSerialNumberIndex(n), this.getAtomSerialNumberIndex(n2), n3);
    }

    public void addConnection(int[] nArray) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new Vector();
        }
        if (this.connectLast != null && nArray[0] == this.connectLast[0] && nArray[1] == this.connectLast[1] && nArray[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = nArray;
        this.vConnect.addElement(nArray);
    }

    public void connectAll(int n) {
        if (this.vConnect == null) {
            return;
        }
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetCollectionAuxiliaryInfo("someModelsHaveCONECT", Boolean.TRUE);
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_firstAtom_count_max", new int[]{n2, this.atomSetAtomCounts[i], n}, i);
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_bonds", this.vConnect, i);
            n2 += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = n2;
    }

    public void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
    }

    void setAtomSetSpaceGroupName(String string) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", string + "");
    }

    void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.setAtomSetCollectionAuxiliaryInfo("symmetryRange", new Float(f));
    }

    void setLatticeCells(int[] nArray, boolean bl) {
        this.latticeCells = nArray;
        this.isLatticeRange = (nArray[2] == 0 || nArray[2] == 1) && nArray[0] <= 555 && nArray[1] >= 555;
        this.doNormalize = !this.isLatticeRange || nArray[2] == 1;
        this.setApplySymmetryToBonds(bl);
    }

    boolean setNotionalUnitCell(float[] fArray) {
        this.notionalUnitCell = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.unitCell = new UnitCell(this.notionalUnitCell);
        return true;
    }

    void setGlobalBoolean(int n) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[n], Boolean.TRUE);
    }

    boolean addSymmetry(String string) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(this.doNormalize);
        }
        return this.spaceGroup.addSymmetry(string);
    }

    public void setLatticeParameter(int n) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(this.doNormalize);
        }
        this.spaceGroup.setLattice(n);
    }

    void applySymmetry() throws Exception {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], this.latticeCells[2]);
    }

    void applySymmetry(SpaceGroup spaceGroup) throws Exception {
        this.spaceGroup = spaceGroup;
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], this.latticeCells[2]);
    }

    void applySymmetry(int n, int n2, int n3) throws Exception {
        if (this.coordinatesAreFractional && this.spaceGroup != null) {
            this.applyAllSymmetry(n, n2, n3);
        }
    }

    private void setSymmetryMinMax(Point3f point3f) {
        if (this.rminx > point3f.x) {
            this.rminx = point3f.x;
        }
        if (this.rminy > point3f.y) {
            this.rminy = point3f.y;
        }
        if (this.rminz > point3f.z) {
            this.rminz = point3f.z;
        }
        if (this.rmaxx < point3f.x) {
            this.rmaxx = point3f.x;
        }
        if (this.rmaxy < point3f.y) {
            this.rmaxy = point3f.y;
        }
        if (this.rmaxz < point3f.z) {
            this.rmaxz = point3f.z;
        }
    }

    private boolean isInSymmetryRange(Point3f point3f) {
        return point3f.x >= this.rminx && point3f.y >= this.rminy && point3f.z >= this.rminz && point3f.x <= this.rmaxx && point3f.y <= this.rmaxy && point3f.z <= this.rmaxz;
    }

    private void applyAllSymmetry(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        boolean bl;
        int n7;
        int n8 = this.getLastAtomSetAtomCount();
        int n9 = this.getLastAtomSetAtomIndex();
        this.bondCount0 = this.bondCount;
        SymmetryOperation[] symmetryOperationArray = this.spaceGroup.getFinalOperations(this.atoms, n9, n8, this.doNormalize);
        int n10 = symmetryOperationArray.length;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (this.isLatticeRange) {
            n11 = n / 100 - 5;
            n12 = n % 100 / 10 - 5;
            n13 = n % 10 - 5;
            n = n2 / 100 - 4;
            n3 = n2 % 10 - 4;
            n2 = n2 % 100 / 10 - 4;
        }
        int n14 = (n - n11) * (n2 - n12) * (n3 - n13);
        int n15 = this.checkSpecial ? n8 * n10 * n14 : (this.symmetryRange > 0.0f ? n8 * n10 : (this.symmetryRange < 0.0f ? 1 : 1));
        this.cartesians = new Point3f[n15];
        for (n7 = 0; n7 < n8; ++n7) {
            this.atoms[n7 + n9].bsSymmetry = new BitSet(n10 * (n14 + 1));
        }
        n7 = 0;
        int[] nArray = new int[n14];
        int n16 = 0;
        int n17 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        for (n6 = n11; n6 < n; ++n6) {
            for (n5 = n12; n5 < n2; ++n5) {
                for (n4 = n13; n4 < n3; ++n4) {
                    nArray[n16++] = 555 + n6 * 100 + n5 * 10 + n4;
                    if (n6 != 0 || n5 != 0 || n4 != 0 || this.cartesians.length <= 0) continue;
                    for (n7 = 0; n7 < n8; ++n7) {
                        Atom atom = this.atoms[n9 + n7];
                        Point3f point3f = new Point3f((Point3f)atom);
                        symmetryOperationArray[0].transform(point3f);
                        this.unitCell.toCartesian(point3f);
                        atom.bsSymmetry.set(n16 * n10);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(point3f);
                        }
                        if (n7 >= n15) continue;
                        this.cartesians[n7] = point3f;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n17 = n7 = this.symmetryAddAtoms(symmetryOperationArray, n9, n8, 0, 0, 0, 0, n7, n16 * n10);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n16 = 0;
        for (n6 = n11; n6 < n; ++n6) {
            for (n5 = n12; n5 < n2; ++n5) {
                for (n4 = n13; n4 < n3; ++n4) {
                    ++n16;
                    if (n6 == 0 && n5 == 0 && n4 == 0) continue;
                    n7 = this.symmetryAddAtoms(symmetryOperationArray, n9, n8, n6, n5, n4, n17, n7, n16 * n10);
                }
            }
        }
        if (n10 > 0) {
            String[] stringArray = new String[n10];
            for (n5 = 0; n5 < n10; ++n5) {
                stringArray[n5] = "" + (this.doNormalize ? symmetryOperationArray[n5].getXyz() : symmetryOperationArray[n5].getXyzOriginal());
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(n9));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(n8));
        this.setAtomSetAuxiliaryInfo("symmetryCount", new Integer(n10));
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.spaceGroup.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.spaceGroup = null;
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setGlobalBoolean(1);
    }

    public void setCheckSpecial(boolean bl) {
        this.checkSpecial = bl;
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.applySymmetryToBonds = bl;
    }

    private int symmetryAddAtoms(SymmetryOperation[] symmetryOperationArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        boolean bl;
        boolean bl2 = n6 == 0;
        boolean bl3 = this.bondCount0 > this.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray = bl3 ? new int[n2] : null;
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        boolean bl7 = bl4 || (bl5 &= !bl2);
        boolean bl8 = this.checkSpecial || bl7;
        boolean bl9 = bl = this.checkSpecial || bl6;
        if (bl4) {
            n6 = n2;
        }
        int n9 = symmetryOperationArray.length;
        int n10 = n + n2;
        Point3f point3f = new Point3f();
        for (int i = 0; i < n9; ++i) {
            Object object;
            int n11;
            if (bl2 && symmetryOperationArray[i].getXyz().equals("x,y,z")) continue;
            int n12 = this.checkSpecial ? n7 : (bl5 ? n6 : 0);
            for (n11 = n; n11 < n10; ++n11) {
                symmetryOperationArray[i].newPoint(this.atoms[n11], point3f, n3, n4, n5);
                object = null;
                Point3f point3f2 = new Point3f(point3f);
                this.unitCell.toCartesian(point3f2);
                if (bl6) {
                    this.setSymmetryMinMax(point3f2);
                }
                if (bl8) {
                    float f2 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange(point3f2)) continue;
                    int n13 = n12;
                    while (--n13 >= 0) {
                        float f3 = point3f2.distanceSquared(this.cartesians[n13]);
                        if (this.checkSpecial && (double)f3 < 1.0E-4) {
                            object = this.atoms[n + n13];
                            break;
                        }
                        if (!bl5 || n13 >= n6 || !(f3 < f2)) continue;
                        f2 = f3;
                    }
                    if (bl5 && f2 > f) continue;
                }
                int n14 = this.atoms[n11].atomSite;
                if (object != null) {
                    if (bl3) {
                        nArray[n14] = ((Atom)object).atomIndex;
                    }
                    ((Atom)object).bsSymmetry.set(n8 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl3) {
                    nArray[n14] = this.atomCount;
                }
                Atom atom = this.newCloneAtom(this.atoms[n11]);
                atom.set((Tuple3f)point3f);
                atom.atomSite = n14;
                atom.bsSymmetry = new BitSet();
                atom.bsSymmetry.set(n8 + i);
                atom.bsSymmetry.set(i);
                if (!bl) continue;
                this.cartesians[n7++] = point3f2;
            }
            if (!bl3) continue;
            for (n11 = this.bondIndex0; n11 < this.bondCount0; ++n11) {
                object = this.bonds[n11];
                int n15 = nArray[this.atoms[((Bond)object).atomIndex1].atomSite];
                int n16 = nArray[this.atoms[((Bond)object).atomIndex2].atomSite];
                if (n15 < n10 && n16 < n10) continue;
                this.addNewBond(n15, n16, ((Bond)object).order);
            }
        }
        return n7;
    }

    public void setCollectionName(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            this.collectionName = string;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            String string = this.atoms[n].atomName;
            if (string != null) {
                this.atomSymbolicMap.put(string, new Integer(n));
            }
        }
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            int n2 = this.atoms[n].atomSerial;
            if (n2 != Integer.MIN_VALUE) {
                this.atomSymbolicMap.put(new Integer(n2), new Integer(n));
            }
        }
    }

    void mapAtomName(String string, int n) {
        this.atomSymbolicMap.put(string, new Integer(n));
    }

    public int getAtomNameIndex(String string) {
        int n = -1;
        Object v = this.atomSymbolicMap.get(string);
        if (v != null) {
            n = (Integer)v;
        }
        return n;
    }

    int getAtomSerialNumberIndex(int n) {
        int n2 = -1;
        Object v = this.atomSymbolicMap.get(new Integer(n));
        if (v != null) {
            n2 = (Integer)v;
        }
        return n2;
    }

    public void setAtomSetCollectionProperty(String string, String string2) {
        ((Hashtable)this.atomSetCollectionProperties).put(string, string2);
    }

    String getAtomSetCollectionProperty(String string) {
        return (String)((Hashtable)this.atomSetCollectionProperties).get(string);
    }

    public void setAtomSetCollectionAuxiliaryInfo(String string, Object object) {
        this.atomSetCollectionAuxiliaryInfo.put(string, object);
    }

    public boolean setAtomSetCollectionPartialCharges(String string) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(string)) {
            return false;
        }
        Vector vector = (Vector)this.atomSetCollectionAuxiliaryInfo.get(string);
        int n = vector.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)vector.get(n)).floatValue();
        }
        return true;
    }

    public void mapPartialCharge(String string, float f) {
        this.atoms[this.getAtomNameIndex((String)string)].partialCharge = f;
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String string) {
        return this.atomSetCollectionAuxiliaryInfo.get(string);
    }

    void addTrajectory() {
        if (this.trajectory.length == 0) {
            this.trajectory = new Point3f[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            this.trajectory[i] = new Point3f((Point3f)this.atoms[i]);
        }
        this.trajectories.addElement(this.trajectory);
        ++this.nTrajectories;
    }

    void finalizeTrajectories() {
        if (this.trajectory == null || this.trajectory.length == 0 || this.nTrajectories == 0) {
            return;
        }
        this.addTrajectory();
        Point3f[] point3fArray = (Point3f[])this.trajectories.get(0);
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].set((Tuple3f)point3fArray[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectories", this.trajectories);
    }

    public void newAtomSet() {
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            if (this.trajectory == null && this.atomCount > 0) {
                this.trajectory = new Point3f[0];
            }
            if (this.trajectory != null) {
                this.addTrajectory();
            }
            this.trajectory = new Point3f[this.atomCount];
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNames = ArrayUtil.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetProperties = (Properties[])ArrayUtil.doubleLength(this.atomSetProperties);
            this.atomSetAuxiliaryInfo = (Hashtable[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        if (this.atomSetCount + this.nTrajectories > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.nTrajectories] = this.atomSetCount + this.nTrajectories;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        }
        this.atomSymbolicMap.clear();
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public void setAtomSetName(String string) {
        this.setAtomSetName(string, this.currentAtomSetIndex);
    }

    public void setAtomSetName(String string, int n) {
        this.atomSetNames[n] = string;
    }

    public void setAtomSetNames(String string, int n) {
        int n2 = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(string, n2);
            --n2;
        }
    }

    public void setAtomSetNumber(int n) {
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.nTrajectories] = n;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = n;
        }
    }

    public void setAtomSetProperty(String string, String string2) {
        this.setAtomSetProperty(string, string2, this.currentAtomSetIndex);
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object) {
        this.setAtomSetAuxiliaryInfo(string, object, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String string) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(string)) {
            return false;
        }
        Vector vector = (Vector)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, string);
        int n = vector.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)vector.get(n)).floatValue();
        }
        return true;
    }

    Object getAtomSetAuxiliaryInfo(int n, String string) {
        return this.atomSetAuxiliaryInfo[n].get(string);
    }

    public void setAtomSetProperty(String string, String string2, int n) {
        if (this.atomSetProperties[n] == null) {
            this.atomSetProperties[n] = new Properties();
        }
        ((Hashtable)this.atomSetProperties[n]).put(string, string2);
    }

    void setAtomSetAuxiliaryInfo(String string, Object object, int n) {
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable();
        }
        if (object == null) {
            return;
        }
        this.atomSetAuxiliaryInfo[n].put(string, object);
    }

    public void setAtomSetProperties(String string, String string2, int n) {
        int n2 = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(string, string2, n2);
            --n2;
        }
    }

    public void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int n) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)((Hashtable)this.atomSetProperties[n]).clone();
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n];
    }

    String getAtomSetName(int n) {
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return this.atomSetNames[n];
    }

    Properties getAtomSetProperties(int n) {
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return this.atomSetProperties[n];
    }

    Hashtable getAtomSetAuxiliaryInfo(int n) {
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return this.atomSetAuxiliaryInfo[n];
    }

    boolean hasAlternateLocations() {
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getAltLocLists() {
        int n;
        if (!this.hasAlternateLocations()) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            char c = this.atoms[n].alternateLocationID;
            if (c == '\u0000' || stringArray[this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n2 = this.atoms[n].atomSetIndex;
            stringArray[n2] = stringArray[n2] + c;
        }
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("altLocs", stringArray[n], n);
        }
    }

    boolean hasInsertions() {
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].insertionCode == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getInsertionLists() {
        int n;
        if (!this.hasInsertions()) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            char c = this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n2 = this.atoms[n].atomSetIndex;
            stringArray[n2] = stringArray[n2] + c;
        }
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("insertionCodes", stringArray[n], n);
        }
    }

    public void newVolumeData() {
        this.vd = new VolumeData();
    }

    public void setVoxelCounts(int n, int n2, int n3) {
        this.vd.voxelCounts[0] = n;
        this.vd.voxelCounts[1] = n2;
        this.vd.voxelCounts[2] = n3;
    }

    public void setVolumetricVector(int n, float f, float f2, float f3) {
        this.vd.setVolumetricVector(n, f, f2, f3);
    }

    public void setVolumetricOrigin(float f, float f2, float f3) {
        this.vd.volumetricOrigin.set(f, f2, f3);
    }

    public void setVoxelData(float[][][] fArray) {
        this.vd.setVoxelData(fArray);
    }

    public Object getVolumeData() {
        VolumeData volumeData = this.vd;
        this.vd = null;
        return volumeData;
    }
}

