/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;

public class CellInfo {
    boolean coordinatesAreFractional;
    String spaceGroup;
    String[] symmetryOperations;
    String symmetryInfoString;
    private int modelIndex;
    private UnitCell unitCell;
    private Point3f periodicOriginXyz;
    private int[] cellRange;

    public boolean isPeriodic() {
        return this.periodicOriginXyz != null;
    }

    CellInfo(int n, boolean bl, Hashtable hashtable) {
        float[] fArray = (float[])hashtable.get("notionalUnitcell");
        this.cellRange = (int[])hashtable.get("unitCellRange");
        this.modelIndex = n;
        this.periodicOriginXyz = (Point3f)hashtable.get("periodicOriginXyz");
        this.spaceGroup = (String)hashtable.get("spaceGroup");
        if (this.spaceGroup == null || this.spaceGroup == "") {
            this.spaceGroup = "spacegroup unspecified";
        }
        int n2 = hashtable.containsKey("symmetryCount") ? (Integer)hashtable.get("symmetryCount") : 0;
        this.symmetryOperations = (String[])hashtable.get("symmetryOperations");
        this.symmetryInfoString = "Spacegroup: " + this.spaceGroup;
        if (this.symmetryOperations == null) {
            this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: ?\nSymmetry Operations: unspecified\n";
        } else {
            this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: " + (n2 == 0 ? 1 : n2) + "\nSymmetry Operations:";
            for (int i = 0; i < n2; ++i) {
                this.symmetryInfoString = this.symmetryInfoString + "\n" + this.symmetryOperations[i];
            }
        }
        this.symmetryInfoString = this.symmetryInfoString + "\n";
        boolean bl2 = this.coordinatesAreFractional = hashtable.containsKey("coordinatesAreFractional") ? (Boolean)hashtable.get("coordinatesAreFractional") : false;
        if (fArray == null || fArray[0] == 0.0f) {
            return;
        }
        this.unitCell = new UnitCell(fArray);
        this.showInfo();
    }

    public UnitCell getUnitCell() {
        return this.unitCell;
    }

    int[] getCellRange() {
        return this.cellRange;
    }

    float[] getNotionalUnitCell() {
        return this.unitCell == null ? null : this.unitCell.getNotionalUnitCell();
    }

    void toCartesian(Point3f point3f) {
        if (this.unitCell == null) {
            return;
        }
        this.unitCell.toCartesian(point3f);
    }

    void toFractional(Point3f point3f) {
        if (this.unitCell == null) {
            return;
        }
        this.unitCell.toFractional(point3f);
    }

    void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (!this.coordinatesAreFractional || this.symmetryOperations == null) {
            return;
        }
        this.unitCell.toUnitCell(point3f, point3f2);
    }

    void showInfo() {
        if (Logger.debugging) {
            Logger.debug("cellInfos[" + this.modelIndex + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    String getUnitCellInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }
}

