/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;

class BondIteratorSelected
implements BondIterator {
    private Bond[] bonds;
    private int bondCount;
    private short bondType;
    private int iBond;
    private BitSet bsSelected;
    private boolean bondSelectionModeOr;
    private boolean isBondBitSet;

    BondIteratorSelected(Bond[] bondArray, int n, short s, BitSet bitSet, boolean bl) {
        this.bonds = bondArray;
        this.bondCount = n;
        this.bondType = s;
        this.bsSelected = bitSet;
        this.bondSelectionModeOr = bl;
        this.isBondBitSet = false;
        this.iBond = 0;
    }

    BondIteratorSelected(Bond[] bondArray, int n, BitSet bitSet) {
        this.bonds = bondArray;
        this.bondCount = n;
        this.bsSelected = bitSet;
        this.isBondBitSet = true;
        this.iBond = 0;
    }

    public boolean hasNext() {
        while (this.iBond < this.bondCount) {
            Bond bond = this.bonds[this.iBond];
            if (this.isBondBitSet) {
                if (this.bsSelected.get(this.iBond)) {
                    return true;
                }
            } else if (this.bondType == -2 || (bond.order & this.bondType) != 0) {
                boolean bl = this.bsSelected.get(bond.atom1.atomIndex);
                boolean bl2 = this.bsSelected.get(bond.atom2.atomIndex);
                if (!this.bondSelectionModeOr && bl && bl2 || this.bondSelectionModeOr && (bl || bl2)) {
                    return true;
                }
            }
            ++this.iBond;
        }
        return false;
    }

    public int nextIndex() {
        return this.iBond;
    }

    public Bond next() {
        return this.bonds[this.iBond++];
    }
}

