/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;

public abstract class VoxelReader
implements VertexDataServer {
    protected SurfaceGenerator sg;
    protected MeshDataServer meshDataServer;
    protected ColorEncoder colorEncoder;
    protected Parameters params;
    protected MeshData meshData;
    protected JvxlData jvxlData;
    protected VolumeData volumeData;
    protected boolean isProgressive = false;
    protected boolean isXLowToHigh = false;
    private float assocCutoff = 0.3f;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    private int edgeCount;
    protected Point3f volumetricOrigin;
    protected Vector3f[] volumetricVectors;
    protected int[] voxelCounts;
    protected float[][][] voxelData;
    protected int nBytes;
    protected int nDataPoints;
    protected int nPointsX;
    protected int nPointsY;
    protected int nPointsZ;
    protected boolean isJvxl;
    protected boolean isApbsDx;
    protected int edgeFractionBase;
    protected int edgeFractionRange;
    protected int colorFractionBase;
    protected int colorFractionRange;
    protected StringBuffer jvxlFileHeaderBuffer;
    protected StringBuffer fractionData;
    protected String jvxlEdgeDataRead = "";
    protected String jvxlColorDataRead = "";
    protected boolean jvxlDataIsColorMapped;
    protected boolean jvxlDataIsPrecisionColor;
    protected boolean jvxlDataIs2dContour;
    protected float jvxlCutoff;
    protected int jvxlNSurfaceInts;
    protected char cJvxlEdgeNaN;
    protected int contourVertexCount;
    protected MarchingSquares marchingSquares;
    private MarchingCubes marchingCubes;
    protected final Point3f ptTemp = new Point3f();
    final float[] fReturn = new float[1];
    private static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};

    VoxelReader(SurfaceGenerator surfaceGenerator) {
        this.sg = surfaceGenerator;
        this.colorEncoder = surfaceGenerator.getColorEncoder();
        this.params = surfaceGenerator.getParams();
        this.marchingSquares = surfaceGenerator.getMarchingSquares();
        this.assocCutoff = this.params.assocCutoff;
        this.isXLowToHigh = this.params.isXLowToHigh;
        this.meshData = surfaceGenerator.getMeshData();
        this.jvxlData = surfaceGenerator.getJvxlData();
        this.setVolumeData(surfaceGenerator.getVolumeData());
        this.meshDataServer = surfaceGenerator.getMeshDataServer();
        this.cJvxlEdgeNaN = (char)125;
    }

    void setVolumeData(VolumeData volumeData) {
        this.nBytes = 0;
        this.volumetricOrigin = volumeData.volumetricOrigin;
        this.volumetricVectors = volumeData.volumetricVectors;
        this.voxelCounts = volumeData.voxelCounts;
        this.voxelData = volumeData.voxelData;
        this.volumeData = volumeData;
    }

    abstract void readVolumeParameters();

    abstract void readVolumeData(boolean var1);

    void jvxlUpdateInfo() {
        JvxlReader.jvxlUpdateInfo(this.jvxlData, this.params.title, this.nBytes);
    }

    boolean createIsosurface(boolean bl) {
        this.resetIsosurface();
        this.readVolumeParameters();
        this.jvxlData.insideOut = this.params.insideOut;
        if (bl) {
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1);
            }
            this.params.setMapRanges(this);
        } else {
            this.readVolumeData(false);
        }
        this.generateSurfaceData();
        this.jvxlData.jvxlFileHeader = this.jvxlFileHeaderBuffer.toString();
        this.jvxlData.cutoff = this.isJvxl ? this.jvxlCutoff : this.params.cutoff;
        this.jvxlData.pointsPerAngstrom = 1.0f / this.volumeData.volumetricVectorLengths[0];
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlPlane = this.params.thePlane;
        this.jvxlData.jvxlEdgeData = this.fractionData.toString();
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.isContoured = this.params.isContoured;
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.nEdges = this.edgeCount;
        this.jvxlData.edgeFractionBase = this.edgeFractionBase;
        this.jvxlData.edgeFractionRange = this.edgeFractionRange;
        this.jvxlData.colorFractionBase = this.colorFractionBase;
        this.jvxlData.colorFractionRange = this.colorFractionRange;
        this.jvxlData.jvxlDataIs2dContour = this.jvxlDataIs2dContour;
        this.jvxlData.jvxlDataIsColorMapped = this.jvxlDataIsColorMapped;
        this.jvxlData.isXLowToHigh = this.isXLowToHigh;
        this.jvxlData.nPointsX = this.nPointsX;
        this.jvxlData.nPointsY = this.nPointsY;
        this.jvxlData.nPointsZ = this.nPointsZ;
        if (this.jvxlDataIsColorMapped) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1);
                this.meshDataServer.fillMeshData(this.meshData, 2);
            }
            this.jvxlData.jvxlColorData = this.readColorData();
        }
        this.jvxlData.jvxlExtraLine = JvxlReader.jvxlExtraLine(this.jvxlData, 1);
        return true;
    }

    void resetIsosurface() {
        this.meshData.clear("isosurface");
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(null, 0);
        }
        this.contourVertexCount = 0;
        if (this.params.cutoff == Float.MAX_VALUE) {
            this.params.cutoff = 0.02f;
        }
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.edgeCount = 0;
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.params.mappedDataMin = Float.MAX_VALUE;
    }

    void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.voxelData = null;
        this.marchingSquares = null;
        this.sg.setMarchingSquares(null);
        this.marchingCubes = null;
    }

    protected void initializeVolumetricData() {
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.volumeData.setUnitVectors();
        this.setVolumeData(this.volumeData);
    }

    protected abstract void readVoxelData(boolean var1) throws Exception;

    protected void gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX <= 0 || this.nPointsY <= 0 || this.nPointsZ <= 0) {
            return;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            this.readVoxelData(bl);
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            throw new NullPointerException();
        }
    }

    protected void gotoData(int n, int n2) throws Exception {
    }

    protected String readColorData() {
        return "";
    }

    private void generateSurfaceData() {
        this.fractionData = new StringBuffer();
        this.contourVertexCount = 0;
        int n = -1;
        this.marchingSquares = null;
        if (this.params.isSquared || this.params.insideOut) {
            this.volumeData.filterData(this.params.isSquared, this.params.insideOut && !this.isJvxl ? this.params.cutoff * 2.0f : Float.NaN);
        }
        if (this.params.thePlane != null || this.params.isContoured) {
            this.marchingSquares = new MarchingSquares(this, this.volumeData, this.params.thePlane, this.params.nContours, this.params.thisContour, this.params.contourFromZero);
            n = this.marchingSquares.getContourType();
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
        }
        this.marchingCubes = new MarchingCubes(this, this.volumeData, this.params.isContoured, n, this.params.cutoff, this.params.isCutoffAbsolute);
        this.edgeCount = this.marchingCubes.generateSurfaceData(this.isXLowToHigh);
        if (this.isJvxl) {
            this.fractionData = new StringBuffer(this.jvxlEdgeDataRead);
        }
        this.fractionData.append('\n');
    }

    protected static boolean isInside(float f, float f2, boolean bl) {
        return MarchingCubes.isInside(f, f2, bl);
    }

    public int getSurfacePointIndex(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2) {
        int n6;
        float f4 = this.readSurfacePoint(f, bl, f2, f3, point3f, vector3f, this.fReturn);
        if (this.marchingSquares != null && this.params.isContoured) {
            return bl2 ? this.marchingSquares.addContourVertex(n, n2, n3, point3i, this.ptTemp, f) : Integer.MAX_VALUE;
        }
        int n7 = this.assocCutoff > 0.0f ? (this.fReturn[0] < this.assocCutoff ? n4 : (this.fReturn[0] > 1.0f - this.assocCutoff ? n5 : -1)) : (n6 = -1);
        if (n6 >= 0) {
            n6 = this.marchingCubes.getLinearOffset(n, n2, n3, n6);
        }
        int n8 = this.addVertexCopy(this.ptTemp, f4, n6);
        if (this.params.iAddGridPoints) {
            this.marchingCubes.calcVertexPoint(n, n2, n3, n5, this.ptTemp);
            this.addVertexCopy(f2 < f3 ? point3f : this.ptTemp, Float.NaN, -3);
            this.addVertexCopy(f2 < f3 ? this.ptTemp : point3f, Float.NaN, -3);
        }
        return n8;
    }

    protected float readSurfacePoint(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, float[] fArray) {
        float f4 = f3 - f2;
        float f5 = (f - f2) / f4;
        if (bl && (f5 < 0.0f || f5 > 1.0f)) {
            f5 = (-f - f2) / f4;
        }
        if (f5 < 0.0f || f5 > 1.0f) {
            f5 = Float.NaN;
        }
        fArray[0] = f5;
        if (!this.isJvxl) {
            this.fractionData.append(JvxlReader.jvxlFractionAsCharacter(f5, this.edgeFractionBase, this.edgeFractionRange));
        }
        float f6 = f2 + f5 * f4;
        this.ptTemp.scaleAdd(f5, vector3f, point3f);
        return f6;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        if (this.meshDataServer == null) {
            return this.meshData.addVertexCopy(point3f, f, n);
        }
        return this.meshDataServer.addVertexCopy(point3f, f, n);
    }

    public void addTriangleCheck(int n, int n2, int n3, int n4, boolean bl) {
        if (this.meshDataServer == null) {
            if (bl && !MeshData.checkCutoff(n, n2, n3, this.meshData.vertexValues)) {
                return;
            }
            this.meshData.addTriangleCheck(n, n2, n3, n4);
        } else {
            this.meshDataServer.addTriangleCheck(n, n2, n3, n4, bl);
        }
    }

    void colorIsosurface() {
        if (this.params.isSquared) {
            this.volumeData.filterData(true, Float.NaN);
        }
        if (this.params.isContoured && this.marchingSquares == null) {
            Logger.error("Isosurface error: Cannot contour this type of data.");
            return;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1);
        }
        if (this.params.isContoured) {
            this.params.setMapRanges(this);
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
            this.contourVertexCount = this.marchingSquares.generateContourData(this.jvxlDataIs2dContour);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
        }
        this.applyColorScale();
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.jvxlExtraLine = JvxlReader.jvxlExtraLine(this.jvxlData, 1);
        this.jvxlData.jvxlFileMessage = "mapped: min = " + this.params.valueMappedToRed + "; max = " + this.params.valueMappedToBlue;
    }

    void applyColorScale() {
        this.jvxlData.colorFractionBase = 35;
        this.colorFractionBase = 35;
        this.jvxlData.colorFractionRange = 90;
        this.colorFractionRange = 90;
        if (this.params.colorPhase == 0) {
            this.params.colorPhase = 1;
        }
        if (this.meshDataServer == null) {
            this.meshData.vertexColixes = new short[this.meshData.vertexCount];
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1);
            this.meshDataServer.fillMeshData(this.meshData, 2);
        }
        this.params.setMapRanges(this);
        boolean bl = this.params.isBicolorMap || this.params.colorBySign || !this.params.colorByPhase;
        this.jvxlData.isJvxlPrecisionColor = this.jvxlDataIsPrecisionColor || this.params.isContoured || this.params.remappable;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        this.jvxlData.minColorIndex = (short)-1;
        this.jvxlData.maxColorIndex = 0;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (this.params.isBicolorMap && !this.params.isContoured || this.params.colorBySign) {
            this.jvxlData.minColorIndex = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
            this.jvxlData.maxColorIndex = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
        }
        this.jvxlData.isTruncated = this.jvxlData.minColorIndex >= 0 && !this.params.isContoured;
        int n = this.meshData.vertexCount;
        while (--n >= 0) {
            float f = this.params.colorBySets ? (float)this.meshData.vertexSets[n] : (this.params.colorByPhase ? this.getPhase(this.meshData.vertices[n]) : (this.params.isBicolorMap && !this.params.isContoured ? this.meshData.vertexValues[n] : (this.jvxlDataIs2dContour ? this.marchingSquares.getInterpolatedPixelValue(this.meshData.vertices[n]) : this.volumeData.lookupInterpolatedVoxelValue(this.meshData.vertices[n]))));
            this.meshData.vertexValues[n] = f;
        }
        this.colorData();
        JvxlReader.jvxlCreateColorData(this.jvxlData, bl ? this.meshData.vertexValues : null);
        if (this.meshDataServer != null && this.params.colorBySets) {
            this.meshDataServer.fillMeshData(this.meshData, 3);
        }
    }

    private void colorData() {
        float[] fArray = this.meshData.vertexValues;
        short[] sArray = this.meshData.vertexColixes;
        float f = this.jvxlData.valueMappedToBlue;
        float f2 = this.jvxlData.valueMappedToRed;
        short s = this.jvxlData.minColorIndex;
        short s2 = this.jvxlData.maxColorIndex;
        int n = this.meshData.vertexCount;
        while (--n >= 0) {
            float f3 = fArray[n];
            if (s >= 0) {
                if (f3 <= 0.0f) {
                    sArray[n] = s;
                    continue;
                }
                if (!(f3 > 0.0f)) continue;
                sArray[n] = s2;
                continue;
            }
            if (f3 < f2) {
                f3 = f2;
            }
            if (f3 >= f) {
                f3 = f;
            }
            sArray[n] = this.getColorIndexFromPalette(f3);
        }
    }

    static int getColorPhaseIndex(String string) {
        int n = -1;
        int n2 = colorPhases.length;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(colorPhases[n2])) continue;
            n = n2;
            break;
        }
        return n;
    }

    private float getPhase(Point3f point3f) {
        switch (this.params.colorPhase) {
            case -1: 
            case 0: 
            case 1: {
                return point3f.x > 0.0f ? 1 : -1;
            }
            case 2: {
                return point3f.y > 0.0f ? 1 : -1;
            }
            case 3: {
                return point3f.z > 0.0f ? 1 : -1;
            }
            case 4: {
                return point3f.x * point3f.y > 0.0f ? 1 : -1;
            }
            case 5: {
                return point3f.y * point3f.z > 0.0f ? 1 : -1;
            }
            case 6: {
                return point3f.x * point3f.z > 0.0f ? 1 : -1;
            }
            case 7: {
                return point3f.x * point3f.x - point3f.y * point3f.y > 0.0f ? 1 : -1;
            }
            case 8: {
                return point3f.z * point3f.z * 2.0f - point3f.x * point3f.x - point3f.y * point3f.y > 0.0f ? 1 : -1;
            }
        }
        return 1.0f;
    }

    float getMinMappedValue() {
        if (this.params.colorBySets) {
            return 0.0f;
        }
        int n = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        Point3f[] point3fArray = this.meshData.vertices;
        float f = Float.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            float f2 = this.jvxlDataIs2dContour ? this.marchingSquares.getInterpolatedPixelValue(point3fArray[i]) : this.volumeData.lookupInterpolatedVoxelValue(point3fArray[i]);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    float getMaxMappedValue() {
        if (this.params.colorBySets) {
            return Math.max(this.meshData.nSets - 1, 0);
        }
        int n = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        Point3f[] point3fArray = this.meshData.vertices;
        float f = -3.4028235E38f;
        int n2 = 1;
        for (int i = 0; i < n; i += n2) {
            float f2 = this.jvxlDataIs2dContour ? this.marchingSquares.getInterpolatedPixelValue(point3fArray[i]) : this.volumeData.lookupInterpolatedVoxelValue(point3fArray[i]);
            if (f2 == Float.MAX_VALUE) {
                f2 = 0.0f;
            }
            if (!(f2 > f) || f2 == Float.MAX_VALUE) continue;
            f = f2;
        }
        return f;
    }

    protected short getColorIndexFromPalette(float f) {
        if (this.params.isColorReversed) {
            return this.colorEncoder.getColorIndexFromPalette(-f, -this.params.valueMappedToBlue, -this.params.valueMappedToRed);
        }
        return this.colorEncoder.getColorIndexFromPalette(f, this.params.valueMappedToRed, this.params.valueMappedToBlue);
    }

    void updateTriangles() {
        if (this.meshDataServer == null) {
            this.meshData.invalidateTriangles();
        } else {
            this.meshDataServer.invalidateTriangles();
        }
    }

    void updateSurfaceData() {
        this.updateTriangles();
        JvxlReader.jvxlUpdateSurfaceData(this.jvxlData, this.meshData.vertexValues, this.meshData.vertexCount, this.meshData.vertexIncrement, this.cJvxlEdgeNaN);
    }

    public void selectPocket(boolean bl) {
    }

    void excludeMinimumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1);
        }
        this.meshData.getSurfaceSet();
        int n = this.meshData.nSets;
        while (--n >= 0) {
            BitSet bitSet = this.meshData.surfaceSet[n];
            if (bitSet == null) continue;
            int n2 = 0;
            int n3 = bitSet.size();
            while (--n3 >= 0) {
                if (!bitSet.get(n3)) continue;
                ++n2;
            }
            if (n2 >= this.params.minSet) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3);
        }
    }
}

