/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

public class Mol2Reader
extends AtomSetCollectionReader {
    int nAtoms = 0;
    int atomCount = 0;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mol2");
        try {
            this.setFractionalCoordinates(false);
            this.readLine();
            this.modelNumber = 0;
            while (this.line != null) {
                if (this.line.equals("@<TRIPOS>MOLECULE") && (++this.modelNumber == this.desiredModelNumber || this.desiredModelNumber <= 0)) {
                    this.processMolecule();
                    if (this.desiredModelNumber <= 0) continue;
                    break;
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void processMolecule() throws Exception {
        boolean bl;
        String string = this.readLineTrimmed();
        this.readLine();
        this.line = this.line + " 0 0 0 0 0 0";
        this.atomCount = this.parseInt(this.line);
        int n = this.parseInt();
        int n2 = this.parseInt();
        this.readLine();
        this.readLine();
        boolean bl2 = bl = this.line.indexOf("NO_CHARGES") != 0;
        if (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.readLine() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            string = string + ": " + this.line.trim();
        }
        this.newAtomSet(string);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.atomCount, bl);
                this.atomSetCollection.setAtomSetName(string);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(n);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(n2);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.readLine();
        }
        this.nAtoms += this.atomCount;
        this.applySymmetry();
    }

    void readAtoms(int n, boolean bl) throws Exception {
        for (int i = 0; i < n; ++i) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = AtomSetCollectionReader.getTokens(this.readLine());
            atom.atomName = stringArray[1];
            this.setAtomCoord(atom, this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
            String string = stringArray[5];
            if (string.length() > 1 && string.charAt(1) == '.') {
                string = string.substring(0, 1);
            }
            if (string.length() > 2) {
                string = string.substring(0, 2);
            }
            atom.elementSymbol = string;
            if (stringArray.length <= 8) continue;
            atom.partialCharge = this.parseFloat(stringArray[8]);
        }
    }

    void readBonds(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String[] stringArray = AtomSetCollectionReader.getTokens(this.readLine());
            int n2 = this.parseInt(stringArray[1]);
            int n3 = this.parseInt(stringArray[2]);
            int n4 = this.parseInt(stringArray[3]);
            if (n4 == Integer.MIN_VALUE) {
                n4 = stringArray[3].equals("ar") ? 515 : 7;
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + n2 - 1, this.nAtoms + n3 - 1, n4));
        }
    }

    void readResInfo(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
        }
    }

    void readCrystalInfo() throws Exception {
        this.readLine();
        String[] stringArray = this.getTokens();
        if (stringArray.length < 6) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat(stringArray[i]));
        }
        String string = "";
        for (int i = 6; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        string = string == "" ? " P1" : string + " *";
        string = string.substring(1);
        this.setSpaceGroupName(string);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.setAtomCoord(atomArray[this.nAtoms + i]);
        }
    }
}

