/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.shape.Shape;
import org.jmol.shape.Text;
import org.jmol.util.Logger;

public abstract class TextShape
extends Shape {
    Hashtable texts = new Hashtable();
    Text currentText;
    Font3D currentFont;
    Object currentColor;
    Object currentBgColor;
    float currentTranslucentLevel;
    float currentBgTranslucentLevel;
    boolean isAll;
    protected int modelIndex = -1;

    protected void initModelSet() {
        this.modelIndex = -1;
        this.currentText = null;
        this.isAll = false;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("TextShape.setProperty(" + string + "," + object + ")");
        }
        if ("allOff" == string) {
            this.currentText = null;
            this.isAll = true;
            this.texts = new Hashtable();
            return;
        }
        if ("off" == string) {
            if (this.isAll) {
                this.texts = new Hashtable();
                this.isAll = false;
                this.currentText = null;
            }
            if (this.currentText == null) {
                return;
            }
            this.texts.remove(this.currentText.target);
            this.currentText = null;
            return;
        }
        if ("model" == string) {
            this.modelIndex = (Integer)object;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setModel(this.modelIndex);
                    }
                }
                return;
            }
            this.currentText.setModel(this.modelIndex);
            return;
        }
        if ("align" == string) {
            String string2 = (String)object;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setAlignment(string2);
                    }
                }
                return;
            }
            if (!this.currentText.setAlignment(string2)) {
                Logger.error("unrecognized align:" + string2);
            }
            return;
        }
        if ("bgcolor" == string) {
            this.currentBgColor = object;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setBgColix(object);
                    }
                }
                return;
            }
            this.currentText.setBgColix(object);
            return;
        }
        if ("color" == string) {
            this.currentColor = object;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setColix(object);
                    }
                }
                return;
            }
            this.currentText.setColix(object);
            return;
        }
        if ("text" == string) {
            String string3 = (String)object;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setText(string3);
                    }
                }
                return;
            }
            this.currentText.setText(string3);
            return;
        }
        if ("font" == string) {
            this.currentFont = (Font3D)object;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setFont(this.currentFont);
                    }
                }
                return;
            }
            this.currentText.setFont(this.currentFont);
            return;
        }
        if ("target" == string) {
            String string4 = (String)object;
            this.isAll = ((String)object).equals("all");
            if (this.isAll || string4.equals("none")) {
                this.currentText = null;
            }
            return;
        }
        if ("xpos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableX((Integer)object);
            }
            return;
        }
        if ("ypos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableY((Integer)object);
            }
            return;
        }
        if ("%xpos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableXPercent((Integer)object);
            }
            return;
        }
        if ("%ypos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableYPercent((Integer)object);
            }
            return;
        }
        if ("xyz" == string) {
            if (this.currentText != null) {
                this.currentText.setXYZ((Point3f)object);
            }
            return;
        }
        boolean bl = "bgtranslucency" == string;
        if (bl || "translucency" == string) {
            boolean bl2;
            boolean bl3 = bl2 = "translucent" == object;
            if (bl) {
                this.currentBgTranslucentLevel = bl2 ? this.translucentLevel : 0.0f;
            } else {
                float f = this.currentTranslucentLevel = bl2 ? this.translucentLevel : 0.0f;
            }
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration enumeration = this.texts.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Text)enumeration.nextElement()).setTranslucent(this.translucentLevel, bl);
                    }
                }
                return;
            }
            this.currentText.setTranslucent(this.translucentLevel, bl);
            return;
        }
        super.setProperty(string, object, null);
    }
}

