/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.api.JmolAppletInterface;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.util.Logger;

public class JmolAppletRegistry {
    public static Hashtable htRegistry = new Hashtable();
    String name;
    boolean mayScript;
    Applet applet;
    AppletContext appletContext;

    public JmolAppletRegistry(String string, boolean bl, Applet applet) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        this.name = string;
        this.mayScript = bl;
        this.applet = applet;
        this.appletContext = applet.getAppletContext();
        JmolAppletRegistry.checkIn(string, applet);
    }

    public synchronized Enumeration applets() {
        return htRegistry.elements();
    }

    static synchronized void checkIn(String string, Applet applet) {
        JmolAppletRegistry.cleanRegistry();
        Logger.info("AppletRegistry.checkIn(" + string + ")");
        if (string != null) {
            htRegistry.put(string, applet);
        }
        if (Logger.debugging) {
            Enumeration enumeration = htRegistry.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Logger.debug(string2 + " " + htRegistry.get(string2));
            }
        }
    }

    static synchronized void checkOut(String string) {
        htRegistry.remove(string);
    }

    static synchronized void cleanRegistry() {
        Enumeration enumeration = htRegistry.keys();
        AppletWrapper appletWrapper = null;
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                appletWrapper = (AppletWrapper)htRegistry.get(string);
                JSObject jSObject = JSObject.getWindow((Applet)appletWrapper);
                bl = (Boolean)jSObject.getMember("closed");
                if (bl || jSObject.hashCode() == 0) {
                    // empty if block
                }
                if (Logger.debugging) {
                    Logger.debug("Preserving registered applet " + string + " window: " + jSObject.hashCode());
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (!bl) continue;
            if (Logger.debugging) {
                Logger.debug("Dereferencing closed window applet " + string);
            }
            htRegistry.remove(string);
            appletWrapper.destroy();
        }
    }

    JSObject getJsoWindow() {
        JSObject jSObject = null;
        if (this.mayScript) {
            try {
                jSObject = JSObject.getWindow((Applet)this.applet);
            }
            catch (Exception exception) {
                Logger.error("exception trying to get jsoWindow");
            }
        } else {
            Logger.warn("mayScript not specified for:" + this.name);
        }
        return jSObject;
    }

    JSObject getJsoTop() {
        JSObject jSObject = null;
        JSObject jSObject2 = this.getJsoWindow();
        if (jSObject2 != null) {
            try {
                jSObject = (JSObject)jSObject2.getMember("top");
            }
            catch (Exception exception) {
                Logger.error("exception trying to get window.top");
            }
        }
        return jSObject;
    }

    public void script(String string, String string2) {
        this.scriptCallback(string, string2, null);
    }

    public void scriptCallback(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            Logger.error("no targetName specified");
            return;
        }
        if (this.tryDirect(string, string2, string3)) {
            return;
        }
        Logger.error("unable to find target:" + string);
    }

    public static synchronized Vector findApplets(String string, String string2, String string3) {
        if (string != null && string.indexOf("[") < 0) {
            string = string + "[" + string2 + "]";
        }
        Vector<String> vector = new Vector<String>();
        if (string != null && htRegistry.containsKey(string)) {
            vector.addElement(string);
            return vector;
        }
        Enumeration enumeration = htRegistry.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string3 != null && string4.equals(string3) || (string != null || string4.indexOf("[" + string2 + "]") <= 0) && !string4.equals(string)) continue;
            vector.addElement(string4);
        }
        return vector;
    }

    private synchronized boolean tryDirect(String string, String string2, String string3) {
        Object object;
        Logger.debug("tryDirect trying appletContext");
        Applet applet = this.appletContext.getApplet(string);
        if (applet == null) {
            Logger.debug("... trying registry");
            object = JmolAppletRegistry.findApplets(string, null, null);
            if (((Vector)object).size() > 0) {
                applet = htRegistry.get(((Vector)object).elementAt(0));
            }
        }
        if (applet == null) {
            Logger.error("tryDirect failed to find applet:" + string);
            return false;
        }
        if (!(applet instanceof JmolAppletInterface)) {
            Logger.error("target " + string + " is not a JmolApplet");
            return true;
        }
        object = (JmolAppletInterface)((Object)applet);
        object.scriptButton(string3 == null ? null : this.getJsoWindow(), this.name, string2, string3);
        return true;
    }
}

