/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

class TransformManager11
extends TransformManager {
    private float navigationSlabOffset;
    private float zoomFactor = Float.MAX_VALUE;
    private float prevZoomSetting;
    private float previousX;
    private float previousY;
    boolean isNavigationCentered;
    private int nHits;
    private int multiplier = 1;
    private static final int NAV_MODE_ZOOMED = -1;
    private static final int NAV_MODE_NONE = 0;
    private static final int NAV_MODE_RESET = 1;
    private static final int NAV_MODE_NEWXY = 2;
    private static final int NAV_MODE_NEWXYZ = 3;
    private static final int NAV_MODE_NEWZ = 4;
    private int navMode = 1;

    TransformManager11() {
    }

    TransformManager11(Viewer viewer) {
        super(viewer);
    }

    TransformManager11(Viewer viewer, int n, int n2) {
        super(viewer, n, n2);
    }

    protected void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
            this.zoomFactor = Float.MAX_VALUE;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.referencePlaneOffset = this.cameraDistance + (float)this.screenPixelCount / 2.0f;
        this.scalePixelsPerAngstrom = this.scale3D && !this.perspectiveDepth && !this.isNavigationMode ? 72.0f / this.scale3DAngstromsPerInch : (float)this.screenPixelCount / this.visualRange;
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        float f = 2.0f * this.modelRadius / this.visualRange * this.referencePlaneOffset;
        if (!this.isNavigationMode) {
            this.zoomFactor = Float.MAX_VALUE;
            this.modelCenterOffset = this.referencePlaneOffset;
            if (!this.scale3D || this.perspectiveDepth) {
                this.scalePixelsPerAngstrom *= this.modelCenterOffset / f * this.zoomPercent / 100.0f;
            }
            this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
            return;
        }
        if (this.zoomFactor == Float.MAX_VALUE) {
            if (this.zoomPercent > 10000.0f) {
                this.zoomPercent = 10000.0f;
            }
            this.modelCenterOffset = f * 100.0f / this.zoomPercent;
        } else if (this.prevZoomSetting != this.zoomPercentSetting) {
            this.modelCenterOffset = this.zoomRatio == 0.0f ? f * 100.0f / this.zoomPercentSetting : (this.modelCenterOffset += (1.0f - this.zoomRatio) * this.referencePlaneOffset);
            this.navMode = -1;
        }
        this.prevZoomSetting = this.zoomPercentSetting;
        this.zoomFactor = this.modelCenterOffset / this.referencePlaneOffset;
        this.zoomPercent = this.zoomFactor == 0.0f ? 10000.0f : f / this.modelCenterOffset * 100.0f;
    }

    protected float getPerspectiveFactor(float f) {
        return f <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / f;
    }

    protected void adjustTemporaryScreenPoint() {
        float f = this.point3fScreenTemp.z;
        if (Float.isNaN(f)) {
            if (!this.haveNotifiedNaN) {
                Logger.debug((String)"NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            f = 1.0f;
        } else if (f <= 0.0f) {
            f = 1.0f;
        }
        this.point3fScreenTemp.z = f;
        if (this.perspectiveDepth) {
            if (this.isNavigationMode) {
                this.point3fScreenTemp.x -= this.navigationShiftXY.x;
                this.point3fScreenTemp.y -= this.navigationShiftXY.y;
            }
            float f2 = this.getPerspectiveFactor(f);
            this.point3fScreenTemp.x *= f2;
            this.point3fScreenTemp.y *= f2;
        }
        if (this.isNavigationMode) {
            this.point3fScreenTemp.x += this.navigationOffset.x;
            this.point3fScreenTemp.y += this.navigationOffset.y;
        } else {
            this.point3fScreenTemp.x += this.fixedRotationOffset.x;
            this.point3fScreenTemp.y += this.fixedRotationOffset.y;
        }
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug((String)"NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.set((int)this.point3fScreenTemp.x, (int)this.point3fScreenTemp.y, (int)this.point3fScreenTemp.z);
    }

    protected void calcNavigationPoint() {
        float f;
        float f2 = this.getNavigationDepthPercent();
        boolean bl = this.isNavigationCentered = f2 < 100.0f && f2 > 0.0f;
        if (!this.navigating && this.navMode != 1) {
            this.navMode = this.isNavigationCentered && this.previousX == this.fixedTranslation.x && this.previousY == this.fixedTranslation.y && this.navMode != -1 ? 3 : 0;
        }
        switch (this.navMode) {
            case 1: {
                this.navigationOffset.set((float)this.width / 2.0f, (float)this.height / 2.0f, this.referencePlaneOffset);
                this.zoomFactor = Float.MAX_VALUE;
                this.calcCameraFactors();
                this.calcTransformMatrix();
                this.newNavigationCenter();
                break;
            }
            case -1: 
            case 0: {
                this.fixedRotationOffset.set((Tuple3f)this.fixedTranslation);
                this.newNavigationCenter();
                break;
            }
            case 2: {
                this.newNavigationCenter();
                break;
            }
            case 3: {
                this.matrixTransform(this.navigationCenter, this.pointT);
                f = this.pointT.z;
                this.matrixTransform(this.fixedRotationCenter, this.pointT);
                this.modelCenterOffset = this.referencePlaneOffset + (this.pointT.z - f);
                this.calcCameraFactors();
                this.calcTransformMatrix();
                break;
            }
            case 4: {
                this.navigationOffset.z = this.referencePlaneOffset;
                this.unTransformPoint(this.navigationOffset, this.navigationCenter);
            }
        }
        this.matrixTransform(this.navigationCenter, this.navigationShiftXY);
        if (this.viewer.getNavigationPeriodic()) {
            this.viewer.toUnitCell(this.navigationCenter, null);
            if ((double)this.pointT.distance(this.navigationCenter) > 0.01) {
                this.matrixTransform(this.navigationCenter, this.pointT);
                f = this.navigationShiftXY.z - this.pointT.z;
                this.modelCenterOffset += f;
                this.calcCameraFactors();
                this.calcTransformMatrix();
                this.matrixTransform(this.navigationCenter, this.navigationShiftXY);
            }
        }
        this.transformPoint(this.fixedRotationCenter, this.fixedTranslation);
        this.fixedRotationOffset.set((Tuple3f)this.fixedTranslation);
        this.previousX = this.fixedTranslation.x;
        this.previousY = this.fixedTranslation.y;
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        this.navigationOffset.z = this.referencePlaneOffset;
        this.navMode = 0;
        this.calcNavigationSlabAndDepth();
    }

    protected void calcNavigationSlabAndDepth() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (!this.slabEnabled) {
            return;
        }
        this.slabValue = (int)(this.referencePlaneOffset - this.navigationSlabOffset);
        this.depthValue = (int)((1.0f - (float)this.depthPercentSetting / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", this.getNavigationDepthPercent());
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", this.getNavigationSlabOffsetPercent());
        if (Logger.debugging) {
            Logger.debug((String)("\n\nperspectiveScale: " + this.referencePlaneOffset + " screenPixelCount: " + this.screenPixelCount + "\nmodelTrailingEdge: " + (this.modelCenterOffset + this.modelRadiusPixels) + " depthValue: " + this.depthValue + "\nmodelCenterOffset: " + this.modelCenterOffset + " modelRadiusPixels: " + this.modelRadiusPixels + "\nmodelLeadingEdge: " + (this.modelCenterOffset - this.modelRadiusPixels) + " slabValue: " + this.slabValue + "\nzoom: " + this.zoomPercent + " navDepth: " + (float)((int)(100.0f * this.getNavigationDepthPercent())) / 100.0f + " visualRange: " + this.visualRange + "\nnavX/Y/Z/modelCenterOffset: " + this.navigationOffset.x + "/" + this.navigationOffset.y + "/" + this.navigationOffset.z + "/" + this.modelCenterOffset + " navCenter:" + this.navigationCenter));
        }
    }

    private void newNavigationCenter() {
        this.isNavigationMode = false;
        this.transformPoint(this.fixedRotationCenter, this.pointT);
        this.pointT.x -= this.navigationOffset.x;
        this.pointT.y -= this.navigationOffset.y;
        float f = -this.getPerspectiveFactor(this.pointT.z);
        this.pointT.x /= f;
        this.pointT.y /= f;
        this.pointT.z = this.referencePlaneOffset;
        this.matrixUnTransform(this.pointT, this.navigationCenter);
        this.isNavigationMode = true;
    }

    boolean canNavigate() {
        return true;
    }

    protected void resetNavigationPoint(boolean bl) {
        if (this.zoomPercent < 5.0f && !this.isNavigationMode) {
            this.perspectiveDepth = true;
            this.isNavigationMode = true;
            return;
        }
        if (this.isNavigationMode) {
            this.navMode = 1;
            this.slabPercentSetting = 0;
            this.perspectiveDepth = true;
        } else if (bl) {
            this.slabPercentSetting = 100;
        }
        if (bl) {
            this.slabEnabled = this.isNavigationMode;
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.zoomPercentSetting = this.zoomPercent;
    }

    synchronized void navigate(int n, int n2) {
        if (!this.isNavigationMode) {
            return;
        }
        if (n == 0) {
            this.nHits = 0;
            this.multiplier = 1;
            if (!this.navigating) {
                return;
            }
            this.navigating = false;
            return;
        }
        ++this.nHits;
        if (this.nHits % 10 == 0) {
            this.multiplier *= this.multiplier == 4 ? 1 : 2;
        }
        boolean bl = (n2 & 1) > 0;
        boolean bl2 = (n2 & 8) > 0;
        switch (n) {
            case 38: {
                if (bl) {
                    this.navigationOffset.y -= (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                if (bl2) {
                    this.rotateXRadians(-0.0034906585f * (float)this.multiplier);
                    this.navMode = 3;
                    break;
                }
                this.modelCenterOffset -= this.viewer.getNavigationSpeed() * (float)(this.viewer.getNavigationPeriodic() ? 1 : this.multiplier);
                this.navMode = 4;
                break;
            }
            case 40: {
                if (bl) {
                    this.navigationOffset.y += (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                if (bl2) {
                    this.rotateXRadians(0.0034906585f * (float)this.multiplier);
                    this.navMode = 3;
                    break;
                }
                this.modelCenterOffset += this.viewer.getNavigationSpeed() * (float)(this.viewer.getNavigationPeriodic() ? 1 : this.multiplier);
                this.navMode = 4;
                break;
            }
            case 37: {
                if (bl) {
                    this.navigationOffset.x -= (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                this.rotateYRadians(-0.010471976f * (float)this.multiplier);
                this.navMode = 3;
                break;
            }
            case 39: {
                if (bl) {
                    this.navigationOffset.x += (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                this.rotateYRadians(0.010471976f * (float)this.multiplier);
                this.navMode = 3;
                break;
            }
            default: {
                this.navigating = false;
                this.navMode = 0;
                return;
            }
        }
        this.navigating = true;
        this.finalizeTransformParameters();
    }

    void navigate(float f, Point3f point3f) {
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, point3f, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        this.navigationCenter.set((Tuple3f)point3f);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void navigate(float f, Vector3f vector3f, float f2) {
        if (f > 0.0f) {
            this.navigateTo(f, vector3f, f2, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        this.rotateAxisAngle(vector3f, f2 / 57.29578f);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void setNavigationDepthPercent(float f, float f2) {
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, null, f2, Float.NaN, Float.NaN);
            return;
        }
        this.setNavigationDepthPercent(f2);
    }

    void navTranslate(float f, Point3f point3f) {
        this.transformPoint(point3f, this.pointT);
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, null, Float.NaN, this.pointT.x, this.pointT.y);
            return;
        }
        this.navTranslatePercent(-1.0f, this.pointT.x, this.pointT.y);
    }

    void navTranslatePercent(float f, float f2, float f3) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        if (f >= 0.0f) {
            if (!Float.isNaN(f2)) {
                f2 = (float)this.width * f2 / 100.0f + (Float.isNaN(f3) ? this.navigationOffset.x : (float)this.width / 2.0f);
            }
            if (!Float.isNaN(f3)) {
                f3 = (float)this.height * f3 / 100.0f + (Float.isNaN(f2) ? this.navigationOffset.y : (float)this.height / 2.0f);
            }
        }
        if (f > 0.0f) {
            this.navigateTo(f, null, Float.NaN, null, Float.NaN, f2, f3);
            return;
        }
        if (!Float.isNaN(f2)) {
            this.navigationOffset.x = f2;
        }
        if (!Float.isNaN(f3)) {
            this.navigationOffset.y = f3;
        }
        this.navMode = 2;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    private void navigateTo(float f, Vector3f vector3f, float f2, Point3f point3f, float f3, float f4, float f5) {
        this.ptMoveToCenter = point3f == null ? this.navigationCenter : point3f;
        int n = 30;
        int n2 = (int)(f * (float)n);
        this.viewer.setInMotion(true);
        if (f2 == 0.0f) {
            f2 = Float.NaN;
        }
        if (n2 > 1) {
            int n3 = 1000 / n;
            long l = System.currentTimeMillis();
            float f6 = this.getNavigationDepthPercent();
            float f7 = f3 - f6;
            float f8 = this.navigationOffset.x;
            float f9 = f4 - f8;
            float f10 = this.navigationOffset.y;
            float f11 = f5 - f10;
            float f12 = f2 / (float)n2;
            this.aaStepCenter.set((Tuple3f)this.ptMoveToCenter);
            this.aaStepCenter.sub((Tuple3f)this.navigationCenter);
            this.aaStepCenter.scale(1.0f / (float)n2);
            Point3f point3f2 = new Point3f(this.navigationCenter);
            for (int i = 1; i < n2; ++i) {
                this.navigating = true;
                float f13 = (float)i / ((float)n2 - 1.0f);
                if (!Float.isNaN(f2)) {
                    this.navigate(0.0f, vector3f, f12);
                }
                if (point3f != null) {
                    point3f2.add((Tuple3f)this.aaStepCenter);
                    this.navigate(0.0f, point3f2);
                }
                if (!Float.isNaN(f4) || !Float.isNaN(f5)) {
                    float f14 = Float.NaN;
                    float f15 = Float.NaN;
                    if (!Float.isNaN(f4)) {
                        f14 = f8 + f9 * f13;
                    }
                    if (!Float.isNaN(f5)) {
                        f15 = f10 + f11 * f13;
                    }
                    this.navTranslatePercent(-1.0f, f14, f15);
                }
                if (!Float.isNaN(f3)) {
                    this.setNavigationDepthPercent(f6 + f7 * f13);
                }
                this.navigating = false;
                if (System.currentTimeMillis() >= (l += (long)n3)) continue;
                this.viewer.requestRepaintAndWait();
                if (this.viewer.isScriptExecuting()) {
                    int n4 = (int)(l - System.currentTimeMillis());
                    if (n4 <= 0) continue;
                    try {
                        Thread.sleep(n4);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        } else {
            int n5 = (int)(f * 1000.0f) - 30;
            if (n5 > 0) {
                try {
                    Thread.sleep(n5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!Float.isNaN(f4) || !Float.isNaN(f5)) {
            this.navTranslatePercent(-1.0f, f4, f5);
        }
        if (!Float.isNaN(f3)) {
            this.setNavigationDepthPercent(f3);
        }
        this.viewer.setInMotion(false);
    }

    void navigate(float f, Point3f[][] point3fArray) {
        this.navigate(f, point3fArray, null, null, 0, Integer.MAX_VALUE);
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
        this.navigate(f, null, point3fArray, fArray, n, n2);
    }

    void navigate(float f, Point3f[][] point3fArray, Point3f[] point3fArray2, float[] fArray, int n, int n2) {
        int n3;
        int n4;
        if (f <= 0.0f) {
            f = 2.0f;
        }
        boolean bl = point3fArray != null;
        if (!bl) {
            for (n4 = Math.min((bl ? point3fArray.length : point3fArray2.length) - 1, n2); n4 > 0 && point3fArray2[n4] == null; --n4) {
            }
        }
        if ((n4 -= n) < 1) {
            return;
        }
        int n5 = (int)(10.0f * f);
        int n6 = n4 * n5 + 1;
        Point3f[] point3fArray3 = new Point3f[n6 + 2];
        Point3f[] point3fArray4 = new Point3f[bl ? n6 + 2 : 0];
        for (n3 = 0; n3 < n4; ++n3) {
            int n7 = Math.max(n3 - 1, 0) + n;
            int n8 = n3 + n;
            int n9 = Math.min(n3 + 1, n4) + n;
            int n10 = Math.min(n3 + 2, n4) + n;
            int n11 = Math.min(n3 + 3, n4) + n;
            if (bl) {
                Graphics3D.getHermiteList((int)7, (Tuple3f)point3fArray[n7][0], (Tuple3f)point3fArray[n8][0], (Tuple3f)point3fArray[n9][0], (Tuple3f)point3fArray[n10][0], (Tuple3f)point3fArray[n11][0], (Tuple3f[])point3fArray3, (int)(n3 * n5), (int)(n5 + 1));
                Graphics3D.getHermiteList((int)7, (Tuple3f)point3fArray[n7][1], (Tuple3f)point3fArray[n8][1], (Tuple3f)point3fArray[n9][1], (Tuple3f)point3fArray[n10][1], (Tuple3f)point3fArray[n11][1], (Tuple3f[])point3fArray4, (int)(n3 * n5), (int)(n5 + 1));
                continue;
            }
            Graphics3D.getHermiteList((int)7, (Tuple3f)point3fArray2[n7], (Tuple3f)point3fArray2[n8], (Tuple3f)point3fArray2[n9], (Tuple3f)point3fArray2[n10], (Tuple3f)point3fArray2[n11], (Tuple3f[])point3fArray3, (int)(n3 * n5), (int)(n5 + 1));
        }
        n3 = 10;
        int n12 = n6;
        this.viewer.setInMotion(true);
        int n13 = 1000 / n3;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n12; ++i) {
            this.navigate(0.0f, point3fArray3[i]);
            if (bl) {
                this.alignZX(point3fArray3[i], point3fArray3[i + 1], point3fArray4[i]);
            }
            if (System.currentTimeMillis() >= (l += (long)n13)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) break;
            int n14 = (int)(l - System.currentTimeMillis());
            if (n14 <= 0) continue;
            try {
                Thread.sleep(n14);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void alignZX(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Point3f point3f4 = new Point3f();
        Point3f point3f5 = new Point3f();
        this.matrixRotate.transform((Tuple3f)point3f, (Tuple3f)point3f4);
        this.matrixRotate.transform((Tuple3f)point3f2, (Tuple3f)point3f5);
        Vector3f vector3f = new Vector3f((Tuple3f)point3f4);
        vector3f.sub((Tuple3f)point3f5);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        float f = vector3f.angle(vector3f2);
        vector3f2.cross(vector3f, vector3f2);
        if (f != 0.0f) {
            this.navigate(0.0f, vector3f2, f * 57.29578f);
        }
        this.matrixRotate.transform((Tuple3f)point3f, (Tuple3f)point3f4);
        Point3f point3f6 = new Point3f(point3f3);
        point3f6.add((Tuple3f)point3f);
        Point3f point3f7 = new Point3f();
        this.matrixRotate.transform((Tuple3f)point3f6, (Tuple3f)point3f7);
        vector3f.set((Tuple3f)point3f7);
        vector3f.sub((Tuple3f)point3f4);
        vector3f.z = 0.0f;
        vector3f2.set(-1.0f, 0.0f, 0.0f);
        f = vector3f.angle(vector3f2);
        if (vector3f.y < 0.0f) {
            f = -f;
        }
        vector3f2.set(0.0f, 0.0f, 1.0f);
        if (f != 0.0f) {
            this.navigate(0.0f, vector3f2, f * 57.29578f);
        }
        this.matrixRotate.transform((Tuple3f)point3f, (Tuple3f)point3f4);
        this.matrixRotate.transform((Tuple3f)point3f2, (Tuple3f)point3f5);
        this.matrixRotate.transform((Tuple3f)point3f3, (Tuple3f)point3f7);
    }

    void setNavigationCenter(Point3f point3f) {
        this.navigate(0.0f, point3f);
    }

    Point3f getNavigationCenter() {
        return this.navigationCenter;
    }

    boolean isNavigationCentered() {
        return this.isNavigationCentered;
    }

    void setNavigationSlabOffsetPercent(float f) {
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", f);
        this.calcCameraFactors();
        this.navigationSlabOffset = f / 50.0f * this.modelRadiusPixels;
    }

    float getNavigationSlabOffsetPercent() {
        this.calcCameraFactors();
        return 50.0f * this.navigationSlabOffset / this.modelRadiusPixels;
    }

    Point3f getNavigationOffset() {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        return this.navigationOffset;
    }

    void setNavigationDepthPercent(float f) {
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", f);
        this.calcCameraFactors();
        this.modelCenterOffset = this.referencePlaneOffset - (1.0f - f / 50.0f) * this.modelRadiusPixels;
        this.calcCameraFactors();
        this.navMode = -1;
    }

    float getNavigationDepthPercent() {
        this.calcCameraFactors();
        return 50.0f * (1.0f + (this.modelCenterOffset - this.referencePlaneOffset) / this.modelRadiusPixels);
    }

    float getNavigationOffsetPercent(char c) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        return c == 'X' ? (this.navigationOffset.x - (float)this.width / 2.0f) * 100.0f / (float)this.width : (this.navigationOffset.y - (float)this.height / 2.0f) * 100.0f / (float)this.height;
    }

    protected String getNavigationText(boolean bl) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        return (bl ? " /* navigation center, translation, depth */ " : " ") + Escape.escape((Tuple3f)this.navigationCenter) + " " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + " " + this.getNavigationDepthPercent();
    }

    protected String getNavigationState() {
        if (!this.isNavigationMode) {
            return "";
        }
        return "# navigation state;\nnavigate 0 center " + Escape.escape((Tuple3f)this.getNavigationCenter()) + ";\nnavigate 0 translate " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + ";\nset navigationDepth " + this.getNavigationDepthPercent() + ";\nset navigationSlab " + this.getNavigationSlabOffsetPercent() + ";\n\n";
    }
}

