/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.MonitorInputStream;
import org.jmol.viewer.Viewer;

public class FileManager {
    private Viewer viewer;
    private String openErrorMessage;
    JmolAdapter modelAdapter;
    private URL appletDocumentBase = null;
    private URL appletCodeBase = null;
    private String appletProxy;
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String fileName;
    private String fileType;
    private String inlineData;
    private String loadScript;
    FileOpenThread fileOpenThread;
    FilesOpenThread filesOpenThread;
    private DOMOpenThread aDOMOpenThread;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};

    String getInlineData(int n) {
        return n < 0 ? this.inlineData : "";
    }

    FileManager(Viewer viewer, JmolAdapter jmolAdapter) {
        this.viewer = viewer;
        this.modelAdapter = jmolAdapter;
        this.clear();
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setFileState;\n");
            stringBuffer2.append("function _setFileState();\n\n");
        }
        stringBuffer2.append(this.loadScript);
        if (this.viewer.getModelSetFileName().equals("zapped")) {
            stringBuffer2.append("  zap;\n");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\nend function;\n\n");
        }
        return stringBuffer2.toString();
    }

    String getFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        Object object = this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, true);
        if (object instanceof BufferedReader) {
            return this.modelAdapter.getFileTypeName((Object)((BufferedReader)object));
        }
        if (object instanceof ZipInputStream) {
            String string2 = this.getZipDirectoryAsString(string);
            return this.modelAdapter.getFileTypeName((Object)this.getBufferedReaderForString(string2));
        }
        if (object instanceof String[]) {
            return ((String[])object)[0];
        }
        return null;
    }

    void clear() {
        this.setLoadScript("", false);
    }

    String getLoadScript() {
        return this.loadScript;
    }

    private void setLoadScript(String string, boolean bl) {
        if (this.loadScript == null || !bl) {
            this.loadScript = "";
        }
        this.loadScript = this.loadScript + this.viewer.getLoadState();
        this.addLoadScript(string);
    }

    void addLoadScript(String string) {
        if (string == null) {
            return;
        }
        this.loadScript = this.loadScript + "  " + string + ";\n";
    }

    void openFile(String string, Hashtable hashtable, String string2, boolean bl) {
        this.setLoadScript(string2, bl);
        int n = string.indexOf("::");
        this.nameAsGiven = n >= 0 ? string.substring(n + 2) : string;
        this.fileType = n >= 0 ? string.substring(0, n) : null;
        Logger.info((String)("\nFileManager.openFile(" + this.nameAsGiven + ") //" + string));
        this.fileName = null;
        this.fullPathName = null;
        this.openErrorMessage = null;
        this.setNames(this.classifyName(this.nameAsGiven));
        hashtable.put("fullPathName", (this.fileType == null ? "" : this.fileType + "::") + this.fullPathName.replace('\\', '/'));
        if (this.openErrorMessage != null) {
            Logger.error((String)("file ERROR: " + this.openErrorMessage));
            return;
        }
        this.fileOpenThread = new FileOpenThread(this.fullPathName, this.nameAsGiven, this.fileType, null, hashtable);
        this.fileOpenThread.run();
    }

    void openFiles(String string, String[] stringArray, String string2, boolean bl) {
        this.setLoadScript(string2, bl);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            this.nameAsGiven = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            this.fileType = n >= 0 ? stringArray[i].substring(0, n) : null;
            this.fileName = null;
            this.fullPathName = null;
            this.openErrorMessage = null;
            this.setNames(this.classifyName(this.nameAsGiven));
            if (this.openErrorMessage != null) {
                Logger.error((String)("file ERROR: " + this.openErrorMessage));
                return;
            }
            stringArray2[i] = this.fullPathName;
            stringArray[i] = this.fullPathName.replace('\\', '/');
            stringArray4[i] = this.fileType;
            stringArray3[i] = this.nameAsGiven;
        }
        this.fileName = this.nameAsGiven = string;
        this.fullPathName = this.nameAsGiven;
        this.inlineData = "";
        this.filesOpenThread = new FilesOpenThread(stringArray2, stringArray3, stringArray4, null);
        this.filesOpenThread.run();
    }

    void openStringInline(String string, Hashtable hashtable, boolean bl) {
        String string2 = bl ? "append" : "model";
        String string3 = "data \"" + string2 + " inline\"" + string + "end \"" + string2 + " inline\";";
        this.setLoadScript(string3, bl);
        Logger.info((String)"FileManager.openStringInline()");
        this.openErrorMessage = null;
        this.fileName = "string";
        this.fullPathName = "string";
        this.inlineData = string;
        this.fileOpenThread = new FileOpenThread("string", "string", null, this.getBufferedReaderForString(string), hashtable);
        this.fileOpenThread.run();
    }

    void openStringsInline(String[] stringArray, Hashtable hashtable, boolean bl) {
        String string = "\"" + this.viewer.getDataSeparator() + "\"";
        String string2 = "\"" + (bl ? "append" : "model") + " inline\"";
        String string3 = "set dataSeparator \"~~~next file~~~\";\ndata " + string2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string3 = string3 + "~~~next file~~~";
            }
            string3 = string3 + stringArray[i];
        }
        string3 = string3 + "end " + string2 + ";set dataSeparator " + string;
        this.setLoadScript(string3, bl);
        Logger.info((String)"FileManager.openStringsInline(string[])");
        this.openErrorMessage = null;
        this.fileName = "string[]";
        this.fullPathName = "string[]";
        this.inlineData = "";
        String[] stringArray2 = new String[stringArray.length];
        Reader[] readerArray = new StringReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            readerArray[i] = new StringReader(stringArray[i]);
        }
        this.filesOpenThread = new FilesOpenThread(stringArray2, stringArray2, null, readerArray);
        this.filesOpenThread.run();
    }

    void openDOM(Object object) {
        this.openErrorMessage = null;
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        this.inlineData = "";
        this.aDOMOpenThread = new DOMOpenThread(object);
        this.aDOMOpenThread.run();
    }

    void openReader(String string, String string2, Reader reader) {
        this.openBufferedReader(string, string2, new BufferedReader(reader));
    }

    private void openBufferedReader(String string, String string2, BufferedReader bufferedReader) {
        this.openErrorMessage = null;
        this.fullPathName = string;
        this.fileName = string2;
        this.fileType = null;
        this.fileOpenThread = new FileOpenThread(string, string, this.fileType, bufferedReader, null);
        this.fileOpenThread.run();
    }

    static boolean isGzip(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 31 && byArray[1] == -117;
    }

    public Object getFileAsBytes(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split((String)string, (String)"|");
            string = stringArray[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, false)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (ZipUtil.isZipFile((InputStream)bufferedInputStream2) && stringArray != null && 1 < stringArray.length) {
                return ZipUtil.getZipFileContentsAsBytes((InputStream)bufferedInputStream2, (String[])stringArray, (int)1);
            }
            return ZipUtil.getStreamAsBytes((BufferedInputStream)bufferedInputStream);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    String getFileAsString(String string) {
        Object object;
        if (string == null) {
            return "";
        }
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split((String)string, (String)"|");
            string = stringArray[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, false)) instanceof String) {
            return "Error:" + object;
        }
        try {
            String string2;
            BufferedInputStream bufferedInputStream;
            FilterInputStream filterInputStream = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument((InputStream)filterInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return "" + compoundDocument.getAllData();
            }
            if (FileManager.isGzip(filterInputStream)) {
                filterInputStream = new GZIPInputStream(bufferedInputStream);
            } else if (ZipUtil.isZipFile((InputStream)filterInputStream)) {
                return ZipUtil.getZipFileContents((InputStream)filterInputStream, (String[])stringArray, (int)1);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(filterInputStream));
            StringBuffer stringBuffer = new StringBuffer(8192);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    Object waitForClientFileOrErrorMessage() {
        Object object = null;
        if (this.fileOpenThread != null) {
            object = this.fileOpenThread.clientFile;
            if (this.fileOpenThread.errorMessage != null) {
                this.openErrorMessage = this.fileOpenThread.errorMessage;
            } else if (object == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.fileOpenThread = null;
        } else if (this.filesOpenThread != null) {
            object = this.filesOpenThread.clientFile;
            if (this.filesOpenThread.errorMessage != null) {
                this.openErrorMessage = this.filesOpenThread.errorMessage;
            } else if (object == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.filesOpenThread = null;
        } else if (this.aDOMOpenThread != null) {
            object = this.aDOMOpenThread.clientFile;
            if (this.aDOMOpenThread.errorMessage != null) {
                this.openErrorMessage = this.aDOMOpenThread.errorMessage;
            } else if (object == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.aDOMOpenThread = null;
        }
        if (this.openErrorMessage != null) {
            return this.openErrorMessage;
        }
        return object;
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    void setFileInfo(String[] stringArray) {
        try {
            this.fullPathName = stringArray[0];
            this.fileName = stringArray[1];
            this.inlineData = stringArray[2];
            this.loadScript = stringArray[3];
        }
        catch (Exception exception) {
            Logger.error((String)("Exception saving file info: " + exception.getMessage()));
        }
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.inlineData, this.loadScript};
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        if (this.appletDocumentBase == null) {
            return "";
        }
        return this.appletDocumentBase.toString();
    }

    void setAppletContext(URL uRL, URL uRL2, String string) {
        this.appletDocumentBase = uRL;
        this.appletCodeBase = uRL2;
        Logger.info((String)("appletDocumentBase=" + this.appletDocumentBase + "\nappletCodeBase=" + this.appletCodeBase));
        this.appletProxy = string;
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    private void setNames(String[] stringArray) {
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
    }

    private String[] classifyName(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[2];
        if (string.indexOf("=") == 0) {
            string = TextFormat.formatString((String)this.viewer.getLoadFormat(), (String)"FILE", (String)string.substring(1));
        }
        if ((string2 = this.viewer.getDefaultDirectory()).length() != 0 && string.indexOf(":") < 0) {
            string = string2 + "/" + string;
        }
        if (this.appletDocumentBase != null) {
            try {
                URL uRL = new URL(this.appletDocumentBase, string);
                stringArray[0] = uRL.toString();
                stringArray[1] = stringArray[0].substring(stringArray[0].lastIndexOf(47) + 1, stringArray[0].length());
            }
            catch (MalformedURLException malformedURLException) {
                this.openErrorMessage = malformedURLException.getMessage();
            }
            return stringArray;
        }
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            try {
                URL uRL = new URL(string);
                stringArray[0] = uRL.toString();
                stringArray[1] = stringArray[0].substring(stringArray[0].lastIndexOf(47) + 1, stringArray[0].length());
            }
            catch (MalformedURLException malformedURLException) {
                this.openErrorMessage = malformedURLException.getMessage();
            }
            return stringArray;
        }
        File file = new File(string);
        stringArray[0] = file.getAbsolutePath();
        stringArray[1] = file.getName();
        return stringArray;
    }

    Object getInputStreamOrErrorMessageFromName(String string, boolean bl) {
        return FileManager.getInputStream(string, bl, this.appletDocumentBase, this.appletProxy, this.viewer.getDefaultDirectory());
    }

    public static Object getInputStream(String string, boolean bl, URL uRL, String string2, String string3) {
        String string4 = null;
        int n = urlPrefixes.length;
        while (--n >= 0 && !string.startsWith(urlPrefixes[n])) {
        }
        boolean bl2 = n >= 0;
        boolean bl3 = uRL != null;
        try {
            InputStream inputStream;
            int n2;
            if (bl3 || bl2) {
                if (bl3 && bl2 && string2 != null) {
                    string = string2 + "?url=" + URLEncoder.encode(string, "utf-8");
                } else if (!bl2 && string3.length() != 0) {
                    string = string3 + "/" + string;
                }
                URL uRL2 = bl3 ? new URL(uRL, string) : new URL(string);
                string = uRL2.toString();
                if (bl) {
                    Logger.info((String)("FileManager opening " + uRL2.toString()));
                }
                URLConnection uRLConnection = uRL2.openConnection();
                n2 = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
            } else {
                if (!bl2 && string.indexOf(":") < 0 && string3.length() != 0) {
                    string = string3 + "/" + string;
                }
                if (bl) {
                    Logger.info((String)("FileManager opening " + string));
                }
                File file = new File(string);
                n2 = (int)file.length();
                inputStream = new FileInputStream(file);
            }
            return new MonitorInputStream(inputStream, n2);
        }
        catch (Exception exception) {
            string4 = "" + exception;
            return string4;
        }
    }

    BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    Object loadFileSetAsOneFile(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = stringArray[1];
        for (int i = 2; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string != null) {
                stringBuffer.append("BEGIN " + string + " " + string2 + "\n");
            }
            stringBuffer.append(this.getFileAsString(string2));
            if (string == null) continue;
            stringBuffer.append("\nEND " + string + " " + string2 + "\n");
        }
        return this.getBufferedReaderForString(stringBuffer.toString());
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray) {
        String[] stringArray2 = this.classifyName(string);
        if (stringArray2 == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(stringArray2[0], false, false);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string, boolean bl, boolean bl2) {
        Object object;
        String[] stringArray;
        String[] stringArray2 = null;
        if (string.indexOf("|") >= 0) {
            stringArray2 = TextFormat.split((String)string, (String)"|");
            string = stringArray2[0];
        }
        if ((stringArray = this.modelAdapter.specialLoad(string, null)) != null) {
            if (bl2) {
                return stringArray;
            }
            if (stringArray[2] != null) {
                return this.loadFileSetAsOneFile(stringArray);
            }
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, true)) instanceof String) {
            return object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            FilterInputStream filterInputStream = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument((InputStream)filterInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return this.getBufferedReaderForString("" + compoundDocument.getAllData());
            }
            if (FileManager.isGzip(filterInputStream)) {
                filterInputStream = new GZIPInputStream(bufferedInputStream);
            } else if (ZipUtil.isZipFile((InputStream)filterInputStream)) {
                if (bl) {
                    return new ZipInputStream(filterInputStream);
                }
                return this.getBufferedReaderForString(ZipUtil.getZipFileContents((InputStream)filterInputStream, (String[])stringArray2, (int)1));
            }
            return new BufferedReader(new InputStreamReader(filterInputStream));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    String[] getZipDirectory(String string, boolean bl) {
        return ZipUtil.getZipDirectoryAndClose((InputStream)((InputStream)this.getInputStreamOrErrorMessageFromName(string, false)), (boolean)bl);
    }

    String getZipDirectoryAsString(String string) {
        return ZipUtil.getZipDirectoryAsStringAndClose((InputStream)((InputStream)this.getInputStreamOrErrorMessageFromName(string, false)));
    }

    class FilesOpenThread
    implements Runnable,
    JmolFileReaderInterface {
        String errorMessage;
        private String[] fullPathNamesInThread;
        private String[] namesAsGivenInThread;
        private String[] fileTypesInThread;
        Object clientFile;
        private Reader[] stringReaders;
        private Hashtable[] htParamsSet;

        FilesOpenThread(String[] stringArray, String[] stringArray2, String[] stringArray3, Reader[] readerArray) {
            this.fullPathNamesInThread = stringArray;
            this.namesAsGivenInThread = stringArray2;
            this.fileTypesInThread = stringArray3;
            this.stringReaders = readerArray;
        }

        public void run() {
            if (this.stringReaders != null) {
                this.openStringReaders();
                this.stringReaders = null;
            } else {
                this.htParamsSet = new Hashtable[this.fullPathNamesInThread.length];
                this.htParamsSet[0] = new Hashtable();
                Object object = FileManager.this.modelAdapter.openBufferedReaders((JmolFileReaderInterface)this, this.fullPathNamesInThread, this.fileTypesInThread, this.htParamsSet);
                if (object instanceof String) {
                    this.errorMessage = (String)object;
                } else {
                    this.clientFile = object;
                }
                if (this.errorMessage != null) {
                    Logger.error((String)("file ERROR: " + this.errorMessage));
                }
            }
        }

        private void openStringReaders() {
            Object object = FileManager.this.modelAdapter.openBufferedReaders((JmolFileReaderInterface)this, this.fullPathNamesInThread, this.fileTypesInThread, null);
            if (object == null) {
                return;
            }
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.clientFile = object;
            }
        }

        public BufferedReader getBufferedReader(int n) {
            Object object;
            if (this.stringReaders != null) {
                return new BufferedReader(this.stringReaders[n]);
            }
            String string = this.fullPathNamesInThread[n];
            String[] stringArray = null;
            Hashtable hashtable = this.htParamsSet[0];
            hashtable.remove("subFileList");
            if (string.indexOf("|") >= 0) {
                stringArray = TextFormat.split((String)string, (String)"|");
                string = stringArray[0];
            }
            if ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false)) instanceof ZipInputStream) {
                if (stringArray != null) {
                    hashtable.put("subFileList", stringArray);
                }
                String[] stringArray2 = FileManager.this.getZipDirectory(string, true);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)FileManager.this.getInputStreamOrErrorMessageFromName(string, false), 8192);
                object = FileManager.this.modelAdapter.openZipFiles((InputStream)bufferedInputStream, string, stringArray2, hashtable, true);
            }
            if (object instanceof BufferedReader) {
                return (BufferedReader)object;
            }
            this.errorMessage = object == null ? "error opening:" + this.namesAsGivenInThread[n] : (String)object;
            return null;
        }
    }

    class FileOpenThread
    implements Runnable {
        String errorMessage;
        String fullPathNameInThread;
        String nameAsGivenInThread;
        String fileTypeInThread;
        Object clientFile;
        BufferedReader reader;
        Hashtable htParams;

        FileOpenThread(String string, String string2, String string3, BufferedReader bufferedReader, Hashtable hashtable) {
            this.fullPathNameInThread = string;
            this.nameAsGivenInThread = string2;
            this.fileTypeInThread = string3;
            this.reader = bufferedReader;
            this.htParams = hashtable;
        }

        public void run() {
            if (this.reader != null) {
                this.openBufferedReader();
            } else {
                Object object;
                String string = this.fullPathNameInThread;
                String[] stringArray = null;
                if (string.indexOf("|") >= 0) {
                    stringArray = TextFormat.split((String)string, (String)"|");
                    string = stringArray[0];
                }
                if ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false)) instanceof BufferedReader) {
                    this.reader = (BufferedReader)object;
                    this.openBufferedReader();
                } else if (object instanceof ZipInputStream) {
                    if (stringArray != null) {
                        this.htParams.put("subFileList", stringArray);
                    }
                    this.openZipStream(string);
                } else {
                    String string2 = this.errorMessage = object == null ? "error opening:" + this.nameAsGivenInThread : (String)object;
                }
            }
            if (this.errorMessage != null) {
                Logger.error((String)("file ERROR: " + this.fullPathNameInThread + "\n" + this.errorMessage));
            }
        }

        private void openZipStream(String string) {
            String[] stringArray = FileManager.this.getZipDirectory(string, true);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)FileManager.this.getInputStreamOrErrorMessageFromName(string, false), 8192);
            Object object = FileManager.this.modelAdapter.openZipFiles((InputStream)bufferedInputStream, string, stringArray, this.htParams, false);
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.clientFile = object;
            }
        }

        private void openBufferedReader() {
            Object object = FileManager.this.modelAdapter.openBufferedReader(this.fullPathNameInThread, this.fileTypeInThread, this.reader, this.htParams);
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.clientFile = object;
            }
        }
    }

    class DOMOpenThread
    implements Runnable {
        String errorMessage;
        Object aDOMNode;
        Object clientFile;

        DOMOpenThread(Object object) {
            this.aDOMNode = object;
        }

        public void run() {
            this.clientFile = FileManager.this.modelAdapter.openDOMReader(this.aDOMNode);
            this.errorMessage = null;
        }
    }
}

