/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.shapespecial.MeshFileCollection;
import org.jmol.util.Logger;

public class Pmesh
extends MeshFileCollection {
    private boolean isOnePerLine;
    private int modelIndex;
    private String pmeshError;

    public void initShape() {
        super.initShape();
        this.myType = "pmesh";
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("init" == string) {
            this.pmeshError = null;
            this.isFixed = false;
            this.modelIndex = -1;
            this.isOnePerLine = false;
            this.script = (String)object;
            super.setProperty("thisID", (Object)"+PREVIOUS_MESH+", null);
        }
        if ("modelIndex" == string) {
            this.modelIndex = (Integer)object;
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.modelIndex = -1;
            this.setModelIndex(-1, -1);
            return;
        }
        if ("bufferedReaderOnePerLine" == string) {
            this.isOnePerLine = true;
            string = "bufferedReader";
        }
        if ("bufferedReader" == string) {
            BufferedReader bufferedReader = (BufferedReader)object;
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            this.currentMesh.clear("pmesh");
            this.currentMesh.isValid = this.readPmesh(bufferedReader);
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentMesh.isValid) {
                this.currentMesh.initialize(2);
                this.currentMesh.visible = true;
                this.currentMesh.title = this.title;
            } else {
                Logger.error((String)this.pmeshError);
            }
            this.setModelIndex(-1, this.modelIndex);
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("pmeshError")) {
            return this.pmeshError;
        }
        return super.getProperty(string, n);
    }

    private boolean readPmesh(BufferedReader bufferedReader) {
        try {
            if (!this.readVertexCount(bufferedReader)) {
                return false;
            }
            Logger.debug((String)("vertexCount=" + this.currentMesh.vertexCount));
            if (!this.readVertices(bufferedReader)) {
                return false;
            }
            Logger.debug((String)"vertices read");
            if (!this.readPolygonCount(bufferedReader)) {
                return false;
            }
            Logger.debug((String)("polygonCount=" + this.currentMesh.polygonCount));
            if (!this.readPolygonIndexes(bufferedReader)) {
                return false;
            }
            Logger.debug((String)"polygonIndexes read");
            if (this.currentMesh.polygonCount == 0) {
                this.currentMesh.setPolygonCount(1);
                this.currentMesh.polygonIndexes[0] = new int[]{0, 0, 0};
            }
        }
        catch (Exception exception) {
            if (this.pmeshError == null) {
                this.pmeshError = "pmesh ERROR: read exception: " + exception;
            }
            return false;
        }
        return true;
    }

    private boolean readVertexCount(BufferedReader bufferedReader) throws Exception {
        this.pmeshError = "pmesh ERROR: vertex count must be positive";
        this.currentMesh.vertexCount = 0;
        this.currentMesh.vertices = new Point3f[0];
        int n = this.parseInt(bufferedReader.readLine());
        if (n <= 0) {
            this.pmeshError = this.pmeshError + " (" + n + ")";
            return false;
        }
        this.currentMesh.vertices = new Point3f[n];
        this.currentMesh.vertexCount = n;
        this.pmeshError = null;
        return true;
    }

    private boolean readVertices(BufferedReader bufferedReader) throws Exception {
        this.pmeshError = "pmesh ERROR: invalid vertex list";
        if (this.isOnePerLine) {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                float f = this.parseFloat(bufferedReader.readLine());
                float f2 = this.parseFloat(bufferedReader.readLine());
                float f3 = this.parseFloat(bufferedReader.readLine());
                this.currentMesh.vertices[i] = new Point3f(f, f2, f3);
            }
        } else {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                this.line = bufferedReader.readLine();
                float f = this.parseFloat(this.line);
                float f4 = this.parseFloat();
                float f5 = this.parseFloat();
                this.currentMesh.vertices[i] = new Point3f(f, f4, f5);
            }
        }
        this.pmeshError = null;
        return true;
    }

    private boolean readPolygonCount(BufferedReader bufferedReader) throws Exception {
        int n = this.parseInt(bufferedReader.readLine());
        if (n >= 0) {
            this.currentMesh.setPolygonCount(n);
        } else {
            this.pmeshError = "pmesh ERROR: polygon count must be >= 0 (" + n + ")";
        }
        return n >= 0;
    }

    private boolean readPolygonIndexes(BufferedReader bufferedReader) throws Exception {
        for (int i = 0; i < this.currentMesh.polygonCount; ++i) {
            this.currentMesh.polygonIndexes[i] = this.readPolygon(i, bufferedReader);
            if (this.currentMesh.polygonIndexes[i] != null) continue;
            return false;
        }
        return true;
    }

    private int[] readPolygon(int n, BufferedReader bufferedReader) throws Exception {
        int n2;
        int n3 = this.parseInt(bufferedReader.readLine());
        if (n3 < 2) {
            this.pmeshError = "pmesh ERROR: each polygon must have at least two verticies indicated -- polygon " + (n + 1);
            return null;
        }
        int n4 = n3 - 1;
        int n5 = n4 < 3 ? 3 : n4;
        int[] nArray = new int[n5];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.parseInt(bufferedReader.readLine());
            if (nArray[n2] >= 0 && nArray[n2] < this.currentMesh.vertexCount) continue;
            this.pmeshError = "pmesh ERROR: invalid vertex index: " + nArray[n2];
            return null;
        }
        for (n2 = n4; n2 < n5; ++n2) {
            nArray[n2] = nArray[n2 - 1];
        }
        n2 = this.parseInt(bufferedReader.readLine());
        if (n2 != nArray[0]) {
            this.pmeshError = "pmesh ERROR: last polygon point reference (" + n2 + ") is not the same as the first (" + nArray[0] + ") for polygon " + (n + 1);
            return null;
        }
        return nArray;
    }
}

