/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;

public class DrawRenderer
extends MeshRenderer {
    private int drawType;
    private DrawMesh dmesh;
    private Point3f[] controlHermites;

    protected void render() {
        this.antialias = ((ShapeRenderer)this).g3d.isAntialiased();
        Draw draw = (Draw)((ShapeRenderer)this).shape;
        int n = draw.meshCount;
        while (--n >= 0) {
            this.dmesh = (DrawMesh)draw.meshes[n];
            if (!this.render1(this.dmesh)) continue;
            this.renderInfo();
        }
    }

    protected boolean isPolygonDisplayable(int n) {
        return Draw.isPolygonDisplayable(this.dmesh, n) && (this.mesh.modelFlags == null || this.mesh.modelFlags[n] != 0);
    }

    protected void render2() {
        int n;
        boolean bl;
        boolean bl2 = ((ShapeRenderer)this).viewer.getPickingMode() == 4;
        this.drawType = this.dmesh.drawType;
        this.diameter = this.dmesh.diameter;
        this.width = this.dmesh.width;
        boolean bl3 = bl = (this.drawType == 17 || this.drawType == 15) && this.vertexCount >= 2;
        if (this.width > 0.0f && bl) {
            this.pt1f.set(0.0f, 0.0f, 0.0f);
            for (n = 0; n < this.vertexCount; ++n) {
                this.pt1f.add((Tuple3f)this.vertices[n]);
            }
            this.pt1f.scale(1.0f / (float)this.vertexCount);
            ((ShapeRenderer)this).viewer.transformPoint(this.pt1f, this.pt1i);
            this.diameter = ((ShapeRenderer)this).viewer.scaleToScreen(this.pt1i.z, (int)(this.width * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
        }
        n = 5;
        switch (this.drawType) {
            default: {
                super.render2();
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 15: {
                int n2;
                Vector3f vector3f = new Vector3f();
                float f = this.dmesh.drawArrowScale;
                if (f == 0.0f) {
                    f = ((ShapeRenderer)this).viewer.getDefaultDrawArrowScale();
                }
                if (f <= 0.0f) {
                    f = 0.5f;
                }
                int n3 = 5;
                if (this.controlHermites == null || this.controlHermites.length < n3 + 1) {
                    this.controlHermites = new Point3f[n3 + 1];
                }
                if (this.vertexCount == 2) {
                    if (this.controlHermites[n3 - 1] == null) {
                        this.controlHermites[n3 - 2] = new Point3f(this.vertices[0]);
                        this.controlHermites[n3 - 1] = new Point3f(this.vertices[1]);
                    } else {
                        this.controlHermites[n3 - 2].set((Tuple3f)this.vertices[0]);
                        this.controlHermites[n3 - 1].set((Tuple3f)this.vertices[1]);
                    }
                } else {
                    Graphics3D.getHermiteList((int)n, (Tuple3f)this.vertices[this.vertexCount - 3], (Tuple3f)this.vertices[this.vertexCount - 2], (Tuple3f)this.vertices[this.vertexCount - 1], (Tuple3f)this.vertices[this.vertexCount - 1], (Tuple3f)this.vertices[this.vertexCount - 1], (Tuple3f[])this.controlHermites, (int)0, (int)n3);
                }
                this.pt1f.set((Tuple3f)this.controlHermites[n3 - 2]);
                this.pt2f.set((Tuple3f)this.controlHermites[n3 - 1]);
                vector3f.set((Tuple3f)this.pt2f);
                vector3f.sub((Tuple3f)this.pt1f);
                float f2 = vector3f.length();
                if (f2 == 0.0f) break;
                vector3f.scale(f / f2 / 5.0f);
                this.pt2f.add((Tuple3f)vector3f);
                vector3f.scale(5.0f);
                this.pt1f.set((Tuple3f)this.pt2f);
                this.pt1f.sub((Tuple3f)vector3f);
                ((ShapeRenderer)this).viewer.transformPoint(this.pt2f, this.pt2i);
                ((ShapeRenderer)this).viewer.transformPoint(this.pt1f, this.pt1i);
                vector3f.set((float)(this.pt2i.x - this.pt1i.x), (float)(this.pt2i.y - this.pt1i.y), (float)(this.pt2i.z - this.pt1i.z));
                if (this.pt2i.z == 1 || this.pt1i.z == 1) break;
                if (this.diameter > 0) {
                    n2 = this.diameter * 5;
                } else {
                    n2 = (int)((double)vector3f.length() * 0.5);
                    this.diameter = n2 / 5;
                }
                if (this.diameter < 1) {
                    this.diameter = 1;
                }
                if (n2 <= 2) break;
                ((ShapeRenderer)this).g3d.fillCone((byte)2, n2, this.pt1i, this.pt2i);
            }
        }
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        if (bl) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < this.vertexCount - 1) {
                ((ShapeRenderer)this).g3d.fillHermite(n, this.diameter, this.diameter, this.diameter, this.screens[n5], this.screens[n4], this.screens[n4 + 1], this.screens[n4 + (n4 + 2 == this.vertexCount ? 1 : 2)]);
                n5 = n4++;
            }
        }
        if (bl2 && !((ShapeRenderer)this).isGenerator) {
            this.renderHandles();
        }
    }

    private void renderHandles() {
        int n = this.antialias ? 20 : 10;
        block0 : switch (this.drawType) {
            case -1: 
            case 1: 
            case 2: 
            case 4: 
            case 15: 
            case 16: 
            case 17: {
                int n2 = this.dmesh.polygonCount;
                while (--n2 >= 0) {
                    int[] nArray;
                    if (!this.isPolygonDisplayable(n2) || (nArray = this.dmesh.polygonIndexes[n2]) == null) continue;
                    int n3 = nArray.length;
                    while (--n3 >= 0) {
                        int n4 = nArray[n3];
                        ((ShapeRenderer)this).g3d.fillScreenedCircleCentered((short)23, n, this.screens[n4].x, this.screens[n4].y, this.screens[n4].z);
                    }
                    break block0;
                }
                break;
            }
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || ((ShapeRenderer)this).viewer.getDrawHover() || !((ShapeRenderer)this).g3d.setColix(((ShapeRenderer)this).viewer.getColixBackgroundContrast())) {
            return;
        }
        int n = this.dmesh.polygonCount;
        while (--n >= 0) {
            if (!this.isPolygonDisplayable(n)) continue;
            byte by = ((ShapeRenderer)this).g3d.getFontFid("SansSerif", 14);
            ((ShapeRenderer)this).g3d.setFont(by);
            ((ShapeRenderer)this).viewer.transformPoint(this.vertices[this.dmesh.polygonIndexes[n][0]], this.pt1i);
            int n2 = this.antialias ? 10 : 5;
            ((ShapeRenderer)this).g3d.drawString(this.mesh.title[n < this.mesh.title.length ? n : this.mesh.title.length - 1], null, this.pt1i.x + n2, this.pt1i.y - n2, this.pt1i.z, this.pt1i.z);
            break;
        }
    }
}

