/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.Quaternion;

public class AminoMonomer
extends AlphaMonomer {
    private static final byte CA = 0;
    private static final byte O = 1;
    private static final byte N = 2;
    private static final byte C = 3;
    private static final byte OT = 4;
    static final byte[] interestingAminoAtomIDs = new byte[]{2, -5, 1, 3, -65, -6};

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        byte[] byArray = Monomer.scanForOffsets(n2, nArray, interestingAminoAtomIDs);
        if (byArray == null) {
            return null;
        }
        Monomer.checkOptional(byArray, (byte)1, n2, nArray[5]);
        if (atomArray[n2].isHetero() && !AminoMonomer.isBondedCorrectly(n2, byArray, atomArray)) {
            return null;
        }
        AminoMonomer aminoMonomer = new AminoMonomer(chain, string, n, n2, n3, byArray);
        return aminoMonomer;
    }

    private static boolean isBondedCorrectly(int n, int n2, int n3, byte[] byArray, Atom[] atomArray) {
        int n4 = n3 + (byArray[n] & 0xFF);
        int n5 = n3 + (byArray[n2] & 0xFF);
        if (n4 >= n5) {
            return false;
        }
        return atomArray[n4].isBonded(atomArray[n5]);
    }

    private static boolean isBondedCorrectly(int n, byte[] byArray, Atom[] atomArray) {
        return AminoMonomer.isBondedCorrectly(2, 0, n, byArray, atomArray) && AminoMonomer.isBondedCorrectly(0, 3, n, byArray, atomArray) && (byArray[1] == -1 || AminoMonomer.isBondedCorrectly(3, 1, n, byArray, atomArray));
    }

    private AminoMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
    }

    boolean isAminoMonomer() {
        return true;
    }

    Atom getNitrogenAtom() {
        return this.getAtomFromOffsetIndex(2);
    }

    Point3f getNitrogenAtomPoint() {
        return this.getAtomPointFromOffsetIndex(2);
    }

    Atom getCarbonylCarbonAtom() {
        return this.getAtomFromOffsetIndex(3);
    }

    Point3f getCarbonylCarbonAtomPoint() {
        return this.getAtomPointFromOffsetIndex(3);
    }

    Atom getCarbonylOxygenAtom() {
        return this.getWingAtom();
    }

    Point3f getCarbonylOxygenAtomPoint() {
        return this.getWingAtomPoint();
    }

    Atom getInitiatorAtom() {
        return this.getNitrogenAtom();
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[4] != -1 ? 4 : 3);
    }

    boolean hasOAtom() {
        return this.offsets[1] != -1;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        if (!(monomer instanceof AminoMonomer)) {
            return false;
        }
        AminoMonomer aminoMonomer = (AminoMonomer)monomer;
        return aminoMonomer.getCarbonylCarbonAtom().isBonded(this.getNitrogenAtom());
    }

    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        Atom atom;
        int n3;
        Atom atom2 = atomArray[0];
        Atom atom3 = this.getNitrogenAtom();
        int n4 = s / 2;
        if (n4 < 1200) {
            n4 = 1200;
        }
        if (atom3.screenZ == 0) {
            return;
        }
        int n5 = this.scaleToScreen(atom3.screenZ, n4);
        if (n5 < 4) {
            n5 = 4;
        }
        Atom atom4 = this.getCarbonylCarbonAtom();
        int n6 = s2 / 2;
        if (n6 < 1200) {
            n6 = 1200;
        }
        if ((n3 = this.scaleToScreen(atom3.screenZ, n6)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom = this.getLeadAtom(), n, n2, (n5 + n3) / 2, atom2) || this.isCursorOnTopOf(atom3, n, n2, n5, atom2) || this.isCursorOnTopOf(atom4, n, n2, n3, atom2)) {
            atomArray[0] = atom;
        }
    }

    Quaternion getQuaternion() {
        Point3f point3f = this.getCarbonylCarbonAtomPoint();
        Point3f point3f2 = this.getLeadAtomPoint();
        Vector3f vector3f = new Vector3f((Tuple3f)point3f);
        vector3f.sub((Tuple3f)point3f2);
        Point3f point3f3 = this.getNitrogenAtomPoint();
        Vector3f vector3f2 = new Vector3f((Tuple3f)point3f3);
        vector3f2.sub((Tuple3f)point3f2);
        return Quaternion.getQuaternionFrame(vector3f, vector3f2);
    }
}

