/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlArgusReader;
import org.jmol.adapter.readers.xml.XmlChem3dReader;
import org.jmol.adapter.readers.xml.XmlCmlReader;
import org.jmol.adapter.readers.xml.XmlMolproReader;
import org.jmol.adapter.readers.xml.XmlOdysseyReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader
extends AtomSetCollectionReader {
    protected XmlReader parent;
    protected Atom atom;
    String[] implementedAttributes = new String[]{"id"};
    protected boolean keepChars;
    protected String chars;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        XMLReader xMLReader = this.getXmlReader();
        if (xMLReader == null) {
            this.atomSetCollection = new AtomSetCollection("xml");
            this.atomSetCollection.errorMessage = "No XML reader found";
            return this.atomSetCollection;
        }
        try {
            this.processXml(xMLReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.atomSetCollection.errorMessage = "XML reader error: " + exception.getMessage();
        }
        return this.atomSetCollection;
    }

    private XMLReader getXmlReader() {
        XMLReader xMLReader = null;
        if (xMLReader == null && System.getProperty("java.version").compareTo("1.4") >= 0) {
            xMLReader = this.allocateXmlReader14();
        }
        if (xMLReader == null) {
            xMLReader = this.allocateXmlReaderAelfred2();
        }
        return xMLReader;
    }

    private XMLReader allocateXmlReader14() {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            Logger.debug((String)"Using JAXP/SAX XML parser.");
        }
        catch (Exception exception) {
            Logger.debug((String)("Could not instantiate JAXP/SAX XML reader: " + exception.getMessage()));
        }
        return xMLReader;
    }

    private XMLReader allocateXmlReaderAelfred2() {
        XMLReader xMLReader = null;
        try {
            xMLReader = (XMLReader)((Object)((Object)this)).getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
            Logger.debug((String)"Using Aelfred2 XML parser.");
        }
        catch (Exception exception) {
            Logger.debug((String)"Could not instantiate Aelfred2 XML reader!");
        }
        return xMLReader;
    }

    private Object processXml(XMLReader xMLReader) throws Exception {
        this.atomSetCollection = new AtomSetCollection(this.readerName);
        if (this.readerName.equals(Resolver.specialTags[8][0])) {
            return new XmlArgusReader(this, this.atomSetCollection, this.reader, xMLReader);
        }
        if (this.readerName.equals(Resolver.specialTags[10][0])) {
            return new XmlChem3dReader(this, this.atomSetCollection, this.reader, xMLReader);
        }
        if (this.readerName.equals(Resolver.specialTags[11][0])) {
            return new XmlMolproReader(this, this.atomSetCollection, this.reader, xMLReader);
        }
        if (this.readerName.equals(Resolver.specialTags[12][0])) {
            return new XmlOdysseyReader(this, this.atomSetCollection, this.reader, xMLReader);
        }
        return new XmlCmlReader(this, this.atomSetCollection, this.reader, xMLReader);
    }

    protected void parseReaderXML(XMLReader xMLReader) {
        xMLReader.setEntityResolver(new DummyResolver());
        InputSource inputSource = new InputSource(this.reader);
        inputSource.setSystemId("foo");
        try {
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.atomSetCollection.errorMessage = "XML parsing error: " + exception.getMessage();
        }
    }

    public AtomSetCollection readAtomSetCollectionFromDOM(Object object) {
        this.processXml((JSObject)object);
        return this.atomSetCollection;
    }

    private Object processXml(JSObject jSObject) {
        this.atomSetCollection = new AtomSetCollection(this.readerName);
        if (this.readerName.equals(Resolver.specialTags[13][0])) {
            return new XmlArgusReader(this, this.atomSetCollection, jSObject);
        }
        if (this.readerName.equals(Resolver.specialTags[15][0])) {
            return new XmlChem3dReader(this, this.atomSetCollection, jSObject);
        }
        if (this.readerName.equals(Resolver.specialTags[16][0])) {
            return new XmlMolproReader(this, this.atomSetCollection, jSObject);
        }
        if (this.readerName.equals(Resolver.specialTags[17][0])) {
            return new XmlOdysseyReader(this, this.atomSetCollection, jSObject);
        }
        return new XmlCmlReader(this, this.atomSetCollection, jSObject);
    }

    protected void processStartElement(String string, String string2, String string3, HashMap hashMap) {
    }

    protected void setKeepChars(boolean bl) {
        this.keepChars = bl;
        this.chars = null;
    }

    protected void processEndElement(String string, String string2, String string3) {
    }

    public class JmolXmlHandler
    extends DefaultHandler
    implements ErrorHandler {
        public HashMap atts;

        public JmolXmlHandler() {
        }

        public JmolXmlHandler(XMLReader xMLReader) {
            this.setHandler(xMLReader, this);
        }

        public void setHandler(XMLReader xMLReader, JmolXmlHandler jmolXmlHandler) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xMLReader.setEntityResolver(jmolXmlHandler);
                xMLReader.setContentHandler(jmolXmlHandler);
                xMLReader.setErrorHandler(jmolXmlHandler);
            }
            catch (Exception exception) {
                Logger.error((String)"ERROR IN XmlReader.JmolXmlHandler.setHandler", (Throwable)exception);
            }
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.getAttributes(attributes);
            if (Logger.debugging) {
                Logger.debug((String)("start " + string2));
            }
            this.startElement(string, string2, string3);
        }

        private void startElement(String string, String string2, String string3) {
            XmlReader.this.processStartElement(string, string2, string3, this.atts);
        }

        public void endElement(String string, String string2, String string3) {
            if (Logger.debugging) {
                Logger.debug((String)("end " + string2));
            }
            XmlReader.this.processEndElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) {
            if (XmlReader.this.keepChars) {
                XmlReader.this.chars = XmlReader.this.chars == null ? new String(cArray, n, n2) : XmlReader.this.chars + new String(cArray, n, n2);
            }
        }

        public InputSource resolveEntity(String string, String string2, String string3, String string4) {
            if (Logger.debugging) {
                Logger.debug((String)("Not resolving this:\n      name: " + string + "\n  systemID: " + string4 + "\n  publicID: " + string2 + "\n   baseURI: " + string3));
            }
            return null;
        }

        public InputSource resolveEntity(String string, String string2) {
            if (Logger.debugging) {
                Logger.debug((String)("Not resolving this:\n  publicID: " + string + "\n  systemID: " + string2));
            }
            return null;
        }

        public void error(SAXParseException sAXParseException) {
            Logger.error((String)("SAX ERROR:" + sAXParseException.getMessage()));
        }

        public void fatalError(SAXParseException sAXParseException) {
            Logger.error((String)("SAX FATAL:" + sAXParseException.getMessage()));
        }

        public void warning(SAXParseException sAXParseException) {
            Logger.warn((String)("SAX WARNING:" + sAXParseException.getMessage()));
        }

        protected void walkDOMTree(JSObject jSObject) {
            String string = (String)jSObject.getMember("namespaceURI");
            String string2 = (String)jSObject.getMember("localName");
            String string3 = (String)jSObject.getMember("nodeName");
            JSObject jSObject2 = (JSObject)jSObject.getMember("attributes");
            this.getAttributes(jSObject2);
            this.startElement(string, string2, string3);
            if (((Boolean)jSObject.call("hasChildNodes", null)).booleanValue()) {
                for (JSObject jSObject3 = (JSObject)jSObject.getMember("firstChild"); jSObject3 != (JSObject)null; jSObject3 = (JSObject)jSObject3.getMember("nextSibling")) {
                    this.walkDOMTree(jSObject3);
                }
            }
            this.endElement(string, string2, string3);
        }

        private void getAttributes(Attributes attributes) {
            int n = attributes.getLength();
            this.atts = new HashMap(n);
            int n2 = n;
            while (--n2 >= 0) {
                this.atts.put(attributes.getLocalName(n2), attributes.getValue(n2));
            }
        }

        private void getAttributes(JSObject jSObject) {
            if (jSObject == null) {
                this.atts = new HashMap(0);
                return;
            }
            int n = ((Number)jSObject.getMember("length")).intValue();
            this.atts = new HashMap(n);
            int n2 = XmlReader.this.implementedAttributes.length;
            while (--n2 >= 0) {
                Object[] objectArray = new Object[]{XmlReader.this.implementedAttributes[n2]};
                JSObject jSObject2 = (JSObject)jSObject.call("getNamedItem", objectArray);
                if (jSObject2 == null) continue;
                String string = (String)jSObject2.getMember("name");
                String string2 = (String)jSObject2.getMember("value");
                this.atts.put(string, string2);
            }
        }
    }

    public class DummyResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (Logger.debugging) {
                Logger.debug((String)("Jmol SAX EntityResolver not resolving:\n  publicID: " + string + "\n  systemID: " + string2));
            }
            return new InputSource(new BufferedReader(new StringReader("")));
        }
    }
}

