/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacDataReader {
    protected float[] frequencies = null;
    protected AtomSetCollection freqAtomSet = null;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("molden");
        this.modelNumber = 0;
        try {
            this.readLine();
            while (this.line != null) {
                if (this.line.startsWith("[Atoms]")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.equals("[GTO]")) {
                    this.readGaussianBasis();
                    continue;
                }
                if (this.line.equals("[MO]")) {
                    this.readMolecularOrbitals();
                    continue;
                }
                if (this.line.indexOf("[FREQ]") >= 0) {
                    this.readFreqsAndModes();
                    continue;
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        String string = this.line.substring(7).trim();
        int n = 0;
        int n2 = 0;
        if (!string.equals("Angs") && !string.equals("AU")) {
            throw new Exception("invalid coordinate unit " + string + " in [Atoms]");
        }
        this.readLine();
        while (this.line != null && this.line.charAt(0) != '[') {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.atomName = stringArray[0];
            n2 = this.parseInt(stringArray[1]);
            if (n > 0 && n2 != n + 1) {
                throw new Exception("out of order atom in [Atoms]");
            }
            n = n2;
            atom.set(this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
            this.readLine();
        }
        if (string.equals("AU")) {
            int n3 = this.atomSetCollection.getAtomCount();
            while (--n3 >= 0) {
                this.atomSetCollection.getAtom(n3).scale(0.5291772f);
            }
        }
    }

    void readGaussianBasis() throws Exception {
        Object object;
        Vector<int[]> vector = new Vector<int[]>();
        Vector<float[]> vector2 = new Vector<float[]>();
        int n = 0;
        int n2 = 0;
        while (this.readLine() != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            object = this.getTokens();
            n = this.parseInt((String)object[0]) - 1;
            while (this.readLine() != null && this.line.trim().length() > 0) {
                object = this.getTokens();
                String string = object[0].toUpperCase();
                int n3 = this.parseInt((String)object[1]);
                int[] nArray = new int[]{n, JmolAdapter.getQuantumShellTagID((String)string), n2, n3};
                int n4 = n3;
                while (--n4 >= 0) {
                    String[] stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                    int n5 = stringArray.length;
                    float[] fArray = new float[n5];
                    for (int i = 0; i < n5; ++i) {
                        fArray[i] = this.parseFloat(stringArray[i]);
                    }
                    vector2.addElement(fArray);
                    ++n2;
                }
                vector.addElement(nArray);
            }
        }
        object = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])vector2.get(i);
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug((String)(vector.size() + " slater shells read"));
            Logger.debug((String)(((float[][])object).length + " gaussian primitives read"));
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
    }

    void readMolecularOrbitals() throws Exception {
        Object object;
        Object object2;
        this.readLine();
        if (this.line.equals("[5D]")) {
            object2 = (Vector)this.moData.get("shells");
            int n = ((Vector)object2).size();
            block4: while (--n >= 0) {
                object = (int[])((Vector)object2).get(n);
                switch (object[1]) {
                    case 3: {
                        object[1] = 4;
                        continue block4;
                    }
                    case 5: {
                        object[1] = 6;
                        continue block4;
                    }
                }
            }
            this.readLine();
        }
        object2 = this.getTokens();
        while (object2 != null && this.line.indexOf(91) < 0) {
            Object[] objectArray;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            object = new Vector();
            float f = Float.NaN;
            float f2 = Float.NaN;
            while (object2 != null && this.parseInt((String)object2[0]) == Integer.MIN_VALUE) {
                if (((String)object2[0]).startsWith("Ene")) {
                    objectArray = this.splitKeyValue();
                    f = this.parseFloat((String)objectArray[1]);
                } else if (((String)object2[0]).startsWith("Occup")) {
                    objectArray = this.splitKeyValue();
                    f2 = this.parseFloat((String)objectArray[1]);
                }
                object2 = AtomSetCollectionReader.getTokens((String)this.readLine());
            }
            if (object2 == null) {
                throw new Exception("error reading MOs: unexpected EOF reading coeffs");
            }
            while (object2 != null && this.parseInt((String)object2[0]) != Integer.MIN_VALUE) {
                if (((Object)object2).length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                ((Vector)object).addElement(object2[1]);
                object2 = AtomSetCollectionReader.getTokens((String)this.readLine());
            }
            objectArray = new float[((Vector)object).size()];
            int n = ((Vector)object).size();
            while (--n >= 0) {
                objectArray[n] = this.parseFloat((String)((Vector)object).get(n));
            }
            hashtable.put("energy", new Float(f));
            hashtable.put("occupancy", new Float(f2));
            hashtable.put("coefficients", objectArray);
            this.orbitals.addElement(hashtable);
            if (!Logger.debugging) continue;
            Logger.debug((String)(objectArray.length + " coefficients in MO " + this.orbitals.size()));
        }
        Logger.debug((String)("read " + this.orbitals.size() + " MOs"));
        this.setMOs("eV");
    }

    void readFreqsAndModes() throws Exception {
        String[] stringArray;
        int n;
        Vector<String> vector = new Vector<String>();
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            vector.add(this.getTokens()[0]);
        }
        if (this.line.indexOf("[FR-COORD]") < 0) {
            throw new Exception("error reading normal modes: [FREQ] must be followed by [FR-COORD]");
        }
        int n2 = vector.size();
        int n3 = this.atomSetCollection.getFirstAtomSetAtomCount();
        this.atomSetCollection.cloneLastAtomSet();
        this.atomSetCollection.setAtomSetName("frequency base geometry");
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (n = 0; n < n3; ++n) {
            stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
            Atom atom = atomArray[n + this.atomSetCollection.getLastAtomSetAtomIndex()];
            atom.atomName = stringArray[0];
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            atom.scale(0.5291772f);
        }
        this.readLine();
        if (this.line.indexOf("[FR-NORM-COORD]") < 0) {
            throw new Exception("error reading normal modes: [FR-COORD] must be followed by [FR-NORM-COORD]");
        }
        for (n = 0; n < n2; ++n) {
            if (this.readLine().indexOf("Vibration") < 0) {
                throw new Exception("error reading normal modes: expected vibration data");
            }
            this.atomSetCollection.cloneLastAtomSet();
            this.atomSetCollection.setAtomSetName(vector.get(n) + " cm-1");
            atomArray = this.atomSetCollection.getAtoms();
            for (int i = 0; i < n3; ++i) {
                Atom atom = atomArray[i + this.atomSetCollection.getLastAtomSetAtomIndex()];
                stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                atom.vectorX = this.parseFloat(stringArray[0]) * 0.5291772f;
                atom.vectorY = this.parseFloat(stringArray[1]) * 0.5291772f;
                atom.vectorZ = this.parseFloat(stringArray[2]) * 0.5291772f;
            }
        }
        this.readLine();
    }

    String[] splitKeyValue() {
        return this.splitKeyValue("=", this.line);
    }

    String[] splitKeyValue(String string) {
        return this.splitKeyValue(string, this.line);
    }

    String[] splitKeyValue(String string, String string2) throws NoSuchElementException {
        String[] stringArray = new String[2];
        int n = string2.indexOf(string);
        if (n < 0) {
            throw new NoSuchElementException("separator not found");
        }
        stringArray[0] = string2.substring(0, n);
        stringArray[1] = string2.substring(n + string.length());
        return stringArray;
    }
}

