/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    final float[] chargeAndOrVector = new float[4];
    final boolean[] isNaN = new boolean[4];

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("xyz");
        boolean bl = false;
        try {
            int n;
            while ((n = this.readAtomCount()) > 0) {
                if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                    if (!bl) {
                        this.skipAtomSet(n);
                        continue;
                    }
                    break;
                }
                bl = true;
                this.readAtomSetName();
                this.readAtoms(n);
                this.applySymmetry();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void skipAtomSet(int n) throws Exception {
        this.readLine();
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    int readAtomCount() throws Exception {
        int n;
        this.readLine();
        if (this.line != null && (n = this.parseInt(this.line)) > 0) {
            return n;
        }
        return 0;
    }

    void readAtomSetName() throws Exception {
        this.readLineTrimmed();
        this.checkLineForScript();
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.line);
    }

    void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            int n2 = this.parseInt(this.line);
            String string = this.parseToken(this.line);
            if (n2 == Integer.MIN_VALUE) {
                atom.elementSymbol = string;
            } else {
                string = string.substring(("" + n2).length());
                atom.elementNumber = (short)((n2 << 7) + JmolAdapter.getElementNumber((String)string));
                this.atomSetCollection.setFileTypeName("xyzi");
            }
            atom.x = this.parseFloat();
            atom.y = this.parseFloat();
            atom.z = this.parseFloat();
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn((String)("line cannot be read for XYZ atom data: " + this.line));
                atom.set(0.0f, 0.0f, 0.0f);
            }
            this.setAtomCoord(atom);
            for (int j = 0; j < 4; ++j) {
                this.chargeAndOrVector[j] = this.parseFloat();
                this.isNaN[j] = Float.isNaN(this.chargeAndOrVector[j]);
            }
            if (this.isNaN[0]) continue;
            if (this.isNaN[1]) {
                atom.formalCharge = (int)this.chargeAndOrVector[0];
                continue;
            }
            if (this.isNaN[3]) {
                atom.vectorX = this.chargeAndOrVector[0];
                atom.vectorY = this.chargeAndOrVector[1];
                atom.vectorZ = this.chargeAndOrVector[2];
                continue;
            }
            atom.formalCharge = (int)this.chargeAndOrVector[0];
            atom.vectorX = this.chargeAndOrVector[1];
            atom.vectorY = this.chargeAndOrVector[2];
            atom.vectorZ = this.chargeAndOrVector[3];
        }
    }
}

