/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.applet.Jvm12;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class Jmol
implements WrappedApplet {
    JmolViewer viewer;
    boolean jvm12orGreater;
    String emulate;
    Jvm12 jvm12;
    JmolPopup jmolpopup;
    String htmlName;
    String fullName;
    String syncId;
    MyStatusListener myStatusListener;
    AppletWrapper appletWrapper;
    boolean mayScript;
    boolean haveDocumentAccess;
    boolean doTranslate = true;
    String animFrameCallback;
    String resizeCallback;
    String loadStructCallback;
    String messageCallback;
    String pickCallback;
    String hoverCallback;
    String statusForm;
    String statusText;
    String statusTextarea;
    static final boolean REQUIRE_PROGRESSBAR = true;
    boolean hasProgressBar;
    int paintCounter;
    String language;
    String menuStructure;
    boolean haveNotifiedError;
    boolean haveWindow;
    boolean needPopupMenu;
    public boolean showPaintTime = false;
    private boolean isUpdating;
    static final String[] progressbarMsgs = new String[]{"Jmol developer alert!", "", "Please use jmol.js. You are missing the require 'progressbar' parameter.", "  <param name='progressbar' value='true' />"};
    int timeLast;
    int timeCount;
    int timeTotal;
    long timeBegin;
    int lastMotionEventNumber;
    Object[] buttonCallbackBefore;
    Object[] buttonCallbackAfter;
    boolean buttonCallbackNotificationPending;
    String buttonCallback;
    String buttonName;
    JSObject buttonWindow;
    static final int SCRIPT_CHECK = 0;
    static final int SCRIPT_WAIT = 1;
    static final int SCRIPT_NOWAIT = 2;

    public void setAppletWrapper(AppletWrapper appletWrapper) {
        this.appletWrapper = appletWrapper;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void init() {
        this.htmlName = this.getParameter("name");
        this.syncId = this.getParameter("syncId");
        this.fullName = this.htmlName + "[" + this.syncId + "]";
        System.out.println("Jmol applet " + this.fullName + " initializing");
        this.language = this.getParameter("language");
        if (this.language != null) {
            System.out.print("requested language=" + this.language + "; ");
            new GT(this.language);
        }
        this.language = GT.getLanguage();
        System.out.println("language=" + this.language);
        this.doTranslate = this.getBooleanValue("doTranslate", true);
        this.setLogging();
        String string = this.getParameter("mayscript");
        this.mayScript = string != null && !string.equalsIgnoreCase("false");
        JmolAppletRegistry.checkIn(this.fullName, (Applet)this.appletWrapper);
        this.initWindows();
        this.initApplication();
    }

    public void destroy() {
        JmolAppletRegistry.checkOut(this.fullName);
        this.viewer.setModeMouse(-1);
        this.viewer = null;
        System.out.println("Jmol applet " + this.fullName + " destroyed");
    }

    String getParameter(String string) {
        return this.appletWrapper.getParameter(string);
    }

    public void initWindows() {
        this.viewer = JmolViewer.allocateViewer((Component)this.appletWrapper, (JmolAdapter)new SmarterJmolAdapter());
        this.viewer.setAppletContext(this.fullName, this.appletWrapper.getDocumentBase(), this.appletWrapper.getCodeBase(), this.getValue("JmolAppletProxy", null));
        this.myStatusListener = new MyStatusListener();
        this.viewer.setJmolStatusListener(this.myStatusListener);
        String string = this.getParameter("menuFile");
        if (string != null) {
            this.menuStructure = this.viewer.getFileAsString(string);
        }
        this.jvm12orGreater = this.viewer.isJvm12orGreater();
        if (this.jvm12orGreater) {
            this.jvm12 = new Jvm12((Component)this.appletWrapper, this.viewer);
        }
        if (Logger.debugging) {
            Logger.debug((String)("checking for jsoWindow mayScript=" + this.mayScript));
        }
        if (this.mayScript) {
            this.haveDocumentAccess = false;
            this.mayScript = false;
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)this.appletWrapper);
                if (Logger.debugging) {
                    Logger.debug((String)("jsoWindow=" + jSObject));
                }
                if (jSObject == null) {
                    Logger.error((String)"jsoWindow returned null ... no JavaScript callbacks :-(");
                } else {
                    this.mayScript = true;
                    this.haveWindow = true;
                }
                jSObject2 = (JSObject)jSObject.getMember("document");
                if (jSObject2 == null) {
                    Logger.error((String)"jsoDocument returned null ... no DOM manipulations :-(");
                } else {
                    this.haveDocumentAccess = true;
                }
            }
            catch (Exception exception) {
                Logger.error((String)("Microsoft MSIE bug -- http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5012558 " + exception));
            }
            if (Logger.debugging) {
                Logger.debug((String)("jsoWindow:" + jSObject + " jsoDocument:" + jSObject2 + " mayScript:" + this.mayScript + " haveDocumentAccess:" + this.haveDocumentAccess));
            }
        }
    }

    void setLogging() {
        int n = (this.getValue("logLevel", "") + (this.getBooleanValue("debug", false) ? "5" : "4")).charAt(0) - 48;
        if (n != 4) {
            System.out.println("setting logLevel=" + n + " -- To change, use script \"set logLevel [0-5]\"");
        }
        Logger.setLogLevel((int)n);
    }

    boolean getBooleanValue(String string, boolean bl) {
        String string2 = this.getValue(string, bl ? "true" : "");
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes");
    }

    String getValue(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    String getValueLowerCase(String string, String string2) {
        String string3 = this.getValue(string, string2);
        if (string3 != null && (string3 = string3.trim().toLowerCase()).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public void initApplication() {
        this.viewer.pushHoldRepaint();
        this.hasProgressBar = this.getBooleanValue("progressbar", false);
        this.needPopupMenu = this.getBooleanValue("popupMenu", true);
        if (this.needPopupMenu) {
            this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)this.viewer, (boolean)this.doTranslate, (String)this.menuStructure);
        }
        this.emulate = this.getValueLowerCase("emulate", "jmol");
        if (this.emulate.equals("chime")) {
            this.viewer.setStringProperty("defaults", "RasMol");
        } else {
            this.viewer.setStringProperty("defaults", "Jmol");
        }
        String string = this.getValue("boxbgcolor", "black");
        string = this.getValue("bgcolor", string);
        this.viewer.setStringProperty("backgroundColor", string);
        this.loadNodeId(this.getValue("loadNodeId", null));
        this.viewer.setBooleanProperty("frank", true);
        this.animFrameCallback = this.getValue("AnimFrameCallback", null);
        this.loadStructCallback = this.getValue("LoadStructCallback", null);
        this.messageCallback = this.getValue("MessageCallback", null);
        this.pickCallback = this.getValue("PickCallback", null);
        this.resizeCallback = this.getValue("ResizeCallback", null);
        this.hoverCallback = this.getValue("HoverCallback", null);
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.animFrameCallback != null) {
            Logger.info((String)("animFrameCallback=" + this.animFrameCallback));
        }
        if (this.hoverCallback != null) {
            Logger.info((String)("hoverCallback=" + this.hoverCallback));
        }
        if (this.loadStructCallback != null) {
            Logger.info((String)("loadStructCallback=" + this.loadStructCallback));
        }
        if (this.messageCallback != null) {
            Logger.info((String)("messageCallback=" + this.messageCallback));
        }
        if (this.pickCallback != null) {
            Logger.info((String)("pickCallback=" + this.pickCallback));
        }
        if (this.resizeCallback != null) {
            Logger.info((String)("resizeCallback=" + this.resizeCallback));
        }
        if (this.statusForm != null && this.statusText != null) {
            Logger.info((String)("applet text status will be reported to document." + this.statusForm + "." + this.statusText));
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info((String)("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea));
        }
        if (!(this.animFrameCallback == null && this.loadStructCallback == null && this.messageCallback == null && this.hoverCallback == null && this.pickCallback == null && this.statusForm == null && this.statusText == null || this.mayScript)) {
            Logger.warn((String)"MAYSCRIPT missing -- all applet JavaScript calls disabled");
        }
        if (this.messageCallback != null || this.statusForm != null || this.statusText != null) {
            if (this.getValue("doTranslate", null) == null) {
                this.doTranslate = false;
                Logger.warn((String)"Note -- Presence of message callback will disable translation; to enable message translation use jmolSetTranslation(true) prior to jmolApplet()");
            }
            if (this.doTranslate) {
                Logger.warn((String)"Note -- Automatic language translation may affect parsing of callback messages; to disable language translation of callback messages, use jmolSetTranslation(false) prior to jmolApplet()");
            }
        }
        if ("none".equals(this.language)) {
            this.doTranslate = false;
        }
        if (!this.doTranslate) {
            GT.setDoTranslate(false);
            Logger.warn((String)"Note -- language translation disabled");
        }
        String string2 = this.getValue("script", "");
        String string3 = this.getValue("loadInline", null);
        if (string3 != null) {
            this.loadInlineSeparated(string3, string2.length() > 0 ? string2 : null);
        } else {
            string3 = this.getValue("load", null);
            if (string3 != null) {
                string2 = "load \"" + string3 + "\";" + string2;
            }
            if (string2.length() > 0) {
                this.scriptProcessor(string2, null, 2);
            }
        }
        this.viewer.popHoldRepaint();
    }

    void showStatusAndConsole(String string) {
        this.appletWrapper.showStatus(string);
        this.sendJsTextStatus(string);
        this.consoleMessage(string);
    }

    void sendMessageCallback(String string) {
        if (!this.mayScript || this.messageCallback == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            if (this.messageCallback.equals("alert")) {
                jSObject.call(this.messageCallback, string);
            } else if (this.messageCallback.length() > 0) {
                jSObject.call(this.messageCallback, this.htmlName, string);
            }
        }
        catch (Exception exception) {
            if (!this.haveNotifiedError && Logger.debugging) {
                Logger.debug((String)("messageCallback call error to " + this.messageCallback + ": " + exception));
            }
            this.haveNotifiedError = true;
        }
    }

    void sendJsTextStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusText);
                jSObject4.setMember("value", string);
            }
        }
        catch (Exception exception) {
            Logger.error((String)("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + exception.toString()));
        }
    }

    void sendJsTextareaStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusTextarea);
                String string2 = (String)jSObject4.getMember("value");
                jSObject4.setMember("value", string2 + "\n" + string);
            }
        }
        catch (Exception exception) {
            Logger.error((String)("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + exception.toString()));
        }
    }

    void consoleMessage(String string) {
        if (this.jvm12 != null) {
            this.jvm12.consoleMessage(string);
        }
        this.sendJsTextareaStatus(string);
    }

    public void paint(Graphics graphics) {
        this.update(graphics, "paint ");
    }

    public void update(Graphics graphics) {
        this.update(graphics, "update");
    }

    private void update(Graphics graphics, String string) {
        if (this.viewer == null) {
            return;
        }
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension dimension = this.jvm12orGreater ? this.jvm12.getSize() : this.appletWrapper.size();
        this.viewer.setScreenDimension(dimension);
        Rectangle rectangle = this.jvm12orGreater ? this.jvm12.getClipBounds(graphics) : graphics.getClipRect();
        ++this.paintCounter;
        if (!this.hasProgressBar && this.paintCounter < 30 && (this.paintCounter & 1) == 0) {
            this.printProgressbarMessage(graphics);
            this.viewer.repaintView();
        } else {
            this.viewer.renderScreenImage(graphics, dimension, rectangle);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, graphics);
        }
        this.isUpdating = false;
    }

    void printProgressbarMessage(Graphics graphics) {
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, 0, 10000, 10000);
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 13;
        while (n < progressbarMsgs.length) {
            graphics.drawString(progressbarMsgs[n], 10, n2);
            ++n;
            n2 += 13;
        }
    }

    public boolean handleEvent(Event event) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.handleOldJvm10Event(event);
    }

    void resetTimes() {
        this.timeTotal = 0;
        this.timeCount = 0;
        this.timeLast = -1;
    }

    void recordTime(int n) {
        if (this.timeLast != -1) {
            this.timeTotal += this.timeLast;
            ++this.timeCount;
        }
        this.timeLast = n;
    }

    void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int n = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != n) {
            this.lastMotionEventNumber = n;
            this.resetTimes();
        }
    }

    void stopPaintClock() {
        int n = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(n);
    }

    String fmt(int n) {
        if (n < 0) {
            return "---";
        }
        if (n < 10) {
            return "  " + n;
        }
        if (n < 100) {
            return " " + n;
        }
        return "" + n;
    }

    void showTimes(int n, int n2, Graphics graphics) {
        int n3 = this.timeCount == 0 ? -1 : (this.timeTotal + this.timeCount / 2) / this.timeCount;
        graphics.setColor(Color.green);
        graphics.drawString(this.fmt(this.timeLast) + "ms : " + this.fmt(n3) + "ms", n, n2);
    }

    public void scriptButton(JSObject jSObject, String string, String string2, String string3) {
        if (!this.mayScript || jSObject == null || string3 == null) {
            this.buttonCallbackNotificationPending = false;
            return;
        }
        Logger.info((String)(this.htmlName + " JmolApplet.scriptButton(" + jSObject + "," + string + "," + string2 + "," + string3));
        if (Logger.debugging) {
            Logger.debug((String)("!!!! calling back " + string3));
        }
        if (this.buttonCallbackBefore == null) {
            this.buttonCallbackBefore = new Object[]{null, Boolean.FALSE};
        }
        this.buttonCallbackBefore[0] = string;
        Logger.debug((String)"trying...");
        jSObject.call(string3, this.buttonCallbackBefore);
        Logger.debug((String)"made it");
        this.buttonCallbackNotificationPending = true;
        this.buttonCallback = string3;
        this.buttonWindow = jSObject;
        this.buttonName = string;
        this.scriptProcessor(string2, null, 2);
    }

    private String scriptProcessor(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        switch (n) {
            case 0: {
                String string3 = this.viewer.scriptCheck(string);
                return string3 == null ? "" : string3;
            }
            case 1: {
                if (string2 != null) {
                    return this.viewer.scriptWaitStatus(string, string2).toString();
                }
                return this.viewer.scriptWait(string);
            }
        }
        return this.viewer.script(string);
    }

    public void script(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.scriptProcessor(string, null, 2);
    }

    public String scriptCheck(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 0);
    }

    public String scriptNoWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 2);
    }

    public String scriptWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 1);
    }

    public String scriptWait(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, string2, 1);
    }

    public synchronized void syncScript(String string) {
        this.viewer.syncScript(string, "~");
    }

    public String getAppletInfo() {
        return GT._("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information", new Object[]{JmolConstants.version, JmolConstants.date}) + "\nhtmlName = " + Escape.escape((String)this.htmlName) + "\nsyncId = " + Escape.escape((String)this.syncId) + "\ndocumentBase = " + Escape.escape((String)("" + this.appletWrapper.getDocumentBase())) + "\ncodeBase = " + Escape.escape((String)("" + this.appletWrapper.getCodeBase()));
    }

    public Object getProperty(String string) {
        return this.viewer.getProperty(null, string, "");
    }

    public Object getProperty(String string, String string2) {
        return this.viewer.getProperty(null, string, string2);
    }

    public String getPropertyAsString(String string) {
        return this.viewer.getProperty("readable", string, "").toString();
    }

    public String getPropertyAsString(String string, String string2) {
        return this.viewer.getProperty("readable", string, string2).toString();
    }

    public String getPropertyAsJSON(String string) {
        return this.viewer.getProperty("JSON", string, "").toString();
    }

    public String getPropertyAsJSON(String string, String string2) {
        return this.viewer.getProperty("JSON", string, string2).toString();
    }

    public void loadInlineString(String string, String string2, boolean bl) {
        this.viewer.loadInline(string, bl);
        this.script(string2);
    }

    public void loadInlineArray(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.viewer.loadInline(stringArray, bl);
        this.script(string);
    }

    public void loadInline(String string) {
        this.loadInlineString(string, "", false);
    }

    public void loadInline(String string, String string2) {
        this.loadInlineString(string, string2, false);
    }

    public void loadInline(String[] stringArray) {
        this.loadInlineArray(stringArray, "", false);
    }

    public void loadInline(String[] stringArray, String string) {
        this.loadInlineArray(stringArray, string, false);
    }

    private void loadInlineSeparated(String string, String string2) {
        if (string == null) {
            return;
        }
        this.viewer.loadInline(string);
        this.script(string2);
    }

    public void loadDOMNode(JSObject jSObject) {
        this.viewer.openDOM(jSObject);
    }

    public void loadNodeId(String string) {
        if (!this.haveDocumentAccess) {
            return;
        }
        if (string != null) {
            Object[] objectArray;
            JSObject jSObject;
            Object[] objectArray2 = new Object[]{string};
            JSObject jSObject2 = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject3 = (JSObject)jSObject2.getMember("document");
            JSObject jSObject4 = (JSObject)jSObject3.call("getElementById", objectArray2);
            if (jSObject4 == null && (jSObject = (JSObject)jSObject3.call("getElementsByTagNameNS", objectArray = new Object[]{"http://www.xml-cml.org/schema/cml2/core", "cml"})) != null) {
                Object[] objectArray3;
                String string2;
                for (int i = 0; i < ((Number)jSObject.getMember("length")).intValue() && !string.equals(string2 = (String)(jSObject4 = (JSObject)jSObject.getSlot(i)).call("getAttribute", objectArray3 = new Object[]{"id"})); ++i) {
                }
            }
            if (jSObject4 != null) {
                this.loadDOMNode(jSObject4);
            }
        }
    }

    void loadPopupMenuAsBackgroundTask() {
        if (this.viewer.getOperatingSystemName().equals("Mac OS") && this.viewer.getJavaVersion().equals("1.1.5")) {
            return;
        }
        new Thread(new LoadPopupThread()).start();
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        protected void finalize() throws Throwable {
            Logger.debug((String)("MyStatusListener finalize " + this));
            super.finalize();
        }

        public String eval(String string) {
            if (string.equals("_GET_MENU")) {
                return Jmol.this.jmolpopup == null ? "" : Jmol.this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion());
            }
            if (!Jmol.this.haveDocumentAccess) {
                return "NO EVAL ALLOWED";
            }
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                jSObject2 = (JSObject)jSObject.getMember("document");
            }
            catch (Exception exception) {
                if (Logger.debugging) {
                    Logger.debug((String)(" error setting jsoWindow or jsoDocument:" + jSObject + ", " + jSObject2));
                }
                return "NO EVAL ALLOWED";
            }
            try {
                if (!Jmol.this.haveDocumentAccess || ((Boolean)jSObject2.eval("!!_jmol.noEval")).booleanValue()) {
                    return "NO EVAL ALLOWED";
                }
            }
            catch (Exception exception) {
                Logger.error((String)("# no _jmol in evaluating " + string + ":" + exception.toString()));
                return "";
            }
            try {
                return "" + jSObject2.eval(string);
            }
            catch (Exception exception) {
                Logger.error((String)("# error evaluating " + string + ":" + exception.toString()));
                return "";
            }
        }

        public void createImage(String string, Object object, int n) {
            String string2;
            String string3 = string2 = object instanceof String ? (String)object : new String((byte[])object);
            if (n == Integer.MAX_VALUE) {
                Jmol.this.consoleMessage(string2);
            }
        }

        public void notifyFileLoaded(String string, String string2, String string3, Object object, String string4) {
            if (string4 != null) {
                Jmol.this.showStatusAndConsole(GT._("File Error:") + string4);
                return;
            }
            if (!Jmol.this.mayScript || Jmol.this.loadStructCallback == null || string == null) {
                return;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (Jmol.this.loadStructCallback.equals("alert")) {
                    jSObject.call(Jmol.this.loadStructCallback, string);
                } else if (Jmol.this.loadStructCallback.length() > 0) {
                    jSObject.call(Jmol.this.loadStructCallback, Jmol.this.htmlName, string);
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug((String)("loadStructCallback call error to " + Jmol.this.loadStructCallback + ": " + exception));
                }
                Jmol.this.haveNotifiedError = true;
            }
        }

        public void notifyScriptStart(String string, String string2) {
            if (!Jmol.this.mayScript || Jmol.this.messageCallback == null) {
                return;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (Jmol.this.messageCallback.equals("alert")) {
                    jSObject.call(Jmol.this.messageCallback, string + " ; " + string2);
                } else if (Jmol.this.messageCallback.length() > 0) {
                    jSObject.call(Jmol.this.messageCallback, Jmol.this.htmlName, string, string2);
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug((String)("messageCallback call error to " + Jmol.this.messageCallback + ": " + exception));
                }
                Jmol.this.haveNotifiedError = true;
            }
            Jmol.this.showStatusAndConsole(string);
        }

        public float[][] functionXY(String string, int n, int n2) {
            float[][] fArray = new float[Math.abs(n)][Math.abs(n2)];
            if (!Jmol.this.mayScript || n == 0 || n2 == 0) {
                return fArray;
            }
            JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
            try {
                if (n > 0 && n2 > 0) {
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            fArray[i][j] = ((Double)jSObject.call(string, Jmol.this.htmlName, new Integer(i), new Integer(j))).floatValue();
                        }
                    }
                } else if (n2 > 0) {
                    String string2 = (String)jSObject.call(string, Jmol.this.htmlName, new Integer(n), new Integer(n2));
                    n = Math.abs(n);
                    float[] fArray2 = new float[n * n2];
                    Parser.parseFloatArray((String)string2, null, (float[])fArray2);
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n4 = 0;
                        while (n4 < n2) {
                            fArray[i][n4] = fArray2[n3];
                            ++n4;
                            ++n3;
                        }
                    }
                } else {
                    jSObject.call(string, new Object[]{Jmol.this.htmlName, new Integer(n), new Integer(n2), fArray});
                }
            }
            catch (Exception exception) {
                Logger.error((String)("Exception " + exception.getMessage() + " with nX, nY: " + n + " " + n2));
            }
            return fArray;
        }

        public void notifyNewPickingModeMeasurement(int n, String string) {
            this.sendConsoleMessage(string);
        }

        public void notifyNewDefaultModeMeasurement(int n, String string) {
            Jmol.this.showStatusAndConsole(string);
        }

        public void notifyResized(int n, int n2) {
            if (!Jmol.this.mayScript || Jmol.this.resizeCallback == null) {
                return;
            }
            JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
            try {
                if (Jmol.this.resizeCallback.length() > 0) {
                    jSObject.call(Jmol.this.resizeCallback, Jmol.this.htmlName, new Integer(n), new Integer(n2));
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug((String)("resizeCallback call error to " + Jmol.this.resizeCallback + ": " + exception));
                }
                Jmol.this.haveNotifiedError = true;
            }
        }

        public void notifyFrameChanged(int n, int n2, int n3, int n4, int n5) {
            int n6;
            boolean bl = n <= -2;
            int n7 = n4 < 0 ? -1 : 1;
            int n8 = n6 = n5 < 0 ? -1 : 1;
            if (Jmol.this.mayScript && Jmol.this.animFrameCallback != null) {
                try {
                    JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                    if (Jmol.this.animFrameCallback.length() > 0) {
                        jSObject.call(Jmol.this.animFrameCallback, Jmol.this.htmlName, new Integer(Math.max(n, -2 - n)), new Integer(n2), new Integer(n3), new Integer(Math.abs(n4)), new Integer(Math.abs(n5)), new Integer(bl ? 1 : 0), new Integer(n7), new Integer(n6));
                    }
                }
                catch (Exception exception) {
                    if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                        Logger.debug((String)("animFrameCallback call error to " + Jmol.this.animFrameCallback + ": " + exception));
                    }
                    Jmol.this.haveNotifiedError = true;
                }
            }
            if (Jmol.this.jmolpopup == null || bl) {
                return;
            }
            Jmol.this.jmolpopup.updateComputedMenus();
        }

        public void notifyAtomPicked(int n, String string) {
            Jmol.this.showStatusAndConsole(string);
            if (!Jmol.this.mayScript || Jmol.this.pickCallback == null) {
                return;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (Jmol.this.pickCallback.equals("alert")) {
                    jSObject.call(Jmol.this.pickCallback, string);
                } else if (Jmol.this.pickCallback.length() > 0) {
                    jSObject.call(Jmol.this.pickCallback, Jmol.this.htmlName, string, new Integer(n));
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug((String)("pickCallback call error to " + Jmol.this.pickCallback + ": " + exception));
                }
                Jmol.this.haveNotifiedError = true;
            }
        }

        public void notifyAtomHovered(int n, String string) {
            if (!Jmol.this.mayScript || Jmol.this.hoverCallback == null) {
                return;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (Jmol.this.hoverCallback.equals("alert")) {
                    jSObject.call(Jmol.this.hoverCallback, string);
                } else if (Jmol.this.hoverCallback.length() > 0) {
                    jSObject.call(Jmol.this.hoverCallback, Jmol.this.htmlName, string, new Integer(n));
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug((String)("hoverCallback call error to " + Jmol.this.hoverCallback + ": " + exception));
                }
                Jmol.this.haveNotifiedError = true;
            }
        }

        public void notifyScriptTermination(String string, int n) {
            Jmol.this.showStatusAndConsole(GT._(string));
            if (Jmol.this.buttonCallbackNotificationPending) {
                if (Logger.debugging) {
                    Logger.debug((String)("!!!! calling back " + Jmol.this.buttonCallback));
                }
                if (Jmol.this.buttonCallbackAfter == null) {
                    Jmol.this.buttonCallbackAfter = new Object[]{null, Boolean.TRUE};
                }
                Jmol.this.buttonCallbackAfter[0] = Jmol.this.buttonName;
                Jmol.this.buttonWindow.call(Jmol.this.buttonCallback, Jmol.this.buttonCallbackAfter);
            }
        }

        public void sendConsoleEcho(String string) {
            this.sendConsoleMessage(string);
        }

        public void sendConsoleMessage(String string) {
            Jmol.this.sendMessageCallback(string);
            Jmol.this.consoleMessage(string);
        }

        public void setCallbackFunction(String string, String string2) {
            if (string.equalsIgnoreCase("menu")) {
                Jmol.this.menuStructure = string2;
                if (Jmol.this.needPopupMenu) {
                    Jmol.this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)Jmol.this.viewer, (boolean)Jmol.this.doTranslate, (String)Jmol.this.menuStructure);
                }
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                new GT(string2);
                Jmol.this.language = GT.getLanguage();
                if (Jmol.this.needPopupMenu) {
                    Jmol.this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)Jmol.this.viewer, (boolean)Jmol.this.doTranslate, (String)Jmol.this.menuStructure);
                }
                return;
            }
            if (string.equalsIgnoreCase("AnimFrameCallback")) {
                Jmol.this.animFrameCallback = string2;
            } else if (string.equalsIgnoreCase("HoverCallback")) {
                Jmol.this.hoverCallback = string2;
            } else if (string.equalsIgnoreCase("LoadStructCallback")) {
                Jmol.this.loadStructCallback = string2;
            } else if (string.equalsIgnoreCase("MessageCallback")) {
                Jmol.this.messageCallback = string2;
            } else if (string.equalsIgnoreCase("PickCallback")) {
                Jmol.this.pickCallback = string2;
            } else if (string.equalsIgnoreCase("ResizeCallback")) {
                Jmol.this.resizeCallback = string2;
            } else {
                this.sendConsoleMessage("Available callbacks include: AnimFrameCallback, HoverCallback, LoadStructCallback, MessageCallback, PickCallback, and ResizeCallback");
            }
        }

        public void handlePopupMenu(int n, int n2) {
            if (Jmol.this.jmolpopup == null) {
                return;
            }
            if (!Jmol.this.language.equals(GT.getLanguage())) {
                Jmol.this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)Jmol.this.viewer, (boolean)Jmol.this.doTranslate, (String)Jmol.this.menuStructure);
                Jmol.this.language = GT.getLanguage();
            }
            Jmol.this.jmolpopup.show(n, n2);
        }

        public void showUrl(String string) {
            if (Logger.debugging) {
                Logger.debug((String)("showUrl(" + string + ")"));
            }
            if (string != null && string.length() > 0) {
                try {
                    URL uRL = new URL(string);
                    Jmol.this.appletWrapper.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (MalformedURLException malformedURLException) {
                    Jmol.this.showStatusAndConsole("Malformed URL:" + string);
                }
            }
        }

        public void showConsole(boolean bl) {
            if (Jmol.this.jvm12 != null) {
                Jmol.this.jvm12.showConsole(bl);
            }
        }

        public void sendSyncScript(String string, String string2) {
            Vector vector = JmolAppletRegistry.findApplets(string2, Jmol.this.syncId, Jmol.this.fullName);
            if (vector == null || vector.size() == 0) {
                Logger.error((String)(Jmol.this.fullName + " couldn't find applet " + string2));
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                JmolAppletInterface jmolAppletInterface = (JmolAppletInterface)JmolAppletRegistry.htRegistry.get(string3);
                if (Logger.debugging) {
                    Logger.debug((String)(Jmol.this.fullName + " sending to " + string3 + ": " + string));
                }
                try {
                    jmolAppletInterface.syncScript(string);
                    continue;
                }
                catch (Exception exception) {
                    Logger.error((String)(Jmol.this.htmlName + " couldn't send to " + string3 + ": " + string + ": " + exception));
                }
            }
        }
    }

    class LoadPopupThread
    implements Runnable {
        LoadPopupThread() {
        }

        protected void finalize() throws Throwable {
            Logger.debug((String)("LoadPopupThead finalize " + this));
            super.finalize();
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            Jmol.this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)Jmol.this.viewer, (boolean)Jmol.this.doTranslate, (String)Jmol.this.menuStructure);
        }
    }
}

