/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.geodesic;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.geodesic.Geodesic;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;

public final class EnvelopeCalculation {
    private short[] mads;
    private AtomData atomData = new AtomData();
    private AtomDataServer viewer;
    private int atomCount;
    public static final float SURFACE_DISTANCE_FOR_CALCULATION = 3.0f;
    public static final int MAX_LEVEL = 3;
    private float maxRadius = 0.0f;
    private float scale = 1.0f;
    private float setRadius = Float.MAX_VALUE;
    private float addRadius = Float.MAX_VALUE;
    private boolean modelZeroBased;
    private int[][] dotsConvexMaps;
    private int dotsConvexMax;
    private int geodesicCount;
    private int[] geodesicMap;
    private int[] mapT;
    private static final int[] mapNull = new int[0];
    private BitSet bsSurface;
    private boolean disregardNeighbors = false;
    private BitSet bsMySelected;
    private float radiusP;
    private float diameterP;
    private Point3f[] currentPoints;
    private int indexI;
    private Point3f centerI;
    private float radiusI;
    private float radiiIP2;
    private final Point3f pointT = new Point3f();
    private Point3f centerT;
    private final Point3f[] vertexTest = new Point3f[12];
    private static int[] power4 = new int[]{1, 4, 16, 64, 256};
    private int neighborCount;
    private int[] neighborIndices;
    private Point3f[] neighborCenters;
    private float[] neighborPlusProbeRadii2;
    private float[] neighborRadii2;

    public EnvelopeCalculation(AtomDataServer atomDataServer, int n, short[] sArray) {
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i] = new Point3f();
        }
        this.neighborIndices = new int[16];
        this.neighborCenters = new Point3f[16];
        this.neighborPlusProbeRadii2 = new float[16];
        this.neighborRadii2 = new float[16];
        this.viewer = atomDataServer;
        this.atomCount = n;
        this.mads = sArray;
        this.geodesicCount = Geodesic.getVertexVectorsCount();
        this.geodesicMap = EnvelopeCalculation.allocateBitmap(this.geodesicCount);
        this.mapT = EnvelopeCalculation.allocateBitmap(this.geodesicCount);
    }

    public int[][] getDotsConvexMaps() {
        return this.dotsConvexMaps;
    }

    public int getDotsConvexMax() {
        return this.dotsConvexMax;
    }

    public void allocDotsConvexMaps(int n) {
        if (this.dotsConvexMax >= n) {
            return;
        }
        this.dotsConvexMax = n;
        this.dotsConvexMaps = new int[n][];
    }

    public BitSet getBsSurfaceClone() {
        return this.bsSurface == null ? null : BitSetUtil.copy(this.bsSurface);
    }

    public void setMads(short[] sArray) {
        this.mads = sArray;
    }

    public void setFromBits(int n, BitSet bitSet) {
        EnvelopeCalculation.setAllBits(this.geodesicMap, this.geodesicCount);
        int n2 = this.geodesicCount;
        while (--n2 >= 0) {
            if (bitSet.get(n2)) continue;
            EnvelopeCalculation.clearBit(this.geodesicMap, n2);
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new int[this.atomCount][];
        }
        int[] nArray = mapNull;
        int n3 = this.getMapStorageCount(this.geodesicMap);
        if (n3 > 0) {
            nArray = new int[n3];
            System.arraycopy(this.geodesicMap, 0, nArray, 0, n3);
        }
        this.dotsConvexMaps[n] = nArray;
        this.dotsConvexMax = Math.max(this.dotsConvexMax, n);
    }

    public float getRadius() {
        return this.setRadius;
    }

    public void newSet() {
        this.dotsConvexMax = 0;
        this.dotsConvexMaps = null;
        this.diameterP = 0.0f;
        this.radiusP = 0.0f;
        this.mads = null;
    }

    public void calculate(float f, float f2, float f3, float f4, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.addRadius = f == Float.MAX_VALUE ? 0.0f : f;
        this.setRadius = f2 == Float.MAX_VALUE && !bl ? 3.0f : f2;
        this.scale = f3;
        this.atomData.useIonic = !bl;
        this.atomData.modelIndex = bl5 ? -1 : 0;
        this.modelZeroBased = !bl5;
        this.viewer.fillAtomData(this.atomData, 2);
        this.atomCount = this.atomData.atomCount;
        this.setRadii(bl);
        BitSet bitSet3 = bl3 && bitSet != null ? BitSetUtil.copy(bitSet) : (this.bsMySelected = bitSet2 != null ? BitSetUtil.setAll(this.atomCount) : null);
        if (bitSet2 != null) {
            BitSetUtil.andNot(this.bsMySelected, bitSet2);
        }
        this.disregardNeighbors = bl2;
        this.bsSurface = new BitSet();
        this.maxRadius = f4 == Float.MAX_VALUE ? f2 : f4;
        int n = this.atomCount;
        while (--n >= 0) {
            if (bitSet != null && !bitSet.get(n) || bitSet2 != null && bitSet2.get(n)) continue;
            this.setAtomI(n);
            this.getNeighbors();
            this.calcConvexMap(bl4);
        }
        this.currentPoints = null;
        this.setDotsConvexMax();
    }

    private void setRadii(boolean bl) {
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomData.atomRadius[i] = this.mads != null ? (float)this.mads[i] / 1000.0f : this.addRadius + (this.setRadius != Float.MAX_VALUE ? this.setRadius : this.atomData.atomRadius[i] * this.scale);
        }
    }

    public Point3f[] getPoints() {
        if (this.dotsConvexMaps == null) {
            this.calculate(Float.MAX_VALUE, 3.0f, 1.0f, Float.MAX_VALUE, this.bsMySelected, null, false, false, false, false, false);
        }
        if (this.currentPoints != null) {
            return this.currentPoints;
        }
        int n = 0;
        int n2 = 42;
        int n3 = this.dotsConvexMax;
        while (--n3 >= 0) {
            n += this.getPointCount(this.dotsConvexMaps[n3], n2);
        }
        Point3f[] point3fArray = new Point3f[n];
        if (n == 0) {
            return point3fArray;
        }
        n = 0;
        int n4 = this.dotsConvexMax;
        while (--n4 >= 0) {
            if (this.dotsConvexMaps[n4] == null) continue;
            int n5 = this.dotsConvexMaps[n4].length << 5;
            if (n5 > n2) {
                n5 = n2;
            }
            while (--n5 >= 0) {
                if (!EnvelopeCalculation.getBit(this.dotsConvexMaps[n4], n5)) continue;
                Point3f point3f = new Point3f();
                point3f.scaleAdd(this.atomData.atomRadius[n4], (Tuple3f)Geodesic.getVertexVector(n5), (Tuple3f)this.atomData.atomXyz[n4]);
                point3fArray[n++] = point3f;
            }
        }
        this.currentPoints = point3fArray;
        return point3fArray;
    }

    public static final boolean getBit(int[] nArray, int n) {
        return nArray[n >> 5] << (n & 0x1F) < 0;
    }

    private int getPointCount(int[] nArray, int n) {
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray.length << 5;
        if (n2 > n) {
            n2 = n;
        }
        int n3 = 0;
        n3 = 0;
        while (--n2 >= 0) {
            if (!EnvelopeCalculation.getBit(nArray, n2)) continue;
            ++n3;
        }
        return n3;
    }

    private void setDotsConvexMax() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            int n = this.atomCount;
            while (--n >= 0 && this.dotsConvexMaps[n] == null) {
            }
            this.dotsConvexMax = n + 1;
        }
    }

    public float getAppropriateRadius(int n) {
        return this.mads != null ? (float)this.mads[n] / 1000.0f : this.atomData.atomRadius[n];
    }

    private void setAtomI(int n) {
        this.indexI = n;
        this.centerI = this.atomData.atomXyz[n];
        this.radiusI = this.atomData.atomRadius[n];
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    private void calcConvexMap(boolean bl) {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new int[this.atomCount][];
        }
        this.calcConvexBits();
        int[] nArray = mapNull;
        int n = this.getMapStorageCount(this.geodesicMap);
        if (n > 0) {
            this.bsSurface.set(this.indexI);
            if (bl) {
                this.addIncompleteFaces(this.geodesicMap);
                this.addIncompleteFaces(this.geodesicMap);
            }
            n = this.getMapStorageCount(this.geodesicMap);
            nArray = new int[n];
            System.arraycopy(this.geodesicMap, 0, nArray, 0, n);
        }
        this.dotsConvexMaps[this.indexI] = nArray;
    }

    private int getMapStorageCount(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0 && nArray[n] == 0) {
        }
        return n + 1;
    }

    private void addIncompleteFaces(int[] nArray) {
        EnvelopeCalculation.clearBitmap(this.mapT);
        short[] sArray = Geodesic.getFaceVertexes(3);
        int n = sArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = sArray[n3++];
            int n5 = sArray[n3++];
            int n6 = sArray[n3++];
            boolean bl = EnvelopeCalculation.getBit(nArray, n4);
            boolean bl2 = EnvelopeCalculation.getBit(nArray, n5);
            boolean bl3 = EnvelopeCalculation.getBit(nArray, n6);
            if (!bl && !bl2 && !bl3 || bl && bl2 && bl3) continue;
            if (!bl) {
                EnvelopeCalculation.setBit(this.mapT, n4);
                if (n2 < n4) {
                    n2 = n4;
                }
            }
            if (!bl2) {
                EnvelopeCalculation.setBit(this.mapT, n5);
                if (n2 < n5) {
                    n2 = n5;
                }
            }
            if (bl3) continue;
            EnvelopeCalculation.setBit(this.mapT, n6);
            if (n2 >= n6) continue;
            n2 = n6;
        }
        for (n3 = 0; n3 <= n2; ++n3) {
            if (!EnvelopeCalculation.getBit(this.mapT, n3)) continue;
            EnvelopeCalculation.setBit(nArray, n3);
        }
    }

    private void calcConvexBits() {
        int n;
        EnvelopeCalculation.setAllBits(this.geodesicMap, this.geodesicCount);
        float f = this.radiusI + this.radiusP;
        if (this.neighborCount == 0) {
            return;
        }
        short[] sArray = Geodesic.getFaceVertexes(3);
        int n2 = power4[2];
        EnvelopeCalculation.clearBitmap(this.mapT);
        for (n = 0; n < 12; ++n) {
            this.vertexTest[n].set((Tuple3f)Geodesic.getVertexVector(n));
            this.vertexTest[n].scaleAdd(f, (Tuple3f)this.centerI);
        }
        for (n = 0; n < 20; ++n) {
            int n3;
            int n4 = 0;
            short s = sArray[3 * n2 * (4 * n + 0)];
            short s2 = sArray[3 * n2 * (4 * n + 1)];
            short s3 = sArray[3 * n2 * (4 * n + 2)];
            for (n3 = 0; n3 < this.neighborCount; ++n3) {
                boolean bl;
                float f2 = this.neighborPlusProbeRadii2[n3];
                this.centerT = this.neighborCenters[n3];
                boolean bl2 = this.vertexTest[s].distanceSquared(this.centerT) >= f2;
                boolean bl3 = this.vertexTest[s2].distanceSquared(this.centerT) >= f2;
                boolean bl4 = bl = this.vertexTest[s3].distanceSquared(this.centerT) >= f2;
                if (!bl2) {
                    EnvelopeCalculation.clearBit(this.geodesicMap, s);
                }
                if (!bl3) {
                    EnvelopeCalculation.clearBit(this.geodesicMap, s2);
                }
                if (!bl) {
                    EnvelopeCalculation.clearBit(this.geodesicMap, s3);
                }
                if (bl2 || bl3 || bl) continue;
                n4 = -1;
                break;
            }
            n3 = n * 12 * n2;
            int n5 = n3 + 12 * n2;
            for (int i = n3; i < n5; ++i) {
                short s4 = sArray[i];
                if (EnvelopeCalculation.getBit(this.mapT, s4) || !EnvelopeCalculation.getBit(this.geodesicMap, s4)) continue;
                switch (n4) {
                    case -1: {
                        EnvelopeCalculation.clearBit(this.geodesicMap, s4);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float f3 = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.set((Tuple3f)Geodesic.getVertexVector(s4));
                            this.pointT.scaleAdd(f, (Tuple3f)this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < f3)) continue;
                            EnvelopeCalculation.clearBit(this.geodesicMap, s4);
                        }
                        break;
                    }
                }
                EnvelopeCalculation.setBit(this.mapT, s4);
            }
        }
    }

    private void getNeighbors() {
        this.neighborCount = 0;
        if (this.disregardNeighbors) {
            return;
        }
        AtomIndexIterator atomIndexIterator = this.viewer.getWithinAtomSetIterator(this.indexI, this.radiusI + this.diameterP + this.maxRadius, this.bsMySelected, false, this.modelZeroBased);
        while (atomIndexIterator.hasNext()) {
            int n = atomIndexIterator.next();
            float f = this.atomData.atomRadius[n];
            if (this.centerI.distance(this.atomData.atomXyz[n]) > this.radiusI + this.radiusP + this.radiusP + f) continue;
            if (this.neighborCount == this.neighborIndices.length) {
                this.neighborIndices = ArrayUtil.doubleLength(this.neighborIndices);
                this.neighborCenters = (Point3f[])ArrayUtil.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = ArrayUtil.doubleLength(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = ArrayUtil.doubleLength(this.neighborRadii2);
            }
            this.neighborCenters[this.neighborCount] = this.atomData.atomXyz[n];
            this.neighborIndices[this.neighborCount] = n;
            float f2 = f + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = f2 * f2;
            this.neighborRadii2[this.neighborCount] = f * f;
            ++this.neighborCount;
        }
    }

    private static final int[] allocateBitmap(int n) {
        return new int[n + 31 >> 5];
    }

    private static final void setBit(int[] nArray, int n) {
        int n2 = n >> 5;
        nArray[n2] = nArray[n2] | 1 << (~n & 0x1F);
    }

    private static final void clearBit(int[] nArray, int n) {
        int n2 = n >> 5;
        nArray[n2] = nArray[n2] & ~(1 << (~n & 0x1F));
    }

    private static final void setAllBits(int[] nArray, int n) {
        int n2 = n >> 5;
        if ((n & 0x1F) != 0) {
            nArray[n2] = Integer.MIN_VALUE >> n - 1;
        }
        while (--n2 >= 0) {
            nArray[n2] = -1;
        }
    }

    private static final void clearBitmap(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = 0;
        }
    }
}

