/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.Function;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Eval {
    private static final int scriptLevelMax = 10;
    private Compiler compiler;
    private int scriptLevel;
    private int scriptReportingLevel = 0;
    private Context[] stack = new Context[10];
    private String filename;
    private String functionName;
    private String script;
    private Hashtable contextVariables;
    private String thisCommand;
    private short[] lineNumbers;
    private int[] lineIndices;
    private Token[][] aatoken;
    private int pc;
    private int lineEnd;
    private int pcEnd;
    private long timeBeginExecution;
    private long timeEndExecution;
    private boolean error;
    private String errorMessage;
    private Token[] statement;
    private int statementLength;
    private BitSet bsSubset;
    boolean isScriptCheck;
    private boolean historyDisabled;
    private boolean tQuiet;
    private boolean debugScript = false;
    private boolean fileOpenCheck = true;
    boolean logMessages;
    boolean isSyntaxCheck;
    Viewer viewer;
    int iToken;
    private StringBuffer outputBuffer;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    private Boolean interruptExecution = Boolean.FALSE;
    private Boolean executionPaused = Boolean.FALSE;
    private boolean isExecuting = false;
    private Thread currentThread = null;
    private int commandHistoryLevelMax = 0;
    boolean isForCheck = false;
    private final StringBuffer strbufLog = new StringBuffer(80);
    private Token[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private boolean coordinatesAreFractional;
    private int theTok;
    private Token theToken;
    private Hashtable variables = new Hashtable();
    private Object[] data;
    private int lastMoNumber = 0;
    private boolean ignoreError;

    String getScript() {
        return this.script;
    }

    Eval(Viewer viewer) {
        this.compiler = viewer.getCompiler();
        this.viewer = viewer;
        this.clearDefinitionsAndLoadPredefined();
    }

    private Object getParameter(String string, boolean bl) {
        Token token = this.getContextVariableAsToken(string);
        return token == null ? this.viewer.getParameter(string) : (bl ? token : Token.oValue(token));
    }

    private Object getNumericParameter(String string) {
        Token token = this.getContextVariableAsToken(string);
        if (token == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            token = new Token(4, object);
        }
        return Token.nValue(token);
    }

    private Token getContextVariableAsToken(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return (Token)this.contextVariables.get(string);
        }
        int n = this.scriptLevel;
        while (--n >= 0) {
            if (this.stack[n].contextVariables == null || !this.stack[n].contextVariables.containsKey(string)) continue;
            return (Token)this.stack[n].contextVariables.get(string);
        }
        return null;
    }

    private String getParameterEscaped(String string) {
        Token token = this.getContextVariableAsToken(string);
        return token == null ? "" + this.viewer.getParameterEscaped(string) : Escape.escape(token.value);
    }

    static Object evaluateExpression(Viewer viewer, String string) {
        Eval eval = new Eval(viewer);
        try {
            if (eval.loadScript(null, "e_x_p_r_e_s_s_i_o_n = " + string, false)) {
                eval.setStatement(0);
                return eval.parameterExpression(2, 0, "", false);
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + string + "\n" + exception);
        }
        return "ERROR";
    }

    static BitSet getAtomBitSet(Eval eval, Viewer viewer, Object object) {
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        if (eval == null) {
            eval = new Eval(viewer);
        }
        BitSet bitSet = new BitSet();
        try {
            eval.pushContext(null);
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters(string, "\n\r", "),(");
            string = TextFormat.simpleReplace(string, "()", "(none)");
            if (eval.loadScript(null, string, false)) {
                eval.statement = eval.aatoken[0];
                bitSet = eval.expression(eval.statement, 1, 0, false, false, true);
            }
            eval.popContext();
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bitSet;
    }

    static Vector getAtomBitSetVector(Eval eval, Viewer viewer, Object object) {
        Vector<Integer> vector = new Vector<Integer>();
        BitSet bitSet = Eval.getAtomBitSet(eval, viewer, object);
        int n = viewer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            vector.addElement(new Integer(i));
        }
        return vector;
    }

    void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = Boolean.TRUE;
    }

    boolean isScriptExecuting() {
        return this.isExecuting && this.interruptExecution == false;
    }

    void runEval(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.fileOpenCheck;
        this.fileOpenCheck = bl2;
        this.viewer.pushHoldRepaint();
        this.interruptExecution = Boolean.FALSE;
        this.executionPaused = Boolean.FALSE;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isScriptCheck = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = bl3;
        try {
            this.instructionDispatchLoop(bl4);
            String string = this.viewer.getInterruptScript();
            if (string != "") {
                this.runScript(string, null);
            }
        }
        catch (ScriptException scriptException) {
            this.error = true;
            this.setErrorMessage(scriptException.toString());
            this.scriptStatus(this.errorMessage);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.fileOpenCheck = bl5;
        if (this.errorMessage == null && this.interruptExecution.booleanValue()) {
            this.errorMessage = "execution interrupted";
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus("Script completed");
        }
        bl3 = false;
        this.isScriptCheck = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint();
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String string) {
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    private void runScript(String string) throws ScriptException {
        this.runScript(string, null);
    }

    void runScript(String string, StringBuffer stringBuffer) throws ScriptException {
        this.pushContext(null);
        if (stringBuffer != null) {
            this.outputBuffer = stringBuffer;
        }
        if (this.loadScript(null, string, false)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext();
    }

    private void pushContext(Function function) throws ScriptException {
        if (this.scriptLevel == 10) {
            this.evalError(GT._("too many script levels"));
        }
        Context context = new Context();
        context.filename = this.filename;
        context.functionName = this.functionName;
        context.script = this.script;
        context.lineNumbers = this.lineNumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.statement = this.statement;
        context.statementLength = this.statementLength;
        context.pc = this.pc;
        context.lineEnd = this.lineEnd;
        context.pcEnd = this.pcEnd;
        context.iToken = this.iToken;
        context.outputBuffer = this.outputBuffer;
        context.contextVariables = this.contextVariables;
        this.stack[this.scriptLevel++] = context;
        if (this.isScriptCheck) {
            Logger.info("-->>-------------".substring(0, this.scriptLevel + 5) + this.filename);
        }
    }

    private void popContext() {
        if (this.isScriptCheck) {
            Logger.info("--<<-------------".substring(0, this.scriptLevel + 5) + this.filename);
        }
        if (this.scriptLevel == 0) {
            return;
        }
        Context context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.filename = context.filename;
        this.functionName = context.functionName;
        this.script = context.script;
        this.lineNumbers = context.lineNumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.statement = context.statement;
        this.statementLength = context.statementLength;
        this.pc = context.pc;
        this.lineEnd = context.lineEnd;
        this.pcEnd = context.pcEnd;
        this.iToken = context.iToken;
        this.outputBuffer = context.outputBuffer;
        this.contextVariables = context.contextVariables;
    }

    private boolean loadScript(String string, String string2, boolean bl) {
        this.filename = string;
        if (!this.compiler.compile(string, string2, false, false, bl, false)) {
            this.error = true;
            this.errorMessage = this.compiler.getErrorMessage();
            return false;
        }
        this.script = this.compiler.getScript();
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.lineNumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        this.contextVariables = this.compiler.getContextVariables();
        return true;
    }

    private Function getFunction(String string, int n) {
        if (string == null) {
            return null;
        }
        Function function = (Function)(string.indexOf("_") == 0 ? this.compiler.localFunctions : Compiler.globalFunctions).get(string);
        return function == null || function.aatoken == null ? null : function;
    }

    private boolean loadFunction(String string, Vector vector, int n) {
        Function function = this.getFunction(string, n);
        if (function == null) {
            return false;
        }
        this.aatoken = function.aatoken;
        this.lineNumbers = function.lineNumbers;
        this.lineIndices = function.lineIndices;
        this.script = function.script;
        this.pc = 0;
        if (function.names != null) {
            this.contextVariables = new Hashtable();
            function.setVariables(this.contextVariables, vector);
        }
        this.functionName = string;
        return true;
    }

    Token getFunctionReturn(String string, Vector vector) throws ScriptException {
        this.pushContext(null);
        this.loadFunction(string, vector, 17326337);
        this.instructionDispatchLoop(false);
        Token token = this.getContextVariableAsToken("_retval");
        this.popContext();
        return token;
    }

    Object checkScriptSilent(String string) {
        if (!this.compiler.compile(null, string, false, true, false, true)) {
            return this.compiler.getErrorMessage();
        }
        this.isSyntaxCheck = true;
        this.isScriptCheck = false;
        this.errorMessage = null;
        this.script = this.compiler.getScript();
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.lineNumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        this.contextVariables = this.compiler.getContextVariables();
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
        }
        this.isSyntaxCheck = false;
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.compiler.getScript());
        vector.addElement(this.compiler.getAatokenCompiled());
        vector.addElement(this.compiler.getLineNumbers());
        vector.addElement(this.compiler.getLineIndices());
        return vector;
    }

    private void clearState(boolean bl) {
        int n = 10;
        while (--n >= 0) {
            this.stack[n] = null;
        }
        this.scriptLevel = 0;
        this.error = false;
        this.errorMessage = null;
        this.tQuiet = bl;
    }

    boolean loadScriptString(String string, boolean bl) {
        this.clearState(bl);
        return this.loadScript(null, string, this.debugScript);
    }

    boolean loadScriptFile(String string, boolean bl) {
        this.clearState(bl);
        return this.loadScriptFileInternal(string);
    }

    private boolean loadScriptFileInternal(String string) {
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.loadScript(string, this.viewer.eval(string.substring(11)), this.debugScript);
        }
        Object object = this.viewer.getBufferedReaderOrErrorMessageFromName(string, null);
        if (!(object instanceof BufferedReader)) {
            return this.loadError((String)object);
        }
        BufferedReader bufferedReader = (BufferedReader)object;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return this.ioError(string);
        }
        try {
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.loadScript(string, stringBuffer.toString(), this.debugScript);
    }

    private boolean loadError(String string) {
        this.error = true;
        this.errorMessage = string;
        return false;
    }

    private boolean ioError(String string) {
        return this.loadError("io error reading:" + string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eval\n pc:");
        stringBuffer.append(this.pc);
        stringBuffer.append("\n");
        stringBuffer.append(this.aatoken.length);
        stringBuffer.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            stringBuffer.append("----\n");
            Token[] tokenArray = this.aatoken[i];
            for (int j = 0; j < tokenArray.length; ++j) {
                stringBuffer.append(tokenArray[j]);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }

    private void clearPredefined(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.predefine(stringArray[i]);
        }
    }

    void clearDefinitionsAndLoadPredefined() {
        String string;
        this.variables.clear();
        this.bsSubset = null;
        this.viewer.setSelectionSubset(null);
        if (this.viewer.getModelSet() == null || this.viewer.getAtomCount() == 0) {
            return;
        }
        this.clearPredefined(JmolConstants.predefinedStatic);
        this.clearPredefined(JmolConstants.predefinedVariable);
        int n = 4;
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 > 1) {
            string = "@" + JmolConstants.elementNameFromNumber(n2) + " _e=" + n2;
            this.predefine(string);
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 1) {
            string = "@_" + JmolConstants.elementSymbolFromNumber(n2) + " " + JmolConstants.elementNameFromNumber(n2);
            this.predefine(string);
        }
        n2 = n;
        while (--n2 >= 0) {
            string = "@" + JmolConstants.altElementNameFromIndex(n2) + " _e=" + JmolConstants.altElementNumberFromIndex(n2);
            this.predefine(string);
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= n) {
            string = " element=" + JmolConstants.altElementNumberFromIndex(n2);
            String string2 = "@_" + JmolConstants.altElementSymbolFromIndex(n2);
            this.predefine(string2 + string);
            string2 = "@_" + JmolConstants.altIsotopeSymbolFromIndex(n2);
            this.predefine(string2 + string);
            string2 = "@" + JmolConstants.altElementNameFromIndex(n2);
            if (string2.length() <= 1) continue;
            this.predefine(string2 + string);
        }
    }

    private void predefine(String string) {
        if (this.compiler.compile("#predefine", string, true, false, false, false)) {
            Token[][] tokenArray = this.compiler.getAatokenCompiled();
            if (tokenArray.length != 1) {
                this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
                return;
            }
            Token[] tokenArray2 = tokenArray[0];
            if (tokenArray2.length > 2) {
                this.iToken = 1;
                int n = tokenArray2[1].tok;
                if (n == 1 || Compiler.tokAttr(n, 0x180000)) {
                    String string2 = (String)tokenArray2[1].value;
                    this.variables.put(string2, tokenArray2);
                } else {
                    this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
                }
            } else {
                this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            }
        } else {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + this.compiler.getErrorMessage());
        }
    }

    private void setShapeProperty(int n, String string, Object object) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(n, string, object);
        }
    }

    private void setShapeSize(int n, int n2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeSize(n, n2);
        }
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private void setIntProperty(String string, int n) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(string, n);
        }
    }

    private void setFloatProperty(String string, float f) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(string, f);
        }
    }

    private void setStringProperty(String string, String string2) {
        if (!this.isSyntaxCheck || string.equalsIgnoreCase("defaultdirectory")) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    void pauseExecution() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.delay(100L);
        this.viewer.popHoldRepaint();
        this.executionPaused = Boolean.TRUE;
    }

    boolean isExecutionPaused() {
        return this.executionPaused;
    }

    void resumePausedExecution() {
        this.executionPaused = Boolean.FALSE;
    }

    private boolean checkContinue() {
        if (!this.interruptExecution.booleanValue()) {
            if (!this.executionPaused.booleanValue()) {
                return true;
            }
            if (Logger.debugging) {
                Logger.debug("script execution paused at this command: " + this.thisCommand);
            }
            try {
                while (this.executionPaused.booleanValue()) {
                    Thread.sleep(100L);
                    String string = this.viewer.getInterruptScript();
                    if (string == "") continue;
                    this.resumePausedExecution();
                    this.error = false;
                    --this.pc;
                    try {
                        this.runScript(string);
                    }
                    catch (Exception exception) {
                        this.error = true;
                        this.errorMessage = exception.toString();
                    }
                    ++this.pc;
                    if (this.error) {
                        this.scriptStatus(this.errorMessage);
                    }
                    this.pauseExecution();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.debug("script execution resumed");
        }
        return this.interruptExecution == false;
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.statement = this.aatoken[n];
        this.statementLength = this.statement.length;
        for (n2 = 1; n2 < this.statementLength && this.statement[n2].tok != 590601; ++n2) {
        }
        if (n2 == this.statementLength) {
            return n2 == this.statementLength;
        }
        Token[] tokenArray = new Token[this.statementLength];
        tokenArray[0] = this.statement[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            int n4 = this.statement[n2].tok;
            switch (n4) {
                case 590601: {
                    Object object;
                    Serializable serializable;
                    boolean bl2;
                    String string = this.parameterAsString(++n2);
                    boolean bl3 = bl2 = this.tokAt(n2) == 524388;
                    if (bl2) {
                        if ((serializable = (Vector)this.parameterExpression(++n2, 0, "_var", true)).size() == 0) {
                            this.invalidArgument();
                        }
                        n2 = this.iToken;
                        Token token = (Token)serializable.elementAt(0);
                        object = token.tok == 6 ? token : Token.oValue(token);
                    } else {
                        object = this.getParameter(string, false);
                    }
                    if (object instanceof Token) {
                        tokenArray[n3] = (Token)object;
                        if (bl && tokenArray[n3].tok == 6) {
                            tokenArray[n3] = new Token(262215, Eval.getAtomBitSet(this, this.viewer, Token.sValue(tokenArray[n3])));
                        }
                    } else if (object instanceof Boolean) {
                        tokenArray[n3] = (Boolean)object != false ? Token.tokenOn : Token.tokenOff;
                    } else if (object instanceof Integer) {
                        tokenArray[n3] = new Token(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tokenArray[n3] = new Token(3, Compiler.modelValue("" + object), object);
                    } else if (object instanceof String) {
                        if ((object = this.getStringObjectAsToken((String)object, null)) instanceof Token) {
                            tokenArray[n3] = (Token)object;
                        } else {
                            String string2 = (String)object;
                            int n5 = bl ? 262215 : (bl2 ? 4 : (n4 = string2.indexOf(".") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 1));
                            tokenArray[n3] = bl ? new Token(262215, Eval.getAtomBitSet(this, this.viewer, string2)) : new Token(n4, string2);
                        }
                    } else if (object instanceof BitSet) {
                        tokenArray[n3] = new Token(262215, object);
                    } else if (object instanceof Point3f) {
                        tokenArray[n3] = new Token(7, object);
                    } else if (object instanceof Point4f) {
                        tokenArray[n3] = new Token(8, object);
                    } else {
                        serializable = this.getDrawObjectCenter(string);
                        if (serializable == null) {
                            this.invalidArgument();
                        }
                        tokenArray[n3] = new Token(7, serializable);
                    }
                    if (n3 != 1 || this.statement[0].tok != 169247 || tokenArray[n3].tok == 1) break;
                    this.invalidArgument();
                    break;
                }
                case 524388: 
                case 524389: {
                    bl = n4 == 524388;
                    tokenArray[n3] = this.statement[n2];
                    break;
                }
                default: {
                    tokenArray[n3] = this.statement[n2];
                }
            }
            ++n3;
        }
        this.statement = tokenArray;
        this.statementLength = n3;
        return true;
    }

    private Object getStringObjectAsToken(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = Token.unescapePointOrBitsetAsToken(string);
        if (object instanceof String && string2 != null) {
            return this.viewer.getListVariable(string2, object);
        }
        return object;
    }

    private void instructionDispatchLoop(boolean bl) throws ScriptException {
        long l = 0L;
        this.isForCheck = false;
        this.debugScript = !this.isSyntaxCheck && this.viewer.getDebugScript();
        boolean bl2 = this.logMessages = this.debugScript && Logger.debugging;
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + l);
            this.viewer.scriptStatus(this.toString());
        }
        if (!this.historyDisabled && !this.isSyntaxCheck && this.scriptLevel <= this.commandHistoryLevelMax) {
            this.viewer.addCommand(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && this.checkContinue()) {
            block114: {
                Token token;
                block116: {
                    block115: {
                        block113: {
                            token = this.aatoken[this.pc][0];
                            if (this.setStatement(this.pc)) break block113;
                            Logger.info(this.getCommand() + " -- STATEMENT CONTAINING @{} SKIPPED");
                            break block114;
                        }
                        if (this.lineNumbers[this.pc] > this.lineEnd) break;
                        this.thisCommand = this.getCommand();
                        this.iToken = 0;
                        String string = this.viewer.getInterruptScript();
                        if (string != "") {
                            this.runScript(string);
                        }
                        if (bl || !this.isSyntaxCheck) {
                            int n = this.viewer.getScriptDelay();
                            if (bl || n > 0 && this.scriptLevel > 0) {
                                if (n > 0) {
                                    this.delay(n);
                                }
                                this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                            }
                        }
                        if (!this.isSyntaxCheck) break block115;
                        if (this.isScriptCheck) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.statementLength != 1 || this.statement[0].tok == 17326337) break block116;
                        break block114;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.logMessages) {
                        Logger.debug(token.toString());
                    }
                }
                switch (token.tok) {
                    case 16644: 
                    case 16645: 
                    case 16648: 
                    case 16649: 
                    case 24842: 
                    case 54530: 
                    case 54531: 
                    case 54534: 
                    case 54535: {
                        this.flowControl(token.tok);
                        break;
                    }
                    case 0x180100: {
                        this.proteinShape(7);
                        break;
                    }
                    case 196865: {
                        this.background(1);
                        break;
                    }
                    case 772: {
                        this.center(1);
                        break;
                    }
                    case 74126595: {
                        this.color();
                        break;
                    }
                    case 17301778: {
                        this.data();
                        break;
                    }
                    case 590601: {
                        this.define();
                        break;
                    }
                    case 67851: {
                        this.echo(1);
                        break;
                    }
                    case 2405: {
                        this.message();
                        break;
                    }
                    case 262200: {
                        break;
                    }
                    case 268: {
                        if (!this.isSyntaxCheck && this.pc > 0) {
                            this.viewer.clearScriptQueue();
                        }
                    }
                    case 277: {
                        if (this.isSyntaxCheck) break;
                        this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue() ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 23660815: {
                        this.label(1);
                        break;
                    }
                    case 2385: {
                        this.hover();
                        break;
                    }
                    case 17305865: {
                        this.load();
                        break;
                    }
                    case 591122: {
                        this.monitor();
                        break;
                    }
                    case 278: {
                        this.refresh();
                        break;
                    }
                    case 305: {
                        this.initialize();
                        break;
                    }
                    case 280: {
                        this.reset();
                        break;
                    }
                    case 5403: {
                        this.rotate(false, false);
                        break;
                    }
                    case 17301771: 
                    case 17303820: {
                        this.script(token.tok == 17303820);
                        break;
                    }
                    case 17326337: {
                        this.function(token.tok);
                        break;
                    }
                    case 375: {
                        this.sync();
                        break;
                    }
                    case 65898: {
                        this.history(1);
                        break;
                    }
                    case 798: {
                        this.select();
                        break;
                    }
                    case 4394: {
                        this.translate();
                        break;
                    }
                    case 5491: {
                        this.invertSelected();
                        break;
                    }
                    case 5492: {
                        this.rotate(false, true);
                        break;
                    }
                    case 4454: {
                        this.translateSelected();
                        break;
                    }
                    case 302: {
                        this.zap();
                        break;
                    }
                    case 5423: {
                        this.zoom(false);
                        break;
                    }
                    case 5424: {
                        this.zoom(true);
                        break;
                    }
                    case 316: {
                        this.delay();
                        break;
                    }
                    case 317: {
                        this.delay();
                        if (this.isSyntaxCheck) break;
                        this.pc = -1;
                        break;
                    }
                    case 370: {
                        this.gotocmd();
                        break;
                    }
                    case 4414: {
                        this.move();
                        break;
                    }
                    case 66411: {
                        this.display(true);
                        break;
                    }
                    case 847: {
                        this.display(false);
                        break;
                    }
                    case 793: {
                        this.restrict();
                        break;
                    }
                    case 1573740: {
                        this.subset();
                        break;
                    }
                    case 65897: {
                        this.selectionHalo(1);
                        break;
                    }
                    case 169247: {
                        this.set();
                        break;
                    }
                    case 5409: {
                        this.slab(false);
                        break;
                    }
                    case 5426: {
                        this.slab(true);
                        break;
                    }
                    case 307: {
                        this.star();
                        break;
                    }
                    case 2622740: {
                        this.structure();
                        break;
                    }
                    case 341: {
                        this.halo();
                        break;
                    }
                    case 4387: {
                        this.spacefill();
                        break;
                    }
                    case 300: {
                        this.wireframe();
                        break;
                    }
                    case 4435: {
                        this.vector();
                        break;
                    }
                    case 5473: {
                        this.dipole();
                        break;
                    }
                    case 323: {
                        this.animation();
                        break;
                    }
                    case 4434: {
                        this.vibration();
                        break;
                    }
                    case 1383: {
                        this.calculate();
                        break;
                    }
                    case 1290: {
                        this.dots(1, 6);
                        break;
                    }
                    case 65831: {
                        this.proteinShape(10);
                        break;
                    }
                    case 340: {
                        this.proteinShape(11);
                        break;
                    }
                    case 282: {
                        this.proteinShape(12);
                        break;
                    }
                    case 297: {
                        this.proteinShape(8);
                        break;
                    }
                    case 259: {
                        this.proteinShape(9);
                        break;
                    }
                    case 342: {
                        this.proteinShape(13);
                        break;
                    }
                    case 70976: {
                        this.rotate(true, false);
                        break;
                    }
                    case 65828: {
                        this.ssbond();
                        break;
                    }
                    case 590093: {
                        this.hbond(true);
                        break;
                    }
                    case 288: {
                        this.show();
                        break;
                    }
                    case 2621704: {
                        this.file();
                        break;
                    }
                    case 324: 
                    case 2621709: {
                        this.frame(1);
                        break;
                    }
                    case 336: {
                        this.font(-1, 0);
                        break;
                    }
                    case 5464: {
                        this.moveto();
                        break;
                    }
                    case 5489: {
                        this.navigate();
                        break;
                    }
                    case 4441: {
                        this.bondorder();
                        break;
                    }
                    case 346: {
                        this.console();
                        break;
                    }
                    case 347: {
                        this.pmesh();
                        break;
                    }
                    case 136543: {
                        this.draw();
                        break;
                    }
                    case 132444: {
                        this.polyhedra();
                        break;
                    }
                    case 1367: {
                        this.dots(1, 18);
                        break;
                    }
                    case 349: {
                        this.centerAt();
                        break;
                    }
                    case 136542: {
                        this.isosurface(21);
                        break;
                    }
                    case 136548: {
                        this.lcaoCartoon();
                        break;
                    }
                    case 135523: {
                        this.mo(false);
                        break;
                    }
                    case 135462: {
                        this.stereo();
                        break;
                    }
                    case 136455: {
                        this.connect();
                        break;
                    }
                    case 17302785: {
                        this.getProperty();
                        break;
                    }
                    case 354: {
                        this.configuration();
                        break;
                    }
                    case 65901: {
                        this.axes(1);
                        break;
                    }
                    case 6886669: {
                        this.boundbox(1);
                        break;
                    }
                    case 1638767: {
                        this.unitcell(1);
                        break;
                    }
                    case 65904: {
                        this.frank(1);
                        break;
                    }
                    case 2318: {
                        this.help();
                        break;
                    }
                    case 284: {
                        this.save();
                        break;
                    }
                    case 360: {
                        this.restore();
                        break;
                    }
                    case 374: {
                        this.dataFrame(0);
                        break;
                    }
                    case 373: {
                        this.dataFrame(1);
                        break;
                    }
                    case 301: {
                        this.write();
                        break;
                    }
                    case 38264: {
                        this.print();
                        break;
                    }
                    case 38265: {
                        this.returnCmd();
                        break;
                    }
                    case 264467: {
                        this.pause();
                        break;
                    }
                    default: {
                        this.unrecognizedCommand();
                    }
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setCursor(0);
                }
            }
            ++this.pc;
        }
    }

    private void flowControl(int n) throws ScriptException {
        int n2 = this.statement[0].intValue;
        boolean bl = n2 < 0 && !this.isSyntaxCheck;
        boolean bl2 = true;
        int n3 = 0;
        switch (n) {
            case 54530: 
            case 54531: {
                boolean bl3 = bl2 = !bl && this.ifCmd();
                if (this.isSyntaxCheck) break;
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl || bl2 ? -n3 : n3;
                break;
            }
            case 16644: {
                this.checkStatementLength(1);
                if (n2 >= 0 || this.isSyntaxCheck) break;
                this.pc = -n2 - 1;
                break;
            }
            case 16645: {
                this.checkStatementLength(1);
                break;
            }
            case 24842: {
                this.checkLength2();
                this.isForCheck = this.tokAt(1) == 54534;
                bl2 = this.tokAt(1) == 54530;
                break;
            }
            case 54535: {
                this.isForCheck = false;
                if (this.ifCmd() || this.isSyntaxCheck) break;
                this.pc = n2;
                break;
            }
            case 16648: {
                if (!this.isSyntaxCheck) {
                    this.pc = this.aatoken[n2][0].intValue;
                }
                if (this.statementLength <= 1) break;
                this.checkLength2();
                this.intParameter(1);
                break;
            }
            case 16649: {
                this.isForCheck = true;
                if (!this.isSyntaxCheck) {
                    this.pc = n2 - 1;
                }
                if (this.statementLength <= 1) break;
                this.checkLength2();
                this.intParameter(1);
                break;
            }
            case 54534: {
                int[] nArray = new int[2];
                int n4 = 0;
                for (int i = 1; i < this.statementLength && n4 < 2; ++i) {
                    if (this.tokAt(i) != 524302) continue;
                    nArray[n4++] = i;
                }
                if (this.isForCheck) {
                    n4 = nArray[1] + 1;
                    this.isForCheck = false;
                } else {
                    n4 = 2;
                    if (this.tokAt(n4) == 111994) {
                        ++n4;
                    }
                }
                if (this.tokAt(n4) == 1) {
                    String string = this.parameterAsString(n4);
                    if (this.getToken((int)(++n4)).tok != 42467380) {
                        this.invalidArgument();
                    }
                    this.setVariable(++n4, this.statementLength - 1, string, false);
                }
                bl2 = (Boolean)this.parameterExpression(nArray[0] + 1, nArray[1], null, false);
                ++n2;
            }
        }
        if (!bl2 && !this.isSyntaxCheck) {
            this.pc = Math.abs(n2) - 1;
        }
    }

    private boolean ifCmd() throws ScriptException {
        return (Boolean)this.parameterExpression(1, 0, null, false);
    }

    private int getLinenumber() {
        return this.lineNumbers[this.pc];
    }

    private String getCommand() {
        int n = this.lineIndices[this.pc];
        int n2 = this.pc + 1 == this.lineIndices.length || this.lineIndices[this.pc + 1] == 0 ? this.script.length() : this.lineIndices[this.pc + 1];
        String string = "";
        try {
            string = this.script.substring(n, n2);
            int n3 = string.indexOf("\n");
            if (n3 >= 0) {
                string = string.substring(0, n3);
            }
            if ((n3 = string.indexOf("\r")) >= 0) {
                string = string.substring(0, n3);
            }
            if (!string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n + " ichEnd=" + n2 + " len = " + this.script.length() + " script = " + this.script + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(int n) {
        this.strbufLog.setLength(0);
        if (this.logMessages) {
            Logger.debug(this.statement[0].toString());
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug(this.statement[i].toString());
            }
        }
        this.iToken = -2;
        String string = n > 0 ? "                          ".substring(0, n * 2) : "";
        this.strbufLog.append(string).append(this.statementAsString());
        this.viewer.scriptStatus(this.strbufLog.toString());
    }

    private BitSet expression(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.badArgumentCount();
        }
        return this.expression(this.statement, n, 0, true, false, true);
    }

    private BitSet expression(Token[] tokenArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        this.isBondSet = false;
        if (tokenArray != this.statement) {
            this.tempStatement = this.statement;
            this.statement = tokenArray;
        }
        Rpn rpn = new Rpn(64, false, false);
        int n3 = Integer.MAX_VALUE;
        boolean bl4 = false;
        this.iToken = 1000;
        boolean bl5 = n < 0;
        boolean bl6 = false;
        int n4 = this.viewer.getAtomCount();
        if (bl5) {
            n = -n;
        }
        if (n2 == 0) {
            n2 = n + 1;
        }
        block35: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            Token token = tokenArray[i];
            if (token == null) break;
            Object object = token.value;
            switch (token.tok) {
                case 524388: {
                    n = i;
                    n2 = tokenArray.length;
                    continue block35;
                }
                case 524389: {
                    break block35;
                }
                case 524291: {
                    Point3f point3f;
                    if (!this.isPoint3f(i) || (point3f = this.getPoint3f(i, true)) == null) continue block35;
                    rpn.addX(point3f);
                    i = this.iToken;
                    continue block35;
                }
                case 524292: {
                    continue block35;
                }
                case 0x880010: {
                    bl6 = true;
                    rpn.addOp(token);
                    continue block35;
                }
                case 0x880011: {
                    bl6 = false;
                    rpn.addOp(token);
                    continue block35;
                }
                case 1: {
                    Object object2 = this.getParameter((String)object, true);
                    if (object2 instanceof String) {
                        object2 = this.getStringObjectAsToken((String)object2, null);
                    }
                    if (object2 instanceof String) {
                        object2 = this.lookupIdentifierValue((String)object);
                    }
                    rpn.addX(object2);
                    continue block35;
                }
                case 590601: {
                    rpn.addX(Eval.getAtomBitSet(this, this.viewer, (String)object));
                    continue block35;
                }
                case 17303586: {
                    rpn.addX(token);
                    rpn.addX(new Token(8, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block35;
                }
                case 524300: {
                    rpn.addX(token);
                    rpn.addX(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block35;
                }
                case 4: {
                    rpn.addX(token);
                    if (!((String)object).equals("hkl")) continue block35;
                    rpn.addX(new Token(8, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block35;
                }
                case 0x880008: 
                case 17301514: 
                case 17301545: 
                case 17301546: {
                    rpn.addOp(token);
                    continue block35;
                }
                case 524303: {
                    rpn.addX(this.viewer.getModelAtomBitSet(-1, true));
                    continue block35;
                }
                case 524301: {
                    rpn.addX(new BitSet());
                    continue block35;
                }
                case 524304: 
                case 524305: {
                    rpn.addX(token.tok == 524305);
                    continue block35;
                }
                case 1572867: {
                    rpn.addX(BitSetUtil.copy(this.viewer.getSelectionSet()));
                    continue block35;
                }
                case 1573740: {
                    rpn.addX(this.bsSubset == null ? this.viewer.getModelAtomBitSet(-1, true) : BitSetUtil.copy(this.bsSubset));
                    continue block35;
                }
                case 1572884: {
                    rpn.addX(BitSetUtil.copy(this.viewer.getHiddenSet()));
                    continue block35;
                }
                case 1572885: {
                    rpn.addX(BitSetUtil.copyInvert(this.viewer.getHiddenSet(), n4));
                    continue block35;
                }
                case 0x180011: {
                    if (!this.isSyntaxCheck && !bl4) {
                        this.viewer.setModelVisibility();
                    }
                    bl4 = true;
                    rpn.addX(this.viewer.getVisibleSet());
                    continue block35;
                }
                case 1572882: {
                    if (!this.isSyntaxCheck && bl) {
                        this.refresh();
                    }
                    rpn.addX(this.viewer.getClickableSet());
                    continue block35;
                }
                case 524306: 
                case 1572870: 
                case 1572871: 
                case 0x180008: 
                case 1572873: 
                case 1572874: 
                case 1572875: 
                case 1572883: 
                case 1572886: 
                case 1572887: 
                case 0x190001: 
                case 1638402: 
                case 1638767: {
                    rpn.addX(this.getAtomBits(token.tok));
                    continue block35;
                }
                case 524313: 
                case 524317: 
                case 524320: {
                    rpn.addX(this.viewer.getAtomBits(token.tok, (String)object));
                    continue block35;
                }
                case 524318: 
                case 524319: {
                    int n5 = token.intValue;
                    if (n5 == Integer.MAX_VALUE) {
                        n5 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            rpn.addX(this.getAtomBits(524318, n5));
                            continue block35;
                        }
                        n5 = n5 < 1000 ? (n5 *= 1000000) : n5 / 1000 * 1000000 + n5 % 1000;
                    }
                    rpn.addX(this.bitSetForModelFileNumber(n5));
                    continue block35;
                }
                case 524312: 
                case 524316: {
                    rpn.addX(this.getAtomBits(token.tok, token.intValue));
                    continue block35;
                }
                case 524314: {
                    if (bl6) {
                        rpn.addX(token.intValue);
                        continue block35;
                    }
                    rpn.addX(this.getAtomBits(token.tok, Eval.getSeqCode(token)));
                    continue block35;
                }
                case 524315: {
                    if (bl6) {
                        rpn.addX(token.intValue);
                        rpn.addX(Token.tokenMinus);
                        rpn.addX(tokenArray[++i].intValue);
                        continue block35;
                    }
                    rpn.addX(this.getAtomBits(token.tok, new int[]{Eval.getSeqCode(token), Eval.getSeqCode(tokenArray[++i])}));
                    continue block35;
                }
                case 2621445: {
                    Point3f point3f = (Point3f)object;
                    rpn.addX(this.getAtomBits(2621445, new int[]{(int)(point3f.x * 1000.0f), (int)(point3f.y * 1000.0f), (int)(point3f.z * 1000.0f)}));
                    continue block35;
                }
                case 1572877: {
                    rpn.addX(this.viewer.getModelAtomBitSet(this.viewer.getCurrentModelIndex(), true));
                    continue block35;
                }
                case 0x180000: 
                case 1572869: 
                case 1572876: 
                case 0x180100: 
                case 1638404: {
                    rpn.addX(this.lookupIdentifierValue((String)object));
                    continue block35;
                }
                case 42467376: 
                case 42467377: 
                case 42467378: 
                case 42467379: 
                case 42467380: 
                case 42467381: {
                    String string;
                    Object object2 = tokenArray[++i].value;
                    int n6 = token.tok;
                    int n7 = token.intValue;
                    String string2 = string = n7 == 73990156 ? (String)object2 : null;
                    if (string != null) {
                        object2 = tokenArray[++i].value;
                    }
                    if (this.isSyntaxCheck) {
                        rpn.addX(new BitSet());
                        continue block35;
                    }
                    boolean bl7 = n7 == 2621709;
                    boolean bl8 = n7 == 2686993;
                    int n8 = tokenArray[i].tok;
                    n3 = tokenArray[i].intValue;
                    float f = Float.NaN;
                    if (object2 instanceof String) {
                        if (n8 == 1) {
                            object2 = this.getNumericParameter((String)object2);
                        }
                        if (object2 instanceof String) {
                            object2 = Token.nValue(tokenArray[i]);
                        }
                        if (object2 instanceof Integer) {
                            n3 = (Integer)object2;
                            f = n3;
                        } else if (object2 instanceof Float && bl7) {
                            n3 = ModelCollection.modelFileNumberFromFloat(((Float)object2).floatValue());
                        }
                    }
                    if (object2 instanceof Integer || n8 == 2) {
                        f = n3 *= Compiler.tokAttr(n7, 0x280020) ? 100 : 1;
                        if (bl7 && this.viewer.haveFileSet() && n3 >= 1000 && n3 < 1000000) {
                            n3 = n3 / 1000 * 1000000 + n3 % 1000;
                            n7 = -2621709;
                        }
                    } else if (object2 instanceof Float) {
                        if (bl7) {
                            n7 = -2621709;
                        } else {
                            f = ((Float)object2).floatValue();
                            n3 = (int)(f * (bl8 ? 250.0f : 100.0f));
                        }
                    } else {
                        ++this.iToken;
                        this.invalidArgument();
                    }
                    if (bl7 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n7 = 2621704;
                        bl7 = false;
                    }
                    if (n7 == -2621709 && n6 == 42467380) {
                        rpn.addX(this.bitSetForModelFileNumber(n3));
                        continue block35;
                    }
                    if (((String)object).indexOf("-") >= 0) {
                        if (!Float.isNaN(f)) {
                            f = -f;
                        }
                        n3 = -n3;
                    }
                    float[] fArray = n7 == 73990156 ? this.viewer.getDataFloat(string) : null;
                    rpn.addX(this.comparatorInstruction(token, n7, fArray, n6, n3, f));
                    continue block35;
                }
                case 3: 
                case 7: 
                case 8: 
                case 262215: {
                    rpn.addX(object);
                    continue block35;
                }
                case 2: {
                    rpn.addX(token.intValue);
                    continue block35;
                }
                default: {
                    if (Compiler.tokAttr(token.tok, 0x880000)) {
                        rpn.addOp(token);
                        continue block35;
                    }
                    this.unrecognizedExpression();
                }
            }
        }
        this.expressionResult = rpn.getResult(bl2, null);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks();
            }
            this.endOfStatementUnexpected();
        }
        this.expressionResult = ((Token)this.expressionResult).value;
        if (bl3 && this.expressionResult instanceof String) {
            Object object = this.expressionResult = this.isScriptCheck ? new BitSet() : Eval.getAtomBitSet(this, this.viewer, (String)this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : new BitSet();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        if (!bl5 && this.bsSubset != null && !this.isBondSet) {
            bitSet.and(this.bsSubset);
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bitSet;
    }

    private static int getSeqCode(Token token) {
        return token.intValue != Integer.MAX_VALUE ? Group.getSeqcode(token.intValue, ' ') : (Integer)token.value;
    }

    private BitSet lookupIdentifierValue(String string) throws ScriptException {
        BitSet bitSet = this.lookupValue(string, false);
        if (bitSet != null) {
            return BitSetUtil.copy(bitSet);
        }
        bitSet = this.getAtomBits(1, string);
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet getAtomBits(int n) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(n);
    }

    private BitSet getAtomBits(int n, String string) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(n, string);
    }

    private BitSet getAtomBits(int n, int n2) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(n, n2);
    }

    private BitSet getAtomBits(int n, int[] nArray) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(n, nArray);
    }

    private BitSet lookupValue(String string, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        Object object = this.variables.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.variables.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object != null) {
            if (object instanceof Token[]) {
                this.pushContext(null);
                object = this.expression((Token[])object, -2, 0, true, false, true);
                this.popContext();
                if (!bl2) {
                    this.variables.put(string, object);
                }
            }
            return (BitSet)object;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    private BitSet comparatorInstruction(Token token, int n, float[] fArray, int n2, int n3, float f) throws ScriptException {
        BitSet bitSet = new BitSet();
        int n4 = Integer.MAX_VALUE;
        BitSet bitSet2 = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        float f2 = 0.0f;
        block28: for (int i = 0; i < n7; ++i) {
            int n12;
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = (int)this.atomProperty(atom, n, true);
                    if (n4 != Integer.MAX_VALUE) break;
                    continue block28;
                }
                case 73990156: {
                    if (fArray == null || fArray.length <= i) continue block28;
                    f2 = fArray[i];
                    switch (n2) {
                        case 42467379: {
                            bl = f2 < f;
                            break;
                        }
                        case 42467378: {
                            bl = f2 <= f;
                            break;
                        }
                        case 42467377: {
                            bl = f2 >= f;
                            break;
                        }
                        case 42467376: {
                            bl = f2 > f;
                            break;
                        }
                        case 42467380: {
                            bl = f2 == f;
                            break;
                        }
                        case 42467381: {
                            boolean bl2 = bl = f2 != f;
                        }
                    }
                    if (!bl) continue block28;
                    bitSet.set(i);
                    continue block28;
                }
                case 2621461: {
                    bitSet2 = atom.getAtomSymmetry();
                    if (n6 < 200) break;
                    n3 = n6 % 1000;
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if ((n12 = n6 / 1000 - 1) < 0) {
                        bl = true;
                    } else if (n11 == 0 || n12 >= 0 && !(bl = bitSet2.get(n12))) continue block28;
                    n5 = 524301;
                    n4 = n12 < 0 ? atom.getCellTranslation(n3, nArray, n11) : atom.getSymmetryTranslation(n12, nArray, n11);
                }
            }
            if (bitSet2 != null) {
                switch (n5) {
                    case 42467379: {
                        n8 = n3 - 1;
                        n9 = 0;
                        break;
                    }
                    case 42467378: {
                        n8 = n3;
                        n9 = 0;
                        break;
                    }
                    case 42467377: {
                        n8 = bitSet2.size();
                        n9 = n3 - 1;
                        break;
                    }
                    case 42467376: {
                        n8 = bitSet2.size();
                        n9 = n3;
                        break;
                    }
                    case 42467380: {
                        n8 = n3;
                        n9 = n3 - 1;
                        break;
                    }
                    case 42467381: {
                        boolean bl3 = bl = !bitSet2.get(n3);
                    }
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                if (n8 > bitSet2.size()) {
                    n8 = bitSet2.size();
                }
                for (n12 = n9; n12 < n8; ++n12) {
                    if (!bitSet2.get(n12)) continue;
                    bl = true;
                    break;
                }
                if (!bl || n4 == Integer.MAX_VALUE) {
                    n2 = 524301;
                }
            }
            switch (n2) {
                case 42467379: {
                    bl = n4 < n3;
                    break;
                }
                case 42467378: {
                    bl = n4 <= n3;
                    break;
                }
                case 42467377: {
                    bl = n4 >= n3;
                    break;
                }
                case 42467376: {
                    bl = n4 > n3;
                    break;
                }
                case 42467380: {
                    bl = n4 == n3;
                    break;
                }
                case 42467381: {
                    boolean bl4 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private float atomProperty(Atom atom, int n, boolean bl) throws ScriptException {
        float f = 0.0f;
        switch (n) {
            case 2621441: {
                return atom.getAtomNumber();
            }
            case 2621444: {
                return atom.getAtomIndex();
            }
            case 2621447: {
                return atom.getElementNumber();
            }
            case 2621446: {
                return atom.getAtomicAndIsotopeNumber();
            }
            case 69795849: {
                return atom.getFormalCharge();
            }
            case 69730342: {
                f = atom.getPartialCharge();
                return bl ? f * 100.0f : f;
            }
            case 2621459: {
                return atom.getAtomSite();
            }
            case 2621454: {
                return atom.getMoleculeNumber();
            }
            case 69730346: {
                f = atom.getBfactor100();
                return f < 0.0f ? 2.1474836E9f : (bl ? f : f / 100.0f);
            }
            case 2621481: {
                this.viewer.getSurfaceDistanceMax();
                f = atom.getSurfaceDistance100();
                return bl ? f : f / 100.0f;
            }
            case 69730319: {
                return atom.getOccupancy();
            }
            case 2621456: {
                return atom.getPolymerLength();
            }
            case 2621458: {
                return atom.getResno();
            }
            case 2621450: {
                f = atom.getGroupID();
                return f < 0.0f ? 2.1474836E9f : f;
            }
            case 0x280002: {
                return atom.getSpecialAtomID();
            }
            case 2622740: {
                return atom.getProteinStructureType();
            }
            case 2686993: {
                return atom.getRasMolRadius();
            }
            case 69730326: {
                return (float)(bl ? 100 : 1) * atom.getVanderwaalsRadiusFloat();
            }
            case 0x280028: {
                f = atom.getGroupPsi();
                return bl ? f * 100.0f : f;
            }
            case 2621479: {
                f = atom.getGroupPhi();
                return bl ? f * 100.0f : f;
            }
            case 2621443: {
                return atom.getCovalentBondCount();
            }
            case 69730327: {
                return atom.getValence();
            }
            case 2621704: {
                return atom.getModelFileIndex() + 1;
            }
            case 2621709: {
                return atom.getModelNumber();
            }
            case -2621709: {
                return atom.getModelFileNumber();
            }
            case 69730336: {
                f = atom.x;
                return bl ? f * 100.0f : f;
            }
            case 69730337: {
                f = atom.y;
                return bl ? f * 100.0f : f;
            }
            case 69730338: {
                f = atom.z;
                return bl ? f * 100.0f : f;
            }
            case 69730339: {
                f = atom.getFractionalCoord('X');
                return bl ? f * 100.0f : f;
            }
            case 69730340: {
                f = atom.getFractionalCoord('Y');
                return bl ? f * 100.0f : f;
            }
            case 69730341: {
                f = atom.getFractionalCoord('Z');
                return bl ? f * 100.0f : f;
            }
        }
        this.unrecognizedAtomProperty(Token.nameOf(n));
        return 0.0f;
    }

    private void checkStatementLength(int n) throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != n) {
            this.badArgumentCount();
        }
    }

    private void checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.badArgumentCount();
        }
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.badArgumentCount();
        }
        return this.statementLength;
    }

    private void checkLength2() throws ScriptException {
        this.checkStatementLength(2);
    }

    private void checkLength3() throws ScriptException {
        this.checkStatementLength(3);
    }

    private void checkLength4() throws ScriptException {
        this.checkStatementLength(4);
    }

    private int modelNumberParameter(Token token) {
        int n = 0;
        boolean bl = false;
        switch (token.tok) {
            case 2: {
                bl = true;
            }
            case 3: {
                n = token.intValue;
                break;
            }
            default: {
                return -1;
            }
        }
        return this.viewer.getModelNumberIndex(n, bl, true);
    }

    private String optParameterAsString(int n) throws ScriptException {
        if (n >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(n);
    }

    private String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.endOfStatementUnexpected();
        }
        return this.theTok == 2 ? "" + this.theToken.intValue : "" + this.theToken.value;
    }

    private int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        return this.integerExpected();
    }

    private boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 2: 
                case 524314: {
                    return this.theToken.intValue;
                }
                case 3: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        return this.numberExpected();
    }

    private int floatParameterSet(int n, float[] fArray) throws ScriptException {
        if (this.tokAt(n) == 524291) {
            ++n;
        }
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.floatParameter(n++);
        }
        if (this.tokAt(n) == 524292) {
            ++n;
        }
        return n;
    }

    private String stringParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 4) {
            return (String)this.theToken.value;
        }
        return this.stringExpected();
    }

    private String objectNameParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 1) {
            return this.parameterAsString(n);
        }
        return this.objectNameExpected();
    }

    private float radiusParameter(int n, float f) throws ScriptException {
        boolean bl;
        if (!this.checkToken(n)) {
            if (Float.isNaN(f)) {
                this.numberExpected();
            }
            return f;
        }
        this.getToken(n);
        float f2 = Float.NaN;
        boolean bl2 = bl = this.theTok == 8912953;
        if (bl) {
            ++n;
        }
        boolean bl3 = this.tokAt(n + 1) == 8912962;
        switch (this.tokAt(n)) {
            case 2: {
                f2 = this.intParameter(n);
            }
            case 3: {
                if (Float.isNaN(f2)) {
                    f2 = this.floatParameter(n);
                }
                if (!(f2 < 0.0f)) break;
                bl = true;
                break;
            }
            default: {
                f2 = f;
                --n;
            }
        }
        this.iToken = n + (bl3 ? 1 : 0);
        if (Float.isNaN(f2)) {
            this.numberExpected();
        }
        if (f2 == 0.0f) {
            return 0.0f;
        }
        if (bl3) {
            if (f2 <= -100.0f) {
                this.invalidArgument();
            }
            f2 += (float)(bl ? 200 : 100);
        } else if (!bl) {
            if (f2 < 0.0f || f2 > 10.0f) {
                this.numberOutOfRange(0.0f, 10.0f);
            }
            f2 += 10.0f;
        }
        return f2;
    }

    private int setShapeByNameParameter(int n) throws ScriptException {
        String string = this.objectNameParameter(n);
        int n2 = this.viewer.getShapeIdFromObjectName(string);
        if (!this.isSyntaxCheck && n2 < 0) {
            this.objectNameExpected();
        }
        this.setShapeProperty(n2, "thisID", string);
        return n2;
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.statementLength == n) {
            return true;
        }
        this.checkStatementLength(n + 1);
        switch (this.getToken((int)n).tok) {
            case 524305: {
                return true;
            }
            case 524304: {
                return false;
            }
        }
        this.booleanExpected();
        return false;
    }

    private Point3f atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 262215: 
            case 524388: {
                BitSet bitSet = this.expression(this.statement, n, 0, true, false, false);
                if (bitSet != null) {
                    return this.viewer.getAtomSetCenter(bitSet);
                }
                if (this.expressionResult instanceof Point3f) {
                    return (Point3f)this.expressionResult;
                }
                this.invalidArgument();
            }
            case 7: 
            case 524291: {
                return this.getPoint3f(n, true);
            }
        }
        this.invalidArgument();
        return null;
    }

    private boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 524293 || n2 == 524291 || n2 == 524388 || n2 == 7 || n2 == 262215;
    }

    private Point3f centerParameter(int n) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 524293: {
                    String string = this.objectNameParameter(++n);
                    if (this.tokAt(n + 1) == 0x880010) {
                        string = string + "." + this.intParameter(n + 2);
                        if (this.getToken((int)(n + 3)).tok != 0x880011) {
                            this.invalidArgument();
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    point3f = this.getDrawObjectCenter(string);
                    if (point3f != null) break;
                    this.drawObjectNotDefined(string);
                    break;
                }
                case 7: 
                case 262215: 
                case 524291: 
                case 524388: {
                    point3f = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (point3f == null) {
            this.coordinateOrNameOrExpressionRequired();
        }
        return point3f;
    }

    private Point4f planeParameter(int n) throws ScriptException {
        block26: {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            if (n >= this.statementLength) break block26;
            switch (this.getToken((int)n).tok) {
                case 8: {
                    return (Point4f)this.theToken.value;
                }
                case 524293: {
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int n2 = this.viewer.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 20: {
                            this.setShapeProperty(20, "thisID", string);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(20, "vertices");
                            if (point3fArray != null) {
                                if (point3fArray.length < 3) break;
                                Vector3f vector3f3 = new Vector3f();
                                float f = Graphics3D.getNormalThroughPoints(point3fArray[0], point3fArray[1], point3fArray[2], vector3f3, vector3f, vector3f2);
                                return new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                            }
                            break block26;
                        }
                        case 21: {
                            this.setShapeProperty(21, "thisID", string);
                            Point4f point4f = (Point4f)this.viewer.getShapeProperty(21, "plane");
                            if (point4f != null) {
                                return point4f;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 4: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    if (string.equalsIgnoreCase("x")) {
                        if (!this.checkToken(++n) || this.getToken((int)n++).tok != 42467380) {
                            this.evalError("x=?");
                        }
                        return new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    }
                    if (string.equalsIgnoreCase("y")) {
                        if (!this.checkToken(++n) || this.getToken((int)n++).tok != 42467380) {
                            this.evalError("y=?");
                        }
                        return new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    }
                    if (!string.equalsIgnoreCase("z")) break;
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 42467380) {
                        this.evalError("z=?");
                    }
                    return new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                }
                case 524291: {
                    if (!this.isPoint3f(n)) {
                        return this.getPoint4f(n);
                    }
                }
                case 262215: 
                case 524388: {
                    Point3f point3f = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x880008) {
                        ++this.iToken;
                    }
                    Point3f point3f2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x880008) {
                        ++this.iToken;
                    }
                    Point3f point3f3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    Vector3f vector3f4 = new Vector3f();
                    float f = Graphics3D.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f4, vector3f, vector3f2);
                    Point4f point4f = new Point4f(vector3f4.x, vector3f4.y, vector3f4.z, f);
                    if (!this.isSyntaxCheck && Logger.debugging) {
                        Logger.debug("points: " + point3f + point3f2 + point3f3 + " defined plane: " + point4f);
                    }
                    return point4f;
                }
            }
        }
        this.evalError(GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}", new Object[]{"{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx"}));
        return null;
    }

    private Point4f hklParameter(int n) throws ScriptException {
        Point3f point3f = this.viewer.getCurrentUnitCellOffset();
        if (point3f == null) {
            if (this.isSyntaxCheck) {
                point3f = new Point3f();
            } else {
                this.evalError(GT._("No unit cell"));
            }
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f2 = (Point3f)this.getPointOrPlane(n, false, true, false, true, 3, 3);
        Point3f point3f3 = new Point3f(point3f2.x == 0.0f ? 1.0f : 1.0f / point3f2.x, 0.0f, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, point3f2.y == 0.0f ? 1.0f : 1.0f / point3f2.y, 0.0f);
        Point3f point3f5 = new Point3f(0.0f, 0.0f, point3f2.z == 0.0f ? 1.0f : 1.0f / point3f2.z);
        if (point3f2.x == 0.0f && point3f2.y == 0.0f && point3f2.z == 0.0f) {
            this.evalError(GT._("Miller indices cannot all be zero."));
        } else if (point3f2.x == 0.0f && point3f2.y == 0.0f) {
            point3f3.set(1.0f, 0.0f, point3f5.z);
            point3f4.set(0.0f, 1.0f, point3f5.z);
        } else if (point3f2.y == 0.0f && point3f2.z == 0.0f) {
            point3f4.set(point3f3.x, 0.0f, 1.0f);
            point3f5.set(point3f3.x, 1.0f, 0.0f);
        } else if (point3f2.z == 0.0f && point3f2.x == 0.0f) {
            point3f5.set(0.0f, point3f4.y, 1.0f);
            point3f3.set(1.0f, point3f4.y, 0.0f);
        } else if (point3f2.x == 0.0f) {
            point3f3.set(1.0f, point3f4.y, 0.0f);
        } else if (point3f2.y == 0.0f) {
            point3f4.set(0.0f, 1.0f, point3f5.z);
        } else if (point3f2.z == 0.0f) {
            point3f5.set(point3f3.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(point3f3);
        this.viewer.toCartesian(point3f4);
        this.viewer.toCartesian(point3f5);
        point3f3.add(point3f);
        point3f4.add(point3f);
        point3f5.add(point3f);
        Vector3f vector3f3 = new Vector3f();
        float f = Graphics3D.getNormalThroughPoints(point3f3, point3f4, point3f5, vector3f3, vector3f, vector3f2);
        Point4f point4f = new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
        if (!this.isSyntaxCheck && Logger.debugging) {
            Logger.info("defined plane: " + point4f);
        }
        return point4f;
    }

    private short getMadParameter() throws ScriptException {
        short s = 1;
        switch (this.getToken((int)1).tok) {
            case 524305: {
                break;
            }
            case 524304: {
                s = 0;
                break;
            }
            case 2: {
                s = this.getMadInteger(this.intParameter(1));
                break;
            }
            case 3: {
                s = this.getMadFloat(this.floatParameter(1));
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        return s;
    }

    private short getMadInteger(int n) throws ScriptException {
        if (n < 0 || n > 750) {
            this.numberOutOfRange(0, 750);
        }
        return (short)(n * 4 * 2);
    }

    private short getMadFloat(float f) throws ScriptException {
        if (f < 0.0f || f > 3.0f) {
            this.numberOutOfRange(0.0f, 3.0f);
        }
        return (short)(f * 1000.0f * 2.0f);
    }

    private short getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.statementLength) {
            return 1;
        }
        this.checkStatementLength(n + 1);
        switch (this.getToken((int)n).tok) {
            case 524305: {
                return 1;
            }
            case 524304: {
                return 0;
            }
            case 262174: {
                return -1;
            }
            case 2: {
                int n2 = this.intParameter(n);
                if (n2 < -1 || n2 >= 20) {
                    this.numberOutOfRange(-1, 19);
                }
                return (short)n2;
            }
            case 3: {
                float f = this.floatParameter(n);
                if (f < 0.0f || f >= 2.0f) {
                    this.numberOutOfRange(0.01f, 1.99f);
                }
                return (short)(f * 1000.0f * 2.0f);
            }
        }
        this.booleanOrNumberExpected("DOTTED");
        return 0;
    }

    private boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 393236 || n2 == 0x880010 || n2 == 7 || this.isPoint3f(n) || (n2 == 4 || n2 == 1) && Graphics3D.getArgbFromString((String)this.statement[n].value) != 0;
    }

    private int getArgbParam(int n) throws ScriptException {
        return this.getArgbParam(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParam(n, bl);
        this.checkStatementLength(this.iToken + 1);
        return n2;
    }

    private int getArgbParam(int n, boolean bl) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 1: 
                case 4: {
                    return Graphics3D.getArgbFromString(this.parameterAsString(n));
                }
                case 0x880010: {
                    return this.getColorTriad(++n);
                }
                case 393236: {
                    return this.theToken.intValue;
                }
                case 7: {
                    point3f = (Point3f)this.theToken.value;
                    break;
                }
                case 524291: {
                    point3f = this.getPoint3f(n, false);
                    break;
                }
                case 524301: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (point3f == null) {
            this.colorExpected();
        }
        return Eval.colorPtToInt(point3f);
    }

    static int colorPtToInt(Point3f point3f) {
        return 0xFF000000 | ((int)point3f.x & 0xFF) << 16 | ((int)point3f.y & 0xFF) << 8 | (int)point3f.z & 0xFF;
    }

    private int getArgbOrPaletteParam(int n) throws ScriptException {
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 393236: 
                case 0x880010: {
                    return this.getArgbParam(n);
                }
                case 262149: {
                    return 262149;
                }
                case 262190: 
                case 524301: {
                    return 262190;
                }
            }
        }
        this.evalError(GT._("a color or palette name (Jmol, Rasmol) is required"));
        return 0;
    }

    private int getColorTriad(int n) throws ScriptException {
        int[] nArray = new int[3];
        int n2 = 0;
        String string = "";
        this.getToken(n);
        Point3f point3f = null;
        block0 : switch (this.theTok) {
            case 2: 
            case 524314: {
                while (n < this.statementLength) {
                    this.getToken(n);
                    switch (this.theTok) {
                        case 0x880008: {
                            break;
                        }
                        case 1: {
                            if (n2 != 1 || nArray[0] != 0) {
                                this.badRGBColor();
                            }
                            string = "0" + this.parameterAsString(n);
                            break block0;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.badRGBColor();
                            }
                            nArray[n2++] = this.theToken.intValue;
                            break;
                        }
                        case 524314: {
                            if (n2 > 2) {
                                this.badRGBColor();
                            }
                            nArray[n2++] = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x880011: {
                            if (n2 == 3) {
                                return Eval.colorPtToInt(new Point3f(nArray[0], nArray[1], nArray[2]));
                            }
                        }
                        default: {
                            this.badRGBColor();
                        }
                    }
                    ++n;
                }
                this.badRGBColor();
            }
            case 7: {
                point3f = (Point3f)this.theToken.value;
                break;
            }
            case 1: {
                string = this.parameterAsString(n);
                break;
            }
            default: {
                this.badRGBColor();
            }
        }
        if (this.getToken((int)(++n)).tok != 0x880011) {
            this.badRGBColor();
        }
        if (point3f != null) {
            return Eval.colorPtToInt(point3f);
        }
        n2 = Graphics3D.getArgbFromString("[" + string + "]");
        if (n2 == 0) {
            this.badRGBColor();
        }
        return n2;
    }

    private boolean isPoint3f(int n) {
        this.ignoreError = true;
        boolean bl = true;
        int n2 = this.iToken;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    private Point3f getPoint3f(int n, boolean bl) throws ScriptException {
        return (Point3f)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    private Point4f getPoint4f(int n) throws ScriptException {
        return (Point4f)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 7) {
            if (n2 <= 3 && n3 >= 3) {
                return (Point3f)this.getToken((int)n).value;
            }
            this.invalidArgument();
        }
        if (this.tokAt(n) == 8) {
            if (n2 <= 4 && n3 >= 4) {
                return (Point4f)this.getToken((int)n).value;
            }
            this.invalidArgument();
        }
        int n5 = 1;
        block10: for (int i = n; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 524291: 
                case 0x880008: 
                case 0x880020: {
                    continue block10;
                }
                case 524292: {
                    break block10;
                }
                case 0x880038: {
                    n5 = -1;
                    continue block10;
                }
                case 524315: {
                    if (n4 == 6) {
                        this.invalidArgument();
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block10;
                }
                case 2: 
                case 524314: {
                    if (n4 == 6) {
                        this.invalidArgument();
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block10;
                }
                case 0x880040: {
                    this.getToken(++i);
                }
                case 524318: {
                    if (--n4 < 0 || bl) {
                        this.invalidArgument();
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block10;
                }
                case 3: 
                case 524319: {
                    if (bl) {
                        this.invalidArgument();
                    }
                    if (n4 == 6) {
                        this.invalidArgument();
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block10;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.invalidArgument();
        }
        if (n4 == 3) {
            Point3f point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3 && !this.isSyntaxCheck) {
                this.viewer.toCartesian(point3f);
            }
            return point3f;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.invalidArgument();
            }
            Point4f point4f = new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
            return point4f;
        }
        return fArray;
    }

    private Token getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.endOfStatementUnexpected();
        }
        this.theToken = this.statement[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int n) {
        return n < this.statementLength ? this.statement[n].tok : 0;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.statementLength;
    }

    private void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.statementLength == 1 ? "" : this.parameterAsString(1);
        Token token = Token.getTokenFromName(string);
        if (token != null && (token.tok & 0x100) != 0) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        if (this.statementLength > 11) {
            this.badArgumentCount();
        }
        Vector3f vector3f = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        Vector3f vector3f2 = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(vector3f, f, vector3f2, f2, f3, n);
    }

    private void moveto() throws ScriptException {
        float f;
        float f2;
        float f3;
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f4 = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f4 > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f4, null, new Point3f(0.0f, 0.0f, 1.0f), 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Point3f point3f = new Point3f();
        Point3f point3f2 = null;
        int n = 1;
        float f5 = f3 = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        if (f3 < 0.0f) {
            this.invalidArgument();
        }
        float f6 = Float.NaN;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 90.0f;
        switch (this.getToken((int)n).tok) {
            case 7: 
            case 524291: {
                if (this.isPoint3f(n)) {
                    point3f = this.getPoint3f(n, true);
                    n = this.iToken + 1;
                    f9 = this.floatParameter(n++);
                    break;
                }
                Point4f point4f = this.getPoint4f(n);
                n = this.iToken + 1;
                point3f.set(point4f.x, point4f.y, point4f.z);
                f9 = point4f.w;
                break;
            }
            case 262211: {
                point3f.set(1.0f, 0.0f, 0.0f);
                f9 = 0.0f;
                ++n;
                break;
            }
            case 262212: {
                point3f.set(0.0f, 1.0f, 0.0f);
                f9 = 180.0f;
                ++n;
                break;
            }
            case 262209: {
                point3f.set(0.0f, 1.0f, 0.0f);
                ++n;
                break;
            }
            case 262210: {
                point3f.set(0.0f, -1.0f, 0.0f);
                this.checkStatementLength(++n);
                break;
            }
            case 262213: {
                point3f.set(1.0f, 0.0f, 0.0f);
                this.checkStatementLength(++n);
                break;
            }
            case 262214: {
                point3f.set(-1.0f, 0.0f, 0.0f);
                this.checkStatementLength(++n);
                break;
            }
            default: {
                point3f = new Point3f(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f9 = this.floatParameter(n++);
            }
        }
        boolean bl = !this.viewer.isInPosition(point3f, f9);
        float f10 = this.viewer.getZoomPercentFloat();
        if (n != this.statementLength && !this.isCenterParameter(n)) {
            f6 = this.floatParameter(n++);
        }
        if (n != this.statementLength && !this.isCenterParameter(n)) {
            f7 = this.floatParameter(n++);
            f8 = this.floatParameter(n++);
            if (!bl && Math.abs(f7 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f8 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        float f11 = Float.NaN;
        if (n != this.statementLength) {
            int n2 = n;
            point3f2 = this.centerParameter(n);
            if (!bl && (double)point3f2.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n = this.iToken + 1)) {
                f11 = this.floatParameter(n++);
            }
            f2 = this.viewer.getRotationRadius();
            if (!this.isCenterParameter(n)) {
                if ((f11 == 0.0f || Float.isNaN(f11)) && (f6 == 0.0f || Float.isNaN(f6))) {
                    f = Math.abs(this.getZoomFactor(n, n2, f2, f10));
                    n = this.iToken + 1;
                    if (Float.isNaN(f)) {
                        this.invalidArgument();
                    }
                    f6 = f;
                } else if (!bl && (double)Math.abs(f11 - this.viewer.getRotationRadius()) >= 0.1) {
                    bl = true;
                }
            }
        }
        if (f6 == 0.0f || Float.isNaN(f6)) {
            f6 = 100.0f;
        }
        if (Float.isNaN(f11)) {
            f11 = 0.0f;
        }
        if (!bl && Math.abs(f6 - f10) >= 1.0f) {
            bl = true;
        }
        Point3f point3f3 = null;
        f2 = Float.NaN;
        f = Float.NaN;
        float f12 = Float.NaN;
        if (n != this.statementLength) {
            point3f3 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.statementLength) {
                f2 = this.floatParameter(n++);
                f = this.floatParameter(n++);
            }
            if (n != this.statementLength) {
                f12 = this.floatParameter(n++);
            }
        }
        if (n != this.statementLength) {
            this.badArgumentCount();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!bl) {
            f3 = 0.0f;
        }
        if (f3 > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(f3, point3f2, point3f, f9, f6, f7, f8, f11, point3f3, f2, f, f12);
    }

    private void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 524304: 
                case 524305: {
                    this.setBooleanProperty("navigationMode", this.theTok == 524305);
                }
            }
            this.invalidArgument();
            return;
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block16: for (int i = 1; i < this.statementLength; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.invalidArgument();
            }
            if (!this.isSyntaxCheck && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 5426: {
                    float f3 = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.setNavigationDepthPercent(f, f3);
                    continue block16;
                }
                case 772: {
                    Point3f point3f = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(f, point3f);
                    continue block16;
                }
                case 5403: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1: {
                            String string = this.parameterAsString(i++);
                            if (string.equalsIgnoreCase("x")) {
                                vector3f.set(1.0f, 0.0f, 0.0f);
                                break;
                            }
                            if (string.equalsIgnoreCase("y")) {
                                vector3f.set(0.0f, 1.0f, 0.0f);
                                break;
                            }
                            if (string.equalsIgnoreCase("z")) {
                                vector3f.set(0.0f, 0.0f, 1.0f);
                                break;
                            }
                            this.invalidArgument();
                        }
                        case 7: 
                        case 524291: {
                            vector3f.set(this.getPoint3f(i, true));
                            i = this.iToken + 1;
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(f, vector3f, f4);
                    continue block16;
                }
                case 4394: {
                    Point3f[][] point3fArray;
                    Point3f point3f;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else if (this.getToken((int)i).tok == 1) {
                        point3fArray = this.parameterAsString(i);
                        if (point3fArray.equalsIgnoreCase("x")) {
                            f5 = this.floatParameter(++i);
                        } else if (point3fArray.equalsIgnoreCase("y")) {
                            f6 = this.floatParameter(++i);
                        } else {
                            this.invalidArgument();
                        }
                    } else {
                        point3f = this.centerParameter(i);
                        i = this.iToken;
                        if (this.isSyntaxCheck) continue block16;
                        this.viewer.navTranslate(f, point3f);
                        continue block16;
                    }
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navTranslatePercent(f, f5, f6);
                    continue block16;
                }
                case 0x880040: {
                    continue block16;
                }
                case 297: {
                    Vector vector = new Vector();
                    BitSet bitSet = this.expression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bitSet, vector);
                    int n = vector.size();
                    if (n <= 0) continue block16;
                    Point3f[][] point3fArray = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        point3fArray[j] = (Point3f[])vector.get(j);
                    }
                    this.viewer.navigate(f, point3fArray);
                    continue block16;
                }
                case 1: {
                    float[] fArray = null;
                    String string = this.parameterAsString(i);
                    if (string.equalsIgnoreCase("path")) {
                        int n;
                        Object object;
                        if (this.getToken((int)(i + 1)).tok == 524293) {
                            ++i;
                            object = this.objectNameParameter(++i);
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            this.setShapeProperty(20, "thisID", object);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(20, "vertices");
                            this.refresh();
                            if (point3fArray == null) {
                                this.invalidArgument();
                            }
                            n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                            int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(f, point3fArray, fArray, n, n2);
                            continue block16;
                        }
                        object = new Vector();
                        while (this.isCenterParameter(i + 1)) {
                            ((Vector)object).addElement(this.centerParameter(++i));
                            i = this.iToken;
                        }
                        if (((Vector)object).size() > 0) {
                            Point3f[] point3fArray = new Point3f[((Vector)object).size()];
                            for (n = 0; n < ((Vector)object).size(); ++n) {
                                point3fArray[n] = (Point3f)((Vector)object).get(n);
                            }
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(f, point3fArray, fArray, 0, Integer.MAX_VALUE);
                            continue block16;
                        }
                    }
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
    }

    private void bondorder() throws ScriptException {
        short s = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                s = JmolConstants.getBondOrderFromFloat(this.floatParameter(1));
                if (s != -1) break;
                this.invalidArgument();
                break;
            }
            default: {
                s = JmolConstants.getBondOrderFromString(this.parameterAsString(1));
                if (s == -1) {
                    this.invalidArgument();
                }
                if (s != 33 || this.tokAt(2) != 3) break;
                s = JmolConstants.getPartialBondOrderFromInteger(this.statement[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", new Short(s));
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 524304: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 524305: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                this.viewer.clearConsole();
                break;
            }
            default: {
                this.evalError("console ON|OFF");
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 262191: {
                string = "absolute";
                break;
            }
            case 262192: {
                string = "average";
                break;
            }
            case 6886669: {
                string = "boundbox";
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            point3f.x = this.floatParameter(2);
            point3f.y = this.floatParameter(3);
            point3f.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            point3f = this.centerParameter(2);
            this.checkStatementLength(this.iToken + 1);
        } else {
            this.checkLength2();
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(string, point3f);
        }
    }

    private void stereo() throws ScriptException {
        int n = 1;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = new int[2];
        int n2 = 0;
        String string = "";
        block6: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (n2 > 1) {
                    this.badArgumentCount();
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n2++] = this.getArgbParam(i);
                i = this.iToken;
                if (n2 == 1) {
                    nArray[n2] = ~nArray[0];
                }
                string = string + " " + Escape.escapeColor(nArray[n2 - 1]);
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 524305: {
                    this.checkLength2();
                    this.iToken = 1;
                    string = " on";
                    continue block6;
                }
                case 524304: {
                    this.checkLength2();
                    this.iToken = 1;
                    n = 0;
                    string = " off";
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    string = string + " " + f;
                    continue block6;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    string = string + " " + string2;
                    if (!bl) {
                        f = 3.0f;
                    }
                    if (string2.equalsIgnoreCase("redblue")) {
                        n = 3;
                        continue block6;
                    }
                    if (string2.equalsIgnoreCase("redcyan")) {
                        n = 2;
                        continue block6;
                    }
                    if (string2.equalsIgnoreCase("redgreen")) {
                        n = 4;
                        continue block6;
                    }
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        this.setFloatProperty("stereoDegrees", f);
        this.checkStatementLength(this.iToken + 1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (n2 > 0) {
            this.viewer.setStereoMode(nArray, string);
        } else {
            this.viewer.setStereoMode(n, string);
        }
    }

    private void connect() throws ScriptException {
        int n;
        int n2;
        float[] fArray = new float[2];
        BitSet[] bitSetArray = new BitSet[2];
        bitSetArray[0] = bitSetArray[1] = this.viewer.getSelectionSet();
        float f = Float.NaN;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 0;
        short s = -1;
        int n6 = 3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n7 = 0;
        int n8 = 0;
        BitSet bitSet = new BitSet();
        boolean bl5 = false;
        int n9 = 0;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block13: for (n2 = 1; n2 < this.statementLength; ++n2) {
            if (this.isColorParam(n2)) {
                n3 = this.getArgbParam(n2);
                n2 = this.iToken;
                bl4 = true;
                continue;
            }
            switch (this.getToken((int)n2).tok) {
                case 524304: 
                case 524305: {
                    this.checkLength2();
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    short s2;
                    if (n7 > 0) {
                        if (bl2 || bl4) {
                            this.invalidParameterOrder();
                        }
                        if ((s2 = JmolConstants.getBondOrderFromFloat(this.floatParameter(n2))) == -1) {
                            this.invalidArgument();
                        }
                        s = s2;
                        bl2 = true;
                        continue block13;
                    }
                    if (++n8 > 2) {
                        this.badArgumentCount();
                    }
                    fArray[n4++] = this.floatParameter(n2);
                    continue block13;
                }
                case 262215: 
                case 524388: {
                    int n10;
                    if (++n7 > 2 || bl5 && n7 > 1) {
                        this.badArgumentCount();
                    }
                    if (bl2 || bl4) {
                        this.invalidParameterOrder();
                    }
                    bitSetArray[n5++] = this.expression(n2);
                    if (n5 == 2) {
                        n = this.iToken;
                        for (n10 = n2; n10 < n; ++n10) {
                            if (this.tokAt(n10) != 1 || !this.parameterAsString(n10).equals("_1")) continue;
                            n9 = n2;
                            break;
                        }
                        this.iToken = n;
                    }
                    bl5 = this.isBondSet;
                    n2 = this.iToken;
                    continue block13;
                }
                case 1: 
                case 590093: {
                    int n10;
                    String string2 = this.parameterAsString(n2);
                    if (string2.equalsIgnoreCase("pdb")) {
                        n10 = this.optParameterAsString(2).equalsIgnoreCase("auto");
                        if (n10 != 0) {
                            this.checkLength3();
                        } else {
                            this.checkLength2();
                        }
                        if (this.isSyntaxCheck) {
                            return;
                        }
                        this.viewer.setPdbConectBonding(0, 0, n10 != 0);
                        return;
                    }
                    short s2 = JmolConstants.getBondOrderFromString(string2);
                    if (s2 == -1) {
                        bl3 = true;
                        if (++n2 != this.statementLength) {
                            this.invalidParameterOrder();
                        }
                        if ((n6 = JmolConstants.connectOperationFromString(string2)) < 0) {
                            this.invalidArgument();
                        }
                        if (n6 != 4 || s == -1 || s == 2048 || s == 515) continue block13;
                        this.invalidArgument();
                        continue block13;
                    }
                    if (bl2) {
                        this.incompatibleArguments();
                    }
                    bl2 = true;
                    if (s2 == 33) {
                        switch (this.tokAt(n2 + 1)) {
                            case 3: {
                                s2 = JmolConstants.getPartialBondOrderFromInteger(this.statement[++n2].intValue);
                                break;
                            }
                            case 2: {
                                s2 = (short)this.intParameter(++n2);
                            }
                        }
                    }
                    s = s2;
                    continue block13;
                }
                case 262184: 
                case 262185: {
                    if (string != null) {
                        this.invalidArgument();
                    }
                    bl4 = true;
                    string = this.parameterAsString(n2);
                    if (this.theTok != 262185 || !this.isFloatParameter(n2 + 1)) continue block13;
                    f2 = this.floatParameter(++n2);
                    continue block13;
                }
                case 2686993: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    continue block13;
                }
                case 262186: 
                case 524301: {
                    if (++n2 != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    n6 = 0;
                    if (bl4) {
                        this.invalidArgument();
                    }
                    bl = true;
                    continue block13;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 < 2) {
            if (n4 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n3 != Integer.MIN_VALUE) {
            if (!bl2) {
                s = -2;
            }
            if (!bl3) {
                n6 = 1;
            }
        }
        n2 = 0;
        n = 0;
        if (n9 > 0) {
            BitSet bitSet2 = new BitSet();
            this.variables.put("_1", bitSet2);
            for (int i = bitSetArray[0].size(); i >= 0; --i) {
                if (!bitSetArray[0].get(i)) continue;
                bitSet2.set(i);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], s, n6, bitSet2, this.expression(n9), bitSet, bl5);
                n2 += nArray[0];
                n += nArray[1];
                bitSet2.clear(i);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], s, n6, bitSetArray[0], bitSetArray[1], bitSet, bl5);
            n2 += nArray[0];
            n += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatus(GT._("{0} connections deleted", n));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bitSet);
            if (!Float.isNaN(f)) {
                this.viewer.setShapeSize(1, (int)(f * 2000.0f), bitSet);
            }
            if (n3 != Integer.MIN_VALUE) {
                this.viewer.setShapeProperty(1, "color", new Integer(n3), bitSet);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getDefaultTranslucent();
                }
                this.viewer.setShapeProperty(1, "translucentLevel", new Float(f2));
                this.viewer.setShapeProperty(1, "translucency", string, bitSet);
            }
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatus(GT._("{0} new bonds; {1} modified", new Object[]{new Integer(n2), new Integer(n)}));
        }
    }

    private void getProperty() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = this.optParameterAsString(2);
        int n = this.tokAt(2);
        BitSet bitSet = n == 524388 || n == 262215 ? this.expression(2) : null;
        int n2 = PropertyManager.getPropertyNumber(string2);
        if (string2.length() > 0 && n2 < 0) {
            string2 = "";
            string3 = "";
        } else if (n2 >= 0 && this.statementLength < 3 && (string3 = PropertyManager.getDefaultParam(n2)).equals("(visible)")) {
            this.viewer.setModelVisibility();
            bitSet = this.viewer.getVisibleSet();
        }
        string = (String)this.viewer.getProperty("readable", string2, bitSet == null ? string3 : bitSet);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.isColorParam(n) || this.theTok == 524301) {
            int n2 = this.getArgbParamLast(n, true);
            if (!this.isSyntaxCheck) {
                this.viewer.setObjectArgb("background", n2);
            }
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f point3f = this.centerParameter(n);
        if (point3f == null) {
            this.invalidArgument();
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(point3f);
        }
    }

    private void color() throws ScriptException {
        if (this.isColorParam(1)) {
            this.colorObject(6815745, 1);
            return;
        }
        switch (this.getToken((int)1).tok) {
            case 524293: {
                this.colorNamedObject(2);
                return;
            }
            case 4387: 
            case 262149: 
            case 262158: 
            case 262165: 
            case 262166: 
            case 262182: 
            case 262184: 
            case 262185: 
            case 262190: 
            case 524294: 
            case 524295: 
            case 524296: 
            case 524297: 
            case 524301: 
            case 0x180000: 
            case 2621454: 
            case 2621481: 
            case 2622740: 
            case 69730326: 
            case 69730342: 
            case 69730346: 
            case 69795849: 
            case 73990156: {
                this.colorObject(6815745, 1);
                return;
            }
            case 4: {
                String string = this.stringParameter(1);
                this.setStringProperty("propertyColorSchemeOverLoad", string);
                if (this.tokAt(2) == 262206 || this.tokAt(2) == 262191) {
                    float f = this.floatParameter(3);
                    float f2 = this.floatParameter(4);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(f, f2);
                    }
                }
                return;
            }
            case 262191: 
            case 262206: {
                this.checkLength4();
                float f = this.floatParameter(2);
                float f3 = this.floatParameter(3);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentColorRange(f, f3);
                }
                return;
            }
            case 196865: {
                int n = this.getArgbParamLast(2, true);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectArgb("background", n);
                }
                return;
            }
            case 262215: 
            case 524388: {
                this.colorObject(6815745, -1);
                return;
            }
            case 262181: {
                int n = this.getArgbParamLast(2, false);
                if (!this.isSyntaxCheck) {
                    this.viewer.setRubberbandArgb(n);
                }
                return;
            }
            case 65897: {
                int n = 2;
                if (this.tokAt(2) == 262184) {
                    ++n;
                }
                int n2 = this.getArgbParamLast(n, true);
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.loadShape(15);
                this.setShapeProperty(15, "argbSelection", new Integer(n2));
                return;
            }
            case 1: 
            case 65901: 
            case 1638402: 
            case 1638767: 
            case 6886669: {
                String string = this.parameterAsString(1);
                int n = this.getArgbOrPaletteParam(2);
                this.checkStatementLength(this.iToken + 1);
                if (string.equalsIgnoreCase("axes")) {
                    this.setStringProperty("axesColor", Escape.escapeColor(n));
                    return;
                }
                if (StateManager.getObjectIdFromName(string) >= 0) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setObjectArgb(string, n);
                    }
                    return;
                }
                if (this.changeElementColor(string, n)) {
                    return;
                }
                this.invalidArgument();
            }
            case 136542: {
                this.setShapeProperty(21, "thisID", "+PREVIOUS_MESH+");
            }
        }
        this.colorObject(this.theTok, 2);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.elementNameFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.altElementNameFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + JmolConstants.elementSymbolFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + JmolConstants.altElementSymbolFromIndex(n2))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + JmolConstants.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorNamedObject(int n) throws ScriptException {
        int n2 = this.setShapeByNameParameter(n);
        this.colorShape(n2, n + 1, false);
    }

    private void colorObject(int n, int n2) throws ScriptException {
        this.colorShape(this.getShapeType(n), n2, false);
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        String string = null;
        Number number = null;
        BitSet bitSet = null;
        String string2 = "";
        boolean bl2 = false;
        int n3 = 0;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bitSet = this.expression(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                n = 1;
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 196865;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        }
        if (!this.isSyntaxCheck && n == 23 && !this.mo(true)) {
            return;
        }
        if (this.theTok == 262185 || this.theTok == 262184) {
            string = this.parameterAsString(n2++);
            if (this.theTok == 262185 && this.isFloatParameter(n2)) {
                f = this.floatParameter(n2++);
            }
        }
        if (n2 < this.statementLength && this.tokAt(n2) != 524305 && this.tokAt(n2) != 524304) {
            bl2 = true;
            int n4 = this.getToken((int)n2).tok;
            if (this.isColorParam(n2)) {
                int n5 = this.getArgbParam(n2, false);
                Integer n6 = number = n5 == 0 ? null : new Integer(n5);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    if (string == null && (this.theTok == 262185 || this.theTok == 262184)) {
                        string = this.parameterAsString(n2);
                        if (this.theTok == 262185 && this.isFloatParameter(n2 + 1)) {
                            f = this.floatParameter(++n2);
                        }
                    }
                }
            } else if (n == 22) {
                --this.iToken;
            } else {
                int n7;
                boolean bl3;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl4 = string3.indexOf("byelement") == 0;
                boolean bl5 = bl3 = bl4 || string3.indexOf("byresidue") == 0;
                int n8 = bl3 || n == 21 ? 83 : (n7 = n4 == 4387 ? 1 : (int)JmolConstants.getPaletteID(string3));
                if (n7 == -1 || n7 == 18 && n != 2) {
                    this.invalidArgument();
                }
                Object object = null;
                if (n7 == 83) {
                    if (bl3) {
                        if (!this.isSyntaxCheck) {
                            object = this.getBitsetProperty(null, (bl4 ? 2621447 : 2621450) | 0xC0, null, null, null, null, false);
                        }
                    } else {
                        if (!bl3 && n != 21) {
                            ++n2;
                        }
                        if (string3.equals("property") && Compiler.tokAttr(this.getToken((int)n2).tok, 0x280000) && !this.isSyntaxCheck && !((object = (Object)this.getBitsetProperty(null, this.getToken((int)n2++).tok | 0xC0, null, null, null, null, false)) instanceof float[])) {
                            this.invalidArgument();
                        }
                    }
                } else if (n7 == 84) {
                    int n9 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n9);
                    object = new float[this.viewer.getAtomCount()];
                    Parser.parseFloatArray("" + this.getParameter(string3, false), null, object);
                    n7 = 83;
                }
                if (n7 == 83) {
                    String string4;
                    String string5 = string4 = this.tokAt(n2) == 4 ? this.parameterAsString(n2++).toLowerCase() : null;
                    if (string4 != null) {
                        this.setStringProperty("propertyColorScheme", string4);
                        bl3 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    float f2 = 0.0f;
                    float f3 = Float.MAX_VALUE;
                    if (!(bl3 || this.tokAt(n2) != 262191 && this.tokAt(n2) != 262206)) {
                        f2 = this.floatParameter(n2 + 1);
                        f3 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (f2 == f3 && n == 21) {
                            float[] fArray = (float[])this.viewer.getShapeProperty(n, "dataRange");
                            if (fArray != null) {
                                f2 = fArray[0];
                                f3 = fArray[1];
                            }
                        } else if (f2 == f3) {
                            f3 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        if (n != 21 && f3 != -3.4028235E38f) {
                            if (object == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRange((float[])object, null);
                            }
                        }
                        if (f3 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange(f2, f3);
                        }
                    }
                    if (n == 21) {
                        string2 = "remap";
                    }
                } else {
                    ++n2;
                }
                number = new Byte((byte)n7);
                this.checkStatementLength(n2);
            }
            if (this.isSyntaxCheck || n < 0) {
                return;
            }
            switch (n4) {
                case 2621481: {
                    this.viewer.getSurfaceDistanceMax();
                    break;
                }
                case 69730346: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 524296: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 262182: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 2621454: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
        }
        int n10 = n == 2 ? 30720 : (n == 3 ? 256 : (n3 = n == 1 ? 1023 : 0));
        if (n3 == 0) {
            this.viewer.loadShape(n);
            if (n == 4) {
                this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bitSet != null) {
                this.viewer.selectBonds(bitSet);
                bitSet = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", new Integer(n3));
        }
        if (bl2) {
            if (bitSet != null) {
                this.viewer.setShapeProperty(n, string2 + "color", number, bitSet);
            } else {
                this.viewer.setShapeProperty(n, string2 + "color", number);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f);
        }
        if (n3 != 0) {
            this.viewer.setShapeProperty(1, "type", new Integer(1023));
        }
    }

    private void setShapeTranslucency(int n, String string, String string2, float f) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(n, "translucentLevel", new Float(f));
        if (string != null) {
            this.setShapeProperty(n, string + "translucency", string2);
        }
    }

    private void data() throws ScriptException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setData(null, null, 0, 0, 0);
                    }
                    return;
                }
                int n = string2.indexOf("@");
                if (n >= 0) {
                    string = "" + this.getParameter(string2.substring(n + 1), false);
                    string2 = string2.substring(0, n).trim();
                    break;
                }
                if (string != null || (n = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
                bl = true;
                break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        String string3 = string2 + " ";
        string3 = string3.substring(0, string3.indexOf(" "));
        this.data = new Object[3];
        this.data[0] = string2;
        this.data[1] = string;
        boolean bl2 = string3.equalsIgnoreCase("model");
        boolean bl3 = string3.equalsIgnoreCase("append");
        if (!this.isSyntaxCheck || this.isScriptCheck && (bl2 || bl3) && this.fileOpenCheck) {
            if (string3.toLowerCase().indexOf("property_") == 0) {
                BitSet bitSet = this.viewer.getSelectionSet();
                int n = bl ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
                int n2 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
                int n3 = this.viewer.getAtomCount();
                int[] nArray = null;
                BitSet bitSet2 = new BitSet(n3);
                if (n2 > 0) {
                    int n4;
                    nArray = new int[n3 + 2];
                    for (n4 = 0; n4 <= n3; ++n4) {
                        nArray[n4] = -1;
                    }
                    for (n4 = 0; n4 < n3; ++n4) {
                        int n5;
                        if (!bitSet.get(n4) || (n5 = this.viewer.getAtomNumber(n4)) > n3 + 1 || n5 < 0 || bitSet2.get(n5)) continue;
                        bitSet2.set(n5);
                        nArray[n5] = n4;
                    }
                    this.data[2] = nArray;
                } else {
                    this.data[2] = bitSet;
                }
                this.viewer.setData(string3, this.data, n3, n2, n);
            } else {
                this.viewer.setData(string3, this.data, 0, 0, 0);
            }
        }
        if ((bl2 || bl3) && string == null) {
            this.invalidArgument();
        }
        if ((bl2 || bl3) && (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck)) {
            char c = this.viewer.getInlineChar();
            if (string.length() > 0 && string.charAt(0) != c) {
                c = '\u0000';
            }
            this.viewer.loadInline(string, c, bl3);
        }
        if (Parser.isOneOf(string3.toLowerCase(), "coord;formalcharge;occupany;partialcharge;temperature;valency;vibrationvector;")) {
            this.viewer.loadData(string3, string);
        }
    }

    private void define() throws ScriptException {
        boolean bl;
        String string = (String)this.getToken((int)1).value;
        BitSet bitSet = this.expression(2);
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = bl = string.indexOf("dynamic_") == 0;
        if (bl) {
            Token[] tokenArray = new Token[this.statementLength];
            int n = this.statementLength;
            while (--n >= 0) {
                tokenArray[n] = this.statement[n];
            }
            this.variables.put("!" + string.substring(8), tokenArray);
            this.viewer.addStateScript(this.thisCommand, false);
        } else {
            this.assignBitsetVariable(string, bitSet);
        }
    }

    private void echo(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            this.setShapeProperty(28, "text", string);
        }
        if (this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string));
        }
    }

    private void message() throws ScriptException {
        String string = this.parameterAsString(1);
        if (this.isSyntaxCheck) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            Logger.warn(string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatus(string2);
        }
    }

    private void scriptStatus(String string) {
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    private void pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        this.pauseExecution();
        String string = this.optParameterAsString(1);
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.viewer.scriptStatus("script execution paused" + string);
    }

    private void label(int n) throws ScriptException {
        String string;
        if (this.isSyntaxCheck) {
            return;
        }
        if ((string = this.parameterAsString(n++)).equalsIgnoreCase("on")) {
            string = this.viewer.getStandardLabelFormat();
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(string);
    }

    private void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.loadShape(29);
        this.setShapeProperty(29, "label", string);
    }

    private void load() throws ScriptException {
        Object object;
        String string;
        boolean bl = false;
        int n = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        boolean bl2 = this.viewer.getAppendNew();
        StringBuffer stringBuffer = new StringBuffer("load");
        Object object2 = new int[4];
        int n2 = 1;
        Point3f point3f = this.viewer.getDefaultLattice();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.viewer.getApplySymmetryToBonds()) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        hashtable.put("params", object2);
        object2[1] = (int)point3f.x;
        object2[2] = (int)point3f.y;
        object2[3] = (int)point3f.z;
        int n3 = 1;
        String string2 = "fileset";
        if (this.statementLength == 1) {
            n3 = 0;
        } else {
            if (this.tokAt(1) == 1 || this.parameterAsString(1).equals("fileset")) {
                string2 = this.parameterAsString(1);
                if (string2.equals("menu")) {
                    this.checkLength3();
                    if (!this.isSyntaxCheck) {
                        this.viewer.setMenu(this.parameterAsString(2), true);
                    }
                    return;
                }
                n3 = 2;
                stringBuffer.append(" " + string2);
                bl = string2.equalsIgnoreCase("append");
                if (string2.equalsIgnoreCase("trajectory")) {
                    object2[0] = -1;
                }
            }
            if (this.getToken((int)n3).tok != 4) {
                this.filenameExpected();
            }
        }
        if (this.statementLength == n3 + 1) {
            String string3;
            if (n3 == 0 || (string3 = this.parameterAsString(n3)).length() == 0) {
                string3 = this.viewer.getFullPathName();
            }
            if (string3 == null) {
                this.zap();
                return;
            }
            if (string3.equals("string[]")) {
                return;
            }
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFile(string3, hashtable, null, bl);
                stringBuffer.append(" ");
                if (!string3.equals("string") && !string3.equals("string[]")) {
                    stringBuffer.append("/*file*/");
                }
                string2 = (String)hashtable.get("fullPathName");
                stringBuffer.append(Escape.escape(string2));
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 524291 || this.theTok == 7 || this.theTok == 2 || this.theTok == 1) {
            String string4;
            if ((string4 = this.parameterAsString(n3++)).length() == 0) {
                string4 = this.viewer.getFullPathName();
            }
            if (string4 == null) {
                this.zap();
                return;
            }
            if (string4.equals("string[]")) {
                return;
            }
            String string5 = "";
            int n4 = this.tokAt(n3);
            if (n4 == 1 && this.parameterAsString(n3).equalsIgnoreCase("manifest")) {
                string = this.stringParameter(++n3);
                hashtable.put("manifest", string);
                string5 = string5 + " MANIFEST " + Escape.escape(string);
                n4 = this.tokAt(++n3);
            }
            if (n4 == 2) {
                object2[0] = this.intParameter(n3);
                string5 = string5 + " " + object2[0];
                n4 = this.tokAt(++n3);
            }
            if (n4 == 524291 || n4 == 7) {
                int n5;
                point3f = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                object2[1] = (int)point3f.x;
                object2[2] = (int)point3f.y;
                object2[3] = (int)point3f.z;
                string5 = string5 + " " + Escape.escape(point3f);
                int n6 = -1;
                float f = 0.0f;
                if (this.tokAt(n3) == 262206) {
                    int n7 = ++n3;
                    ++n3;
                    f = this.floatParameter(n7);
                    string5 = string5 + " range " + f;
                }
                hashtable.put("symmetryRange", new Float(f));
                if (this.tokAt(n3) == 262147) {
                    int n8 = ++n3;
                    ++n3;
                    String string6 = TextFormat.simpleReplace(this.parameterAsString(n8), "''", "\"");
                    string5 = string5 + " spacegroup " + Escape.escape(string6);
                    if (string6.equalsIgnoreCase("ignoreOperators")) {
                        n6 = -999;
                    } else {
                        if (string6.indexOf(",") >= 0 && point3f.x < 9.0f && point3f.y < 9.0f && point3f.z == 0.0f) {
                            string6 = string6 + "#doNormalize=0";
                        }
                        if ((n6 = SpaceGroup.determineSpaceGroupIndex(string6)) == -1) {
                            this.evalError(GT._("space group {0} was not found.", string6));
                        }
                    }
                    object = new int[5];
                    for (n5 = 0; n5 < 4; ++n5) {
                        object[n5] = object2[n5];
                    }
                    object[4] = n6;
                    object2 = object;
                    hashtable.put("params", object2);
                }
                if (this.tokAt(n3) == 1638767) {
                    ++n3;
                    object = new int[11];
                    for (int i = 0; i < ((int[])object2).length; ++i) {
                        object[i] = object2[i];
                    }
                    object[4] = n6;
                    float[] fArray = new float[6];
                    n3 = this.floatParameterSet(n3, fArray);
                    string5 = string5 + " unitcell {";
                    for (n5 = 0; n5 < 6; ++n5) {
                        object[5 + n5] = (int)(fArray[n5] * 10000.0f);
                        string5 = string5 + (n5 == 0 ? "" : " ") + (int)object[5 + n5];
                    }
                    string5 = string5 + "}";
                    object2 = object;
                    hashtable.put("params", object2);
                }
            }
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFile(string4, hashtable, null, bl);
                stringBuffer.append(" ");
                if (!string4.equals("string") && !string4.equals("string[]")) {
                    stringBuffer.append("/*file*/");
                }
                string2 = (String)hashtable.get("fullPathName");
                stringBuffer.append(Escape.escape(string2));
                stringBuffer.append(string5);
            }
        } else {
            if (n3 != 2) {
                string2 = this.parameterAsString(n3++);
                stringBuffer.append(" ").append(Escape.escape(string2));
            }
            String[] stringArray = new String[this.statementLength - n3];
            int n9 = 0;
            while (n3 < this.statementLength) {
                String string7 = this.parameterAsString(n3);
                stringArray[n9++] = string7;
                ++n3;
            }
            n2 = stringArray.length;
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFiles(string2, stringArray, null, bl);
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(" /*file*/").append(Escape.escape(stringArray[n3]));
                }
            }
        }
        if (!(!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck)) {
            return;
        }
        this.viewer.addLoadScript(stringBuffer.toString());
        String string8 = this.viewer.getOpenFileError(bl);
        if (string8 != null && !this.isScriptCheck) {
            this.evalError(string8);
        }
        if (bl && (bl2 || n2 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n);
        }
        if (this.logMessages) {
            this.scriptStatus("Successfully loaded:" + string2);
        }
        String string9 = this.viewer.getDefaultLoadScript();
        string = "";
        if (string9.length() > 0) {
            string = string + "\nUsing defaultLoadScript: " + string9;
        }
        if ((object = this.viewer.getModelSetProperty("jmolscript")) != null && this.viewer.getAllowEmbeddedScripts()) {
            string = string + "\nAdding embedded #jmolscript: " + (String)object;
            string9 = string9 + ";" + (String)object;
            string9 = "allowEmbeddedScripts = false;" + string9 + ";allowEmbeddedScripts = true;";
        }
        if (string.length() > 0) {
            Logger.info(string);
        }
        if (string9.length() > 0 && !this.isScriptCheck) {
            this.runScript(string9);
        }
    }

    private String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.invalidArgument();
        }
        return string;
    }

    private void dataFrame(int n) throws ScriptException {
        int n2;
        String string = "";
        boolean bl = false;
        switch (n) {
            case 0: {
                string = "ramachandran";
                break;
            }
            case 1: {
                string = this.statementLength == 1 ? "w" : this.optParameterAsString(1);
                int n3 = n2 = this.optParameterAsString(this.statementLength - 1).indexOf("deriv") == 0 ? 1 : 0;
                if (n2 != 0 && this.statementLength == 2) {
                    string = "w";
                }
                if (!Parser.isOneOf(string, "w;x;y;z")) {
                    this.evalError("QUATERNION [w,x,y,z] [derivative]");
                }
                string = "quaternion " + string + (n2 != 0 ? " derivative" : "");
                bl = true;
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n2 = this.viewer.getCurrentModelIndex();
        if (n2 < 0) {
            this.multipleModelsNotOK(string);
        }
        n2 = this.viewer.getJmolDataSourceFrame(n2);
        int n4 = this.viewer.getJmolDataFrameIndex(n2, string);
        if (bl && n4 < 0 && this.statementLength == 1) {
            n4 = this.viewer.getJmolDataFrameIndex(n2, "quaternion");
        }
        if (n4 > 0) {
            this.viewer.setCurrentModelIndex(n4, true);
            return;
        }
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl2 = this.viewer.getAppendNew();
        this.viewer.setAppendNew(true);
        String string2 = this.viewer.getPdbData(n2, string);
        boolean bl3 = string2 != null && this.viewer.loadInline(string2, '\n', true);
        this.viewer.setAppendNew(bl2);
        this.viewer.setFileInfo(stringArray);
        if (!bl3) {
            return;
        }
        int n5 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string, n2, n5 - 1);
        switch (n) {
            default: {
                this.viewer.setFrameTitle(n5 - 1, "ramachandran plot for model " + this.viewer.getModelNumberDotted(n2));
                this.runScript("frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0; set rotationRadius 260;draw ramaAxisX" + n5 + " {200 0 0} {-200 0 0} \"phi\";" + "draw ramaAxisY" + n5 + " {0 200 0} {0 -200 0} \"psi\";");
                break;
            }
            case 1: {
                this.viewer.setFrameTitle(n5 - 1, string + " for model " + this.viewer.getModelNumberDotted(n2));
                this.runScript("frame 0.0; frame last; reset; set rotationRadius 12;select visible; trace 0.1; wireframe 0; color trace structure;isosurface quatSphere" + n5 + " resolution 1.0 sphere 10.0 mesh nofill translucent 0.8;set rotationRadius 12");
            }
        }
        this.viewer.loadShape(28);
        this.viewer.addStateScript("frame " + this.viewer.getModelNumberDotted(n2) + "; " + string + ";", false);
        this.showString("frame " + this.viewer.getModelNumberDotted(n5 - 1) + " created: " + string);
    }

    private void monitor() throws ScriptException {
        int[] nArray = new int[5];
        float[] fArray = new float[2];
        if (this.statementLength == 1) {
            this.viewer.hideMeasurements(false);
            return;
        }
        switch (this.statementLength) {
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 524305: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(false);
                        }
                        return;
                    }
                    case 524304: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(true);
                        }
                        return;
                    }
                    case 262186: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.setMeasurementFormats(this.stringParameter(1));
                        }
                        return;
                    }
                }
                this.keywordExpected("ON, OFF, DELETE");
            }
            case 3: {
                if (this.getToken((int)1).tok != 262186) break;
                if (this.getToken((int)2).tok == 524303) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.clearAllMeasurements();
                    }
                } else {
                    int n = this.intParameter(2) - 1;
                    if (!this.isSyntaxCheck) {
                        this.viewer.deleteMeasurement(n);
                    }
                }
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        fArray[0] = Float.MAX_VALUE;
        fArray[1] = Float.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = null;
        Vector<BitSet> vector = new Vector<BitSet>();
        BitSet bitSet = new BitSet();
        block22: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 524305: {
                    if (bl6 || bl7 || bl4) {
                        this.invalidArgument();
                    }
                    bl6 = true;
                    continue block22;
                }
                case 524304: {
                    if (bl6 || bl7 || bl4) {
                        this.invalidArgument();
                    }
                    bl7 = true;
                    continue block22;
                }
                case 262186: {
                    if (bl6 || bl7 || bl4) {
                        this.invalidArgument();
                    }
                    bl4 = true;
                    continue block22;
                }
                case 262206: {
                    bl5 = true;
                    n3 = -1;
                    bl = true;
                    continue block22;
                }
                case 1: {
                    if (this.parameterAsString(i).equalsIgnoreCase("ALLCONNECTED")) {
                        bl2 = true;
                    } else {
                        this.keywordExpected("ALL, ALLCONNECTED, DELETE");
                    }
                }
                case 524303: {
                    n3 = -1;
                    bl = true;
                    continue block22;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block22;
                }
                case 3: {
                    bl = true;
                    bl5 = true;
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = this.floatParameter(i);
                    continue block22;
                }
                case 2: {
                    bl5 = true;
                    n4 = this.intParameter(i);
                    n3 = this.viewer.getAtomIndexFromAtomNumber(n4);
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = n4;
                    break;
                }
                case 262215: 
                case 524388: {
                    bl3 = true;
                    bitSet = this.expression(i);
                    i = this.iToken;
                    n3 = BitSetUtil.firstSetBit(bitSet);
                    break;
                }
                default: {
                    this.expressionOrIntegerExpected();
                }
            }
            if ((n3 == -1 || bl && (bitSet == null || bitSet.size() == 0)) && !this.isSyntaxCheck) {
                if (bl3) {
                    return;
                }
                this.evalError(GT._("bad atom number"));
            }
            if (bl) {
                if (++n2 > 4) {
                    this.badArgumentCount();
                }
                vector.addElement(bitSet);
                n = n2;
                continue;
            }
            if (++n > 4) {
                this.badArgumentCount();
            }
            nArray[n] = n3;
        }
        nArray[0] = n;
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl) {
            if (!bl3) {
                this.expressionExpected();
            }
            if (bl5 && fArray[1] < fArray[0]) {
                fArray[1] = fArray[0];
                float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
            }
            if (!this.isSyntaxCheck) {
                this.viewer.defineMeasurement(vector, fArray, bl4, bl2, bl6 || bl7, bl7, string);
            }
            return;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.deleteMeasurement(nArray);
        } else if (bl6) {
            this.viewer.showMeasurement(nArray, true);
        } else if (bl7) {
            this.viewer.showMeasurement(nArray, false);
        } else {
            this.viewer.toggleMeasurement(nArray, string);
        }
    }

    private void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset();
            return;
        }
        if (this.tokAt(1) == 17326337) {
            Compiler.globalFunctions.clear();
            this.compiler.localFunctions.clear();
            return;
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.invalidArgument();
        }
        if (string.equalsIgnoreCase("aromatic")) {
            this.viewer.resetAromatic();
        } else {
            this.viewer.unsetProperty(string);
        }
    }

    private void initialize() {
        this.viewer.initialize();
    }

    private void restrict() throws ScriptException {
        this.select();
        if (this.isSyntaxCheck) {
            return;
        }
        BitSet bitSet = BitSetUtil.copy(this.viewer.getSelectionSet());
        this.viewer.invertSelection();
        if (this.bsSubset != null) {
            bitSet = BitSetUtil.copy(this.viewer.getSelectionSet());
            bitSet.and(this.bsSubset);
            this.viewer.setSelectionSet(bitSet);
            BitSetUtil.invertInPlace(bitSet, this.viewer.getAtomCount());
            bitSet.and(this.bsSubset);
        }
        boolean bl = this.viewer.getBondSelectionModeOr();
        this.setBooleanProperty("bondModeOr", true);
        this.setShapeSize(1, 0);
        int n = 19;
        while (--n >= 0) {
            if (n == 5) continue;
            this.setShapeSize(n, 0);
        }
        this.setShapeProperty(19, "delete", null);
        this.viewer.setLabel(null);
        this.setBooleanProperty("bondModeOr", bl);
        this.viewer.setSelectionSet(bitSet);
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        int n;
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 524305: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 524304: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        float f = Float.MIN_VALUE;
        int n2 = 0;
        float f2 = Float.MAX_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        Point3f[] point3fArray = new Point3f[3];
        Point3f point3f = null;
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        int n3 = 1;
        boolean bl5 = this.viewer.getAxesOrientationRasmol();
        for (n = 0; n < 3; ++n) {
            point3fArray[n] = new Point3f(0.0f, 0.0f, 0.0f);
        }
        for (n = 1; n < this.statementLength; ++n) {
            switch (this.getToken((int)n).tok) {
                case 70976: {
                    bl = true;
                    break;
                }
                case 0x880038: {
                    n3 = -1;
                    break;
                }
                case 262150: {
                    bl3 = true;
                    break;
                }
                case 1: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("x")) {
                        vector3f.set(n3, 0.0f, 0.0f);
                        break;
                    }
                    if (string.equalsIgnoreCase("y")) {
                        if (bl5) {
                            n3 = -n3;
                        }
                        vector3f.set(0.0f, n3, 0.0f);
                        break;
                    }
                    if (string.equalsIgnoreCase("z")) {
                        vector3f.set(0.0f, 0.0f, n3);
                        break;
                    }
                    if (string.equalsIgnoreCase("internal") || string.equalsIgnoreCase("molecular")) {
                        bl4 = true;
                        break;
                    }
                    this.invalidArgument();
                }
                case 7: 
                case 524291: {
                    Point3f point3f2 = this.getPoint3f(n, true);
                    n = this.iToken;
                    if (bl3) {
                        if (bl5) {
                            point3f2.y = -point3f2.y;
                        }
                        vector3f.set(point3f2);
                        bl3 = false;
                        break;
                    }
                    point3fArray[n2++].set(point3f2);
                    break;
                }
                case 524293: {
                    Serializable serializable;
                    if (this.tokAt(n + 2) == 0x880010) {
                        serializable = this.centerParameter(n);
                        n = this.iToken;
                        if (bl3) {
                            if (bl5) {
                                ((Tuple3f)serializable).y = -((Tuple3f)serializable).y;
                            }
                            vector3f.set((Tuple3f)serializable);
                            bl3 = false;
                            break;
                        }
                        point3fArray[n2++].set((Tuple3f)serializable);
                        break;
                    }
                    bl4 = true;
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        point3f = new Point3f();
                        vector3f = new Vector3f();
                    } else {
                        point3f = this.getDrawObjectCenter(string);
                        vector3f = this.getDrawObjectAxis(string);
                        if (point3f == null) {
                            this.drawObjectNotDefined(string);
                        }
                    }
                    point3fArray[n2++].set(point3f);
                    break;
                }
                case 0x880008: {
                    break;
                }
                case 2: 
                case 3: {
                    if (f == Float.MIN_VALUE) {
                        f = this.floatParameter(n);
                        break;
                    }
                    f2 = f;
                    f = this.floatParameter(n);
                    bl = true;
                    break;
                }
                case 262215: 
                case 524388: {
                    Serializable serializable = this.expression(n);
                    n = this.iToken;
                    point3f = this.viewer.getAtomSetCenter((BitSet)serializable);
                    point3fArray[n2++].set(point3f);
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (n2 < 3) continue;
            this.evalError(GT._("too many rotation points were specified"));
        }
        if (n2 < 2 && !bl4) {
            if (n2 == 1) {
                point3f = new Point3f(point3fArray[0]);
            }
            if (f == Float.MIN_VALUE) {
                f = 10.0f;
            }
            if (this.isSyntaxCheck) {
                return;
            }
            this.viewer.rotateAxisAngleAtCenter(point3f, vector3f, f, f2, bl, bl2);
            return;
        }
        if (n2 < 2 && !this.isSyntaxCheck) {
            point3fArray[1].set(point3fArray[0]);
            point3fArray[1].sub(vector3f);
        }
        if (!this.isSyntaxCheck && point3fArray[0].distance(point3fArray[1]) == 0.0f) {
            this.evalError(GT._("rotation points cannot be identical"));
        }
        if (f == Float.MIN_VALUE) {
            f = 10.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.rotateAboutPointsInternal(point3fArray[0], point3fArray[1], f, f2, bl, bl2);
    }

    private Point3f getDrawObjectCenter(String string) {
        return (Point3f)this.viewer.getShapeProperty(20, "getSpinCenter:" + string);
    }

    private Vector3f getDrawObjectAxis(String string) {
        return (Vector3f)this.viewer.getShapeProperty(20, "getSpinAxis:" + string);
    }

    private void script(boolean bl) throws ScriptException {
        if (bl) {
            if (!this.isSyntaxCheck) {
                this.viewer.eval(this.parameterAsString(1));
            }
            return;
        }
        if (this.getToken((int)1).tok != 4) {
            this.filenameExpected();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        String string = this.parameterAsString(1);
        String string2 = null;
        if (string.equalsIgnoreCase("inline")) {
            string2 = this.parameterExpression(2, 0, "_script", false).toString();
            n5 = this.iToken + 1;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        String string3 = this.optParameterAsString(n5);
        if (string3.equalsIgnoreCase("check")) {
            bl3 = true;
            string3 = this.optParameterAsString(++n5);
        }
        if (string3.equalsIgnoreCase("noload")) {
            bl2 = false;
            string3 = this.optParameterAsString(++n5);
        }
        if (string3.equalsIgnoreCase("line") || string3.equalsIgnoreCase("lines")) {
            int n6 = ++n5;
            n3 = n = Math.max(this.intParameter(n6), 0);
            if (this.checkToken(++n5)) {
                if (this.getToken((int)n5++).tok == 0x880038) {
                    n3 = this.checkToken(n5) ? this.intParameter(n5++) : 0;
                } else {
                    this.invalidArgument();
                }
            }
        } else if (string3.equalsIgnoreCase("command") || string3.equalsIgnoreCase("commands")) {
            int n7 = ++n5;
            n2 = Math.max(this.intParameter(n7) - 1, 0);
            n4 = n2 + 1;
            if (this.checkToken(++n5)) {
                if (this.getToken((int)n5++).tok == 0x880038) {
                    n4 = this.checkToken(n5) ? this.intParameter(n5++) : 0;
                } else {
                    this.invalidArgument();
                }
            }
        }
        this.checkStatementLength(n5);
        if (this.isSyntaxCheck && !this.isScriptCheck) {
            return;
        }
        if (this.isScriptCheck) {
            bl3 = true;
        }
        boolean bl4 = this.isSyntaxCheck;
        boolean bl5 = this.isScriptCheck;
        if (bl3) {
            this.isScriptCheck = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext(null);
        boolean bl6 = string2 != null ? this.loadScript(null, string2, false) : this.loadScriptFileInternal(string);
        if (bl6) {
            this.pcEnd = n4;
            this.lineEnd = n3;
            while (n2 < this.lineNumbers.length && this.lineNumbers[n2] < n) {
                ++n2;
            }
            this.pc = n2;
            boolean bl7 = this.fileOpenCheck;
            this.fileOpenCheck = this.fileOpenCheck && bl2;
            this.instructionDispatchLoop(bl3);
            this.fileOpenCheck = bl7;
            this.popContext();
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext();
            if (bl5) {
                this.error = false;
                this.errorMessage = null;
            } else {
                this.evalError(null);
            }
        }
        this.isSyntaxCheck = bl4;
        this.isScriptCheck = bl5;
    }

    private void function(int n) throws ScriptException {
        Vector vector;
        if (this.isSyntaxCheck && !this.isScriptCheck) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (this.getFunction(string, n) == null) {
            this.evalError(GT._("command expected"));
        }
        Vector vector2 = vector = this.statementLength == 1 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        this.pushContext(null);
        this.loadFunction(string, vector, n);
        this.instructionDispatchLoop(false);
        this.popContext();
    }

    private void sync() throws ScriptException {
        String string = "";
        String string2 = "";
        switch (this.statementLength) {
            case 1: {
                string2 = "*";
                string = "ON";
                break;
            }
            case 2: {
                string2 = this.parameterAsString(1);
                if (string2.indexOf("jmolApplet") == 0 || Parser.isOneOf(string2, "*;.;^")) {
                    string = "ON";
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(string, string2);
                    }
                    string2 = ".";
                    break;
                }
                string = string2;
                string2 = "*";
                break;
            }
            case 3: {
                string2 = this.parameterAsString(1);
                string = this.parameterAsString(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.syncScript(string, string2);
    }

    private void history(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            this.checkLength3();
            int n2 = this.intParameter(2);
            if (n2 < 0) {
                this.invalidArgument();
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        this.checkLength2();
        switch (this.getToken((int)1).tok) {
            case 262152: 
            case 524305: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 524304: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.keywordExpected("ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl) {
            this.viewer.display(this.viewer.getModelAtomBitSet(-1, false), bitSet, this.tQuiet);
        } else {
            this.viewer.hide(bitSet, this.tQuiet);
        }
    }

    private void select() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.select(null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        this.viewer.setNoneSelected(this.statementLength == 4 && this.tokAt(2) == 524301);
        if (this.tokAt(2) == 262215 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 6881282 && this.getToken((int)3).tok == 262215) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.invalidArgument();
        }
        if (this.getToken((int)2).tok == 591122) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 262215) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(5, "select", this.theToken.value);
                }
                return;
            }
            this.invalidArgument();
        }
        BitSet bitSet = this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds(bitSet);
        } else {
            this.viewer.select(bitSet, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BitSet bitSet = this.bsSubset = this.statementLength == 1 ? null : this.expression(-1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setSelectionSubset(this.bsSubset);
    }

    private void invertSelected() throws ScriptException {
        Point3f point3f = null;
        Point4f point4f = null;
        if (this.statementLength == 1) {
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bitSet = this.viewer.getSelectionSet();
            point3f = this.viewer.getAtomSetCenter(bitSet);
            this.viewer.invertSelected(point3f, bitSet);
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("point")) {
            point3f = this.centerParameter(2);
        } else if (string.equalsIgnoreCase("plane")) {
            point4f = this.planeParameter(2);
        } else if (string.equalsIgnoreCase("hkl")) {
            point4f = this.hklParameter(2);
        }
        this.checkStatementLength(this.iToken + 1);
        if (point4f == null && point3f == null) {
            this.invalidArgument();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.invertSelected(point3f, point4f);
    }

    private void translateSelected() throws ScriptException {
        Point3f point3f = this.getPoint3f(1, true);
        if (!this.isSyntaxCheck) {
            this.viewer.setAtomCoordRelative(point3f);
        }
    }

    private void translate() throws ScriptException {
        float f = this.floatParameter(2);
        if (f > 100.0f || f < -100.0f) {
            this.numberOutOfRange(-100, 100);
        }
        if (this.getToken((int)1).tok == 1) {
            String string = this.parameterAsString(1);
            if (string.equalsIgnoreCase("x")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToXPercent(f);
                }
                return;
            }
            if (string.equalsIgnoreCase("y")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToYPercent(f);
                }
                return;
            }
            if (string.equalsIgnoreCase("z")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToZPercent(f);
                }
                return;
            }
        }
        this.axisExpected();
    }

    private void zap() {
        this.viewer.zap(true);
        this.refresh();
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.statementLength > 1 ? this.getToken((int)1).tok : 524305;
            switch (n) {
                case 524304: 
                case 524305: {
                    if (this.statementLength > 2) {
                        this.badArgumentCount();
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", n == 524305);
                    }
                    return;
                }
            }
        }
        float f2 = this.viewer.getZoomPercentFloat();
        float f3 = this.viewer.getRotationRadius();
        Point3f point3f = null;
        Point3f point3f2 = this.viewer.getRotationCenter();
        int n = 1;
        float f4 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            this.invalidArgument();
        }
        int n2 = 0;
        if (this.isCenterParameter(n)) {
            n2 = n;
            point3f = this.centerParameter(n);
            n = this.iToken + 1;
        }
        boolean bl2 = point3f != null && (double)point3f2.distance(point3f) < 0.1;
        float f5 = this.getZoomFactor(n, n2, f3, f2);
        if (f5 < 0.0f) {
            f5 = -f5;
            if (bl) {
                if (this.statementLength == 1 || bl2) {
                    f5 *= 2.0f;
                } else if (point3f == null) {
                    f5 /= 2.0f;
                }
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = this.viewer.getMaxZoomPercent();
        if (f5 < 5.0f || f5 > f8) {
            this.numberOutOfRange(5.0f, f8);
        }
        if (!this.viewer.isWindowCentered()) {
            if (point3f != null) {
                BitSet bitSet = this.expression(n2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bitSet, false);
                }
            }
            point3f = this.viewer.getRotationCenter();
            f6 = this.viewer.getTranslationXPercent();
            f7 = this.viewer.getTranslationYPercent();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl2 && Math.abs(f2 - f5) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(f, point3f, new Point3f(0.0f, 0.0f, 0.0f), Float.NaN, f5, f6, f7, f3, null, Float.NaN, Float.NaN, Float.NaN);
    }

    private float getZoomFactor(int n, int n2, float f, float f2) throws ScriptException {
        float f3;
        float f4;
        BitSet bitSet = null;
        float f5 = f4 = this.isFloatParameter(n) ? this.floatParameter(n) : Float.NaN;
        if (f4 == 0.0f) {
            switch (this.statement[n2].tok) {
                case 262215: 
                case 524388: {
                    bitSet = this.expression(this.statement, n2, 0, true, false, false);
                }
            }
            if (bitSet == null) {
                this.invalidArgument();
            }
            f3 = this.viewer.calcRotationRadius(bitSet);
            f2 = f / f3 * 100.0f;
            f4 = Float.NaN;
            ++n;
        }
        if (f4 < 0.0f) {
            f4 += f2;
        } else if (Float.isNaN(f4)) {
            f4 = f2;
            if (this.isFloatParameter(n + 1)) {
                f3 = this.floatParameter(n + 1);
                switch (this.getToken((int)n++).tok) {
                    case 0x880040: {
                        f4 /= f3;
                        break;
                    }
                    case 8912961: {
                        f4 *= f3;
                        break;
                    }
                    case 8912953: {
                        f4 += f3;
                        break;
                    }
                    default: {
                        this.invalidArgument();
                        break;
                    }
                }
            } else {
                if (bitSet == null) {
                    f4 = -f4;
                }
                --n;
            }
        }
        this.iToken = n;
        return f4;
    }

    private void gotocmd() throws ScriptException {
        String string = null;
        string = this.parameterAsString(1);
        int n = -1;
        for (int i = 0; i < this.aatoken.length; ++i) {
            Token[] tokenArray = this.aatoken[i];
            if (tokenArray[0].tok != 2405 || !tokenArray[1].value.toString().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            this.invalidArgument();
        }
        if (!this.isSyntaxCheck) {
            this.pc = n - 1;
        }
    }

    private void delay() throws ScriptException {
        long l = 0L;
        switch (this.getToken((int)1).tok) {
            case 524305: {
                l = 1L;
                break;
            }
            case 2: {
                l = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                l = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(l);
        }
    }

    private void delay(long l) {
        long l2 = System.currentTimeMillis();
        this.refresh();
        int n = (int)(l -= System.currentTimeMillis() - l2) / 1000;
        if ((l -= (long)(n * 1000)) <= 0L) {
            l = 1L;
        }
        while (n >= 0 && l > 0L && !this.interruptExecution.booleanValue() && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint();
            try {
                Thread.sleep(n-- > 0 ? 1000L : l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint();
        }
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        Point4f point4f = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 8) {
            point4f = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    this.checkLength2();
                    int n = this.intParameter(1);
                    if (!this.isSyntaxCheck) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 524305: {
                    this.checkLength2();
                    bl2 = true;
                }
                case 524304: {
                    this.checkLength2();
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 280: {
                    this.checkLength2();
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 169247: {
                    this.checkLength2();
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x880038: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        point4f = this.planeParameter(3);
                    }
                    if (point4f == null) {
                        this.invalidArgument();
                    }
                    point4f.scale(-1.0f);
                    break;
                }
                case 17303586: {
                    switch (this.getToken((int)2).tok) {
                        case 524301: {
                            break block0;
                        }
                    }
                    point4f = this.planeParameter(2);
                    break;
                }
                case 1: {
                    String string = this.parameterAsString(1);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.getToken((int)2).tok == 524301 ? null : this.hklParameter(2);
                        break;
                    }
                    if (string.equalsIgnoreCase("reference")) {
                        return;
                    }
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.slabInternal(point4f, bl);
        }
    }

    private int getDiameterTok() throws ScriptException {
        if (this.statementLength == 1) {
            return 524305;
        }
        int n = this.getToken((int)1).tok;
        switch (this.statementLength) {
            case 2: {
                break;
            }
            case 3: {
                if (n == 2 && this.getToken((int)2).tok == 8912962 || n == 8912953 && this.isFloatParameter(2)) break;
                this.invalidArgument();
            }
        }
        return n;
    }

    private void star() throws ScriptException {
        int n = 0;
        switch (this.getDiameterTok()) {
            case 524305: 
            case 69730326: {
                n = -100;
                break;
            }
            case 524304: {
                break;
            }
            case 2: {
                int n2 = this.intParameter(1);
                if (this.statementLength == 2) {
                    if (n2 >= 750 || n2 < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    n = (short)n2;
                    if (n2 <= 0) break;
                    n = (short)(n * 8);
                    break;
                }
                if (n2 < 0 || n2 > 100) {
                    this.numberOutOfRange(0, 100);
                }
                n = (short)(-n2);
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f < 0.0f || f > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                n = (short)(f * 1000.0f * 2.0f);
                break;
            }
            case 69730346: {
                n = -1000;
                break;
            }
            case 262199: {
                n = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(14, n);
    }

    private void structure() throws ScriptException {
        String string = this.parameterAsString(1).toLowerCase();
        byte by = 0;
        BitSet bitSet = null;
        if (string.equals("helix")) {
            by = 3;
        } else if (string.equals("sheet")) {
            by = 2;
        } else if (string.equals("turn")) {
            by = 1;
        } else if (string.equals("none")) {
            by = 0;
        } else {
            this.invalidArgument();
        }
        switch (this.tokAt(2)) {
            case 262215: 
            case 524388: {
                bitSet = this.expression(2);
                this.checkStatementLength(this.iToken + 1);
                break;
            }
            default: {
                this.checkLength2();
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearPredefined(JmolConstants.predefinedVariable);
        this.viewer.setProteinType(by, bitSet);
    }

    private void halo() throws ScriptException {
        int n = 0;
        switch (this.getDiameterTok()) {
            case 524305: {
                n = -20;
                break;
            }
            case 69730326: {
                n = -100;
                break;
            }
            case 524304: {
                break;
            }
            case 2: {
                int n2 = this.intParameter(1);
                if (this.statementLength == 2) {
                    if (n2 >= 750 || n2 < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    n = (short)n2;
                    if (n2 <= 0) break;
                    n = (short)(n * 8);
                    break;
                }
                if (n2 < 0 || n2 > 100) {
                    this.numberOutOfRange(0, 100);
                }
                n = (short)(-n2);
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f < 0.0f || f > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                n = (short)(f * 1000.0f * 2.0f);
                break;
            }
            case 69730346: {
                n = -1000;
                break;
            }
            case 262199: {
                n = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(15, n);
    }

    private void spacefill() throws ScriptException {
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        switch (this.getDiameterTok()) {
            case 524305: 
            case 69730326: {
                n = -100;
                break;
            }
            case 524304: {
                break;
            }
            case 8912953: {
                bl = true;
                ++n2;
            }
            case 3: {
                float f = this.floatParameter(n2);
                if (f < 0.0f || f > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                n = (short)(f * 1000.0f * 2.0f);
                if (!bl) break;
                n = (short)(n + 10000);
                break;
            }
            case 2: {
                int n3 = this.intParameter(1);
                if (this.statementLength == 2) {
                    if (n3 >= 750 || n3 < -200) {
                        this.numberOutOfRange(-200, 749);
                    }
                    n = (short)n3;
                    if (n3 <= 0) break;
                    n = (short)(n * 8);
                    break;
                }
                if (n3 < 0 || n3 > 200) {
                    this.numberOutOfRange(0, 200);
                }
                n = (short)(-n3);
                break;
            }
            case 69730346: {
                n = -1000;
                break;
            }
            case 262199: {
                n = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(0, n);
    }

    private void wireframe() throws ScriptException {
        short s = this.getMadParameter();
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", new Integer(1023));
        this.viewer.setShapeSize(1, s, this.viewer.getSelectionSet());
    }

    private void ssbond() throws ScriptException {
        this.setShapeProperty(1, "type", new Integer(256));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void hbond(boolean bl) throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 1383) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null);
            this.scriptStatus(GT._("{0} hydrogen bonds", n));
            return;
        }
        this.setShapeProperty(1, "type", new Integer(30720));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void configuration() throws ScriptException {
        int n;
        BitSet bitSet;
        if (!this.isSyntaxCheck && this.viewer.getDisplayModelIndex() <= -2) {
            this.evalError(GT._("{0} not allowed with background model displayed", "\"CONFIGURATION\""));
        }
        if (this.statementLength == 1) {
            bitSet = this.viewer.setConformation();
            this.viewer.addStateScript("select " + Escape.escape(this.viewer.getSelectionSet()) + "; configuration;", true);
        } else {
            this.checkLength2();
            if (this.isSyntaxCheck) {
                return;
            }
            n = this.intParameter(1);
            bitSet = this.viewer.setConformation(n - 1);
            this.viewer.addStateScript("configuration " + n + ";", true);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = this.viewer.hasCalculatedHBonds(bitSet) ? 1 : 0;
        this.setShapeProperty(1, "type", new Integer(30720));
        this.viewer.setShapeSize(1, 0, bitSet);
        if (n != 0) {
            this.viewer.autoHbond(bitSet, bitSet, null);
        }
        this.viewer.select(bitSet, this.tQuiet);
    }

    private void vector() throws ScriptException {
        int n = 1;
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 524305: {
                        break block0;
                    }
                    case 524304: {
                        n = 0;
                        break block0;
                    }
                    case 2: {
                        int n2 = this.intParameter(1);
                        if (n2 < 0 || n2 >= 20) {
                            this.numberOutOfRange(0, 19);
                        }
                        n = (short)n2;
                        break block0;
                    }
                    case 3: {
                        float f = this.floatParameter(1);
                        if (f > 3.0f) {
                            this.numberOutOfRange(0.0f, 3.0f);
                        }
                        n = (short)(f * 1000.0f * 2.0f);
                        break block0;
                    }
                }
                this.booleanOrNumberExpected();
                break;
            }
            case 3: {
                if (this.parameterAsString(1).equalsIgnoreCase("scale")) {
                    float f = this.floatParameter(2);
                    if (f < -10.0f || f > 10.0f) {
                        this.numberOutOfRange(-10.0f, 10.0f);
                    }
                    this.setFloatProperty("vectorScale", f);
                    return;
                }
                this.invalidArgument();
            }
        }
        this.setShapeSize(17, n);
    }

    private void dipole() throws ScriptException {
        String string = null;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.viewer.loadShape(16);
        if (this.tokAt(1) == 6 && this.listIsosurface(16)) {
            return;
        }
        this.setShapeProperty(16, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(16, "thisID", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            string = null;
            object = null;
            switch (this.getToken((int)i).tok) {
                case 524305: {
                    string = "on";
                    break;
                }
                case 524304: {
                    string = "off";
                    break;
                }
                case 262186: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    object = new Float(this.floatParameter(i));
                    break;
                }
                case 262215: {
                    string = "atomBitset";
                }
                case 524388: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    object = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: 
                case 524291: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    object = point3f;
                    bl2 = true;
                    break;
                }
                case 6881282: {
                    string = "bonds";
                    break;
                }
                case 1383: {
                    string = "calculate";
                    break;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("cross")) {
                        string = "cross";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("noCross")) {
                        string = "cross";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("offset")) {
                        float f = this.floatParameter(++i);
                        if (this.theTok == 2) {
                            string = "offsetPercent";
                            object = new Integer((int)f);
                            break;
                        }
                        string = "offset";
                        object = new Float(f);
                        break;
                    }
                    if (string2.equalsIgnoreCase("value")) {
                        string = "value";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("offsetSide")) {
                        string = "offsetSide";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("width")) {
                        string = "width";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (bl3) {
                        this.invalidArgument();
                    }
                    string = "thisID";
                    object = string2.toLowerCase();
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            boolean bl4 = bl3 = this.theTok != 262186 && this.theTok != 1383;
            if (string == null) continue;
            this.setShapeProperty(16, string, object);
        }
        if (bl2 || bl) {
            this.setShapeProperty(16, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.statementLength > 5) {
            this.badArgumentCount();
        }
        int n = 0;
        switch (this.getToken((int)2).tok) {
            case 317: {
                n = 1;
                break;
            }
            case 1: {
                String string = this.parameterAsString(2);
                if (string.equalsIgnoreCase("once")) {
                    f2 = 0.0f;
                    f = 0.0f;
                    break;
                }
                if (string.equalsIgnoreCase("palindrome")) {
                    n = 2;
                    break;
                }
                this.invalidArgument();
            }
        }
        if (this.statementLength >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.statementLength == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(n, f, f2);
        }
    }

    private void vibration() throws ScriptException {
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 524305: {
                this.checkLength2();
                f = this.viewer.getVibrationPeriod();
                break;
            }
            case 524304: {
                this.checkLength2();
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength2();
                f = this.floatParameter(1);
                break;
            }
            case 1: {
                String string = this.optParameterAsString(1);
                if (string.equalsIgnoreCase("scale")) {
                    float f2 = this.floatParameter(2);
                    if (f2 < -10.0f || f2 > 10.0f) {
                        this.numberOutOfRange(-10.0f, 10.0f);
                    }
                    this.setFloatProperty("vibrationScale", f2);
                    return;
                }
                if (string.equalsIgnoreCase("period")) {
                    f = this.floatParameter(2);
                    this.setFloatProperty("vibrationPeriod", f);
                    return;
                }
                this.invalidArgument();
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.invalidArgument();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void animationDirection() throws ScriptException {
        this.checkStatementLength(4);
        boolean bl = false;
        this.getToken(2);
        if (this.theTok == 0x880038) {
            bl = true;
        } else if (this.theTok != 8912953) {
            this.invalidArgument();
        }
        int n = this.intParameter(3);
        if (n != 1) {
            this.numberMustBe(-1, 1);
        }
        if (bl) {
            n = -n;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(n);
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearPredefined(JmolConstants.predefinedVariable);
            switch (this.getToken((int)1).tok) {
                case 1572876: {
                    bl = true;
                }
                case 2621481: {
                    String string = this.optParameterAsString(2);
                    boolean bl2 = false;
                    if (!string.equalsIgnoreCase("within")) {
                        if (string.equalsIgnoreCase("from")) {
                            bl2 = true;
                        } else if (string.length() > 0) {
                            bl2 = true;
                            --this.iToken;
                        } else if (!bl) {
                            bl2 = true;
                        }
                    }
                    BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : this.viewer.getSelectionSet();
                    this.checkStatementLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.calculateSurface(bitSet, bl2 ? Float.MAX_VALUE : -1.0f);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("AROMATIC")) break;
                    this.checkLength2();
                    if (!this.isSyntaxCheck) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 590093: {
                    this.checkLength2();
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.autoHbond(null);
                    return;
                }
                case 2622740: {
                    BitSet bitSet;
                    BitSet bitSet2 = bitSet = this.statementLength == 2 ? null : this.expression(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (bitSet == null) {
                        bitSet = this.viewer.getModelAtomBitSet(-1, false);
                    }
                    this.viewer.calculateStructures(bitSet);
                    this.viewer.addStateScript(this.thisCommand, false);
                    return;
                }
            }
        }
        this.evalError(GT._("Calculate what?") + "aromatic? hbonds? polymers? structure? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void dots(int n, int n2) throws ScriptException {
        if (!this.isSyntaxCheck) {
            this.viewer.loadShape(n2);
        }
        this.setShapeProperty(n2, "init", null);
        if (this.statementLength == n) {
            this.setShapeSize(n2, 1);
            return;
        }
        int n3 = 0;
        switch (this.getToken((int)n).tok) {
            case 524305: 
            case 69730326: {
                n3 = 1;
                break;
            }
            case 262199: {
                n3 = -1;
                break;
            }
            case 524304: {
                break;
            }
            case 8912953: {
                float f = this.floatParameter(++n);
                if (f < 0.0f || f > 10.0f) {
                    this.numberOutOfRange(0.0f, 2.0f);
                }
                n3 = (short)(f == 0.0f ? 0.0f : f * 1000.0f + 11002.0f);
                break;
            }
            case 3: {
                float f = this.floatParameter(n);
                if (f < 0.0f || f > 10.0f) {
                    this.numberOutOfRange(0.0f, 10.0f);
                }
                n3 = (short)(f == 0.0f ? 0.0f : f * 1000.0f + 1002.0f);
                break;
            }
            case 2: {
                int n4 = this.intParameter(n);
                if (this.statementLength > n + 1 && this.statement[n + 1].tok == 2686993) {
                    this.setShapeProperty(n2, "atom", new Integer(n4));
                    ++n;
                    this.setShapeProperty(n2, "radius", new Float(this.floatParameter(++n)));
                    if (this.statementLength > n + 1 && this.statement[++n].tok == 74126595) {
                        this.setShapeProperty(n2, "colorRGB", new Integer(this.getArgbParam(++n)));
                    }
                    if (this.getToken((int)n).tok != 262215) {
                        this.invalidArgument();
                    }
                    this.setShapeProperty(n2, "dots", this.statement[n].value);
                    return;
                }
                if (n4 < 0 || n4 > 1000) {
                    this.numberOutOfRange(0, 1000);
                }
                n3 = (short)(n4 == 0 ? 0 : n4 + 1);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(n2, n3);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 524305: {
                n2 = -1;
                break;
            }
            case 524304: {
                break;
            }
            case 2622740: {
                n2 = -2;
                break;
            }
            case 262178: 
            case 69730346: {
                n2 = -4;
                break;
            }
            case 2: {
                int n3 = this.intParameter(1);
                if (n3 >= 500) {
                    this.numberOutOfRange(0, 499);
                }
                n2 = (short)(n3 * 4 * 2);
                break;
            }
            case 3: {
                float f = this.floatParameter(1);
                if (f > 4.0f) {
                    this.numberOutOfRange(0.0f, 4.0f);
                }
                n2 = (short)(f * 1000.0f * 2.0f);
                break;
            }
            case 262215: {
                if (!this.isSyntaxCheck) {
                    this.viewer.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.setShapeSize(n, n2);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 524305: {
                bl = true;
            }
            case 524304: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 324: {
                this.frame(2);
                break;
            }
            case 262175: {
                this.animationMode();
                break;
            }
            case 262176: {
                this.animationDirection();
                break;
            }
            case 1: {
                String string = this.parameterAsString(1);
                if (string.equalsIgnoreCase("fps")) {
                    this.checkLength3();
                    this.setIntProperty("animationFps", this.intParameter(2));
                    break;
                }
            }
            default: {
                this.frameControl(1, true);
            }
        }
    }

    private void file() throws ScriptException {
        int n = this.intParameter(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void frame(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = true;
        if (this.statementLength == 1 && n == 1) {
            int n4 = this.viewer.getCurrentModelIndex();
            if (!this.isSyntaxCheck && n4 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n4)) >= 0) {
                this.viewer.setCurrentModelIndex(n4, true);
            }
            return;
        }
        if (this.statementLength == 3 && this.parameterAsString(1).equalsIgnoreCase("Title")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setFrameTitle(this.parameterAsString(2));
            }
            return;
        }
        if (this.getToken((int)n).tok == 0x880038) {
            this.checkStatementLength(++n + 1);
            if (this.getToken((int)n).tok != 2 || this.intParameter(n) != 1) {
                this.invalidArgument();
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimationPrevious();
            }
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = new int[]{-1, -1};
        int n5 = 0;
        block9: for (n3 = n; n3 < this.statementLength; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 524303: 
                case 8912961: {
                    this.checkStatementLength(n + (bl3 ? 2 : 1));
                    bl4 = true;
                    continue block9;
                }
                case 0x880038: {
                    if (n5 != 1) {
                        this.invalidArgument();
                    }
                    bl5 = true;
                    continue block9;
                }
                case 524301: {
                    this.checkStatementLength(n + 1);
                    continue block9;
                }
                case 3: {
                    bl = false;
                    if (this.floatParameter(n3) < 0.0f) {
                        bl5 = true;
                    }
                }
                case 2: {
                    if (n5 == 2) {
                        this.invalidArgument();
                    }
                    if ((n2 = this.statement[n3].intValue) >= 1000 && n2 < 1000000 && this.viewer.haveFileSet()) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl && n2 == 0) {
                        bl4 = true;
                    }
                    if (n2 >= 1000000) {
                        bl = false;
                    }
                    nArray[n5++] = n2;
                    continue block9;
                }
                case 262201: {
                    bl2 = true;
                    continue block9;
                }
                case 262206: {
                    bl3 = true;
                    continue block9;
                }
                default: {
                    this.checkStatementLength(n + 1);
                    this.frameControl(n3, false);
                    return;
                }
            }
        }
        n3 = this.viewer.haveFileSet() ? 1 : 0;
        if (bl3 && n5 == 0) {
            bl4 = true;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl3) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n5 == 2 && !bl3) {
            bl5 = true;
        }
        if (n3 != 0) {
            bl = false;
        } else if (bl) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n2] < 0) continue;
                int n6 = n2;
                nArray[n6] = nArray[n6] % 1000000;
            }
        }
        n2 = this.viewer.getModelNumberIndex(nArray[0], bl, false);
        int n7 = -1;
        if (n3 != 0 && n5 == 1 && n2 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n2 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n2 >= 0) {
                    n7 = this.viewer.getModelNumberIndex(nArray[0] + 1000000, false, false);
                    if (n7 < 0) {
                        n7 = this.viewer.getModelCount();
                    }
                    --n7;
                    if (bl3) {
                        n5 = 2;
                    } else if (!bl5 && n7 != n2) {
                        bl5 = true;
                    }
                    bl3 = bl3 || n2 == n7;
                }
            } else {
                return;
            }
        }
        if (!bl2 && !bl3 || n2 >= 0) {
            this.viewer.setCurrentModelIndex(n2, false);
        }
        if (bl2 && n5 == 2 || bl3 || bl5) {
            if (n7 < 0) {
                n7 = this.viewer.getModelNumberIndex(nArray[1], bl, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n2, n7);
            this.viewer.setCurrentModelIndex(bl5 && !bl3 ? -1 : (n2 >= 0 ? n2 : 0), false);
        }
        if (bl2) {
            this.viewer.resumeAnimation();
        }
    }

    BitSet bitSetForModelFileNumber(int n) {
        int n2;
        BitSet bitSet = new BitSet();
        if (this.isSyntaxCheck) {
            return bitSet;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bitSet;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bitSet.or(this.viewer.getModelAtomBitSet(i, false));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bitSet.or(this.viewer.getModelAtomBitSet(n7, false));
            }
        }
        return bitSet;
    }

    private void frameControl(int n, boolean bl) throws ScriptException {
        this.checkStatementLength(n + 1);
        int n2 = this.getToken((int)n).tok;
        if (this.isSyntaxCheck) {
            switch (n2) {
                case 262200: 
                case 262201: 
                case 262202: 
                case 262203: 
                case 262204: 
                case 262205: 
                case 262217: 
                case 264467: {
                    return;
                }
            }
        } else {
            switch (n2) {
                case 262205: {
                    this.viewer.reverseAnimation();
                }
                case 262200: 
                case 262201: {
                    this.viewer.resumeAnimation();
                    return;
                }
                case 264467: {
                    this.viewer.pauseAnimation();
                    return;
                }
                case 262202: {
                    this.viewer.setAnimationNext();
                    return;
                }
                case 262203: {
                    this.viewer.setAnimationPrevious();
                    return;
                }
                case 262204: {
                    this.viewer.rewindAnimation();
                    return;
                }
                case 262217: {
                    this.viewer.setAnimationLast();
                    return;
                }
            }
        }
        this.evalError(GT._("invalid {0} control keyword", "frame"));
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JmolConstants.shapeTokenIndex(n);
        if (n2 < 0) {
            this.unrecognizedObject();
        }
        return n2;
    }

    private void font(int n, int n2) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n3 = 0;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                if (this.getToken((int)4).tok != 1) {
                    this.invalidArgument();
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 1) {
                    this.invalidArgument();
                }
                string = this.parameterAsString(3);
                if (this.getToken((int)2).tok != 2) {
                    this.integerExpected();
                }
                n2 = this.intParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (this.getToken((int)2).tok != 2) {
                    this.integerExpected();
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    n2 = this.intParameter(2);
                    break;
                }
                n3 = 5;
                n2 += 5;
                break;
            }
            default: {
                if (n == 4) {
                    n2 = 13;
                    break;
                }
                this.badArgumentCount();
            }
        }
        if (n == 4) {
            if (n2 < 6 || n2 > 63) {
                this.numberOutOfRange(6 - n3, 6 - n3);
            }
            this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
        }
        Font3D font3D = this.viewer.getFont3D(string, string2, n2);
        this.viewer.loadShape(n);
        this.setShapeProperty(n, "font", font3D);
    }

    private void set() throws ScriptException {
        String string;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl = this.parameterAsString(0).equals("set");
        if (bl && this.statementLength == 2 && (string = this.parameterAsString(1)).indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string.substring(0, string.indexOf("?"))));
            return;
        }
        boolean bl2 = !this.isSyntaxCheck && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.statement[0].value).equals("var");
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 65901: {
                this.axes(2);
                return;
            }
            case 196865: {
                this.background(2);
                return;
            }
            case 6886669: {
                this.boundbox(2);
                return;
            }
            case 65904: {
                this.frank(2);
                return;
            }
            case 65898: {
                this.history(2);
                return;
            }
            case 23660815: {
                this.label(2);
                return;
            }
            case 1638767: {
                this.unitcell(2);
                return;
            }
            case 65897: 
            case 66411: {
                this.selectionHalo(2);
                return;
            }
            case 65537: {
                this.setBondmode();
                return;
            }
            case 67851: {
                this.setEcho();
                return;
            }
            case 65538: {
                this.checkLength23();
                this.font(4, this.statementLength == 2 ? 0 : this.intParameter(2));
                return;
            }
            case 590093: {
                this.setHbond();
                return;
            }
            case 591122: {
                this.setMonitor();
                return;
            }
            case 73990156: {
                string = this.parameterAsString(1).toLowerCase();
                if (string.startsWith("property_")) break;
                this.setProperty();
                return;
            }
            case 65540: {
                this.setPicking();
                return;
            }
            case 65569: {
                this.setPickingStyle();
                return;
            }
            case 70976: {
                this.checkLength4();
                this.setSpin(this.parameterAsString(2), (int)this.floatParameter(3));
                return;
            }
            case 65828: {
                this.setSsbond();
                return;
            }
            case 65565: {
                this.setFloatProperty("scaleAngstromsPerInch", this.floatSetting(2));
                return;
            }
            case 69795849: {
                n2 = this.intSetting(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n2);
                }
                return;
            }
            case 65543: {
                if (this.statementLength == 2 || this.statement[2].tok != 2) {
                    string = "specular";
                    break;
                }
            }
            case 65544: {
                string = "specularPercent";
                break;
            }
            case 65536: {
                string = "ambientPercent";
                break;
            }
            case 65567: {
                string = "diffusePercent";
                break;
            }
            case 65545: {
                n = this.intSetting(2);
                if (n >= 0) {
                    string = "specularPower";
                    break;
                }
                if (n < -10 || n > -1) {
                    this.numberOutOfRange(-10, -1);
                }
                n = -n;
                string = "specularExponent";
                break;
            }
            case 65546: {
                string = "specularExponent";
                break;
            }
            case 6881282: {
                string = "showMultipleBonds";
                break;
            }
            case 65831: {
                string = "strandCount";
                break;
            }
            case 0x190001: {
                string = "selectHetero";
                break;
            }
            case 1638402: {
                string = "selectHydrogen";
                break;
            }
            case 2686993: {
                string = "solventProbeRadius";
                break;
            }
            case 1638404: {
                string = "solventProbe";
                break;
            }
            case 65548: 
            case 74126595: {
                string = "defaultColorScheme";
                break;
            }
            default: {
                string = this.parameterAsString(1);
                if (string.charAt(0) == '_') {
                    this.invalidArgument();
                }
                if (string.equalsIgnoreCase("toggleLabel") && this.setLabel("toggle")) {
                    return;
                }
                if (string.toLowerCase().indexOf("label") == 0 && Parser.isOneOf(string.toLowerCase(), "labelfront;labelgroup;labelatom;labeloffset;labelpointer;labelalignment;labeltoggle") && this.setLabel(string.substring(5))) {
                    return;
                }
                if (string.equalsIgnoreCase("userColorScheme")) {
                    this.setUserColors();
                    return;
                }
                if (string.equalsIgnoreCase("defaultLattice")) {
                    int n3;
                    Vector vector = (Vector)this.parameterExpression(2, 0, "XXX", true);
                    if (vector == null || vector.size() == 0) {
                        this.invalidArgument();
                    }
                    Token token = (Token)vector.elementAt(0);
                    Point3f point3f = token.tok == 7 ? (Point3f)token.value : ((n3 = Token.iValue(token)) < 555 ? new Point3f() : UnitCell.ijkToPoint3f(n3 + 111));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setDefaultLattice(point3f);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("defaultDrawArrowScale")) {
                    this.setFloatProperty(string, this.floatSetting(2));
                    return;
                }
                if (string.equalsIgnoreCase("logLevel")) {
                    int n4 = this.intSetting(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.setIntProperty("logLevel", n4);
                    return;
                }
                if (string.equalsIgnoreCase("backgroundModel")) {
                    int n5;
                    String string2 = this.stringSetting(2, false);
                    boolean bl3 = false;
                    if (string2.indexOf(".") < 0) {
                        n5 = Parser.parseInt(string2);
                        bl3 = true;
                    } else {
                        n5 = Compiler.modelValue(string2);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    int n6 = this.viewer.getModelNumberIndex(n5, bl3, true);
                    this.viewer.setBackgroundModelIndex(n6);
                    return;
                }
                if (string.equalsIgnoreCase("language")) {
                    String string3 = this.stringSetting(2, bl);
                    this.setStringProperty(string, string3);
                    return;
                }
                if (string.equalsIgnoreCase("trajectory") || string.equalsIgnoreCase("trajectories")) {
                    Token token = this.tokenSetting(2);
                    if (token.tok == 3) {
                        this.viewer.getModelNumberIndex(token.intValue, false, true);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("showSelections")) {
                    string = "selectionHalos";
                    break;
                }
                if (!string.equalsIgnoreCase("measurementNumbers")) break;
                string = "measurementLabels";
            }
        }
        if (this.getContextVariableAsToken(string) != null || !this.setParameter(string, n, bl, bl2)) {
            int n7 = this.tokAt(1) == 524388 ? 0 : this.tokAt(2);
            this.setVariable(n7 == 42467380 ? 3 : 2, 0, string, bl2);
            if (!bl) {
                return;
            }
        }
        if (bl2) {
            this.viewer.showParameter(string, true, 80);
        }
    }

    private int intSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, 0, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.invalidArgument();
        }
        return Token.iValue((Token)vector.elementAt(0));
    }

    private float floatSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, 0, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.invalidArgument();
        }
        return Token.fValue((Token)vector.elementAt(0));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.statementLength == n + 1) {
            return this.parameterAsString(n);
        }
        Vector vector = (Vector)this.parameterExpression(n, 0, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.invalidArgument();
        }
        return Token.sValue((Token)vector.elementAt(0));
    }

    private Token tokenSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, 0, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.invalidArgument();
        }
        return (Token)vector.elementAt(0);
    }

    private void setVariable(int n, int n2, String string, boolean bl) throws ScriptException {
        Token token;
        Object object;
        BitSet bitSet = null;
        String string2 = "";
        if (this.tokAt(n - 1) == 524388) {
            bitSet = this.expression(n - 1);
            n = this.iToken + 1;
        }
        int n3 = 0;
        if (this.tokAt(n) == 524289) {
            object = this.getBitsetPropertySelector(n++, true);
            if (this.tokAt(++n) != 42467380) {
                this.invalidArgument();
            }
            ++n;
            n3 = ((Token)object).intValue;
            string2 = (String)((Token)object).value;
        } else if (bitSet != null) {
            this.invalidArgument();
        }
        Token token2 = this.getContextVariableAsToken(string);
        boolean bl2 = token2 != null || n3 != 0;
        Object object2 = this.parameterExpression(n, n2, string, bl2);
        if (this.isSyntaxCheck || object2 == null) {
            return;
        }
        Token token3 = token = bl2 ? (Token)((Vector)object2).get(0) : null;
        if (n3 != 0) {
            if (bitSet == null) {
                if (token2 == null) {
                    object2 = this.viewer.getParameter(string);
                    if (!(object2 instanceof String)) {
                        this.invalidArgument();
                    }
                    if (!((object2 = this.getStringObjectAsToken((String)object2, null)) instanceof Token)) {
                        this.invalidArgument();
                    }
                    token2 = (Token)object2;
                }
                if (!(token2.value instanceof BitSet)) {
                    this.invalidArgument();
                }
                bitSet = (BitSet)token2.value;
            }
            if (string2.startsWith("property_")) {
                this.viewer.setData(string2, new Object[]{string2, Token.sValue(token), bitSet}, this.viewer.getAtomCount(), 0, token.tok == 6 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                return;
            }
            this.setBitsetProperty(bitSet, n3, Token.iValue(token), Token.fValue(token), token);
            return;
        }
        if (token2 != null) {
            token2.value = token.value;
            token2.intValue = token.intValue;
            token2.tok = token.tok;
        }
        if (string.startsWith("property_")) {
            int n4 = this.viewer.getAtomCount();
            this.viewer.setData(string, new Object[]{string, "" + object2, this.viewer.getSelectionSet()}, n4, 0, Integer.MIN_VALUE);
            return;
        }
        if (object2 == null) {
            return;
        }
        if (object2 instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object2);
        } else if (object2 instanceof Integer) {
            this.setIntProperty(string, (Integer)object2);
        } else if (object2 instanceof Float) {
            this.setFloatProperty(string, ((Float)object2).floatValue());
        } else if (object2 instanceof String) {
            this.setStringProperty(string, (String)object2);
        } else if (object2 instanceof Bond.BondSet) {
            this.setStringProperty(string, Escape.escape((BitSet)object2, false));
        } else if (object2 instanceof BitSet) {
            this.setStringProperty(string, Escape.escape((BitSet)object2));
        } else if (object2 instanceof Point3f) {
            object = Escape.escape((Point3f)object2);
            this.setStringProperty(string, (String)object);
        } else if (object2 instanceof Point4f) {
            object = Escape.escape((Point4f)object2);
            this.setStringProperty(string, (String)object);
        }
    }

    private boolean setParameter(String string, int n, boolean bl, boolean bl2) throws ScriptException {
        String string2 = string.toLowerCase();
        if (string.equalsIgnoreCase("scriptReportingLevel")) {
            n = this.intSetting(2);
            if (!this.isSyntaxCheck) {
                this.scriptReportingLevel = n;
                this.setIntProperty(string, n);
            }
            return true;
        }
        if (string.equalsIgnoreCase("historyLevel")) {
            n = this.intSetting(2);
            if (!this.isSyntaxCheck) {
                this.commandHistoryLevelMax = n;
                this.setIntProperty(string, n);
            }
            return true;
        }
        if (string.equalsIgnoreCase("dipoleScale")) {
            float f = this.floatSetting(2);
            if (f < -10.0f || f > 10.0f) {
                this.numberOutOfRange(-10.0f, 10.0f);
            }
            this.setFloatProperty("dipoleScale", f);
            return true;
        }
        if (string.equalsIgnoreCase("axesScale")) {
            float f = this.floatSetting(2);
            this.setFloatProperty("axesScale", f);
            return true;
        }
        if (string.equalsIgnoreCase("measurementUnits")) {
            this.setMeasurementUnits(this.stringSetting(2, bl));
            return true;
        }
        if (Parser.isOneOf(string2, "defaults;defaultcolorscheme")) {
            String string3;
            this.theTok = this.tokAt(2);
            if (this.theTok == 262190 || this.theTok == 262149) {
                string3 = this.parameterAsString(2).toLowerCase();
                this.checkLength3();
            } else {
                string3 = this.stringSetting(2, false).toLowerCase();
            }
            if (!string3.equals("jmol") && !string3.equals("rasmol")) {
                this.invalidArgument();
            }
            this.setStringProperty(string.equalsIgnoreCase("defaults") ? string : "defaultColorScheme", string3);
            return true;
        }
        if (Parser.isOneOf(string2, "strandcount;strandcountformeshribbon;strandcountforstrands")) {
            n = this.intSetting(2);
            if (n < 0 || n > 20) {
                this.numberOutOfRange(0, 20);
            }
            this.setIntProperty(string, n);
            return true;
        }
        if (Parser.isOneOf(string2, "specularpercent;ambientpercent;diffusepercent;specularPower")) {
            if (n == Integer.MAX_VALUE) {
                n = this.intSetting(2);
            }
            if (n < 0 || n > 100) {
                this.numberOutOfRange(0, 100);
            }
            this.setIntProperty(string, n);
            return true;
        }
        if (string.equalsIgnoreCase("specularExponent")) {
            if (n == Integer.MAX_VALUE) {
                n = this.intSetting(2);
            }
            if (n > 10 || n < 1) {
                this.numberOutOfRange(1, 10);
            }
            this.setIntProperty(string, n);
            return true;
        }
        boolean bl3 = this.viewer.isJmolVariable(string);
        if (bl && !bl3) {
            this.iToken = 1;
            this.unrecognizedParameter("SET", string);
        }
        switch (this.statementLength) {
            case 2: {
                this.setBooleanProperty(string, true);
                return true;
            }
            case 3: {
                if (n != Integer.MAX_VALUE) {
                    this.setIntProperty(string, n);
                    return true;
                }
                this.getToken(2);
                if (this.theTok == 524301) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.removeUserVariable(string);
                    }
                } else if (!bl || this.theTok != 1) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private Object parameterExpression(int n, int n2, String string, boolean bl) throws ScriptException {
        Token token;
        boolean bl2 = string != null && string.length() > 0;
        Rpn rpn = new Rpn(64, bl2 && this.tokAt(n) == 0x880010, bl);
        if (n2 < n) {
            n2 = this.statementLength;
        }
        block16: for (int i = n; i < n2; ++i) {
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 524302: {
                    break block16;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 262215: 
                case 524304: 
                case 524305: {
                    rpn.addX(this.theToken);
                    break;
                }
                case 2: 
                case 524314: {
                    rpn.addX(Token.intToken(this.theToken.intValue));
                    break;
                }
                case 524293: {
                    rpn.addX(new Token(7, this.centerParameter(i)));
                    i = this.iToken;
                    break;
                }
                case 524291: {
                    object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    i = this.iToken;
                    break;
                }
                case 524388: {
                    object = this.expression(this.statement, i, 0, true, true, true);
                    i = this.iToken;
                    break;
                }
                case 524389: {
                    ++i;
                    break block16;
                }
                case 524292: {
                    this.invalidArgument();
                }
                case 0x880008: {
                    if (rpn.addOp(this.theToken)) break;
                    this.invalidArgument();
                    break;
                }
                case 524289: {
                    Token token2 = this.getBitsetPropertySelector(i, false);
                    if (this.tokAt(this.iToken + 1) == 524289) {
                        if (this.tokAt(this.iToken + 2) == 524303) {
                            token2.intValue |= 0xC0;
                            this.getToken(this.iToken + 2);
                        }
                        if (Compiler.tokAttrOr(this.tokAt(this.iToken + 2), 64, 128)) {
                            token2.intValue |= this.getToken((int)(this.iToken + 2)).tok;
                        }
                    }
                    if (!rpn.addOp(token2)) {
                        this.invalidArgument();
                    }
                    i = this.iToken;
                    break;
                }
                default: {
                    if (this.theTok == 1 && this.compiler.isFunction((String)this.theToken.value)) {
                        if (rpn.addOp(new Token(17326337, this.theToken.value))) break;
                        this.invalidArgument();
                        break;
                    }
                    if (Compiler.tokAttr(this.theTok, 0x880000) || Compiler.tokAttr(this.theTok, 0x1080000)) {
                        if (rpn.addOp(this.theToken)) break;
                        this.invalidArgument();
                        break;
                    }
                    String string2 = this.parameterAsString(i);
                    if (this.isSyntaxCheck) {
                        object = string2;
                        break;
                    }
                    object = this.getParameter(string2, true);
                    if (!(object instanceof String)) break;
                    object = this.getStringObjectAsToken((String)object, string2);
                }
            }
            if (object == null) continue;
            if (object instanceof Boolean) {
                rpn.addX((Boolean)object != false ? Token.tokenOn : Token.tokenOff);
                continue;
            }
            if (object instanceof Integer) {
                rpn.addX(Token.intToken((Integer)object));
                continue;
            }
            if (object instanceof Float) {
                rpn.addX(new Token(3, object));
                continue;
            }
            if (object instanceof String) {
                rpn.addX(new Token(4, object));
                continue;
            }
            if (object instanceof Point3f) {
                rpn.addX(new Token(7, object));
                continue;
            }
            if (object instanceof Point4f) {
                rpn.addX(new Token(8, object));
                continue;
            }
            if (object instanceof BitSet) {
                rpn.addX(new Token(262215, object));
                continue;
            }
            if (object instanceof Token) {
                rpn.addX((Token)object);
                continue;
            }
            this.invalidArgument();
        }
        if ((token = rpn.getResult(false, string)) == null) {
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks();
            }
            this.endOfStatementUnexpected();
        }
        if (token.tok == 4435) {
            return token.value;
        }
        if (string == null) {
            return Token.bValue(token);
        }
        if (string.length() == 0) {
            if (token.tok == 4) {
                token.intValue = Integer.MAX_VALUE;
            }
            return Token.sValue(token);
        }
        if (token.tok == 4 && token.intValue != Integer.MAX_VALUE) {
            if (!this.isSyntaxCheck && !this.insertArrayValue(string, token)) {
                this.invalidArgument();
            }
            return null;
        }
        switch (token.tok) {
            case 524304: 
            case 524305: {
                return token == Token.tokenOn;
            }
            case 2: {
                return new Integer(token.intValue);
            }
        }
        return token.value;
    }

    private boolean insertArrayValue(String string, Token token) {
        int n = token.intValue;
        if (n == Integer.MAX_VALUE) {
            return false;
        }
        token.intValue = Integer.MAX_VALUE;
        String string2 = Token.sValue(token);
        Object object = this.getParameter(string, false);
        if (!(object instanceof String)) {
            return false;
        }
        if ((object = this.getStringObjectAsToken((String)object, string)) instanceof Token) {
            Token token2 = (Token)object;
            if (token2.tok != 6) {
                return false;
            }
            String[] stringArray = (String[])token2.value;
            if (n <= 0) {
                n = stringArray.length + n;
            }
            if (--n < 0) {
                n = 0;
            }
            if (stringArray.length > n) {
                stringArray[n] = string2;
                this.viewer.setListVariable(string, token2);
                return true;
            }
            String[] stringArray2 = ArrayUtil.ensureLength(stringArray, n + 1);
            for (int i = stringArray.length; i <= n; ++i) {
                stringArray2[i] = "";
            }
            stringArray2[n] = string2;
            token2.value = stringArray2;
            this.viewer.setListVariable(string, token2);
            return true;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            int n2 = string3.length();
            if (n <= 0) {
                n = n2 + n;
            }
            if (--n < 0) {
                n = 0;
            }
            while (n >= string3.length()) {
                string3 = string3 + " ";
            }
            string3 = string3.substring(0, n) + string2 + string3.substring(n + 1);
            this.setStringProperty(string, string3);
            return true;
        }
        return false;
    }

    private void assignBitsetVariable(String string, BitSet bitSet) {
        this.variables.put(string, bitSet);
        this.setStringProperty("@" + string, Escape.escape(bitSet));
    }

    String getBitsetIdent(BitSet bitSet, String string, Object object, boolean bl) {
        String string2;
        int n;
        int[] nArray;
        int n2;
        boolean bl2;
        boolean bl3 = bl2 = !(object instanceof Bond.BondSet);
        if (bl2 && string == null) {
            string = this.viewer.getStandardLabelFormat();
        }
        int n3 = n2 = string == null ? -1 : string.indexOf("%");
        if (bitSet == null || this.isSyntaxCheck || bl2 && n2 < 0) {
            return string == null ? "" : string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = bitSet.size();
        ModelSet modelSet = this.viewer.getModelSet();
        int n5 = 0;
        int[] nArray2 = nArray = bl2 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && string != null && string.indexOf("%D") > 0) {
            nArray = this.viewer.getAtomIndices(bitSet);
        }
        int n6 = 0;
        String[] stringArray = null;
        Object object2 = null;
        while (n2 >= 0 && (n2 = string.indexOf("{", n2 + 1)) > 0) {
            n = string.indexOf("}", n2);
            if (n > 0) {
                float[] fArray;
                if (n6 == 0) {
                    for (int i = n2; i < string.length(); ++i) {
                        if (string.charAt(i) != '{') continue;
                        ++n6;
                    }
                    stringArray = new String[n6];
                    object2 = new float[n6][];
                    n6 = 0;
                }
                if ((fArray = this.viewer.getDataFloat(string2 = string.substring(n2 + 1, n))) != null) {
                    object2[n6] = fArray;
                    stringArray[n6++] = '{' + string2 + '}';
                }
            }
            n2 = n;
        }
        for (n = 0; n < n4; ++n) {
            if (!bitSet.get(n)) continue;
            string2 = string;
            if (bl2) {
                if (string2 == null) {
                    string2 = modelSet.getAtomAt(n).getInfo();
                } else {
                    string2 = modelSet.getAtomAt(n).formatLabel(string2, '\u0000', nArray);
                    for (int i = 0; i < n6; ++i) {
                        if (n >= object2[i].length) continue;
                        string2 = TextFormat.formatString(string2, stringArray[i], object2[i][n]);
                    }
                }
            } else {
                Bond bond = modelSet.getBondAt(n);
                if (string2 == null) {
                    string2 = bond.getIdentity();
                } else {
                    int n7;
                    string2 = bond.formatLabel(string2, nArray);
                    int n8 = bond.getAtomIndex1();
                    int n9 = bond.getAtomIndex2();
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (n8 >= object2[n7].length) continue;
                        string2 = TextFormat.formatString(string2, stringArray[n7] + "1", object2[n7][n8]);
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (n9 >= object2[n7].length) continue;
                        string2 = TextFormat.formatString(string2, stringArray[n7] + "2", object2[n7][n9]);
                    }
                }
            }
            string2 = TextFormat.formatString(string2, "#", ++n5);
            if (n5 > 1) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private Token getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)(++n)).tok;
        String string = this.parameterAsString(n).toLowerCase();
        switch (n2) {
            default: {
                if (Compiler.tokAttrOr(n2, 0x280000, 0x680000)) break;
                this.invalidArgument();
            }
            case 73990156: {
                break;
            }
            case 1: {
                if (string.equals("x")) {
                    n2 = 69730336;
                    break;
                }
                if (string.equals("y")) {
                    n2 = 69730337;
                    break;
                }
                if (string.equals("z")) {
                    n2 = 69730338;
                    break;
                }
                this.invalidArgument();
            }
        }
        if (bl && !Compiler.tokAttr(n2, 0x4000000)) {
            this.invalidArgument();
        }
        return new Token(8912977, n2, string);
    }

    protected Object getBitsetProperty(BitSet bitSet, int n, Point3f point3f, Point4f point4f, Object object, Object object2, boolean bl) throws ScriptException {
        Object object3;
        int n2;
        boolean bl2 = !(object instanceof Bond.BondSet);
        boolean bl3 = Compiler.tokAttr(n, 64);
        boolean bl4 = Compiler.tokAttr(n, 128);
        boolean bl5 = Compiler.tokAttr(n, 192);
        if (bl5) {
            bl4 = false;
            bl3 = false;
        }
        float[] fArray = null;
        BitSet bitSet2 = null;
        if ((n &= 0xFFFFFF3F) == 6815745) {
            BitSet bitSet3 = bitSet2 = !bl2 && !this.isSyntaxCheck ? this.viewer.getAtomsWithin(6881282, bitSet) : bitSet;
        }
        if (n == 6881282) {
            BitSet bitSet4 = bitSet2 = bl2 && !this.isSyntaxCheck ? this.viewer.getBondsForSelectedAtoms(bitSet) : bitSet;
        }
        if (bitSet2 != null) {
            if (!bl4 && !bl3 || this.isSyntaxCheck) {
                return bitSet2;
            }
            int n3 = bitSet2.size();
            int n4 = 0;
            if (bl3) {
                n4 = -1;
                while (++n4 < n3 && !bitSet2.get(n4)) {
                }
            } else if (bl4) {
                n4 = n3;
                while (--n4 >= 0 && !bitSet2.get(n4)) {
                }
            }
            bitSet2.clear();
            if (n4 >= 0 && n4 < n3) {
                bitSet2.set(n4);
            }
            return bitSet2;
        }
        if (n == 6815748) {
            return bl3 || bl4 ? "" : this.getBitsetIdent(bitSet, null, object, bl);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MAX_VALUE;
        float f = 0.0f;
        float f2 = -3.4028235E38f;
        float f3 = Float.MAX_VALUE;
        Point3f point3f2 = new Point3f();
        if (n == 23592977 && point3f == null && point4f == null) {
            return point3f2;
        }
        boolean bl6 = true;
        Point3f point3f3 = n == 74126595 ? new Point3f() : null;
        ModelSet modelSet = this.viewer.getModelSet();
        float[] fArray2 = n == 73990156 ? this.viewer.getDataFloat((String)object2) : null;
        int n9 = 0;
        if (bl2) {
            int n10 = n9 = this.isSyntaxCheck ? 0 : this.viewer.getAtomCount();
            if (bl5) {
                fArray = new float[n9];
            }
            for (n2 = 0; n2 < n9; ++n2) {
                if (bitSet != null && !bitSet.get(n2)) continue;
                ++n5;
                object3 = modelSet.getAtomAt(n2);
                if (bl6) {
                    int n11 = 0;
                    switch (n) {
                        case 2621441: {
                            n11 = ((Atom)object3).getAtomNumber();
                            break;
                        }
                        case 2621444: {
                            n11 = n2;
                            break;
                        }
                        case 2621447: {
                            n11 = ((Atom)object3).getElementNumber();
                            break;
                        }
                        case 2621446: {
                            n11 = ((Atom)object3).getAtomicAndIsotopeNumber();
                            break;
                        }
                        case 69795849: {
                            n11 = ((Atom)object3).getFormalCharge();
                            break;
                        }
                        case 2621459: {
                            n11 = ((Atom)object3).getAtomSite();
                            break;
                        }
                        case 2621461: {
                            BitSet bitSet5 = ((Atom)object3).getAtomSymmetry();
                            int n12 = bitSet5.size();
                            int n13 = 0;
                            int n14 = Integer.MAX_VALUE;
                            int n15 = Integer.MIN_VALUE;
                            for (int i = 0; i < n12; ++i) {
                                if (!bitSet5.get(i)) continue;
                                n11 += i + 1;
                                n14 = Math.min(n14, i + 1);
                                n15 = Math.max(n15, i + 1);
                                ++n13;
                            }
                            if (bl3) {
                                n11 = n14;
                            } else if (bl4) {
                                n11 = n15;
                            }
                            n5 += n13 - 1;
                            break;
                        }
                        case 2621454: {
                            n11 = ((Atom)object3).getMoleculeNumber();
                            break;
                        }
                        case 69730319: {
                            n11 = ((Atom)object3).getOccupancy();
                            break;
                        }
                        case 2621456: {
                            n11 = ((Atom)object3).getPolymerLength();
                            break;
                        }
                        case 2621458: {
                            n11 = ((Atom)object3).getResno();
                            break;
                        }
                        case 2621450: {
                            n11 = ((Atom)object3).getGroupID();
                            break;
                        }
                        case 0x280002: {
                            n11 = ((Atom)object3).getSpecialAtomID();
                            break;
                        }
                        case 2622740: {
                            n11 = ((Atom)object3).getProteinStructureType();
                            break;
                        }
                        case 2621443: {
                            n11 = ((Atom)object3).getCovalentBondCount();
                            break;
                        }
                        case 69730327: {
                            n11 = ((Atom)object3).getValence();
                            break;
                        }
                        case 2621704: {
                            n11 = ((Atom)object3).getModelFileIndex() + 1;
                            break;
                        }
                        case 2621709: {
                            n11 = ((Atom)object3).getModelNumber();
                            break;
                        }
                        default: {
                            bl6 = false;
                        }
                    }
                    if (bl6) {
                        if (bl5) {
                            fArray[n2] = n11;
                            continue;
                        }
                        if (bl3) {
                            n8 = Math.min(n8, n11);
                            continue;
                        }
                        if (bl4) {
                            n7 = Math.max(n7, n11);
                            continue;
                        }
                        n6 += n11;
                        continue;
                    }
                }
                float f4 = Float.MAX_VALUE;
                switch (n) {
                    case 73990156: {
                        f4 = fArray2 == null ? 0.0f : fArray2[n2];
                        break;
                    }
                    case 69730336: {
                        f4 = ((Tuple3f)object3).x;
                        break;
                    }
                    case 69730337: {
                        f4 = ((Tuple3f)object3).y;
                        break;
                    }
                    case 69730338: {
                        f4 = ((Tuple3f)object3).z;
                        break;
                    }
                    case 69730339: {
                        f4 = ((Atom)object3).getFractionalCoord('X');
                        break;
                    }
                    case 69730340: {
                        f4 = ((Atom)object3).getFractionalCoord('Y');
                        break;
                    }
                    case 69730341: {
                        f4 = ((Atom)object3).getFractionalCoord('Z');
                        break;
                    }
                    case 69730347: {
                        f4 = this.viewer.getVibrationCoord(n2, 'x');
                        break;
                    }
                    case 69730348: {
                        f4 = this.viewer.getVibrationCoord(n2, 'y');
                        break;
                    }
                    case 69730349: {
                        f4 = this.viewer.getVibrationCoord(n2, 'z');
                        break;
                    }
                    case 23592977: {
                        if (point4f != null) {
                            f4 = Graphics3D.distanceToPlane(point4f, (Point3f)object3);
                            break;
                        }
                        f4 = ((Point3f)object3).distance(point3f);
                        break;
                    }
                    case 2686993: {
                        f4 = ((Atom)object3).getRadius();
                        break;
                    }
                    case 69730326: {
                        f4 = ((Atom)object3).getVanderwaalsRadiusFloat();
                        break;
                    }
                    case 69730342: {
                        f4 = ((Atom)object3).getPartialCharge();
                        break;
                    }
                    case 2621479: {
                        f4 = ((Atom)object3).getGroupPhi();
                        break;
                    }
                    case 0x280028: {
                        f4 = ((Atom)object3).getGroupPsi();
                        break;
                    }
                    case 2621481: {
                        this.viewer.getSurfaceDistanceMax();
                        f4 = (float)((Atom)object3).getSurfaceDistance100() / 100.0f;
                        break;
                    }
                    case 69730346: {
                        f4 = (float)((Atom)object3).getBfactor100() / 100.0f;
                        break;
                    }
                    case 73924617: {
                        point3f2.add((Tuple3f)object3);
                        break;
                    }
                    case 73924618: {
                        point3f2.add(((Atom)object3).getFractionalCoord());
                        break;
                    }
                    case 73924619: {
                        point3f2.add(this.viewer.getVibrationVector(n2));
                        break;
                    }
                    case 74126595: {
                        point3f2.add(Graphics3D.colorPointFromInt(this.viewer.getColixArgb(((Atom)object3).getColix()), point3f3));
                        break;
                    }
                    default: {
                        this.unrecognizedAtomProperty(Token.nameOf(n));
                    }
                }
                if (f4 == Float.MAX_VALUE) continue;
                if (bl5) {
                    fArray[n2] = f4;
                    continue;
                }
                if (bl3) {
                    f3 = Math.min(f3, f4);
                    continue;
                }
                if (bl4) {
                    f2 = Math.max(f2, f4);
                    continue;
                }
                f += f4;
            }
        } else {
            n9 = this.viewer.getBondCount();
            if (bl5) {
                fArray = new float[n9];
            }
            for (n2 = 0; n2 < n9; ++n2) {
                if (bitSet != null && !bitSet.get(n2)) continue;
                ++n5;
                object3 = modelSet.getBondAt(n2);
                switch (n) {
                    case 6815749: {
                        float f5 = ((Bond)object3).getAtom1().distance(((Bond)object3).getAtom2());
                        f3 = Math.min(f3, f5);
                        f2 = Math.max(f2, f5);
                        f += f5;
                        if (!bl5) break;
                        fArray[n2] = f5;
                        break;
                    }
                    case 73924617: {
                        point3f2.add(((Bond)object3).getAtom1());
                        point3f2.add(((Bond)object3).getAtom2());
                        ++n5;
                        break;
                    }
                    case 74126595: {
                        point3f2.add(Graphics3D.colorPointFromInt(this.viewer.getColixArgb(((Bond)object3).getColix()), point3f3));
                        break;
                    }
                    default: {
                        this.unrecognizedBondProperty(Token.nameOf(n));
                    }
                }
                bl6 = false;
            }
        }
        if (n == 73924617 || n == 74126595) {
            return n5 == 0 ? point3f2 : new Point3f(point3f2.x / (float)n5, point3f2.y / (float)n5, point3f2.z / (float)n5);
        }
        if (n5 == 0) {
            return new Float(Float.NaN);
        }
        if (bl3) {
            n5 = 1;
            n6 = n8;
            f = f3;
        } else if (bl4) {
            n5 = 1;
            n6 = n7;
            f = f2;
        } else if (bl5) {
            float[] fArray3 = new float[n5];
            int n16 = 0;
            for (int i = 0; i < n9; ++i) {
                if (bitSet != null && !bitSet.get(i)) continue;
                fArray3[n16++] = fArray[i];
            }
            if (object2 == null) {
                return fArray3;
            }
            return Escape.escape(fArray3);
        }
        if (bl6 && n6 / n5 * n5 == n6) {
            return new Integer(n6 / n5);
        }
        return new Float((bl6 ? (float)n6 * 1.0f : f) / (float)n5);
    }

    private void setBitsetProperty(BitSet bitSet, int n, int n2, float f, Token token) throws ScriptException {
        if (this.isSyntaxCheck || BitSetUtil.cardinalityOf(bitSet) == 0) {
            return;
        }
        switch (n) {
            case 73924617: 
            case 73924618: 
            case 73924619: {
                if (token.tok == 7) {
                    this.viewer.setAtomCoord(bitSet, n, token.value);
                    break;
                }
                if (token.tok != 6) break;
                String[] stringArray = (String[])token.value;
                int n3 = stringArray.length;
                if (n3 == 0) {
                    return;
                }
                Point3f[] point3fArray = new Point3f[n3];
                int n4 = n3;
                while (--n4 >= 0) {
                    Object object = Escape.unescapePoint(stringArray[n4]);
                    if (!(object instanceof Point3f)) {
                        this.unrecognizedParameter("ARRAY", stringArray[n4]);
                    }
                    point3fArray[n4] = (Point3f)object;
                }
                this.viewer.setAtomCoord(bitSet, n, point3fArray);
                break;
            }
            case 74126595: {
                if (token.tok == 7) {
                    n2 = Eval.colorPtToInt((Point3f)token.value);
                } else if (token.tok == 6) {
                    String[] stringArray = (String[])token.value;
                    int n5 = stringArray.length;
                    if (n5 == 0) {
                        return;
                    }
                    int[] nArray = new int[n5];
                    int n6 = n5;
                    while (--n6 >= 0) {
                        Object object = Escape.unescapePoint(stringArray[n6]);
                        nArray[n6] = object instanceof Point3f ? Eval.colorPtToInt((Point3f)object) : Graphics3D.getArgbFromString(stringArray[n6]);
                        if (nArray[n6] != 0 || (nArray[n6] = Parser.parseInt(stringArray[n6])) != Integer.MIN_VALUE) continue;
                        this.unrecognizedParameter("ARRAY", stringArray[n6]);
                    }
                    this.viewer.setShapeProperty(0, "colorValues", nArray, bitSet);
                    break;
                }
                this.viewer.setShapeProperty(0, "color", token.tok == 4 ? token.value : new Integer(n2), bitSet);
                break;
            }
            default: {
                float[] fArray = null;
                if (token.tok == 6 || token.tok == 4) {
                    String[] stringArray = token.tok == 6 ? (String[])token.value : Parser.getTokens(Token.sValue(token));
                    int n7 = stringArray.length;
                    if (n7 == 0) {
                        return;
                    }
                    fArray = new float[n7];
                    int n8 = n7;
                    while (--n8 >= 0) {
                        fArray[n8] = Parser.parseFloat(stringArray[n8]);
                    }
                }
                this.viewer.setAtomProperty(bitSet, n, n2, f, fArray);
            }
        }
    }

    private void axes(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.setShapeSize(25, 1);
            return;
        }
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.statementLength == n + 1 && Parser.isOneOf(string, "window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        if (this.statementLength == n + 2 && string.equals("scale")) {
            this.setFloatProperty("axesScale", this.floatParameter(++n));
            return;
        }
        short s = this.getSetAxesTypeMad(n);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(25, "axes", s);
        }
    }

    private void boundbox(int n) throws ScriptException {
        boolean bl = false;
        if (this.tokAt(n) == 1) {
            bl = this.parameterAsString(n).equalsIgnoreCase("corners");
        }
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            Point3f point3f = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                Point3f point3f2 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(point3f, point3f2, bl);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BitSet) {
                if (!this.isSyntaxCheck) {
                    this.viewer.calcBoundBoxDimensions((BitSet)this.expressionResult);
                }
            } else {
                this.invalidArgument();
            }
            if (n == this.statementLength) {
                return;
            }
        }
        short s = this.getSetAxesTypeMad(n);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(26, "boundbox", s);
        }
    }

    private void unitcell(int n) throws ScriptException {
        if (this.statementLength == 1) {
            if (!this.isSyntaxCheck) {
                this.viewer.setObjectMad(27, "unitcell", (short)1);
            }
            return;
        }
        if (this.statementLength == n + 1) {
            if (this.getToken((int)n).tok == 2 && this.intParameter(n) >= 111) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentUnitCellOffset(this.intParameter(n));
                }
            } else {
                short s = this.getSetAxesTypeMad(n);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectMad(27, "unitCell", s);
                }
            }
            return;
        }
        Point3f point3f = (Point3f)this.getPointOrPlane(2, false, true, false, true, 3, 3);
        if (!this.isSyntaxCheck) {
            this.viewer.setCurrentUnitCellOffset(point3f);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void setUserColors() throws ScriptException {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 2; n < this.statementLength; ++n) {
            int n2 = this.getArgbParam(n);
            vector.addElement(new Integer(n2));
            n = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = vector.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)vector.elementAt(n3);
        }
        Viewer.setUserScale(nArray);
    }

    private void setBondmode() throws ScriptException {
        this.checkLength3();
        boolean bl = false;
        switch (this.getToken((int)2).tok) {
            case 0x880020: {
                break;
            }
            case 0x880018: {
                bl = true;
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void selectionHalo(int n) throws ScriptException {
        if (n == this.statementLength) {
            this.setBooleanProperty("selectionHalos", true);
            return;
        }
        if (n + 1 < this.statementLength) {
            this.checkLength3();
        }
        boolean bl = false;
        switch (this.getToken((int)n).tok) {
            case 524305: 
            case 1572867: {
                bl = true;
            }
            case 262148: 
            case 524301: 
            case 524304: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    private void setEcho() throws ScriptException {
        int n;
        String string = "target";
        Object object = null;
        boolean bl = true;
        switch (this.getToken((int)2).tok) {
            case 524304: {
                this.checkLength3();
                bl = false;
                string = "allOff";
                break;
            }
            case 524301: {
                bl = false;
            }
            case 524303: {
                this.checkLength3();
            }
            case 1: 
            case 772: 
            case 262209: 
            case 262210: 
            case 262213: 
            case 262214: {
                object = this.parameterAsString(2);
                break;
            }
            case 2621709: {
                n = this.modelNumberParameter(this.statement[3]);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (n >= this.viewer.getModelCount()) {
                    this.invalidArgument();
                }
                string = "model";
                object = new Integer(n);
                break;
            }
            case 4: {
                this.echo(2);
                return;
            }
            default: {
                this.invalidArgument();
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(bl);
            this.viewer.loadShape(28);
            this.setShapeProperty(28, string, object);
        }
        if (this.statementLength == 3) {
            return;
        }
        string = "align";
        if (this.statementLength == 4) {
            if (this.isCenterParameter(3)) {
                this.setShapeProperty(28, "xyz", this.centerParameter(3));
                return;
            }
            switch (this.getToken((int)3).tok) {
                case 524304: {
                    string = "off";
                    break;
                }
                case 2621709: {
                    n = this.modelNumberParameter(this.statement[4]);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (n >= this.viewer.getModelCount()) {
                        this.invalidArgument();
                    }
                    string = "model";
                    object = new Integer(n);
                    break;
                }
                case 1: 
                case 772: 
                case 262209: 
                case 262210: 
                case 262213: 
                case 262214: {
                    object = this.parameterAsString(3);
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.setShapeProperty(28, string, object);
            return;
        }
        if (this.statementLength == 5) {
            switch (this.tokAt(3)) {
                case 17301771: {
                    string = "script";
                    object = this.parameterAsString(4);
                    this.setShapeProperty(28, string, object);
                    return;
                }
                case 2621709: {
                    n = this.modelNumberParameter(this.statement[4]);
                    if (!this.isSyntaxCheck && n >= this.viewer.getModelCount()) {
                        this.invalidArgument();
                    }
                    string = "model";
                    object = new Integer(n);
                    this.setShapeProperty(28, string, object);
                    return;
                }
            }
        }
        this.getToken(4);
        n = 3;
        if (this.isCenterParameter(n)) {
            if (!this.isSyntaxCheck) {
                this.setShapeProperty(28, "xyz", this.centerParameter(n));
            }
            return;
        }
        int n2 = this.intParameter(n++);
        object = new Integer(n2);
        String string2 = this.tokAt(n) == 8912962 ? "%xpos" : "xpos";
        this.setShapeProperty(28, string2, object);
        int n3 = ++n;
        n2 = this.intParameter(n3);
        object = new Integer(n2);
        if (this.tokAt(++n) == 8912962) {
            string2 = "%ypos";
            ++n;
        } else {
            string2 = "ypos";
        }
        this.setShapeProperty(28, string2, object);
    }

    private boolean setLabel(String string) throws ScriptException {
        int n;
        this.viewer.loadShape(4);
        Object object = null;
        this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("offset")) {
            n = this.intParameter(2);
            int n2 = this.intParameter(3);
            if (n > 100 || n2 > 100 || n < -100 || n2 < -100) {
                this.numberOutOfRange(-100, 100);
            }
            object = new Integer((n & 0xFF) << 8 | n2 & 0xFF);
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 772: 
                case 262209: 
                case 262210: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.invalidArgument();
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            n = 0;
            switch (this.getToken((int)2).tok) {
                case 524301: 
                case 524304: {
                    break;
                }
                case 196865: {
                    n |= 2;
                }
                case 524305: {
                    n |= 1;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            object = new Integer(n);
        } else {
            if (string.equals("toggle")) {
                this.iToken = 1;
                BitSet bitSet = this.statementLength == 2 ? null : this.expression(2);
                this.checkStatementLength(this.iToken + 1);
                if (!this.isSyntaxCheck) {
                    this.viewer.togglePickingLabel(bitSet);
                }
                return true;
            }
            this.iToken = 1;
            int n3 = n = this.statementLength == 2 || this.getToken((int)2).tok == 524305 ? 1 : 0;
            if (string.equals("front") || string.equals("group")) {
                if (n == 0 && this.tokAt(2) != 524304) {
                    this.invalidArgument();
                }
                if (n == 0) {
                    string = "front";
                }
                object = n != 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (n == 0 && this.tokAt(2) != 524304) {
                    this.invalidArgument();
                }
                string = "front";
                object = n != 0 ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
        this.checkStatementLength(this.iToken + 1);
        if (this.isSyntaxCheck) {
            return true;
        }
        if (bitSet != null) {
            this.viewer.setShapeProperty(4, string, object, bitSet);
        } else {
            this.setShapeProperty(4, string, object);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        boolean bl = false;
        this.checkLength3();
        switch (this.tokAt(2)) {
            case 524305: {
                bl = true;
            }
            case 524304: {
                this.setShapeProperty(5, "showMeasurementNumbers", bl ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                this.setMeasurementUnits(this.parameterAsString(2));
                return;
            }
        }
        this.setShapeSize(5, this.getSetAxesTypeMad(2));
    }

    private void setMeasurementUnits(String string) throws ScriptException {
        if (!StateManager.isMeasurementUnit(string)) {
            this.unrecognizedParameter("set measurementUnits ", string);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setMeasureDistanceUnits(string);
        }
    }

    private void setProperty() throws ScriptException {
        this.checkLength4();
        if (this.getToken((int)2).tok != 1) {
            this.propertyNameExpected();
        }
        String string = this.parameterAsString(2);
        switch (this.getToken((int)3).tok) {
            case 524305: {
                this.setBooleanProperty(string, true);
                break;
            }
            case 524304: {
                this.setBooleanProperty(string, false);
                break;
            }
            case 2: {
                this.setIntProperty(string, this.intParameter(3));
                break;
            }
            case 3: {
                this.setFloatProperty(string, this.floatParameter(3));
                break;
            }
            case 4: {
                this.setStringProperty(string, this.stringParameter(3));
                break;
            }
            default: {
                this.unrecognizedParameter("SET " + string.toUpperCase(), this.parameterAsString(3));
            }
        }
    }

    private void setSpin(String string, int n) throws ScriptException {
        if (Parser.isOneOf(string = string.toLowerCase(), "x;y;z;fps")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setSpin(string, n);
            }
            return;
        }
        this.unrecognizedParameter("set SPIN ", this.parameterAsString(2));
    }

    private void setSsbond() throws ScriptException {
        this.checkLength3();
        boolean bl = false;
        switch (this.tokAt(2)) {
            case 0x180100: {
                bl = true;
                break;
            }
            case 1572869: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        this.checkLength3();
        boolean bl = false;
        switch (this.tokAt(2)) {
            case 0x180100: {
                bl = true;
            }
            case 1572869: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 262189: {
                bl = true;
            }
            case 262174: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "ident");
            return;
        }
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 798: 
            case 70976: 
            case 591122: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                string = this.parameterAsString(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            default: {
                this.checkLength3();
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 262148: 
            case 524305: {
                string2 = "ident";
                break;
            }
            case 524301: {
                string2 = "off";
                break;
            }
            case 798: {
                string2 = "atom";
                break;
            }
            case 6881282: {
                string2 = "bond";
            }
        }
        if (JmolConstants.getPickingMode(string2) < 0) {
            this.unrecognizedParameter("SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 591122: {
                bl = true;
                string = "MEASURE";
            }
            case 798: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength3();
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 524301: 
            case 524304: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 524305: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (JmolConstants.getPickingStyle(string2) < 0) {
            this.unrecognizedParameter("SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void save() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 262223: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 6881282: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 262224: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 2622740: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.evalError(GT._("save what?") + " bonds? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 262223) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 262223: {
                    float f;
                    float f2 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.invalidArgument();
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(string, f);
                    }
                    return;
                }
                case 6881282: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 262224: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string2 = this.viewer.getSavedState(string);
                    if (string2 == null) {
                        this.invalidArgument();
                    }
                    this.runScript(string2);
                    return;
                }
                case 2622740: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string3 = this.viewer.getSavedStructure(string);
                    if (string3 == null) {
                        this.invalidArgument();
                    }
                    this.runScript(string3);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.evalError(GT._("restore what?") + " bonds? orientation? selection? state? structure?");
    }

    private void write() throws ScriptException {
        boolean bl;
        int n = 1;
        boolean bl2 = this.viewer.isApplet();
        String string = this.viewer.getExportDriverList();
        int n2 = this.statementLength == 1 ? 262146 : this.tokAt(n);
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        String string2 = "SPT";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n6 = Integer.MIN_VALUE;
        switch (n2) {
            case 373: {
                string4 = this.optParameterAsString(++n).toLowerCase();
                if (Parser.isOneOf(string4, "w;x;y;z")) {
                    ++n;
                } else {
                    string4 = "w";
                }
                string4 = "quaternion " + string4;
                string2 = this.optParameterAsString(n);
                if (string2.indexOf("deriv") == 0) {
                    string4 = string4 + " derivative";
                    ++n;
                }
                string2 = "QUAT";
                break;
            }
            case 374: {
                string2 = "RAMA";
                string4 = "ramachandran";
                ++n;
                break;
            }
            case 17326337: {
                string2 = "FUNCS";
                ++n;
                break;
            }
            case 524300: 
            case 17301778: {
                string2 = this.optParameterAsString(n + 1).toLowerCase();
                string2 = "data";
                bl3 = true;
                ++n;
                break;
            }
            case 262224: 
            case 17301771: {
                ++n;
                break;
            }
            case 135523: {
                string2 = "MO";
                ++n;
                break;
            }
            case 136542: {
                string2 = "ISO";
                ++n;
                break;
            }
            case 65898: {
                string2 = "HIS";
                ++n;
                break;
            }
            case 111994: {
                n += 2;
                string2 = "VAR";
                break;
            }
            case 2621704: {
                string2 = "FILE";
                ++n;
                break;
            }
            case 1: {
                string2 = this.parameterAsString(1).toLowerCase();
                if (string2.equals("image")) {
                    if (this.tokAt(++n) != 2) break;
                    n4 = this.intParameter(n++);
                    n5 = this.intParameter(n++);
                    break;
                }
                if (Parser.isOneOf(string2, string.toLowerCase())) {
                    string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                    bl5 = true;
                    string5 = "Jmol." + string2;
                    if (this.tokAt(++n) != 2) break;
                    n4 = this.intParameter(n++);
                    n5 = this.intParameter(n++);
                    break;
                }
                string2 = "(image)";
            }
        }
        String string6 = this.optParameterAsString(n);
        if (string6.equalsIgnoreCase("clipboard")) {
            if (this.isSyntaxCheck) {
                return;
            }
        } else if (Parser.isOneOf(string6.toLowerCase(), "png;jpg;jpeg;jpg64") && this.tokAt(n + 1) == 2) {
            n6 = this.intParameter(++n);
        } else if (Parser.isOneOf(string6.toLowerCase(), "xyz;mol;pdb")) {
            string2 = string6.toUpperCase();
            if (n + 1 == this.statementLength) {
                ++n;
            }
        }
        if (string2.equals("(image)") && Parser.isOneOf(string6.toUpperCase(), "JPG;JPG64;JPEG;JPEG64;PNG;PPM")) {
            string2 = string6.toUpperCase();
            ++n;
        }
        if (n + 2 == this.statementLength && (string3 = this.parameterAsString(++n)).charAt(0) != '.') {
            string2 = string6.toUpperCase();
        }
        switch (this.tokAt(n)) {
            case 0: {
                bl4 = true;
                break;
            }
            case 1: 
            case 4: {
                string5 = this.parameterAsString(n);
                if (n == this.statementLength - 3 && this.tokAt(n + 1) == 524289) {
                    string5 = string5 + "." + this.parameterAsString(n + 2);
                }
                if (string2 != "VAR" && n == 1) {
                    string2 = "image";
                } else if (string5.charAt(0) == '.' && (n == 2 || n == 3)) {
                    string5 = this.parameterAsString(n - 1) + string5;
                    if (string2 != "VAR" && n == 2) {
                        string2 = "image";
                    }
                }
                if (!string5.equalsIgnoreCase("clipboard")) break;
                string5 = null;
                break;
            }
            case 262146: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        if (string2.equals("image")) {
            string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "JPG";
        }
        if (string2.equals("data")) {
            string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
        }
        if ((bl = Parser.isOneOf(string2, "JPEG;JPG64;JPG;PPM;PNG")) && (bl2 || bl4)) {
            string2 = "JPG64";
        }
        if (!(bl || bl5 || Parser.isOneOf(string2, "SPT;HIS;MO;ISO;VAR;FILE;XYZ;MOL;PDB;QUAT;RAMA;FUNCS;"))) {
            this.evalError(GT._("write what? {0} or {1} \"filename\"", new Object[]{"COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|ISOSURFACE|MO|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|STATE|VAR x  CLIPBOARD", "JPG|JPG64|PNG|PPM|SPT|JVXL|XYZ|MOL|PDB|" + string.toUpperCase().replace(';', '|')}));
        }
        if (this.isSyntaxCheck) {
            return;
        }
        string3 = string2.intern();
        Object object = null;
        if (bl5) {
            boolean bl6 = string2.equals("Povray");
            string3 = this.viewer.generateOutput(string3, bl6 ? string5 : null, n4, n5);
            if (bl6) {
                string3 = TextFormat.simpleReplace(string3, "%FILETYPE%", "N");
                string3 = TextFormat.simpleReplace(string3, "%OUTPUTFILENAME%", string5 + ".png");
                this.viewer.createImage(string5 + ".ini", string3, Integer.MIN_VALUE, 0, 0);
                this.scriptStatus("Created " + string5 + ".ini:\n\n" + string3);
                return;
            }
        } else if (string3 == "PDB" || string3 == "XYZ" || string3 == "MOL") {
            string3 = this.viewer.getData("selected", string3);
        } else if (string3 == "QUAT" || string3 == "RAMA") {
            int n7 = this.viewer.getCurrentModelIndex();
            if (n7 < 0) {
                this.multipleModelsNotOK("write " + string4);
            }
            string3 = this.viewer.getPdbData(n7, string4);
        } else if (string3 == "FUNCS") {
            string3 = this.getFunctionCalls("");
        } else if (string3 == "FILE") {
            if (bl4) {
                string3 = this.viewer.getCurrentFileAsString();
            } else {
                object = this.viewer.getCurrentFileAsBytes();
            }
            n6 = Integer.MIN_VALUE;
        } else if (string3 == "VAR") {
            string3 = "" + this.getParameter(this.parameterAsString(2), false);
        } else if (string3 == "SPT") {
            if (bl3) {
                BitSet bitSet = this.viewer.getTaintedAtoms((byte)0);
                this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f));
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                this.viewer.setTaintedAtoms(bitSet, (byte)0);
            } else {
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
            }
        } else if (string3 == "HIS") {
            string3 = this.viewer.getSetHistory(Integer.MAX_VALUE);
        } else if (string3 == "MO") {
            string3 = this.getMoJvxl(Integer.MAX_VALUE);
        } else if (string3 == "ISO") {
            string3 = this.getIsosurfaceJvxl();
            if (string3 == null) {
                this.evalError(GT._("No data available"));
            }
        } else {
            n3 = -1;
            if (string3 == "PNG") {
                if (n6 == Integer.MIN_VALUE) {
                    n6 = 2;
                } else if (n6 < 0 || n6 > 9) {
                    n6 = 0;
                }
            } else if (n6 <= 0) {
                n6 = 75;
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        if (n3 == 0) {
            int n8 = object == null ? string3.length() : (n3 = object instanceof String ? ((String)object).length() : ((byte[])object).length);
        }
        if (bl) {
            this.refresh();
            if (n4 < 0) {
                n4 = this.viewer.getScreenWidth();
            }
            if (n5 < 0) {
                n5 = this.viewer.getScreenHeight();
            }
        }
        if (bl4) {
            this.showString(string3);
        } else if (object != null && object instanceof String) {
            this.scriptStatus((String)object);
        } else {
            if (object == null) {
                object = string3;
            }
            this.viewer.createImage(string5, object, n6, n4, n5);
            this.scriptStatus("type=" + string2 + "; file=" + (string5 == null ? "CLIPBOARD" : string5) + (n3 >= 0 ? "; length=" + n3 : "") + (bl ? "; width=" + n4 + "; height=" + n5 : "") + (n6 >= 0 ? "; quality=" + n6 : ""));
        }
    }

    private void print() throws ScriptException {
        if (this.statementLength == 1) {
            this.badArgumentCount();
        }
        String string = (String)this.parameterExpression(1, 0, "", false);
        if (!this.isSyntaxCheck) {
            this.showString(string);
        }
    }

    private void returnCmd() throws ScriptException {
        Object object;
        Token token = this.getContextVariableAsToken("_retval");
        if (token == null) {
            if (!this.isSyntaxCheck) {
                this.interruptExecution = Boolean.TRUE;
            }
            return;
        }
        Object object2 = object = this.statementLength == 1 ? null : this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        Token token2 = object == null ? Token.intToken(0) : (Token)((Vector)object).get(0);
        token.value = token2.value;
        token.intValue = token2.intValue;
        token.tok = token2.tok;
        this.pcEnd = this.pc;
    }

    private void show() throws ScriptException {
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        int n = 2;
        if (this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        block0 : switch (this.getToken((int)1).tok) {
            case 17326337: {
                this.checkLength23();
                if (!this.isSyntaxCheck) {
                    this.showString(this.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 169247: {
                this.checkLength2();
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 262221: {
                n = this.statementLength;
                if (n == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                String string4 = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 65548: 
            case 74126595: {
                string2 = "defaultColorScheme";
                break;
            }
            case 65565: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 373: 
            case 374: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n2 = this.viewer.getCurrentModelIndex();
                if (n2 < 0) {
                    this.multipleModelsNotOK("show " + this.theToken.value);
                }
                string3 = this.viewer.getPdbData(n2, this.theTok == 373 ? "quaternion w" : "ramachandran");
                break;
            }
            case 1: {
                if (string2.equalsIgnoreCase("historyLevel")) {
                    string = "" + this.commandHistoryLevelMax;
                    break;
                }
                if (string2.equalsIgnoreCase("defaultLattice")) {
                    string = Escape.escape(this.viewer.getDefaultLattice());
                    break;
                }
                if (string2.equalsIgnoreCase("logLevel")) {
                    string = "" + Viewer.getLogLevel();
                    break;
                }
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (string2.equalsIgnoreCase("debugScript")) {
                    string = "" + this.viewer.getDebugScript();
                    break;
                }
                if (string2.equalsIgnoreCase("colorScheme")) {
                    String string5 = this.optParameterAsString(2);
                    if (string5.length() > 0) {
                        n = 3;
                    }
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getColorSchemeList(string5, true);
                    break;
                }
                if (string2.equalsIgnoreCase("menu")) {
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getMenu();
                    break;
                }
                if (string2.equalsIgnoreCase("strandCount")) {
                    string3 = "set strandCountForStrands " + this.viewer.getStrandCount(10) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(11);
                    break;
                }
                if (!string2.equalsIgnoreCase("trajectory") && !string2.equalsIgnoreCase("trajectories")) break;
                string3 = this.viewer.getTrajectoryInfo();
                break;
            }
            case 65901: {
                switch (this.viewer.getAxesMode()) {
                    case 2: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case 0: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 65537: {
                string3 = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 65831: {
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(10) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(11);
                break;
            }
            case 590093: {
                string3 = "set hbondsBackbone " + this.viewer.getHbondsBackbone() + ";set hbondsSolid " + this.viewer.getHbondsSolid();
                break;
            }
            case 70976: {
                string3 = this.viewer.getSpinState();
                break;
            }
            case 65828: {
                string3 = "set ssbondsBackbone " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 65897: 
            case 66411: {
                string3 = "selectionHalos " + (this.viewer.getSelectionHaloEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x190001: {
                string3 = "set selectHetero " + this.viewer.getRasmolHeteroSetting();
                break;
            }
            case 1638402: {
                string3 = "set selectHydrogens " + this.viewer.getRasmolHydrogenSetting();
                break;
            }
            case 65536: 
            case 65543: 
            case 65545: 
            case 65546: 
            case 65567: {
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 284: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 1638767: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 262224: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedState(string6);
                break;
            }
            case 2622740: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStructureState();
                    break;
                }
                String string7 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedStructure(string7);
                break;
            }
            case 17301778: {
                Object[] objectArray;
                String string8;
                n = this.statementLength;
                String string9 = string8 = n == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] objectArray2 = objectArray = string8 == null ? this.data : this.viewer.getData(string8);
                string3 = objectArray == null ? "no data" : "data \"" + objectArray[0] + "\"\n" + (objectArray[1] instanceof float[] ? Escape.escape((float[])objectArray[1]) : "" + objectArray[1]);
                break;
            }
            case 262147: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getSpaceGroupInfoText(null);
                    break;
                }
                String string10 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpaceGroupInfoText(TextFormat.simpleReplace(string10, "''", "\""));
                break;
            }
            case 524293: {
                n = 3;
                int n3 = this.setShapeByNameParameter(2);
                if (this.isSyntaxCheck) break;
                if (n3 == 21) {
                    string3 = this.getIsosurfaceJvxl();
                    break;
                }
                string3 = (String)this.viewer.getShapeProperty(n3, "command");
                break;
            }
            case 6886669: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 772: {
                if (this.isSyntaxCheck) break;
                string3 = "center " + Escape.escape(this.viewer.getRotationCenter());
                break;
            }
            case 136543: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(20, "command");
                break;
            }
            case 2621704: {
                if (this.statementLength == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCurrentFileAsString();
                    break;
                }
                n = 3;
                string = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 324: {
                if (this.tokAt(2) == 524303) {
                    n = 3;
                    if (3 > 0) {
                        string3 = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                string3 = this.viewer.getModelFileInfo();
                break;
            }
            case 65898: {
                int n4;
                n = this.statementLength;
                int n5 = n4 = n == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n4 < 1) {
                    this.invalidArgument();
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                string3 = this.viewer.getSetHistory(n4);
                break;
            }
            case 136542: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(21, "jvxlFileData");
                break;
            }
            case 135523: {
                int n6;
                n = this.statementLength;
                int n7 = n6 = n == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                string3 = this.getMoJvxl(n6);
                break;
            }
            case 2621709: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 591122: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 262223: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getOrientationText();
                break;
            }
            case 262225: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 1572886: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 262222: {
                if (this.isSyntaxCheck) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 5423: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomPercentFloat() : "off");
                break;
            }
            case 65904: {
                string3 = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 2686993: {
                string2 = "solventProbeRadius";
                break;
            }
            case 262218: 
            case 262219: {
                this.unrecognizedShowParameter("show ORIENTATION");
            }
            case 262220: 
            case 524296: 
            case 524297: 
            case 524298: {
                this.unrecognizedShowParameter("getProperty CHAININFO (atom expression)");
            }
            case 1572867: {
                this.unrecognizedShowParameter("getProperty ATOMINFO (selected)");
            }
            case 6815745: {
                this.unrecognizedShowParameter("getProperty ATOMINFO (atom expression)");
            }
            case 2318: 
            case 65538: 
            case 67851: 
            case 1638404: 
            case 6881282: 
            case 73990156: {
                string = "?";
            }
        }
        this.checkStatementLength(n);
        if (this.isSyntaxCheck) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            this.showString(string2 + " = " + this.getParameterEscaped(string2));
        }
    }

    private void showString(String string) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
        } else {
            this.viewer.showString(string);
        }
    }

    private String getFunctionCalls(String string) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("*");
        boolean bl2 = n >= 0;
        boolean bl3 = bl = string.indexOf("_") == 0;
        if (bl2) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase();
        Hashtable hashtable = bl ? this.compiler.localFunctions : Compiler.globalFunctions;
        Object[] objectArray = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string) && (!bl2 || string2.toLowerCase().indexOf(string) != 0)) continue;
            objectArray[n2++] = string2;
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(((Function)hashtable.get(objectArray[i])).toString());
        }
        return stringBuffer.toString();
    }

    private String getIsosurfaceJvxl() {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.viewer.getShapeProperty(21, "jvxlFileData");
    }

    private String getMoJvxl(int n) throws ScriptException {
        Hashtable hashtable;
        this.viewer.loadShape(23);
        int n2 = this.viewer.getDisplayModelIndex();
        if (n2 < 0) {
            this.multipleModelsNotOK("MO isosurfaces");
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n2, "moData")) == null) {
            this.evalError(GT._("no MO basis/coefficient data available for this frame"));
        }
        this.setShapeProperty(23, "moData", hashtable);
        return (String)this.viewer.getShapeProperty(23, "showMO", n);
    }

    /*
     * Unable to fully structure code
     */
    private void pmesh() throws ScriptException {
        this.viewer.loadShape(24);
        if (this.tokAt(1) == 6 && this.listIsosurface(24)) {
            return;
        }
        var2_1 = false;
        var3_2 = null;
        this.initIsosurface(24);
        block6: for (var4_3 = this.iToken; var4_3 < this.statementLength; ++var4_3) {
            var5_6 = null;
            var6_7 = null;
            switch (this.getToken((int)var4_3).tok) {
                case 1: {
                    var7_8 = this.parameterAsString(var4_3);
                    if (var7_8.equalsIgnoreCase("FIXED")) {
                        var5_6 = "fixed";
                        var6_7 = Boolean.TRUE;
                        break;
                    }
                    if (var7_8.equalsIgnoreCase("MODELBASED")) {
                        var5_6 = "fixed";
                        var6_7 = Boolean.FALSE;
                        break;
                    }
                    if (var2_1) {
                        this.invalidArgument();
                    }
                    var5_6 = "thisID";
                    var6_7 = var7_8;
                    break;
                }
                case 2621709: {
                    var8_9 = this.modelNumberParameter(this.statement[++var4_3]);
                    if (var8_9 < 0) {
                        var5_6 = "fixed";
                        var6_7 = Boolean.TRUE;
                        break;
                    }
                    var5_6 = "modelIndex";
                    var6_7 = new Integer(var8_9);
                    break;
                }
                case 74126595: {
                    var3_2 = this.setColorOptions(var4_3 + 1, 24, -1);
                    var4_3 = this.iToken;
                    var2_1 = true;
                    continue block6;
                }
                case 4: {
                    var9_10 = this.stringParameter(var4_3);
                    var5_6 = "bufferedReader";
                    if (!var9_10.equalsIgnoreCase("inline")) ** GOTO lbl56
                    if (var4_3 + 1 < this.statementLength && this.tokAt(var4_3 + 1) == 4) {
                        if ((var10_11 = this.parameterAsString(++var4_3)).indexOf("|") < 0 && var10_11.indexOf("\n") < 0) {
                            var10_11 = var10_11.replace(' ', '\n');
                            var5_6 = "bufferedReaderOnePerLine";
                        }
                        var10_11 = var10_11.replace('{', ' ').replace(',', ' ').replace('}', ' ').replace('|', '\n');
                        var10_11 = TextFormat.simpleReplace((String)var10_11, "\n\n", "\n");
                        if (this.logMessages) {
                            Logger.debug("pmesh inline data:\n" + (String)var10_11);
                        }
                        var1_5 = this.viewer.getBufferedReaderForString((String)var10_11);
                    } else {
                        this.stringOrIdentifierExpected();
                        break;
lbl56:
                        // 1 sources

                        if (this.isSyntaxCheck) {
                            return;
                        }
                        if (this.thisCommand.indexOf("# FILE0=") >= 0) {
                            var9_10 = this.extractCommandOption("FILE0");
                        }
                        if ((var1_5 = this.viewer.getBufferedReaderOrErrorMessageFromName(var9_10, (String[])(var10_11 = new String[1]))) instanceof String) {
                            this.fileNotFoundException(var9_10 + ":" + var1_5);
                        }
                        this.setShapeProperty(24, "commandOption", "FILE0=" + Escape.escape((String)var10_11[0]));
                        Logger.info("reading pmesh data from " + (String)var10_11[0]);
                    }
                    var6_7 = var1_5;
                    break;
                }
                default: {
                    if (!this.setMeshDisplayProperty(24, var4_3, this.theTok)) {
                        this.invalidArgument();
                    }
                    var4_3 = this.iToken;
                }
            }
            v0 = var2_1 = this.theTok != 262186;
            if (var5_6 == null) continue;
            this.setShapeProperty(24, var5_6, var6_7);
        }
        if (!this.isSyntaxCheck && (var4_4 = (String)this.viewer.getShapeProperty(24, "pmeshError")) != null) {
            this.evalError(var4_4);
        }
        if (var3_2 != null) {
            this.setShapeProperty(24, "translucency", var3_2);
        }
    }

    private String extractCommandOption(String string) {
        int n = this.thisCommand.indexOf(string + "=");
        return n < 0 ? string : Parser.getNextQuotedString(this.thisCommand, n);
    }

    private void draw() throws ScriptException {
        this.viewer.loadShape(20);
        if (this.tokAt(1) == 6 && this.listIsosurface(20)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        boolean bl5 = false;
        int n3 = 0;
        this.initIsosurface(20);
        block19: for (int i = this.iToken; i < this.statementLength; ++i) {
            String string = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 4: {
                    object = this.stringParameter(i);
                    string = "title";
                    break;
                }
                case 6815749: {
                    object = new Float(this.floatParameter(++i));
                    string = "length";
                    break;
                }
                case 3: {
                    object = new Float(this.floatParameter(i));
                    string = "length";
                    break;
                }
                case 2: {
                    if (bl3) {
                        string = "modelIndex";
                        object = new Integer(this.intParameter(i));
                        break;
                    }
                    n2 = this.intParameter(i);
                    break;
                }
                case 0x880010: 
                case 0x880011: {
                    bl3 = !bl3;
                    if (bl3 != (this.theTok == 0x880011)) break;
                    this.invalidArgument();
                    break;
                }
                case 17303586: {
                    string = "plane";
                    break;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("FIXED")) {
                        string = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("MODELBASED")) {
                        string = "fixed";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("CROSSED")) {
                        string = "crossed";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CURVE")) {
                        string = "curve";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ARROW")) {
                        string = "arrow";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CIRCLE")) {
                        string = "circle";
                        break;
                    }
                    if (string2.equalsIgnoreCase("VERTICES")) {
                        string = "vertices";
                        break;
                    }
                    if (string2.equalsIgnoreCase("REVERSE")) {
                        string = "reverse";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ROTATE45")) {
                        string = "rotate45";
                        break;
                    }
                    if (string2.equalsIgnoreCase("PERP") || string2.equalsIgnoreCase("PERPENDICULAR")) {
                        string = "perp";
                        break;
                    }
                    if (string2.equalsIgnoreCase("OFFSET")) {
                        Point3f point3f = this.getPoint3f(++i, true);
                        i = this.iToken;
                        string = "offset";
                        object = point3f;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SCALE")) {
                        if (++i >= this.statementLength) {
                            this.numberExpected();
                        }
                        switch (this.getToken((int)i).tok) {
                            case 2: {
                                n2 = this.intParameter(i);
                                continue block19;
                            }
                            case 3: {
                                n2 = (int)(this.floatParameter(i) * 100.0f);
                                continue block19;
                            }
                            default: {
                                this.numberExpected();
                            }
                        }
                    }
                    if (string2.equalsIgnoreCase("DIAMETER")) {
                        object = new Float(this.floatParameter(++i));
                        string = this.tokAt(i) == 3 ? "width" : "diameter";
                        break;
                    }
                    if (string2.equalsIgnoreCase("WIDTH")) {
                        object = new Float(this.floatParameter(++i));
                        string = "width";
                        break;
                    }
                    if (bl5) {
                        this.invalidArgument();
                    }
                    string = "thisID";
                    object = string2;
                    break;
                }
                case 524293: {
                    if (this.tokAt(i + 2) == 0x880010) {
                        Point3f point3f = this.centerParameter(i);
                        i = this.iToken;
                        string = "coord";
                        object = point3f;
                        bl = true;
                        break;
                    }
                    object = this.objectNameParameter(++i);
                    string = "identifier";
                    bl = true;
                    break;
                }
                case 74126595: {
                    ++i;
                }
                case 262184: 
                case 262185: {
                    bl4 = false;
                    boolean bl6 = false;
                    if (this.tokAt(i) == 262185) {
                        bl4 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.floatParameter(i++);
                        }
                        bl6 = true;
                    } else if (this.tokAt(i) == 262184) {
                        ++i;
                        bl6 = true;
                    }
                    if (this.isColorParam(i)) {
                        n = this.getArgbParam(i);
                        i = this.iToken;
                        bl6 = true;
                    }
                    if (!bl6) {
                        this.invalidArgument();
                    }
                    bl5 = true;
                    continue block19;
                }
                case 7: 
                case 524291: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = "coord";
                    object = point3f;
                    bl = true;
                    break;
                }
                case 262215: 
                case 524388: {
                    string = "atomSet";
                    object = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 6: {
                    string = "modelBasedPoints";
                    object = this.theToken.value;
                    bl = true;
                    break;
                }
                default: {
                    if (n3 == 0) {
                        n3 = i;
                    }
                    if (this.setMeshDisplayProperty(20, 0, this.theTok)) continue block19;
                    this.invalidArgument();
                    continue block19;
                }
            }
            boolean bl7 = bl5 = this.theTok != 262186;
            if (bl && !bl2) {
                this.setShapeProperty(20, "points", new Integer(n2));
                bl2 = true;
                n2 = 0;
            }
            if (string == null) continue;
            this.setShapeProperty(20, string, object);
        }
        if (bl) {
            this.setShapeProperty(20, "set", null);
        }
        if (n != Integer.MIN_VALUE) {
            this.setShapeProperty(20, "color", new Integer(n));
        }
        if (bl4) {
            this.setShapeTranslucency(20, "", "translucent", f);
        }
        if (n2 != 0) {
            this.setShapeProperty(20, "scale", new Integer(n2));
        }
        if (n3 > 0 && !this.setMeshDisplayProperty(20, n3, this.getToken((int)n3).tok)) {
            this.invalidArgument();
        }
    }

    private void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        this.viewer.loadShape(19);
        this.setShapeProperty(19, "init", null);
        String string = "centers";
        String string2 = "radius_";
        boolean bl6 = false;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        block12: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                n2 = this.getArgbParam(i);
                i = this.iToken;
                continue;
            }
            String string3 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 0x880008: 
                case 42467380: {
                    continue block12;
                }
                case 6881282: {
                    if (n > 0) {
                        this.invalidParameterOrder();
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 2686993: {
                    string2 = "radius";
                    continue block12;
                }
                case 74126595: {
                    ++i;
                }
                case 262184: 
                case 262185: {
                    bl6 = false;
                    boolean bl7 = false;
                    if (this.tokAt(i) == 262185) {
                        bl6 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.floatParameter(i++);
                        }
                        bl7 = true;
                    } else if (this.tokAt(i) == 262184) {
                        ++i;
                        bl7 = true;
                    }
                    if (this.isColorParam(i)) {
                        n2 = this.getArgbParam(i);
                        i = this.iToken;
                        bl7 = true;
                    }
                    if (bl7) continue block12;
                    this.invalidArgument();
                    continue block12;
                }
                case 1: {
                    String string4 = this.parameterAsString(i);
                    if ("collapsed".equalsIgnoreCase(string4)) {
                        string3 = "collapsed";
                        object = Boolean.TRUE;
                        if (bl3) {
                            this.incompatibleArguments();
                        }
                        bl3 = true;
                        break;
                    }
                    if ("flat".equalsIgnoreCase(string4)) {
                        string3 = "collapsed";
                        object = Boolean.FALSE;
                        if (bl3) {
                            this.incompatibleArguments();
                        }
                        bl3 = true;
                        break;
                    }
                    if ("edges".equalsIgnoreCase(string4) || "noedges".equalsIgnoreCase(string4) || "frontedges".equalsIgnoreCase(string4)) {
                        if (bl4) {
                            this.incompatibleArguments();
                        }
                        string3 = string4;
                        bl4 = true;
                        break;
                    }
                    if (!bl) {
                        this.insufficientArguments();
                    }
                    if ("to".equalsIgnoreCase(string4)) {
                        if (n > 1) {
                            this.invalidParameterOrder();
                        }
                        if (this.getToken((int)(i + 1)).tok == 262215) {
                            string3 = "toBitSet";
                            object = this.getToken((int)(++i)).value;
                            bl = true;
                            break;
                        }
                        string = "to";
                        continue block12;
                    }
                    if ("faceCenterOffset".equalsIgnoreCase(string4)) {
                        string2 = "faceCenterOffset";
                        bl5 = true;
                        continue block12;
                    }
                    if ("distanceFactor".equalsIgnoreCase(string4)) {
                        string2 = "distanceFactor";
                        bl5 = true;
                        continue block12;
                    }
                    this.invalidArgument();
                }
                case 2: {
                    if (n > 0 && !bl5) {
                        this.invalidParameterOrder();
                    }
                    if (string2 == "radius_") {
                        string3 = "nVertices";
                        object = new Integer(this.intParameter(i));
                        bl = true;
                        break;
                    }
                }
                case 3: {
                    if (n > 0 && !bl5) {
                        this.invalidParameterOrder();
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = new Float(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 262186: 
                case 524304: 
                case 524305: {
                    if (i + 1 != this.statementLength || bl || n > 1 || n == 0 && string == "to") {
                        this.incompatibleArguments();
                    }
                    string3 = this.parameterAsString(i);
                    bl2 = true;
                    break;
                }
                case 262215: 
                case 524388: {
                    if (bl3) {
                        this.invalidParameterOrder();
                    }
                    if (++n > 2) {
                        this.badArgumentCount();
                    }
                    if (string == "to") {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.expression(i);
                    i = this.iToken;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.setShapeProperty(19, string3, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4)) {
            this.insufficientArguments();
        }
        if (bl) {
            this.setShapeProperty(19, "generate", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(19, "colorThis", new Integer(n2));
        }
        if (bl6) {
            this.setShapeTranslucency(19, "", "translucent", f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(22);
        if (this.tokAt(1) == 6 && this.listIsosurface(22)) {
            return;
        }
        this.setShapeProperty(22, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(22, "lcaoID", null);
            return;
        }
        boolean bl = false;
        String string = null;
        int n = 1;
        while (true) {
            block33: {
                if (n >= this.statementLength) {
                    this.setShapeProperty(22, "clear", null);
                    return;
                }
                String string2 = null;
                Object object = null;
                switch (this.getToken((int)n).tok) {
                    case 772: {
                        this.isosurface(22);
                        return;
                    }
                    case 5403: {
                        String string3;
                        Vector3f vector3f = new Vector3f();
                        switch (this.getToken((int)(++n)).tok) {
                            case 1: {
                                string3 = this.parameterAsString(n);
                                float f = this.floatParameter(++n) * ((float)Math.PI / 180);
                                if (string3.equalsIgnoreCase("x")) {
                                    vector3f.set(f, 0.0f, 0.0f);
                                    break;
                                }
                                if (string3.equalsIgnoreCase("y")) {
                                    vector3f.set(0.0f, f, 0.0f);
                                    break;
                                }
                                if (string3.equalsIgnoreCase("z")) {
                                    vector3f.set(0.0f, 0.0f, f);
                                    break;
                                }
                                this.invalidArgument();
                            }
                            default: {
                                this.invalidArgument();
                            }
                        }
                        string2 = "rotationAxis";
                        object = vector3f;
                        break;
                    }
                    case 524305: {
                        string2 = "on";
                        break;
                    }
                    case 524304: {
                        string2 = "off";
                        break;
                    }
                    case 262186: {
                        string2 = "delete";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string2 = "scale";
                        object = new Float(this.floatParameter(++n));
                        break;
                    }
                    case 262215: 
                    case 524388: {
                        string2 = "select";
                        object = this.expression(n);
                        n = this.iToken;
                        break;
                    }
                    case 74126595: {
                        string = this.setColorOptions(n + 1, 22, -2);
                        if (string != null) {
                            this.setShapeProperty(22, "settranslucency", string);
                        }
                        n = this.iToken;
                        bl = true;
                        break block33;
                    }
                    case 262184: 
                    case 262185: {
                        this.setMeshDisplayProperty(22, n, this.theTok);
                        n = this.iToken;
                        bl = true;
                        break block33;
                    }
                    case 4: {
                        object = this.stringParameter(n);
                        string2 = "create";
                        if (!this.optParameterAsString(n + 1).equalsIgnoreCase("molecular")) break;
                        ++n;
                        string2 = "molecular";
                        break;
                    }
                    case 798: {
                        if (this.tokAt(n + 1) == 262215 || this.tokAt(n + 1) == 524388) {
                            string2 = "select";
                            object = this.expression(n + 1);
                            n = this.iToken;
                            break;
                        }
                        string2 = "selectType";
                        object = this.parameterAsString(++n);
                        break;
                    }
                    case 1: {
                        String string3 = this.parameterAsString(n);
                        if (string3.equalsIgnoreCase("SCALE")) {
                            string2 = "scale";
                            object = new Float(this.floatParameter(++n));
                            break;
                        }
                        if (string3.equalsIgnoreCase("MOLECULAR")) {
                            string2 = "molecular";
                            break;
                        }
                        if (string3.equalsIgnoreCase("CREATE")) {
                            object = this.parameterAsString(++n);
                            string2 = "create";
                            if (!this.optParameterAsString(n + 1).equalsIgnoreCase("molecular")) break;
                            ++n;
                            string2 = "molecular";
                            break;
                        }
                        object = string3;
                    }
                    case 524303: {
                        if (bl) {
                            this.invalidArgument();
                        }
                        string2 = "lcaoID";
                    }
                }
                if (this.theTok != 262186) {
                    bl = true;
                }
                if (string2 == null) {
                    this.invalidArgument();
                }
                this.setShapeProperty(22, string2, object);
            }
            ++n;
        }
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = this.viewer.getDisplayModelIndex();
        int n2 = Integer.MAX_VALUE;
        if (!this.isSyntaxCheck && n < 0) {
            this.multipleModelsNotOK("MO isosurfaces");
        }
        this.viewer.loadShape(23);
        if (this.tokAt(1) == 6 && this.listIsosurface(23)) {
            return true;
        }
        this.setShapeProperty(23, "init", new Integer(n));
        String string = null;
        int n3 = (Integer)this.viewer.getShapeProperty(23, "moNumber");
        if (bl) {
            return true;
        }
        if (n3 == 0 && !this.isSyntaxCheck) {
            this.lastMoNumber = 0;
            n3 = Integer.MAX_VALUE;
        }
        String string2 = null;
        Object object = null;
        switch (this.getToken((int)1).tok) {
            case 2: {
                n3 = this.intParameter(1);
                break;
            }
            case 262202: {
                n3 = this.lastMoNumber + 1;
                break;
            }
            case 262203: {
                n3 = this.lastMoNumber - 1;
                break;
            }
            case 74126595: {
                this.setColorOptions(2, 23, 2);
                break;
            }
            case 17303586: {
                string2 = "plane";
                object = this.planeParameter(2);
                break;
            }
            case 1: {
                String string3 = this.parameterAsString(1);
                n2 = this.moOffset(1);
                if (n2 != Integer.MAX_VALUE) {
                    n3 = 0;
                    break;
                }
                if (string3.equalsIgnoreCase("CUTOFF")) {
                    if (this.tokAt(2) == 8912953) {
                        string2 = "cutoffPositive";
                        object = new Float(this.floatParameter(3));
                        break;
                    }
                    string2 = "cutoff";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("RESOLUTION") || string3.equalsIgnoreCase("POINTSPERANGSTROM")) {
                    string2 = "resolution";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("SCALE")) {
                    string2 = "scale";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("SQUARED")) {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                if (string3.equalsIgnoreCase("TITLEFORMAT")) {
                    if (2 >= this.statementLength || this.tokAt(2) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(2);
                    break;
                }
                if (string3.equalsIgnoreCase("DEBUG")) {
                    string2 = "debug";
                    break;
                }
                if (string3.equalsIgnoreCase("noplane")) {
                    string2 = "plane";
                    break;
                }
                this.invalidArgument();
            }
            default: {
                if (!this.setMeshDisplayProperty(23, 1, this.theTok)) {
                    this.invalidArgument();
                }
                return true;
            }
        }
        if (string2 != null) {
            this.setShapeProperty(23, string2, object);
        }
        if (n3 != Integer.MAX_VALUE) {
            if (this.tokAt(2) == 4) {
                string = this.parameterAsString(2);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setCursor(4);
            }
            this.setMoData(23, n3, n2, n, string);
            this.setShapeProperty(23, "finalize", null);
        }
        return true;
    }

    private String setColorOptions(int n, int n2, int n3) throws ScriptException {
        this.getToken(n);
        String string = "opaque";
        if (this.theTok == 262185) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.setShapeTranslucency(n2, null, "translucent", f);
            } else {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else if (this.theTok == 262184) {
            if (n3 >= 0) {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else {
            --this.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                this.setShapeProperty(n2, "colorRGB", new Integer(this.getArgbParam(++this.iToken)));
                continue;
            }
            if (this.iToken >= n) break;
            this.invalidArgument();
        }
        return string;
    }

    private int moOffset(int n) throws ScriptException {
        String string = this.parameterAsString(n++);
        boolean bl = false;
        int n2 = Integer.MAX_VALUE;
        bl = string.equalsIgnoreCase("HOMO");
        if (bl || string.equalsIgnoreCase("LUMO")) {
            int n3 = n2 = bl ? 0 : 1;
            if (this.tokAt(n) == 2 && this.intParameter(n) < 0) {
                n2 += this.intParameter(n);
            } else if (this.tokAt(n) == 8912953) {
                n2 += this.intParameter(n + 1);
            } else if (this.tokAt(n) == 0x880038) {
                n2 -= this.intParameter(n + 1);
            }
        }
        return n2;
    }

    private void setMoData(int n, int n2, int n3, int n4, String string) throws ScriptException {
        Hashtable hashtable;
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 == 0) {
            n4 = this.viewer.getDisplayModelIndex();
        }
        if (n4 < 0) {
            this.multipleModelsNotOK("MO isosurfaces");
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n4, "jmolSurfaceInfo")) == null || !((String)hashtable.get("surfaceDataType")).equals("mo")) {
            Vector vector;
            int n5;
            hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n4, "moData");
            if (hashtable == null) {
                this.evalError(GT._("no MO basis/coefficient data available for this frame"));
            }
            int n6 = n5 = (vector = (Vector)hashtable.get("mos")) == null ? 0 : vector.size();
            if (n5 == 0) {
                this.evalError(GT._("no MO coefficient data available"));
            }
            if (n5 == 1 && n2 > 1) {
                this.evalError(GT._("Only one molecular orbital is available in this file"));
            }
            if (n3 != Integer.MAX_VALUE) {
                if (hashtable.containsKey("HOMO")) {
                    this.lastMoNumber = n2 = (Integer)hashtable.get("HOMO") + n3;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        Hashtable hashtable2 = (Hashtable)vector.get(i);
                        if (!hashtable2.containsKey("occupancy")) {
                            this.evalError(GT._("no MO occupancy data available"));
                        }
                        if (((Float)hashtable2.get("occupancy")).floatValue() != 0.0f) continue;
                        this.lastMoNumber = n2 = i + n3;
                        break;
                    }
                }
                Logger.info("MO " + n2);
            }
            if (n2 < 1 || n2 > n5) {
                this.evalError(GT._("An MO index from 1 to {0} is required", n5));
            }
        }
        this.lastMoNumber = n2;
        this.setShapeProperty(n, "moData", hashtable);
        if (string != null) {
            this.setShapeProperty(n, "title", string);
        }
        this.setShapeProperty(n, "molecularOrbital", new Integer(n2));
        this.setShapeProperty(n, "clear", null);
    }

    private void initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.thisCommand);
        this.iToken = 0;
        if (this.tokAt(1) == 262186 || this.tokAt(2) == 262186 && this.tokAt(++this.iToken) == 524303) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(n, "init", this.thisCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, this.tokAt(1))) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 20) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
        }
    }

    private boolean listIsosurface(int n) throws ScriptException {
        if (this.getToken((int)1).value instanceof String[]) {
            return false;
        }
        this.checkLength2();
        if (!this.isSyntaxCheck) {
            this.showString((String)this.viewer.getShapeProperty(n, "list"));
        }
        return true;
    }

    private void isosurface(int n) throws ScriptException {
        Object object;
        Object object2;
        int n2;
        this.viewer.loadShape(n);
        if (this.tokAt(1) == 6 && this.listIsosurface(n)) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl = n == 21;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float[] fArray = new float[5];
        float[] fArray2 = null;
        int n5 = 0;
        int n6 = n2 = this.isSyntaxCheck ? 0 : this.viewer.getDisplayModelIndex();
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(4);
        }
        boolean bl5 = false;
        String string = null;
        this.initIsosurface(n);
        block29: for (int i = this.iToken; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (i != n4) {
                    this.invalidParameterOrder();
                }
                this.setShapeProperty(n, "colorRGB", new Integer(this.getArgbParam(i)));
                i = this.iToken;
                n4 = i + 1;
                bl5 = true;
                continue;
            }
            object2 = null;
            object = null;
            block1 : switch (this.getToken((int)i).tok) {
                case 17301545: {
                    float f = this.floatParameter(++i);
                    object = this.centerParameter(++i);
                    i = this.iToken;
                    object2 = "withinPoint";
                    this.setShapeProperty(n, "withinDistance", new Float(f));
                    break;
                }
                case 73990156: {
                    Object object3;
                    this.setShapeProperty(n, "propertySmoothing", this.viewer.getIsosurfacePropertySmoothing() ? Boolean.TRUE : Boolean.FALSE);
                    object2 = "property";
                    String string2 = this.parameterAsString(i);
                    if (!bl4 && string2.toLowerCase().indexOf("property_") == 0) {
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block29;
                        fArray2 = this.viewer.getDataFloat(string2);
                        if (fArray2 == null) {
                            this.invalidArgument();
                        }
                        object = fArray2;
                        break;
                    }
                    int n7 = this.viewer.getAtomCount();
                    int n8 = this.getToken((int)(++i)).tok;
                    float[] fArray3 = fArray2 = bl4 ? new float[]{} : new float[n7];
                    if (bl4) {
                        this.invalidArgument();
                    }
                    if (!this.isSyntaxCheck && !bl4) {
                        object3 = this.viewer.getModelSet().atoms;
                        if (n8 == 2621481) {
                            this.viewer.getSurfaceDistanceMax();
                        }
                        int n9 = n7;
                        while (--n9 >= 0) {
                            fArray2[n9] = this.atomProperty(object3[n9], n8, false);
                        }
                    }
                    object = fArray2;
                    break;
                }
                case 2621709: {
                    if (bl2) {
                        this.invalidArgument();
                    }
                    if ((n2 = this.modelNumberParameter(this.statement[++i])) < 0) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    object2 = "modelIndex";
                    object = new Integer(n2);
                    break;
                }
                case 798: {
                    object2 = "select";
                    object = this.expression(++i);
                    i = this.iToken;
                    break;
                }
                case 772: {
                    object2 = "center";
                    object = this.centerParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 74126595: {
                    n3 = 0;
                    if (this.getToken((int)(i + 1)).tok == 4) {
                        this.setShapeProperty(n, "setColorScheme", this.parameterAsString(++i));
                    }
                    if ((this.theTok = this.tokAt(i + 1)) == 262185 || this.tokAt(i + 1) == 262184) {
                        string = this.setColorOptions(i + 1, 21, -2);
                        i = this.iToken;
                    }
                    switch (this.tokAt(i + 1)) {
                        case 262191: 
                        case 262206: {
                            this.getToken(++i);
                            n3 = 1;
                            object2 = "rangeAll";
                            if (this.tokAt(i + 1) != 524303) break block1;
                            this.getToken(++i);
                            break block1;
                        }
                        default: {
                            n4 = i + 1;
                            break;
                        }
                    }
                    continue block29;
                }
                case 2621704: {
                    continue block29;
                }
                case 8912953: {
                    if (n3 != 0) break;
                    object2 = "cutoffPositive";
                    object = new Float(this.floatParameter(++i));
                    break;
                }
                case 2: 
                case 3: {
                    object2 = n3 == 1 ? "red" : (n3 == 2 ? "blue" : "cutoff");
                    object = new Float(this.floatParameter(i));
                    if (n3 <= 0) break;
                    ++n3;
                    break;
                }
                case 262199: {
                    object2 = "ionicRadius";
                    object = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 69730326: {
                    object2 = "vdwRadius";
                    object = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 17303586: {
                    bl3 = true;
                    object2 = "plane";
                    object = this.planeParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 1: {
                    Object object3;
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("REMAPPABLE")) {
                        object2 = "remappable";
                        break;
                    }
                    if (string2.equalsIgnoreCase("LINK")) {
                        object2 = "link";
                        break;
                    }
                    if (string2.equalsIgnoreCase("SQUARED")) {
                        object2 = "squareData";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("CAP")) {
                        object2 = "cappingPlane";
                        object = this.planeParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("IGNORE")) {
                        object2 = "ignore";
                        object = this.expression(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("CUTOFF")) {
                        if (++i < this.statementLength && this.getToken((int)i).tok == 8912953) {
                            object2 = "cutoffPositive";
                            object = new Float(this.floatParameter(++i));
                            break;
                        }
                        object2 = "cutoff";
                        object = new Float(this.floatParameter(i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("CAVITY")) {
                        float f;
                        if (!bl) {
                            this.invalidArgument();
                        }
                        bl4 = true;
                        if (this.isSyntaxCheck) continue block29;
                        float f2 = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 1.2f;
                        float f3 = f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 10.0f;
                        if (f > 10.0f) {
                            this.numberOutOfRange(0, 10);
                        }
                        this.setShapeProperty(n, "envelopeRadius", new Float(f));
                        this.setShapeProperty(n, "cavityRadius", new Float(f2));
                        object2 = "cavity";
                        break;
                    }
                    if (string2.equalsIgnoreCase("POCKET")) {
                        object2 = "pocket";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("INTERIOR")) {
                        object2 = "pocket";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SCALE")) {
                        object2 = "scale";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("MINSET")) {
                        object2 = "minset";
                        object = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("ANGSTROMS")) {
                        object2 = "angstroms";
                        break;
                    }
                    if (string2.equalsIgnoreCase("RESOLUTION") || string2.equalsIgnoreCase("POINTSPERANGSTROM")) {
                        object2 = "resolution";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("ANISOTROPY")) {
                        object2 = "anisotropy";
                        object = this.getPoint3f(++i, false);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("ECCENTRICITY")) {
                        object2 = "eccentricity";
                        object = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("FIXED")) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("BLOCKDATA")) {
                        object2 = "blockData";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("MODELBASED")) {
                        object2 = "fixed";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SIGN")) {
                        n4 = i + 1;
                        object2 = "sign";
                        object = Boolean.TRUE;
                        n3 = 1;
                        break;
                    }
                    if (string2.equalsIgnoreCase("REVERSECOLOR")) {
                        object2 = "reverseColor";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("ADDHYDROGENS")) {
                        object2 = "addHydrogens";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("COLORSCHEME")) {
                        object2 = "setColorScheme";
                        object = this.parameterAsString(++i);
                        break;
                    }
                    if (string2.equalsIgnoreCase("DEBUG") || string2.equalsIgnoreCase("NODEBUG")) {
                        object2 = "debug";
                        object = string2.equalsIgnoreCase("DEBUG") ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("GRIDPOINTS")) {
                        object2 = "gridPoints";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CONTOUR")) {
                        object2 = "contour";
                        object = new Integer(this.tokAt(i + 1) == 2 ? this.intParameter(++i) : 0);
                        break;
                    }
                    if (string2.equalsIgnoreCase("PHASE")) {
                        object2 = "phase";
                        object = this.tokAt(i + 1) == 4 ? this.stringParameter(++i) : "_orb";
                        break;
                    }
                    if (string2.equalsIgnoreCase("INSIDEOUT")) {
                        object2 = "insideOut";
                        break;
                    }
                    if (string2.equalsIgnoreCase("MAP")) {
                        bl2 = !bl4;
                        object2 = "map";
                        break;
                    }
                    if (string2.equalsIgnoreCase("hkl")) {
                        bl3 = true;
                        object2 = "plane";
                        object = this.hklParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("sphere")) {
                        bl2 = true;
                        object2 = "sphere";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("ellipsoid")) {
                        bl2 = true;
                        object2 = "ellipsoid";
                        object = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("lobe")) {
                        bl2 = true;
                        object2 = "lobe";
                        object = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("AtomicOrbital") || string2.equalsIgnoreCase("orbital")) {
                        bl2 = true;
                        fArray[0] = this.intParameter(++i);
                        fArray[1] = this.intParameter(++i);
                        fArray[2] = this.intParameter(++i);
                        fArray[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                        object2 = "hydrogenOrbital";
                        object = fArray;
                        break;
                    }
                    if (string2.equalsIgnoreCase("functionXY")) {
                        bl2 = true;
                        object3 = new Vector();
                        if (this.getToken((int)(++i)).tok != 4) {
                            this.invalidArgument();
                        }
                        String string3 = this.parameterAsString(i++);
                        ((Vector)object3).addElement(string3);
                        ((Vector)object3).addElement(this.getPoint3f(i, false));
                        Point4f point4f = this.getPoint4f(++this.iToken);
                        ((Vector)object3).addElement(point4f);
                        int n10 = (int)point4f.x;
                        point4f = this.getPoint4f(++this.iToken);
                        ((Vector)object3).addElement(point4f);
                        int n11 = (int)point4f.x;
                        ((Vector)object3).addElement(this.getPoint4f(++this.iToken));
                        if (n10 == 0 || n11 == 0) {
                            this.invalidArgument();
                        }
                        if (!this.isSyntaxCheck) {
                            ((Vector)object3).addElement(this.viewer.functionXY(string3, n10, n11));
                        }
                        i = this.iToken;
                        object2 = "functionXY";
                        object = object3;
                        break;
                    }
                    if (string2.equalsIgnoreCase("molecular")) {
                        bl2 = true;
                        object2 = "molecular";
                        object = new Float(1.4);
                        break;
                    }
                    if (string2.equalsIgnoreCase("VARIABLE")) {
                        object2 = "property";
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (!this.isSyntaxCheck) {
                            Parser.parseFloatArray("" + this.getParameter(this.parameterAsString(++i), false), null, fArray2);
                        }
                        object = fArray2;
                        break;
                    }
                    object = string2;
                }
                case 524303: {
                    if (bl5) {
                        this.invalidArgument();
                    }
                    object2 = "thisID";
                    break;
                }
                case 136548: {
                    bl2 = true;
                    Object object3 = this.parameterAsString(++i);
                    this.setShapeProperty(n, "lcaoType", object3);
                    switch (this.getToken((int)(++i)).tok) {
                        case 262215: 
                        case 524388: {
                            Point3f point3f;
                            object2 = "lcaoCartoon";
                            BitSet bitSet = this.expression(i);
                            i = this.iToken;
                            int n12 = BitSetUtil.firstSetBit(bitSet);
                            n2 = 0;
                            if (n12 < 0) {
                                if (!this.isSyntaxCheck) {
                                    this.expressionExpected();
                                }
                                point3f = new Point3f();
                            } else {
                                n2 = this.viewer.getAtomModelIndex(n12);
                                point3f = this.viewer.getAtomPoint3f(n12);
                            }
                            this.setShapeProperty(n, "modelIndex", new Integer(n2));
                            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(point3f), new Vector3f()};
                            if (!this.isSyntaxCheck) {
                                this.viewer.getHybridizationAndAxes(n12, vector3fArray[0], vector3fArray[1], (String)object3, false);
                            }
                            object = vector3fArray;
                            break block1;
                        }
                    }
                    this.expressionExpected();
                    break;
                }
                case 135523: {
                    if (++i == this.statementLength) {
                        this.badArgumentCount();
                    }
                    int n13 = Integer.MAX_VALUE;
                    int n14 = Integer.MAX_VALUE;
                    if (this.tokAt(i) == 2) {
                        n13 = this.intParameter(i);
                    } else {
                        n14 = this.moOffset(i);
                        if (n14 != Integer.MAX_VALUE) {
                            n13 = 0;
                            i = this.iToken;
                        }
                    }
                    this.setMoData(n, n13, n14, n2, null);
                    bl2 = true;
                    continue block29;
                }
                case 262153: {
                    float[] fArray4 = null;
                    try {
                        fArray4 = this.viewer.getPartialCharges();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.isSyntaxCheck && fArray4 == null) {
                        this.evalError(GT._("No partial charges were read from the file; Jmol needs these to render the MEP data."));
                    }
                    bl2 = true;
                    object2 = "mep";
                    object = fArray4;
                    break;
                }
                case 262208: 
                case 1638404: {
                    bl2 = true;
                    this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
                    object2 = this.theTok == 262208 ? "sasurface" : "solvent";
                    float f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    object = new Float(f);
                    break;
                }
                case 4: {
                    Object object4;
                    object2 = bl2 || bl3 ? "mapColor" : "readFile";
                    String string4 = this.parameterAsString(i);
                    if (string4.length() == 0) {
                        if (bl2 || bl3) {
                            object = this.viewer.getModelAuxiliaryInfo(n2, "jmolMappedDataInfo");
                        }
                        if (object == null) {
                            object = this.viewer.getModelAuxiliaryInfo(n2, "jmolSurfaceInfo");
                        }
                        bl2 = true;
                        if (object != null) break;
                        string4 = this.getFullPathName();
                    }
                    bl2 = true;
                    if (this.tokAt(i + 1) == 2) {
                        this.setShapeProperty(n, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    if (this.thisCommand.indexOf("# FILE" + n5 + "=") >= 0) {
                        string4 = this.extractCommandOption("FILE" + n5);
                    }
                    String[] stringArray = new String[1];
                    Object object5 = object4 = this.isSyntaxCheck ? null : this.viewer.getBufferedReaderOrErrorMessageFromName(string4, stringArray);
                    if (object4 instanceof String) {
                        this.fileNotFoundException(string4 + ":" + object4);
                    }
                    if (!this.isSyntaxCheck) {
                        Logger.info("reading isosurface data from " + stringArray[0]);
                    }
                    this.setShapeProperty(n, "commandOption", "FILE" + n5++ + "=" + Escape.escape(stringArray[0]));
                    object = object4;
                    break;
                }
                default: {
                    if (bl3 && !bl2) {
                        this.setShapeProperty(n, "nomap", new Float(0.0f));
                        bl2 = true;
                    }
                    if (!this.setMeshDisplayProperty(n, i, this.theTok)) {
                        this.invalidArgument();
                    }
                    i = this.iToken;
                }
            }
            boolean bl6 = bl5 = this.theTok != 262186;
            if (object2 == "property" && !bl2) {
                bl2 = true;
                this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
                this.setShapeProperty(n, "sasurface", new Float(0.0f));
            }
            if (object2 == null) continue;
            this.setShapeProperty(n, (String)object2, object);
        }
        if (bl4 && !bl2) {
            bl2 = true;
            this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
            this.setShapeProperty(n, "sasurface", new Float(0.0f));
        }
        if (bl3 && !bl2) {
            this.setShapeProperty(n, "nomap", new Float(0.0f));
            bl2 = true;
        }
        if (bl2 && bl && !this.isSyntaxCheck) {
            String string5 = (String)this.viewer.getShapeProperty(n, "ID");
            object2 = (float[])this.viewer.getShapeProperty(n, "dataRange");
            object = (Integer)this.viewer.getShapeProperty(n, "count");
            if (string5 != null) {
                string5 = string5 + " created; number of isosurfaces = " + object;
                if (object2 != null && object2[0] != object2[1]) {
                    string5 = string5 + "\ncolor range " + (float)object2[2] + " " + (float)object2[3] + "; mapped data range " + (float)object2[0] + " to " + (float)object2[1];
                }
                this.showString(string5);
            }
            this.setShapeProperty(n, "finalize", null);
        }
        if (string != null) {
            this.setShapeProperty(n, "translucency", string);
        }
        this.setShapeProperty(n, "clear", null);
    }

    private boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        String string = null;
        Comparable<Boolean> comparable = null;
        boolean bl = n2 == 0;
        switch (n3) {
            case 0: 
            case 262186: 
            case 524304: 
            case 524305: {
                if (this.iToken == 1) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (!bl) {
                    this.setShapeProperty(n, this.parameterAsString(this.iToken), null);
                }
                return true;
            }
            case 1290: {
                comparable = Boolean.TRUE;
            }
            case 262193: {
                string = "dots";
                break;
            }
            case 262194: {
                comparable = Boolean.TRUE;
            }
            case 262195: {
                string = "mesh";
                break;
            }
            case 262196: {
                comparable = Boolean.TRUE;
            }
            case 262197: {
                string = "fill";
                break;
            }
            case 262226: {
                comparable = Boolean.TRUE;
            }
            case 262227: {
                string = "triangles";
                break;
            }
            case 262228: {
                comparable = Boolean.TRUE;
            }
            case 262229: {
                string = "frontOnly";
                break;
            }
            case 262230: {
                string = "lighting";
                comparable = new Integer(0);
                break;
            }
            case 262231: {
                string = "lighting";
                comparable = new Integer(1);
                break;
            }
            case 262232: {
                string = "lighting";
                comparable = new Integer(2);
                break;
            }
            case 262184: 
            case 262185: {
                if (bl) {
                    return true;
                }
                this.colorShape(n, this.iToken, false);
                return true;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, comparable);
        n3 = this.tokAt(this.iToken + 1);
        if (n3 != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, n3)) {
            --this.iToken;
        }
        return true;
    }

    void evalError(String string) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            String string2 = this.viewer.removeCommand();
            this.viewer.addCommand(string2 + "#??");
            this.viewer.setCursor(0);
            this.viewer.setRefreshing(true);
        }
        throw new ScriptException(string);
    }

    private void multipleModelsNotOK(String string) throws ScriptException {
        this.evalError(GT._("{0} require that only one model be displayed", string));
    }

    private void unrecognizedCommand() throws ScriptException {
        this.evalError(GT._("unrecognized command") + ": " + this.statement[0].value);
    }

    private void unrecognizedAtomProperty(String string) throws ScriptException {
        this.evalError(GT._("unrecognized atom property") + ": " + string);
    }

    private void unrecognizedBondProperty(String string) throws ScriptException {
        this.evalError(GT._("unrecognized bond property") + ": " + string);
    }

    private void filenameExpected() throws ScriptException {
        this.evalError(GT._("filename expected"));
    }

    private void booleanExpected() throws ScriptException {
        this.evalError(GT._("boolean expected"));
    }

    private void booleanOrNumberExpected() throws ScriptException {
        this.evalError(GT._("boolean or number expected"));
    }

    private void booleanOrNumberExpected(String string) throws ScriptException {
        this.evalError(GT._("boolean, number, or {0} expected", "\"" + string + "\""));
    }

    private void expressionOrIntegerExpected() throws ScriptException {
        this.evalError(GT._("(atom expression) or integer expected"));
    }

    private void expressionExpected() throws ScriptException {
        this.evalError(GT._("valid (atom expression) expected"));
    }

    private void badRGBColor() throws ScriptException {
        this.evalError(GT._("bad [R,G,B] color"));
    }

    private int integerExpected() throws ScriptException {
        this.evalError(GT._("integer expected"));
        return 0;
    }

    private float numberExpected() throws ScriptException {
        this.evalError(GT._("number expected"));
        return 0.0f;
    }

    private String stringExpected() throws ScriptException {
        this.evalError(GT._("quoted string expected"));
        return "";
    }

    private void stringOrIdentifierExpected() throws ScriptException {
        this.evalError(GT._("quoted string or identifier expected"));
    }

    private void propertyNameExpected() throws ScriptException {
        this.evalError(GT._("property name expected"));
    }

    private void axisExpected() throws ScriptException {
        this.evalError(GT._("x y z axis expected"));
    }

    private void colorExpected() throws ScriptException {
        this.evalError(GT._("color expected"));
    }

    private void unrecognizedObject() throws ScriptException {
        this.evalError(GT._("unrecognized object"));
    }

    private void unrecognizedExpression() throws ScriptException {
        this.evalError(GT._("runtime unrecognized expression"));
    }

    void endOfStatementUnexpected() throws ScriptException {
        this.evalError(GT._("unexpected end of script command"));
    }

    private void badArgumentCount() throws ScriptException {
        this.evalError(GT._("bad argument count"));
    }

    void invalidArgument() throws ScriptException {
        this.evalError(GT._("invalid argument"));
    }

    void unrecognizedParameter(String string, String string2) throws ScriptException {
        this.evalError(GT._("unrecognized {0} parameter", string) + ": " + string2);
    }

    private void unrecognizedShowParameter(String string) throws ScriptException {
        this.evalError(GT._("unrecognized SHOW parameter --  use {0}", string));
    }

    private void numberOutOfRange(int n, int n2) throws ScriptException {
        this.evalError(GT._("integer out of range ({0} - {1})", new Object[]{new Integer(n), new Integer(n2)}));
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.evalError(GT._("decimal number out of range ({0} - {1})", new Object[]{new Float(f), new Float(f2)}));
    }

    private void numberMustBe(int n, int n2) throws ScriptException {
        this.evalError(GT._("number must be ({0} or {1})", new Object[]{new Integer(n), new Integer(n2)}));
    }

    private void fileNotFoundException(String string) throws ScriptException {
        this.evalError(GT._("file not found") + ": " + string);
    }

    private void drawObjectNotDefined(String string) throws ScriptException {
        this.evalError(GT._("draw object not defined") + ": " + string);
    }

    String objectNameExpected() throws ScriptException {
        this.evalError(GT._("object name expected after '$'"));
        return "";
    }

    private void coordinateOrNameOrExpressionRequired() throws ScriptException {
        this.evalError(GT._(" {x y z} or $name or (atom expression) required"));
    }

    private void keywordExpected(String string) throws ScriptException {
        this.evalError(GT._("keyword expected") + ": " + string);
    }

    private void invalidParameterOrder() throws ScriptException {
        this.evalError(GT._("invalid parameter order"));
    }

    private void incompatibleArguments() throws ScriptException {
        this.evalError(GT._("incompatible arguments"));
    }

    private void insufficientArguments() throws ScriptException {
        this.evalError(GT._("insufficient arguments"));
    }

    private String statementAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.statement[0].tok;
        boolean bl = Compiler.tokAttr(n, 1024);
        boolean bl2 = Compiler.tokAttr(n, 37888);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = n == 169247 && (String)this.statement[0].value == "";
        block25: for (int i = 0; i < this.statementLength; ++i) {
            if (this.iToken == i - 1) {
                stringBuffer.append(" <<");
            }
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if (i == 2 && bl5) {
                bl5 = false;
                stringBuffer.append("= ");
            }
            Token token = this.statement[i];
            if (this.iToken == i && token.tok != 524389) {
                stringBuffer.append(">> ");
            }
            switch (token.tok) {
                case 524388: {
                    if (bl2) {
                        stringBuffer.append("{");
                        continue block25;
                    }
                    if (!bl) continue block25;
                    stringBuffer.append("(");
                    continue block25;
                }
                case 524389: {
                    if (bl4 && i == this.statementLength - 1) {
                        bl2 = false;
                    }
                    if (bl2) {
                        stringBuffer.append("}");
                        continue block25;
                    }
                    if (!bl) continue block25;
                    stringBuffer.append(")");
                    continue block25;
                }
                case 0x880010: 
                case 0x880011: {
                    break;
                }
                case 524291: 
                case 524292: {
                    bl3 = token.tok == 524291;
                    break;
                }
                case 590601: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    stringBuffer.append("@");
                    if (this.tokAt(i + 1) != 524388) continue block25;
                    if (!bl2) {
                        bl4 = true;
                    }
                    bl2 = true;
                    continue block25;
                }
                case 524305: {
                    stringBuffer.append("true");
                    continue block25;
                }
                case 524304: {
                    stringBuffer.append("false");
                    continue block25;
                }
                case 798: {
                    break;
                }
                case 2: {
                    stringBuffer.append(token.intValue);
                    continue block25;
                }
                case 7: 
                case 8: 
                case 262215: {
                    stringBuffer.append(Token.sValue(token));
                    continue block25;
                }
                case 524315: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                    } else {
                        stringBuffer.append(Group.getSeqcodeString(Eval.getSeqCode(token)));
                    }
                    token = this.statement[++i];
                    stringBuffer.append(' ');
                    stringBuffer.append(bl3 ? "-" : "- ");
                }
                case 524314: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                        continue block25;
                    }
                    stringBuffer.append(Group.getSeqcodeString(Eval.getSeqCode(token)));
                    continue block25;
                }
                case 524316: {
                    stringBuffer.append("*:");
                    stringBuffer.append((char)token.intValue);
                    continue block25;
                }
                case 524317: {
                    stringBuffer.append("*%");
                    if (token.value == null) continue block25;
                    stringBuffer.append(token.value.toString());
                    continue block25;
                }
                case 524318: {
                    stringBuffer.append("*/");
                }
                case 3: 
                case 524319: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        stringBuffer.append(Escape.escapeModelFileNumber(token.intValue));
                        continue block25;
                    }
                    stringBuffer.append("" + token.value);
                    continue block25;
                }
                case 524312: {
                    stringBuffer.append('[');
                    stringBuffer.append(Group.getGroup3((short)token.intValue));
                    stringBuffer.append(']');
                    continue block25;
                }
                case 524313: {
                    stringBuffer.append('[');
                    stringBuffer.append(token.value);
                    stringBuffer.append(']');
                    continue block25;
                }
                case 524320: {
                    stringBuffer.append("*.");
                    break;
                }
                case 2621445: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f point3f = (Point3f)token.value;
                    stringBuffer.append("cell={").append(point3f.x).append(" ").append(point3f.y).append(" ").append(point3f.z).append("}");
                    continue block25;
                }
                case 4: {
                    stringBuffer.append("\"").append(token.value).append("\"");
                    continue block25;
                }
                case 42467376: 
                case 42467377: 
                case 42467378: 
                case 42467379: 
                case 42467380: 
                case 42467381: {
                    if (token.intValue == 73990156) {
                        stringBuffer.append((String)this.statement[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    stringBuffer.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (!this.logMessages) break;
                    stringBuffer.append(token.toString());
                    continue block25;
                }
            }
            if (token.value == null) continue;
            stringBuffer.append(token.value.toString());
        }
        if (this.iToken >= this.statementLength - 1) {
            stringBuffer.append(" <<");
        }
        return stringBuffer.toString();
    }

    String contextTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string = (this.functionName == null ? "" : " function " + this.functionName) + " file " + this.filename;
            stringBuffer.append(Eval.setErrorLineMessage(string, this.getLinenumber(), this.pc, this.statementAsString()));
            if (this.scriptLevel <= 0) break;
            this.popContext();
        }
        return stringBuffer.toString();
    }

    static String setErrorLineMessage(String string, int n, int n2, String string2) {
        String string3 = "\n----";
        if (string != null) {
            string3 = string3 + "line " + n + " command " + (n2 + 1) + " of" + string + ":";
        }
        string3 = string3 + "\n         " + string2;
        return string3;
    }

    class Rpn {
        private Token[] oStack;
        private Token[] xStack;
        private int oPt = -1;
        private int xPt = -1;
        private int maxLevel;
        private int parenCount;
        private int squareCount;
        private int braceCount;
        private boolean wasX;
        private boolean isAssignment;
        private boolean asVector;

        Rpn(int n, boolean bl, boolean bl2) {
            this.isAssignment = bl;
            this.maxLevel = n;
            this.asVector = bl2;
            this.oStack = new Token[n];
            this.xStack = new Token[n];
            if (Eval.this.logMessages) {
                Logger.info("initialize RPN on " + Eval.this.getScript());
            }
        }

        Token getResult(boolean bl, String string) throws ScriptException {
            boolean bl2 = true;
            Token token = null;
            int n = Integer.MAX_VALUE;
            while (bl2 && this.oPt >= 0) {
                bl2 = this.operate();
            }
            if (bl2 && this.isAssignment && this.xPt == 2 && this.xStack[1].tok == 0x880010) {
                token = this.xStack[2];
                n = Token.iValue(this.xStack[0]);
                this.xPt = 0;
            } else if (bl2 && this.asVector) {
                Vector<Token> vector = new Vector<Token>();
                for (int i = 0; i <= this.xPt; ++i) {
                    vector.addElement(Token.selectItem(this.xStack[i]));
                }
                return new Token(4435, vector);
            }
            if (bl2 && this.xPt == 0) {
                if (token == null) {
                    token = this.xStack[0];
                }
                if (token.tok == 262215 || token.tok == 6 || token.tok == 4) {
                    token = this.xStack[0] = Token.selectItem(token);
                }
                if (n == Integer.MAX_VALUE && string != null && string.length() > 0 && !Eval.this.isSyntaxCheck) {
                    Eval.this.viewer.setListVariable(string, token.tok == 6 ? token : null);
                }
                if (n != Integer.MAX_VALUE || token.tok == 6) {
                    token = new Token(4, n, Token.sValue(token));
                }
                return token;
            }
            if (!(bl || this.xPt < 0 && this.oPt < 0)) {
                --Eval.this.iToken;
                Eval.this.invalidArgument();
            }
            return null;
        }

        boolean addX(Token token) throws ScriptException {
            if (this.xPt + 1 == this.maxLevel) {
                this.stackOverflow();
            }
            if (this.wasX && token.tok == 2 && token.intValue < 0) {
                this.addOp(Token.tokenMinus);
                this.xStack[++this.xPt] = Token.intToken(-token.intValue);
            } else if (this.wasX && token.tok == 3 && ((Float)token.value).floatValue() < 0.0f) {
                this.addOp(Token.tokenMinus);
                this.xStack[++this.xPt] = new Token(3, new Float(-Token.fValue(token)));
            } else {
                this.xStack[++this.xPt] = token;
            }
            if (Eval.this.logMessages) {
                Logger.info("addX token " + token);
            }
            this.wasX = true;
            return true;
        }

        boolean addX(Object object) throws ScriptException {
            if (object instanceof Integer) {
                return this.addX((Integer)object);
            }
            if (object instanceof Float) {
                return this.addX(((Float)object).floatValue());
            }
            if (object instanceof String) {
                return this.addX((String)object);
            }
            if (object instanceof Point3f) {
                return this.addX((Point3f)object);
            }
            if (object instanceof Point4f) {
                return this.addX((Point4f)object);
            }
            if (object instanceof BitSet) {
                return this.addX((BitSet)object);
            }
            if (object instanceof Token) {
                return this.addX((Token)object);
            }
            return false;
        }

        boolean addX(boolean bl) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = bl ? Token.tokenOn : Token.tokenOff;
            return true;
        }

        boolean addX(int n) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = Token.intToken(n);
            this.wasX = true;
            return true;
        }

        boolean addX(float f) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(3, new Float(f));
            this.wasX = true;
            return true;
        }

        boolean addX(String string) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(4, string);
            this.wasX = true;
            return true;
        }

        boolean addX(String[] stringArray) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(6, stringArray);
            this.wasX = true;
            return true;
        }

        boolean addX(Point3f point3f) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(7, point3f);
            this.wasX = true;
            return true;
        }

        boolean addX(Point4f point4f) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(8, point4f);
            this.wasX = true;
            return true;
        }

        boolean addX(BitSet bitSet) throws ScriptException {
            if (++this.xPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(262215, bitSet);
            this.wasX = true;
            return true;
        }

        boolean isOpFunc(Token token) {
            return Compiler.tokAttr(token.tok, 0x1080000) || token.tok == 8912977 && Compiler.tokAttr(token.intValue, 0x1080000);
        }

        boolean addOp(Token token) throws ScriptException {
            boolean bl;
            if (Eval.this.logMessages) {
                this.dumpStacks();
                Logger.info("\naddOp: " + token);
            }
            Token token2 = null;
            boolean bl2 = false;
            boolean bl3 = bl = token.tok == 8912977;
            if (bl && !this.wasX) {
                return false;
            }
            boolean bl4 = this.isOpFunc(token);
            if (this.oPt >= 1 && token.tok != 0x880000 && Compiler.tokAttr(this.oStack[this.oPt].tok, 2048)) {
                --this.oPt;
            }
            boolean bl5 = this.oPt >= 1 && this.oStack[this.oPt].tok == 0x880000;
            switch (token.tok) {
                case 0x880008: {
                    if (this.wasX) break;
                    return false;
                }
                case 64: 
                case 128: 
                case 192: {
                    int n;
                    int n2 = n = this.oPt < 0 ? 0 : this.oStack[this.oPt].tok;
                    if (!this.wasX || n != 8912977 && n != 6881282 && n != 6815745) {
                        return false;
                    }
                    this.oStack[this.oPt].intValue |= token.tok;
                    return true;
                }
                case 0x880010: {
                    bl2 = true;
                    break;
                }
                case 0x880038: {
                    if (this.wasX) break;
                    this.addX(0);
                    token = new Token(0x880048, "-");
                    break;
                }
                case 0x880001: {
                    if (this.wasX || this.oPt < 1 || this.oStack[this.oPt].tok != 0x880000 || this.isOpFunc(this.oStack[this.oPt - 1])) break;
                    return false;
                }
                case 0x880000: 
                case 0x880028: {
                    bl2 = true;
                }
                default: {
                    if (bl4) {
                        if (!bl && this.wasX && !bl5) {
                            return false;
                        }
                        token2 = token;
                        bl2 = true;
                        break;
                    }
                    if (this.wasX != bl2) break;
                    return false;
                }
            }
            while (this.oPt >= 0 && (!bl2 && token.tok != 0x880010 || (token.tok == 8912977 || token.tok == 0x880010) && this.oStack[this.oPt].tok == 8912977) && Token.prec(this.oStack[this.oPt].tok) >= Token.prec(token.tok)) {
                if (Eval.this.logMessages) {
                    this.dumpStacks();
                    Logger.info("\noperating, oPt=" + this.oPt + " isLeftOp=" + bl2 + " oStack[oPt]=" + Token.nameOf(this.oStack[this.oPt].tok) + "/" + Token.prec(this.oStack[this.oPt].tok) + " op=" + Token.nameOf(token.tok) + "/" + Token.prec(token.tok));
                }
                if (token.tok == 0x880001 && this.oStack[this.oPt].tok == 0x880000) {
                    this.xStack[this.xPt] = Token.selectItem(this.xStack[this.xPt]);
                    break;
                }
                if (token.tok == 0x880011 && this.oStack[this.oPt].tok == 0x880010) {
                    if (this.xPt == 0 && this.isAssignment) {
                        this.addX(Token.tokenArraySelector);
                        break;
                    }
                    if (this.doBitsetSelect()) break;
                    return false;
                }
                if (this.operate()) continue;
                return false;
            }
            if (token2 != null) {
                this.addX(token2);
            }
            switch (token.tok) {
                case 0x880008: {
                    this.wasX = false;
                    return true;
                }
                case 0x880000: {
                    ++this.parenCount;
                    this.wasX = false;
                    break;
                }
                case 0x880010: {
                    ++this.squareCount;
                    this.wasX = false;
                    break;
                }
                case 0x880001: {
                    this.wasX = true;
                    --this.oPt;
                    if (this.parenCount-- <= 0) {
                        return false;
                    }
                    if (this.oPt < 0) {
                        return true;
                    }
                    return this.isOpFunc(this.oStack[this.oPt]) ? this.evaluateFunction() : true;
                }
                case 0x880011: {
                    this.wasX = true;
                    --this.oPt;
                    return this.squareCount-- > 0;
                }
                case 8912977: {
                    this.wasX = !Compiler.tokAttr(token.intValue, 0x1080000);
                    break;
                }
                case 524291: {
                    ++this.braceCount;
                    this.wasX = false;
                    break;
                }
                case 524292: {
                    if (this.braceCount-- <= 0) {
                        return false;
                    }
                }
                default: {
                    this.wasX = false;
                }
            }
            if (++this.oPt == this.maxLevel) {
                this.stackOverflow();
            }
            this.oStack[this.oPt] = token;
            return true;
        }

        private boolean doBitsetSelect() {
            if (this.xPt < 0 || this.xPt == 0 && !this.isAssignment) {
                return false;
            }
            int n = Token.iValue(this.xStack[this.xPt--]);
            Token token = this.xStack[this.xPt];
            switch (token.tok) {
                default: {
                    token = new Token(4, Token.sValue(token));
                }
                case 4: 
                case 6: 
                case 262215: 
            }
            this.xStack[this.xPt] = Token.selectItem(token, n);
            return true;
        }

        void dumpStacks() {
            int n;
            Logger.info("RPN stacks: for " + Eval.this.getScript());
            for (n = 0; n <= this.xPt; ++n) {
                Logger.info("x[" + n + "]: " + this.xStack[n]);
            }
            Logger.info("\n");
            for (n = 0; n <= this.oPt; ++n) {
                Logger.info("o[" + n + "]: " + this.oStack[n] + " prec=" + Token.prec(this.oStack[n].tok));
            }
        }

        Token getX() throws ScriptException {
            if (this.xPt < 0) {
                Eval.this.endOfStatementUnexpected();
            }
            return this.xStack[this.xPt--];
        }

        private boolean evaluateFunction() throws ScriptException {
            Token token = this.oStack[this.oPt--];
            int n = token.tok == 8912977 ? token.intValue : token.tok;
            int n2 = Token.prec(n);
            int n3 = 0;
            int n4 = this.xPt;
            while (n4 >= 0 && this.xStack[n4--] != token) {
                ++n3;
            }
            if (n2 > 0 && n3 > n2) {
                return false;
            }
            Token[] tokenArray = new Token[n3];
            int n5 = n3;
            while (--n5 >= 0) {
                tokenArray[n5] = this.getX();
            }
            --this.xPt;
            if (Eval.this.isScriptCheck) {
                return token.tok == 8912977 ? true : this.addX(true);
            }
            switch (n) {
                case 23592977: {
                    if (token.tok == 8912977) {
                        return this.evaluateDistance(tokenArray);
                    }
                }
                case 17301537: {
                    return this.evaluateMeasure(tokenArray, token.tok == 17301537);
                }
                case 17326337: {
                    return this.evaluateUserFunction((String)token.value, tokenArray);
                }
                case 23592971: {
                    return this.evaluateFind(tokenArray);
                }
                case 23592979: {
                    return this.evaluateReplace(tokenArray);
                }
                case 0x1080001: {
                    return this.evaluateArray(tokenArray);
                }
                case 23592968: 
                case 23592969: 
                case 23592970: {
                    return this.evaluateString(token.intValue, tokenArray);
                }
                case 23592972: 
                case 23592973: 
                case 23592974: 
                case 23592975: {
                    return this.evaluateList(token.intValue, tokenArray);
                }
                case 23660815: {
                    return this.evaluateLabel(tokenArray);
                }
                case 17301778: {
                    return this.evaluateData(tokenArray);
                }
                case 17305865: {
                    return this.evaluateLoad(tokenArray);
                }
                case 17301771: 
                case 17303820: {
                    return this.evaluateScript(tokenArray, n == 17303820);
                }
                case 17301545: {
                    return this.evaluateWithin(tokenArray);
                }
                case 17302785: {
                    return this.evaluateGetProperty(tokenArray);
                }
                case 17301529: {
                    return this.evaluatePoint(tokenArray);
                }
                case 17303586: {
                    return this.evaluatePlane(tokenArray);
                }
                case 17301546: {
                    return this.evaluateConnected(tokenArray);
                }
                case 17301514: {
                    return this.evaluateSubstructure(tokenArray);
                }
            }
            return false;
        }

        private boolean evaluateDistance(Token[] tokenArray) throws ScriptException {
            Token token = this.getX();
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1.0f);
            }
            Token token2 = tokenArray[0];
            Point3f point3f = this.ptValue(token2);
            Point4f point4f = this.planeValue(token2);
            if (token.tok == 262215) {
                return this.addX(Eval.this.getBitsetProperty(Token.bsSelect(token), 23592977, point3f, point4f, token.value, null, false));
            }
            Point3f point3f2 = this.ptValue(token);
            Point4f point4f2 = this.planeValue(token);
            if (point4f2 == null) {
                return this.addX(point4f == null ? point3f.distance(point3f2) : Graphics3D.distanceToPlane(point4f, point3f2));
            }
            return this.addX(Graphics3D.distanceToPlane(point4f2, point3f));
        }

        private boolean evaluateMeasure(Token[] tokenArray, boolean bl) throws ScriptException {
            int n = tokenArray.length;
            if (n < (bl ? 3 : 2) || n > (bl ? 4 : 2)) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1.0f);
            }
            Point3f[] point3fArray = new Point3f[n];
            for (int i = 0; i < n; ++i) {
                point3fArray[i] = this.ptValue(tokenArray[i]);
            }
            switch (n) {
                case 2: {
                    return this.addX(point3fArray[0].distance(point3fArray[1]));
                }
                case 3: {
                    return this.addX(Measure.computeAngle(point3fArray[0], point3fArray[1], point3fArray[2], true));
                }
                case 4: {
                    return this.addX(Measure.computeTorsion(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], true));
                }
            }
            return false;
        }

        private boolean evaluateUserFunction(String string, Token[] tokenArray) throws ScriptException {
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            Vector<Token> vector = new Vector<Token>();
            for (int i = 0; i < tokenArray.length; ++i) {
                vector.addElement(tokenArray[i]);
            }
            Token token = Eval.this.getFunctionReturn(string, vector);
            this.wasX = false;
            return token == null ? false : this.addX(token);
        }

        private boolean evaluateFind(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            Token token = this.getX();
            String string = Token.sValue(tokenArray[0]);
            switch (token.tok) {
                default: {
                    return this.addX(Token.sValue(token).indexOf(string) + 1);
                }
                case 6: 
            }
            int n = 0;
            String[] stringArray = (String[])token.value;
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(string) < 0) continue;
                ++n;
                n2 = i;
            }
            if (n == 1) {
                return this.addX(stringArray[n2]);
            }
            String[] stringArray2 = new String[n];
            if (n > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (stringArray[n3].indexOf(string) < 0) continue;
                    stringArray2[--n] = stringArray[n3];
                }
            }
            return this.addX(stringArray2);
        }

        private boolean evaluateGetProperty(Token[] tokenArray) throws ScriptException {
            Object object;
            Object object2;
            String string;
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            int n = 0;
            String string2 = string = tokenArray.length > n ? Token.sValue(tokenArray[n++]).toLowerCase() : "";
            Object object3 = tokenArray.length > n && tokenArray[n].tok == 262215 ? Token.bsSelect(tokenArray[n++]) : (object2 = tokenArray.length > n && tokenArray[n].tok == 4 && PropertyManager.acceptsStringParameter(string) ? tokenArray[n++].value : "");
            if (string.equalsIgnoreCase("fileContents") && tokenArray.length > 2) {
                object = Token.sValue(tokenArray[1]);
                for (int i = 2; i < tokenArray.length; ++i) {
                    object = (String)object + "|" + Token.sValue(tokenArray[i]);
                }
                object2 = object;
                n = tokenArray.length;
            }
            object = Eval.this.viewer.getProperty(null, string, object2);
            if ((object = PropertyManager.extractProperty(object, tokenArray, n)) instanceof String) {
                return this.addX(object);
            }
            if (object instanceof Integer) {
                return this.addX(object);
            }
            if (object instanceof Float) {
                return this.addX(object);
            }
            if (object instanceof Point3f) {
                return this.addX(object);
            }
            if (object instanceof Vector3f) {
                return this.addX(new Point3f((Vector3f)object));
            }
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                int n2 = vector.size();
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    Object e = vector.elementAt(i);
                    stringArray[i] = e instanceof String ? (String)e : Escape.toReadable(e);
                }
                return this.addX(stringArray);
            }
            return this.addX(Escape.toReadable(object));
        }

        private boolean evaluatePoint(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1 && tokenArray.length != 3) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(new Point3f(0.0f, 0.0f, 0.0f));
            }
            switch (tokenArray.length) {
                case 1: {
                    Object object = Escape.unescapePoint(Token.sValue(tokenArray[0]));
                    if (object instanceof Point3f) {
                        return this.addX((Point3f)object);
                    }
                    return this.addX("" + object);
                }
                case 3: {
                    float f = Token.fValue(tokenArray[0]);
                    float f2 = Token.fValue(tokenArray[1]);
                    float f3 = Token.fValue(tokenArray[2]);
                    return this.addX(new Point3f(f, f2, f3));
                }
            }
            return false;
        }

        private boolean evaluatePlane(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1 && tokenArray.length != 3 && tokenArray.length != 4) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
            switch (tokenArray.length) {
                case 1: {
                    Object object = Escape.unescapePoint(Token.sValue(tokenArray[0]));
                    if (object instanceof Point4f) {
                        return this.addX((Point4f)object);
                    }
                    return this.addX("" + object);
                }
                case 3: 
                case 4: {
                    switch (tokenArray[0].tok) {
                        case 7: 
                        case 262215: {
                            Point3f point3f = this.ptValue(tokenArray[0]);
                            Point3f point3f2 = this.ptValue(tokenArray[1]);
                            Point3f point3f3 = this.ptValue(tokenArray[2]);
                            Vector3f vector3f = new Vector3f();
                            Vector3f vector3f2 = new Vector3f();
                            Vector3f vector3f3 = new Vector3f();
                            float f = Graphics3D.getDirectedNormalThroughPoints(point3f, point3f2, point3f3, tokenArray.length == 4 ? this.ptValue(tokenArray[3]) : null, vector3f3, vector3f, vector3f2);
                            return this.addX(new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f));
                        }
                    }
                    float f = Token.fValue(tokenArray[0]);
                    float f2 = Token.fValue(tokenArray[1]);
                    float f3 = Token.fValue(tokenArray[2]);
                    float f4 = Token.fValue(tokenArray[3]);
                    return this.addX(new Point4f(f, f2, f3, f4));
                }
            }
            return false;
        }

        private boolean evaluateReplace(Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length != 2) {
                return false;
            }
            Token token = this.getX();
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string2 = Token.sValue(tokenArray[0]);
            String string3 = Token.sValue(tokenArray[1]);
            String string4 = string = token.tok == 6 ? null : Token.sValue(token);
            if (string != null) {
                return this.addX(TextFormat.simpleReplace(string, string2, string3));
            }
            String[] stringArray = (String[])token.value;
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = TextFormat.simpleReplace(stringArray[n], string2, string3);
            }
            return this.addX(stringArray);
        }

        private boolean evaluateString(int n, Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length > 1) {
                return false;
            }
            Token token = this.getX();
            if (Eval.this.isSyntaxCheck) {
                return this.addX(Token.sValue(token));
            }
            String string2 = string = n == 23592968 && token.tok == 262215 || n == 23592970 && token.tok == 6 ? null : Token.sValue(token);
            String string3 = tokenArray.length == 1 ? Token.sValue(tokenArray[0]) : (n == 23592970 ? "" : "\n");
            switch (n) {
                case 23592968: {
                    if (token.tok == 262215) {
                        BitSet bitSet = Token.bsSelect(token);
                        string3 = "\n";
                        int n2 = Eval.this.viewer.getModelCount();
                        string = "";
                        for (int i = 0; i < n2; ++i) {
                            string = string + (i == 0 ? "" : "\n");
                            BitSet bitSet2 = Eval.this.viewer.getModelAtomBitSet(i, true);
                            bitSet2.and(bitSet);
                            string = string + Escape.escape(bitSet2);
                        }
                    }
                    return this.addX(TextFormat.split(string, string3));
                }
                case 23592969: {
                    if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                        string = string.substring(0, string.length() - 1);
                    }
                    return this.addX(TextFormat.simpleReplace(string, "\n", string3));
                }
                case 23592970: {
                    if (string != null) {
                        return this.addX(TextFormat.trim(string, string3));
                    }
                    String[] stringArray = (String[])token.value;
                    int n3 = stringArray.length;
                    while (--n3 >= 0) {
                        stringArray[n3] = TextFormat.trim(stringArray[n3], string3);
                    }
                    return this.addX(stringArray);
                }
            }
            return this.addX("");
        }

        private boolean evaluateList(int n, Token[] tokenArray) throws ScriptException {
            String[] stringArray;
            String string;
            if (tokenArray.length != 1) {
                return false;
            }
            Token token = this.getX();
            Token token2 = tokenArray[0];
            if (token.tok != 6 && token.tok != 4) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            boolean bl = token2.tok != 6 && Token.sValue(token2).indexOf("\n") < 0;
            String string2 = string = bl ? Token.sValue(token2) : "";
            float f = string.indexOf("{") >= 0 ? Float.NaN : (bl ? Token.fValue(token2) : 0.0f);
            String[] stringArray2 = stringArray = token.value instanceof String ? TextFormat.split((String)token.value, "\n") : (String[])token.value;
            String[] stringArray3 = bl ? null : (token2.value instanceof String ? TextFormat.split((String)token2.value, "\n") : (String[])token2.value);
            int n2 = bl ? stringArray.length : Math.min(stringArray.length, stringArray3.length);
            String[] stringArray4 = new String[n2];
            float[] fArray = new float[stringArray.length];
            Parser.parseFloatArray(stringArray, fArray);
            float[] fArray2 = new float[bl ? stringArray.length : stringArray3.length];
            if (bl) {
                int n3 = n2;
                while (--n3 >= 0) {
                    fArray2[n3] = f;
                }
            } else {
                Parser.parseFloatArray(stringArray3, fArray2);
            }
            Token token3 = null;
            switch (n) {
                case 23592972: {
                    token3 = Token.tokenPlus;
                    break;
                }
                case 23592973: {
                    token3 = Token.tokenMinus;
                    break;
                }
                case 23592974: {
                    token3 = Token.tokenTimes;
                    break;
                }
                case 23592975: {
                    token3 = Token.tokenDivide;
                }
            }
            for (int i = 0; i < n2; ++i) {
                if (Float.isNaN(fArray[i])) {
                    this.addX(Token.unescapePointOrBitsetAsToken(stringArray[i]));
                } else {
                    this.addX(fArray[i]);
                }
                if (!Float.isNaN(fArray2[i])) {
                    this.addX(fArray2[i]);
                } else if (bl) {
                    this.addX(Token.unescapePointOrBitsetAsToken(string));
                } else {
                    this.addX(Token.unescapePointOrBitsetAsToken(stringArray3[i]));
                }
                if (!this.addOp(token3) || !this.operate()) {
                    return false;
                }
                stringArray4[i] = Token.sValue(this.xStack[this.xPt--]);
            }
            return this.addX(stringArray4);
        }

        private boolean evaluateArray(Token[] tokenArray) throws ScriptException {
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            int n = tokenArray.length;
            if (n == 0) {
                n = 1;
            }
            String[] stringArray = new String[n];
            stringArray[0] = "";
            for (int i = 0; i < tokenArray.length; ++i) {
                stringArray[i] = Token.sValue(tokenArray[i]);
            }
            return this.addX(stringArray);
        }

        private boolean evaluateLoad(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            return this.addX(Eval.this.viewer.getFileAsString(Token.sValue(tokenArray[0])));
        }

        private boolean evaluateScript(Token[] tokenArray, boolean bl) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string = Token.sValue(tokenArray[0]);
            if (bl) {
                return this.addX(Eval.this.viewer.eval(string));
            }
            StringBuffer stringBuffer = new StringBuffer();
            Eval.this.runScript(string, stringBuffer);
            return this.addX(stringBuffer.toString());
        }

        private boolean evaluateData(Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length == 0 || tokenArray.length > 2) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string2 = Token.sValue(tokenArray[0]);
            String string3 = string = tokenArray.length == 2 ? Token.sValue(tokenArray[1]) : "";
            if (string2.indexOf("property_") == 0) {
                float[] fArray;
                float[] fArray2 = Eval.this.viewer.getDataFloat(string2);
                if (fArray2 == null) {
                    return this.addX("");
                }
                float[] fArray3 = fArray = string.indexOf("property_") == 0 ? Eval.this.viewer.getDataFloat(string) : null;
                if (fArray != null) {
                    int n = Math.min(fArray2.length, fArray.length);
                    while (--n >= 0) {
                        int n2 = n;
                        fArray2[n2] = fArray2[n2] + fArray[n];
                    }
                }
                return this.addX(Escape.escape(fArray2));
            }
            if (tokenArray.length == 1) {
                Object[] objectArray = Eval.this.viewer.getData(string2);
                return this.addX(objectArray == null ? "" : "" + objectArray[1]);
            }
            return this.addX(Eval.this.viewer.getData(string2, string));
        }

        private boolean evaluateLabel(Token[] tokenArray) throws ScriptException {
            String string;
            Token token = this.getX();
            String string2 = string = tokenArray.length == 0 ? "%U" : Token.sValue(tokenArray[0]);
            if (tokenArray.length > 1 || token.tok != 262215) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            return this.addX(Eval.this.getBitsetIdent(Token.bsSelect(token), string, token.value, true));
        }

        private boolean evaluateWithin(Token[] tokenArray) throws ScriptException {
            boolean bl;
            if (tokenArray.length < 1) {
                return false;
            }
            Object object = tokenArray[0].value;
            int n = tokenArray[0].tok;
            String string = "" + object;
            BitSet bitSet = new BitSet();
            float f = 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = tokenArray.length;
            boolean bl4 = false;
            boolean bl5 = bl = n == 3 || n == 2;
            if (object instanceof String) {
                bl2 = !Parser.isOneOf(string, "element;site;group;chain;molecule;model;boundbox");
            } else if (bl) {
                f = Token.fValue(tokenArray[0]);
                if (n2 < 2) {
                    return false;
                }
                if (tokenArray[1].tok == 524305 || tokenArray[1].tok == 524304) {
                    bl4 = Token.bValue(tokenArray[1]);
                    n2 = 0;
                }
            } else {
                return false;
            }
            if (n2 == 3) {
                string = Token.sValue(tokenArray[1]);
                if (!Parser.isOneOf(string, "on;off;plane;hkl;coord")) {
                    return false;
                }
            } else if (n2 == 1) {
                if (!string.equals("boundbox")) {
                    return false;
                }
                bl3 = true;
            }
            Point3f point3f = null;
            Point4f point4f = null;
            n2 = tokenArray.length - 1;
            if (tokenArray[n2].value instanceof Point4f) {
                point4f = (Point4f)tokenArray[n2].value;
            } else if (tokenArray[n2].value instanceof Point3f) {
                point3f = (Point3f)tokenArray[n2].value;
            }
            if (n2 > 0 && point4f == null && point3f == null && !(tokenArray[n2].value instanceof BitSet)) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            if (point4f != null) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, point4f));
            }
            if (point3f != null) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, point3f));
            }
            BitSet bitSet2 = bitSet = bl3 ? null : Token.bsSelect(tokenArray[n2]);
            if (bl) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, bitSet, bl4));
            }
            if (bl2) {
                return this.addX(Eval.this.viewer.getAtomsWithin(524298, string, bitSet));
            }
            return this.addX(Eval.this.viewer.getAtomsWithin(Token.getTokenFromName((String)string).tok, bitSet));
        }

        private boolean evaluateConnected(Token[] tokenArray) throws ScriptException {
            float f = -2.1474836E9f;
            float f2 = 2.1474836E9f;
            float f3 = 0.0f;
            float f4 = Float.MAX_VALUE;
            short s = -2;
            BitSet bitSet = null;
            BitSet bitSet2 = null;
            boolean bl = false;
            boolean bl2 = false;
            block5: for (int i = 0; i < tokenArray.length; ++i) {
                Token token = tokenArray[i];
                switch (token.tok) {
                    case 262215: {
                        bl2 = token.value instanceof Bond.BondSet;
                        if (bl2 && bitSet != null) {
                            return false;
                        }
                        if (bitSet == null) {
                            bitSet = Token.bsSelect(token);
                            continue block5;
                        }
                        if (bitSet2 == null) {
                            bitSet2 = Token.bsSelect(token);
                            continue block5;
                        }
                        return false;
                    }
                    case 4: {
                        s = JmolConstants.getBondOrderFromString(Token.sValue(token));
                        if (s != -1) continue block5;
                        return false;
                    }
                    case 3: {
                        bl = true;
                    }
                    default: {
                        int n = Token.iValue(token);
                        float f5 = Token.fValue(token);
                        if (f2 != 2.1474836E9f) {
                            return false;
                        }
                        if (f == -2.1474836E9f) {
                            f = Math.max(n, 1);
                            f3 = f5;
                            continue block5;
                        }
                        f2 = n;
                        f4 = f5;
                    }
                }
            }
            if (f == -2.1474836E9f) {
                f = 1.0f;
                f2 = 100.0f;
                f3 = 0.1f;
                f4 = 1.0E8f;
            } else if (f2 == 2.1474836E9f) {
                f2 = f;
                f4 = f3;
                f3 = 0.1f;
            }
            if (bitSet == null) {
                bitSet = Eval.this.viewer.getModelAtomBitSet(-1, true);
            }
            if (bl && bitSet2 == null) {
                bitSet2 = bitSet;
            }
            if (bitSet2 != null) {
                BitSet bitSet3 = new BitSet();
                if (Eval.this.isSyntaxCheck) {
                    return this.addX(new Token(262215, new Bond.BondSet(bitSet3)));
                }
                Eval.this.viewer.makeConnections(f3, f4, s, 5, bitSet, bitSet2, bitSet3, bl2);
                return this.addX(new Token(262215, new Bond.BondSet(bitSet3, Eval.this.viewer.getAtomIndices(Eval.this.viewer.getAtomsWithin(6881282, bitSet3)))));
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            return this.addX(Eval.this.viewer.getAtomsConnected(f, f2, s, bitSet));
        }

        private boolean evaluateSubstructure(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            BitSet bitSet = new BitSet();
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            String string = Token.sValue(tokenArray[0]);
            if (string.length() == 0) {
                return false;
            }
            try {
                SmilesMatcherInterface smilesMatcherInterface = (SmilesMatcherInterface)Class.forName("org.jmol.smiles.PatternMatcher").newInstance();
                smilesMatcherInterface.setViewer(Eval.this.viewer);
                bitSet = smilesMatcherInterface.getSubstructureSet(string);
            }
            catch (Exception exception) {
                Eval.this.evalError(exception.getMessage());
            }
            return this.addX(bitSet);
        }

        private boolean operate() throws ScriptException {
            Token token = this.oStack[this.oPt--];
            if (this.oPt < 0 && token.tok == 42467380 && this.isAssignment && this.xPt == 2) {
                return true;
            }
            Token token2 = this.getX();
            if (token2 == Token.tokenArraySelector) {
                return false;
            }
            if (token2.tok == 6) {
                token2 = Token.selectItem(token2);
            }
            if (token.tok == 0x880028) {
                return Eval.this.isScriptCheck ? this.addX(true) : (token2.tok == 262215 ? this.addX(BitSetUtil.copyInvert(Token.bsSelect(token2), token2.value instanceof Bond.BondSet ? Eval.this.viewer.getBondCount() : Eval.this.viewer.getAtomCount())) : this.addX(!Token.bValue(token2)));
            }
            int n = token.intValue & 0xFFFFFF3F;
            if (token.tok == 8912977) {
                switch (n) {
                    case 6815751: {
                        return this.addX(Token.sizeOf(token2));
                    }
                    case 0x680008: {
                        return this.addX(Token.typeOf(token2));
                    }
                    case 0x680006: {
                        if (token2.tok != 4) {
                            return Eval.this.isScriptCheck ? this.addX(1) : false;
                        }
                        String string = (String)token2.value;
                        string = TextFormat.simpleReplace(string, "\n\r", "\n").replace('\r', '\n');
                        return this.addX(TextFormat.split(string, '\n'));
                    }
                    case 74126595: {
                        switch (token2.tok) {
                            case 4: 
                            case 6: {
                                Point3f point3f = new Point3f();
                                return this.addX(Graphics3D.colorPointFromString(Token.sValue(token2), point3f));
                            }
                            case 2: 
                            case 3: {
                                return this.addX(Eval.this.viewer.getColorPointForPropertyValue(Token.fValue(token2)));
                            }
                            case 7: {
                                return this.addX(Escape.escapeColor(Eval.colorPtToInt((Point3f)token2.value)));
                            }
                        }
                        break;
                    }
                    case 6886669: {
                        return Eval.this.isScriptCheck ? this.addX("x") : this.evaluateBoundBox(token2);
                    }
                }
                if (Eval.this.isScriptCheck) {
                    return this.addX(Token.sValue(token2));
                }
                if (token2.tok == 4) {
                    Object object = Token.unescapePointOrBitsetAsToken(Token.sValue(token2));
                    if (!(object instanceof Token)) {
                        return false;
                    }
                    token2 = (Token)object;
                }
                return this.evaluatePointOrBitsetOperation(token, token2);
            }
            Token token3 = this.getX();
            if (Eval.this.isScriptCheck) {
                return this.addX(Token.sValue(token3));
            }
            if (token3.tok == 6) {
                token3 = Token.selectItem(token3);
            }
            switch (token.tok) {
                case 0x880020: {
                    if (token3.tok == 262215 && token2.tok == 262215) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.and(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) && Token.bValue(token2));
                }
                case 0x880018: {
                    if (token3.tok == 262215 && token2.tok == 262215) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.or(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) || Token.bValue(token2));
                }
                case 8912921: {
                    if (token3.tok == 262215 && token2.tok == 262215) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.xor(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    boolean bl = Token.bValue(token3);
                    boolean bl2 = Token.bValue(token2);
                    return this.addX(bl && !bl2 || bl2 && !bl);
                }
                case 8912922: {
                    if (token3.tok != 262215 || token2.tok != 262215) {
                        return false;
                    }
                    return this.addX(BitSetUtil.toggleInPlace(Token.bsSelect(token3), Token.bsSelect(token2), Eval.this.viewer.getAtomCount()));
                }
                case 42467378: {
                    return this.addX(Token.fValue(token3) <= Token.fValue(token2));
                }
                case 42467377: {
                    return this.addX(Token.fValue(token3) >= Token.fValue(token2));
                }
                case 42467376: {
                    return this.addX(Token.fValue(token3) > Token.fValue(token2));
                }
                case 42467379: {
                    return this.addX(Token.fValue(token3) < Token.fValue(token2));
                }
                case 42467380: {
                    if (token3.tok == 4 && token2.tok == 4) {
                        return this.addX(Token.sValue(token3).equalsIgnoreCase(Token.sValue(token2)));
                    }
                    return this.addX(Token.fValue(token3) == Token.fValue(token2));
                }
                case 42467381: {
                    if (token3.tok == 4 && token2.tok == 4) {
                        return this.addX(!Token.sValue(token3).equalsIgnoreCase(Token.sValue(token2)));
                    }
                    return this.addX(Token.fValue(token3) != Token.fValue(token2));
                }
                case 8912953: {
                    String string;
                    if (token3.tok == 6 || token2.tok == 6) {
                        return this.addX(Token.concatList(token3, token2));
                    }
                    if (token3.tok == 4) {
                        return this.addX(Token.sValue(token3) + Token.sValue(token2));
                    }
                    if (token3.tok == 4 && token2.tok == 2 && (string = Token.sValue(token3).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0) {
                        return this.addX(Token.iValue(token3) + token2.intValue);
                    }
                    if (token3.tok == 2 && (token2.tok == 4 ? (string = Token.sValue(token2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : token2.tok != 3)) {
                        return this.addX(token3.intValue + Token.iValue(token2));
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        switch (token2.tok) {
                            case 7: {
                                point3f.add((Point3f)token2.value);
                                return this.addX(point3f);
                            }
                        }
                        float f = Token.fValue(token2);
                        return this.addX(new Point3f(point3f.x + f, point3f.y + f, point3f.z + f));
                    }
                    return this.addX(Token.fValue(token3) + Token.fValue(token2));
                }
                case 0x880038: {
                    String string;
                    if (token3.tok == 2 && (token2.tok == 4 ? (string = Token.sValue(token2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : token2.tok != 3)) {
                        return this.addX(token3.intValue - Token.iValue(token2));
                    }
                    if (token3.tok == 4 && token2.tok == 2 && (string = Token.sValue(token3).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0) {
                        return this.addX(Token.iValue(token3) - token2.intValue);
                    }
                    if (token3.tok == 2 && token2.tok == 2) {
                        return this.addX(token3.intValue - Token.iValue(token2));
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        switch (token2.tok) {
                            case 7: {
                                point3f.sub((Point3f)token2.value);
                                return this.addX(point3f);
                            }
                        }
                        float f = Token.fValue(token2);
                        return this.addX(new Point3f(point3f.x - f, point3f.y - f, point3f.z - f));
                    }
                    return this.addX(Token.fValue(token3) - Token.fValue(token2));
                }
                case 0x880048: {
                    switch (token2.tok) {
                        case 2: {
                            return this.addX(-Token.iValue(token2));
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token2.value);
                            point3f.scale(-1.0f);
                            return this.addX(point3f);
                        }
                        case 8: {
                            Point4f point4f = new Point4f((Point4f)token2.value);
                            point4f.scale(-1.0f);
                            return this.addX(point4f);
                        }
                        case 262215: {
                            return this.addX(BitSetUtil.copyInvert(Token.bsSelect(token2), token2.value instanceof Bond.BondSet ? Eval.this.viewer.getBondCount() : Eval.this.viewer.getAtomCount()));
                        }
                    }
                    return this.addX(-Token.fValue(token2));
                }
                case 8912961: {
                    if (token3.tok == 2 && token2.tok != 3) {
                        return this.addX(token3.intValue * Token.iValue(token2));
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        switch (token2.tok) {
                            case 7: {
                                Point3f point3f2 = (Point3f)token2.value;
                                return this.addX(point3f.x * point3f2.x + point3f.y * point3f2.y + point3f.z * point3f2.z);
                            }
                        }
                        float f = Token.fValue(token2);
                        return this.addX(new Point3f(point3f.x * f, point3f.y * f, point3f.z * f));
                    }
                    return this.addX(Token.fValue(token3) * Token.fValue(token2));
                }
                case 8912962: {
                    String string = null;
                    int n2 = Token.iValue(token2);
                    switch (token3.tok) {
                        case 2: 
                        case 524304: 
                        case 524305: {
                            if (n2 == 0) {
                                return this.addX(0);
                            }
                            return this.addX(Token.iValue(token3) % n2);
                        }
                        case 3: {
                            float f = Token.fValue(token3);
                            if (n2 == 0) {
                                return this.addX((int)(f + 0.5f * (float)(f < 0.0f ? -1 : 1)));
                            }
                            string = TextFormat.formatDecimal(f, n2);
                            return this.addX(string);
                        }
                        case 4: {
                            string = (String)token3.value;
                            if (n2 == 0) {
                                return this.addX(TextFormat.trim(string, "\n\t "));
                            }
                            if (n2 > 0) {
                                return this.addX(TextFormat.format(string, n2, n2, false, false));
                            }
                            return this.addX(TextFormat.format(string, -n2, n2, true, false));
                        }
                        case 6: {
                            String[] stringArray = (String[])token3.value;
                            String[] stringArray2 = new String[stringArray.length];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray2[i] = n2 == 0 ? stringArray[i].trim() : (n2 > 0 ? TextFormat.format(stringArray[i], n2, n2, true, false) : TextFormat.format(string, -n2, n2, false, false));
                            }
                            return this.addX(stringArray2);
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token3.value);
                            Eval.this.viewer.toUnitCell(point3f, new Point3f(n2, n2, n2));
                            return this.addX(point3f);
                        }
                        case 262215: {
                            return this.addX(Token.bsSelect(token3, n2));
                        }
                    }
                }
                case 0x880040: {
                    if (token3.tok == 2 && token2.tok == 2 && token2.intValue != 0) {
                        return this.addX(token3.intValue / token2.intValue);
                    }
                    if (token3.tok == 7) {
                        Point3f point3f = new Point3f((Point3f)token3.value);
                        float f = Token.fValue(token2);
                        if (f == 0.0f) {
                            return this.addX(new Point3f(Float.NaN, Float.NaN, Float.NaN));
                        }
                        return this.addX(new Point3f(point3f.x / f, point3f.y / f, point3f.z / f));
                    }
                    float f = Token.fValue(token3);
                    float f2 = Token.fValue(token2);
                    if (f2 == 0.0f) {
                        return this.addX(f == 0.0f ? 0.0f : (f < 0.0f ? Float.POSITIVE_INFINITY : Float.POSITIVE_INFINITY));
                    }
                    return this.addX(f / f2);
                }
            }
            return true;
        }

        private boolean evaluateBoundBox(Token token) throws ScriptException {
            if (token.tok != 262215) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            BoxInfo boxInfo = Eval.this.viewer.getBoxInfo(Token.bsSelect(token));
            Point3f[] point3fArray = boxInfo.getBoundBoxPoints();
            return this.addX(new String[]{Escape.escape(point3fArray[0]), Escape.escape(point3fArray[1]), Escape.escape(point3fArray[2]), Escape.escape(point3fArray[3])});
        }

        private boolean evaluatePointOrBitsetOperation(Token token, Token token2) throws ScriptException {
            switch (token2.tok) {
                case 6: {
                    String[] stringArray = (String[])token2.value;
                    String[] stringArray2 = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object object = Token.unescapePointOrBitsetAsToken(stringArray[i]);
                        if (!(object instanceof Token) || !this.evaluatePointOrBitsetOperation(token, (Token)object)) {
                            return false;
                        }
                        stringArray2[i] = Token.sValue(this.xStack[this.xPt--]);
                    }
                    return this.addX(stringArray2);
                }
                case 7: {
                    switch (token.intValue) {
                        case 69730336: {
                            return this.addX(((Point3f)token2.value).x);
                        }
                        case 69730337: {
                            return this.addX(((Point3f)token2.value).y);
                        }
                        case 69730338: {
                            return this.addX(((Point3f)token2.value).z);
                        }
                        case 69730339: 
                        case 69730340: 
                        case 69730341: {
                            Point3f point3f = new Point3f((Point3f)token2.value);
                            Eval.this.viewer.toFractional(point3f);
                            return this.addX(token.intValue == 69730339 ? point3f.x : (token.intValue == 69730340 ? point3f.y : point3f.z));
                        }
                    }
                    break;
                }
                case 262215: {
                    if (token.intValue == 6881282 && token2.value instanceof Bond.BondSet) {
                        return this.addX(token2);
                    }
                    Object object = Eval.this.getBitsetProperty(Token.bsSelect(token2), token.intValue, null, null, token2.value, token.value, false);
                    if (token.intValue == 6881282) {
                        return this.addX(new Token(262215, new Bond.BondSet((BitSet)object, Eval.this.viewer.getAtomIndices(Token.bsSelect(token2)))));
                    }
                    return this.addX(object);
                }
            }
            return false;
        }

        Point3f ptValue(Token token) throws ScriptException {
            if (Eval.this.isSyntaxCheck) {
                return new Point3f();
            }
            switch (token.tok) {
                case 7: {
                    return (Point3f)token.value;
                }
                case 262215: {
                    return (Point3f)Eval.this.getBitsetProperty(Token.bsSelect(token), 73924617, null, null, token.value, null, false);
                }
                case 4: 
                case 6: {
                    Object object = Escape.unescapePoint(Token.sValue(token));
                    if (!(object instanceof Point3f)) break;
                    return (Point3f)object;
                }
            }
            float f = Token.fValue(token);
            return new Point3f(f, f, f);
        }

        Point4f planeValue(Token token) {
            if (Eval.this.isSyntaxCheck) {
                return new Point4f();
            }
            switch (token.tok) {
                case 8: {
                    return (Point4f)token.value;
                }
                case 4: 
                case 6: {
                    Object object = Escape.unescapePoint(Token.sValue(token));
                    return object instanceof Point4f ? (Point4f)object : null;
                }
            }
            return null;
        }

        void stackOverflow() throws ScriptException {
            Eval.this.evalError(GT._("too many parentheses"));
        }
    }

    class ScriptException
    extends Exception {
        private String message;

        ScriptException(String string) {
            this.message = (string == null ? "" : string) + Eval.this.contextTrace();
            if (!Eval.this.isSyntaxCheck) {
                Logger.error("eval ERROR: " + this.toString());
            }
        }

        public String toString() {
            return this.message;
        }
    }

    private static class Context {
        String filename;
        String functionName;
        String script;
        short[] lineNumbers;
        int[] lineIndices;
        Token[][] aatoken;
        Token[] statement;
        int statementLength;
        int pc;
        int pcEnd = Integer.MAX_VALUE;
        int lineEnd = Integer.MAX_VALUE;
        int iToken;
        StringBuffer outputBuffer;
        Hashtable contextVariables;

        Context() {
        }
    }
}

