/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.atomdata.AtomData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelCollection;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected boolean isZeroBased;
    protected final Shape[] shapes = new Shape[31];
    protected final Atom[] closest = new Atom[1];
    private static final boolean useRasMolHbondsCalculation = true;

    protected void releaseModelSet() {
        for (int i = 0; i < 31; ++i) {
            this.shapes[i] = null;
        }
        this.models = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        if (this.selectionHaloEnabled != bl) {
            this.selectionHaloEnabled = bl;
        }
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public void setZeroBased() {
        this.isZeroBased = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
    }

    private Shape allocateShape(int n) {
        if (n == 2 || n == 3) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            shape.initializeShape(this.viewer, this.g3d, this, n);
            return shape;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate shape:" + string, exception);
            return null;
        }
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.modelNumbers[i] != n) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getTrajectoryInfo() {
        String string = "";
        if (this.trajectories == null) {
            return "";
        }
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            string = " or " + this.getModelNumberDotted(this.models[n].selectedTrajectory) + string;
            n = this.models[n].trajectoryBaseIndex;
        }
        if (string.length() > 0) {
            string = "set trajectory {" + string.substring(4) + "}";
        }
        return string;
    }

    public BitSet getBitSetTrajectories() {
        if (this.trajectories == null) {
            return null;
        }
        BitSet bitSet = new BitSet();
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            bitSet.set(this.models[n].selectedTrajectory);
            n = this.models[n].trajectoryBaseIndex;
        }
        return bitSet;
    }

    public void setTrajectory(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int n) {
        int n2;
        if (n < 0 || !this.models[n].isTrajectory) {
            return;
        }
        int n3 = this.models[n].firstAtomIndex;
        if (this.atoms[n3].modelIndex == n) {
            return;
        }
        int n4 = this.models[n].trajectoryBaseIndex;
        this.models[n4].selectedTrajectory = n;
        Point3f[] point3fArray = (Point3f[])this.trajectories.get(n);
        BitSet bitSet = new BitSet();
        int n5 = this.getAtomCountInModel(n);
        int n6 = 0;
        for (n2 = n3; n2 < n5 && n6 < point3fArray.length; ++n2) {
            this.atoms[n2].set(point3fArray[n6++]);
            this.atoms[n2].modelIndex = (short)n;
            bitSet.set(n2);
        }
        this.bspf.clearBspt(n4);
        this.recalculateLeadMidpointsAndWingVectors(n4);
        Integer n7 = new Integer(n4);
        for (n2 = 0; n2 < 31; ++n2) {
            if (this.shapes[n2] == null) continue;
            this.setShapeProperty(n2, "refreshTrajectories", n7, bitSet);
        }
        if (this.models[n4].hasCalculatedHBonds) {
            this.clearCalculatedHydrogenBonds(n4, null);
            this.models[n4].calcHydrogenBonds(bitSet, bitSet);
        }
        if ((n2 = this.viewer.getCurrentModelIndex()) >= 0 && n2 != n && this.models[n2].fileIndex == this.models[n].fileIndex) {
            this.viewer.setCurrentModelIndex(n, false);
        }
    }

    public BitSet getAtomBits(int n, int n2) {
        switch (n) {
            case 524318: {
                return this.getSpecModel(n2);
            }
        }
        return super.getAtomBits(n, n2);
    }

    private BitSet getSpecModel(int n) {
        int n2 = this.getModelNumberIndex(n, true, true);
        return n2 < 0 && n > 0 ? new BitSet() : this.getModelAtomBitSet(n2, true);
    }

    public int findNearestAtomIndex(int n, int n2) {
        int n3;
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearestAtomIndex(n, n2, this.closest);
        for (n3 = 0; n3 < this.shapes.length && this.closest[0] == null; ++n3) {
            if (this.shapes[n3] == null) continue;
            this.shapes[n3].findNearestAtomIndex(n, n2, this.closest);
        }
        n3 = this.closest[0] == null ? -1 : this.closest[0].atomIndex;
        this.closest[0] = null;
        return n3;
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        if (n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setSize(n2, bitSet);
        }
    }

    public Shape loadShape(int n) {
        if (this.shapes[n] == null) {
            this.shapes[n] = this.allocateShape(n);
        }
        return this.shapes[n];
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes[n] != null) {
            this.shapes[n].setProperty(string.intern(), object, bitSet);
        }
    }

    public Object getShapeProperty(int n, String string, int n2) {
        return this.shapes[n] == null ? null : this.shapes[n].getProperty(string, n2);
    }

    public int getShapeIdFromObjectName(String string) {
        for (int i = 20; i < 25; ++i) {
            if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
            return i;
        }
        Shape shape = this.shapes[16];
        return shape == null || shape.getIndexFromName(string) < 0 ? -1 : 16;
    }

    public void setModelVisibility() {
        int n;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 31; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 31; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    public void fillAtomData(AtomData atomData, int n) {
        if (n == 3) {
            int[] nArray = new int[1];
            atomData.hAtomRadius = (float)JmolConstants.vanderwaalsMars[1] / 1000.0f;
            atomData.hAtoms = this.getAdditionalHydrogens(atomData.bsSelected, nArray);
            atomData.hydrogenAtomCount = nArray[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? Math.max(0, BitSetUtil.firstSetBit(atomData.bsSelected)) : this.models[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        super.fillAtomData(atomData, n);
    }

    public boolean frankClicked(int n, int n2) {
        Shape shape = this.shapes[30];
        return shape != null && shape.wasClicked(n, n2);
    }

    public boolean checkObjectHovered(int n, int n2) {
        Shape shape = this.shapes[28];
        if (shape != null && shape.checkObjectHovered(n, n2)) {
            return true;
        }
        shape = this.shapes[20];
        if (shape == null || !this.viewer.getDrawHover()) {
            return false;
        }
        return shape.checkObjectHovered(n, n2);
    }

    public boolean checkObjectClicked(int n, int n2, int n3) {
        Shape shape = this.shapes[28];
        if (shape != null && shape.checkObjectClicked(n, n2, n3)) {
            return true;
        }
        shape = this.shapes[20];
        return shape != null && shape.checkObjectClicked(n, n2, n3);
    }

    public void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        Shape shape;
        for (int i = 0; !(i >= 31 || (shape = this.shapes[i]) != null && shape.checkObjectDragged(n, n2, n3, n4, n5)); ++i) {
        }
    }

    public Hashtable getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 31; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            String string = JmolConstants.shapeClassBases[i];
            Vector vector = shape.getShapeDetail();
            if (vector == null) continue;
            Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
            hashtable2.put("obj", vector);
            hashtable.put(string, hashtable2);
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    public void calculateStructures(BitSet bitSet) {
        int n;
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = BitSetUtil.invertInPlace(this.modelsOf(bitSet, bitSet2), this.modelCount);
        for (n = 0; n < this.modelCount; ++n) {
            if (bitSet3.get(n)) continue;
            this.addBioPolymerToModel(null, this.models[n]);
        }
        this.calculatePolymers(bitSet3);
        this.calculateStructuresAllExcept(bitSet3, false);
        for (n = 0; n < this.shapes.length; ++n) {
            if (this.shapes[n] == null || !this.shapes[n].isBioShape) continue;
            this.shapes[n].setSize(0, bitSet2);
            this.shapes[n].setProperty("color", new Byte(1), bitSet2);
        }
    }

    private BitSet modelsOf(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = new BitSet(this.modelCount);
        for (int i = 0; i < this.atomCount; ++i) {
            int n = this.models[this.atoms[i].modelIndex].trajectoryBaseIndex;
            if (bitSet != null && !bitSet.get(i) || this.isJmolDataFrame(n)) continue;
            bitSet3.set(n);
            bitSet2.set(i);
        }
        return bitSet3;
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        this.bsPseudoHBonds = new BitSet();
        if (this.bondCount > 0) {
            this.calcHydrogenBonds(bitSet, bitSet2);
            bitSet3 = this.bsPseudoHBonds;
            return BitSetUtil.cardinalityOf(bitSet3);
        }
        this.initializeBspf();
        return super.autoHbond(bitSet, bitSet2, bitSet3);
    }

    protected void assignAromaticBonds(boolean bl) {
        super.assignAromaticBonds(bl, null);
        if (bl) {
            this.setShapeSize(1, Integer.MIN_VALUE, this.bsAromatic);
        }
    }

    public int[] makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        if (n != 5) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            string = bl ? string + Escape.escape(bitSet, false) + " " : string + Escape.escape(bitSet) + " " + Escape.escape(bitSet2) + " ";
            if (n != 0) {
                string = string + JmolConstants.getBondOrderNameFromOrder(s) + " ";
            }
            string = string + JmolConstants.connectOperationName(n);
            string = string + ";";
            this.stateScripts.addElement(string);
        }
        return super.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    public void setPdbConectBonding(int n, int n2, BitSet bitSet) {
        short s = this.viewer.getMadBond();
        for (int i = n2; i < this.modelCount; ++i) {
            int n3;
            Vector vector = (Vector)this.getModelAuxiliaryInfo(i, "PDB_CONECT_bonds");
            if (vector == null) continue;
            int n4 = vector.size();
            int[] nArray = (int[])this.getModelAuxiliaryInfo(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])vector.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                if (bitSet != null) {
                    if (this.atoms[n11].isHetero()) {
                        bitSet.set(n11);
                    }
                    if (this.atoms[n12].isHetero()) {
                        bitSet.set(n12);
                    }
                }
                this.checkValencesAndBond(this.atoms[n11], this.atoms[n12], s2, s2 == 2048 ? (short)1 : s, null);
            }
        }
    }

    public void deleteAllBonds() {
        int n = 0;
        while (n < this.stateScripts.size()) {
            if (((String)this.stateScripts.get(n)).indexOf("connect") == 0) {
                this.stateScripts.removeElementAt(n);
                continue;
            }
            ++n;
        }
        super.deleteAllBonds();
    }

    public String getState(StringBuffer stringBuffer, boolean bl) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setModelState;\n");
            stringBuffer2.append("function _setModelState();\n");
        }
        if (bl) {
            for (n = 0; n < 7; n = (byte)(n + 1)) {
                if (this.getTaintedAtoms((byte)n) == null) continue;
                this.getTaintedState(stringBuffer2, (byte)n);
            }
        }
        if (bl) {
            Vector vector = this.stateScripts;
            int n2 = vector.size();
            if (n2 > 0) {
                stringBuffer2.append("\n");
                for (int i = 0; i < n2; ++i) {
                    stringBuffer2.append("  ").append(vector.get(i)).append("\n");
                }
            }
            stringBuffer2.append("\n");
        }
        this.setModelVisibility();
        stringBuffer2.append(this.getProteinStructureState(null, false));
        for (n = 0; n < 31; ++n) {
            String string;
            Shape shape = this.shapes[n];
            if (shape == null || !bl && !JmolConstants.isShapeSecondary(n) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
            stringBuffer2.append(string);
        }
        for (n = 0; n < this.modelCount; ++n) {
            String string = this.frameTitles[n];
            if (string == null || string.length() <= 0) continue;
            stringBuffer2.append("  frame " + this.getModelNumberDotted(n) + "; frame title " + Escape.escape(string) + "\n;");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\nend function;\n\n");
        }
        return stringBuffer2.toString();
    }
}

