/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class V3000Reader
extends AtomSetCollectionReader {
    int headerAtomCount;
    int headerBondCount;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("v3000");
        boolean bl = false;
        try {
            while (this.readLine() != null) {
                if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                    if (!bl) {
                        this.flushLines();
                        continue;
                    }
                    break;
                }
                bl = true;
                this.processCtab();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void processCtab() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$") && !this.line.startsWith("M  END")) {
            if (this.line.startsWith("M  V30 BEGIN ATOM")) {
                this.processAtomBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN BOND")) {
                this.processBondBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN CTAB")) {
                this.newAtomSet("");
                continue;
            }
            if (!this.line.startsWith("M  V30 COUNTS")) continue;
            this.headerAtomCount = this.parseInt(this.line, 13);
            this.headerBondCount = this.parseInt();
        }
        if (this.line != null && !this.line.startsWith("$$$$")) {
            this.flushLines();
        }
    }

    String processAtomBlock() throws Exception {
        int n = this.headerAtomCount;
        while (--n >= 0) {
            String string;
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized atom");
            }
            Atom atom = new Atom();
            String[] stringArray = this.getTokens();
            atom.atomSerial = this.parseInt(stringArray[2]);
            atom.elementSymbol = stringArray[3];
            atom.set(this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]));
            this.parseInt();
            while ((string = this.parseToken()) != null) {
                if (!string.startsWith("CHG=")) continue;
                atom.formalCharge = this.parseInt(string, 4);
            }
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END ATOM")) {
            throw new Exception("M  V30 END ATOM not found");
        }
        return this.line;
    }

    void processBondBlock() throws Exception {
        int n = this.headerBondCount;
        while (--n >= 0) {
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized bond");
            }
            this.parseInt(this.line, 7);
            int n2 = this.parseInt();
            int n3 = this.parseInt();
            int n4 = this.parseInt();
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(n3, n4, n2);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END BOND")) {
            throw new Exception("M  V30 END BOND not found");
        }
    }

    void readLineWithContinuation() throws Exception {
        this.readLine();
        if (this.line != null && this.line.length() > 7) {
            while (this.line.charAt(this.line.length() - 1) == '-') {
                String string = this.readLine();
                if (string == null || !this.line.startsWith("M  V30 ")) {
                    throw new Exception("Invalid line continuation");
                }
                this.line = this.line + string.substring(7);
            }
        }
    }

    void flushLines() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$")) {
        }
    }
}

