/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

public class CompoundDocument
extends BinaryDocument {
    CmpDocHeader header = new CmpDocHeader();
    Vector directory = new Vector();
    CmpDocDirectoryEntry rootEntry;
    int[] SAT;
    int[] SSAT;
    int sectorSize;
    int shortSectorSize;
    int nShortSectorsPerStandardSector;
    int nIntPerSector;
    int nDirEntriesperSector;
    StringBuffer data;

    public CompoundDocument(BufferedInputStream bufferedInputStream) {
        if (!this.isRandom) {
            this.stream = new DataInputStream(bufferedInputStream);
        }
        this.stream.mark(Integer.MAX_VALUE);
        if (!this.readHeader()) {
            return;
        }
        this.getSectorAllocationTable();
        this.getShortSectorAllocationTable();
        this.getDirectoryTable();
    }

    public static boolean isCompoundDocument(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[8];
        inputStream.mark(9);
        int n = inputStream.read(byArray, 0, 8);
        inputStream.reset();
        return n == 8 && byArray[0] == -48 && byArray[1] == -49 && byArray[2] == 17 && byArray[3] == -32 && byArray[4] == -95 && byArray[5] == -79 && byArray[6] == 26 && byArray[7] == -31;
    }

    public static boolean isCompoundDocument(byte[] byArray) {
        return byArray.length >= 8 && byArray[0] == -48 && byArray[1] == -49 && byArray[2] == 17 && byArray[3] == -32 && byArray[4] == -95 && byArray[5] == -79 && byArray[6] == 26 && byArray[7] == -31;
    }

    public Vector getDirectory() {
        return this.directory;
    }

    public String getDirectoryListing(String string) {
        String string2 = "";
        for (int i = 0; i < this.directory.size(); ++i) {
            CmpDocDirectoryEntry cmpDocDirectoryEntry = (CmpDocDirectoryEntry)this.directory.get(i);
            if (cmpDocDirectoryEntry.isEmpty) continue;
            string2 = string2 + string + cmpDocDirectoryEntry.entryName + "\tlen=" + cmpDocDirectoryEntry.lenStream + "\tSID=" + cmpDocDirectoryEntry.SIDfirstSector + (cmpDocDirectoryEntry.isStandard ? "\tfileOffset=" + this.getOffset(cmpDocDirectoryEntry.SIDfirstSector) : "");
        }
        return string2;
    }

    public StringBuffer getAllData() {
        this.data = new StringBuffer();
        this.data.append("Compound Document File Directory: ");
        this.data.append(this.getDirectoryListing("|"));
        this.data.append("\n");
        for (int i = 0; i < this.directory.size(); ++i) {
            CmpDocDirectoryEntry cmpDocDirectoryEntry = (CmpDocDirectoryEntry)this.directory.get(i);
            if (cmpDocDirectoryEntry.isEmpty || cmpDocDirectoryEntry.entryType == 5) continue;
            this.data.append("BEGIN Compound Document Entry: ").append(cmpDocDirectoryEntry.entryName).append("\n");
            this.data.append(this.getFileAsString(cmpDocDirectoryEntry));
            this.data.append("\n");
            this.data.append("END Compound Document Entry: ").append(cmpDocDirectoryEntry.entryName).append("\n");
        }
        return this.data;
    }

    public StringBuffer getFileAsString(String string) {
        for (int i = 0; i < this.directory.size(); ++i) {
            CmpDocDirectoryEntry cmpDocDirectoryEntry = (CmpDocDirectoryEntry)this.directory.get(i);
            if (!cmpDocDirectoryEntry.entryName.equals(string)) continue;
            return this.getFileAsString(cmpDocDirectoryEntry);
        }
        return new StringBuffer();
    }

    private long getOffset(int n) {
        return 512 + n * this.sectorSize;
    }

    private void gotoSector(int n) {
        this.seek(this.getOffset(n));
    }

    private boolean readHeader() {
        if (!this.header.readData()) {
            return false;
        }
        this.sectorSize = 1 << this.header.sectorPower;
        this.shortSectorSize = 1 << this.header.shortSectorPower;
        this.nShortSectorsPerStandardSector = this.sectorSize / this.shortSectorSize;
        this.nIntPerSector = this.sectorSize / 4;
        this.nDirEntriesperSector = this.sectorSize / 128;
        if (Logger.debugging) {
            Logger.debug("compound document: revNum=" + this.header.revNumber + " verNum=" + this.header.verNumber + " isBigEndian=" + this.isBigEndian + " bytes per standard/short sector=" + this.sectorSize + "/" + this.shortSectorSize);
        }
        return true;
    }

    private void getSectorAllocationTable() {
        block9: {
            int n = 0;
            this.SAT = new int[this.header.nSATsectors * this.nIntPerSector + 109];
            try {
                int n2;
                int n3;
                for (n3 = 0; n3 < 109 && (n2 = this.header.MSAT0[n3]) >= 0; ++n3) {
                    this.gotoSector(n2);
                    for (int i = 0; i < this.nIntPerSector; ++i) {
                        this.SAT[n++] = this.readInt();
                    }
                }
                n3 = this.header.nAdditionalMATsectors;
                n2 = this.header.SID_MSAT_next;
                int[] nArray = new int[this.nIntPerSector];
                while (n3-- > 0 && n2 >= 0) {
                    int n4;
                    this.gotoSector(n2);
                    for (n4 = 0; n4 < this.nIntPerSector; ++n4) {
                        nArray[n4] = this.readInt();
                    }
                    for (n4 = 0; n4 < this.nIntPerSector - 1; ++n4) {
                        n2 = nArray[n4];
                        if (n2 >= 0) {
                            this.gotoSector(n2);
                            int n5 = this.nIntPerSector;
                            while (--n5 >= 0) {
                                this.SAT[n++] = this.readInt();
                            }
                            continue;
                        }
                        break block9;
                    }
                    n2 = nArray[this.nIntPerSector - 1];
                }
            }
            catch (Exception exception) {
                Logger.error(null, exception);
            }
        }
    }

    private void getShortSectorAllocationTable() {
        int n = 0;
        int n2 = this.header.SID_SSAT_start;
        int n3 = this.header.nSATsectors * this.nIntPerSector * 2;
        this.SSAT = new int[n3];
        try {
            while (n2 > 0 && n < n3) {
                this.gotoSector(n2);
                for (int i = 0; i < this.nIntPerSector; ++i) {
                    this.SSAT[n++] = this.readInt();
                }
                n2 = this.SAT[n2];
            }
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
    }

    private void getDirectoryTable() {
        int n = this.header.SID_DIR_start;
        this.rootEntry = null;
        try {
            while (n > 0) {
                this.gotoSector(n);
                int n2 = this.nDirEntriesperSector;
                while (--n2 >= 0) {
                    CmpDocDirectoryEntry cmpDocDirectoryEntry = new CmpDocDirectoryEntry();
                    cmpDocDirectoryEntry.readData();
                    if (cmpDocDirectoryEntry.lenStream > 0) {
                        this.directory.addElement(cmpDocDirectoryEntry);
                    }
                    if (cmpDocDirectoryEntry.entryType != 5) continue;
                    this.rootEntry = cmpDocDirectoryEntry;
                }
                n = this.SAT[n];
            }
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
    }

    private StringBuffer getFileAsString(CmpDocDirectoryEntry cmpDocDirectoryEntry) {
        if (cmpDocDirectoryEntry.isEmpty) {
            return new StringBuffer();
        }
        return cmpDocDirectoryEntry.isStandard ? this.getStandardStringData(cmpDocDirectoryEntry.SIDfirstSector, cmpDocDirectoryEntry.lenStream) : this.getShortStringData(cmpDocDirectoryEntry.SIDfirstSector, cmpDocDirectoryEntry.lenStream);
    }

    private StringBuffer getStandardStringData(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[this.sectorSize];
        try {
            while (n > 0 && n2 > 0) {
                this.gotoSector(n);
                this.readByteArray(byArray);
                for (int i = 0; i < this.sectorSize; ++i) {
                    if (byArray[i] == 0) {
                        return new StringBuffer();
                    }
                    stringBuffer.append((char)byArray[i]);
                    if (--n2 == 0) break;
                }
                n = this.SAT[n];
            }
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
        return stringBuffer;
    }

    private StringBuffer getShortStringData(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[this.shortSectorSize];
        int n3 = 0;
        if (this.rootEntry == null) {
            return stringBuffer;
        }
        try {
            int n4 = this.rootEntry.SIDfirstSector;
            while (n4 >= 0 && n >= 0 && n2 > 0) {
                while (n - n3 >= this.nShortSectorsPerStandardSector) {
                    n3 += this.nShortSectorsPerStandardSector;
                    n4 = this.SAT[n4];
                }
                this.seek(this.getOffset(n4) + (long)((n - n3) * this.shortSectorSize));
                this.readByteArray(byArray);
                for (int i = 0; i < this.shortSectorSize; ++i) {
                    if (byArray[i] == 0) {
                        return new StringBuffer();
                    }
                    stringBuffer.append((char)byArray[i]);
                    if (--n2 == 0) break;
                }
                n = this.SSAT[n];
            }
        }
        catch (Exception exception) {
            Logger.error(stringBuffer.toString());
            Logger.error(null, exception);
        }
        return stringBuffer;
    }

    class CmpDocDirectoryEntry {
        byte[] unicodeName = new byte[64];
        short nBytesUnicodeName;
        byte entryType;
        byte[] uniqueID = new byte[16];
        byte[] userflags = new byte[4];
        int SIDfirstSector;
        int lenStream;
        byte[] unused = new byte[4];
        String entryName;
        boolean isStandard;
        boolean isEmpty;

        CmpDocDirectoryEntry() {
        }

        final boolean readData() {
            try {
                CompoundDocument.this.readByteArray(this.unicodeName);
                this.nBytesUnicodeName = CompoundDocument.this.readShort();
                this.entryType = CompoundDocument.this.readByte();
                CompoundDocument.this.readByte();
                CompoundDocument.this.readInt();
                CompoundDocument.this.readInt();
                CompoundDocument.this.readInt();
                CompoundDocument.this.readByteArray(this.uniqueID);
                CompoundDocument.this.readByteArray(this.userflags);
                CompoundDocument.this.readLong();
                CompoundDocument.this.readLong();
                this.SIDfirstSector = CompoundDocument.this.readInt();
                this.lenStream = CompoundDocument.this.readInt();
                CompoundDocument.this.readByteArray(this.unused);
            }
            catch (Exception exception) {
                Logger.error(null, exception);
                return false;
            }
            this.entryName = "";
            for (int i = 0; i < this.nBytesUnicodeName - 2; i += 2) {
                this.entryName = this.entryName + (char)this.unicodeName[i];
            }
            this.isStandard = this.entryType == 5 || this.lenStream >= CompoundDocument.this.header.minBytesStandardStream;
            this.isEmpty = this.entryType == 0 || this.lenStream <= 0;
            return true;
        }
    }

    class CmpDocHeader {
        byte[] magicNumbers = new byte[8];
        byte[] uniqueID = new byte[16];
        byte revNumber;
        byte verNumber;
        short sectorPower;
        short shortSectorPower;
        byte[] unused = new byte[10];
        int nSATsectors;
        int SID_DIR_start;
        byte[] unused2 = new byte[4];
        int minBytesStandardStream;
        int SID_SSAT_start;
        int SID_MSAT_next;
        int nAdditionalMATsectors;
        int[] MSAT0 = new int[109];

        CmpDocHeader() {
        }

        final boolean readData() {
            try {
                CompoundDocument.this.readByteArray(this.magicNumbers, 0, 8);
                if (this.magicNumbers[0] != -48 || this.magicNumbers[1] != -49 || this.magicNumbers[2] != 17 || this.magicNumbers[3] != -32 || this.magicNumbers[4] != -95 || this.magicNumbers[5] != -79 || this.magicNumbers[6] != 26 || this.magicNumbers[7] != -31) {
                    return false;
                }
                CompoundDocument.this.readByteArray(this.uniqueID);
                this.revNumber = CompoundDocument.this.readByte();
                CompoundDocument.this.readByte();
                this.verNumber = CompoundDocument.this.readByte();
                CompoundDocument.this.readByte();
                byte by = CompoundDocument.this.readByte();
                byte by2 = CompoundDocument.this.readByte();
                CompoundDocument.this.isBigEndian = by == -1 && by2 == -2;
                this.sectorPower = CompoundDocument.this.readShort();
                this.shortSectorPower = CompoundDocument.this.readShort();
                CompoundDocument.this.readByteArray(this.unused);
                this.nSATsectors = CompoundDocument.this.readInt();
                this.SID_DIR_start = CompoundDocument.this.readInt();
                CompoundDocument.this.readByteArray(this.unused2);
                this.minBytesStandardStream = CompoundDocument.this.readInt();
                this.SID_SSAT_start = CompoundDocument.this.readInt();
                CompoundDocument.this.readInt();
                this.SID_MSAT_next = CompoundDocument.this.readInt();
                this.nAdditionalMATsectors = CompoundDocument.this.readInt();
                for (int i = 0; i < 109; ++i) {
                    this.MSAT0[i] = CompoundDocument.this.readInt();
                }
            }
            catch (Exception exception) {
                Logger.error(null, exception);
                return false;
            }
            return true;
        }
    }
}

