/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.shape.FontLineShapeRenderer;
import org.jmol.shape.Measures;

public class MeasuresRenderer
extends FontLineShapeRenderer {
    private boolean showMeasurementLabels;
    private short measurementMad;
    private Font3D font3d;
    private Measurement measurement;
    private boolean doJustify;
    private Point3i ptA = new Point3i();
    private Point3i ptB = new Point3i();
    private AxisAngle4f aaT = new AxisAngle4f();
    private Matrix3f matrixT = new Matrix3f();
    private Point3f pointT = new Point3f();

    protected void render() {
        if (!this.viewer.getShowMeasurements() || !this.g3d.checkTranslucent(false)) {
            return;
        }
        this.antialias = this.g3d.isAntialiased();
        Measures measures = (Measures)this.shape;
        this.doJustify = this.viewer.getJustifyMeasurements();
        this.measurementMad = measures.mad;
        this.font3d = measures.font3d;
        this.showMeasurementLabels = this.viewer.getShowMeasurementLabels();
        measures.setVisibilityInfo();
        boolean bl = this.viewer.getDynamicMeasurements();
        int n = measures.measurementCount;
        while (--n >= 0) {
            Measurement measurement = measures.measurements[n];
            if (bl || measurement.isDynamic()) {
                measurement.refresh();
            }
            if (!measurement.isVisible()) continue;
            this.colix = measurement.getColix();
            if (this.colix == 0) {
                this.colix = measures.colix;
            }
            if (this.colix == 0) {
                this.colix = this.viewer.getColixBackgroundContrast();
            }
            this.g3d.setColix(this.colix);
            this.renderMeasurement(measurement);
        }
        this.renderPendingMeasurement(measures.pendingMeasurement);
    }

    private void renderMeasurement(Measurement measurement) {
        this.renderMeasurement(measurement.getCount(), measurement, true);
    }

    private void renderMeasurement(int n, Measurement measurement, boolean bl) {
        this.measurement = measurement;
        switch (n) {
            case 2: {
                this.renderDistance(this.modelSet.getAtomAt(measurement.getIndex(1)), this.modelSet.getAtomAt(measurement.getIndex(2)));
                break;
            }
            case 3: {
                this.renderAngle(this.modelSet.getAtomAt(measurement.getIndex(1)), this.modelSet.getAtomAt(measurement.getIndex(2)), this.modelSet.getAtomAt(measurement.getIndex(3)), bl);
                break;
            }
            case 4: {
                this.renderTorsion(this.modelSet.getAtomAt(measurement.getIndex(1)), this.modelSet.getAtomAt(measurement.getIndex(2)), this.modelSet.getAtomAt(measurement.getIndex(3)), this.modelSet.getAtomAt(measurement.getIndex(4)), bl);
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
    }

    private int drawSegment(int n, int n2, int n3, int n4, int n5, int n6) {
        this.ptA.set(n, n2, n3);
        this.ptB.set(n4, n5, n6);
        if (this.measurementMad < 0) {
            this.g3d.drawDashedLine(4, 2, this.ptA, this.ptB);
            return 1;
        }
        short s = this.measurementMad;
        if (this.measurementMad >= 20) {
            s = this.viewer.scaleToScreen((n3 + n6) / 2, this.measurementMad);
        }
        this.g3d.fillCylinder((byte)2, s, this.ptA, this.ptB);
        return (s + 1) / 2;
    }

    void renderDistance(Atom atom, Atom atom2) {
        int n;
        int n2;
        int n3 = atom.screenZ - atom.screenDiameter - 10;
        int n4 = atom2.screenZ - atom2.screenDiameter - 10;
        int n5 = this.drawSegment(atom.screenX, atom.screenY, n3, atom2.screenX, atom2.screenY, n4);
        int n6 = (n3 + n4) / 2;
        if (n6 < 1) {
            n6 = 1;
        }
        this.paintMeasurementString(n2, n, n6, n5, ((n2 = (atom.screenX + atom2.screenX) / 2) - atom.screenX) * ((n = (atom.screenY + atom2.screenY) / 2) - atom.screenY) > 0, 0);
    }

    private void renderAngle(Atom atom, Atom atom2, Atom atom3, boolean bl) {
        int n = atom.screenZ - atom.screenDiameter - 10;
        int n2 = atom2.screenZ - atom2.screenDiameter - 10;
        int n3 = atom3.screenZ - atom3.screenDiameter - 10;
        int n4 = (n + n2 + n3) / 3;
        int n5 = this.drawSegment(atom.screenX, atom.screenY, n, atom2.screenX, atom2.screenY, n2);
        n5 += this.drawSegment(atom2.screenX, atom2.screenY, n2, atom3.screenX, atom3.screenY, n3);
        n5 = (n5 + 1) / 2;
        if (!bl) {
            return;
        }
        AxisAngle4f axisAngle4f = this.measurement.getAxisAngle();
        if (axisAngle4f == null) {
            int n6 = this.antialias ? 10 : 5;
            this.paintMeasurementString(atom2.screenX + n6, atom2.screenY - n6, n2, n5, false, 0);
            return;
        }
        int n7 = (int)((double)axisAngle4f.angle / (Math.PI * 2) * 64.0);
        float f = axisAngle4f.angle / (float)n7;
        this.aaT.set(axisAngle4f);
        int n8 = n7 / 2;
        Point3f point3f = this.measurement.getPointArc();
        int n9 = n7;
        while (--n9 >= 0) {
            this.aaT.angle = (float)n9 * f;
            this.matrixT.set(this.aaT);
            this.pointT.set(point3f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(atom2);
            Point3i point3i = this.viewer.transformPoint(this.pointT);
            int n10 = point3i.z - n4;
            if (n10 < 0) {
                n10 = 0;
            }
            this.g3d.drawPixel(point3i.x, point3i.y, n10);
            if (n9 != n8) continue;
            this.pointT.set(point3f);
            this.pointT.scale(1.1f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(atom2);
            Point3i point3i2 = this.viewer.transformPoint(this.pointT);
            int n11 = point3i2.z - n4;
            this.paintMeasurementString(point3i2.x, point3i2.y, n11, n5, point3i2.x < atom2.screenX, atom2.screenY);
        }
    }

    private void renderTorsion(Atom atom, Atom atom2, Atom atom3, Atom atom4, boolean bl) {
        int n = atom.screenZ - atom.screenDiameter - 10;
        int n2 = atom2.screenZ - atom2.screenDiameter - 10;
        int n3 = atom3.screenZ - atom3.screenDiameter - 10;
        int n4 = atom4.screenZ - atom4.screenDiameter - 10;
        int n5 = this.drawSegment(atom.screenX, atom.screenY, n, atom2.screenX, atom2.screenY, n2);
        n5 += this.drawSegment(atom2.screenX, atom2.screenY, n2, atom3.screenX, atom3.screenY, n3);
        n5 += this.drawSegment(atom3.screenX, atom3.screenY, n3, atom4.screenX, atom4.screenY, n4);
        this.paintMeasurementString((atom.screenX + atom2.screenX + atom3.screenX + atom4.screenX) / 4, (atom.screenY + atom2.screenY + atom3.screenY + atom4.screenY) / 4, (n + n2 + n3 + n4) / 4, n5 /= 3, false, 0);
    }

    private void paintMeasurementString(int n, int n2, int n3, int n4, boolean bl, int n5) {
        String string;
        if (!this.showMeasurementLabels) {
            return;
        }
        if (!this.doJustify) {
            bl = false;
            n5 = n2;
        }
        if ((string = this.measurement.getString()) == null) {
            return;
        }
        int n6 = this.font3d.fontMetrics.stringWidth(string);
        int n7 = this.font3d.fontMetrics.getAscent();
        if (this.antialias) {
            n6 <<= 1;
            n7 <<= 1;
        }
        int n8 = n;
        n8 = bl ? (n8 -= n4 / 2 + 2 + n6) : (n8 += n4 / 2 + 2);
        int n9 = n2 + (n5 == 0 || n5 < n2 ? n7 : -n4 / 2);
        int n10 = n3 - n4 - 2;
        if (n10 < 1) {
            n10 = 1;
        }
        this.g3d.drawString(string, this.font3d, n8, n9, n10, n10);
    }

    private void renderPendingMeasurement(MeasurementPending measurementPending) {
        if (this.isGenerator) {
            return;
        }
        int n = measurementPending.getCount();
        if (!measurementPending.getIsActive() || n < 2) {
            return;
        }
        this.g3d.setColix(this.viewer.getColixRubberband());
        if (measurementPending.getLastIndex() == -1) {
            this.renderPendingWithCursor(measurementPending);
        } else {
            this.renderMeasurement(measurementPending);
        }
    }

    private void renderPendingWithCursor(MeasurementPending measurementPending) {
        int n = measurementPending.getCount();
        if (n < 2) {
            return;
        }
        if (n > 2) {
            this.renderMeasurement(n - 1, measurementPending, false);
        }
        Atom atom = this.modelSet.getAtomAt(measurementPending.getPreviousIndex());
        int n2 = atom.screenZ - atom.screenDiameter - 10;
        int n3 = this.viewer.getCursorX();
        int n4 = this.viewer.getCursorY();
        if (this.g3d.isAntialiased()) {
            n3 <<= 1;
            n4 <<= 1;
        }
        this.drawSegment(atom.screenX, atom.screenY, n2, n3, n4, 0);
    }
}

