/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Quaternion;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public abstract class BioPolymer
extends Polymer {
    Monomer[] monomers;
    int monomerCount;
    protected Model model;
    private float sheetSmoothing;
    private final Vector3f unitVectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    private int selectedMonomerCount;
    BitSet bsSelectedMonomers;

    public Monomer[] getMonomers() {
        return this.monomers;
    }

    public int getMonomerCount() {
        return this.monomerCount;
    }

    public Model getModel() {
        return this.model;
    }

    BioPolymer(Monomer[] monomerArray) {
        this.monomers = monomerArray;
        int n = this.monomerCount = monomerArray.length;
        while (--n >= 0) {
            monomerArray[n].setBioPolymer(this, n);
        }
        this.model = monomerArray[0].getModel();
    }

    static BioPolymer allocateBioPolymer(Group[] groupArray, int n) {
        Monomer[] monomerArray = BioPolymer.getAminoMonomers(groupArray, n);
        if (monomerArray != null) {
            return new AminoPolymer(monomerArray);
        }
        monomerArray = BioPolymer.getAlphaMonomers(groupArray, n);
        if (monomerArray != null) {
            return new AlphaPolymer(monomerArray);
        }
        monomerArray = BioPolymer.getNucleicMonomers(groupArray, n);
        if (monomerArray != null) {
            return new NucleicPolymer(monomerArray);
        }
        monomerArray = BioPolymer.getPhosphorusMonomers(groupArray, n);
        if (monomerArray != null) {
            return new PhosphorusPolymer(monomerArray);
        }
        monomerArray = BioPolymer.getCarbohydrateMonomers(groupArray, n);
        if (monomerArray != null) {
            return new CarbohydratePolymer(monomerArray);
        }
        Logger.error("Polymer.allocatePolymer() ... why am I here?");
        throw new NullPointerException();
    }

    private static Monomer[] getAlphaMonomers(Group[] groupArray, int n) {
        Group group;
        AlphaMonomer alphaMonomer = null;
        int n2 = 0;
        int n3 = n;
        while (n3 < groupArray.length && (group = groupArray[n3]) instanceof AlphaMonomer) {
            AlphaMonomer alphaMonomer2 = (AlphaMonomer)group;
            if (alphaMonomer2.bioPolymer != null || !alphaMonomer2.isConnectedAfter(alphaMonomer)) break;
            alphaMonomer = alphaMonomer2;
            ++n3;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (AlphaMonomer)groupArray[n + i];
        }
        return monomerArray;
    }

    private static Monomer[] getAminoMonomers(Group[] groupArray, int n) {
        Group group;
        AminoMonomer aminoMonomer = null;
        int n2 = 0;
        int n3 = n;
        while (n3 < groupArray.length && (group = groupArray[n3]) instanceof AminoMonomer) {
            AminoMonomer aminoMonomer2 = (AminoMonomer)group;
            if (aminoMonomer2.bioPolymer != null || !aminoMonomer2.isConnectedAfter(aminoMonomer)) break;
            aminoMonomer = aminoMonomer2;
            ++n3;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (AminoMonomer)groupArray[n + i];
        }
        return monomerArray;
    }

    private static Monomer[] getCarbohydrateMonomers(Group[] groupArray, int n) {
        Group group;
        int n2 = 0;
        int n3 = n;
        while (n3 < groupArray.length && (group = groupArray[n3]) instanceof CarbohydrateMonomer) {
            CarbohydrateMonomer carbohydrateMonomer = (CarbohydrateMonomer)group;
            if (carbohydrateMonomer.bioPolymer != null) break;
            ++n3;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (CarbohydrateMonomer)groupArray[n + i];
        }
        return monomerArray;
    }

    private static Monomer[] getPhosphorusMonomers(Group[] groupArray, int n) {
        Group group;
        PhosphorusMonomer phosphorusMonomer = null;
        int n2 = 0;
        int n3 = n;
        while (n3 < groupArray.length && (group = groupArray[n3]) instanceof PhosphorusMonomer) {
            PhosphorusMonomer phosphorusMonomer2 = (PhosphorusMonomer)group;
            if (phosphorusMonomer2.bioPolymer != null || !phosphorusMonomer2.isConnectedAfter(phosphorusMonomer)) break;
            phosphorusMonomer = phosphorusMonomer2;
            ++n3;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (PhosphorusMonomer)groupArray[n + i];
        }
        return monomerArray;
    }

    private static Monomer[] getNucleicMonomers(Group[] groupArray, int n) {
        Group group;
        NucleicMonomer nucleicMonomer = null;
        int n2 = 0;
        int n3 = n;
        while (n3 < groupArray.length && (group = groupArray[n3]) instanceof NucleicMonomer) {
            NucleicMonomer nucleicMonomer2 = (NucleicMonomer)group;
            if (nucleicMonomer2.bioPolymer != null || !nucleicMonomer2.isConnectedAfter(nucleicMonomer)) break;
            nucleicMonomer = nucleicMonomer2;
            ++n3;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (NucleicMonomer)groupArray[n + i];
        }
        return monomerArray;
    }

    public void clearStructures() {
        for (int i = 0; i < this.monomerCount; ++i) {
            this.monomers[i].setStructure(null);
        }
    }

    void removeProteinStructure(int n, int n2) {
        int n3 = 0;
        for (int i = n; n3 < n2 && i < this.monomerCount; ++n3, ++i) {
            this.monomers[i].setStructure(null);
        }
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            int n = this.monomerCount;
            while (--n >= 0) {
                this.leadAtomIndices[n] = this.monomers[n].getLeadAtomIndex();
            }
        }
        return this.leadAtomIndices;
    }

    int getIndex(char c, int n) {
        int n2 = this.monomerCount;
        while (--n2 >= 0 && (this.monomers[n2].getSeqcode() != n || this.monomers[n2].getChainID() != c)) {
        }
        return n2;
    }

    final Point3f getLeadPoint(int n) {
        return this.monomers[n].getLeadAtomPoint();
    }

    final Point3f getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    final Point3f getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int n, Point3f point3f) {
        if (n == this.monomerCount) {
            --n;
        } else if (n > 0) {
            point3f.set(this.getLeadPoint(n));
            point3f.add(this.getLeadPoint(n - 1));
            point3f.scale(0.5f);
            return;
        }
        point3f.set(this.getLeadPoint(n));
    }

    void getLeadPoint(int n, Point3f point3f) {
        if (n == this.monomerCount) {
            --n;
        }
        point3f.set(this.getLeadPoint(n));
    }

    boolean hasWingPoints() {
        return false;
    }

    final Point3f getWingPoint(int n) {
        return this.monomers[n].getWingAtomPoint();
    }

    final Point3f getPointPoint(int n) {
        return this.monomers[n].getPointAtomPoint();
    }

    public void addSecondaryStructure(byte by, char c, int n, char c2, int n2) {
    }

    public void calculateStructures() {
    }

    public void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
    }

    public void setConformation(BitSet bitSet, int n) {
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            this.monomers[n2].updateOffsetsForAlternativeLocations(bitSet, n);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.leadAtomIndices = null;
        this.sheetPoints = null;
        this.getLeadAtomIndices();
        this.calcLeadMidpointsAndWingVectors(false);
    }

    public Point3f[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.leadMidpoints;
    }

    Point3f[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.leadPoints;
    }

    public Point3f[] getControlPoints(boolean bl, float f) {
        if (!bl) {
            return this.leadMidpoints;
        }
        if (f == 0.0f) {
            return this.leadPoints;
        }
        return this.getSheetPoints(f);
    }

    private Point3f[] getSheetPoints(float f) {
        if (this.sheetPoints != null && f == this.sheetSmoothing) {
            return this.sheetPoints;
        }
        this.sheetPoints = new Point3f[this.monomerCount + 1];
        this.getLeadPoints();
        for (int i = 0; i < this.monomerCount; ++i) {
            this.sheetPoints[i] = new Point3f();
        }
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (this.monomers[i].isSheet()) {
                vector3f.sub(this.leadMidpoints[i], this.leadPoints[i]);
                vector3f.scale(f);
                this.sheetPoints[i].add(this.leadPoints[i], vector3f);
                continue;
            }
            this.sheetPoints[i] = this.leadPoints[i];
        }
        this.sheetPoints[this.monomerCount] = this.sheetPoints[this.monomerCount - 1];
        this.sheetSmoothing = f;
        return this.sheetPoints;
    }

    public final Vector3f[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors(true);
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors(boolean bl) {
        Point3f point3f;
        int n = this.monomerCount;
        if (this.leadMidpoints == null || bl) {
            this.leadMidpoints = new Point3f[n + 1];
            this.leadPoints = new Point3f[n + 1];
            this.wingVectors = new Vector3f[n + 1];
            this.sheetSmoothing = Float.MIN_VALUE;
        }
        boolean bl2 = this.hasWingPoints();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = point3f = this.getLeadPoint(0);
        Vector3f vector3f5 = null;
        for (int i = 1; i < n; ++i) {
            Point3f point3f2 = point3f;
            this.leadPoints[i] = point3f = this.getLeadPoint(i);
            Point3f point3f3 = new Point3f(point3f);
            point3f3.add(point3f2);
            point3f3.scale(0.5f);
            this.leadMidpoints[i] = point3f3;
            if (!bl2) continue;
            vector3f.sub(point3f, point3f2);
            vector3f2.sub(point3f2, this.getWingPoint(i - 1));
            vector3f3.cross(vector3f, vector3f2);
            vector3f4.cross(vector3f, vector3f3);
            vector3f4.normalize();
            if (vector3f5 != null && (double)vector3f5.angle(vector3f4) > 1.5707963267948966) {
                vector3f4.scale(-1.0f);
            }
            vector3f5 = this.wingVectors[i] = new Vector3f(vector3f4);
        }
        this.leadPoints[n] = this.leadMidpoints[n] = this.getTerminatorPoint();
        if (!bl2) {
            if (n < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                Vector3f vector3f6 = null;
                for (int i = 1; i < n; ++i) {
                    vector3f.sub(this.leadMidpoints[i], this.leadPoints[i]);
                    vector3f2.sub(this.leadPoints[i], this.leadMidpoints[i + 1]);
                    vector3f3.cross(vector3f, vector3f2);
                    vector3f3.normalize();
                    if (vector3f6 != null && (double)vector3f6.angle(vector3f3) > 1.5707963267948966) {
                        vector3f3.scale(-1.0f);
                    }
                    vector3f6 = this.wingVectors[i] = new Vector3f(vector3f3);
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[n] = this.wingVectors[n - 1];
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short[] sArray, int n3) {
        int n4 = this.monomerCount;
        while (--n4 >= 0) {
            if ((this.monomers[n4].shapeVisibilityFlags & n3) == 0 || this.model.isAtomHidden(this.monomers[n4].getLeadAtomIndex()) || sArray[n4] <= 0 && sArray[n4 + 1] <= 0) continue;
            this.monomers[n4].findNearestAtomIndex(n, n2, atomArray, sArray[n4], sArray[n4 + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BitSet();
        }
        BitSetUtil.clear(this.bsSelectedMonomers);
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bitSet)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    boolean isMonomerSelected(int n) {
        return n >= 0 && this.bsSelectedMonomers.get(n);
    }

    public int getPolymerPointsAndVectors(int n, BitSet bitSet, Vector vector, boolean bl, float f) {
        Point3f[] point3fArray = this.getControlPoints(bl, f);
        Vector3f[] vector3fArray = this.getWingVectors();
        int n2 = this.monomerCount;
        for (int i = 0; i < n2; ++i) {
            if (bitSet.get(this.monomers[i].getLeadAtomIndex())) {
                vector.addElement(new Point3f[]{point3fArray[i], new Point3f(vector3fArray[i])});
                n = i;
                continue;
            }
            if (n == 0x7FFFFFFE) continue;
            vector.addElement(new Point3f[]{point3fArray[i], new Point3f(vector3fArray[i])});
            n = 0x7FFFFFFE;
        }
        if (n + 1 < n2) {
            vector.addElement(new Point3f[]{point3fArray[n + 1], new Point3f(vector3fArray[n + 1])});
        }
        return n;
    }

    public String getSequence() {
        char[] cArray = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount; ++i) {
            cArray[i] = this.monomers[i].getGroup1();
        }
        return String.valueOf(cArray);
    }

    public Hashtable getPolymerInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!bitSet.get(this.monomers[i].getLeadAtomIndex())) continue;
            Hashtable hashtable2 = this.monomers[i].getMyInfo();
            hashtable2.put("monomerIndex", new Integer(i));
            vector.addElement(hashtable2);
        }
        if (vector.size() > 0) {
            hashtable.put("sequence", this.getSequence());
            hashtable.put("monomers", vector);
        }
        return hashtable;
    }

    public void getPolymerSequenceAtoms(int n, int n2, int n3, int n4, BitSet bitSet, BitSet bitSet2) {
        int n5 = n3 + n4;
        for (int i = n3; i < this.monomerCount && i < n5; ++i) {
            this.monomers[i].getMonomerSequenceAtoms(bitSet, bitSet2);
        }
    }

    public ProteinStructure getProteinStructure(int n) {
        return this.monomers[n].getProteinStructure();
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    public static final void getPdbData(BioPolymer bioPolymer, char c, boolean bl, BitSet bitSet, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        boolean bl2;
        int n = Integer.MIN_VALUE;
        Quaternion quaternion = null;
        Quaternion quaternion2 = null;
        float f = c == 'r' ? 1.0f : 10.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl3 = bl2 = c == 'r';
        if (bl2 && !bioPolymer.calcPhiPsiAngles()) {
            return;
        }
        for (int i = 0; i < bioPolymer.monomerCount; ++i) {
            Monomer monomer = bioPolymer.monomers[i];
            if (!bitSet.get(monomer.getLeadAtomIndex())) continue;
            Atom atom = monomer.getLeadAtom();
            if (bl2) {
                f2 = monomer.getPhi();
                f3 = monomer.getPsi();
                f4 = monomer.getOmega();
                if (f4 < -90.0f) {
                    f4 += 360.0f;
                }
                if (Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4 -= 180.0f)) continue;
                f5 = atom.getPartialCharge();
            } else {
                Quaternion quaternion3 = monomer.getQuaternion();
                if (quaternion3 == null) {
                    quaternion = null;
                    n = Integer.MIN_VALUE;
                    continue;
                }
                if (bl) {
                    if (quaternion2 == null) {
                        quaternion2 = quaternion3;
                        continue;
                    }
                    if (quaternion3.dot(quaternion2) < 0.0f) {
                        quaternion3 = quaternion3.mul(-1.0f);
                    }
                    Quaternion quaternion4 = quaternion3;
                    quaternion3 = quaternion2.inv().mul(quaternion3);
                    quaternion2 = quaternion4;
                }
                if (quaternion != null && quaternion3.dot(quaternion) < 0.0f) {
                    quaternion3 = quaternion3.mul(-1.0f);
                }
                quaternion = quaternion3;
                switch (c) {
                    case 'w': {
                        f2 = quaternion3.q1;
                        f3 = quaternion3.q2;
                        f4 = quaternion3.q3;
                        f5 = quaternion3.q0;
                        break;
                    }
                    case 'x': {
                        f2 = quaternion3.q0;
                        f3 = quaternion3.q1;
                        f4 = quaternion3.q2;
                        f5 = quaternion3.q3;
                        break;
                    }
                    case 'y': {
                        f2 = quaternion3.q3;
                        f3 = quaternion3.q0;
                        f4 = quaternion3.q1;
                        f5 = quaternion3.q2;
                        break;
                    }
                    case 'z': {
                        f2 = quaternion3.q2;
                        f3 = quaternion3.q3;
                        f4 = quaternion3.q0;
                        f5 = quaternion3.q1;
                    }
                }
            }
            stringBuffer.append(atom.formatLabel("ATOM  %5i %4a%1A%3n %1c%4R%1E   "));
            stringBuffer.append(TextFormat.formatString("%8.3x", "x", f2 * f));
            stringBuffer.append(TextFormat.formatString("%8.3x", "x", f3 * f));
            stringBuffer.append(TextFormat.formatString("%8.3x", "x", f4 * f));
            stringBuffer.append(TextFormat.formatString("%6.2x", "x", f5 * f));
            stringBuffer.append(TextFormat.formatString("                %2x    \n", "x", atom.getElementSymbol().toUpperCase()));
            if (n != Integer.MIN_VALUE) {
                stringBuffer2.append("CONECT");
                stringBuffer2.append(TextFormat.formatString("%5i", "i", n));
                stringBuffer2.append(TextFormat.formatString("%5i", "i", atom.getAtomNumber()));
                stringBuffer2.append('\n');
            }
            n = atom.getAtomNumber();
        }
    }
}

