/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolBioResolver;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.CellInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Molecule;
import org.jmol.modelset.Polymer;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public abstract class ModelCollection
extends BondCollection {
    protected String modelSetName;
    protected Model[] models = new Model[1];
    protected int modelCount;
    CellInfo[] cellInfos;
    int[] modelNumbers = new int[1];
    int[] modelFileNumbers = new int[1];
    String[] modelNumbersForAtomLabel = new String[1];
    String[] modelNames = new String[1];
    String[] frameTitles = new String[1];
    protected BitSet[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    Properties modelSetProperties;
    Hashtable modelSetAuxiliaryInfo;
    protected Group[] groups;
    protected int groupCount;
    protected int baseGroupIndex = 0;
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];
    protected boolean haveBioClasses = true;
    protected JmolBioResolver jbr = null;
    protected BitSet structuresDefinedInFile = new BitSet();
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected Molecule[] molecules = new Molecule[4];
    protected int moleculeCount;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Point3f ptTemp = new Point3f();
    private final Point3f averageAtomPoint = new Point3f();
    private boolean isBbcageDefault;
    private BitSet bboxModels;
    private BitSet bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    protected Vector stateScripts;
    private int thisStateModel;
    protected Vector trajectories;
    private String pdbHeader;
    static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};
    private BitSet bsTemp;
    private BitSet selectedMolecules;
    private int selectedMoleculeCount;
    private AtomIteratorWithinModel withinModelIterator;
    private AtomIteratorWithinSet withinAtomSetIterator;
    private BitSet bsAll;
    protected BitSet bsSymmetry;

    public ModelCollection() {
        this.boxInfo.setBbcage();
        this.stateScripts = new Vector();
        this.thisStateModel = 0;
        this.bsTemp = new BitSet();
        this.selectedMolecules = new BitSet();
    }

    void merge(ModelSet modelSet) {
        for (int i = 0; i < modelSet.modelCount; ++i) {
            this.models[i] = modelSet.models[i];
            this.models[i].bsAtoms = null;
            this.stateScripts = modelSet.stateScripts;
            this.thisStateModel = -1;
        }
        super.merge(modelSet);
    }

    protected void releaseModelSet() {
        this.models = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.cellInfos = null;
        this.withinModelIterator = null;
        this.withinAtomSetIterator = null;
        super.releaseModelSet();
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public CellInfo[] getCellInfos() {
        return this.cellInfos;
    }

    public UnitCell getUnitCell(int n) {
        if (n < 0) {
            return null;
        }
        return this.cellInfos == null ? null : this.cellInfos[n].getUnitCell();
    }

    public String getModelName(int n) {
        return this.modelCount < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileName");
    }

    public void setFrameTitle(int n, String string) {
        if (n >= 0 && n < this.modelCount) {
            this.frameTitles[n] = string;
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.modelCount ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    protected void calculatePolymers(BitSet bitSet) {
        if (this.jbr == null) {
            return;
        }
        if (bitSet != null) {
            this.jbr.clearBioPolymers(this.groups, this.groupCount, bitSet);
        }
        for (int i = this.baseGroupIndex; i < this.groupCount; ++i) {
            Polymer polymer = this.jbr.buildBioPolymer(this.groups[i], this.groups, i);
            if (polymer == null) continue;
            this.addBioPolymerToModel(polymer, this.groups[i].getModel());
        }
    }

    protected void addBioPolymerToModel(Polymer polymer, Model model) {
        if (model.bioPolymers.length == 0 || polymer == null) {
            model.bioPolymers = new Polymer[8];
        }
        if (polymer == null) {
            model.bioPolymerCount = 0;
            return;
        }
        if (model.bioPolymerCount == model.bioPolymers.length) {
            model.bioPolymers = (Polymer[])ArrayUtil.doubleLength(model.bioPolymers);
        }
        model.bioPolymers[model.bioPolymerCount++] = polymer;
    }

    public float[] getNotionalUnitcell() {
        return this.cellInfos == null || this.cellInfos[0] == null ? null : this.cellInfos[0].getNotionalUnitCell();
    }

    public boolean haveSymmetry() {
        return this.someModelsHaveSymmetry;
    }

    public Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    public Point3f getBoundBoxCenter() {
        return this.boxInfo.getBoundBoxCenter();
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3f[] getBboxVertices() {
        return this.boxInfo.getBboxVertices();
    }

    public Hashtable getBoundBoxInfo() {
        return this.boxInfo.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl) {
        if (point3f.distance(point3f2) == 0.0f) {
            return;
        }
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(point3f, point3f2, bl);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.escape(this.bboxAtoms);
        }
        this.ptTemp.set(this.boxInfo.getBoundBoxCenter());
        Vector3f vector3f = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.escape(this.ptTemp) + " " + Escape.escape(vector3f) + "\n#or\n" : "";
        this.ptTemp.sub(vector3f);
        string = string + "boundbox corners " + Escape.escape(this.ptTemp) + " ";
        this.ptTemp.scaleAdd(2.0f, vector3f, this.ptTemp);
        float f = Math.abs(8.0f * vector3f.x * vector3f.y * vector3f.z);
        string = string + Escape.escape(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public void calcBoundBoxDimensions(BitSet bitSet) {
        if (BitSetUtil.firstSetBit(bitSet) < 0) {
            bitSet = null;
        }
        if (bitSet == null && this.isBbcageDefault || this.atomCount < 2) {
            return;
        }
        this.bboxAtoms = BitSetUtil.copy(bitSet);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms);
        if (this.calcAtomsMinMax(bitSet, this.boxInfo) == this.atomCount) {
            this.isBbcageDefault = true;
        }
        if (bitSet == null) {
            this.averageAtomPoint.set(this.getAtomSetCenter(null));
            if (this.cellInfos != null) {
                this.calcUnitCellMinMax();
            }
        }
        this.boxInfo.setBbcage();
    }

    public BoxInfo getBoxInfo(BitSet bitSet) {
        if (bitSet == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bitSet, boxInfo);
        boxInfo.setBbcage();
        return boxInfo;
    }

    private int calcAtomsMinMax(BitSet bitSet, BoxInfo boxInfo) {
        boxInfo.reset();
        int n = 0;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (bitSet != null && !bitSet.get(n2)) continue;
            ++n;
            if (this.isJmolDataFrame(this.atoms[n2])) continue;
            boxInfo.addBoundBoxPoint(this.atoms[n2]);
        }
        return n;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.cellInfos[i].coordinatesAreFractional) continue;
            Point3f[] point3fArray = this.cellInfos[i].getUnitCell().getVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(point3fArray[j]);
            }
        }
    }

    public float calcRotationRadius(BitSet bitSet) {
        Point3f point3f = this.getAtomSetCenter(bitSet);
        float f = 0.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            float f2;
            Atom atom;
            float f3;
            float f4;
            if (!bitSet.get(n) || !((f4 = (f3 = point3f.distance(atom = this.atoms[n])) + (f2 = atom.getVanderwaalsRadiusFloat())) > f)) continue;
            f = f4;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (bitSet == null || BitSetUtil.firstSetBit(bitSet) < 0) {
            return point3f;
        }
        int n = 0;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (bitSet != null && !bitSet.get(n2) || this.isJmolDataFrame(this.atoms[n2])) continue;
            ++n;
            point3f.add(this.atoms[n2]);
        }
        point3f.scale(1.0f / (float)n);
        return point3f;
    }

    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, float[] fArray) {
        super.setAtomProperty(bitSet, n, n2, f, fArray);
        if ((n == 69730327 || n == 69795849) && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds();
        }
    }

    public void addStateScript(String string, boolean bl) {
        if (bl) {
            int n = this.viewer.getCurrentModelIndex();
            if (this.thisStateModel != n) {
                string = "  frame " + (n < 0 ? "" + n : this.getModelNumberDotted(n)) + ";\n" + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        this.stateScripts.addElement(string);
    }

    protected void defineStructure(int n, String string, char c, int n2, char c2, char c3, int n3, char c4) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(n, string, c, Group.getSeqcode(n2, c2), c3, Group.getSeqcode(n3, c4));
    }

    void calculateStructuresAllExcept(BitSet bitSet, boolean bl) {
        this.freezeModels();
        int n = this.modelCount;
        while (--n >= 0) {
            if (!this.models[n].isPDB || bitSet.get(n)) continue;
            this.models[n].calculateStructures();
        }
        if (bl) {
            this.propagateSecondaryStructure();
        }
    }

    private void freezeModels() {
        int n = this.modelCount;
        while (--n >= 0) {
            int n2;
            Model model = this.models[n];
            model.chains = (Chain[])ArrayUtil.setLength(model.chains, model.chainCount);
            model.groupCount = -1;
            model.getGroupCount();
            for (n2 = 0; n2 < model.chainCount; ++n2) {
                model.chains[n2].groups = (Group[])ArrayUtil.setLength(model.chains[n2].groups, this.groupCount);
            }
            model.bioPolymers = (Polymer[])ArrayUtil.setLength(model.bioPolymers, model.bioPolymerCount);
            n2 = model.bioPolymerCount;
            while (--n2 >= 0) {
                model.bioPolymers[n2].freeze();
            }
        }
    }

    public BitSet setConformation(int n, BitSet bitSet) {
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (n2 != n && n >= 0) continue;
            this.models[n2].setConformation(bitSet);
        }
        return bitSet;
    }

    public BitSet setConformation(int n, int n2) {
        BitSet bitSet = new BitSet();
        String string = this.getAltLocListInModel(n);
        if (string.length() > 0) {
            BitSet bitSet2 = this.getModelAtomBitSet(n, true);
            if (n2 >= 0) {
                int n3 = this.models[n].nAltLocs;
                while (--n3 >= 0) {
                    if (n3 == n2) continue;
                    BitSetUtil.andNot(bitSet2, this.getSpecAlternate(string.substring(n3, n3 + 1)));
                }
            }
            if (BitSetUtil.length(bitSet2) > 0) {
                this.setConformation(n, bitSet2);
                bitSet.or(bitSet2);
            }
        }
        return bitSet;
    }

    public Hashtable getHeteroList(int n) {
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Hashtable hashtable2;
            if (n >= 0 && n2 != n || (hashtable2 = (Hashtable)this.getModelAuxiliaryInfo(n2, "hetNames")) == null) continue;
            bl = true;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, hashtable2.get(string));
            }
        }
        return bl ? hashtable : (Hashtable)this.getModelSetAuxiliaryInfo("hetNames");
    }

    void setModelSetProperties(Properties properties) {
        this.modelSetProperties = properties;
    }

    void setModelSetAuxiliaryInfo(Hashtable hashtable) {
        this.modelSetAuxiliaryInfo = hashtable;
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    boolean getModelSetAuxiliaryInfoBoolean(String string) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string) && (Boolean)this.modelSetAuxiliaryInfo.get(string) != false;
    }

    int getModelSetAuxiliaryInfoInt(String string) {
        if (this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string)) {
            return (Integer)this.modelSetAuxiliaryInfo.get(string);
        }
        return Integer.MIN_VALUE;
    }

    protected int getTrajectoryCount() {
        return this.trajectories == null ? 0 : this.trajectories.size();
    }

    public int getTrajectoryIndex(int n) {
        return this.models[n].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int n) {
        return this.models[n].isTrajectory;
    }

    public boolean isTrajectory(int[] nArray) {
        int n;
        if (nArray == null) {
            return false;
        }
        int n2 = n = nArray[0];
        while (--n2 >= 0) {
            if (nArray[n2 + 1] < 0) {
                return false;
            }
            if (!this.models[this.atoms[nArray[n2 + 1]].modelIndex].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BitSet getIterativeModels(boolean bl) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bl && this.isJmolDataFrame(i) || this.models[i].trajectoryBaseIndex != i) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public void selectDisplayedTrajectories(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isTrajectory || this.atoms[this.models[i].firstAtomIndex].modelIndex == i) continue;
            bitSet.clear(i);
        }
    }

    public String getModelNumberDotted(int n) {
        return this.modelCount < 1 || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        return this.modelNumbers[n];
    }

    public int getModelFileNumber(int n) {
        return this.modelFileNumbers[n];
    }

    public Properties getModelProperties(int n) {
        return this.models[n].properties;
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.models[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.models[n].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.models[n].auxiliaryInfo.put(object, object2);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        if (n < 0) {
            return null;
        }
        return this.models[n].auxiliaryInfo.get(string);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Hashtable hashtable = this.models[n].auxiliaryInfo;
        return hashtable != null && hashtable.containsKey(string) && (Boolean)hashtable.get(string) != false;
    }

    protected int getModelAuxiliaryInfoInt(int n, String string) {
        Hashtable hashtable = this.models[n].auxiliaryInfo;
        if (hashtable != null && hashtable.containsKey(string)) {
            return (Integer)hashtable.get(string);
        }
        return Integer.MIN_VALUE;
    }

    Model getModel(int n) {
        return this.models[n];
    }

    public int getInsertionCountInModel(int n) {
        return this.models[n].nInsertions;
    }

    public static int modelFileNumberFromFloat(float f) {
        int n = (int)f;
        int n2 = (int)(((double)(f - (float)n) + 1.0E-5) * 10000.0);
        while (n2 % 10 == 0) {
            n2 /= 10;
        }
        return n * 1000000 + n2;
    }

    public int getAltLocCountInModel(int n) {
        return this.models[n].nAltLocs;
    }

    private void propagateSecondaryStructure() {
        int n = this.structureCount;
        while (--n >= 0) {
            Structure structure = this.structures[n];
            this.models[structure.modelIndex].addSecondaryStructure(structure.type, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
        }
    }

    public int getChainCount(boolean bl) {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getChainCount(bl);
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (this.models[n2].isTrajectory && this.models[n2].trajectoryBaseIndex != n2) continue;
            n += this.models[n2].getBioPolymerCount();
        }
        return n;
    }

    public int getBioPolymerCountInModel(int n) {
        if (n < 0) {
            return this.getBioPolymerCount();
        }
        if (this.models[n].isTrajectory && this.models[n].trajectoryBaseIndex != n) {
            return 0;
        }
        return this.models[n].getBioPolymerCount();
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        boolean bl = this.viewer.getTraceAlpha();
        float f = this.viewer.getSheetSmoothing();
        int n = 0x7FFFFFFE;
        for (int i = 0; i < this.modelCount; ++i) {
            int n2 = this.models[i].getBioPolymerCount();
            for (int j = 0; j < n2; ++j) {
                n = this.models[i].getBioPolymer(j).getPolymerPointsAndVectors(n, bitSet, vector, bl, f);
            }
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (n < 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                this.recalculateLeadMidpointsAndWingVectors(i);
            }
            return;
        }
        int n2 = this.models[n].getBioPolymerCount();
        for (int i = 0; i < n2; ++i) {
            this.models[n].getBioPolymer(i).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.models[n].getBioPolymer(n2).getLeadMidpoints();
    }

    public int getChainCountInModel(int n, boolean bl) {
        if (n < 0) {
            return this.getChainCount(bl);
        }
        return this.models[n].getChainCount(bl);
    }

    public int getGroupCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getGroupCount();
        }
        return n;
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.models[n].getGroupCount();
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedGroupsCount(bitSet);
        }
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedMonomersCount(bitSet);
        }
    }

    public void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].trajectoryBaseIndex != n) continue;
            this.clearCalculatedHydrogenBonds(n, bitSet);
            this.models[n].calcHydrogenBonds(bitSet, bitSet2);
        }
    }

    private String getPdbData(String string, char c, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isJmolDataFrame(n)) {
            n = this.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Model model = this.models[n];
        BitSet bitSet = this.getModelAtomBitSet(n, false);
        int n2 = model.getBioPolymerCount();
        for (int i = 0; i < n2; ++i) {
            model.bioPolymers[i].getPdbData(c, bl, bitSet, stringBuffer2, stringBuffer);
        }
        stringBuffer2.append(stringBuffer);
        return this.getProteinStructureState(bitSet, c == 'r') + stringBuffer2.toString();
    }

    public String getPdbData(int n, String string) {
        if (!this.models[n].isPDB) {
            return null;
        }
        char c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'r';
        String string2 = this.getPdbData(string, c, n, string.indexOf(" deriv") >= 0);
        if (string2.length() == 0) {
            return "";
        }
        String string3 = "REMARK   6 Jmol PDB-encoded data: " + string + " data(x,y,z,charge)=";
        switch (c) {
            case 'w': {
                string3 = string3 + "(x,y,z,w)";
                break;
            }
            case 'x': {
                string3 = string3 + "(y,z,w,x)";
                break;
            }
            case 'y': {
                string3 = string3 + "(z,w,x,y)";
                break;
            }
            case 'z': {
                string3 = string3 + "(w,x,y,z)";
                break;
            }
            case 'r': {
                string3 = string3 + "(phi,psi,omega,partialCharge)";
            }
        }
        string3 = string3 + "\n";
        return string3 + string2;
    }

    public boolean isJmolDataFrame(int n) {
        return n >= 0 && n < this.modelCount && this.models[n].jmolData != null;
    }

    private boolean isJmolDataFrame(Atom atom) {
        return this.models[atom.modelIndex].jmolData != null;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.models[string == null ? this.models[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.models[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable();
            }
            this.models[n2].dataSourceFrame = n;
            this.models[n2].jmolFrameType = string;
            model.dataFrames.put(string, new Integer(n2));
        }
        if (string.indexOf(" ") > 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, new Integer(n2));
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.models[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = (Integer)this.models[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].dataSourceFrame : -1;
    }

    private String getFullPDBHeader() {
        String string = this.pdbHeader == null ? (this.pdbHeader = this.viewer.getCurrentFileAsString()) : this.pdbHeader;
        int n = string.length();
        int n2 = pdbRecords.length;
        block4: while (--n2 >= 0) {
            String string2 = pdbRecords[n2];
            int n3 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n3) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    return "";
                }
            }
            if (n3 >= n) continue;
            n = ++n3;
        }
        return string.substring(0, n);
    }

    public String getPDBHeader() {
        return this.isPDB ? this.getFullPDBHeader() : this.getFileHeader();
    }

    public String getFileHeader() {
        if (this.isPDB) {
            return this.getFullPDBHeader();
        }
        String string = this.getModelSetProperty("fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public Hashtable getModelInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", this.modelSetName);
        hashtable.put("modelCount", new Integer(this.modelCount));
        hashtable.put("modelSetHasVibrationVectors", this.modelSetHasVibrationVectors());
        if (this.modelSetProperties != null) {
            hashtable.put("modelSetProperties", this.modelSetProperties);
        }
        Vector vector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", new Integer(i));
            hashtable2.put("num", new Integer(this.getModelNumber(i)));
            hashtable2.put("file_model", this.getModelNumberDotted(i));
            hashtable2.put("name", this.getModelName(i));
            String string = this.getModelTitle(i);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = this.getModelFileName(i)) != null) {
                hashtable2.put("file", string);
            }
            hashtable2.put("vibrationVectors", this.modelHasVibrationVectors(i));
            hashtable2.put("atomCount", new Integer(this.getAtomCountInModel(i)));
            hashtable2.put("bondCount", new Integer(this.getBondCountInModel(i)));
            hashtable2.put("groupCount", new Integer(this.getGroupCountInModel(i)));
            hashtable2.put("polymerCount", new Integer(this.models[i].getBioPolymerCount()));
            hashtable2.put("chainCount", new Integer(this.getChainCountInModel(i, true)));
            if (this.models[i].properties != null) {
                hashtable2.put("modelProperties", this.models[i].properties);
            }
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        return string == null ? "" : string;
    }

    protected String getModelSymmetryList(int n) {
        if (this.cellInfos == null || this.cellInfos[n] == null) {
            return "";
        }
        String[] stringArray = this.cellInfos[n].symmetryOperations;
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "\n" + stringArray[i];
            }
        }
        return string;
    }

    public int getModelSymmetryCount(int n) {
        return this.cellInfos == null || this.cellInfos[n] == null ? 0 : this.cellInfos[n].symmetryOperations.length;
    }

    public int[] getModelCellRange(int n) {
        if (this.cellInfos == null) {
            return null;
        }
        return this.cellInfos[n].getCellRange();
    }

    public boolean modelHasVibrationVectors(int n) {
        if (this.vibrationVectors != null) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (n >= 0 && this.atoms[n2].modelIndex != n || this.vibrationVectors[n2] == null || !(this.vibrationVectors[n2].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public BitSet getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            bitSet.or(this.elementsPresent[i]);
        }
        return bitSet;
    }

    String getSymmetryInfoAsString(int n) {
        if (this.cellInfos == null) {
            return "no symmetry information";
        }
        return this.cellInfos[n].symmetryInfoString;
    }

    public void toCartesian(int n, Point3f point3f) {
        if (n < 0) {
            n = 0;
        }
        if (this.cellInfos == null || n >= this.cellInfos.length || this.cellInfos[n] == null) {
            return;
        }
        this.cellInfos[n].toCartesian(point3f);
    }

    public void toUnitCell(int n, Point3f point3f, Point3f point3f2) {
        if (n < 0) {
            return;
        }
        if (this.cellInfos == null || n >= this.cellInfos.length || this.cellInfos[n] == null) {
            return;
        }
        this.cellInfos[n].toUnitCell(point3f, point3f2);
    }

    public void toFractional(int n, Point3f point3f) {
        if (n < 0) {
            return;
        }
        if (this.cellInfos == null || n >= this.cellInfos.length || this.cellInfos[n] == null) {
            return;
        }
        this.cellInfos[n].toFractional(point3f);
    }

    public Point3f getUnitCellOffset(int n) {
        UnitCell unitCell = this.getUnitCell(n);
        if (unitCell == null) {
            return null;
        }
        return unitCell.getCartesianOffset();
    }

    public boolean setUnitCellOffset(int n, Point3f point3f) {
        UnitCell unitCell = this.getUnitCell(n);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(point3f);
        return true;
    }

    public boolean setUnitCellOffset(int n, int n2) {
        UnitCell unitCell = this.getUnitCell(n);
        if (unitCell == null) {
            return false;
        }
        unitCell.setOffset(n2);
        return true;
    }

    public Vector getMoleculeInfo(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp = BitSetUtil.copy(bitSet);
            this.bsTemp.and(this.molecules[i].atomList);
            if (BitSetUtil.length(this.bsTemp) <= 0) continue;
            vector.addElement(this.molecules[i].getInfo());
        }
        return vector;
    }

    public int getMoleculeIndex(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    public void rotateSelected(Matrix3f matrix3f, Matrix3f matrix3f2, BitSet bitSet, boolean bl, Point3f point3f, boolean bl2) {
        this.bspf = null;
        BitSet bitSet2 = bl ? this.getMoleculeBitSet(bitSet) : bitSet;
        this.matInv.set(matrix3f2);
        this.matInv.invert();
        this.ptTemp.set(0.0f, 0.0f, 0.0f);
        this.matTemp.mul(matrix3f, matrix3f2);
        this.matTemp.mul(this.matInv, this.matTemp);
        int n = 0;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (!bitSet2.get(n2)) continue;
            if (bl2) {
                this.atoms[n2].sub(point3f);
                this.matTemp.transform(this.atoms[n2]);
                this.atoms[n2].add(point3f);
            } else {
                this.ptTemp.add(this.atoms[n2]);
                this.matTemp.transform(this.atoms[n2]);
                this.ptTemp.sub(this.atoms[n2]);
            }
            this.taint(n2, (byte)0);
            ++n;
        }
        if (n == 0) {
            return;
        }
        if (!bl2) {
            this.ptTemp.scale(1.0f / (float)n);
            n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!bitSet2.get(n2)) continue;
                this.atoms[n2].add(this.ptTemp);
            }
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public BitSet getMoleculeBitSet(BitSet bitSet) {
        int n;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bitSet2 = BitSetUtil.copy(bitSet);
        BitSet bitSet3 = BitSetUtil.copy(bitSet);
        while ((n = BitSetUtil.length(bitSet3)) > 0) {
            this.bsTemp = this.getMoleculeBitSet(n - 1);
            BitSetUtil.andNot(bitSet3, this.bsTemp);
            bitSet2.or(this.bsTemp);
        }
        return bitSet2;
    }

    public BitSet getMoleculeBitSet(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public void invertSelected(Point3f point3f, Point4f point4f, BitSet bitSet) {
        this.bspf = null;
        if (point3f != null) {
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                float f = (point3f.x - this.atoms[n].x) * 2.0f;
                float f2 = (point3f.y - this.atoms[n].y) * 2.0f;
                float f3 = (point3f.z - this.atoms[n].z) * 2.0f;
                this.setAtomCoordRelative(n, f, f2, f3);
            }
            return;
        }
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        vector3f.normalize();
        float f = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            float f4 = -Graphics3D.distanceToPlane(point4f, f, (Point3f)this.atoms[n]) * 2.0f;
            float f5 = vector3f.x * f4;
            float f6 = vector3f.y * f4;
            float f7 = vector3f.z * f4;
            this.setAtomCoordRelative(n, f5, f6, f7);
        }
    }

    public Vector3f getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        Vector3f vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "dipole");
        if (vector3f == null) {
            vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "DIPOLE_VEC");
        }
        return vector3f;
    }

    public Vector3f calculateMolecularDipole(int n) {
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != n) continue;
            float f3 = this.partialCharges[i];
            if (f3 < 0.0f) {
                ++n3;
                f2 += f3;
                vector3f2.scaleAdd(f3, this.atoms[i], vector3f2);
                continue;
            }
            if (!(f3 > 0.0f)) continue;
            ++n2;
            f += f3;
            vector3f.scaleAdd(f3, this.atoms[i], vector3f);
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        vector3f.scale(1.0f / f);
        vector3f2.scale(1.0f / f2);
        vector3f.sub(vector3f2);
        Logger.warn(" this is an untested result -- needs checking");
        vector3f.scale(f * 4.8f);
        return vector3f;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (n != i && n >= 0) continue;
            n2 += this.models[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        for (int i = 0; i < this.moleculeCount; ++i) {
            BitSetUtil.copy(bitSet, this.bsTemp);
            this.bsTemp.and(this.molecules[i].atomList);
            if (BitSetUtil.length(this.bsTemp) <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    private void getMolecules() {
        if (this.moleculeCount > 0) {
            return;
        }
        if (this.molecules == null) {
            this.molecules = new Molecule[4];
        }
        this.moleculeCount = 0;
        BitSet bitSet = new BitSet(this.atomCount);
        BitSet bitSet2 = new BitSet(this.atomCount);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (bitSet.get(i) || bitSet2.get(i)) continue;
            n2 = this.atoms[i].modelIndex;
            if (n2 != n) {
                n3 = -1;
                this.models[n2].firstMolecule = this.moleculeCount;
                n4 = this.moleculeCount - 1;
                n = n2;
            }
            ++n3;
            bitSet2 = this.getConnectedBitSet(i);
            bitSet.or(bitSet2);
            if (this.moleculeCount == this.molecules.length) {
                this.molecules = (Molecule[])ArrayUtil.setLength(this.molecules, this.moleculeCount * 2);
            }
            this.molecules[this.moleculeCount] = new Molecule((ModelSet)this, this.moleculeCount, bitSet2, n, n3);
            this.getModel((int)n).moleculeCount = this.moleculeCount - n4;
            ++this.moleculeCount;
        }
    }

    private BitSet getConnectedBitSet(int n) {
        BitSet bitSet = new BitSet(this.atomCount);
        BitSet bitSet2 = this.getModelAtomBitSet(this.atoms[n].modelIndex, true);
        this.getCovalentlyConnectedBitSet(this.atoms[n], bitSet, bitSet2);
        return bitSet;
    }

    private void getCovalentlyConnectedBitSet(Atom atom, BitSet bitSet, BitSet bitSet2) {
        int n = atom.atomIndex;
        if (!bitSet2.get(n)) {
            return;
        }
        bitSet2.clear(n);
        bitSet.set(n);
        if (atom.bonds == null) {
            return;
        }
        int n2 = atom.bonds.length;
        while (--n2 >= 0) {
            Bond bond = atom.bonds[n2];
            if ((bond.order & 0x7800) != 0) continue;
            if (bond.atom1 == atom) {
                this.getCovalentlyConnectedBitSet(bond.atom2, bitSet, bitSet2);
                continue;
            }
            this.getCovalentlyConnectedBitSet(bond.atom1, bitSet, bitSet2);
        }
    }

    public boolean hasCalculatedHBonds(BitSet bitSet) {
        int n = this.atomCount;
        while (--n >= 0) {
            if (bitSet.get(n) && this.models[this.atoms[n].modelIndex].hasCalculatedHBonds) {
                return true;
            }
            n = this.models[this.atoms[n].modelIndex].firstAtomIndex;
        }
        return false;
    }

    public void clearCalculatedHydrogenBonds(int n, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n2 = 0;
        this.models[n].hasCalculatedHBonds = false;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (n >= 0 && this.models[bond.atom1.modelIndex].trajectoryBaseIndex != n || (bond.order & Short.MIN_VALUE) == 0) continue;
            if (bitSet != null && !bitSet.get(bond.atom1.atomIndex)) {
                this.models[n].hasCalculatedHBonds = true;
                continue;
            }
            bitSet2.set(n3);
            ++n2;
        }
        if (n2 > 0) {
            this.deleteBonds(bitSet2);
        }
    }

    protected void initializeBspf() {
        if (this.bspf == null) {
            long l = 0L;
            l = System.currentTimeMillis();
            this.bspf = new Bspf(3);
            Logger.debug("sequential bspt order");
            int n = this.atomCount;
            while (--n >= 0) {
                Atom atom = this.atoms[n];
                this.bspf.addTuple(this.models[atom.modelIndex].trajectoryBaseIndex, atom);
            }
            long l2 = System.currentTimeMillis();
            Logger.debug("time to build bspf=" + (l2 - l) + " ms");
            this.bspf.stats();
        }
    }

    protected void initializeBspt(int n) {
        if (this.bspf.isInitialized(n)) {
            return;
        }
        this.bspf.initialize(n, this.atoms, this.getModelAtomBitSet(n, false));
    }

    public AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        this.initializeBspf();
        int n2 = this.models[this.atoms[n].modelIndex].trajectoryBaseIndex;
        this.initializeBspt(n2);
        if (this.withinAtomSetIterator == null) {
            this.withinAtomSetIterator = new AtomIteratorWithinSet();
        }
        this.withinAtomSetIterator.initialize(this.bspf, n2, n, this.atoms[n], f, bitSet, bl, bl2 ? this.models[n2].firstAtomIndex : 0);
        return this.withinAtomSetIterator;
    }

    public AtomIndexIterator getWithinModelIterator(Atom atom, float f) {
        return this.getWithinModelIterator(atom.modelIndex, atom, f);
    }

    private AtomIndexIterator getWithinModelIterator(int n, Point3f point3f, float f) {
        this.initializeBspf();
        n = this.models[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        if (this.withinModelIterator == null) {
            this.withinModelIterator = new AtomIteratorWithinModel();
        }
        this.withinModelIterator.initialize(this.bspf, n, point3f, f);
        return this.withinModelIterator;
    }

    public int getBondCountInModel(int n) {
        if (n < 0) {
            return this.bondCount;
        }
        int n2 = this.models[n].bondCount;
        if (n2 >= 0) {
            return n2;
        }
        this.models[n].bondCount = super.getBondCountInModel(n);
        return this.models[n].bondCount;
    }

    public void setAtomCoordRelative(Point3f point3f, BitSet bitSet) {
        this.setAtomCoordRelative(bitSet, point3f.x, point3f.y, point3f.z);
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public void setAtomCoord(BitSet bitSet, int n, Object object) {
        super.setAtomCoord(bitSet, n, object);
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public int getAtomCountInModel(int n) {
        if (n < 0) {
            return this.atomCount;
        }
        int n2 = this.models[n].atomCount;
        if (n2 >= 0) {
            return n2;
        }
        this.models[n].atomCount = super.getAtomCountInModel(n);
        return this.models[n].atomCount;
    }

    public BitSet getModelAtomBitSet(int n, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = n < 0 ? this.bsAll : this.models[n].bsAtoms;
        if (bitSet == null) {
            if (n < 0) {
                bitSet = this.bsAll = BitSetUtil.setAll(this.atomCount);
            } else {
                bitSet = new BitSet();
                for (int i = 0; i < this.atomCount; ++i) {
                    if (this.atoms[i].modelIndex != n) continue;
                    bitSet.set(i);
                }
                this.models[n].bsAtoms = bitSet;
            }
        }
        return bl ? BitSetUtil.copy(bitSet) : bitSet;
    }

    public BitSet getAtomBits(int n) {
        switch (n) {
            case 1572887: {
                return this.getSpecialPosition();
            }
            case 1572886: {
                return this.getSymmetrySet();
            }
            case 1638767: {
                return this.getUnitCellSet();
            }
        }
        return super.getAtomBits(n);
    }

    private BitSet getSpecialPosition() {
        BitSet bitSet = new BitSet(this.atomCount);
        short s = -1;
        int n = 0;
        int n2 = this.atomCount;
        block0: while (--n2 >= 0) {
            Atom atom = this.atoms[n2];
            BitSet bitSet2 = atom.getAtomSymmetry();
            if (bitSet2 == null) continue;
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                n = this.getModelSymmetryCount(s);
            }
            int n3 = 0;
            int n4 = n;
            while (--n4 >= 0) {
                if (!bitSet2.get(n4) || ++n3 <= 1) continue;
                bitSet.set(n2);
                continue block0;
            }
        }
        return bitSet;
    }

    private BitSet getUnitCellSet() {
        BitSet bitSet = new BitSet();
        UnitCell unitCell = this.viewer.getCurrentUnitCell();
        if (unitCell == null) {
            return bitSet;
        }
        Point3f point3f = new Point3f(unitCell.getFractionalOffset());
        point3f.x += 1.0f;
        point3f.y += 1.0f;
        point3f.z += 1.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isInLatticeCell(point3f)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    protected BitSet getSymmetrySet() {
        return BitSetUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = new BitSet(this.atomCount)) : this.bsSymmetry);
    }

    public BitSet getAtomBits(int n, int[] nArray) {
        switch (n) {
            case 524315: {
                return this.getSpecSeqcodeRange(nArray[0], nArray[1]);
            }
            case 2621445: {
                return this.getCellSet(nArray[0], nArray[1], nArray[2]);
            }
        }
        return null;
    }

    private BitSet getSpecSeqcodeRange(int n, int n2) {
        BitSet bitSet = new BitSet();
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            this.models[n3].selectSeqcodeRange(n, n2, bitSet);
        }
        return bitSet;
    }

    public BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = this.getIterativeModels(false);
        float f2 = f * f;
        int n = 0;
        if (bl) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!bitSet.get(n2)) continue;
                int n3 = this.modelCount;
                while (--n3 >= 0) {
                    if (!bitSet3.get(n3)) continue;
                    AtomIndexIterator atomIndexIterator = this.getWithinModelIterator(n3, this.atoms[n2], f);
                    while (atomIndexIterator.hasNext()) {
                        n = atomIndexIterator.next();
                        if (n < 0 || !(atomIndexIterator.foundDistance2() <= f2)) continue;
                        bitSet2.set(n);
                    }
                }
            }
        } else {
            int n4 = this.atomCount;
            while (--n4 >= 0) {
                if (!bitSet.get(n4)) continue;
                AtomIndexIterator atomIndexIterator = this.getWithinModelIterator(this.atoms[n4], f);
                while (atomIndexIterator.hasNext()) {
                    n = atomIndexIterator.next();
                    if (n < 0 || !(atomIndexIterator.foundDistance2() <= f2)) continue;
                    bitSet2.set(n);
                }
            }
        }
        return bitSet2;
    }

    public BitSet getAtomsWithin(float f, Point3f point3f) {
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = this.getIterativeModels(false);
        float f2 = f * f;
        int n = this.modelCount;
        while (--n >= 0) {
            if (!bitSet2.get(n)) continue;
            AtomIndexIterator atomIndexIterator = this.getWithinModelIterator(n, point3f, f);
            while (atomIndexIterator.hasNext()) {
                int n2 = atomIndexIterator.next();
                if (n2 < 0 || !(atomIndexIterator.foundDistance2() <= f2)) continue;
                bitSet.set(n2);
            }
        }
        return bitSet;
    }

    public BitSet getAtomsWithin(int n, BitSet bitSet) {
        switch (n) {
            case 2621454: {
                return this.getMoleculeBitSet(bitSet);
            }
            case 6886669: {
                return this.getAtomsWithinBox(this.getBoxInfo(bitSet));
            }
        }
        return super.getAtomsWithin(n, bitSet);
    }

    private BitSet getAtomsWithinBox(BoxInfo boxInfo) {
        BitSet bitSet = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter());
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i) || boxInfo.isWithin(this.atoms[i])) continue;
            bitSet.clear(i);
        }
        return bitSet;
    }

    public BitSet getAtomsWithin(int n, String string, BitSet bitSet) {
        if (n == 524298) {
            return this.withinSequence(string, bitSet);
        }
        return null;
    }

    private BitSet withinSequence(String string, BitSet bitSet) {
        String string2 = "";
        int n = string.length();
        BitSet bitSet2 = new BitSet();
        if (n == 0) {
            return bitSet2;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            int n2 = this.getBioPolymerCountInModel(i);
            block1: for (int j = 0; j < n2; ++j) {
                string2 = this.models[i].getBioPolymer(j).getSequence();
                int n3 = -1;
                while (true) {
                    ++n3;
                    if ((n3 = string2.indexOf(string, n3)) < 0) continue block1;
                    this.models[i].getBioPolymer(j).getPolymerSequenceAtoms(i, j, n3, n, bitSet, bitSet2);
                }
            }
        }
        return bitSet2;
    }

    protected int[] makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        boolean bl2 = s == -2;
        boolean bl3 = s == 2048;
        boolean bl4 = s == -1;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        float f3 = f * f;
        float f4 = f2 * f2;
        switch (n) {
            case 0: {
                return this.deleteConnections(f, f2, s, bitSet, bitSet2, bl, bl4, f3, f4);
            }
            case 4: {
                if (s != 515) {
                    return this.autoBond(s, bitSet, bitSet2, bitSet3, bl, bl3);
                }
                bl6 = true;
                bl8 = true;
                break;
            }
            case 5: {
                bl5 = true;
                break;
            }
            case 1: {
                bl6 = true;
                break;
            }
            case 2: {
                bl7 = true;
            }
        }
        if (bl4) {
            s = 1;
        }
        this.defaultCovalentMad = this.viewer.getMadBond();
        short s2 = this.getDefaultMadFromOrder(s);
        int n2 = 0;
        int n3 = 0;
        Bond bond = null;
        int n4 = bl ? this.bondCount : this.atomCount;
        int n5 = bl ? 1 : this.atomCount;
        Atom atom = null;
        Atom atom2 = null;
        int n6 = n4;
        while (--n6 >= 0) {
            if (!bitSet.get(n6)) continue;
            if (bl) {
                bond = this.bonds[n6];
                atom = bond.atom1;
                atom2 = bond.atom2;
            } else {
                atom = this.atoms[n6];
            }
            int n7 = n5;
            while (--n7 >= 0) {
                float f5;
                if (!bl) {
                    if (n7 == n6 || !bitSet2.get(n7)) continue;
                    atom2 = this.atoms[n7];
                    if (atom.modelIndex != atom2.modelIndex || atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != 0 && atom2.alternateLocationID != 0) continue;
                    bond = atom.getBond(atom2);
                }
                if (bond == null && (bl5 || bl6) || bond != null && bl7 || (f5 = atom.distanceSquared(atom2)) < f3 || f5 > f4) continue;
                if (bond != null) {
                    if (!bl5 && !bl2) {
                        bond.order = s;
                        this.bsAromatic.clear(bond.index);
                    }
                    if (bl5 && !bl2 && s != bond.order && (!bl3 || !bond.isHydrogen())) continue;
                    bitSet3.set(bond.index);
                    ++n3;
                    continue;
                }
                this.bondAtoms(atom, atom2, s, s2, bitSet3);
                ++n2;
            }
        }
        if (bl8) {
            this.assignAromaticBonds(true, bitSet3);
        }
        return new int[]{n2, n3};
    }

    public int autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        if (this.atomCount == 0) {
            return 0;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getBondTolerance();
        float f2 = this.viewer.getMinBondDistance();
        float f3 = f2 * f2;
        short s = this.viewer.getMadBond();
        int n = 0;
        this.initializeBspf();
        long l = 0L;
        l = System.currentTimeMillis();
        short s2 = -1;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            float f4;
            boolean bl;
            boolean bl2 = bitSet == null || bitSet.get(n2);
            boolean bl3 = bl = bitSet2 == null || bitSet2.get(n2);
            if (!bl2 && !bl) continue;
            Atom atom = this.atoms[n2];
            short s3 = atom.modelIndex;
            if (s3 != s2) {
                s2 = s3;
                if (this.isJmolDataFrame(s3)) {
                    while (--n2 >= 0 && this.atoms[n2].modelIndex == s3) {
                    }
                    ++n2;
                    continue;
                }
            }
            if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) continue;
            float f5 = f4 + this.maxBondingRadius + f;
            CubeIterator cubeIterator = this.bspf.getCubeIterator(s3);
            cubeIterator.initializeHemisphere(atom, f5);
            while (cubeIterator.hasMoreElements()) {
                short s4;
                boolean bl4;
                Atom atom2 = (Atom)cubeIterator.nextElement();
                if (atom2 == atom) continue;
                int n3 = atom2.atomIndex;
                boolean bl5 = bitSet == null || bitSet.get(n3);
                boolean bl6 = bl4 = bitSet2 == null || bitSet2.get(n3);
                if (!bl5 && !bl4 || bitSet3 != null && bitSet3.get(n3) && bitSet3.get(n2) || (!bl2 || !bl4) && (!bl || !bl5) || (s4 = this.getBondOrder(atom, f4, atom2, atom2.getBondingRadiusFloat(), cubeIterator.foundDistance2(), f3, f)) <= 0) continue;
                this.checkValencesAndBond(atom, atom2, s4, s, bitSet4);
                ++n;
            }
            cubeIterator.release();
        }
        if (Logger.debugging) {
            long l2 = System.currentTimeMillis();
            Logger.debug("Time to autoBond=" + (l2 - l));
        }
        return n;
    }

    private int[] autoBond(short s, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2) {
        if (bl) {
            BitSet bitSet4 = bitSet;
            bitSet = new BitSet();
            bitSet2 = new BitSet();
            int n = this.bondCount;
            while (--n >= 0) {
                if (!bitSet4.get(n)) continue;
                bitSet.set(this.bonds[n].atom1.atomIndex);
                bitSet2.set(this.bonds[n].atom2.atomIndex);
            }
        }
        if (bl2) {
            this.initializeBspf();
            return new int[]{this.autoHbond(bitSet, bitSet2, bitSet3), 0};
        }
        return new int[]{this.autoBond(bitSet, bitSet2, null, bitSet3), 0};
    }

    protected String getProteinStructureState(BitSet bitSet, boolean bl) {
        BitSet bitSet2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i <= this.atomCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            n2 = Integer.MIN_VALUE;
            if (i == this.atomCount || (n2 = this.atoms[i].getProteinStructureID()) != n4) {
                if (bitSet2 != null) {
                    if (n == 3 || n == 1 || n == 2) {
                        ++n7;
                        if (bitSet == null) {
                            short s = this.atoms[n3].modelIndex;
                            stringBuffer.append("  structure ").append(JmolConstants.getProteinStructureName(n)).append(" ").append(Escape.escape(bitSet2)).append("    \t# model=").append(this.getModelNumberDotted(s)).append(" & (").append(n5).append(" - ").append(n6).append(");\n");
                        } else {
                            StringBuffer stringBuffer5;
                            String string5;
                            String string6;
                            int n11;
                            switch (n) {
                                case 3: {
                                    n11 = ++n8;
                                    string6 = "H" + n11;
                                    string5 = "HELIX  %3N %3ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB\n";
                                    stringBuffer5 = stringBuffer3;
                                    break;
                                }
                                case 2: {
                                    n11 = ++n10;
                                    string6 = "S" + n11;
                                    string5 = "SHEET  %3N %3ID 2 %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB\n";
                                    stringBuffer5 = stringBuffer4;
                                    break;
                                }
                                default: {
                                    n11 = ++n9;
                                    string6 = "T" + n11;
                                    string5 = "TURN   %3N %3ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB\n";
                                    stringBuffer5 = stringBuffer2;
                                }
                            }
                            string5 = TextFormat.formatString(string5, "N", n11);
                            string5 = TextFormat.formatString(string5, "ID", string6);
                            string5 = TextFormat.formatString(string5, "GROUPA", string);
                            string5 = TextFormat.formatString(string5, "CA", string3);
                            string5 = TextFormat.formatString(string5, "RESA", n5);
                            string5 = TextFormat.formatString(string5, "GROUPB", string2);
                            string5 = TextFormat.formatString(string5, "CB", string4);
                            string5 = TextFormat.formatString(string5, "RESB", n6);
                            stringBuffer5.append(string5);
                        }
                    }
                    bitSet2 = null;
                }
                if (n2 == Integer.MIN_VALUE || bitSet != null && bl && (Float.isNaN(this.atoms[i].getGroupPhi()) || Float.isNaN(this.atoms[i].getGroupPsi()))) continue;
            }
            if (bitSet2 == null) {
                bitSet2 = new BitSet();
                n5 = this.atoms[i].getResno();
                string = this.atoms[i].getGroup3();
                string3 = "" + this.atoms[i].getChainID();
            }
            n = this.atoms[i].getProteinStructureType();
            bitSet2.set(i);
            n4 = n2;
            n6 = this.atoms[i].getResno();
            string2 = this.atoms[i].getGroup3();
            string4 = "" + this.atoms[i].getChainID();
            n3 = i;
        }
        if (n7 > 0) {
            stringBuffer.append("\n");
        }
        return bitSet == null ? stringBuffer.toString() : stringBuffer3.append(stringBuffer4).append(stringBuffer2).append(stringBuffer).toString();
    }

    public String getModelInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("model count = ");
        stringBuffer.append(this.modelCount).append("\nmodelSetHasVibrationVectors:").append(this.modelSetHasVibrationVectors());
        if (this.modelSetProperties == null) {
            stringBuffer.append("\nProperties: null");
        } else {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            stringBuffer.append("\nProperties:");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n ").append(string).append("=").append(this.modelSetProperties.getProperty(string));
            }
        }
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\n").append(i).append(":").append(this.getModelNumberDotted(i)).append(":").append(this.getModelName(i)).append(":").append(this.getModelTitle(i)).append("\nmodelHasVibrationVectors:").append(this.modelHasVibrationVectors(i));
        }
        return stringBuffer.toString();
    }

    public String getSymmetryInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("Symmetry Information:");
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsString(i));
        }
        return stringBuffer.toString();
    }

    public BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        int n2;
        int n3;
        BitSet bitSet2 = new BitSet();
        int[] nArray = new int[this.atomCount];
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (n != -2 && bond.order != n) continue;
            if (bitSet.get(bond.atom1.atomIndex)) {
                n2 = bond.atom2.atomIndex;
                nArray[n2] = nArray[n2] + 1;
                bitSet2.set(n2);
            }
            if (!bitSet.get(bond.atom2.atomIndex)) continue;
            n2 = bond.atom1.atomIndex;
            nArray[n2] = nArray[n2] + 1;
            bitSet2.set(n2);
        }
        n3 = f == 0.0f && f2 == 0.0f ? 1 : 0;
        n2 = this.atomCount;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bitSet2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bitSet2.set(n2);
        }
        return bitSet2;
    }

    public String getModelExtract(BitSet bitSet) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.atomCount];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < this.atomCount; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n] = ++n2;
            this.getAtomRecordMOL(stringBuffer2, n);
        }
        for (n = 0; n < this.bondCount; ++n) {
            Bond bond = this.bonds[n];
            if (!bitSet.get(bond.atom1.atomIndex) || !bitSet.get(bond.atom2.atomIndex) || bond.order < 1 || bond.order >= 3) continue;
            this.getBondRecordMOL(stringBuffer2, n, nArray);
            ++n3;
        }
        if (n2 > 999 || n3 > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        TextFormat.rFill(stringBuffer, "   ", "" + n2);
        TextFormat.rFill(stringBuffer, "   ", "" + n3);
        stringBuffer.append("  0  0  0\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    void getAtomRecordMOL(StringBuffer stringBuffer, int n) {
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(this.getAtomX(n), 9));
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(this.getAtomY(n), 9));
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(this.getAtomZ(n), 9));
        stringBuffer.append(" ").append((this.getElementSymbol(n) + "  ").substring(0, 2)).append("\n");
    }

    void getBondRecordMOL(StringBuffer stringBuffer, int n, int[] nArray) {
        Bond bond = this.bonds[n];
        TextFormat.rFill(stringBuffer, "   ", "" + nArray[bond.atom1.atomIndex]);
        TextFormat.rFill(stringBuffer, "   ", "" + nArray[bond.atom2.atomIndex]);
        stringBuffer.append("  ").append(bond.order).append("\n");
    }

    public String getModelFileInfo(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            String string = this.getModelNumberDotted(i);
            stringBuffer.append("\n\nfile[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelFileName(i))).append("\ntitle[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelTitle(i))).append("\nname[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelName(i)));
        }
        return stringBuffer.toString();
    }

    public Hashtable getAuxiliaryInfo() {
        Hashtable hashtable = this.getModelSetAuxiliaryInfo();
        if (hashtable == null) {
            return hashtable;
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable hashtable2 = this.getModelAuxiliaryInfo(i);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public Vector getAllAtomInfo(BitSet bitSet) {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            vector.addElement(this.getAtomInfoLong(i));
        }
        return vector;
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        hashtable.put("_ipt", new Integer(n));
        hashtable.put("atomIndex", new Integer(n));
        hashtable.put("atomno", new Integer(this.getAtomNumber(n)));
        hashtable.put("info", this.getAtomInfo(n));
        hashtable.put("sym", this.getElementSymbol(n));
    }

    private Hashtable getAtomInfoLong(int n) {
        Atom atom = this.atoms[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", this.getElementName(n));
        hashtable.put("elemno", new Integer(this.getElementNumber(n)));
        hashtable.put("x", new Float(this.getAtomX(n)));
        hashtable.put("y", new Float(this.getAtomY(n)));
        hashtable.put("z", new Float(this.getAtomZ(n)));
        hashtable.put("coord", new Point3f(atom));
        if (this.vibrationVectors != null && this.vibrationVectors[n] != null) {
            hashtable.put("vibVector", new Vector3f(this.vibrationVectors[n]));
        }
        hashtable.put("bondCount", new Integer(atom.getCovalentBondCount()));
        hashtable.put("radius", new Float((double)atom.getRasMolRadius() / 120.0));
        hashtable.put("model", atom.getModelNumberForLabel());
        hashtable.put("visible", this.atoms[n].isVisible());
        hashtable.put("clickabilityFlags", new Integer(atom.clickabilityFlags));
        hashtable.put("visibilityFlags", new Integer(atom.shapeVisibilityFlags));
        hashtable.put("spacefill", new Float(atom.getRadius()));
        String string = this.viewer.getHexColorFromIndex(atom.colixAtom);
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", new Integer(atom.colixAtom));
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", new Integer(atom.getFormalCharge()));
        hashtable.put("partialCharge", new Float(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", new Float(f));
        }
        if (this.getModel((int)atom.modelIndex).isPDB) {
            hashtable.put("resname", atom.getGroup3());
            int n2 = atom.getSeqNumber();
            char c = atom.getInsertionCode();
            if (n2 > 0) {
                hashtable.put("resno", new Integer(n2));
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            char c2 = atom.getChainID();
            hashtable.put("name", this.getAtomName(n));
            hashtable.put("chain", c2 == '\u0000' ? "" : "" + c2);
            hashtable.put("atomID", new Integer(atom.getSpecialAtomID()));
            hashtable.put("groupID", new Integer(atom.getGroupID()));
            if (atom.alternateLocationID != 0) {
                hashtable.put("altLocation", "" + atom.alternateLocationID);
            }
            hashtable.put("structure", new Integer(atom.getProteinStructureType()));
            hashtable.put("polymerLength", new Integer(atom.getPolymerLength()));
            hashtable.put("occupancy", new Integer(atom.getOccupancy()));
            int n3 = atom.getBfactor100();
            hashtable.put("temp", new Integer(n3 < 0 ? 0 : n3 / 100));
        }
        return hashtable;
    }

    public Vector getAllBondInfo(BitSet bitSet) {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.bondCount; ++i) {
            if (!bitSet.get(this.bonds[i].atom1.atomIndex) || !bitSet.get(this.bonds[i].atom2.atomIndex)) continue;
            vector.addElement(this.getBondInfo(i));
        }
        return vector;
    }

    private Hashtable getBondInfo(int n) {
        Bond bond = this.bonds[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", new Integer(n));
        Hashtable hashtable2 = new Hashtable();
        this.getAtomIdentityInfo(atom.atomIndex, hashtable2);
        Hashtable hashtable3 = new Hashtable();
        this.getAtomIdentityInfo(atom2.atomIndex, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", new Integer(this.bonds[n].order));
        hashtable.put("radius", new Float((double)bond.mad / 2000.0));
        hashtable.put("length_Ang", new Float(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = this.viewer.getHexColorFromIndex(bond.colix);
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", new Integer(bond.colix));
        boolean bl = bond.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        return hashtable;
    }

    public Hashtable getAllChainInfo(BitSet bitSet) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Vector vector2 = this.getChainInfo(i, bitSet);
            if (vector2.size() <= 0) continue;
            hashtable2.put("modelIndex", new Integer(i));
            hashtable2.put("chains", vector2);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    private Vector getChainInfo(int n, BitSet bitSet) {
        Model model = this.models[n];
        int n2 = model.getChainCount(true);
        Vector vector = new Vector();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChain(i);
            Vector vector2 = new Vector();
            int n3 = chain.getGroupCount();
            Hashtable hashtable = new Hashtable();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bitSet.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put("groupIndex", new Integer(j));
                hashtable2.put("groupID", new Short(group.getGroupID()));
                String string = group.getSeqcodeString();
                if (string != null) {
                    hashtable2.put("seqCode", string);
                }
                hashtable2.put("_apt1", new Integer(group.firstAtomIndex));
                hashtable2.put("_apt2", new Integer(group.lastAtomIndex));
                hashtable2.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex));
                hashtable2.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex));
                hashtable2.put("visibilityFlags", new Integer(group.shapeVisibilityFlags));
                vector2.addElement(hashtable2);
            }
            if (vector2.isEmpty()) continue;
            hashtable.put("residues", vector2);
            vector.addElement(hashtable);
        }
        return vector;
    }

    public Hashtable getAllPolymerInfo(BitSet bitSet) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Vector<Hashtable> vector2 = new Vector<Hashtable>();
            int n = this.models[i].getBioPolymerCount();
            for (int j = 0; j < n; ++j) {
                Hashtable hashtable3 = this.models[i].getBioPolymer(j).getPolymerInfo(bitSet);
                if (hashtable3.isEmpty()) continue;
                vector2.addElement(hashtable3);
            }
            if (vector2.size() <= 0) continue;
            hashtable2.put("modelIndex", new Integer(i));
            hashtable2.put("polymers", vector2);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public String getUnitCellInfoText() {
        int n = this.viewer.getCurrentModelIndex();
        if (n < 0) {
            return "no single current model";
        }
        if (this.cellInfos == null) {
            return "not applicable";
        }
        return this.cellInfos[n].getUnitCellInfo();
    }

    public String getSpaceGroupInfoText(String string) {
        SpaceGroup spaceGroup;
        String string2 = "";
        int n = this.viewer.getCurrentModelIndex();
        if (string == null) {
            if (n < 0) {
                return "no single current model";
            }
            if (this.cellInfos == null) {
                return "not applicable";
            }
            CellInfo cellInfo = this.cellInfos[n];
            string = cellInfo.spaceGroup;
            if (string.indexOf("[") >= 0) {
                string = string.substring(0, string.indexOf("[")).trim();
            }
            if (string == "spacegroup unspecified") {
                return "no space group identified in file";
            }
            spaceGroup = SpaceGroup.determineSpaceGroup(string, cellInfo.getNotionalUnitCell());
            string2 = "\nSymmetry operations employed:" + this.getModelSymmetryList(n);
        } else {
            if (string.equalsIgnoreCase("ALL")) {
                return SpaceGroup.dumpAll();
            }
            if (string.equalsIgnoreCase("ALLSEITZ")) {
                return SpaceGroup.dumpAllSeitz();
            }
            spaceGroup = SpaceGroup.determineSpaceGroup(string);
            if (spaceGroup == null) {
                spaceGroup = SpaceGroup.createSpaceGroup(string, false);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                while (spaceGroup != null) {
                    stringBuffer.append(spaceGroup.dumpInfo());
                    spaceGroup = SpaceGroup.determineSpaceGroup(string, spaceGroup);
                }
                return stringBuffer.toString();
            }
        }
        if (spaceGroup == null) {
            return "could not identify space group from name: " + string + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
        }
        return spaceGroup.dumpInfo() + string2;
    }

    static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;
        int modelIndex;

        Structure(int n, String string, char c, int n2, char c2, int n3) {
            this.modelIndex = n;
            this.typeName = string;
            this.startChainID = c;
            this.startSeqcode = n2;
            this.endChainID = c2;
            this.endSeqcode = n3;
            this.type = "helix".equals(string) ? (byte)3 : ("sheet".equals(string) ? (byte)2 : ("turn".equals(string) ? (byte)1 : 0));
        }
    }
}

