/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.jvxl.readers.VoxelReader;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JvxlReader
extends VolumeFileReader {
    private static final String JVXL_VERSION = "1.4";
    private int surfaceDataCount;
    private int edgeDataCount;
    private int colorDataCount;
    private int nThisValue;
    private boolean thisInside;
    private int fractionPtr;
    private String strFractionTemp = "";

    JvxlReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.isXLowToHigh = false;
    }

    protected static void jvxlUpdateInfo(JvxlData jvxlData, String[] stringArray, int n) {
        jvxlData.title = stringArray;
        jvxlData.nBytes = n;
        JvxlReader.jvxlUpdateInfoLines(jvxlData);
    }

    public static void jvxlUpdateInfoLines(JvxlData jvxlData) {
        jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(jvxlData, false);
        jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(jvxlData, true);
    }

    protected void readVolumeData(boolean bl) {
        super.readVolumeData(bl);
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
    }

    protected void gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX <= 0 || this.nPointsY <= 0 || this.nPointsZ <= 0) {
            return;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            this.readVoxelData(bl);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadData("edge", this.edgeDataCount);
            }
            if (this.colorDataCount > 0) {
                this.jvxlColorDataRead = this.jvxlReadData("color", this.colorDataCount);
            }
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            throw new NullPointerException();
        }
    }

    protected void initializeVoxelData() {
        boolean bl = this.thisInside = !this.params.isContoured;
        if (this.params.insideOut) {
            this.thisInside = !this.thisInside;
        }
        this.nThisValue = 0;
    }

    protected void readVoxelData(boolean bl) throws Exception {
        this.initializeVoxelData();
        if (this.params.thePlane == null) {
            super.readVoxelData(false);
            return;
        }
        this.volumeData.setDataDistanceToPlane(this.params.thePlane);
        this.setVolumeData(this.volumeData);
        this.params.cutoff = 0.0f;
        JvxlReader.setSurfaceInfo(this.jvxlData, this.params.thePlane, 0, new StringBuffer());
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.skipComments(true);
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 1";
        }
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
        this.line = this.br.readLine();
        if (this.line == null || this.line.length() == 0) {
            this.line = "Line 2";
        }
        this.jvxlFileHeaderBuffer.append(this.line).append('\n');
    }

    protected static boolean jvxlCheckAtomLine(boolean bl, boolean bl2, String string, String string2, StringBuffer stringBuffer) {
        int n;
        if (string != null) {
            n = Parser.parseInt(string);
            if (n == Integer.MIN_VALUE) {
                n = 0;
                string2 = " " + string2.substring(string2.indexOf(" ") + 1);
            } else {
                String string3 = "" + n;
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
            stringBuffer.append((bl ? "+" : "-") + Math.abs(n));
        }
        n = string2.indexOf("ANGSTROM");
        if (bl2 && n < 0) {
            string2 = string2 + " ANGSTROMS";
        } else if (string2.indexOf("ANGSTROMS") >= 0) {
            bl2 = true;
        }
        n = string2.indexOf("BOHR");
        if (!bl2 && n < 0) {
            string2 = string2 + " BOHR";
        }
        stringBuffer.append(string2).append('\n');
        return bl2;
    }

    protected void readAtomCountAndOrigin() throws Exception {
        this.skipComments(true);
        String string = this.line;
        String[] stringArray = Parser.getTokens(string, 0);
        this.isXLowToHigh = false;
        this.negativeAtomCount = true;
        this.atomCount = 0;
        if (stringArray[0] != "-0") {
            if (stringArray[0].charAt(0) == '+') {
                this.isXLowToHigh = true;
                this.atomCount = this.parseInt(stringArray[0].substring(1));
            } else {
                this.atomCount = -this.parseInt(stringArray[0]);
            }
        }
        this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        this.isAngstroms = JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, null, string, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
    }

    protected static void jvxlReadAtoms(BufferedReader bufferedReader, StringBuffer stringBuffer, int n, VolumeData volumeData) throws Exception {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(bufferedReader.readLine() + "\n");
        }
    }

    protected int readExtraLine() throws Exception {
        this.line = this.br.readLine();
        Logger.info("Reading extra JVXL information line: " + this.line);
        int n = this.parseInt(this.line);
        this.isJvxl = n < 0;
        if (!this.isJvxl) {
            return n;
        }
        n = -n;
        Logger.info("jvxl file surfaces: " + n);
        int n2 = this.parseInt();
        if (n2 == Integer.MIN_VALUE) {
            Logger.info("using default edge fraction base and range");
        } else {
            this.edgeFractionBase = n2;
            this.edgeFractionRange = this.parseInt();
        }
        n2 = this.parseInt();
        if (n2 == Integer.MIN_VALUE) {
            Logger.info("using default color fraction base and range");
        } else {
            this.colorFractionBase = n2;
            this.colorFractionRange = this.parseInt();
        }
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
        return n;
    }

    private void jvxlReadDefinitionLine(boolean bl) throws Exception {
        this.skipComments(false);
        if (bl) {
            Logger.info("reading jvxl data set: " + this.line);
        }
        this.jvxlCutoff = this.parseFloat(this.line);
        Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        int n = this.parseInt();
        int n2 = this.parseInt();
        int n3 = this.parseInt();
        if (n3 == Integer.MIN_VALUE || n3 == -1) {
            n3 = 0;
        }
        if (n == -1) {
            try {
                this.params.thePlane = new Point4f(this.parseFloat(), this.parseFloat(), this.parseFloat(), this.parseFloat());
            }
            catch (Exception exception) {
                Logger.error("Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.params.thePlane = new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
            }
            Logger.info("JVXL read: {" + this.params.thePlane.x + " " + this.params.thePlane.y + " " + this.params.thePlane.z + " " + this.params.thePlane.w + "}");
            if (n2 == -1 && n3 < 0) {
                n3 = -n3;
            }
        } else {
            this.params.thePlane = null;
        }
        if (n < 0 && n2 != -1) {
            this.params.isContoured = n3 != 0;
            int n4 = this.parseInt();
            if (n4 != Integer.MIN_VALUE) {
                if (n4 < 0) {
                    n4 = -1 - n4;
                    this.params.contourFromZero = false;
                }
                if (n4 != 0 && this.params.nContours == 0) {
                    this.params.nContours = n4;
                    Logger.info("JVXL read: contours " + this.params.nContours);
                }
            }
        } else {
            this.params.isContoured = false;
        }
        this.jvxlDataIsPrecisionColor = n == -1 && n2 == -2 || n3 < 0;
        this.params.isBicolorMap = n > 0 && n2 < 0;
        this.jvxlDataIsColorMapped = n3 != 0;
        boolean bl2 = this.jvxlDataIs2dContour = this.jvxlDataIsColorMapped && this.params.isContoured;
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        int n5 = n < -1 ? -1 - n : (this.surfaceDataCount = n > 0 ? n : 0);
        if (n == -1) {
            this.edgeDataCount = 0;
        } else {
            int n6 = n2 < -1 ? -n2 : (this.edgeDataCount = n2 > 0 ? n2 : 0);
        }
        int n7 = this.params.isBicolorMap ? -n2 : (n3 < -1 ? -n3 : (this.colorDataCount = n3 > 0 ? n3 : 0));
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.jvxlDataIsColorMapped) {
            float f = this.parseFloat();
            float f2 = this.parseFloat();
            float f3 = this.parseFloat();
            float f4 = this.parseFloat();
            if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                if (f2 == 0.0f && f == 0.0f) {
                    f = -1.0f;
                    f2 = 1.0f;
                }
                this.params.mappedDataMin = f;
                this.params.mappedDataMax = f2;
                Logger.info("JVXL read: data min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax);
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(f3) && !Float.isNaN(f4)) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        f3 = -1.0f;
                        f4 = 1.0f;
                    }
                    this.params.valueMappedToRed = f3;
                    this.params.valueMappedToBlue = f4;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue);
        }
        boolean bl3 = this.jvxlData.insideOut = this.line.indexOf("insideOut") >= 0;
        if (this.params.insideOut) {
            this.jvxlData.insideOut = !this.jvxlData.insideOut;
        }
        this.params.insideOut = this.jvxlData.insideOut;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
    }

    private String jvxlReadData(String string, int n) {
        String string2 = "";
        try {
            while (string2.length() < n) {
                this.line = this.br.readLine();
                string2 = string2 + JvxlReader.jvxlUncompressString(this.line);
            }
        }
        catch (Exception exception) {
            Logger.error("Error reading " + string + " data " + exception);
            throw new NullPointerException();
        }
        return string2;
    }

    private static String jvxlUncompressString(String string) {
        if (string.indexOf("~") < 0) {
            return string;
        }
        String string2 = "";
        char c = '\u0000';
        int[] nArray = new int[1];
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '~') {
                nArray[0] = ++i;
                int n = Parser.parseInt(string, nArray);
                if (n == Integer.MIN_VALUE) {
                    if (c == '~') {
                        string2 = string2 + '~';
                        while ((c2 = string.charAt(++i)) == '~') {
                            string2 = string2 + '~';
                        }
                        continue;
                    }
                    Logger.error("Error uncompressing string " + string.substring(0, i) + "?");
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    string2 = string2 + c;
                }
                i = nArray[0];
                continue;
            }
            string2 = string2 + c2;
            c = c2;
        }
        return string2;
    }

    protected float getNextVoxelValue(StringBuffer stringBuffer) throws Exception {
        if (this.surfaceDataCount <= 0) {
            return 0.0f;
        }
        if (this.nThisValue == 0) {
            this.nThisValue = this.parseInt();
            if (this.nThisValue == Integer.MIN_VALUE) {
                this.line = this.br.readLine();
                if (this.line == null || (this.nThisValue = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    this.nThisValue = 10000;
                } else if (stringBuffer != null) {
                    stringBuffer.append(this.line).append('\n');
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
        }
        --this.nThisValue;
        return this.thisInside ? 1.0f : 0.0f;
    }

    protected static void setSurfaceInfo(JvxlData jvxlData, Point4f point4f, int n, StringBuffer stringBuffer) {
        jvxlData.jvxlSurfaceData = stringBuffer.toString();
        if (jvxlData.jvxlSurfaceData.indexOf("--") == 0) {
            jvxlData.jvxlSurfaceData = jvxlData.jvxlSurfaceData.substring(2);
        }
        jvxlData.jvxlPlane = point4f;
        jvxlData.nSurfaceInts = n;
    }

    protected float readSurfacePoint(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, float[] fArray) {
        if (this.edgeDataCount <= 0) {
            return super.readSurfacePoint(f, bl, f2, f3, point3f, vector3f, fArray);
        }
        float f4 = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        this.ptTemp.scaleAdd(f4, vector3f, point3f);
        fArray[0] = f4;
        return fArray[0];
    }

    private float jvxlGetNextFraction(int n, int n2, float f) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data at point " + this.fractionData.length());
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)n;
            this.fractionData.append(this.strFractionTemp);
            this.fractionData.append('\n');
            this.fractionPtr = 0;
        }
        return JvxlReader.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), n, n2, f);
    }

    protected String readColorData() {
        this.fractionPtr = 0;
        int n = this.meshData.vertexCount;
        short[] sArray = this.meshData.vertexColixes;
        float[] fArray = this.meshData.vertexValues;
        this.fractionData = new StringBuffer();
        String string = this.strFractionTemp = this.isJvxl ? this.jvxlColorDataRead : "";
        if (this.isJvxl && this.strFractionTemp.length() == 0) {
            Logger.error("You cannot use JVXL data to map onto OTHER data, because it only containts the data for one surface. Use ISOSURFACE \"file.jvxl\" not ISOSURFACE .... MAP \"file.jvxl\".");
            return "";
        }
        this.fractionPtr = 0;
        Logger.info("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + n + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlDataIsPrecisionColor);
        float f = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin;
        float f2 = (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax) - f;
        float f3 = this.params.valueMappedToBlue - this.params.valueMappedToRed;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        if (sArray == null || sArray.length < n) {
            this.meshData.vertexColixes = sArray = new short[n];
        }
        this.jvxlData.vertexCount = n;
        String string2 = this.jvxlColorDataRead;
        int n2 = 0;
        short s = 0;
        short s2 = 0;
        if (this.params.colorBySign) {
            s2 = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
            s = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
        }
        int n3 = this.meshData.vertexIncrement;
        for (int i = 0; i < n; i += n3) {
            float f6;
            float f7;
            if (this.jvxlDataIsPrecisionColor) {
                f7 = JvxlReader.jvxlFractionFromCharacter2(string2.charAt(n2), string2.charAt(n2 + n), this.colorFractionBase, this.colorFractionRange);
                f6 = f + f7 * f2;
            } else {
                f7 = JvxlReader.jvxlFractionFromCharacter(string2.charAt(n2), this.colorFractionBase, this.colorFractionRange, 0.5f);
                f6 = this.params.valueMappedToRed + f7 * f3;
            }
            fArray[i] = f6;
            ++n2;
            if (f6 < f4) {
                f4 = f6;
            }
            if (f6 > f5) {
                f5 = f6;
            }
            if (this.params.isContoured) {
                this.marchingSquares.setContourData(i, f6);
                continue;
            }
            sArray[i] = this.params.colorBySign ? ((this.params.isColorReversed ? f6 > 0.0f : f6 <= 0.0f) ? s : s2) : this.getColorIndexFromPalette(f6);
        }
        if (this.params.mappedDataMin == Float.MAX_VALUE) {
            this.params.mappedDataMin = f4;
            this.params.mappedDataMax = f5;
        }
        return string2 + "\n";
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        for (int i = 0; i < n; ++i) {
            this.jvxlReadDefinitionLine(true);
            Logger.info("JVXL skipping: jvxlSurfaceDataCount=" + this.surfaceDataCount + " jvxlEdgeDataCount=" + this.edgeDataCount + " jvxlDataIsColorMapped=" + this.jvxlDataIsColorMapped);
            this.jvxlSkipData(n2, true);
        }
        this.jvxlReadDefinitionLine(true);
    }

    private void jvxlSkipData(int n, boolean bl) throws Exception {
        if (this.surfaceDataCount > 0) {
            this.jvxlSkipDataBlock(n, true);
        }
        if (this.edgeDataCount > 0) {
            this.jvxlSkipDataBlock(this.edgeDataCount, false);
        }
        if (this.jvxlDataIsColorMapped && bl) {
            this.jvxlSkipDataBlock(this.colorDataCount, false);
        }
    }

    private void jvxlSkipDataBlock(int n, boolean bl) throws Exception {
        for (int i = 0; i < n; i += bl ? this.countData(this.line) : JvxlReader.jvxlUncompressString(this.line).length()) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = this.parseInt(string);
        while (n2 != Integer.MIN_VALUE) {
            n += n2;
            n2 = this.parseIntNext(string);
        }
        return n;
    }

    protected static void jvxlCreateHeaderWithoutTitleOrAtoms(VolumeData volumeData, StringBuffer stringBuffer) {
        JvxlReader.jvxlCreateHeader(volumeData, Integer.MAX_VALUE, null, null, stringBuffer);
    }

    protected static void jvxlCreateHeader(VolumeData volumeData, int n, Point3f[] point3fArray, int[] nArray, StringBuffer stringBuffer) {
        int n2;
        if (stringBuffer.length() == 0) {
            stringBuffer.append("Line 1\nLine 2\n");
        }
        stringBuffer.append(n == Integer.MAX_VALUE ? -2 : -n).append(' ').append(volumeData.volumetricOrigin.x).append(' ').append(volumeData.volumetricOrigin.y).append(' ').append(volumeData.volumetricOrigin.z).append(" ANGSTROMS\n");
        for (n2 = 0; n2 < 3; ++n2) {
            stringBuffer.append(volumeData.voxelCounts[n2]).append(' ').append(volumeData.volumetricVectors[n2].x).append(' ').append(volumeData.volumetricVectors[n2].y).append(' ').append(volumeData.volumetricVectors[n2].z).append('\n');
        }
        if (n == Integer.MAX_VALUE) {
            JvxlReader.jvxlAddDummyAtomList(volumeData, stringBuffer);
            return;
        }
        n = Math.abs(n);
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 = Math.abs(nArray[n2]);
            stringBuffer.append(n3 + " " + n3 + ".0 " + point3fArray[n2].x + " " + point3fArray[n2].y + " " + point3fArray[n2].z + "\n");
        }
    }

    private static void jvxlAddDummyAtomList(VolumeData volumeData, StringBuffer stringBuffer) {
        Point3f point3f = new Point3f(volumeData.volumetricOrigin);
        stringBuffer.append("1 1.0 ").append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append(" //BOGUS H ATOM ADDED FOR JVXL FORMAT\n");
        for (int i = 0; i < 3; ++i) {
            point3f.scaleAdd(volumeData.voxelCounts[i] - 1, volumeData.volumetricVectors[i], point3f);
        }
        stringBuffer.append("2 2.0 ").append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append(" //BOGUS He ATOM ADDED FOR JVXL FORMAT\n");
    }

    public static int jvxlCreateSurfaceData(JvxlData jvxlData, float[][][] fArray, float f, boolean bl, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    ++n5;
                    if (bl2 == VoxelReader.isInside(fArray[i][j][k], f, bl)) {
                        ++n4;
                        continue;
                    }
                    if (n4 != 0) {
                        stringBuffer.append(' ').append(n4);
                        ++n6;
                    }
                    n4 = 1;
                    bl2 = !bl2;
                }
            }
        }
        stringBuffer.append(' ').append(n4).append('\n');
        JvxlReader.setSurfaceInfo(jvxlData, null, ++n6, stringBuffer);
        return n5;
    }

    public static String jvxlGetDefinitionLine(JvxlData jvxlData, boolean bl) {
        String string = jvxlData.cutoff + " ";
        if (jvxlData.jvxlSurfaceData == null) {
            return "";
        }
        int n = jvxlData.nSurfaceInts;
        int n2 = jvxlData.jvxlEdgeData.length() - 1;
        int n3 = jvxlData.jvxlColorData.length() - 1;
        String string2 = "# cutoff = " + jvxlData.cutoff + "; pointsPerAngstrom = " + jvxlData.pointsPerAngstrom + "; nSurfaceInts = " + n + "; nBytesData = " + (jvxlData.jvxlSurfaceData.length() + n2 + jvxlData.jvxlColorData.length());
        if (jvxlData.jvxlPlane == null) {
            if (jvxlData.isContoured) {
                string = string + (-1 - n) + " " + n2;
                string2 = string2 + "; contoured";
            } else if (jvxlData.isBicolorMap) {
                string = string + n + " " + -n2;
                string2 = string2 + "; bicolor map";
            } else {
                string = string + n + " " + n2;
                if (n3 > 0) {
                    string2 = string2 + "; colormapped";
                }
            }
            string = string + " " + (jvxlData.isJvxlPrecisionColor && n3 != -1 ? -n3 : n3);
            if (jvxlData.isJvxlPrecisionColor && n3 != -1) {
                string2 = string2 + "; precision colored";
            }
        } else {
            String string3 = " " + jvxlData.jvxlPlane.x + " " + jvxlData.jvxlPlane.y + " " + jvxlData.jvxlPlane.z + " " + jvxlData.jvxlPlane.w;
            string = string + (jvxlData.isContoured ? "-1 -2 " + -n3 : "-1 -1 " + n3) + string3;
            string2 = string2 + "; " + (n3 > 0 ? "color mapped " : "") + "plane: {" + string3 + " }";
        }
        if (jvxlData.isContoured) {
            string = string + " " + jvxlData.nContours;
            string2 = string2 + "; " + Math.abs(jvxlData.nContours) + " contours";
        }
        float f = jvxlData.mappedDataMin == Float.MAX_VALUE ? 0.0f : jvxlData.mappedDataMin;
        string = string + " " + f + " " + jvxlData.mappedDataMax + " " + jvxlData.valueMappedToRed + " " + jvxlData.valueMappedToBlue;
        if (jvxlData.jvxlColorData.length() > 0 && !jvxlData.isBicolorMap) {
            string2 = string2 + "\n# data minimum = " + f + "; data maximum = " + jvxlData.mappedDataMax + " " + "\n# value mapped to red = " + jvxlData.valueMappedToRed + "; value mapped to blue = " + jvxlData.valueMappedToBlue;
        }
        if (jvxlData.jvxlCompressionRatio > 0) {
            string2 = string2 + "; approximate compressionRatio=" + jvxlData.jvxlCompressionRatio + ":1";
        }
        if (jvxlData.isXLowToHigh) {
            string2 = string2 + "\n# progressive JVXL+ -- X values read from low(0) to high(" + (jvxlData.nPointsX - 1) + ")";
        }
        string2 = string2 + "\n# created using Jvxl.java";
        if (jvxlData.insideOut) {
            string2 = string2 + "\n# insideOut";
            string = string + " insideOut";
        }
        string2 = string2 + "precision: " + jvxlData.isJvxlPrecisionColor + " nColorData " + n3;
        return bl ? string2 : string;
    }

    protected static String jvxlExtraLine(JvxlData jvxlData, int n) {
        return -n + " " + jvxlData.edgeFractionBase + " " + jvxlData.edgeFractionRange + " " + jvxlData.colorFractionBase + " " + jvxlData.colorFractionRange + " Jmol voxel format version " + JVXL_VERSION + "\n";
    }

    public static String jvxlGetFile(JvxlData jvxlData, String[] stringArray, String string, boolean bl, int n, String string2, String string3) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string4 = jvxlData.jvxlFileHeader + (n > 0 ? -n + jvxlData.jvxlExtraLine.substring(2) : jvxlData.jvxlExtraLine);
            if (string4.indexOf("#JVXL") != 0) {
                stringBuffer.append("#JVXL").append(jvxlData.isXLowToHigh ? "+" : "");
                stringBuffer.append(" VERSION ").append(JVXL_VERSION);
                stringBuffer.append("\n");
            }
            stringBuffer.append(string4);
        }
        stringBuffer.append("# ").append(string).append('\n');
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("# ").append(stringArray[i]).append('\n');
            }
        }
        stringBuffer.append(jvxlData.jvxlDefinitionLine + " rendering:" + string2).append('\n');
        string4 = jvxlData.jvxlPlane == null ? jvxlData.jvxlSurfaceData : "";
        string4 = jvxlData.jvxlPlane == null ? string4 + JvxlReader.jvxlCompressString(jvxlData.jvxlEdgeData + jvxlData.jvxlColorData) : string4 + JvxlReader.jvxlCompressString(jvxlData.jvxlColorData);
        int n2 = 0;
        if (string4.length() > 0) {
            jvxlData.jvxlCompressionRatio = jvxlData.wasCubic && jvxlData.nBytes > 0 ? (n2 = (int)((float)jvxlData.nBytes / (float)string4.length())) : (n2 = (int)((float)(jvxlData.nPointsX * jvxlData.nPointsY * jvxlData.nPointsZ * 13) / (float)string4.length()));
        }
        stringBuffer.append(string4);
        if (string != null) {
            stringBuffer.append("#-------end of jvxl file data-------\n");
        }
        stringBuffer.append(jvxlData.jvxlInfoLine).append('\n');
        if (string3 != null) {
            stringBuffer.append("# ").append(string3).append('\n');
        }
        if (string2 != null) {
            stringBuffer.append("# ").append(string2).append('\n');
        }
        if (n2 > 0) {
            String string5 = "bytes read: " + jvxlData.nBytes + "; approximate voxel-only input/output byte ratio: " + n2 + ":1\n";
            stringBuffer.append("# ").append(string5);
            Logger.info("\n" + string5);
        }
        return stringBuffer.toString();
    }

    private static String jvxlCompressString(String string) {
        String string2 = "";
        String string3 = "";
        char c = '\u0000';
        string = string + '\u0000';
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                ++n;
                string3 = string3 + c2;
                if (c2 != '~') {
                    c2 = '\u0000';
                }
            } else if (n > 0) {
                string2 = string2 + (n < 4 || c == '~' || c == ' ' || c == '\t' ? string3 : "~" + n + " ");
                string3 = "";
                n = 0;
            }
            if (c2 == '\u0000') continue;
            string2 = string2 + c2;
            c = c2;
        }
        return string2;
    }

    protected static float jvxlFractionFromCharacter(int n, int n2, int n3, float f) {
        float f2;
        if (n == n2 + n3) {
            return Float.NaN;
        }
        if (n < n2) {
            n = 92;
        }
        if ((f2 = ((float)(n - n2) + f) / (float)n3) < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 0.999999f;
        }
        return f2;
    }

    protected static float jvxlValueFromCharacter2(int n, int n2, float f, float f2, int n3, int n4) {
        float f3 = JvxlReader.jvxlFractionFromCharacter2(n, n2, n3, n4);
        return f2 == f ? f3 : f + f3 * (f2 - f);
    }

    protected static float jvxlFractionFromCharacter2(int n, int n2, int n3, int n4) {
        float f = JvxlReader.jvxlFractionFromCharacter(n, n3, n4, 0.0f);
        float f2 = JvxlReader.jvxlFractionFromCharacter(n2, n3, n4, 0.5f);
        return f + f2 / (float)n4;
    }

    protected static char jvxlValueAsCharacter(float f, float f2, float f3, int n, int n2) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        return JvxlReader.jvxlFractionAsCharacter(f4, n, n2);
    }

    protected static char jvxlFractionAsCharacter(float f, int n, int n2) {
        if (f > 0.9999f) {
            f = 0.9999f;
        } else if (Float.isNaN(f)) {
            f = 1.0001f;
        }
        int n3 = (int)(f * (float)n2 + (float)n);
        if (n3 < n) {
            return (char)n;
        }
        if (n3 == 92) {
            return '!';
        }
        return (char)n3;
    }

    protected static char jvxlValueAsCharacter2(float f, float f2, float f3, int n, int n2, char[] cArray) {
        float f4 = f2 == f3 ? f : (f - f2) / (f3 - f2);
        char c = JvxlReader.jvxlFractionAsCharacter(f4, n, n2);
        cArray[0] = JvxlReader.jvxlFractionAsCharacter((f4 -= JvxlReader.jvxlFractionFromCharacter(c, n, n2, 0.0f)) * (float)n2, n, n2);
        return c;
    }

    public static void jvxlUpdateSurfaceData(JvxlData jvxlData, float[] fArray, int n, int n2, char c) {
        char[] cArray = jvxlData.jvxlEdgeData.toCharArray();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (Float.isNaN(fArray[n3])) {
                cArray[n4] = c;
            }
            n3 += n2;
            ++n4;
        }
        jvxlData.jvxlEdgeData = String.copyValueOf(cArray);
    }

    public static void jvxlCreateColorData(JvxlData jvxlData, float[] fArray) {
        if (fArray == null) {
            jvxlData.jvxlColorData = "";
            return;
        }
        boolean bl = jvxlData.isJvxlPrecisionColor;
        boolean bl2 = jvxlData.isTruncated;
        int n = jvxlData.colorFractionBase;
        int n2 = jvxlData.colorFractionRange;
        float f = jvxlData.valueMappedToBlue;
        float f2 = jvxlData.valueMappedToRed;
        int n3 = jvxlData.vertexCount;
        float f3 = jvxlData.mappedDataMin;
        float f4 = jvxlData.mappedDataMax;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        stringBuffer = new StringBuffer();
        stringBuffer2 = new StringBuffer();
        char[] cArray = new char[1];
        for (int i = 0; i < n3; ++i) {
            char c;
            float f5 = fArray[i];
            if (bl2) {
                float f6 = f5 = f5 > 0.0f ? 0.999f : -0.999f;
            }
            if (bl) {
                c = JvxlReader.jvxlValueAsCharacter2(f5, f3, f4, n, n2, cArray);
                stringBuffer2.append(cArray[0]);
            } else {
                c = JvxlReader.jvxlValueAsCharacter(f5, f2, f, n, n2);
            }
            stringBuffer.append(c);
        }
        jvxlData.jvxlColorData = stringBuffer.append(stringBuffer2).append('\n').toString();
        JvxlReader.jvxlUpdateInfoLines(jvxlData);
    }
}

