/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Platform3D;

public class Text3D {
    private int height;
    private int ascent;
    private int width;
    private int mapWidth;
    private int size;
    private int[] bitmap;
    private static final Hashtable htFont3d = new Hashtable();
    private static final Hashtable htFont3dAntialias = new Hashtable();

    public int getWidth() {
        return this.width;
    }

    public static int plot(int n, int n2, int n3, int n4, String string, Font3D font3D, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.indexOf("<su") >= 0) {
            return Text3D.plotByCharacter(n, n2, n3, n4, string, font3D, graphics3D, jmolRendererInterface, bl);
        }
        int n5 = font3D.fontMetrics.getAscent();
        if (bl) {
            n5 += n5;
        }
        n2 -= n5;
        Text3D text3D = Text3D.getText3D(string, font3D, graphics3D.platform, bl);
        if (text3D.width == 0) {
            return 0;
        }
        int[] nArray = text3D.bitmap;
        int n6 = text3D.width;
        int n7 = text3D.height;
        int n8 = text3D.mapWidth;
        if (n + n6 < 0 || n > graphics3D.width || n2 + n7 < 0 || n2 > graphics3D.height) {
            return n6;
        }
        if (jmolRendererInterface != null || n < 0 || n + n6 > graphics3D.width || n2 < 0 || n2 + n7 > graphics3D.height) {
            Text3D.plotClipped(n, n2, n3, n4, graphics3D, jmolRendererInterface, n8, n7, nArray);
        } else {
            Text3D.plotUnclipped(n, n2, n3, n4, graphics3D, n8, n7, nArray);
        }
        return n6;
    }

    private static int plotByCharacter(int n, int n2, int n3, int n4, String string, Font3D font3D, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        int n5 = 0;
        int n6 = string.length();
        int n7 = (int)((double)font3D.fontMetrics.getHeight() * 0.25);
        int n8 = -((int)((double)font3D.fontMetrics.getHeight() * 0.3));
        if (bl) {
            n7 <<= 1;
            n8 <<= 1;
        }
        for (int i = 0; i < n6; ++i) {
            if (string.charAt(i) == '<') {
                if (i + 4 < n6 && string.substring(i, i + 5).equals("<sub>")) {
                    i += 4;
                    n2 += n7;
                    continue;
                }
                if (i + 4 < n6 && string.substring(i, i + 5).equals("<sup>")) {
                    i += 4;
                    n2 += n8;
                    continue;
                }
                if (i + 5 < n6 && string.substring(i, i + 6).equals("</sub>")) {
                    i += 5;
                    n2 -= n7;
                    continue;
                }
                if (i + 5 < n6 && string.substring(i, i + 6).equals("</sup>")) {
                    i += 5;
                    n2 -= n8;
                    continue;
                }
            }
            n5 += Text3D.plot(n + n5, n2, n3, n4, string.substring(i, i + 1), font3D, graphics3D, jmolRendererInterface, bl);
        }
        return n5;
    }

    private static void plotUnclipped(int n, int n2, int n3, int n4, Graphics3D graphics3D, int n5, int n6, int[] nArray) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray2 = graphics3D.zbuf;
        int n11 = graphics3D.width;
        int n12 = n2 * n11 + n;
        while (n9 < n6) {
            while (n10 < n5) {
                if ((n7 & 0x1F) == 0) {
                    n8 = nArray[n7 >> 5];
                }
                if (n8 == 0) {
                    int n13 = 32 - (n7 & 0x1F);
                    n10 += n13;
                    n7 += n13;
                    n12 += n13;
                    continue;
                }
                if (n8 < 0 && n3 < nArray2[n12]) {
                    graphics3D.addPixel(n12, n3, n4);
                }
                n8 <<= 1;
                ++n7;
                ++n10;
                ++n12;
            }
            while (n10 >= n5) {
                ++n9;
                n10 -= n5;
                n12 += n11 - n5;
            }
        }
    }

    private static void plotClipped(int n, int n2, int n3, int n4, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, int n5, int n6, int[] nArray) {
        if (jmolRendererInterface == null) {
            jmolRendererInterface = graphics3D;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n9 < n6) {
            while (n10 < n5) {
                if ((n7 & 0x1F) == 0) {
                    n8 = nArray[n7 >> 5];
                }
                if (n8 == 0) {
                    int n11 = 32 - (n7 & 0x1F);
                    n10 += n11;
                    n7 += n11;
                    continue;
                }
                if (n8 < 0) {
                    jmolRendererInterface.plotPixelClippedNoSlab(n4, n + n10, n2 + n9, n3);
                }
                n8 <<= 1;
                ++n7;
                ++n10;
            }
            while (n10 >= n5) {
                ++n9;
                n10 -= n5;
            }
        }
    }

    private Text3D(String string, Font3D font3D, Platform3D platform3D, boolean bl) {
        if (!this.calcMetrics(string, font3D, bl)) {
            return;
        }
        platform3D.checkOffscreenSize(this.mapWidth, this.height);
        this.renderOffscreen(string, font3D, platform3D, bl);
        this.rasterize(platform3D, bl);
    }

    private boolean calcMetrics(String string, Font3D font3D, boolean bl) {
        FontMetrics fontMetrics = font3D.fontMetrics;
        this.ascent = fontMetrics.getAscent();
        this.height = this.ascent + fontMetrics.getDescent();
        this.width = fontMetrics.stringWidth(string);
        if (this.width == 0) {
            return false;
        }
        if (bl) {
            this.ascent <<= 1;
            this.height <<= 1;
            this.width <<= 1;
            this.mapWidth = this.width * 2;
        } else {
            this.mapWidth = this.width;
        }
        this.size = this.mapWidth * this.height;
        return true;
    }

    private void renderOffscreen(String string, Font3D font3D, Platform3D platform3D, boolean bl) {
        Graphics graphics = platform3D.gOffscreen;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.mapWidth, this.height);
        graphics.setColor(Color.white);
        if (bl) {
            if (font3D.antialiasFont == null) {
                font3D.setAntialiasFont();
            }
            graphics.setFont(font3D.antialiasFont);
        } else {
            graphics.setFont(font3D.font);
        }
        graphics.drawString(string, 0, this.ascent);
    }

    private void rasterize(Platform3D platform3D, boolean bl) {
        PixelGrabber pixelGrabber = new PixelGrabber(platform3D.imageOffscreen, 0, 0, this.mapWidth, this.height, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n = this.size + 31 >> 5;
        this.bitmap = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if ((nArray[n3] & 0xFFFFFF) != 0) {
                n2 |= 1;
            }
            if ((n3 & 0x1F) == 31) {
                this.bitmap[n3 >> 5] = n2;
            }
            ++n3;
            n2 <<= 1;
        }
        if ((n3 & 0x1F) != 0) {
            this.bitmap[n3 >> 5] = n2 <<= 31 - (n3 & 0x1F);
        }
    }

    private static synchronized Text3D getText3D(String string, Font3D font3D, Platform3D platform3D, boolean bl) {
        Text3D text3D;
        Hashtable hashtable = bl ? htFont3dAntialias : htFont3d;
        Hashtable<String, Text3D> hashtable2 = (Hashtable<String, Text3D>)hashtable.get(font3D);
        if (hashtable2 != null) {
            text3D = (Text3D)hashtable2.get(string);
            if (text3D != null) {
                return text3D;
            }
        } else {
            hashtable2 = new Hashtable<String, Text3D>();
            hashtable.put(font3D, hashtable2);
        }
        if ((text3D = new Text3D(string, font3D, platform3D, bl)) != null) {
            hashtable2.put(string, text3D);
        }
        return text3D;
    }
}

