/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Shade3D;

class Cylinder3D {
    final Graphics3D g3d;
    final Line3D line3d;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private boolean isScreenedA;
    private int[] shadesB;
    private boolean isScreenedB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private float xAf;
    private float yAf;
    private float zAf;
    private float dxBf;
    private float dyBf;
    private float dzBf;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean tEndcapOpen;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int intensityEndcap;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    boolean notClipped;
    private boolean drawBackside;
    private int zShift;
    float xTip;
    float yTip;
    float zTip;
    int rasterCount;
    float[] tRaster = new float[32];
    float[] txRaster = new float[32];
    float[] tyRaster = new float[32];
    float[] tzRaster = new float[32];
    int[] xRaster = new int[32];
    int[] yRaster = new int[32];
    int[] zRaster = new int[32];
    int[] fp8IntensityUp = new int[32];
    int yMin;
    int yMax;
    int xMin;
    int xMax;
    int zXMin;
    int zXMax;

    Cylinder3D(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.line3d = graphics3D.line3d;
    }

    void render(short s, short s2, boolean bl, boolean bl2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        if (n > this.g3d.height * 3) {
            return;
        }
        this.isScreenedA = bl;
        this.isScreenedB = bl2;
        int n11 = n / 2 + 1;
        int n12 = this.line3d.clipCode(n2 - n11, n3 - n11, n4 - n11);
        boolean bl3 = this.notClipped = (n12 | (n10 = this.line3d.clipCode(n2 + n11, n3 + n11, n4 + n11)) | (n9 = this.line3d.clipCode(n5 - n11, n6 - n11, n7 - n11)) | (n8 = this.line3d.clipCode(n5 + n11, n6 + n11, n7 + n11))) == 0;
        if ((n12 & n8 & n10 & n9) != 0) {
            return;
        }
        this.dxB = n5 - n2;
        this.dyB = n6 - n3;
        this.dzB = n7 - n4;
        this.zShift = this.g3d.getZShift(n4 + n7 >> 1);
        if (n <= 1) {
            this.line3d.plotLineDelta(this.g3d.getColixArgb(s), bl, this.g3d.getColixArgb(s2), bl2, n2, n3, n4, this.dxB, this.dyB, this.dzB, this.notClipped);
            return;
        }
        this.drawBackside = !this.notClipped || by == 2 || by == 0;
        this.diameter = n;
        this.xA = n2;
        this.yA = n3;
        this.zA = n4;
        this.endcaps = by;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.calcArgbEndcap(true);
        this.generateBaseEllipse();
        if (by == 2) {
            this.renderFlatEndcap(true);
        }
        this.g3d.setZMargin(5);
        int n13 = this.rasterCount;
        while (--n13 >= 0) {
            this.plotRaster(n13);
        }
        this.g3d.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
    }

    void renderBits(short s, short s2, boolean bl, boolean bl2, byte by, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        int n2;
        int n3;
        int n4;
        if (n > this.g3d.height * 3) {
            return;
        }
        this.isScreenedA = bl;
        this.isScreenedB = bl2;
        int n5 = n / 2 + 1;
        int n6 = this.line3d.clipCode((int)f - n5, (int)f2 - n5, (int)f3 - n5);
        boolean bl3 = this.notClipped = (n6 | (n4 = this.line3d.clipCode((int)f + n5, (int)f2 + n5, (int)f3 + n5)) | (n3 = this.line3d.clipCode((int)f4 - n5, (int)f5 - n5, (int)f6 - n5)) | (n2 = this.line3d.clipCode((int)f4 + n5, (int)f5 + n5, (int)f6 + n5))) == 0;
        if ((n6 & n2 & n4 & n3) != 0) {
            return;
        }
        this.dxBf = f4 - f;
        this.dyBf = f5 - f2;
        this.dzBf = f6 - f3;
        if (n == 0 || n == 1) {
            this.line3d.plotLineDelta(this.g3d.getColixArgb(s), bl, this.g3d.getColixArgb(s2), bl2, (int)f, (int)f2, (int)f3, this.dxB, this.dyB, this.dzB, this.notClipped);
            return;
        }
        if (n > 0) {
            this.diameter = n;
            this.xAf = f;
            this.yAf = f2;
            this.zAf = f3;
        }
        this.drawBackside = !bl && !bl2 && (!this.notClipped || by == 2);
        this.xA = (int)this.xAf;
        this.yA = (int)this.yAf;
        this.zA = (int)this.zAf;
        this.dxB = (int)this.dxBf;
        this.dyB = (int)this.dyBf;
        this.dzB = (int)this.dzBf;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.endcaps = by;
        this.calcArgbEndcap(true);
        if (n > 0) {
            this.generateBaseEllipsePrecisely();
        }
        if (by == 2) {
            this.renderFlatEndcap(true);
        }
        this.line3d.setLineBits(this.dxBf, this.dyBf);
        this.g3d.setZMargin(5);
        int n7 = this.rasterCount;
        while (--n7 >= 0) {
            this.plotRasterBits(n7);
        }
        this.g3d.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
        this.xAf += this.dxBf;
        this.yAf += this.dyBf;
        this.zAf += this.dzBf;
    }

    private void plotRasterBits(int n) {
        int n2 = this.fp8IntensityUp[n] >> 8 + this.zShift;
        int n3 = n2 >> 1;
        int n4 = this.xRaster[n];
        int n5 = this.yRaster[n];
        int n6 = this.zRaster[n];
        if (this.tEndcapOpen && this.argbEndcap != 0) {
            if (this.notClipped) {
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap + n4, this.yEndcap + n5, this.zEndcap - n6 - 1);
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap - n4, this.yEndcap - n5, this.zEndcap + n6 - 1);
            } else {
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap + n4, this.yEndcap + n5, this.zEndcap - n6 - 1);
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap - n4, this.yEndcap - n5, this.zEndcap + n6 - 1);
            }
        }
        this.line3d.plotLineDeltaBits(this.shadesA, this.isScreenedA, this.shadesB, this.isScreenedB, n2, this.xA + n4, this.yA + n5, this.zA - n6, this.dxB, this.dyB, this.dzB, this.notClipped);
        if (this.drawBackside) {
            this.line3d.plotLineDelta(this.shadesA[n3], this.isScreenedA, this.shadesB[n3], this.isScreenedB, this.xA - n4, this.yA - n5, this.zA + n6, this.dxB, this.dyB, this.dzB, this.notClipped);
        }
    }

    void renderCone(short s, boolean bl, byte by, int n, float f, float f2, float f3, float f4, float f5, float f6, boolean bl2) {
        if (n > this.g3d.height * 3) {
            return;
        }
        this.xAf = f;
        this.dxBf = f4 - this.xAf;
        this.yAf = f2;
        this.dyBf = f5 - this.yAf;
        this.zAf = f3;
        this.dzBf = f6 - this.zAf;
        this.xA = (int)Math.floor(this.xAf);
        this.yA = (int)Math.floor(this.yAf);
        this.zA = (int)Math.floor(this.zAf);
        this.dxB = (int)Math.floor(this.dxBf);
        this.dyB = (int)Math.floor(this.dyBf);
        this.dzB = (int)Math.floor(this.dzBf);
        this.xTip = f4;
        this.yTip = f5;
        this.zTip = f6;
        this.colixA = s;
        this.isScreenedA = bl;
        this.shadesA = this.g3d.getShades(s);
        byte by2 = Shade3D.calcIntensity(this.dxB, this.dyB, -this.dzB);
        this.g3d.plotPixelClipped(this.shadesA[by2], this.isScreenedA, (int)f4, (int)f5, (int)f6);
        this.diameter = n;
        if (n <= 1) {
            if (n == 1) {
                this.line3d.plotLineDelta(this.colixA, this.isScreenedA, this.colixA, this.isScreenedA, this.xA, this.yA, this.zA, this.dxB, this.dyB, this.dzB, this.notClipped);
            }
            return;
        }
        this.endcaps = by;
        this.calcArgbEndcap(false);
        this.generateBaseEllipsePrecisely();
        if (this.endcaps == 2) {
            this.renderFlatEndcap(false);
        }
        this.g3d.setZMargin(5);
        int n2 = this.rasterCount;
        while (--n2 >= 0) {
            this.plotRasterCone(n2, bl2);
        }
        this.g3d.setZMargin(0);
    }

    private void generateBaseEllipse() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        int n = this.dxB * this.dxB + this.dyB * this.dyB;
        if (n == 0) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float f = (float)Math.sqrt(n);
            float f2 = (float)Math.sqrt(n + this.dzB * this.dzB);
            this.cosTheta = (float)this.dzB / f2;
            this.cosPhi = (float)this.dxB / f;
            this.sinPhi = (float)this.dyB / f;
        }
        this.calcRotatedPoint(0.0f, 0, false);
        this.calcRotatedPoint(0.5f, 1, false);
        this.calcRotatedPoint(1.0f, 2, false);
        this.rasterCount = 3;
        this.interpolate(0, 1);
        this.interpolate(1, 2);
    }

    private void generateBaseEllipsePrecisely() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        float f = this.dxBf * this.dxBf + this.dyBf * this.dyBf;
        if (f == 0.0f) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float f2 = (float)Math.sqrt(f);
            float f3 = (float)Math.sqrt(f + this.dzBf * this.dzBf);
            this.cosTheta = this.dzBf / f3;
            this.cosPhi = this.dxBf / f2;
            this.sinPhi = this.dyBf / f2;
        }
        this.calcRotatedPoint(0.0f, 0, true);
        this.calcRotatedPoint(0.5f, 1, true);
        this.calcRotatedPoint(1.0f, 2, true);
        this.rasterCount = 3;
        this.interpolatePrecisely(0, 1);
        this.interpolatePrecisely(1, 2);
        for (int i = 0; i < this.rasterCount; ++i) {
            this.xRaster[i] = (int)Math.floor(this.txRaster[i]);
            this.yRaster[i] = (int)Math.floor(this.tyRaster[i]);
            this.zRaster[i] = (int)Math.floor(this.tzRaster[i]);
        }
    }

    private void calcRotatedPoint(float f, int n, boolean bl) {
        double d;
        double d2;
        double d3;
        this.tRaster[n] = f;
        double d4 = (double)f * Math.PI;
        double d5 = Math.sin(d4) * (double)this.cosTheta;
        double d6 = (double)this.radius * (d5 * (double)this.cosPhi - (d3 = Math.cos(d4)) * (double)this.sinPhi);
        double d7 = (double)this.radius2 - (d6 * d6 + (d2 = (double)this.radius * (d5 * (double)this.sinPhi + d3 * (double)this.cosPhi)) * d2);
        double d8 = d = d7 > 0.0 ? Math.sqrt(d7) : 0.0;
        if (bl) {
            this.txRaster[n] = (float)d6;
            this.tyRaster[n] = (float)d2;
            this.tzRaster[n] = (float)d;
        } else if (this.tEvenDiameter) {
            this.xRaster[n] = (int)(d6 - 0.5);
            this.yRaster[n] = (int)(d2 - 0.5);
            this.zRaster[n] = (int)(d + 0.5);
        } else {
            this.xRaster[n] = (int)d6;
            this.yRaster[n] = (int)d2;
            this.zRaster[n] = (int)(d + 0.5);
        }
        this.fp8IntensityUp[n] = Shade3D.calcFp8Intensity((float)d6, (float)d2, (float)d);
    }

    private void interpolate(int n, int n2) {
        int n3;
        int n4 = this.xRaster[n2] - this.xRaster[n];
        if (n4 < 0) {
            n4 = -n4;
        }
        if ((n3 = this.yRaster[n2] - this.yRaster[n]) < 0) {
            n3 = -n3;
        }
        if (n4 + n3 <= 1) {
            return;
        }
        float f = this.tRaster[n];
        float f2 = this.tRaster[n2];
        int n5 = this.allocRaster(false);
        int n6 = 4;
        while (--n6 >= 0) {
            float f3 = (f + f2) / 2.0f;
            this.calcRotatedPoint(f3, n5, false);
            if (this.xRaster[n5] == this.xRaster[n] && this.yRaster[n5] == this.yRaster[n]) {
                this.fp8IntensityUp[n] = this.fp8IntensityUp[n] + this.fp8IntensityUp[n5] >>> 1;
                f = f3;
                continue;
            }
            if (this.xRaster[n5] == this.xRaster[n2] && this.yRaster[n5] == this.yRaster[n2]) {
                this.fp8IntensityUp[n2] = this.fp8IntensityUp[n2] + this.fp8IntensityUp[n5] >>> 1;
                f2 = f3;
                continue;
            }
            this.interpolate(n, n5);
            this.interpolate(n5, n2);
            return;
        }
        this.xRaster[n5] = this.xRaster[n];
        this.yRaster[n5] = this.yRaster[n2];
    }

    private void interpolatePrecisely(int n, int n2) {
        float f;
        int n3 = (int)Math.floor(this.txRaster[n2]) - (int)Math.floor(this.txRaster[n]);
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((f = (float)((int)Math.floor(this.tyRaster[n2]) - (int)Math.floor(this.tyRaster[n]))) < 0.0f) {
            f = -f;
        }
        if ((float)n3 + f <= 1.0f) {
            return;
        }
        float f2 = this.tRaster[n];
        float f3 = this.tRaster[n2];
        int n4 = this.allocRaster(true);
        int n5 = 4;
        while (--n5 >= 0) {
            float f4 = (f2 + f3) / 2.0f;
            this.calcRotatedPoint(f4, n4, true);
            if ((int)Math.floor(this.txRaster[n4]) == (int)Math.floor(this.txRaster[n]) && (int)Math.floor(this.tyRaster[n4]) == (int)Math.floor(this.tyRaster[n])) {
                this.fp8IntensityUp[n] = this.fp8IntensityUp[n] + this.fp8IntensityUp[n4] >>> 1;
                f2 = f4;
                continue;
            }
            if ((int)Math.floor(this.txRaster[n4]) == (int)Math.floor(this.txRaster[n2]) && (int)Math.floor(this.tyRaster[n4]) == (int)Math.floor(this.tyRaster[n2])) {
                this.fp8IntensityUp[n2] = this.fp8IntensityUp[n2] + this.fp8IntensityUp[n4] >>> 1;
                f3 = f4;
                continue;
            }
            this.interpolatePrecisely(n, n4);
            this.interpolatePrecisely(n4, n2);
            return;
        }
        this.txRaster[n4] = this.txRaster[n];
        this.tyRaster[n4] = this.tyRaster[n2];
    }

    private void plotRaster(int n) {
        int n2 = this.fp8IntensityUp[n] >> 8 + this.zShift;
        int n3 = n2 >> 1;
        int n4 = this.xRaster[n];
        int n5 = this.yRaster[n];
        int n6 = this.zRaster[n];
        if (this.tEndcapOpen && this.argbEndcap != 0) {
            if (this.notClipped) {
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap + n4, this.yEndcap + n5, this.zEndcap - n6 - 1);
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap - n4, this.yEndcap - n5, this.zEndcap + n6 - 1);
            } else {
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap + n4, this.yEndcap + n5, this.zEndcap - n6 - 1);
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap - n4, this.yEndcap - n5, this.zEndcap + n6 - 1);
            }
        }
        this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesB, this.isScreenedB, n2, this.xA + n4, this.yA + n5, this.zA - n6, this.dxB, this.dyB, this.dzB, this.notClipped);
        if (this.drawBackside) {
            this.line3d.plotLineDelta(this.shadesA[n3], this.isScreenedA, this.shadesB[n3], this.isScreenedB, this.xA - n4, this.yA - n5, this.zA + n6, this.dxB, this.dyB, this.dzB, this.notClipped);
        }
    }

    private int[] realloc(int[] nArray) {
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private float[] realloc(float[] fArray) {
        float[] fArray2 = new float[fArray.length * 2];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    private int allocRaster(boolean bl) {
        while (this.rasterCount >= this.xRaster.length) {
            this.xRaster = this.realloc(this.xRaster);
            this.yRaster = this.realloc(this.yRaster);
            this.zRaster = this.realloc(this.zRaster);
            this.tRaster = this.realloc(this.tRaster);
        }
        while (this.rasterCount >= this.fp8IntensityUp.length) {
            this.fp8IntensityUp = this.realloc(this.fp8IntensityUp);
        }
        if (bl) {
            while (this.rasterCount >= this.txRaster.length) {
                this.txRaster = this.realloc(this.txRaster);
                this.tyRaster = this.realloc(this.tyRaster);
                this.tzRaster = this.realloc(this.tzRaster);
            }
        }
        return this.rasterCount++;
    }

    private void findMinMaxY() {
        this.yMin = this.yMax = this.yRaster[0];
        int n = this.rasterCount;
        while (--n > 0) {
            int n2 = this.yRaster[n];
            if (n2 < this.yMin) {
                this.yMin = n2;
                continue;
            }
            if (n2 > this.yMax) {
                this.yMax = n2;
                continue;
            }
            if ((n2 = -n2) < this.yMin) {
                this.yMin = n2;
                continue;
            }
            if (n2 <= this.yMax) continue;
            this.yMax = n2;
        }
    }

    private void findMinMaxX(int n) {
        this.xMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        int n2 = this.rasterCount;
        while (--n2 >= 0) {
            int n3;
            if (this.yRaster[n2] == n) {
                n3 = this.xRaster[n2];
                if (n3 < this.xMin) {
                    this.xMin = n3;
                    this.zXMin = this.zRaster[n2];
                }
                if (n3 > this.xMax) {
                    this.xMax = n3;
                    this.zXMax = this.zRaster[n2];
                }
            }
            if (this.yRaster[n2] != -n) continue;
            n3 = -this.xRaster[n2];
            if (n3 < this.xMin) {
                this.xMin = n3;
                this.zXMin = -this.zRaster[n2];
            }
            if (n3 <= this.xMax) continue;
            this.xMax = n3;
            this.zXMax = -this.zRaster[n2];
        }
    }

    private void renderFlatEndcap(boolean bl) {
        if (this.dzB == 0 || !this.g3d.setColix(this.colixEndcap)) {
            return;
        }
        int n = this.xA;
        int n2 = this.yA;
        int n3 = this.zA;
        if (bl && this.dzB < 0) {
            n += this.dxB;
            n2 += this.dyB;
            n3 += this.dzB;
        }
        this.findMinMaxY();
        for (int i = this.yMin; i <= this.yMax; ++i) {
            this.findMinMaxX(i);
            int n4 = this.xMax - this.xMin + 1;
            this.g3d.setColorNoisy(this.intensityEndcap);
            this.g3d.plotPixelsClipped(n4, n + this.xMin, n2 + i, n3 - this.zXMin - 1, n3 - this.zXMax - 1, null, null);
        }
    }

    private void renderSphericalEndcaps() {
        if (this.colixA != 0 && this.g3d.setColix(this.colixA)) {
            this.g3d.fillSphereCentered(this.diameter, this.xA, this.yA, this.zA + 1);
        }
        if (this.colixB != 0 && this.g3d.setColix(this.colixB)) {
            this.g3d.fillSphereCentered(this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
        }
    }

    private void plotRasterCone(int n, boolean bl) {
        float f = this.txRaster[n];
        float f2 = this.tyRaster[n];
        float f3 = this.tzRaster[n];
        float f4 = this.xAf + f;
        float f5 = this.yAf + f2;
        float f6 = this.zAf - f3;
        float f7 = this.xAf - f;
        float f8 = this.yAf - f2;
        float f9 = this.zAf + f3;
        int n2 = this.shadesA[0];
        if (this.tEndcapOpen && this.argbEndcap != 0) {
            this.g3d.plotPixelClipped(this.argbEndcap, this.isScreenedA, (int)f4, (int)f5, (int)f6);
            this.g3d.plotPixelClipped(this.argbEndcap, this.isScreenedA, (int)f7, (int)f8, (int)f9);
        }
        int n3 = this.fp8IntensityUp[n] >> 8 + this.zShift;
        if (n2 != 0) {
            this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, n3, (int)f4, (int)f5, (int)f6, (int)Math.ceil(this.xTip - f4), (int)Math.ceil(this.yTip - f5), (int)Math.ceil(this.zTip - f6), false);
            if (bl) {
                this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, n3, (int)f4, (int)f5 + 1, (int)f6, (int)Math.ceil(this.xTip - f4), (int)Math.ceil(this.yTip - f5) + 1, (int)Math.ceil(this.zTip - f6), false);
                this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, n3, (int)f4 + 1, (int)f5, (int)f6, (int)Math.ceil(this.xTip - f4) + 1, (int)Math.ceil(this.yTip - f5), (int)Math.ceil(this.zTip - f6), false);
            }
            if (this.endcaps != 2 || this.dzB <= 0) {
                this.line3d.plotLineDelta(n2, this.isScreenedA, n2, this.isScreenedA, (int)f7, (int)f8, (int)f9, (int)Math.ceil(this.xTip - f7), (int)Math.ceil(this.yTip - f8), (int)Math.ceil(this.zTip - f9), false);
            }
        }
    }

    private void calcArgbEndcap(boolean bl) {
        int[] nArray;
        this.tEndcapOpen = false;
        if (this.endcaps == 3 || this.dzB == 0) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        if (this.dzB >= 0 || !bl) {
            this.intensityEndcap = Shade3D.calcIntensity(-this.dxB, -this.dyB, this.dzB);
            this.colixEndcap = this.colixA;
            nArray = this.shadesA;
        } else {
            this.intensityEndcap = Shade3D.calcIntensity(this.dxB, this.dyB, -this.dzB);
            this.colixEndcap = this.colixB;
            nArray = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.intensityEndcap > Graphics3D.intensitySpecularSurfaceLimit) {
            this.intensityEndcap = Graphics3D.intensitySpecularSurfaceLimit;
        }
        this.argbEndcap = nArray[this.intensityEndcap];
        this.tEndcapOpen = this.endcaps == 1;
    }
}

