/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.cifpdb.CifReader;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public class XmlCmlReader
extends XmlReader {
    String[] cmlImplementedAttributes = new String[]{"id", "title", "x3", "y3", "z3", "x2", "y2", "elementType", "formalCharge", "atomId", "atomRefs2", "order", "atomRef1", "atomRef2", "dictRef", "spaceGroup"};
    int atomCount;
    Atom[] atomArray = new Atom[100];
    int bondCount;
    Bond[] bondArray = new Bond[100];
    int tokenCount;
    String[] tokens = new String[16];
    protected final int START = 0;
    protected final int CML = 1;
    protected final int CRYSTAL = 2;
    protected final int CRYSTAL_SCALAR = 3;
    protected final int CRYSTAL_SYMMETRY = 4;
    protected final int CRYSTAL_SYMMETRY_TRANSFORM3 = 5;
    protected final int MOLECULE = 6;
    protected final int MOLECULE_ATOM_ARRAY = 7;
    protected final int MOLECULE_ATOM = 8;
    protected final int MOLECULE_ATOM_SCALAR = 9;
    protected final int MOLECULE_BOND_ARRAY = 10;
    protected final int MOLECULE_BOND = 11;
    protected final int MOLECULE_FORMULA = 12;
    protected final int MOLECULE_ATOM_BUILTIN = 13;
    protected final int MOLECULE_BOND_BUILTIN = 14;
    protected int state = 0;
    String scalarDictRef;
    String scalarDictValue;
    String scalarTitle;
    String cellParameterType;
    int moleculeNesting = 0;
    boolean embeddedCrystal = false;

    XmlCmlReader() {
    }

    XmlCmlReader(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.parent = xmlReader;
        this.reader = bufferedReader;
        this.atomSetCollection = atomSetCollection;
        new CmlHandler(xMLReader);
        this.parseReaderXML(xMLReader);
    }

    XmlCmlReader(XmlReader xmlReader, AtomSetCollection atomSetCollection, JSObject jSObject) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.cmlImplementedAttributes;
        new CmlHandler().walkDOMTree(jSObject);
    }

    public void processStartElement(String string, String string2, String string3, HashMap hashMap) {
        switch (this.state) {
            case 0: {
                if (string2.equals("molecule")) {
                    this.state = 6;
                    if (this.moleculeNesting == 0) {
                        this.createNewAtomSet(hashMap);
                    }
                    ++this.moleculeNesting;
                }
                if (!string2.equals("crystal")) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (string2.equals("scalar")) {
                    this.state = 3;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)hashMap.get("title");
                    this.scalarDictRef = (String)hashMap.get("dictRef");
                    if (this.scalarDictRef == null) break;
                    int n = this.scalarDictRef.indexOf(":");
                    this.scalarDictValue = this.scalarDictRef.substring(n + 1);
                    break;
                }
                if (string2.equals("symmetry")) {
                    this.state = 4;
                    if (!hashMap.containsKey("spaceGroup")) break;
                    String string4 = (String)hashMap.get("spaceGroup");
                    for (int i = 0; i < string4.length(); ++i) {
                        if (string4.charAt(i) != '_') continue;
                        string4 = string4.substring(0, i) + string4.substring(i-- + 1);
                    }
                    this.parent.setSpaceGroupName(string4);
                    break;
                }
                if (!string2.equals("cellParameter") || !hashMap.containsKey("parameterType")) break;
                this.cellParameterType = (String)hashMap.get("parameterType");
                this.setKeepChars(true);
                break;
            }
            case 3: 
            case 4: {
                if (!string2.equals("transform3")) break;
                this.state = 5;
                break;
            }
            case 5: 
            case 6: {
                int n;
                if (string2.equals("crystal")) {
                    this.state = 2;
                    this.embeddedCrystal = true;
                }
                if (string2.equals("molecule")) {
                    this.state = 6;
                    ++this.moleculeNesting;
                }
                if (string2.equals("bondArray")) {
                    this.state = 10;
                    this.bondCount = 0;
                    if (hashMap.containsKey("order")) {
                        this.breakOutBondTokens((String)hashMap.get("order"));
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].order = this.parseBondToken(this.tokens[n]);
                        }
                    }
                    if (hashMap.containsKey("atomRef1")) {
                        this.breakOutBondTokens((String)hashMap.get("atomRef1"));
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].atomIndex1 = this.atomSetCollection.getAtomNameIndex(this.tokens[n]);
                        }
                    }
                    if (hashMap.containsKey("atomRef2")) {
                        this.breakOutBondTokens((String)hashMap.get("atomRef2"));
                        n = this.tokenCount;
                        while (--n >= 0) {
                            this.bondArray[n].atomIndex2 = this.atomSetCollection.getAtomNameIndex(this.tokens[n]);
                        }
                    }
                }
                if (string2.equals("atomArray")) {
                    int n2;
                    this.state = 7;
                    this.atomCount = 0;
                    n = 0;
                    if (hashMap.containsKey("atomID")) {
                        this.breakOutAtomTokens((String)hashMap.get("atomID"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].atomName = this.tokens[n2];
                        }
                    }
                    if (hashMap.containsKey("x3")) {
                        n = 1;
                        this.breakOutAtomTokens((String)hashMap.get("x3"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].x = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (hashMap.containsKey("y3")) {
                        this.breakOutAtomTokens((String)hashMap.get("y3"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].y = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (hashMap.containsKey("z3")) {
                        this.breakOutAtomTokens((String)hashMap.get("z3"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].z = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (hashMap.containsKey("x2")) {
                        this.breakOutAtomTokens((String)hashMap.get("x2"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].x = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (hashMap.containsKey("y2")) {
                        this.breakOutAtomTokens((String)hashMap.get("y2"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].y = this.parseFloat(this.tokens[n2]);
                        }
                    }
                    if (hashMap.containsKey("elementType")) {
                        this.breakOutAtomTokens((String)hashMap.get("elementType"));
                        n2 = this.tokenCount;
                        while (--n2 >= 0) {
                            this.atomArray[n2].elementSymbol = this.tokens[n2];
                        }
                    }
                    n2 = this.atomCount;
                    while (--n2 >= 0) {
                        Atom atom = this.atomArray[n2];
                        if (n == 0) {
                            atom.z = 0.0f;
                        }
                        this.parent.setAtomCoord(atom);
                    }
                }
                if (!string2.equals("formula")) break;
                this.state = 12;
                break;
            }
            case 10: {
                if (!string2.equals("bond")) break;
                this.state = 11;
                int n = -1;
                this.tokenCount = 0;
                if (hashMap.containsKey("atomRefs2")) {
                    this.breakOutTokens((String)hashMap.get("atomRefs2"));
                }
                if (hashMap.containsKey("order")) {
                    n = this.parseBondToken((String)hashMap.get("order"));
                }
                if (this.tokenCount != 2 || n <= 0) break;
                this.atomSetCollection.addNewBond(this.tokens[0], this.tokens[1], n);
                break;
            }
            case 7: {
                if (!string2.equals("atom")) break;
                this.state = 8;
                this.atom = new Atom();
                boolean bl = false;
                boolean bl2 = false;
                this.parent.setFractionalCoordinates(false);
                this.atom.atomName = hashMap.containsKey("label") ? (String)hashMap.get("label") : (String)hashMap.get("id");
                if (hashMap.containsKey("xFract") && (this.parent.iHaveUnitCell || !hashMap.containsKey("x3"))) {
                    bl2 = true;
                    bl = true;
                    this.parent.setFractionalCoordinates(true);
                    this.parent.setAtomCoord(this.atom, this.parseFloat((String)hashMap.get("xFract")), this.parseFloat((String)hashMap.get("yFract")), this.parseFloat((String)hashMap.get("zFract")));
                }
                if (hashMap.containsKey("x3") && !bl2) {
                    bl = true;
                    this.atom.x = this.parseFloat((String)hashMap.get("x3"));
                    this.atom.y = this.parseFloat((String)hashMap.get("y3"));
                    this.atom.z = this.parseFloat((String)hashMap.get("z3"));
                }
                if (hashMap.containsKey("x2") && !bl) {
                    this.atom.x = this.parseFloat((String)hashMap.get("x2"));
                    this.atom.y = this.parseFloat((String)hashMap.get("y2"));
                    this.atom.z = 0.0f;
                }
                this.parent.setAtomCoord(this.atom);
                if (hashMap.containsKey("elementType")) {
                    this.atom.elementSymbol = (String)hashMap.get("elementType");
                }
                if (!hashMap.containsKey("formalCharge")) break;
                this.atom.formalCharge = this.parseInt((String)hashMap.get("formalCharge"));
                break;
            }
            case 11: {
                if (!hashMap.containsKey("builtin")) break;
                this.setKeepChars(true);
                this.state = 14;
                this.scalarDictValue = (String)hashMap.get("builtin");
                break;
            }
            case 8: {
                if (string2.equals("scalar")) {
                    this.state = 9;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)hashMap.get("title");
                    this.scalarDictRef = (String)hashMap.get("dictRef");
                    if (this.scalarDictRef == null) break;
                    int n = this.scalarDictRef.indexOf(":");
                    this.scalarDictValue = this.scalarDictRef.substring(n + 1);
                    break;
                }
                if (!hashMap.containsKey("builtin")) break;
                this.setKeepChars(true);
                this.state = 13;
                this.scalarDictValue = (String)hashMap.get("builtin");
                break;
            }
            case 9: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
        }
    }

    public void processEndElement(String string, String string2, String string3) {
        switch (this.state) {
            case 2: {
                if (string2.equals("crystal")) {
                    if (this.embeddedCrystal) {
                        this.state = 6;
                        this.embeddedCrystal = false;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                if (!string2.equals("cellParameter") || !this.keepChars) break;
                String[] stringArray = AtomSetCollectionReader.getTokens(this.chars);
                this.setKeepChars(false);
                if (stringArray.length == 3 && this.cellParameterType != null) {
                    if (this.cellParameterType.equals("length")) {
                        this.parent.needToApplySymmetry = true;
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i, this.parseFloat(stringArray[i]));
                        }
                        break;
                    }
                    if (this.cellParameterType.equals("angle")) {
                        for (int i = 0; i < 3; ++i) {
                            this.parent.setUnitCellItem(i + 3, this.parseFloat(stringArray[i]));
                        }
                        this.applySymmetry();
                        break;
                    }
                }
                Logger.error("bad cellParameter information: parameterType=" + this.cellParameterType + " data=" + this.chars);
                this.parent.setFractionalCoordinates(false);
                break;
            }
            case 3: {
                if (string2.equals("scalar")) {
                    int n;
                    this.state = 2;
                    if (this.scalarTitle != null) {
                        n = 6;
                        while (--n >= 0 && !this.scalarTitle.equals(AtomSetCollection.notionalUnitcellTags[n])) {
                        }
                        if (n >= 0) {
                            this.parent.setUnitCellItem(n, this.parseFloat(this.chars));
                        }
                    }
                    if (this.scalarDictRef != null) {
                        n = 6;
                        while (--n >= 0 && !this.scalarDictValue.equals(CifReader.cellParamNames[n])) {
                        }
                        if (n >= 0) {
                            this.parent.setUnitCellItem(n, this.parseFloat(this.chars));
                        }
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 4: {
                if (!string2.equals("symmetry")) break;
                this.state = 2;
                break;
            }
            case 5: {
                if (!string2.equals("transform3")) break;
                this.state = 4;
                break;
            }
            case 6: {
                if (!string2.equals("molecule")) break;
                if (--this.moleculeNesting == 0) {
                    this.applySymmetry();
                    this.state = 0;
                    break;
                }
                this.state = 6;
                break;
            }
            case 10: {
                if (!string2.equals("bondArray")) break;
                this.state = 6;
                for (int i = 0; i < this.bondCount; ++i) {
                    this.atomSetCollection.addBond(this.bondArray[i]);
                }
                break;
            }
            case 7: {
                if (!string2.equals("atomArray")) break;
                this.state = 6;
                for (int i = 0; i < this.atomCount; ++i) {
                    Atom atom = this.atomArray[i];
                    if (atom.elementSymbol == null || Float.isNaN(atom.z)) continue;
                    this.atomSetCollection.addAtomWithMappedName(atom);
                }
                break;
            }
            case 11: {
                if (!string2.equals("bond")) break;
                this.state = 10;
                break;
            }
            case 8: {
                if (!string2.equals("atom")) break;
                this.state = 7;
                if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                    this.atomSetCollection.addAtomWithMappedName(this.atom);
                }
                this.atom = null;
                break;
            }
            case 9: {
                if (string2.equals("scalar")) {
                    this.state = 8;
                    if ("jmol:charge".equals(this.scalarDictRef)) {
                        this.atom.partialCharge = this.parseFloat(this.chars);
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 13: {
                this.state = 8;
                if (this.scalarDictValue.equals("x3")) {
                    this.atom.x = this.parseFloat(this.chars);
                } else if (this.scalarDictValue.equals("y3")) {
                    this.atom.y = this.parseFloat(this.chars);
                } else if (this.scalarDictValue.equals("z3")) {
                    this.atom.z = this.parseFloat(this.chars);
                } else if (this.scalarDictValue.equals("elementType")) {
                    this.atom.elementSymbol = this.chars;
                }
                this.setKeepChars(false);
                break;
            }
            case 14: {
                int n;
                this.state = 11;
                if (this.scalarDictValue.equals("atomRef")) {
                    if (this.tokenCount == 0) {
                        this.tokens = new String[2];
                    }
                    if (this.tokenCount < 2) {
                        this.tokens[this.tokenCount++] = this.chars;
                    }
                } else if (this.scalarDictValue.equals("order") && (n = this.parseBondToken(this.chars)) > 0 && this.tokenCount == 2) {
                    this.atomSetCollection.addNewBond(this.tokens[0], this.tokens[1], n);
                }
                this.setKeepChars(false);
                break;
            }
            case 12: {
                this.state = 6;
            }
        }
    }

    int parseBondToken(String string) {
        float f = this.parseFloat(string);
        if (Float.isNaN(f) && string.length() >= 1) {
            string = string.toUpperCase();
            switch (string.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
            }
            return this.parseInt(string);
        }
        if ((double)f == 1.5) {
            return 515;
        }
        if (f == 2.0f) {
            return 2;
        }
        if (f == 3.0f) {
            return 3;
        }
        return 1;
    }

    void breakOutTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.tokenCount = stringTokenizer.countTokens();
        if (this.tokenCount > this.tokens.length) {
            this.tokens = new String[this.tokenCount];
        }
        for (int i = 0; i < this.tokenCount; ++i) {
            try {
                this.tokens[i] = stringTokenizer.nextToken();
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.tokens[i] = null;
            }
        }
    }

    void breakOutAtomTokens(String string) {
        this.breakOutTokens(string);
        this.checkAtomArrayLength(this.tokenCount);
    }

    void checkAtomArrayLength(int n) {
        if (this.atomCount == 0) {
            if (n > this.atomArray.length) {
                this.atomArray = new Atom[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.atomArray[n2] = new Atom();
            }
            this.atomCount = n;
        } else if (n != this.atomCount) {
            throw new IndexOutOfBoundsException("bad atom attribute length");
        }
    }

    void breakOutBondTokens(String string) {
        this.breakOutTokens(string);
        this.checkBondArrayLength(this.tokenCount);
    }

    void checkBondArrayLength(int n) {
        if (this.bondCount == 0) {
            if (n > this.bondArray.length) {
                this.bondArray = new Bond[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                this.bondArray[n2] = new Bond();
            }
            this.bondCount = n;
        } else if (n != this.bondCount) {
            throw new IndexOutOfBoundsException("bad bond attribute length");
        }
    }

    private void createNewAtomSet(HashMap hashMap) {
        this.atomSetCollection.newAtomSet();
        String string = null;
        if (hashMap.containsKey("title")) {
            string = (String)hashMap.get("title");
        } else if (hashMap.containsKey("id")) {
            string = (String)hashMap.get("id");
        }
        if (string != null) {
            this.atomSetCollection.setAtomSetName(string);
        }
    }

    public void applySymmetry() {
        try {
            this.parent.applySymmetry();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error("applySymmetry failed: " + exception);
        }
    }

    class CmlHandler
    extends XmlReader.JmolXmlHandler {
        CmlHandler() {
            super(XmlCmlReader.this);
        }

        CmlHandler(XMLReader xMLReader) {
            super(XmlCmlReader.this);
            this.setHandler(xMLReader, this);
        }
    }
}

