/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;

public class AdfReader
extends AtomSetCollectionReader {
    String energy = null;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.atomSetCollection = new AtomSetCollection("adf");
        this.reader = bufferedReader;
        boolean bl = false;
        this.modelNumber = 0;
        try {
            while (this.readLine() != null) {
                if (this.line.indexOf("Coordinates (Cartesian)") >= 0 || this.line.indexOf("G E O M E T R Y  ***  3D  Molecule  ***") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!bl) continue;
                        break;
                    }
                    bl = true;
                    this.readCoordinates();
                    continue;
                }
                if (this.line.indexOf("Energy:") >= 0) {
                    String[] stringArray = this.getTokens();
                    this.energy = stringArray[1];
                    continue;
                }
                if (this.line.indexOf("Vibrations") < 0) continue;
                this.readFrequencies();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void readCoordinates() throws Exception {
        String[] stringArray;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName("" + this.energy);
        this.discardLinesUntilContains("----");
        while (this.readLine() != null && !this.line.startsWith(" -----") && (stringArray = this.getTokens()).length >= 5) {
            String string = stringArray[1];
            if (JmolAdapter.getElementNumber(string) < 1) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.set(this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
            if (stringArray.length <= 8) continue;
            atom.scale(0.5291772f);
        }
    }

    private void readFrequencies() throws Exception {
        this.readLine();
        int n = this.atomSetCollection.getLastAtomSetAtomCount();
        while (this.readLine() != null) {
            int n2;
            while (this.readLine() != null && this.line.indexOf(".") < 0 && this.line.indexOf("====") < 0) {
            }
            if (this.line == null || this.line.indexOf(".") < 0) {
                return;
            }
            String[] stringArray = this.getTokens();
            this.readLine();
            int n3 = stringArray.length;
            int n4 = this.atomSetCollection.getAtomCount();
            for (n2 = 0; n2 < n3; ++n2) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(stringArray[n2] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", stringArray[n2] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
            }
            n2 = 0;
            while (this.readLine() != null && this.line.indexOf(".") >= 0) {
                String[] stringArray2 = this.getTokens();
                String string = stringArray2[0].substring(stringArray2[0].indexOf(".") + 1);
                if (JmolAdapter.getElementNumber(string) < 1) continue;
                int n5 = 1;
                for (int i = 0; i < n3; ++i) {
                    int n6 = n4 + i * n + n2;
                    Atom atom = this.atomSetCollection.getAtom(n6);
                    float f = this.parseFloat(stringArray2[n5++]);
                    float f2 = this.parseFloat(stringArray2[n5++]);
                    float f3 = this.parseFloat(stringArray2[n5++]);
                    atom.addVibrationVector(f, f2, f3);
                }
                ++n2;
            }
        }
    }
}

