/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.java.BS;
import org.jmol.quantum.QS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class GaussianReader
extends MOReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private String energyString = "";
    private String energyKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    private int stepNumber;
    private int moModelSet = -1;
    private BS namedSets = new BS();

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Step number")) {
            this.equivalentAtomSets = 0;
            ++this.stepNumber;
            int n = this.line.indexOf("scan point");
            this.scanPoint = n > 0 ? this.parseIntAt(this.line, n + 10) : -1;
            return true;
        }
        if (this.line.indexOf("-- Stationary point found") > 0) {
            if (this.scanPoint >= 0) {
                ++this.scanPoint;
            }
            return true;
        }
        if (this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            Logger.info(this.asc.atomSetCount + " model " + this.modelNumber + " step " + this.stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
            this.readAtoms();
            return false;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" Energy=")) {
            this.setEnergy();
            return true;
        }
        if (this.line.startsWith(" SCF Done:")) {
            this.readSCFDone();
            return true;
        }
        if (this.line.startsWith(" Harmonic frequencies")) {
            this.readFrequencies(":", true);
            return true;
        }
        if (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" Dipole moment")) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.startsWith(" Standard basis:") || this.line.startsWith(" General basis read from")) {
            this.energyUnits = "";
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" AO basis set")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0 || this.line.indexOf("Natural Orbital Coefficients") >= 0 || this.line.indexOf("Natural Transition Orbitals") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals();
            Logger.info(this.orbitals.size() + " molecular orbitals read");
            return true;
        }
        if (this.line.startsWith(" Normal termination of Gaussian")) {
            ++this.calculationNumber;
            this.equivalentAtomSets = 0;
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        String[] stringArray = PT.getTokensAt(this.line, 11);
        if (stringArray.length < 4) {
            return;
        }
        this.energyKey = stringArray[0];
        this.asc.setAtomSetEnergy(stringArray[2], this.parseFloatStr(stringArray[2]));
        this.energyString = stringArray[2] + " " + stringArray[3];
        this.setNames(this.energyKey + " = " + this.energyString, this.namedSets, this.equivalentAtomSets);
        this.setProps(this.energyKey, this.energyString, this.equivalentAtomSets);
        stringArray = PT.getTokens(this.rd());
        if (stringArray.length > 2) {
            this.setProps(stringArray[0], stringArray[2], this.equivalentAtomSets);
            if (stringArray.length > 5) {
                this.setProps(stringArray[3], stringArray[5], this.equivalentAtomSets);
            }
            stringArray = PT.getTokens(this.rd());
        }
        if (stringArray.length > 2) {
            this.setProps(stringArray[0], stringArray[2], this.equivalentAtomSets);
        }
    }

    private void setProps(String string, String string2, int n) {
        for (int i = this.asc.iSet; --n >= 0 && i >= 0; --i) {
            this.asc.setAtomSetModelPropertyForSet(string, string2, i);
        }
    }

    private void setNames(String string, BS bS, int n) {
        for (int i = this.asc.iSet; --n >= 0 && i >= 0; --i) {
            if (bS != null && bS.get(i)) continue;
            this.asc.setModelInfoForSet("name", string, i);
        }
    }

    private void setEnergy() {
        String[] stringArray = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = stringArray[1];
        this.setNames("Energy = " + stringArray[1], this.namedSets, this.equivalentAtomSets);
        this.asc.setAtomSetEnergy(this.energyString, this.parseFloatStr(this.energyString));
    }

    protected void readAtoms() throws Exception {
        this.asc.newAtomSet();
        if (this.energyKey.length() != 0) {
            this.asc.setAtomSetName(this.energyKey + " = " + this.energyString);
        }
        this.asc.setAtomSetEnergy(this.energyString, this.parseFloatStr(this.energyString));
        String string = this.getTokens()[0];
        this.readLines(4);
        while (this.rd() != null && !this.line.startsWith(" --")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)this.parseIntStr(stringArray[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordTokens(atom, stringArray, stringArray.length - 3);
        }
        this.asc.setAtomSetModelProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + string);
    }

    protected void readBasis() throws Exception {
        int n;
        int n2;
        String string;
        int[] nArray;
        String[] stringArray;
        boolean bl;
        this.shells = new Lst();
        Lst<String[]> lst = new Lst<String[]>();
        int n3 = 0;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String string2 = "";
        boolean bl2 = this.calculationType != null && this.calculationType.indexOf("5D") > 0;
        boolean bl3 = this.calculationType != null && this.calculationType.indexOf("7F") > 0;
        boolean bl4 = bl = this.line.indexOf("general basis input") >= 0;
        if (bl) {
            while (this.rd() != null && this.line.length() > 0) {
                ++this.shellCount;
                stringArray = this.getTokens();
                ++n3;
                while (this.rd().indexOf("****") < 0) {
                    nArray = new int[4];
                    nArray[0] = n3 - 1;
                    stringArray = this.getTokens();
                    string = stringArray[0];
                    nArray[1] = bl3 && string.indexOf("F") >= 0 || bl2 && string.indexOf("D") >= 0 ? BasisFunctionReader.getQuantumShellTagIDSpherical(string) : BasisFunctionReader.getQuantumShellTagID(string);
                    n2 = this.parseIntStr(stringArray[1]);
                    nArray[2] = this.gaussianCount;
                    nArray[3] = n2;
                    if (Logger.debugging) {
                        Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(nArray));
                    }
                    this.shells.addLast(nArray);
                    this.gaussianCount += n2;
                    for (n = 0; n < n2; ++n) {
                        this.rd();
                        this.line = PT.rep(this.line, "D ", "D+");
                        stringArray = this.getTokens();
                        if (Logger.debugging) {
                            Logger.debug("Gaussians " + (n + 1) + " " + Escape.eAS(stringArray, true));
                        }
                        lst.addLast(stringArray);
                    }
                }
            }
        } else {
            while (this.rd() != null && this.line.startsWith(" Atom")) {
                ++this.shellCount;
                stringArray = this.getTokens();
                nArray = new int[4];
                if (!stringArray[1].equals(string2)) {
                    ++n3;
                }
                string2 = stringArray[1];
                nArray[0] = n3 - 1;
                string = stringArray[4];
                nArray[1] = bl3 && string.indexOf("F") >= 0 || bl2 && string.indexOf("D") >= 0 ? BasisFunctionReader.getQuantumShellTagIDSpherical(string) : BasisFunctionReader.getQuantumShellTagID(string);
                n2 = this.parseIntStr(stringArray[5]);
                nArray[2] = this.gaussianCount;
                nArray[3] = n2;
                this.shells.addLast(nArray);
                this.gaussianCount += n2;
                for (n = 0; n < n2; ++n) {
                    lst.addLast(PT.getTokens(this.rd()));
                }
            }
        }
        if (n3 == 0) {
            n3 = 1;
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        for (int i = 0; i < this.gaussianCount; ++i) {
            stringArray = (String[])lst.get(i);
            this.gaussians[i] = new float[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                this.gaussians[i][j] = this.parseFloatStr(stringArray[j]);
            }
        }
        Logger.info(this.shellCount + " slater shells read");
        Logger.info(this.gaussianCount + " gaussian primitives read");
    }

    protected void readMolecularOrbitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        Map<K, V>[] mapArray = AU.createArrayOfHashtable(5);
        Lst<type>[] lstArray = AU.createArrayOfArrayList(5);
        int n = 0;
        boolean bl = this.line.contains("Natural Orbital");
        while (this.rd() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            String[] stringArray;
            if (this.line.indexOf("                    ") == 0) {
                int n2;
                this.addMOData(n, lstArray, mapArray);
                if (bl) {
                    stringArray = this.getTokens();
                    n = stringArray.length;
                    stringArray = PT.getTokens(this.rd());
                } else {
                    stringArray = PT.getTokens(this.rd());
                    n = stringArray.length;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    mapArray[n2] = new Hashtable();
                    lstArray[n2] = new Lst();
                    if (bl) {
                        mapArray[n2].put("occupancy", Float.valueOf(PT.parseFloat(stringArray[n2 + 2])));
                        continue;
                    }
                    String string = stringArray[n2];
                    mapArray[n2].put("symmetry", string);
                    if (string.indexOf("O") >= 0) {
                        mapArray[n2].put("occupancy", Float.valueOf(2.0f));
                        continue;
                    }
                    if (string.indexOf("V") < 0) continue;
                    mapArray[n2].put("occupancy", Float.valueOf(0.0f));
                }
                if (bl) continue;
                this.line = this.rd().substring(21);
                stringArray = this.getTokens();
                if (stringArray.length != n) {
                    stringArray = GaussianReader.getStrings(this.line, n, 10);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    mapArray[n2].put("energy", Float.valueOf(PT.fVal(stringArray[n2])));
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(5) != ' ' && !PT.isDigit(this.line.charAt(5))) continue;
            try {
                this.line = PT.rep(this.line, " 0 ", "0  ");
                stringArray = this.getTokens();
                String string = stringArray[stringArray.length - n - 1].substring(1);
                if (PT.isDigit(string.charAt(0))) {
                    string = string.substring(1);
                }
                if (!QS.isQuantumBasisSupported(string.charAt(0)) && "XYZ".indexOf(string.charAt(0)) >= 0) {
                    string = (string.length() == 2 ? "D" : "F") + string;
                }
                if (!QS.isQuantumBasisSupported(string.charAt(0))) continue;
                stringArray = GaussianReader.getStrings(this.line.substring(this.line.length() - 10 * n), n, 10);
                for (int i = 0; i < n; ++i) {
                    lstArray[i].addLast(stringArray[i]);
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(n, lstArray, mapArray);
        this.setMOData(this.moModelSet != this.asc.atomSetCount);
        this.moModelSet = this.asc.atomSetCount;
    }

    protected void readFrequencies(String string, boolean bl) throws Exception {
        this.discardLinesUntilContains2(string, ":");
        if (this.line == null && bl) {
            throw new Exception("No frequencies encountered");
        }
        while ((this.line = this.rd()) != null && this.line.length() > 15) {
            String[] stringArray = PT.getTokens(this.rd());
            String[] stringArray2 = PT.getTokensAt(this.discardLinesUntilStartsWith(" Frequencies"), 15);
            String[] stringArray3 = PT.getTokensAt(this.discardLinesUntilStartsWith(" Red. masses"), 15);
            String[] stringArray4 = PT.getTokensAt(this.discardLinesUntilStartsWith(" Frc consts"), 15);
            String[] stringArray5 = PT.getTokensAt(this.discardLinesUntilStartsWith(" IR Inten"), 15);
            int n = this.asc.ac;
            int n2 = this.asc.getLastAtomSetAtomCount();
            int n3 = stringArray2.length;
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl2 = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.asc.cloneAtomSetWithBonds(true);
                String string2 = this.asc.setAtomSetFrequency("Calculation " + this.calculationNumber, stringArray[i], stringArray2[i], null);
                this.appendLoadNote("model " + this.asc.atomSetCount + ": " + string2);
                this.namedSets.set(this.asc.iSet);
                this.asc.setAtomSetModelProperty("ReducedMass", stringArray3[i] + " AMU");
                this.asc.setAtomSetModelProperty("ForceConstant", stringArray4[i] + " mDyne/A");
                this.asc.setAtomSetModelProperty("IRIntensity", stringArray5[i] + " KM/Mole");
            }
            this.discardLinesUntilContains(" AN ");
            this.fillFrequencyData(n, n2, n2, blArray, true, 0, 0, null, 0);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] stringArray = PT.getTokens(this.rd());
        if (stringArray.length != 8) {
            return;
        }
        V3 v3 = V3.new3(this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[5]));
        Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + v3);
        this.asc.setCurrentModelInfo("dipole", v3);
    }

    void readPartialCharges() throws Exception {
        this.rd();
        int n = this.asc.ac;
        int n2 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.asc.atoms;
        for (int i = n2; i < n; ++i) {
            float f;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            atomArray[i].partialCharge = f = this.parseFloatStr(PT.getTokens(this.rd())[2]);
        }
        Logger.info("Mulliken charges found for Model " + this.asc.atomSetCount);
    }
}

