/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Animator
extends Applet
implements Runnable {
    private Graphics g;
    private Graphics2D g2d;
    private Graphics dbg;
    private Image dbImage;
    int numberImages;
    Image[] images;
    int width;
    int height;
    int currentFrame;
    int initialised;
    Thread aThread;
    final Object lock;
    Scrollbar slider;
    Choice orbital;
    Button button;
    ActionListener buttonPressed;
    ItemListener orbitalChanged;
    AdjustmentListener l;

    public Animator() {
        this.g2d = (Graphics2D)this.g;
        this.numberImages = 14;
        this.images = new Image[this.numberImages];
        this.width = 400;
        this.height = 597;
        this.currentFrame = 0;
        this.initialised = 0;
        this.lock = new Object();
        this.slider = new Scrollbar(1, 0, 1, 0, this.numberImages);
        this.orbital = new Choice();
        this.button = new Button("Run");
        this.buttonPressed = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Animator.this.makeThread();
            }
        };
        this.orbitalChanged = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = null;
                Animator.this.height = 558;
                if (Animator.this.orbital.getSelectedIndex() == 0) {
                    string = "1s";
                    Animator.this.height = 597;
                }
                if (Animator.this.orbital.getSelectedIndex() == 1) {
                    string = "2s";
                }
                if (Animator.this.orbital.getSelectedIndex() == 2) {
                    string = "2px";
                }
                if (Animator.this.orbital.getSelectedIndex() == 3) {
                    string = "2py";
                }
                if (Animator.this.orbital.getSelectedIndex() == 4) {
                    string = "2pz";
                    Animator.this.height = 507;
                }
                for (int i = 0; i < Animator.this.images.length; ++i) {
                    Animator.this.images[i] = Animator.this.getImage(Animator.this.getDocumentBase(), string + i + ".gif");
                    int n = Animator.this.images[i].getHeight(new Button());
                }
                Animator.this.repaint();
            }
        };
        this.l = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Animator.this.changeImage();
            }
        };
    }

    @Override
    public void init() {
        this.orbital.add("1s");
        this.orbital.add("2s");
        this.orbital.add("2p x");
        this.orbital.add("2p y");
        this.orbital.add("2p z");
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i] = this.getImage(this.getDocumentBase(), "1s" + i + ".gif");
            int n = this.images[i].getHeight(this);
        }
        this.setSize(470, 680);
        this.setBackground(Color.WHITE);
        this.orbital.setIgnoreRepaint(true);
        this.add(this.slider);
        this.add(this.button);
        this.add(this.orbital);
        this.orbital.addItemListener(this.orbitalChanged);
        this.slider.addAdjustmentListener(this.l);
        this.button.addActionListener(this.buttonPressed);
        this.initialised = 1;
    }

    @Override
    public void start() {
        this.aThread = new Thread(this);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.initialised == 1) {
            graphics.drawImage(this.images[this.currentFrame], 70, 0, this.width, this.height, this);
        }
        this.slider.setBounds(0, 150, 20, 300);
        this.button.setBounds(this.getWidth() / 2 - this.button.getWidth() / 2, 605, 90, 30);
        graphics.drawString("Change orbital: ", 120, 675);
        this.orbital.setLocation(220, 660);
    }

    public void makeThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        System.out.println("thread");
        this.button.setEnabled(false);
        for (int i = 0; i < this.numberImages; ++i) {
            this.slider.setValue(i);
            this.changeImage();
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        this.button.setEnabled(true);
        this.stop();
    }

    public void changeImage() {
        System.out.println("Frame: " + this.slider.getValue());
        this.currentFrame = this.slider.getValue();
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        if (this.dbImage == null) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
            this.dbg = this.dbImage.getGraphics();
        }
        this.dbg.setColor(Color.WHITE);
        this.dbg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.dbg.setColor(this.getForeground());
        this.paint(this.dbg);
        graphics.drawImage(this.dbImage, 0, 0, this);
    }
}

