/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.util.Node;
import org.jmol.util.Normix;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Polyhedron {
    int modelIndex;
    public Atom centralAtom;
    public P3[] vertices;
    public int[][] faces;
    int nVertices;
    boolean collapsed = false;
    private BS bsFlat;
    private V3[] normals;
    private short[] normixes;
    public String smiles;
    public String smarts;
    private SymmetryInterface pointGroup;
    private Float volume;
    boolean visible = true;
    boolean isFullyLit;
    public boolean isValid = true;
    public short colixEdge = 0;
    public int visibilityFlags = 0;
    Map<String, Object> info;

    Polyhedron() {
    }

    Polyhedron set(Atom atom, int n, int n2, int n3, P3[] p3Array, V3[] v3Array, BS bS, int[][] nArray, boolean bl) {
        this.centralAtom = atom;
        this.modelIndex = atom.mi;
        this.nVertices = n;
        this.vertices = new P3[n2 + 1];
        this.normals = new V3[n3];
        this.bsFlat = bS;
        this.faces = AU.newInt2((int)n3);
        int n4 = n2 + 1;
        while (--n4 >= 0) {
            this.vertices[n4] = p3Array[n4];
        }
        n4 = n3;
        while (--n4 >= 0) {
            this.normals[n4] = V3.newV((T3)v3Array[n4]);
        }
        n4 = n3;
        while (--n4 >= 0) {
            this.faces[n4] = nArray[n4];
        }
        this.collapsed = bl;
        return this;
    }

    Map<String, Object> getInfo(Viewer viewer, boolean bl) {
        Object object;
        if (bl && this.info != null) {
            return this.info;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (bl) {
            this.info = hashtable;
            hashtable.put("modelIndex", this.centralAtom.mi);
            hashtable.put("modelNumber", this.centralAtom.getModelNumber());
            hashtable.put("center", P3.newP((T3)this.centralAtom));
            hashtable.put("atomNumber", this.centralAtom.getAtomNumber());
            hashtable.put("atomName", this.centralAtom.getInfo());
            hashtable.put("element", this.centralAtom.getElementSymbol());
            hashtable.put("vertexCount", this.nVertices);
            hashtable.put("faceCount", this.faces.length);
            hashtable.put("volume", this.getVolume());
            if (this.smarts != null) {
                hashtable.put("smarts", this.smarts);
            }
            if (this.smiles != null) {
                hashtable.put("smiles", this.smiles);
            }
            if (this.pointGroup != null) {
                hashtable.put("pointGroup", this.pointGroup.getPointGroupName());
            }
            if ((object = (Object)viewer.ms.getInfo((int)this.centralAtom.mi, "Energy")) != null) {
                hashtable.put("energy", object);
            }
        } else {
            hashtable.put("bsFlat", this.bsFlat);
            if (this.collapsed) {
                hashtable.put("collapsed", this.collapsed);
            }
            hashtable.put("ptRef", this.vertices[this.nVertices]);
        }
        hashtable.put("atomIndex", this.centralAtom.i);
        hashtable.put("vertices", AU.arrayCopyPt((T3[])this.vertices, (int)this.nVertices));
        hashtable.put("faces", AU.arrayCopyII((int[][])this.faces, (int)this.faces.length));
        object = new int[this.nVertices];
        for (int i = 0; i < this.nVertices; ++i) {
            P3 p3 = this.vertices[i];
            object[i] = p3 instanceof Node ? ((Node)p3).getElementNumber() : (p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2);
        }
        hashtable.put("elemNos", object);
        return hashtable;
    }

    Polyhedron setInfo(Map<String, SV> map, Atom[] atomArray) {
        try {
            Point3fi point3fi;
            int n;
            this.centralAtom = atomArray[map.get((Object)"atomIndex").intValue];
            this.modelIndex = this.centralAtom.mi;
            Lst lst = map.get("vertices").getList();
            this.vertices = new P3[lst.size() + 1];
            int n2 = this.nVertices = this.vertices.length - 1;
            while (--n2 >= 0) {
                this.vertices[n2] = SV.ptValue((SV)((SV)lst.get(n2)));
            }
            lst = map.get("elemNos").getList();
            n2 = this.nVertices;
            while (--n2 >= 0) {
                n = ((SV)lst.get((int)n2)).intValue;
                if (n <= 0) continue;
                point3fi = new Point3fi();
                point3fi.setT((T3)this.vertices[n2]);
                point3fi.sD = (short)n;
                this.vertices[n2] = point3fi;
            }
            this.vertices[this.nVertices] = SV.ptValue((SV)map.get("ptRef"));
            lst = map.get("faces").getList();
            this.faces = AU.newInt2((int)lst.size());
            this.normals = new V3[this.faces.length];
            V3 v3 = new V3();
            n = this.faces.length;
            while (--n >= 0) {
                point3fi = ((SV)lst.get(n)).getList();
                int[] nArray = new int[point3fi.size()];
                int n3 = nArray.length;
                while (--n3 >= 0) {
                    nArray[n3] = ((SV)point3fi.get((int)n3)).intValue;
                }
                this.faces[n] = nArray;
                this.normals[n] = new V3();
                Measure.getNormalThroughPoints((T3)this.vertices[nArray[0]], (T3)this.vertices[nArray[1]], (T3)this.vertices[nArray[2]], (V3)this.normals[n], (V3)v3);
            }
            this.bsFlat = SV.getBitSet((SV)map.get("bsFlat"), (boolean)false);
            this.collapsed = map.containsKey("collapsed");
        }
        catch (Exception exception) {
            return null;
        }
        return this;
    }

    void getSymmetry(Viewer viewer, boolean bl) {
        this.info = null;
        SmilesMatcherInterface smilesMatcherInterface = viewer.getSmilesMatcher();
        try {
            if (this.smarts == null) {
                this.smarts = smilesMatcherInterface.polyhedronToSmiles(this.faces, this.nVertices, null);
                this.smiles = smilesMatcherInterface.polyhedronToSmiles(this.faces, this.nVertices, this.vertices);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.pointGroup == null && bl) {
            this.pointGroup = viewer.ms.getSymTemp(true).setPointGroup(null, (T3[])this.vertices, null, false, viewer.getFloat(0x22000026), viewer.getFloat(0x22000028), true);
        }
    }

    private Float getVolume() {
        if (this.volume != null) {
            return this.volume;
        }
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        float f = 0.0f;
        int n = this.faces.length;
        while (--n >= 0) {
            int[] nArray = this.faces[n];
            int n2 = nArray.length - 2;
            while (--n2 >= 0) {
                if (nArray[n2 + 2] < 0) continue;
                f += this.triangleVolume(nArray[n2], nArray[n2 + 1], nArray[n2 + 2], v3, v32, v33);
            }
        }
        return Float.valueOf(f / 6.0f);
    }

    private float triangleVolume(int n, int n2, int n3, V3 v3, V3 v32, V3 v33) {
        v3.setT((T3)this.vertices[n]);
        v32.setT((T3)this.vertices[n2]);
        v33.cross((T3)v3, (T3)v32);
        v32.setT((T3)this.vertices[n3]);
        return v32.dot((T3)v33);
    }

    String getState(Viewer viewer) {
        return "  var p = " + Escape.e(this.getInfo(viewer, false)) + ";polyhedron @p" + (this.isFullyLit ? " fullyLit" : "") + ";" + (this.visible ? "" : "polyhedra ({" + this.centralAtom.i + "}) off;") + "\n";
    }

    public void move(M4 m4) {
        int n;
        this.info = null;
        for (n = 0; n < this.nVertices; ++n) {
            P3 p3 = this.vertices[n];
            if (p3 instanceof Atom) {
                p3 = this.vertices[n] = P3.newP((T3)p3);
            }
            m4.rotTrans((T3)p3);
        }
        n = this.normals.length;
        while (--n >= 0) {
            m4.rotate((T3)this.normals[n]);
        }
        this.normixes = null;
    }

    public short[] getNormixes() {
        if (this.normixes == null) {
            this.normixes = new short[this.normals.length];
            BS bS = new BS();
            int n = this.normals.length;
            while (--n >= 0) {
                this.normixes[n] = this.bsFlat.get(n) ? Normix.get2SidedNormix((V3)this.normals[n], (BS)bS) : Normix.getNormixV((V3)this.normals[n], (BS)bS);
            }
        }
        return this.normixes;
    }
}

