/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.SV;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class Polyhedra
extends AtomShape {
    private static final float DEFAULT_DISTANCE_FACTOR = 1.85f;
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    public static final int EDGES_ALL = 1;
    public static final int EDGES_FRONT = 2;
    private static final int MAX_VERTICES = 250;
    private static final int FACE_COUNT_MAX = 247;
    private P3[] otherAtoms = new P3[251];
    private V3[] normalsT = new V3[251];
    private int[][] planesT = new int[250][3];
    private static final P3 randomPoint = P3.new3((float)3141.0f, (float)2718.0f, (float)1414.0f);
    private static final int MODE_BONDING = 1;
    private static final int MODE_POINTS = 2;
    private static final int MODE_ITERATE = 3;
    private static final int MODE_BITSET = 4;
    private static final int MODE_UNITCELL = 5;
    private static final int MODE_INFO = 6;
    private static final float DEFAULT_PLANAR_PARAM = 0.98f;
    public int polyhedronCount;
    public Polyhedron[] polyhedrons = new Polyhedron[32];
    public int drawEdges;
    private float radius;
    private int nVertices;
    float faceCenterOffset;
    float distanceFactor = Float.NaN;
    boolean isCollapsed;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BS centers;
    private BS bsVertices;
    private BS bsVertexCount;
    private boolean useUnitCell;
    private int nPoints;
    private float planarParam;
    private Map<String, SV> info;
    private V3 align1 = new V3();
    private V3 align2 = new V3();
    private final V3 vAB = new V3();
    private static float minDistanceForPlanarity = 0.1f;

    public void setProperty(String string, Object object, BS bS) {
        int n;
        int n2;
        if ("init" == string) {
            this.faceCenterOffset = 0.25f;
            this.planarParam = Float.NaN;
            this.distanceFactor = Float.NaN;
            this.radius = 0.0f;
            this.nVertices = 0;
            this.nPoints = 0;
            this.bsVertices = null;
            this.useUnitCell = false;
            this.centers = null;
            this.info = null;
            this.bsVertexCount = new BS();
            this.iHaveCenterBitSet = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            this.haveBitSetVertices = false;
            if (Boolean.TRUE == object) {
                this.drawEdges = 0;
            }
            return;
        }
        if ("generate" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
                this.iHaveCenterBitSet = true;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("collapsed" == string) {
            this.isCollapsed = (Boolean)object;
            return;
        }
        if ("nVertices" == string) {
            int n3 = (Integer)object;
            if (n3 < 0) {
                if (-n3 >= this.nVertices) {
                    this.bsVertexCount.setBits(this.nVertices, 1 - n3);
                    this.nVertices = -n3;
                }
            } else {
                this.nVertices = n3;
                this.bsVertexCount.set(this.nVertices);
            }
            return;
        }
        if ("centers" == string) {
            this.centers = (BS)object;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("unitCell" == string) {
            this.useUnitCell = true;
            return;
        }
        if ("to" == string) {
            this.bsVertices = (BS)object;
            return;
        }
        if ("toBitSet" == string) {
            this.bsVertices = (BS)object;
            this.haveBitSetVertices = true;
            return;
        }
        if ("toVertices" == string) {
            P3[] p3Array = (P3[])object;
            int n4 = this.nPoints = p3Array.length;
            while (--n4 >= 0) {
                this.otherAtoms[n4] = p3Array[n4];
            }
            return;
        }
        if ("faceCenterOffset" == string) {
            this.faceCenterOffset = ((Float)object).floatValue();
            return;
        }
        if ("distanceFactor" == string) {
            this.distanceFactor = ((Float)object).floatValue();
            return;
        }
        if ("planarParam" == string) {
            this.planarParam = ((Float)object).floatValue();
            return;
        }
        if ("bonds" == string) {
            this.bondedOnly = true;
            return;
        }
        if ("info" == string) {
            this.info = (Map)object;
            this.centers = BSUtil.newAndSetBit((int)this.info.get((Object)"atomIndex").intValue);
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("delete" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == string) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == string) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == string) {
            this.drawEdges = 2;
            return;
        }
        if (string.indexOf("color") == 0) {
            bS = "colorThis" == string && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            n2 = "colorPhase" == string ? (int)C.getColix((int)((Integer)((Object[])object)[0])) : 0;
            n = this.polyhedronCount;
            while (--n >= 0) {
                if (!bS.get(this.polyhedrons[n].centralAtom.i)) continue;
                this.polyhedrons[n].colixEdge = (short)n2;
            }
            if ("colorPhase" == string) {
                object = ((Object[])object)[1];
            }
            string = "color";
        }
        if (string.indexOf("translucency") == 0) {
            BS bS2 = bS = "translucentThis".equals(object) && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            if (object.equals("translucentThis")) {
                object = "translucent";
            }
        }
        if ("token" == string) {
            n2 = (Integer)object;
            if (n2 != 1073742182 || n2 != 1073742060) {
                this.setLighting(n2 == 1073741964, bS);
            }
            return;
        }
        if ("radius" == string) {
            this.radius = ((Float)object).floatValue();
            return;
        }
        if (string == "symmetry") {
            n2 = this.polyhedronCount;
            while (--n2 >= 0) {
                this.polyhedrons[n2].getSymmetry(this.vwr, true);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            n2 = ((int[])((Object[])object)[2])[0];
            n = this.polyhedronCount;
            while (--n >= 0) {
                this.polyhedrons[n].info = null;
                if (this.polyhedrons[n].modelIndex == n2) {
                    --this.polyhedronCount;
                    this.polyhedrons = (Polyhedron[])AU.deleteElements((Object)this.polyhedrons, (int)n, (int)1);
                    continue;
                }
                if (this.polyhedrons[n].modelIndex <= n2) continue;
                --this.polyhedrons[n].modelIndex;
            }
        }
        this.setPropAS(string, object, bS);
    }

    public boolean getPropertyData(String string, Object[] objectArray) {
        if (string == "points") {
            int n = (Integer)objectArray[0];
            int n2 = this.polyhedronCount;
            while (--n2 >= 0) {
                if (this.polyhedrons[n2].centralAtom.i != n) continue;
                if (this.polyhedrons[n2].collapsed) break;
                objectArray[1] = this.polyhedrons[n2].vertices;
                return true;
            }
            return false;
        }
        if (string == "move") {
            BS bS = (BS)objectArray[0];
            M4 m4 = (M4)objectArray[1];
            int n = this.polyhedronCount;
            while (--n >= 0) {
                Polyhedron polyhedron = this.polyhedrons[n];
                if (!bS.get(polyhedron.centralAtom.i)) continue;
                polyhedron.move(m4);
            }
            return true;
        }
        if (string == "centers") {
            int n;
            BS bS = new BS();
            String string2 = (String)objectArray[1];
            SmilesMatcherInterface smilesMatcherInterface = string2 == null ? null : this.vwr.getSmilesMatcher();
            Integer n3 = (Integer)objectArray[0];
            if (smilesMatcherInterface != null) {
                string2 = smilesMatcherInterface.cleanSmiles(string2);
            }
            int n4 = string2 != null ? PT.countChar((String)string2, (char)'*') : (n = n3 == null ? Integer.MIN_VALUE : n3);
            if (string2 != null && n == 0) {
                n = Integer.MIN_VALUE;
            }
            int n5 = this.polyhedronCount;
            while (--n5 >= 0) {
                if (n > 0 && this.polyhedrons[n5].nVertices != n || n > Integer.MIN_VALUE && n < 0 && this.polyhedrons[n5].faces.length != -n) continue;
                if (string2 == null) {
                    bS.set(this.polyhedrons[n5].centralAtom.i);
                    continue;
                }
                if (smilesMatcherInterface == null) continue;
                this.polyhedrons[n5].getSymmetry(this.vwr, false);
                String string3 = this.polyhedrons[n5].smiles;
                try {
                    if (smilesMatcherInterface.areEqual(string2, string3) <= 0) continue;
                    bS.set(this.polyhedrons[n5].centralAtom.i);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            objectArray[2] = bS;
            return true;
        }
        if (string == "info") {
            int n = (Integer)objectArray[0];
            int n6 = this.polyhedronCount;
            while (--n6 >= 0) {
                if (this.polyhedrons[n6].centralAtom.i != n) continue;
                objectArray[1] = this.polyhedrons[n6].getInfo(this.vwr, true);
                return true;
            }
            return false;
        }
        return false;
    }

    public Lst<Map<String, Object>> getShapeDetail() {
        Lst lst = new Lst();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            lst.addLast(this.polyhedrons[i].getInfo(this.vwr, true));
        }
        return lst;
    }

    private void setLighting(boolean bl, BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            if (!bS.get(this.polyhedrons[n].centralAtom.i)) continue;
            short[] sArray = this.polyhedrons[n].getNormixes();
            this.polyhedrons[n].isFullyLit = bl;
            int n2 = sArray.length;
            while (--n2 >= 0) {
                if (sArray[n2] < 0 == bl) continue;
                sArray[n2] = ~sArray[n2];
            }
        }
    }

    private BS andBitSet(BS bS) {
        BS bS2 = new BS();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            bS2.set(this.polyhedrons[n].centralAtom.i);
        }
        bS2.and(bS);
        return bS2;
    }

    private void deletePolyhedra() {
        int n;
        int n2 = 0;
        byte by = PAL.pidOf(null);
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            int n3 = polyhedron.centralAtom.i;
            if (this.centers.get(n3)) {
                this.setColixAndPalette((short)0, by, n3);
                continue;
            }
            this.polyhedrons[n2++] = polyhedron;
        }
        for (n = n2; n < this.polyhedronCount; ++n) {
            this.polyhedrons[n] = null;
        }
        this.polyhedronCount = n2;
    }

    private void setVisible(boolean bl) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron == null || !this.centers.get(polyhedron.centralAtom.i)) continue;
            polyhedron.visible = bl;
        }
    }

    private void buildPolyhedra() {
        boolean bl;
        boolean bl2 = bl = this.radius == 0.0f || this.bondedOnly;
        int n = this.info != null ? 6 : (this.nPoints > 0 ? 2 : (this.haveBitSetVertices ? 4 : (this.useUnitCell ? 5 : (bl ? 1 : 3))));
        AtomIndexIterator atomIndexIterator = n == 3 ? this.ms.getSelectedAtomIterator(null, false, false, false, false) : null;
        int n2 = this.centers.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = this.atoms[n2];
            Polyhedron polyhedron = null;
            switch (n) {
                case 4: {
                    polyhedron = this.constructBitSetPolyhedron(atom);
                    break;
                }
                case 5: {
                    polyhedron = this.constructUnitCellPolygon(atom, bl);
                    break;
                }
                case 1: {
                    polyhedron = this.constructBondsPolyhedron(atom, 0);
                    break;
                }
                case 2: {
                    polyhedron = this.constructPointPolyhedron(atom);
                    break;
                }
                case 3: {
                    this.vwr.setIteratorForAtom(atomIndexIterator, n2, this.radius);
                    polyhedron = this.constructRadiusPolyhedron(atom, atomIndexIterator);
                    break;
                }
                case 6: {
                    polyhedron = new Polyhedron().setInfo(this.info, this.vwr.ms.at);
                }
            }
            if (polyhedron != null) {
                if (this.polyhedronCount == this.polyhedrons.length) {
                    this.polyhedrons = (Polyhedron[])AU.doubleLength((Object)this.polyhedrons);
                }
                this.polyhedrons[this.polyhedronCount++] = polyhedron;
            }
            if (this.haveBitSetVertices) break;
            n2 = this.centers.nextSetBit(n2 + 1);
        }
        if (atomIndexIterator != null) {
            atomIndexIterator.release();
        }
    }

    private Polyhedron constructPointPolyhedron(Atom atom) {
        return this.validatePolyhedron(atom, this.nPoints, this.otherAtoms);
    }

    private Polyhedron constructUnitCellPolygon(Atom atom, boolean bl) {
        SymmetryInterface symmetryInterface = this.vwr.ms.getUnitCellForAtom(atom.i);
        if (symmetryInterface == null) {
            return null;
        }
        BS bS = BSUtil.copy((BS)this.vwr.getModelUndeletedAtomsBitSet((int)atom.mi));
        if (this.bsVertices != null) {
            bS.and(this.bsVertices);
        }
        if (bS.isEmpty()) {
            return null;
        }
        AtomIndexIterator atomIndexIterator = symmetryInterface.getIterator(this.vwr, atom, this.atoms, bS, bl ? 5.0f : this.radius);
        if (!bl) {
            return this.constructRadiusPolyhedron(atom, atomIndexIterator);
        }
        float f = atom.getBondingRadius();
        if (f == 0.0f) {
            return null;
        }
        float f2 = this.vwr.getFloat(0x22000004);
        float f3 = this.vwr.getFloat(570425364);
        float f4 = f3 * f3;
        int n = 0;
        while (atomIndexIterator.hasNext()) {
            P3 p3;
            float f5;
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            float f6 = atom2.getBondingRadius();
            if (!this.vwr.ms.isBondable(f, f6, f5 = atom.distanceSquared((T3)(p3 = atomIndexIterator.getPosition())), f4, f2)) continue;
            this.otherAtoms[n++] = p3;
            if (n < 250) continue;
            break;
        }
        return this.constructBondsPolyhedron(atom, n);
    }

    private Polyhedron constructBondsPolyhedron(Atom atom, int n) {
        if (n == 0) {
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return null;
            }
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                Bond bond = bondArray[n2];
                if (!bond.isCovalent()) continue;
                Atom atom2 = bond.getOtherAtom(atom);
                if (this.bsVertices != null && !this.bsVertices.get(n2) || this.radius > 0.0f && atom2.distance((T3)atom) > this.radius) continue;
                this.otherAtoms[n++] = atom2;
                if (n < 250) continue;
                break;
            }
        }
        return n < 3 || n >= 250 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n, this.otherAtoms);
    }

    private Polyhedron constructBitSetPolyhedron(Atom atom) {
        int n = 0;
        int n2 = this.bsVertices.nextSetBit(0);
        while (n2 >= 0) {
            this.otherAtoms[n++] = this.atoms[n2];
            n2 = this.bsVertices.nextSetBit(n2 + 1);
        }
        return this.validatePolyhedron(atom, n, this.otherAtoms);
    }

    private Polyhedron constructRadiusPolyhedron(Atom atom, AtomIndexIterator atomIndexIterator) {
        int n = 0;
        while (atomIndexIterator.hasNext()) {
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            P3 p3 = atomIndexIterator.getPosition();
            if (p3 == null) {
                p3 = atom2;
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || atom.distance((T3)p3) > this.radius) continue;
            }
            if (atom2.altloc != atom.altloc && atom2.altloc != '\u0000' && atom.altloc != '\u0000') continue;
            if (n == 250) break;
            this.otherAtoms[n++] = p3;
        }
        return n < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n, this.otherAtoms);
    }

    private Polyhedron validatePolyhedron(Atom atom, int n, P3[] p3Array) {
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6 = 0;
        int n7 = n;
        int n8 = n7 + 1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = Float.isNaN(this.planarParam) ? 0.98f : this.planarParam;
        P3[] p3Array2 = new P3[750];
        p3Array2[n7] = p3Array[n7] = atom;
        for (n5 = 0; n5 < n7; ++n5) {
            p3Array2[n5] = p3Array[n5];
            f2 += p3Array2[n7].distance((T3)p3Array2[n5]);
        }
        f2 /= (float)n7;
        n5 = n7 - 1;
        int n9 = n7 - 2;
        boolean bl2 = n5 > 6;
        float f4 = !Float.isNaN(this.distanceFactor) ? this.distanceFactor : 1.85f;
        BS bS = BS.newN((int)n7);
        boolean bl3 = bl = f2 == 0.0f;
        block1: while (!bl && f4 < 10.0f) {
            int n10;
            f = f2 * f4;
            bS.setBits(0, n7);
            for (n10 = 0; n10 < n9; ++n10) {
                for (int i = n10 + 1; i < n5; ++i) {
                    if (p3Array2[n10].distance((T3)p3Array2[i]) > f) continue;
                    for (n4 = i + 1; n4 < n7; ++n4) {
                        if (p3Array2[n10].distance((T3)p3Array2[n4]) > f || p3Array2[i].distance((T3)p3Array2[n4]) > f) continue;
                        bS.clear(n10);
                        bS.clear(i);
                        bS.clear(n4);
                    }
                }
            }
            bl = true;
            for (n10 = 0; n10 < n7; ++n10) {
                if (!bS.get(n10)) continue;
                bl = false;
                f4 *= 1.05f;
                if (!Logger.debugging) continue block1;
                Logger.debug((String)("Polyhedra distanceFactor for " + n7 + " atoms increased to " + f4 + " in order to include " + p3Array[n10]));
                continue block1;
            }
        }
        String string = "";
        String string2 = "";
        for (n4 = 0; n4 < n9; ++n4) {
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                for (int i = n3 + 1; i < n7; ++i) {
                    if (!this.isPlanar(p3Array2[n4], p3Array2[n3], p3Array2[i], p3Array2[n7])) continue;
                    string = string + this.faceId(n4, n3, i);
                }
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = n4 + 1; n3 < n7; ++n3) {
                if (!this.isAligned(p3Array2[n4], p3Array2[n3], p3Array2[n7])) continue;
                string2 = string2 + this.faceId(n4, n3, -1);
            }
        }
        P3 p3 = new P3();
        int[][] nArray = this.planesT;
        P4 p4 = new P4();
        V3 v3 = new V3();
        boolean bl4 = this.isCollapsed;
        float f5 = this.faceCenterOffset;
        int n11 = 247;
        int n12 = 250;
        P3 p32 = randomPoint;
        BS bS2 = Normix.newVertexBitSet();
        V3[] v3Array = this.normalsT;
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        BS bS3 = new BS();
        boolean bl5 = bl2;
        for (n2 = 0; n2 < n9; ++n2) {
            for (int i = n2 + 1; i < n5; ++i) {
                if (p3Array2[n2].distance((T3)p3Array2[i]) > f) continue;
                for (int j = i + 1; j < n7; ++j) {
                    if (p3Array2[n2].distance((T3)p3Array2[j]) > f || p3Array2[i].distance((T3)p3Array2[j]) > f) continue;
                    if (n6 >= n11) {
                        Logger.error((String)("Polyhedron error: maximum face(" + n11 + ") -- reduce RADIUS or DISTANCEFACTOR"));
                        return null;
                    }
                    if (n8 >= n12) {
                        Logger.error((String)("Polyhedron error: maximum vertex count(" + n12 + ") -- reduce RADIUS"));
                        return null;
                    }
                    boolean bl6 = string.indexOf(this.faceId(n2, i, j)) >= 0;
                    V3 v32 = new V3();
                    boolean bl7 = bl6 ? this.getNormalFromCenter(p32, p3Array2[n2], p3Array2[i], p3Array2[j], false, v32) : this.getNormalFromCenter(p3Array2[n7], p3Array2[n2], p3Array2[i], p3Array2[j], true, v32);
                    v32.scale(bl4 && !bl6 ? f5 : 0.001f);
                    int n13 = n8;
                    p3.setT((T3)p3Array2[n7]);
                    if (bl4 && !bl6) {
                        p3Array2[n8] = P3.newP((T3)p3Array2[n7]);
                        p3Array2[n8].add((T3)v32);
                        p3Array[n8] = p3Array2[n8];
                    } else if (bl6) {
                        p3.sub((T3)v32);
                        n13 = n7;
                        if (this.useUnitCell) continue;
                    }
                    String string3 = this.faceId(n2, i, -1);
                    if (bl4 || bl6 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        nArray[n6] = new int[]{bl7 ? n2 : i, bl7 ? i : n2, n13, bl6 ? -15 : -6};
                        this.getNormalFromCenter(p3Array2[j], p3Array2[n2], p3Array2[i], p3, false, v32);
                        if (bl6) {
                            bS3.set(n6);
                        }
                        v3Array[n6++] = v32;
                    }
                    string3 = this.faceId(n2, j, -1);
                    if (bl4 || bl6 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        nArray[n6] = new int[]{bl7 ? n2 : j, n13, bl7 ? j : n2, bl6 ? -15 : -5};
                        this.getNormalFromCenter(p3Array2[i], p3Array2[n2], p3, p3Array2[j], false, v32);
                        if (bl6) {
                            bS3.set(n6);
                        }
                        v3Array[n6++] = v32;
                    }
                    string3 = this.faceId(i, j, -1);
                    if (bl4 || bl6 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        nArray[n6] = new int[]{n13, bl7 ? i : j, bl7 ? j : i, bl6 ? -15 : -4};
                        this.getNormalFromCenter(p3Array2[n2], p3, p3Array2[i], p3Array2[j], false, v32);
                        if (bl6) {
                            bS3.set(n6);
                        }
                        v3Array[n6++] = v32;
                    }
                    if (bl6) continue;
                    if (bl4) {
                        ++n8;
                        continue;
                    }
                    nArray[n6] = new int[]{bl7 ? n2 : i, bl7 ? i : n2, j, -7};
                    v3Array[n6] = v32;
                    if (bl5 && !this.checkPlane(p3Array2, n7, nArray, v3Array, n6, p4, v3, hashtable, f3, bS2)) continue;
                    ++n6;
                }
            }
        }
        --n8;
        if (Logger.debugging) {
            Logger.info((String)("Polyhedron planeCount=" + n6 + " nPoints=" + n8));
            for (n2 = 0; n2 < n6; ++n2) {
                Logger.info((String)("Polyhedron " + this.getKey(nArray[n2], n2)));
            }
        }
        return new Polyhedron().set(atom, n7, n8, n6, p3Array, v3Array, bS3, nArray, bl4);
    }

    private boolean getNormalFromCenter(P3 p3, P3 p32, P3 p33, P3 p34, boolean bl, V3 v3) {
        boolean bl2;
        V3 v32 = new V3();
        float f = Measure.getNormalThroughPoints((T3)p32, (T3)p33, (T3)p34, (V3)v3, (V3)v32);
        boolean bl3 = bl2 = Measure.distanceToPlaneV((V3)v3, (float)f, (P3)p3) > 0.0f;
        if (bl2 == bl) {
            v3.scale(-1.0f);
        }
        return !bl2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkPlane(P3[] p3Array, int n, int[][] nArray, V3[] v3Array, int n2, P4 p4, V3 v3, Map<Integer, String> map, float f, BS bS) {
        int[] nArray2 = nArray[n2];
        p4 = Measure.getPlaneThroughPoints((T3)p3Array[nArray2[0]], (T3)p3Array[nArray2[1]], (T3)p3Array[nArray2[2]], (V3)v3, (V3)this.vAB, (P4)p4);
        for (int i = 0; i < n; ++i) {
            this.vAB.sub2((T3)p3Array[nArray2[0]], (T3)p3Array[i]);
            if (!((double)this.vAB.dot((T3)v3) < -0.1)) continue;
            return false;
        }
        V3 v32 = v3Array[n2];
        Integer n3 = Normix.getNormixV((V3)v32, (BS)bS);
        String string = map.get(n3);
        if (string == null) {
            V3[] v3Array2 = Normix.getVertexVectors();
            for (Map.Entry entry : map.entrySet()) {
                if (!(v3Array2[(Integer)entry.getKey()].dot((T3)v32) > f)) continue;
                string = (String)entry.getValue();
                break;
            }
        }
        String string2 = this.getKey(nArray2, n2);
        if (string == null) {
            map.put(n3, string2);
        } else {
            void var17_21;
            boolean i = false;
            while (var17_21 < 3) {
                if (string.indexOf("_" + nArray2[var17_21] + "_" + nArray2[(var17_21 + true) % 3] + "_") >= 0) {
                    return false;
                }
                int n4 = string.indexOf("_" + nArray2[(var17_21 + true) % 3] + "_" + nArray2[var17_21] + "_");
                if (n4 >= 0 && string.indexOf(";") == string.lastIndexOf(";")) {
                    n4 = PT.parseInt((String)string.substring(string.indexOf(",") + 1));
                    int[] nArray3 = nArray[n4];
                    int n5 = nArray3.length - 1;
                    int[] nArray4 = new int[nArray3.length];
                    boolean bl = false;
                    int n6 = 0;
                    block3: for (int j = 0; j < n5; ++j) {
                        nArray4[n6++] = nArray3[j];
                        if (bl) continue;
                        for (int k = 0; k < 3; ++k) {
                            if (nArray3[j] != nArray2[(k + 1) % 3] || nArray3[(j + 1) % n5] != nArray2[k]) continue;
                            nArray4[n6++] = nArray2[(k + 2) % 3];
                            bl = true;
                            continue block3;
                        }
                    }
                    nArray[n4] = nArray4;
                    string = PT.rep((String)string, (String)this.getKey(nArray3, n4), (String)this.getKey(nArray4, n4));
                    map.put(n3, string);
                    return false;
                }
                ++var17_21;
            }
            map.put(n3, string + (String)string2);
        }
        return true;
    }

    private String getKey(int[] nArray, int n) {
        SB sB = new SB();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] < 0) continue;
            sB.append("_").appendI(nArray[i]);
        }
        sB.append("_").appendI(nArray[0]);
        sB.append("_,").appendI(n).append(";");
        return sB.toString();
    }

    private String faceId(int n, int n2, int n3) {
        return "[" + n + "," + n2 + "," + n3 + "]";
    }

    private boolean isAligned(P3 p3, P3 p32, P3 p33) {
        this.align1.sub2((T3)p3, (T3)p33);
        this.align2.sub2((T3)p32, (T3)p33);
        float f = this.align1.angle(this.align2);
        return f < 0.01f || f > 3.13f;
    }

    private boolean isPlanar(P3 p3, P3 p32, P3 p33, P3 p34) {
        V3 v3 = new V3();
        float f = Measure.getNormalThroughPoints((T3)p3, (T3)p32, (T3)p33, (V3)v3, (V3)this.vAB);
        float f2 = Measure.distanceToPlaneV((V3)v3, (float)f, (P3)p34);
        return Math.abs(f2) < minDistanceForPlanarity;
    }

    public void setModelVisibilityFlags(BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (this.ms.at[polyhedron.centralAtom.i].isDeleted()) {
                polyhedron.isValid = false;
            }
            int n2 = polyhedron.visibilityFlags = polyhedron.visible && bS.get(polyhedron.modelIndex) && !this.ms.isAtomHidden(polyhedron.centralAtom.i) && !this.ms.at[polyhedron.centralAtom.i].isDeleted() ? this.vf : 0;
            if (polyhedron.visibilityFlags == 0) continue;
            this.setShapeVisibility(this.atoms[polyhedron.centralAtom.i], true);
        }
    }

    public String getShapeState() {
        int n;
        if (this.polyhedronCount == 0) {
            return "";
        }
        SB sB = new SB();
        for (n = 0; n < this.polyhedronCount; ++n) {
            if (!this.polyhedrons[n].isValid) continue;
            sB.append(this.polyhedrons[n].getState(this.vwr));
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd((SB)sB, (String)"polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd((SB)sB, (String)"polyhedra edges");
        }
        sB.append(this.vwr.getAtomShapeState((AtomShape)this));
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (!polyhedron.isValid || polyhedron.colixEdge == 0 || !this.bsColixSet.get(polyhedron.centralAtom.i)) continue;
            Polyhedra.appendCmd((SB)sB, (String)("select ({" + polyhedron.centralAtom.i + "}); color polyhedra " + (C.isColixTranslucent((short)this.colixes[polyhedron.centralAtom.i]) ? "translucent " : "") + C.getHexCode((short)this.colixes[polyhedron.centralAtom.i]) + " " + C.getHexCode((short)polyhedron.colixEdge)));
        }
        return sB.toString();
    }
}

