/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.DSSPInterface;
import org.jmol.c.STR;
import org.jmol.dssx.Bridge;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DSSP
implements DSSPInterface {
    private BioPolymer[] bioPolymers;
    private Lst<Bond> vHBonds;
    private BS[] done;
    private boolean doReport;
    private boolean dsspIgnoreHydrogens;
    private boolean setStructure;
    private char[][] labels;
    private BS bsBad;
    private int bioPolymerCount;
    private Map<String, Bridge> htBridges;
    private Map<int[][], Boolean> htLadders;
    private Lst<Bridge> bridgesA;
    private Lst<Bridge> bridgesP;
    private int[][] sheetOffsets = new int[][]{{0, -1, 1, 0, 1, 0, 0, -1}, {0, 0, 0, 0, 1, -1, 1, -1}};

    public String calculateDssp(Object[] objectArray, int n, Object object, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        String[] stringArray;
        this.bioPolymers = (BioPolymer[])objectArray;
        this.bioPolymerCount = n;
        this.vHBonds = (Lst)object;
        this.doReport = bl;
        this.dsspIgnoreHydrogens = bl2;
        this.setStructure = bl3;
        BS bS = new BS();
        for (int i = 0; i < n; ++i) {
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            bS.set(i);
        }
        if (bS.isEmpty()) {
            return "";
        }
        Model model = this.bioPolymers[0].model;
        SB sB = new SB();
        sB.append("Jmol ").append(Viewer.getJmolVersion()).append(" DSSP analysis for model ").append(model.ms.getModelNumberDotted(model.modelIndex)).append(" - ").append(model.ms.getModelTitle(model.modelIndex)).append("\n");
        if (model.modelIndex == 0) {
            sB.append("\nW. Kabsch and C. Sander, Biopolymers, vol 22, 1983, pp 2577-2637\n").append("\nWe thank Wolfgang Kabsch and Chris Sander for writing the DSSP software,\n").append("and we thank the CMBI for maintaining it to the extent that it was easy to\n").append("re-engineer for our purposes. At this point in time, we make no guarantee\n").append("that this code gives precisely the same analysis as the code available via license\n").append("from CMBI at http://swift.cmbi.ru.nl/gv/dssp\n");
        }
        if (bl3 && model.modelIndex == 0) {
            sB.append("\nAll bioshapes have been deleted and must be regenerated.\n");
        }
        if (model.altLocCount > 0) {
            sB.append("\nNote: This model contains alternative locations. Use  'CONFIGURATION 1' to be consistent with CMBI DSSP.\n");
        }
        this.labels = new char[n][];
        this.done = new BS[n];
        this.bsBad = new BS();
        boolean bl4 = false;
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            stringArray = (String[])this.bioPolymers[n4];
            if (!bl4 && ((AminoMonomer)stringArray.monomers[0]).getExplicitNH() != null) {
                if (bl2) {
                    sB.append(GT.o((String)GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be ignored. Their positions will be approximated, as in standard DSSP analysis.\nUse {0} to not use this approximation.\n\n"), (Object)"SET dsspCalculateHydrogenAlways FALSE"));
                } else {
                    sB.append(GT.o((String)GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be used. Results may differ significantly from standard DSSP analysis.\nUse {0} to ignore these hydrogen positions.\n\n"), (Object)"SET dsspCalculateHydrogenAlways TRUE"));
                }
                bl4 = true;
            }
            stringArray.recalculateLeadMidpointsAndWingVectors();
            n3 = stringArray.monomerCount;
            this.labels[n4] = new char[n3];
            this.done[n4] = new BS();
            for (n2 = 0; n2 < n3; ++n2) {
                if (((AminoMonomer)stringArray.monomers[n2]).getCarbonylOxygenAtom() != null) continue;
                this.bsBad.set(stringArray.monomers[n2].leadAtomIndex);
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        int[][][][] nArray = this.getDualHydrogenBondArray();
        this.bridgesA = new Lst();
        this.bridgesP = new Lst();
        this.htBridges = new Hashtable<String, Bridge>();
        this.htLadders = new Hashtable<int[][], Boolean>();
        this.getBridges(nArray);
        this.getSheetStructures();
        stringArray = new String[n];
        n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            if (nArray[n3] != null) {
                stringArray[n3] = this.findHelixes(n3, nArray[n3]);
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (bl) {
            SB sB2 = new SB();
            sB.append("\n------------------------------\n");
            n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (this.labels[n2] != null) {
                    AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n2];
                    sB2.append(this.dumpSummary(aminoPolymer, this.labels[n2]));
                    sB.append(stringArray[n2]).append(this.dumpTags(aminoPolymer, "$.1: " + String.valueOf(this.labels[n2]), this.bsBad, 2));
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
            if (this.bsBad.nextSetBit(0) >= 0) {
                sB.append("\nNOTE: '!' indicates a residue that is missing a backbone carbonyl oxygen atom.\n");
            }
            sB.append("\n").append("SUMMARY:" + sB2);
        }
        return sB.toString();
    }

    private int[][][][] getDualHydrogenBondArray() {
        int n;
        int n2;
        int[][][][] nArray = AU.newInt4((int)this.bioPolymerCount);
        for (n2 = 0; n2 < this.bioPolymerCount; ++n2) {
            if (!(this.bioPolymers[n2] instanceof AminoPolymer)) continue;
            n = this.bioPolymers[n2].monomerCount;
            nArray[n2] = new int[n][2][3];
            for (int i = 0; i < n; ++i) {
                nArray[n2][i][1][1] = Integer.MIN_VALUE;
                nArray[n2][i][0][1] = Integer.MIN_VALUE;
                nArray[n2][i][1][2] = 0;
                nArray[n2][i][0][2] = 0;
            }
        }
        for (n2 = 0; n2 < this.bioPolymerCount; ++n2) {
            if (nArray[n2] == null) continue;
            for (n = 0; n < this.bioPolymerCount; ++n) {
                if (nArray[n] == null) continue;
                this.bioPolymers[n2].calcRasmolHydrogenBonds(this.bioPolymers[n], null, null, null, 2, nArray[n2], false, this.dsspIgnoreHydrogens);
            }
        }
        return nArray;
    }

    private void getBridges(int[][][][] nArray) {
        Atom[] atomArray = this.bioPolymers[0].model.ms.at;
        Bridge bridge = null;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (int i = 0; i < nArray.length; ++i) {
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[i];
            int n = nArray[i].length - 1;
            for (int j = 1; j < n; ++j) {
                int n2 = aminoPolymer.monomers[j].leadAtomIndex;
                if (this.bsBad.get(n2)) continue;
                for (int k = i; k < nArray.length; ++k) {
                    int n3;
                    if (!(this.bioPolymers[k] instanceof AminoPolymer)) continue;
                    int n4 = n3 = i == k ? j + 3 : 1;
                    while (n3 < nArray[k].length - 1) {
                        block8: {
                            int n5;
                            block9: {
                                AminoPolymer aminoPolymer2 = (AminoPolymer)this.bioPolymers[k];
                                n5 = aminoPolymer2.monomers[n3].leadAtomIndex;
                                if (this.bsBad.get(n5)) break block8;
                                bridge = this.getBridge(nArray, i, j, k, n3, this.bridgesP, atomArray[n2], atomArray[n5], aminoPolymer, aminoPolymer2, hashtable, false);
                                if (bridge != null) break block9;
                                bridge = this.getBridge(nArray, i, j, k, n3, this.bridgesA, atomArray[n2], atomArray[n5], aminoPolymer, aminoPolymer2, hashtable, true);
                                if (bridge == null) break block8;
                                bridge.isAntiparallel = true;
                            }
                            if (Logger.debugging) {
                                Logger.debug((String)("Bridge found " + bridge));
                            }
                            this.done[i].set(j);
                            this.done[k].set(n3);
                            this.htBridges.put(n2 + "-" + n5, bridge);
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private Bridge getBridge(int[][][][] nArray, int n, int n2, int n3, int n4, Lst<Bridge> lst, Atom atom, Atom atom2, AminoPolymer aminoPolymer, AminoPolymer aminoPolymer2, Map<String, Boolean> map, boolean bl) {
        block5: {
            int[] nArray2;
            int n5;
            int[] nArray3;
            int[] nArray4;
            block4: {
                nArray4 = null;
                nArray3 = null;
                n5 = 0;
                nArray2 = bl ? this.sheetOffsets[1] : this.sheetOffsets[0];
                nArray4 = this.isHbonded(n2 + nArray2[0], n4 + nArray2[1], n, n3, nArray);
                if (nArray4 != null && (nArray3 = this.isHbonded(n4 + nArray2[2], n2 + nArray2[3], n3, n, nArray)) != null) break block4;
                n5 = 4;
                nArray4 = this.isHbonded(n2 + nArray2[4], n4 + nArray2[5], n, n3, nArray);
                if (nArray4 == null || (nArray3 = this.isHbonded(n4 + nArray2[6], n2 + nArray2[7], n3, n, nArray)) == null) break block5;
            }
            Bridge bridge = new Bridge(atom, atom2, this.htLadders);
            lst.addLast((Object)bridge);
            if (this.vHBonds != null) {
                int n6 = bl ? 14336 : 6144;
                this.addHbond(aminoPolymer.monomers[n2 + nArray2[n5]], aminoPolymer2.monomers[n4 + nArray2[++n5]], nArray4[2], n6, map);
                this.addHbond(aminoPolymer2.monomers[n4 + nArray2[++n5]], aminoPolymer.monomers[n2 + nArray2[++n5]], nArray3[2], n6, map);
            }
            return bridge;
        }
        return null;
    }

    private void addHbond(Monomer monomer, Monomer monomer2, int n, int n2, Map<String, Boolean> map) {
        Atom atom = ((AminoMonomer)monomer).getNitrogenAtom();
        Atom atom2 = ((AminoMonomer)monomer2).getCarbonylOxygenAtom();
        if (map != null) {
            String string = atom.i + " " + atom2.i;
            if (map.containsKey(string)) {
                return;
            }
            map.put(string, Boolean.TRUE);
        }
        this.vHBonds.addLast((Object)new HBond(atom, atom2, n2, 1, 0, (float)n / 1000.0f));
    }

    private void getSheetStructures() {
        Object object2;
        if (this.bridgesA.size() == 0 && this.bridgesP.size() == 0) {
            return;
        }
        this.createLadders(this.bridgesA, true);
        this.createLadders(this.bridgesP, false);
        BS bS = new BS();
        BS bS2 = new BS();
        for (Object object2 : this.htLadders.keySet()) {
            if (object2[0][0] == object2[0][1] && object2[1][0] == object2[1][1]) {
                bS2.set(object2[0][0]);
                bS2.set(object2[1][0]);
                continue;
            }
            bS.setBits(object2[0][0], object2[0][1] + 1);
            bS.setBits(object2[1][0], object2[1][1] + 1);
        }
        BS bS3 = new BS();
        object2 = new BS();
        int n = this.bioPolymers.length;
        while (--n >= 0) {
            if (!(this.bioPolymers[n] instanceof AminoPolymer)) continue;
            bS3.clearAll();
            object2.clearAll();
            AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n];
            int n2 = 0;
            while (n2 < aminoPolymer.monomerCount) {
                int n3 = aminoPolymer.monomers[n2].leadAtomIndex;
                if (bS.get(n3)) {
                    int n4;
                    for (n4 = n2 + 1; n4 < aminoPolymer.monomerCount && bS.get(aminoPolymer.monomers[n4].leadAtomIndex); ++n4) {
                    }
                    bS3.setBits(n2, n4);
                    n2 = n4;
                    continue;
                }
                if (bS2.get(n3)) {
                    object2.set(n2);
                }
                ++n2;
            }
            if (this.doReport) {
                this.setTag(this.labels[n], (BS)object2, 'B');
                this.setTag(this.labels[n], bS3, 'E');
            }
            if (this.setStructure) {
                this.setStructure(aminoPolymer, bS3, STR.SHEET);
            }
            this.done[n].or(bS3);
            this.done[n].or((BS)object2);
        }
    }

    private void createLadders(Lst<Bridge> lst, boolean bl) {
        int n;
        int n2 = bl ? -1 : 1;
        int n3 = lst.size();
        for (n = 0; n < n3; ++n) {
            this.checkBridge((Bridge)lst.get(n), bl, 1, n2);
        }
        for (n = 0; n < n3; ++n) {
            this.checkBulge((Bridge)lst.get(n), bl, 1);
        }
    }

    private boolean checkBridge(Bridge bridge, boolean bl, int n, int n2) {
        Bridge bridge2 = this.htBridges.get(bridge.a.getOffsetResidueAtom("0", n) + "-" + bridge.b.getOffsetResidueAtom("0", n2));
        return bridge2 != null && bridge.addBridge(bridge2, this.htLadders);
    }

    private void checkBulge(Bridge bridge, boolean bl, int n) {
        int n2 = bl ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            int n3;
            int n4 = n3 = i == 0 ? 1 : 0;
            while (n3 < 6) {
                this.checkBridge(bridge, bl, i * n, n3 * n2);
                if (n3 > i) {
                    this.checkBridge(bridge, bl, n3 * n, i * n2);
                }
                ++n3;
            }
        }
    }

    private String dumpSummary(AminoPolymer aminoPolymer, char[] cArray) {
        Atom atom = aminoPolymer.monomers[0].getLeadAtom();
        int n = atom.getChainID();
        String string = n == 0 ? "" : atom.getChainIDStr() + ":";
        SB sB = new SB();
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n2 = -1;
        int n3 = -1;
        int n4 = aminoPolymer.monomerCount;
        Monomer[] monomerArray = aminoPolymer.monomers;
        for (int i = 0; i <= n4; ++i) {
            if (i == n4 || cArray[i] != c) {
                if (c != '\u0000') {
                    sB.appendC('\n').appendC(c).append(" : ").append(string).appendI(n2).append(c2 == '\u0000' ? "" : String.valueOf(c2)).append("_").append(string).appendI(n3).append(c3 == '\u0000' ? "" : String.valueOf(c3));
                }
                if (i == n4) break;
                c = cArray[i];
                n2 = monomerArray[i].getResno();
                c2 = monomerArray[i].getInsertionCode();
            }
            n3 = monomerArray[i].getResno();
            c3 = monomerArray[i].getInsertionCode();
        }
        return sB.toString();
    }

    private String dumpTags(AminoPolymer aminoPolymer, String string, BS bS, int n) {
        String string2 = aminoPolymer.monomers[0].getLeadAtom().getChainID() + "." + (aminoPolymer.bioPolymerIndexInModel + 1);
        string = PT.rep((String)string, (String)"$", (String)string2);
        int n2 = aminoPolymer.monomers[0].getResno();
        String string3 = "\n" + string2;
        SB sB = new SB();
        SB sB2 = new SB().append(string3 + ".8: ");
        SB sB3 = new SB().append(string3 + ".7: ");
        SB sB4 = new SB().append(string3 + ".6: ");
        SB sB5 = new SB().append(string3 + ".0: ");
        int n3 = n2;
        int n4 = aminoPolymer.monomerCount;
        for (int i = 0; i < n4; ++i) {
            n3 = aminoPolymer.monomers[i].getResno();
            sB2.append(n3 % 100 == 0 ? "" + n3 / 100 % 100 : " ");
            sB3.append(n3 % 10 == 0 ? "" + n3 / 10 % 10 : " ");
            sB4.appendI(n3 % 10);
            sB5.appendC(bS.get(aminoPolymer.monomers[i].leadAtomIndex) ? (char)'!' : aminoPolymer.monomers[i].getGroup1());
        }
        if ((n & 1) == 1) {
            sB.appendSB(sB2).appendSB(sB3).appendSB(sB4);
        }
        sB.append("\n");
        sB.append(string);
        if ((n & 2) == 2) {
            sB.appendSB(sB5);
            sB.append("\n\n");
        }
        return sB.toString().replace('\u0000', '.');
    }

    private int[] isHbonded(int n, int n2, int n3, int n4, int[][][][] nArray) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int[][][] nArray2 = nArray[n3];
        int[][][] nArray3 = nArray[n4];
        if (n >= nArray2.length || n2 >= nArray3.length) {
            return null;
        }
        return nArray2[n][0][0] == n4 && nArray2[n][0][1] == n2 ? nArray2[n][0] : (nArray2[n][1][0] == n4 && nArray2[n][1][1] == n2 ? nArray2[n][1] : null);
    }

    private String findHelixes(int n, int[][][] nArray) {
        AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n];
        if (Logger.debugging) {
            for (int i = 0; i < aminoPolymer.monomerCount; ++i) {
                Logger.debug((String)(n + "." + aminoPolymer.monomers[i].getResno() + "\t" + Escape.e((Object)nArray[i])));
            }
        }
        BS bS = new BS();
        String string = this.findHelixes2(n, 4, nArray, STR.HELIXALPHA, 10240, bS);
        String string2 = this.findHelixes2(n, 3, nArray, STR.HELIX310, 8192, bS);
        String string3 = this.findHelixes2(n, 5, nArray, STR.HELIXPI, 12288, bS);
        if (this.setStructure) {
            this.setStructure(aminoPolymer, bS, STR.TURN);
        }
        if (this.doReport) {
            this.setTag(this.labels[n], bS, 'T');
            return this.dumpTags(aminoPolymer, "$.5: " + string3 + "\n" + "$.4: " + string + "\n" + "$.3: " + string2, this.bsBad, 1);
        }
        return "";
    }

    private String findHelixes2(int n, int n2, int[][][] nArray, STR sTR, int n3, BS bS) {
        char[] cArray;
        AminoPolymer aminoPolymer = (AminoPolymer)this.bioPolymers[n];
        BS bS2 = new BS();
        BS bS3 = new BS();
        BS bS4 = new BS();
        BS bS5 = new BS();
        BS bS6 = new BS();
        BS bS7 = this.done[n];
        String string = "";
        int n4 = aminoPolymer.monomerCount;
        for (int i = n2; i < n4; ++i) {
            int n5 = i - n2;
            int n6 = 0;
            if (nArray[i][0][0] != n || nArray[i][0][1] != n5) {
                n6 = 1;
                if (nArray[i][1][0] != n || nArray[i][1][1] != n5) continue;
            }
            int n7 = aminoPolymer.monomers[n5].leadAtomIndex;
            int n8 = this.bsBad.nextSetBit(n7);
            Monomer monomer = aminoPolymer.monomers[i];
            if (n8 >= n7 && n8 <= monomer.leadAtomIndex) continue;
            bS2.set(n5);
            bS3.setBits(n5 + 1, i);
            bS5.set(i);
            n8 = bS7.nextSetBit(n5);
            boolean bl = n8 < 0 || n8 >= i;
            boolean bl2 = false;
            if (n5 > 0 && bS2.get(n5 - 1) && (n2 == 4 || bl)) {
                bS6.setBits(n5, i);
                if (!bl) {
                    string = string + "  WARNING! Bridge to helix at " + (Object)((Object)aminoPolymer.monomers[n8]);
                }
                bl2 = true;
            } else if (bl || bS7.nextClearBit(n8) < i) {
                bl2 = true;
            }
            if (bS5.get(n5)) {
                bS4.set(n5);
            }
            if (!bl2 || this.vHBonds == null) continue;
            this.addHbond(monomer, aminoPolymer.monomers[n5], nArray[i][n6][2], n3, null);
        }
        if (this.doReport) {
            cArray = new char[n4];
            this.setTag(cArray, bS3, (char)(48 + n2));
            this.setTag(cArray, bS2, '>');
            this.setTag(cArray, bS5, '<');
            this.setTag(cArray, bS4, 'X');
        } else {
            cArray = null;
        }
        bS7.or(bS6);
        bS3.andNot(bS7);
        bS.or(bS3);
        bS.andNot(bS6);
        if (this.setStructure) {
            this.setStructure(aminoPolymer, bS6, sTR);
        }
        if (this.doReport) {
            this.setTag(this.labels[n], bS6, (char)(68 + n2));
            return String.valueOf(cArray) + string;
        }
        return "";
    }

    private void setTag(char[] cArray, BS bS, char c) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            cArray[n] = c;
            n = bS.nextSetBit(n + 1);
        }
    }

    private void setStructure(AminoPolymer aminoPolymer, BS bS, STR sTR) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            int n2 = bS.nextClearBit(n);
            if (n2 < 0) {
                n2 = aminoPolymer.monomerCount;
            }
            aminoPolymer.addStructureProtected(sTR, null, 0, 0, n, n2 - 1);
            n = n2;
            n = bS.nextSetBit(n + 1);
        }
    }
}

