/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapecgo;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.script.T;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.Normix;
import org.jmol.viewer.Viewer;

public class CGOMesh
extends DrawMesh {
    public Lst<Object> cmds;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int STOP = 0;
    public static final int SIMPLE_LINE = 1;
    public static final int BEGIN = 2;
    public static final int END = 3;
    public static final int VERTEX = 4;
    public static final int NORMAL = 5;
    public static final int COLOR = 6;
    public static final int SPHERE = 7;
    public static final int TRICOLOR_TRIANGLE = 8;
    public static final int CYLINDER = 9;
    public static final int LINEWIDTH = 10;
    public static final int WIDTHSCALE = 11;
    public static final int ENABLE = 12;
    public static final int DISABLE = 13;
    public static final int SAUSAGE = 14;
    public static final int CUSTOM_CYLINDER = 15;
    public static final int DOTWIDTH = 16;
    public static final int ALPHA_TRIANGLE = 17;
    public static final int ELLIPSOID = 18;
    public static final int FONT = 19;
    public static final int FONT_SCALE = 20;
    public static final int FONT_VERTEX = 21;
    public static final int FONT_AXES = 22;
    public static final int CHAR = 23;
    public static final int INDENT = 24;
    public static final int ALPHA = 25;
    public static final int QUADRIC = 26;
    public static final int CONE = 27;
    public static final int RESET_NORMAL = 28;
    public static final int PICK_COLOR = 29;
    private static final int[] sizes = new int[]{0, 8, 1, 0, 3, 3, 3, 4, 27, 13, 1, 1, 1, 1, 13, 15, 1, 35, 13, 3, 2, 3, 9, 1, 2, 1, 14, 16, 1, 2};
    private static final int[] sizes2D = new int[]{0, 6, 1, 0, 2, 3, 3, 4, 24, 13, 1, 1, 1, 1, 11, 15, 1, 35, 13, 3, 2, 3, 9, 1, 2, 1, 14, 16, 1, 2};
    public static final int JMOL_DIAMETER = -100;
    public static final int JMOL_SCREEN = -101;
    public static final int JMOL_UVMAP = -102;
    public static final int JMOL_PS = -103;
    public static final int PS_NEWPATH = -104;
    public static final int PS_CLOSEPATH = -105;
    public static final int PS_STROKE = -106;
    public static final int PS_SETLINEWIDTH = -107;
    public static final int PS_SCALE = -108;
    public static final int PS_MOVETO = -109;
    public static final int PS_LINETO = -110;
    public static final int PS_SHOWPAGE = -111;
    private static final String KEY_LIST = "BEGIN:2 END:3 STOP:0 POINT:0 POINTS:0 LINES:1 LINE_LOOP:2 LINE_STRIP:3 TRIANGLES:4 TRIANGLE_STRIP:5 TRIANGLE_FAN:6 LINE:1 VERTEX:4 NORMAL:5 COLOR:6 LINEWIDTH:10 SAUSAGE:14 DIAMETER:-100 SCREEN:-101 UVMAP:-102 PS:-103 NEWPATH:-104 CLOSEPATH:-105 STROKE:-106 SETLINEWIDTH:-107 SCALE:-108 MOVETO:-109 LINETO:-110 SHOWPAGE:-111";
    private static Map<String, Integer> keyMap;
    public Lst<Short> nList = new Lst();
    public Lst<Short> cList = new Lst();

    CGOMesh(Viewer viewer, String string, short s, int n) {
        super(viewer, string, s, n);
    }

    public static int getSize(int n, boolean bl) {
        switch (n) {
            case -103: {
                return 13;
            }
            case -102: {
                return 15;
            }
            case -110: 
            case -109: 
            case -108: {
                return 2;
            }
            case -107: 
            case -101: 
            case -100: {
                return 1;
            }
            case -111: 
            case -106: 
            case -105: 
            case -104: {
                return 0;
            }
        }
        return n >= 0 && n < sizes.length ? (bl ? sizes2D : sizes)[n] : -1;
    }

    public static Map<String, Integer> getKeyMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        String[] stringArray = PT.getTokens(KEY_LIST);
        int n = stringArray.length;
        while (--n >= 0) {
            int n2 = stringArray[n].indexOf(":");
            hashtable.put(stringArray[n].substring(0, n2), Integer.parseInt(stringArray[n].substring(n2 + 1)));
        }
        return hashtable;
    }

    static boolean getData(Object[] objectArray) {
        if (keyMap == null) {
            keyMap = CGOMesh.getKeyMap();
        }
        T[] tArray = (T[])objectArray[0];
        int[] nArray = (int[])objectArray[1];
        Lst lst = (Lst)objectArray[2];
        Viewer viewer = (Viewer)objectArray[3];
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = tArray[n].tok;
        int n4 = n = n3 == 0x10100040 ? n + 1 : n + 2;
        if (n >= n2) {
            return false;
        }
        String string = tArray[n].value.toString().toUpperCase();
        int n5 = ";PS;BEGIN;SCREEN;UVMAP;".indexOf(";" + string + ";");
        n = CGOMesh.addItems(n, tArray, n2, lst, viewer);
        if (n5 == 0) {
            if (n + 5 >= n2 || tArray[n + 1].tok != 0x8101008) {
                return false;
            }
            if (!CGOMesh.parseEPSData(tArray[n + 3].value.toString(), lst)) {
                return false;
            }
            n += 5;
        }
        nArray[0] = n;
        return true;
    }

    private static boolean parseEPSData(String string, Lst<Object> lst) {
        int n;
        int n2 = string.indexOf("%%BoundingBox:");
        if (n2 < 0) {
            return false;
        }
        Lst<Float> lst2 = new Lst<Float>();
        int[] nArray = new int[]{n2 + 14};
        for (n = 0; n < 4; ++n) {
            lst.addLast(Float.valueOf(PT.parseFloatNext(string, nArray)));
        }
        n2 = string.indexOf("%%EndProlog");
        if (n2 < 0) {
            return false;
        }
        nArray[0] = n2 + 11;
        n = string.length();
        while (true) {
            float f = PT.parseFloatChecked(string, n, nArray, false);
            if (nArray[0] >= n) break;
            if (Float.isNaN(f)) {
                String string2 = PT.parseTokenChecked(string, n, nArray);
                if (string2.startsWith("%%")) continue;
                if (!CGOMesh.addKey(lst, string2)) {
                    return false;
                }
                if (lst2.size() <= 0) continue;
                int n3 = lst2.size();
                for (int i = 0; i < n3; ++i) {
                    lst.addLast(lst2.get(i));
                }
                lst2.clear();
                continue;
            }
            lst2.addLast(Float.valueOf(f));
        }
        return true;
    }

    private static int addItems(int n, T[] tArray, int n2, Lst<Object> lst, Viewer viewer) {
        block6: for (int i = n; i < n2; ++i) {
            T t = tArray[i];
            int n3 = t.tok;
            switch (n3) {
                case 0x10100041: {
                    n = i;
                    i = n2;
                    continue block6;
                }
                case 2: {
                    lst.addLast(Float.valueOf(t.intValue));
                    continue block6;
                }
                case 3: {
                    lst.addLast(t.value);
                    continue block6;
                }
                case 8: 
                case 10: {
                    T3 t3 = n3 == 8 ? (T3)t.value : viewer.ms.getAtomSetCenter((BS)t.value);
                    lst.addLast(Float.valueOf(t3.x));
                    lst.addLast(Float.valueOf(t3.y));
                    lst.addLast(Float.valueOf(t3.z));
                    continue block6;
                }
                default: {
                    if (CGOMesh.addKey(lst, tArray[i].value.toString())) continue block6;
                    Logger.error("CGO unknown: " + tArray[i].value);
                    n = i = n2;
                }
            }
        }
        return n;
    }

    private static boolean addKey(Lst<Object> lst, String string) {
        Integer n = keyMap.get((string = string.toUpperCase()).toUpperCase());
        if (n == null) {
            return false;
        }
        lst.addLast(n);
        return true;
    }

    @Override
    public void clear(String string) {
        super.clear(string);
        this.useColix = false;
    }

    boolean set(Lst<Object> lst) {
        this.width = 200.0f;
        this.diameter = 0;
        this.useColix = true;
        this.bsTemp = new BS();
        try {
            if (lst.get(0) instanceof Number) {
                this.cmds = lst;
            } else {
                this.cmds = (Lst)lst.get(1);
                if (this.cmds == null) {
                    this.cmds = (Lst)lst.get(0);
                }
                this.cmds = (Lst)this.cmds.get(1);
            }
            int n = this.cmds.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n2 = ((Number)this.cmds.get(i)).intValue();
                int n3 = CGOMesh.getSize(n2, bl);
                if (n3 < 0) {
                    Logger.error("CGO unknown type: " + n2);
                    return false;
                }
                switch (n2) {
                    case -102: 
                    case -101: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        return true;
                    }
                    case 5: {
                        this.addNormix(i + 1);
                        break;
                    }
                    case 6: {
                        this.addColix(i + 1);
                        this.useColix = false;
                        break;
                    }
                    case 14: {
                        this.addColix(i + 8);
                        this.addColix(i + 11);
                        break;
                    }
                    case 8: {
                        this.addNormix(i + 10);
                        this.addNormix(i + 13);
                        this.addNormix(i + 16);
                        this.addColix(i + 19);
                        this.addColix(i + 22);
                        this.addColix(i + 25);
                    }
                }
                i += n3;
            }
            return true;
        }
        catch (Exception exception) {
            Logger.error("CGOMesh error: " + exception);
            this.cmds = null;
            return false;
        }
    }

    private void addColix(int n) {
        this.getPoint(n, this.vTemp);
        this.cList.addLast(C.getColix(CU.colorPtToFFRGB(this.vTemp)));
    }

    private void addNormix(int n) {
        this.getPoint(n, this.vTemp);
        this.nList.addLast(Normix.get2SidedNormix(this.vTemp, this.bsTemp));
    }

    public void getPoint(int n, T3 t3) {
        t3.set(this.getFloat(n++), this.getFloat(n++), this.getFloat(n));
    }

    public int getInt(int n) {
        return ((Number)this.cmds.get(n)).intValue();
    }

    public float getFloat(int n) {
        return ((Number)this.cmds.get(n)).floatValue();
    }
}

