/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.render.MeshRenderer;
import org.jmol.renderbio.TraceRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

abstract class BioShapeRenderer
extends MeshRenderer {
    private boolean invalidateMesh;
    private boolean invalidateSheets;
    private boolean isHighRes;
    private boolean isTraceAlpha;
    private boolean ribbonBorder = false;
    private boolean haveControlPointScreens;
    private float aspectRatio;
    private int hermiteLevel;
    private float sheetSmoothing;
    protected boolean cartoonsFancy;
    private Mesh[] meshes;
    private boolean[] meshReady;
    private BS bsRenderMesh;
    protected int monomerCount;
    protected Monomer[] monomers;
    protected boolean isNucleic;
    protected boolean isCarbohydrate;
    protected BS bsVisible = new BS();
    protected P3[] ribbonTopScreens;
    protected P3[] ribbonBottomScreens;
    protected P3[] controlPoints;
    protected P3[] controlPointScreens;
    protected int[] leadAtomIndices;
    protected V3[] wingVectors;
    protected short[] mads;
    protected short[] colixes;
    protected short[] colixesBack;
    protected STR[] structureTypes;
    protected boolean wireframeOnly;
    private final P3 pointT = new P3();
    private int iPrev;
    private int iNext;
    private int iNext2;
    private int iNext3;
    private int diameterBeg;
    private int diameterMid;
    private int diameterEnd;
    private boolean doCap0;
    private boolean doCap1;
    protected short colixBack;
    private BS reversed;
    private final P3 screenArrowTop = new P3();
    private final P3 screenArrowTopPrev = new P3();
    private final P3 screenArrowBot = new P3();
    private final P3 screenArrowBotPrev = new P3();
    private static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    private static final int MIN_MESH_RENDER_SIZE = 8;
    private P3[] controlHermites;
    private V3[] wingHermites;
    private P3[] radiusHermites;
    private V3 norm = new V3();
    private final V3 wing = new V3();
    private final V3 wing1 = new V3();
    private final V3 wingT = new V3();
    private final A4 aa = new A4();
    private final P3 pt = new P3();
    private final P3 pt1 = new P3();
    private final P3 ptPrev = new P3();
    private final P3 ptNext = new P3();
    private final M3 mat = new M3();
    private static final int MODE_TUBE = 0;
    private static final int MODE_FLAT = 1;
    private static final int MODE_ELLIPTICAL = 2;
    private static final int MODE_NONELLIPTICAL = 3;
    private BS bsTemp;
    private final V3 norml = new V3();

    BioShapeRenderer() {
    }

    protected abstract void renderBioShape(BioShape var1);

    @Override
    protected boolean render() {
        if (this.shape == null) {
            return false;
        }
        this.setGlobals();
        this.renderShapes();
        return this.needTranslucent;
    }

    private void setGlobals() {
        int n;
        boolean bl;
        this.invalidateMesh = false;
        this.needTranslucent = false;
        this.isPrecision = true;
        this.g3d.addRenderer(553648147);
        boolean bl2 = bl = !this.isExport && !this.vwr.checkMotionRendering(1113200642);
        if (bl != this.wireframeOnly) {
            this.invalidateMesh = true;
        }
        this.wireframeOnly = bl;
        boolean bl3 = bl = this.isExport || !this.wireframeOnly && this.vwr.getBoolean(603979864);
        if (bl != this.isHighRes) {
            this.invalidateMesh = true;
        }
        this.isHighRes = bl;
        boolean bl4 = bl = !this.wireframeOnly && (this.vwr.getBoolean(603979817) || this.isExport);
        if (this.cartoonsFancy != bl) {
            this.invalidateMesh = true;
            this.cartoonsFancy = bl;
        }
        int n2 = (n = this.vwr.getHermiteLevel()) <= 0 ? -n : (n = this.vwr.getInMotion(true) ? 0 : n);
        if (this.cartoonsFancy && !this.wireframeOnly) {
            n = Math.max(n, 3);
        }
        if (n != this.hermiteLevel) {
            this.invalidateMesh = true;
        }
        this.hermiteLevel = Math.min(n, 8);
        int n3 = this.vwr.getInt(553648166);
        n3 = Math.min(Math.max(0, n3), 20);
        if (this.cartoonsFancy && n3 >= 16) {
            n3 = 4;
        }
        if (this.wireframeOnly || this.hermiteLevel == 0) {
            n3 = 0;
        }
        if ((float)n3 != this.aspectRatio && n3 != 0 && n != 0) {
            this.invalidateMesh = true;
        }
        this.aspectRatio = n3;
        bl = this.vwr.getBoolean(603979966);
        if (bl != this.isTraceAlpha) {
            this.invalidateMesh = true;
        }
        this.isTraceAlpha = bl;
        this.invalidateSheets = false;
        float f = this.vwr.getFloat(0x22000030);
        if (f != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = f;
            this.invalidateMesh = true;
            this.invalidateSheets = true;
        }
    }

    private void renderShapes() {
        BioShapeCollection bioShapeCollection = (BioShapeCollection)this.shape;
        int n = bioShapeCollection.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = bioShapeCollection.getBioShape(n);
            if ((bioShape.modelVisibilityFlags & this.myVisibilityFlag) == 0 || bioShape.monomerCount < 2 || !this.initializePolymer(bioShape)) continue;
            this.bsRenderMesh.clearAll();
            this.renderBioShape(bioShape);
            this.renderMeshes();
            this.freeTempArrays();
        }
    }

    protected boolean setBioColix(short s) {
        if (this.g3d.setC(s)) {
            return true;
        }
        this.needTranslucent = true;
        return false;
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.vwr.freeTempPoints(this.controlPointScreens);
        }
        this.vwr.freeTempEnum(this.structureTypes);
    }

    private boolean initializePolymer(BioShape bioShape) {
        BS bS = this.vwr.slm.bsDeleted;
        this.controlPoints = this.vwr.ms.isJmolDataFrameForModel(bioShape.modelIndex) ? bioShape.bioPolymer.getControlPoints(true, 0.0f, false) : bioShape.bioPolymer.getControlPoints(this.isTraceAlpha, this.sheetSmoothing, this.invalidateSheets);
        this.monomerCount = bioShape.monomerCount;
        this.bsRenderMesh = BS.newN(this.monomerCount);
        this.monomers = bioShape.monomers;
        this.reversed = bioShape.bioPolymer.reversed;
        this.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
        this.bsVisible.clearAll();
        boolean bl = false;
        if (this.invalidateMesh) {
            bioShape.falsifyMesh();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            if ((this.monomers[n].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.ms.isAtomHidden(this.leadAtomIndices[n]) || bS != null && bS.get(this.leadAtomIndices[n])) continue;
            Atom atom = this.ms.at[this.leadAtomIndices[n]];
            if (!this.g3d.isInDisplayRange(atom.sX, atom.sY)) continue;
            this.bsVisible.set(n);
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.ribbonBorder = this.vwr.getBoolean(603979898);
        this.isNucleic = bioShape.bioPolymer instanceof NucleicPolymer;
        this.isCarbohydrate = bioShape.bioPolymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = bioShape.wingVectors;
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
        this.mads = bioShape.mads;
        this.colixes = bioShape.colixes;
        this.colixesBack = bioShape.colixesBack;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.vwr.allocTempEnum(this.monomerCount + 1);
        STR[] sTRArray = this.structureTypes;
        int n = this.monomerCount;
        while (--n >= 0) {
            sTRArray[n] = this.monomers[n].getProteinStructureType();
            if (sTRArray[n] != STR.TURN) continue;
            sTRArray[n] = STR.NONE;
        }
        sTRArray[this.monomerCount] = sTRArray[this.monomerCount - 1];
    }

    protected void calcScreenControlPoints() {
        int n = this.monomerCount + 1;
        this.controlPointScreens = this.vwr.allocTempPoints(n);
        P3[] p3Array = this.controlPointScreens;
        P3[] p3Array2 = this.controlPoints;
        int n2 = n;
        while (--n2 >= 0) {
            this.tm.transformPtScrT3(p3Array2[n2], p3Array[n2]);
        }
        this.haveControlPointScreens = true;
    }

    protected P3[] calcScreens(float f, short[] sArray) {
        int n = this.controlPoints.length;
        P3[] p3Array = this.vwr.allocTempPoints(n);
        if (f == 0.0f) {
            int n2 = n;
            while (--n2 >= 0) {
                this.tm.transformPtScrT3(this.controlPoints[n2], p3Array[n2]);
            }
        } else {
            float f2 = f / 1000.0f;
            int n3 = n;
            while (--n3 >= 0) {
                this.calc1Screen(this.controlPoints[n3], this.wingVectors[n3], sArray[n3] == 0 && n3 > 0 ? sArray[n3 - 1] : sArray[n3], f2, p3Array[n3]);
            }
        }
        return p3Array;
    }

    private void calc1Screen(P3 p3, V3 v3, short s, float f, P3 p32) {
        this.pointT.scaleAdd2((float)s * f, v3, p3);
        this.tm.transformPtScrT3(this.pointT, p32);
    }

    protected short getLeadColix(int n) {
        return C.getColixInherited(this.colixes[n], this.monomers[n].getLeadAtom().colixAtom);
    }

    protected short getLeadColixBack(int n) {
        return this.colixesBack == null || this.colixesBack.length <= n ? (short)0 : this.colixesBack[n];
    }

    private void setNeighbors(int n) {
        this.iPrev = Math.max(n - 1, 0);
        this.iNext = Math.min(n + 1, this.monomerCount);
        this.iNext2 = Math.min(n + 2, this.monomerCount);
        this.iNext3 = Math.min(n + 3, this.monomerCount);
    }

    private boolean setMads(int n, boolean bl) {
        this.madBeg = this.madEnd = this.mads[n];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                if (this.madEnd == 0) {
                    this.madEnd = this instanceof TraceRenderer ? this.madBeg : this.madBeg;
                }
                this.madMid = (short)(this.madBeg + this.madEnd >> 1);
            }
        } else {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iPrev]) {
                this.madBeg = (short)((this.mads[this.iPrev] == 0 ? this.madMid : this.mads[this.iPrev]) + this.madMid >> 1);
            }
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = (short)((this.mads[this.iNext] == 0 ? this.madMid : this.mads[this.iNext]) + this.madMid >> 1);
            }
        }
        this.diameterBeg = (int)this.vwr.tm.scaleToScreen((int)this.controlPointScreens[n].z, this.madBeg);
        this.diameterMid = (int)this.vwr.tm.scaleToScreen(this.monomers[n].getLeadAtom().sZ, this.madMid);
        this.diameterEnd = (int)this.vwr.tm.scaleToScreen((int)this.controlPointScreens[this.iNext].z, this.madEnd);
        this.doCap0 = n == this.iPrev || bl && this.structureTypes[n] != this.structureTypes[this.iPrev];
        this.doCap1 = this.iNext == this.iNext2 || bl && this.structureTypes[n] != this.structureTypes[this.iNext];
        return this.aspectRatio > 0.0f && (this.exportType == 1 || this.checkDiameter(this.diameterBeg) || this.checkDiameter(this.diameterMid) || this.checkDiameter(this.diameterEnd));
    }

    private boolean checkDiameter(int n) {
        return this.isHighRes & n > 3 || n >= 8;
    }

    protected void renderHermiteCylinder(P3[] p3Array, int n) {
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.setNeighbors(n);
        this.g3d.drawHermite4(this.isNucleic ? 4 : 7, p3Array[this.iPrev], p3Array[n], p3Array[this.iNext], p3Array[this.iNext2]);
    }

    protected void renderHermiteConic(int n, boolean bl, int n2) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        if (this.setMads(n, bl) || this.isExport) {
            try {
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.madBeg, this.madMid, this.madEnd, 1.0f, n2))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.bsRenderMesh.set(n);
                return;
            }
            catch (Exception exception) {
                this.bsRenderMesh.clear(n);
                this.meshes[n] = null;
                Logger.error("render mesh error hermiteConic: " + exception.toString());
            }
        }
        if (this.diameterBeg == 0 && this.diameterEnd == 0 || this.wireframeOnly) {
            this.g3d.drawLineAB(this.controlPointScreens[n], this.controlPointScreens[this.iNext]);
        } else {
            this.g3d.fillHermite(this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[n], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
        }
    }

    protected void renderHermiteRibbon(boolean bl, int n, boolean bl2) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.colixBack = this.getLeadColixBack(n);
        if (bl && (this.aspectRatio != 0.0f || this.isExport) && (this.setMads(n, bl2) || this.isExport)) {
            try {
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, this.madBeg, this.madMid, this.madEnd, this.aspectRatio, this.isNucleic ? 4 : 7))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.meshes[n].setColixBack(this.colixBack);
                this.bsRenderMesh.set(n);
                return;
            }
            catch (Exception exception) {
                this.bsRenderMesh.clear(n);
                this.meshes[n] = null;
                Logger.error("render mesh error hermiteRibbon: " + exception.toString());
            }
        }
        this.g3d.drawHermite7(bl, this.ribbonBorder, (this.reversed.get(n) ? -1 : 1) * (this.isNucleic ? 4 : 7), this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[n], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[n], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], (int)this.aspectRatio, this.colixBack);
    }

    protected void renderHermiteArrowHead(int n) {
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.colixBack = this.getLeadColixBack(n);
        this.setNeighbors(n);
        if (this.setMads(n, false) || this.isExport) {
            try {
                this.doCap0 = true;
                this.doCap1 = false;
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMesh(n, (int)Math.floor((double)this.madBeg * 1.2), (int)Math.floor((double)this.madBeg * 0.6), 0, this.aspectRatio == 1.0f ? this.aspectRatio : this.aspectRatio / 2.0f, 7))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.bsRenderMesh.set(n);
                return;
            }
            catch (Exception exception) {
                this.bsRenderMesh.clear(n);
                this.meshes[n] = null;
                Logger.error("render mesh error hermiteArrowHead: " + exception.toString());
            }
        }
        P3 p3 = this.controlPoints[n];
        V3 v3 = this.wingVectors[n];
        this.calc1Screen(p3, v3, this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(p3, v3, this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(p3, v3, this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(p3, v3, this.madBeg, -0.001f, this.screenArrowBotPrev);
        this.g3d.drawHermite7(true, this.ribbonBorder, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], (int)this.aspectRatio, this.colixBack);
        this.g3d.setC(this.colix);
        if (this.ribbonBorder && this.aspectRatio == 0.0f) {
            this.g3d.fillCylinderBits((byte)3, 3, this.screenArrowTop, this.screenArrowBot);
        }
    }

    private boolean createMesh(int n, int n2, int n3, int n4, float f, int n5) {
        int n6;
        boolean bl;
        this.setNeighbors(n);
        if (this.controlPoints[n].distanceSquared(this.controlPoints[this.iNext]) == 0.0f) {
            return false;
        }
        boolean bl2 = f != 1.0f && this.wingVectors != null;
        boolean bl3 = f == 0.0f;
        boolean bl4 = this.cartoonsFancy || this.hermiteLevel >= 6;
        int n7 = (this.hermiteLevel + 1) * 2 + 1;
        int n8 = bl3 ? 4 : (this.hermiteLevel + 1) * 4 - 2;
        float f2 = (float)(bl3 ? Math.PI / (double)(n8 - 1) : Math.PI * 2 / (double)n8);
        Mesh mesh = this.meshes[n] = new Mesh().mesh1(this.vwr, "mesh_" + this.shapeID + "_" + n, (short)0, n);
        boolean bl5 = bl = n2 != n3 || n3 != n4;
        if (this.controlHermites == null || this.controlHermites.length < n7 + 1) {
            this.controlHermites = new P3[n7 + 1];
        }
        GData.getHermiteList(n5, this.controlPoints[this.iPrev], this.controlPoints[n], this.controlPoints[this.iNext], this.controlPoints[this.iNext2], this.controlPoints[this.iNext3], this.controlHermites, 0, n7, true);
        if (this.wingHermites == null || this.wingHermites.length < n7 + 1) {
            this.wingHermites = new V3[n7 + 1];
        }
        this.wing.setT(this.wingVectors[this.iPrev]);
        if (n4 == 0) {
            this.wing.scale(2.0f);
        }
        GData.getHermiteList(n5, this.wing, this.wingVectors[n], this.wingVectors[this.iNext], this.wingVectors[this.iNext2], this.wingVectors[this.iNext3], this.wingHermites, 0, n7, false);
        float f3 = (float)n2 / 2000.0f;
        float f4 = (float)n3 / 2000.0f;
        float f5 = (float)n4 / 2000.0f;
        if (bl) {
            if (this.radiusHermites == null || this.radiusHermites.length < (n7 + 1 >> 1) + 1) {
                this.radiusHermites = new P3[(n7 + 1 >> 1) + 1];
            }
            this.ptPrev.set(f3, f3, 0.0f);
            this.pt.set(f3, f4, 0.0f);
            this.pt1.set(f4, f5, 0.0f);
            this.ptNext.set(f5, f5, 0.0f);
            GData.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, 0, n7 + 1 >> 1, true);
        }
        int n9 = 0;
        int n10 = n7 >> 1;
        int n11 = (n8 + 2) / 4;
        int n12 = (3 * n8 + 2) / 4;
        int n13 = !bl2 ? 0 : (bl3 ? 1 : (bl4 ? 2 : 3));
        boolean bl6 = n13 == 0 || n13 == 3;
        for (n6 = 0; n6 < n7; ++n6) {
            this.norm.sub2(this.controlHermites[n6 + 1], this.controlHermites[n6]);
            float f6 = !bl ? f3 : (n6 < n10 ? this.radiusHermites[n6].x : this.radiusHermites[n6 - n10].y);
            this.wing.setT(this.wingHermites[n6]);
            this.wing1.setT(this.wing);
            switch (n13) {
                case 1: {
                    break;
                }
                case 2: {
                    this.wing1.cross(this.norm, this.wing);
                    this.wing1.normalize();
                    this.wing1.scale(this.wing.length() / f);
                    break;
                }
                case 3: {
                    this.wing.scale(2.0f / f);
                    this.wing1.sub(this.wing);
                    break;
                }
                case 0: {
                    this.wing.cross(this.wing, this.norm);
                    this.wing.normalize();
                }
            }
            this.wing.scale(f6);
            this.wing1.scale(f6);
            if (bl6) {
                this.aa.setVA(this.norm, f2);
                this.mat.setAA(this.aa);
            }
            this.pt1.setT(this.controlHermites[n6]);
            float f7 = bl3 ? 0.0f : f2;
            int n14 = 0;
            while (n14 < n8) {
                if (bl6 && n14 > 0) {
                    this.mat.rotate(this.wing);
                }
                switch (n13) {
                    case 1: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.cos(f7));
                        break;
                    }
                    case 2: {
                        this.wingT.setT(this.wing1);
                        this.wingT.scale((float)Math.sin(f7));
                        this.wingT.scaleAdd2((float)Math.cos(f7), this.wing, this.wingT);
                        break;
                    }
                    case 3: {
                        this.wingT.setT(this.wing);
                        if (n14 == n11 || n14 == n12) {
                            this.wing1.scale(-1.0f);
                        }
                        this.wingT.add(this.wing1);
                        break;
                    }
                    case 0: {
                        this.wingT.setT(this.wing);
                    }
                }
                this.pt.add2(this.pt1, this.wingT);
                mesh.addV(this.pt, true);
                ++n14;
                f7 += f2;
            }
            if (n6 > 0) {
                n14 = bl3 ? n8 - 1 : n8;
                for (int i = 0; i < n14; ++i) {
                    int n15 = n9 - n8 + i;
                    int n16 = n9 - n8 + (i + 1) % n8;
                    int n17 = n9 + (i + 1) % n8;
                    int n18 = n9 + i;
                    if (i < n14 / 2) {
                        mesh.addQuad(n15, n16, n17, n18);
                        continue;
                    }
                    mesh.addQuad(n16, n17, n18, n15);
                }
            }
            n9 += n8;
        }
        if (!bl3) {
            n6 = n9;
            if (this.doCap0) {
                int n19;
                for (n19 = 0; n19 < n8; ++n19) {
                    mesh.addV(mesh.vs[n19], true);
                }
                n9 += n8;
                n19 = this.hermiteLevel * 2;
                while (--n19 >= 0) {
                    mesh.addQuad(n9 - n8 + n19 + 2, n9 - n8 + n19 + 1, n9 - n8 + (n8 - n19) % n8, n9 - n19 - 1);
                }
            }
            if (this.doCap1) {
                int n20;
                for (n20 = 0; n20 < n8; ++n20) {
                    mesh.addV(mesh.vs[n6 - n8 + n20], true);
                }
                n9 += n8;
                n20 = this.hermiteLevel * 2;
                while (--n20 >= 0) {
                    mesh.addQuad(n9 - n20 - 1, n9 - n8 + (n8 - n20) % n8, n9 - n8 + n20 + 1, n9 - n8 + n20 + 2);
                }
            }
        }
        this.meshReady[n] = true;
        this.adjustCartoonSeamNormals(n, n8);
        mesh.setVisibilityFlags(1);
        return true;
    }

    void adjustCartoonSeamNormals(int n, int n2) {
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (n == this.iNext - 1 && this.iNext < this.monomerCount && this.monomers[n].getStrucNo() == this.monomers[this.iNext].getStrucNo() && this.meshReady[n] && this.meshReady[this.iNext]) {
            try {
                V3[] v3Array = this.meshes[this.iNext].getNormalsTemp();
                V3[] v3Array2 = this.meshes[n].getNormalsTemp();
                int n3 = v3Array2.length;
                if (this.doCap0) {
                    n3 -= n2;
                }
                for (int i = 1; i <= n2; ++i) {
                    this.norml.add2(v3Array2[n3 - i], v3Array[n2 - i]);
                    this.norml.normalize();
                    this.meshes[n].normalsTemp[n3 - i].setT(this.norml);
                    this.meshes[this.iNext].normalsTemp[n2 - i].setT(this.norml);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void renderMeshes() {
        int n = this.bsRenderMesh.nextSetBit(0);
        while (n >= 0) {
            if (this.meshes[n].normalsTemp != null) {
                this.meshes[n].setNormixes(this.meshes[n].normalsTemp);
                this.meshes[n].normalsTemp = null;
            } else if (this.meshes[n].normixes == null) {
                this.meshes[n].initialize(1073741958, null, null);
            }
            this.renderMesh2(this.meshes[n]);
            n = this.bsRenderMesh.nextSetBit(n + 1);
        }
    }
}

