/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class CubeReader
extends AtomSetCollectionReader {
    private int ac;
    private boolean isAngstroms = false;

    @Override
    public void initializeReader() throws Exception {
        this.asc.newAtomSet();
        this.readTitleLines();
        this.readAtomCountAndOrigin();
        this.readLines(3);
        this.readAtoms();
        this.applySymmetryAndSetTrajectory();
        this.continuing = false;
    }

    private void readTitleLines() throws Exception {
        if (this.rd().indexOf("#JVXL") == 0) {
            while (this.rd().indexOf("#") == 0) {
            }
        }
        this.checkCurrentLineForScript();
        String string = this.line.trim();
        this.rd();
        this.checkCurrentLineForScript();
        this.asc.setAtomSetName(string + " - " + this.line.trim());
    }

    private void readAtomCountAndOrigin() throws Exception {
        this.rd();
        this.isAngstroms = this.line.indexOf("ANGSTROMS") >= 0;
        String[] stringArray = this.getTokens();
        if (stringArray[0].charAt(0) == '+') {
            stringArray[0] = stringArray[0].substring(1);
        }
        this.ac = Math.abs(this.parseIntStr(stringArray[0]));
    }

    private void readAtoms() throws Exception {
        float f = this.isAngstroms ? 1.0f : 0.5291772f;
        for (int i = 0; i < this.ac; ++i) {
            String[] stringArray = PT.getTokens(this.rd());
            this.setAtomCoordScaled(null, (String[])stringArray, (int)2, (float)f).elementNumber = (short)this.parseIntStr(stringArray[0]);
        }
    }
}

