/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.api.GenericLineReader;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.Resolver;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class AnnotationParser
implements JmolAnnotationParser {
    private GenericLineReader reader;
    private String line;
    private Map<String, Object> dssr;
    private Map<String, Object> htTemp;
    private SB message;
    private Map<String, String[]> htPar;
    private Lst<Map<String, Object>> basePairs;
    private int[] next = new int[1];
    private static Map<String, String> pdbAtomForH;

    @Override
    public String processDSSR(Map<String, Object> map, GenericLineReader genericLineReader, String string, Map<String, String> map2) throws Exception {
        this.dssr = new Hashtable<String, Object>();
        map.put("dssr", this.dssr);
        this.htTemp = new Hashtable<String, Object>();
        this.htPar = new Hashtable<String, String[]>();
        this.htPar.put("bp", new String[]{"bpShear", "bpStretch", "bpStagger", "bpPropeller", "bpBuckle", "bpOpening"});
        this.htPar.put("bpChiLambda", new String[]{"bpChi1", "bpLambda1", "bpChi2", "bpLambda2"});
        this.htPar.put("bpDistTor", new String[]{"bpDistC1C1", "bpDistNN", "bpDistC6C8", "bpTorCNNC"});
        this.htPar.put("step", new String[]{"stShift", "stSlide", "stRise", "stTilt", "stRoll", "stTwist"});
        this.htPar.put("hel", new String[]{"heXDisp", "heYDisp", "heRise", "heIncl", "heTip", "heTwist"});
        this.reader = genericLineReader;
        this.message = new SB();
        this.line = string == null ? "" : string.trim();
        this.skipTo("DSSR:", false);
        this.addToMessages(null);
        boolean bl = false;
        block16: while (this.rd() != null) {
            if (this.line.startsWith("List of")) {
                int n = PT.parseInt(this.line.substring(8));
                if (n < 0 || this.line.endsWith("files")) continue;
                if (this.line.indexOf("lone WC") >= 0) {
                    this.line = PT.rep(this.line, "lone WC", "isolated WC");
                }
                this.addMessage(this.line);
                this.line = PT.rep(PT.trim(this.line, "s"), " interaction", "");
                int n2 = "pair elix lice plet stem tack loop ulge tion ment otif pper turn bond file".indexOf(this.line.trim().substring(this.line.length() - 4));
                switch (n2) {
                    case 0: {
                        this.readPairs(n);
                        continue block16;
                    }
                    case 5: 
                    case 10: {
                        this.getHelixOrStem(n, "helices", "helix", true);
                        continue block16;
                    }
                    case 15: {
                        this.readNTList(null, "multiplets", n);
                        continue block16;
                    }
                    case 20: {
                        this.getHelixOrStem(n, "stems", "stem", false);
                        continue block16;
                    }
                    case 25: {
                        this.readStacks(n);
                        continue block16;
                    }
                    case 30: {
                        this.readLoops(n);
                        continue block16;
                    }
                    case 35: {
                        this.readBulges(n);
                        continue block16;
                    }
                    case 40: {
                        this.readJunctions(n);
                        continue block16;
                    }
                    case 45: {
                        this.readNTList(null, "singleStranded", n);
                        continue block16;
                    }
                    case 50: {
                        this.readMotifs(n);
                        continue block16;
                    }
                    case 55: {
                        this.readNTList(null, "riboseZippers", n);
                        continue block16;
                    }
                    case 60: {
                        this.readTurns(n);
                        continue block16;
                    }
                    case 65: {
                        this.readHBonds(n);
                        continue block16;
                    }
                    case 70: {
                        continue block16;
                    }
                }
                this.addMessage("DSSRParser ignored: " + this.line);
                continue;
            }
            if (!bl && this.line.startsWith("Date and time")) {
                bl = true;
                this.addToMessages("");
                continue;
            }
            if (this.line.startsWith("Secondary structures in dot-bracket")) {
                this.readStructure();
                continue;
            }
            if (!this.line.startsWith("Mapping of")) continue;
            this.mapGroups(map2);
        }
        this.dssr.put("summary", this.message.toString());
        return this.message.toString();
    }

    private void mapGroups(Map<String, String> map) throws Exception {
        this.rd();
        int n = 0;
        String string = "";
        if (NucleicPolymer.htGroup1 == null) {
            NucleicPolymer.htGroup1 = new Hashtable<String, String>();
        }
        while (this.rd() != null && this.line.length() > 21) {
            String string2 = this.line.substring(9, 12).trim();
            String string3 = this.line.substring(21, 22);
            if ("ACGTU".indexOf(string3) >= 0) continue;
            NucleicPolymer.htGroup1.put(string2, string3);
            String string4 = " " + string2 + "(" + string3 + ")";
            if (string.indexOf(string4) < 0) {
                ++n;
                string = string + string4;
            }
            if (map == null) continue;
            map.put(string2, string3);
        }
        if (n > 0) {
            this.addMessage(n + " nonstandard base" + (n > 1 ? "s" : "") + ":" + string);
        }
    }

    private void readStructure() throws Exception {
        this.addMessage("");
        this.addMessage(this.line);
        this.addMessage(this.rd());
        this.dssr.put("seq", this.rd());
        this.addMessage(this.line);
        this.dssr.put("dbn", this.rd());
        this.addToMessages(this.line);
        this.addMessage("");
    }

    private void readHBonds(int n) throws Exception {
        Lst<Map<String, Object>> lst = this.newList("hBonds");
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = PT.getTokens(this.rd());
            hashtable.put("atno1", PT.parseInt(stringArray[0]));
            hashtable.put("atno2", PT.parseInt(stringArray[1]));
            hashtable.put("id", stringArray[2]);
            hashtable.put("hbType", stringArray[3]);
            hashtable.put("distAng", Float.valueOf(stringArray[4]));
            int n2 = stringArray.length > 8 ? 6 : 5;
            hashtable.put("energy", Float.valueOf(n2 == 6 ? stringArray[5] : "0"));
            hashtable.put("label", stringArray[n2++]);
            hashtable.put("atom1", this.fix(stringArray[n2++], true));
            hashtable.put("atom2", this.fix(stringArray[n2++], true));
            if (n2 < stringArray.length) {
                hashtable.put("primary", stringArray[n2++].equals("primary"));
            }
            lst.addLast((Map<String, Object>)hashtable);
        }
    }

    private void addToMessages(String string) throws Exception {
        if (string != null) {
            this.addMessage(string);
        }
        while (this.line != null && this.line.length() > 0 && this.line.indexOf("****") < 0) {
            this.addMessage(string == null ? this.line.trim() : this.line);
            this.rd();
        }
    }

    private void addMessage(String string) {
        this.message.append(string).append("\n");
    }

    private Lst<Map<String, Object>> newList(String string) {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        if (string != null) {
            this.dssr.put(string, lst);
        }
        return lst;
    }

    private void readStacks(int n) throws Exception {
        Lst<Map<String, Object>> lst = this.newList("coaxialStacks");
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = PT.getTokens(this.rd());
            hashtable.put("helix", stringArray[1]);
            hashtable.put("stemCount", Integer.valueOf(stringArray[3]));
            hashtable.put("stems", stringArray[5]);
            hashtable.put("basePairs", this.getLinkNTList(stringArray[5], "stem", null));
            lst.addLast((Map<String, Object>)hashtable);
        }
    }

    private Lst<String> readInfo(String string, int n) throws Exception {
        Lst<String> lst = new Lst<String>();
        if (string != null) {
            this.dssr.put(string, lst);
        }
        for (int i = 0; i < n; ++i) {
            lst.addLast(this.rd());
        }
        return lst;
    }

    private void readLoops(int n) throws Exception {
        if (this.line.indexOf("internal") >= 0) {
            this.readSets("internalLoops", n, 2, 4);
        } else if (this.line.indexOf("hairpin") >= 0) {
            this.readSets("hairpinLoops", n, 1, 3);
        } else if (this.line.indexOf("kissing") >= 0) {
            this.readSets("kissingLoops", n, -1, -1);
        }
    }

    private void readJunctions(int n) throws Exception {
        this.readSets("junctions", n, 0, 3);
    }

    private void readBulges(int n) throws Exception {
        this.readSets("bulges", n, 2, 2);
    }

    private void readSets(String string, int n, int n2, int n3) throws Exception {
        Lst<Map<String, Object>> lst = this.newList(string);
        boolean bl = n2 == 0;
        boolean bl2 = n3 == -1;
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = PT.getTokens(this.rd());
            hashtable.put("id", stringArray[0]);
            this.htTemp.put(string + stringArray[0], hashtable);
            Lst<Object> lst2 = new Lst<Object>();
            hashtable.put("desc", this.line);
            if (bl2) {
                this.getNTs(this.getLinkNTList(stringArray[2], "stem", null), lst2, true, false);
                this.getNTs(this.getLinkNTList(stringArray[6], "hairpinLoops", null), lst2, false, false);
                this.getNTs(this.getLinkNTList(stringArray[8], "hairpinLoops", null), lst2, false, false);
                hashtable.put("nts", lst2);
                lst2 = new Lst();
                this.getNTs(this.getLinkNTList(stringArray[2], "stem", null), lst2, true, true);
                this.getNTs(this.getLinkNTList(stringArray[6], "hairpinLoops", null), lst2, false, true);
                this.getNTs(this.getLinkNTList(stringArray[8], "hairpinLoops", null), lst2, false, true);
                hashtable.put("resnos", lst2);
            } else {
                hashtable.put("dssrType", stringArray[1]);
                if (bl) {
                    n2 = PT.parseInt(stringArray[1].substring(0, stringArray[1].indexOf("-")));
                }
                hashtable.put("nway", n2);
                hashtable.put("n", Integer.valueOf(PT.trim(stringArray[n3], ";").substring(4)));
                hashtable.put("linkedBy", this.getLinkNTList(stringArray[n3 + 4], "stem", lst2));
                hashtable.put("basePairs", this.readNTList(string + "#" + (i + 1), null, n2 + 1));
            }
            lst.addLast((Map<String, Object>)hashtable);
        }
    }

    private void getNTs(Lst<Object> lst, Lst<Object> lst2, boolean bl, boolean bl2) {
        Lst lst3 = (Lst)lst.get(0);
        int n = lst3.size();
        String string = !bl2 ? "nt" : (bl ? "res" : "resno");
        Lst lst4 = bl ? new Lst() : null;
        for (int i = 0; i < n; ++i) {
            Map map = (Map)lst3.get(i);
            if (bl) {
                lst4.addLast(map.get(string + "1"));
                lst4.addLast(map.get(string + "2"));
                continue;
            }
            lst2.addLast(map.get(string + "s"));
        }
        if (bl) {
            lst2.addLast(lst4);
        }
    }

    private Lst<Object> getLinkNTList(String string, String string2, Lst<Object> lst) {
        if (lst == null) {
            lst = new Lst();
        }
        String[] stringArray = PT.getTokens(PT.replaceAllCharacters(string, "[,]", " "));
        for (int i = 0; i < stringArray.length; ++i) {
            lst.addLast(this.htTemp.get((stringArray[i].startsWith("-") ? "" : string2) + stringArray[i]));
        }
        return lst;
    }

    private void readMotifs(int n) throws Exception {
        Lst<Map<String, Object>> lst = this.newList("aMinorMotifs");
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = PT.getTokens(this.rd());
            hashtable.put("motiftype", this.after(stringArray[1], "=") + " " + stringArray[2]);
            hashtable.put("info", this.line);
            hashtable.put("data", this.readInfo(null, 2));
            lst.addLast((Map<String, Object>)hashtable);
        }
    }

    private void readTurns(int n) throws Exception {
        Lst<Map<String, Object>> lst = this.newList("kinkTurns");
        for (int i = 0; i < n; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String[] stringArray = PT.getTokens(this.rd());
            hashtable.put("turnType", stringArray[1]);
            hashtable.put("info", this.line);
            hashtable.put("details", this.rd());
            hashtable.put("basePairs", this.readNTList(null, null, 2));
            lst.addLast((Map<String, Object>)hashtable);
        }
    }

    private void readPairs(int n) throws Exception {
        if (this.line.indexOf("lone ") >= 0 || this.line.indexOf("isolated ") >= 0) {
            this.rd();
            this.skipHeader();
            Lst<Map<String, Object>> lst = this.newList("isolatedPairs");
            for (int i = 0; i < n; ++i) {
                String[] stringArray = PT.getTokens(this.line);
                Map map = (Map)this.htTemp.get(stringArray[1] + stringArray[2]);
                this.htTemp.put("#" + this.line.substring(0, 5).trim(), map);
                map.put("isolatedPair", Boolean.TRUE);
                lst.addLast(map);
                this.rd();
            }
            return;
        }
        this.basePairs = this.newList("basePairs");
        this.skipHeader();
        for (int i = 0; i < n; ++i) {
            this.getBPData(0, null, true);
        }
    }

    private Map<String, Object> getBPData(int n, String string, boolean bl) throws Exception {
        String[] stringArray = PT.getTokens(this.line);
        String string2 = stringArray[1] + stringArray[2];
        Hashtable<String, Object> hashtable = (Hashtable<String, Object>)this.htTemp.get(string2);
        int n2 = n;
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
            n2 = PT.parseInt(stringArray[0]);
            if (string != null) {
                n2 = -((Integer)((Map)this.htTemp.get(stringArray[2] + stringArray[1])).get("id")).intValue();
            }
            hashtable.put("id", n2);
            String string3 = this.fix(stringArray[1], true);
            String string4 = this.fix(stringArray[2], true);
            hashtable.put("key", string3 + " " + string4);
            hashtable.put("nt1", string3);
            hashtable.put("nt2", string4);
            hashtable.put("nt2", this.fix(stringArray[2], true));
            hashtable.put("res1", this.fix(stringArray[1], false));
            hashtable.put("res2", this.fix(stringArray[2], false));
            String string5 = stringArray[3];
            hashtable.put("bp", string5);
            hashtable.put("g1", string5.substring(0, 1));
            hashtable.put("g2", string5.substring(2, 3));
            int n3 = stringArray.length == 8 ? 5 : 4;
            hashtable.put("name", n3 == 5 ? stringArray[4] : "?");
            int n4 = stringArray[n3].indexOf("-");
            hashtable.put("Saenger", Integer.valueOf(n4 > 0 ? stringArray[n3].substring(0, n4) : "0"));
            hashtable.put("LW", stringArray[++n3]);
            hashtable.put("DSSR", stringArray[++n3]);
            this.htTemp.put(string2, hashtable);
            this.basePairs.addLast((Map<String, Object>)hashtable);
        }
        if (string != null) {
            hashtable.put(string + "Id", n);
        }
        if (bl) {
            this.readMore(hashtable, string == null, n2 < 0);
        } else {
            this.skipHeader();
        }
        return hashtable;
    }

    private void readMore(Map<String, Object> map, boolean bl, boolean bl2) throws Exception {
        String string = "";
        while (this.isHeader(this.rd())) {
            int n = this.line.indexOf("[");
            this.line = PT.rep(this.line, "_pars", "-pars");
            if (bl) {
                if (this.line.indexOf("bp-pars:") >= 0) {
                    this.addArray(map, "bp", PT.parseFloatArray(this.line.substring(n + 1)));
                } else if (this.line.indexOf("lambda") >= 0) {
                    this.extractFloats(map, this.htPar.get("bpChiLambda"));
                } else if (this.line.indexOf("tor(") >= 0) {
                    this.extractFloats(map, this.htPar.get("bpDistTor"));
                }
                string = string + this.line + "\n";
                continue;
            }
            if (bl2 && this.line.indexOf("bp1-pars:") >= 0) {
                this.addArray(map, "bp", PT.parseFloatArray(this.line.substring(n + 1)));
                continue;
            }
            if (this.line.indexOf("heli-pars:") >= 0) {
                this.addArray(map, "hel", PT.parseFloatArray(this.line.substring(n + 1)));
                continue;
            }
            if (this.line.indexOf("step-pars:") >= 0) {
                this.addArray(map, "step", PT.parseFloatArray(this.line.substring(n + 1)));
                continue;
            }
            n = this.line.indexOf("h-rise=");
            if (n >= 0) {
                this.addFloat(map, "heRiseC1", n + 7);
                this.addFloat(map, "heTwistC1", this.line.indexOf("h-twist=") + 8);
                continue;
            }
            n = this.line.indexOf("rise=");
            if (n < 0) continue;
            this.addFloat(map, "stRiseC1", n + 5);
            this.addFloat(map, "stTwistC1", this.line.indexOf("twist=") + 6);
        }
        if (bl) {
            map.put("info", string);
        }
    }

    private void extractFloats(Map<String, Object> map, String[] stringArray) {
        this.line = this.line.replace('[', '=').replace('(', ' ').replace(']', ' ');
        this.next[0] = -1;
        int n = stringArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.next[0] = n2 = this.line.indexOf("=", n2) + 1;
            if (n2 == 0) break;
            map.put(stringArray[i], Float.valueOf(PT.parseFloatNext(this.line, this.next)));
        }
    }

    private void addArray(Map<String, Object> map, String string, float[] fArray) {
        String[] stringArray = this.htPar.get(string);
        int n = Math.min(fArray.length, stringArray == null ? fArray.length : stringArray.length);
        for (int i = 0; i < n; ++i) {
            map.put(stringArray == null ? string + (i + 1) : stringArray[i], Float.valueOf(fArray[i]));
        }
    }

    private void addFloat(Map<String, Object> map, String string, int n) {
        map.put(string, Float.valueOf(PT.parseFloat(this.line.substring(n, Math.min(this.line.length(), n + 10)))));
    }

    private Lst<Map<String, Object>> readNTList(String string, String string2, int n) throws Exception {
        int n2;
        boolean bl = n == 2;
        Lst<Map<String, Object>> lst = this.newList(string2);
        if (string != null) {
            this.htTemp.put(string, lst);
        }
        if (bl) {
            this.rd();
        }
        int n3 = n2 = bl ? 1 : 0;
        while (n2 < n) {
            lst.addLast(this.getNTList());
            ++n2;
        }
        return lst;
    }

    private void getHelixOrStem(int n, String string, String string2, boolean bl) throws Exception {
        Lst<Map<String, Object>> lst = this.newList(string);
        for (int i = 0; i < n; ++i) {
            Object object;
            this.skipTo("  " + string2 + "#", true);
            int n2 = PT.parseInt(this.after(this.line, "="));
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string3 = this.getHeader();
            hashtable.put("info", string3);
            hashtable.put("bpCount", n2);
            if (bl && ((String[])(object = PT.split(string3, "\n"))).length == 8) {
                hashtable.put("helicalAxisData", this.after(object[5], "s"));
                hashtable.put("p1", this.getPoint(object[6]));
                hashtable.put("p2", this.getPoint(object[7]));
            }
            lst.addLast((Map<String, Object>)hashtable);
            object = this.newList(null);
            hashtable.put("basePairs", object);
            this.htTemp.put(string2 + "#" + (i + 1), object);
            for (int j = 0; j < n2; ++j) {
                ((Lst)object).addLast(this.getBPData(i + 1, string2, bl));
            }
        }
    }

    private P3 getPoint(String string) {
        float[] fArray = PT.parseFloatArray(this.after(string, ":"));
        return P3.new3(fArray[0], fArray[1], fArray[2]);
    }

    private Map<String, Object> getNTList() throws Exception {
        int n;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray = PT.getTokens(this.rd());
        int n2 = n = stringArray[0].startsWith("nts") ? 0 : 1;
        if (stringArray.length > n + 2) {
            hashtable.put("nres", Integer.valueOf(PT.replaceAllCharacters(this.after(stringArray[n], "="), "*;", "")));
            hashtable.put("seq", stringArray[++n]);
            hashtable.put("nts", this.getNT(stringArray[++n], false));
            hashtable.put("resnos", this.getNT(stringArray[n], true));
        }
        return hashtable;
    }

    private Object getNT(String string, boolean bl) {
        String[] stringArray = PT.split(string, ",");
        Lst<String> lst = new Lst<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            lst.addLast(this.fix(stringArray[i], !bl));
        }
        return lst;
    }

    private String getHeader() throws Exception {
        SB sB = new SB();
        sB.append(this.line).append("\n");
        while (this.isHeader(this.rd())) {
            sB.append(this.line).append("\n");
        }
        return sB.toString();
    }

    private void skipHeader() throws Exception {
        while (this.isHeader(this.rd())) {
        }
    }

    private boolean isHeader(String string) {
        return string.length() < 6 || string.charAt(3) == ' ' || string.charAt(5) == ' ';
    }

    private void skipTo(String string, boolean bl) throws Exception {
        while (!(!bl ? this.line.contains(string) : this.line.startsWith(string))) {
            this.rd();
        }
    }

    private String fix(String string, boolean bl) {
        char c;
        if (string.startsWith("[")) {
            int n = string.indexOf("/");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (bl) {
                return string;
            }
            n = string.indexOf(".");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return string.substring(string.indexOf("]") + 1);
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        int n2 = string.length();
        while (PT.isDigit(c = string.charAt(--n2))) {
        }
        int n3 = string2.indexOf("@");
        if (n3 >= 0) {
            string2 = string2.substring(n3 + 1) + (bl ? "." + string2.substring(0, n3) : "");
        }
        int n4 = c == '/' ? n2 : n2 + 1;
        return (bl ? "[" + string.substring(n + 1, n4) + "]" : "") + string.substring(n2 + 1) + ":" + string2;
    }

    private String after(String string, String string2) {
        return string.substring(string.indexOf(string2) + 1);
    }

    private String rd() throws Exception {
        this.line = this.reader.readNextLine();
        if (Logger.debugging) {
            Logger.info(this.line);
        }
        return this.line;
    }

    @Override
    public void setAllDSSRParametersForModel(Viewer viewer, int n) {
        Map map;
        int n2;
        Lst lst;
        Map map2 = (Map)viewer.ms.getInfo(n, "dssr");
        Lst lst2 = map2 == null ? null : (Lst)map2.get("basePairs");
        Lst lst3 = lst = map2 == null ? null : (Lst)map2.get("singleStranded");
        if (lst2 == null && lst == null) {
            int n3;
            BioModel bioModel = (BioModel)viewer.ms.am[n];
            int n4 = n3 = bioModel.getBioPolymerCount();
            while (--n4 >= 0) {
                BioPolymer bioPolymer = bioModel.bioPolymers[n4];
                if (!bioPolymer.isNucleic()) continue;
                ((NucleicPolymer)bioPolymer).isDssrSet = true;
            }
            return;
        }
        Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
        BS bS = new BS();
        if (lst2 != null) {
            n2 = lst2.size();
            while (--n2 >= 0) {
                map = (Map)lst2.get(n2);
                BasePair.add(map, this.setDSSRPhos(viewer, 1, map, bS, hashtable), this.setDSSRPhos(viewer, 2, map, bS, hashtable));
            }
        }
        if (lst != null) {
            n2 = lst.size();
            while (--n2 >= 0) {
                map = (Map)lst.get(n2);
                Lst lst4 = (Lst)map.get("resnos");
                int n5 = lst4.size();
                while (--n5 >= 0) {
                    this.setDSSRRes(viewer, (String)lst4.get(n5), bS, hashtable);
                }
            }
        }
    }

    private NucleicMonomer setDSSRPhos(Viewer viewer, int n, Map<String, Object> map, BS bS, Map<String, BS> map2) {
        return this.setDSSRRes(viewer, (String)map.get("res" + n), bS, map2);
    }

    private NucleicMonomer setDSSRRes(Viewer viewer, String string, BS bS, Map<String, BS> map) {
        bS.clearAll();
        this.getDSSRAtoms(viewer, string, null, bS, map);
        NucleicMonomer nucleicMonomer = (NucleicMonomer)viewer.ms.at[bS.nextSetBit((int)0)].group;
        ((NucleicPolymer)nucleicMonomer.bioPolymer).isDssrSet = true;
        return nucleicMonomer;
    }

    @Override
    public String getHBonds(ModelSet modelSet, int n, Lst<Bond> lst, boolean bl) {
        Object object = modelSet.getInfo(n, "dssr");
        if (object != null) {
            object = ((Map)object).get("hBonds");
        }
        if (object == null) {
            return "no DSSR hydrogen-bond data";
        }
        Lst lst2 = (Lst)object;
        int n2 = modelSet.am[n].firstAtomIndex - 1;
        try {
            int n3 = lst2.size();
            while (--n3 >= 0) {
                Map map = (Map)lst2.get(n3);
                int n4 = (Integer)map.get("atno1") + n2;
                int n5 = (Integer)map.get("atno2") + n2;
                float f = map.containsKey("energy") ? ((Float)map.get("energy")).floatValue() : 0.0f;
                lst.addLast(new HBond(modelSet.at[n4], modelSet.at[n5], 2048, 1, 0, f));
            }
        }
        catch (Exception exception) {
            Logger.error("Exception " + exception + " in DSSRParser.getHBonds");
        }
        return "DSSR reports " + lst2.size() + " hydrogen bonds";
    }

    @Override
    public String calculateDSSRStructure(Viewer viewer, BS bS) {
        BS bS2 = viewer.ms.getModelBS(bS == null ? viewer.bsA() : bS, true);
        String string = "";
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            string = string + this.getDSSRForModel(viewer, n);
            n = bS2.nextSetBit(n + 1);
        }
        return string;
    }

    private String getDSSRForModel(Viewer viewer, int n) {
        Map<String, Object> map = null;
        String string = null;
        if (viewer.ms.am[n].isBioModel && !(map = viewer.ms.getModelAuxiliaryInfo(n)).containsKey("dssr")) {
            BS bS = viewer.getModelUndeletedAtomsBitSet(n);
            bS.and(viewer.ms.getAtoms(0x30000E, null));
            if (bS.nextClearBit(0) < 0) {
                map = null;
            } else {
                try {
                    String string2 = (String)viewer.setLoadFormat("=dssrModel/", '=', false);
                    string2 = PT.rep(string2, "%20", " ");
                    Logger.info("fetching " + string2 + "[pdb data]");
                    String string3 = viewer.getPdbAtomData(bS, null, false, false);
                    string3 = viewer.getFileAsString3(string2 + string3, false, null);
                    this.processDSSR(map, new Rdr(Rdr.getBR(string3)), null, null);
                }
                catch (Exception exception) {
                    map = null;
                    string = "" + exception;
                }
            }
        }
        return map != null ? (String)((Map)map.get("dssr")).get("summary") : (string == null ? "model has no nucleotides" : string);
    }

    private void getAnnotationKVPairs(SV sV, String string, String string2, SB sB, String string3, boolean bl, boolean bl2, int n) {
        Map<String, SV> map = sV.getMap();
        if (map == null || map.isEmpty()) {
            return;
        }
        if (map.containsKey("_map")) {
            map = map.get("_map").getMap();
        }
        String string4 = this.getDataKey(n);
        if (bl && map.containsKey(string4)) {
            if (string == null || string2.indexOf(string) >= 0) {
                sB.append(map.get(string4).asString()).append("\n");
            }
            return;
        }
        for (Map.Entry<String, SV> entry : map.entrySet()) {
            String string5 = entry.getKey();
            if (string5.equals(string4)) continue;
            if (string5.equals("metadata")) {
                sB.append("\n");
            }
            SV sV2 = entry.getValue();
            if (sV2.tok == 6) {
                if (n == 1073742189 && !bl) {
                    sB.append(string5).append("\n");
                    continue;
                }
                this.getAnnotationKVPairs(sV2, string, (string2.length() == 0 ? "" : string2 + ".") + string5, sB, (string3.length() == 0 ? "" : string3 + "\t") + string5, bl, bl2, n);
                continue;
            }
            String string6 = sV2.asString();
            if (string != null && string6.indexOf(string) < 0 && string3.indexOf(string) < 0 && string5.indexOf(string) < 0 && string2.indexOf(string) < 0 || bl && bl2) continue;
            if (string3.length() > 0) {
                sB.append(string3).append("\t");
            }
            sB.append(string5).append("=");
            sB.append(string6).append("\n");
        }
    }

    private String getDataKey(int n) {
        switch (n) {
            case 1073741925: {
                return "mappings";
            }
            case 1073742189: {
                return "outliers";
            }
        }
        return null;
    }

    @Override
    public String catalogStructureUnits(Viewer viewer, SV sV, int[] nArray, Map<String, int[]> map, Object object, Map<String, Integer> map2) {
        String string = "Use within(rna3d, TYPE) where TYPE is one of: ";
        Map<String, SV> map3 = sV.getMap();
        if (map3 == null) {
            return null;
        }
        try {
            sV.mapPut("_map", SV.newV(6, map3));
            Lst<SV> lst = new Lst<SV>();
            Set<Map.Entry<String, SV>> set = map3.entrySet();
            for (Map.Entry<String, SV> entry : set) {
                SV sV2 = entry.getValue();
                Lst<SV> lst2 = sV2.getList();
                if (lst2 == null) continue;
                String string2 = entry.getKey();
                string = string + "\"" + string2 + "\" ";
                SV sV3 = SV.newS(string2);
                int n = lst2.size();
                while (--n >= 0) {
                    int n2;
                    Object object2;
                    SV sV4 = (SV)lst2.get(n);
                    Map<String, SV> map4 = sV4.getMap();
                    sV2 = map4.get("units");
                    map4.put("_isres", SV.vT);
                    Lst<SV> lst3 = sV2 == null || sV2.tok == 7 ? sV2.getList() : (sV2.tok == 4 ? new Lst<SV>() : null);
                    if (lst3 == null) continue;
                    if (sV2.tok == 4) {
                        object2 = PT.split(sV2.asString(), ",");
                        n2 = ((String[])object2).length;
                        while (--n2 >= 0) {
                            lst3.addLast(SV.newS(object2[n2].trim()));
                        }
                    }
                    if (lst3.size() <= 0) continue;
                    object2 = new BS();
                    map4.put("_atoms", SV.getVariable(object2));
                    map4.put("_path", sV3);
                    lst.addLast(sV4);
                    n2 = lst3.size();
                    while (--n2 >= 0) {
                        this.catalogUnit(viewer, null, ((SV)lst3.get(n2)).asString(), 0.0f, (BS)object2, nArray, map, null, map2);
                    }
                }
            }
            sV.mapPut("_list", SV.newV(7, lst));
        }
        catch (Exception exception) {
            Logger.info(exception + " while cataloging structures");
            return null;
        }
        return string;
    }

    @Override
    public Lst<Object> catalogValidations(Viewer viewer, SV sV, int[] nArray, Map<String, int[]> map, Map<String, Integer> map2, Map<String, Integer> map3) {
        Map<String, SV> map4 = sV.getMap();
        if (map4 == null) {
            return null;
        }
        Lst<Object> lst = new Lst<Object>();
        int n = nArray.length - 1;
        try {
            map4 = this.getMainItem(map4).getMap();
            sV.mapPut("_map", SV.newV(6, map4));
            Lst<SV> lst2 = new Lst<SV>();
            sV.mapPut("_list", SV.newV(7, lst2));
            Set<Map.Entry<String, SV>> set = map4.entrySet();
            for (Map.Entry<String, SV> entry : set) {
                Map<String, SV> map5;
                float[][] fArray = AU.newFloat2(n);
                int n2 = n;
                while (--n2 >= 0) {
                    fArray[n2] = new float[nArray[n2 + 1] - nArray[n2]];
                }
                SV sV2 = entry.getValue();
                Lst<SV> lst3 = sV2.getList();
                if (lst3 == null && (map5 = sV2.getMap()) != null && (sV2 = map5.get("outliers")) != null) {
                    lst3 = sV2.getList();
                }
                if (lst3 == null) continue;
                boolean bl = false;
                String string = entry.getKey();
                SV sV3 = SV.newS(string);
                boolean bl2 = false;
                int n3 = lst3.size();
                while (--n3 >= 0) {
                    int n4;
                    Object object;
                    float f;
                    SV sV4 = (SV)lst3.get(n3);
                    map5 = sV4.getMap();
                    sV2 = map5.get("units");
                    SV sV5 = map5.get("value");
                    float f2 = f = sV5 == null ? 1.0f : SV.fValue(sV5);
                    Lst<SV> lst4 = f == 0.0f || sV2 == null || sV2.tok == 7 ? sV2.getList() : (sV2.tok == 4 ? new Lst<SV>() : null);
                    if (lst4 == null) continue;
                    if (sV2.tok == 4) {
                        object = PT.split(sV2.asString(), ",");
                        n4 = ((String[])object).length;
                        while (--n4 >= 0) {
                            lst4.addLast(SV.newS(object[n4].trim()));
                        }
                    }
                    if (lst4.size() <= 0) continue;
                    object = new BS();
                    map5.put("_atoms", SV.getVariable(object));
                    map5.put("_path", sV3);
                    bl = true;
                    lst2.addLast(sV4);
                    n4 = lst4.size();
                    while (--n4 >= 0) {
                        boolean bl3 = this.catalogUnit(viewer, fArray, ((SV)lst4.get(n4)).asString(), f, (BS)object, nArray, map, map2, map3);
                        if (bl3) {
                            map5.put("_isres", SV.vT);
                        }
                        bl2 |= bl3;
                    }
                }
                if (!bl) continue;
                n3 = n;
                while (--n3 >= 0) {
                    if (fArray[n3] == null) continue;
                    lst.addLast(string);
                    lst.addLast(fArray[n3]);
                    lst.addLast((Object)n3);
                    lst.addLast((Object)bl2);
                }
            }
            return lst;
        }
        catch (Exception exception) {
            Logger.info(exception + " while cataloging validations");
            return null;
        }
    }

    private SV getMainItem(Map<String, SV> map) {
        for (Map.Entry<String, SV> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string.contains("metadata")) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Lst<SV> initializeAnnotation(SV sV, int n, int n2) {
        Map<String, SV> map = sV.getMap();
        SV sV2 = map.get("_list");
        if (sV2 != null) {
            return sV2.getList();
        }
        String string = this.getDataKey(n);
        SV sV3 = this.getMainItem(map);
        map.put("_map", sV3);
        boolean bl = true;
        Hashtable<String, SV> hashtable = new Hashtable<String, SV>();
        map.put("_cat", SV.newV(6, hashtable));
        Lst<SV> lst = new Lst<SV>();
        sV2 = SV.newV(7, lst);
        map.put("_list", sV2);
        for (Map.Entry<String, SV> entry : sV3.getMap().entrySet()) {
            String string2 = entry.getKey();
            SV sV4 = entry.getValue();
            hashtable.putAll(sV4.getMap());
            for (Map.Entry<String, SV> entry2 : sV4.getMap().entrySet()) {
                String string3 = entry2.getKey();
                SV sV5 = entry2.getValue();
                SV sV6 = sV5.mapGet(string);
                Lst<SV> lst2 = sV6.getList();
                int n3 = lst2.size();
                while (--n3 >= 0) {
                    SV sV7;
                    SV sV8 = (SV)lst2.get(n3);
                    lst.addLast(sV8);
                    Map<String, SV> map2 = sV8.getMap();
                    SV sV9 = map2.get("chain_id");
                    SV sV10 = map2.get("start");
                    SV sV11 = map2.get("end");
                    int n4 = 0;
                    int n5 = 0;
                    String string4 = "modelIndex=" + n2 + "&chain='" + sV9.value + "'";
                    if (sV10 != null && sV11 != null) {
                        n4 = sV10.mapGet((String)"residue_number").intValue;
                        n5 = sV11.mapGet((String)"residue_number").intValue;
                        string4 = string4 + "&seqid>=" + n4 + "&seqid<=" + n5;
                    } else {
                        n5 = 1;
                        string4 = string4 + "&seqid>0";
                    }
                    SV sV12 = sV7 = bl && n4 >= n5 ? SV.getVariable(new BS()) : (SV)hashtable.get(string4);
                    if (sV7 == null) {
                        sV7 = SV.newS(string4);
                        hashtable.put(string4, sV7);
                    }
                    map2.put("_atoms", sV7);
                    map2.put("_path", SV.newS(string2 + "." + string3));
                    map2.put("domain", sV5);
                }
            }
        }
        return lst;
    }

    private void findAnnotationAtoms(Viewer viewer, String string, Lst<SV> lst, String string2, BS bS) {
        if (lst == null) {
            return;
        }
        System.out.println("Checking " + string + " for " + string2);
        Object object = viewer.extractProperty(lst, "[" + string2 + "]", -1);
        Lst<SV> lst2 = null;
        if (object instanceof Lst) {
            lst2 = (Lst<SV>)object;
        } else if (object instanceof SV) {
            lst2 = ((SV)object).getList();
        }
        if (lst2 == null) {
            return;
        }
        int n = lst2.size();
        for (int i = 0; i < n; ++i) {
            Map<String, SV> map;
            Object e = lst2.get(i);
            Map<String, SV> map2 = map = e instanceof SV ? ((SV)e).getMap() : (Map<String, SV>)e;
            if (map == null) {
                return;
            }
            bS.or(this.setAnnotationAtoms(viewer, map, i));
        }
    }

    private BS setAnnotationAtoms(Viewer viewer, Map<String, SV> map, int n) {
        SV sV = map.get("_atoms");
        if (sV.tok != 10) {
            BS bS = viewer.getAtomBitSet(sV.value);
            if (n >= 0) {
                Logger.info("#" + (n + 1) + " found " + bS.cardinality() + " atoms for " + sV.value);
            }
            sV.tok = 10;
            sV.value = bS;
        }
        return (BS)sV.value;
    }

    private boolean catalogUnit(Viewer viewer, float[][] fArray, String string, float f, BS bS, int[] nArray, Map<String, int[]> map, Map<String, Integer> map2, Map<String, Integer> map3) {
        boolean bl;
        Integer n;
        String[] stringArray = PT.split(string + (fArray == null ? "||||" : "|||"), "|");
        if (stringArray.length < 8 || stringArray[1].length() == 0 || stringArray[2].length() == 0 || stringArray[3].length() == 0 || stringArray[4].length() == 0) {
            return false;
        }
        String string2 = stringArray[1].length() == 0 ? "1" : stringArray[1];
        int n2 = map3 == null ? PT.parseInt(string2) - 1 : -1;
        Integer n3 = n = n2 >= 0 ? null : map3.get(string2);
        if (n != null) {
            n2 = n;
        }
        if (n2 >= nArray.length) {
            return false;
        }
        String string3 = stringArray[1] + "_" + viewer.getChainID(stringArray[2], true) + "_" + stringArray[4] + "_" + stringArray[7].toLowerCase();
        int n4 = nArray[n2];
        boolean bl2 = bl = map2 == null || stringArray[5].length() == 0;
        if (bl) {
            int[] nArray2 = map.get(string3);
            if (nArray2 != null) {
                int n5 = nArray2[1];
                int n6 = nArray2[0];
                while (--n5 >= n6) {
                    bS.set(n4 + n5);
                    if (fArray == null) continue;
                    float[] fArray2 = fArray[n2];
                    int n7 = n5;
                    fArray2[n7] = fArray2[n7] + Math.abs(f);
                }
            }
        } else {
            String string4;
            Integer n8;
            if (stringArray[5].charAt(0) == 'H') {
                stringArray[5] = this.getAttachedAtomForPDBH(stringArray[3], stringArray[5]);
            }
            if ((n8 = map2.get(string4 = string3 + "_" + stringArray[5] + "_" + stringArray[6].toLowerCase())) != null) {
                int n9 = n8;
                bS.set(n4 + n9);
                if (fArray != null) {
                    float[] fArray3 = fArray[n2];
                    int n10 = n9;
                    fArray3[n10] = fArray3[n10] + Math.abs(f);
                }
            }
        }
        return bl;
    }

    private String fixKeyDSSR(String string) {
        int n;
        String string2 = string.toLowerCase();
        while ((n = string2.indexOf("lonepair")) >= 0) {
            string = string.substring(0, n) + "isolatedPair" + string.substring(n + 8);
            string2 = string.toLowerCase();
        }
        if (string2.indexOf("pairs") < 0 && string2.indexOf("kissingloops") < 0 && string2.indexOf("linkedby") < 0 && string2.indexOf("multiplets") < 0 && string2.indexOf("singlestrand") < 0) {
            string = string + ".basePairs";
        }
        if (string2.indexOf(".nt") < 0 && string2.indexOf(".res") < 0 && string2.indexOf("[select res") < 0 && string2.indexOf("[select nt") < 0) {
            string = string + ".res*";
        }
        return string;
    }

    private void getDSSRAtoms(Viewer viewer, String string, Lst<?> lst, BS bS, Map<String, BS> map) {
        Object object;
        int n;
        String[] stringArray;
        if (lst == null) {
            stringArray = PT.getTokens(PT.replaceAllCharacters(string.toString(), "=[,]", " "));
        } else {
            if (lst.size() == 0) {
                return;
            }
            stringArray = new String[lst.size()];
            n = lst.size();
            while (--n >= 0) {
                object = lst.get(n);
                if (object instanceof SV) {
                    object = ((SV)object).value;
                }
                if (object instanceof Lst) {
                    this.getDSSRAtoms(viewer, null, (Lst)object, bS, map);
                    continue;
                }
                String string2 = object instanceof SV ? ((SV)object).asString() : object.toString();
                stringArray[n] = string2.startsWith("[") ? string2.substring(string2.indexOf("]") + 1) : string2;
            }
        }
        n = stringArray.length;
        while (--n >= 0) {
            int n2;
            object = stringArray[n];
            if (object == null || (n2 = ((String)object).indexOf(":")) < 0 || n2 + 1 == ((String)object).length()) continue;
            String string3 = ((String)object).substring(n2 + 1);
            BS bS2 = map.get(string3);
            try {
                if (bS2 == null) {
                    bS2 = viewer.ms.getAtoms(0x100021, viewer.getChainID(string3, true));
                    map.put(string3, bS2);
                }
                BS bS3 = viewer.ms.getAtoms(1095763987, Integer.valueOf(((String)object).substring(0, n2)));
                bS3.and(bS2);
                bS.or(bS3);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public BS getAtomBits(Viewer viewer, String string, Object object, Map<String, Object> map, int n, int n2, BS bS) {
        BS bS2;
        boolean bl;
        if (object == null) {
            return new BS();
        }
        boolean bl2 = n == 1073741916;
        boolean bl3 = bl = !string.contains("NOCACHE");
        if (!bl) {
            string = PT.rep(string, "NOCACHE", "").trim();
        }
        if (bl2) {
            string = this.fixKeyDSSR(string);
        }
        BS bS3 = bS2 = bl ? (BS)map.get(string) : null;
        if (bS2 != null) {
            return bS2;
        }
        bS2 = new BS();
        if (bl) {
            map.put(string, bS2);
        }
        try {
            if (bl2) {
                Object object2 = viewer.extractProperty(object, string, -1);
                if (object2 instanceof Lst) {
                    Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
                    this.getDSSRAtoms(viewer, null, (Lst)object2, bS2, hashtable);
                }
                return bS2;
            }
            Lst<SV> lst = this.initializeAnnotation((SV)object, n, n2);
            int n3 = string.toLowerCase().indexOf(" where ");
            String string2 = PT.rep(n3 < 0 ? string : string.substring(0, n3), " ", "");
            String string3 = n3 < 0 ? "" : string.substring(n3 + 7).trim();
            string2 = string2.indexOf(".") < 0 ? " _path like '" + string2 + "*'" : " _path='" + string2 + "'";
            string3 = "select * where " + (n3 < 0 ? string2 : "(" + string3 + ") and (" + string2 + ")");
            Logger.info("looking for " + string3);
            this.findAnnotationAtoms(viewer, string2, lst, string3, bS2);
            bS2.and(bS);
        }
        catch (Exception exception) {
            System.out.println(exception.toString() + " in AnnotationParser");
            bS2.clearAll();
        }
        return bS2;
    }

    @Override
    public Lst<Float> getAtomValidation(Viewer viewer, String string, Atom atom) {
        int n = 0;
        int n2 = 0;
        Lst<Float> lst = null;
        Map<String, SV> map = null;
        Lst<SV> lst2 = null;
        try {
            int n3 = atom.i;
            lst = new Lst<Float>();
            lst2 = ((SV)viewer.ms.getModelAuxiliaryInfo(atom.mi).get("validation")).mapGet("_list").getList();
            n2 = lst2.size();
            for (n = 0; n < n2; ++n) {
                map = ((SV)lst2.get(n)).getMap();
                if (!map.get((Object)"_path").value.equals(string) || !((BS)map.get((Object)"_atoms").value).get(n3)) continue;
                SV sV = map.get("value");
                lst.addLast(sV.tok == 3 ? (Float)sV.value : Float.valueOf(sV.asFloat()));
            }
            return lst;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getAnnotationInfo(Viewer viewer, SV sV, String string, int n, int n2) {
        boolean bl;
        SB sB = new SB();
        if ("".equals(string)) {
            string = null;
        }
        boolean bl2 = bl = string != null && (string.equals("all") || string.endsWith(" all"));
        if (bl) {
            Lst<SV> lst = this.initializeAnnotation(sV, n, n2);
            int n3 = lst.size();
            while (--n3 >= 0) {
                this.setAnnotationAtoms(viewer, ((SV)lst.get(n3)).getMap(), -1);
            }
            string = string.substring(0, Math.max(0, string.length() - 4)).trim();
        }
        if ("".equals(string)) {
            string = null;
        }
        if (n == 1073742189 && !bl && string == null) {
            return sV.mapGet("_note").asString();
        }
        boolean bl3 = string != null && string.indexOf(".") >= 0 && string.indexOf(".*") < 0;
        string = PT.rep(string, "*", "");
        try {
            this.getAnnotationKVPairs(sV, string, "", sB, "", bl, bl3, n);
        }
        catch (Exception exception) {
            System.out.println(exception.getStackTrace());
        }
        return sB.toString();
    }

    public String getAttachedAtomForPDBH(String string, String string2) {
        if (string2.charAt(0) == 'H') {
            String string3;
            if (pdbAtomForH == null) {
                pdbAtomForH = new Hashtable<String, String>();
                this.assignPDBH("", "N H H1 H2 H3 CB HB2 HB3 CD HD2 HD3 CG HG2 HG3 C2' H2'' H2' C5' H5'' H5' OXT HXT");
                int n = Resolver.pdbBondInfo.length;
                while (--n >= 1) {
                    this.assignPDBH(Group.group3Names[n], Resolver.pdbBondInfo[n]);
                }
            }
            if ((string3 = pdbAtomForH.get(string2)) == null) {
                string3 = pdbAtomForH.get(string + string2);
            }
            if (string3 != null) {
                return string3;
            }
        }
        return string2;
    }

    private void assignPDBH(String string, String string2) {
        String[] stringArray = PT.getTokens(PT.rep(string2, "@", " "));
        String string3 = null;
        for (String string4 : stringArray) {
            if (string4.charAt(0) != 'H') {
                string3 = string4;
                continue;
            }
            string4 = string + string4;
            if (string4.indexOf("?") >= 0) {
                string4 = string4.substring(0, string4.length() - 1);
                pdbAtomForH.put(string4 + "1", string3);
                pdbAtomForH.put(string4 + "2", string3);
                pdbAtomForH.put(string4 + "3", string3);
                continue;
            }
            pdbAtomForH.put(string4, string3);
        }
    }

    @Override
    public void fixAtoms(int n, SV sV, BS bS, int n2, int n3) {
        Lst<SV> lst = this.initializeAnnotation(sV, n2, n);
        int n4 = lst.size();
        while (--n4 >= 0) {
            Map<String, SV> map = ((SV)lst.get(n4)).getMap();
            SV sV2 = map.get("_atoms");
            if (sV2 == null || sV2.tok != 10) continue;
            BSUtil.shiftBits((BS)sV2.value, bS, ((SV)lst.get(n4)).mapGet("_isres") != null, ((BS)sV2.value).length() + n3);
        }
    }
}

